BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Carp Data::Dumper Env Exporter File::Copy File::Spec File::Temp FindBin Math::BigInt POSIX base bigint lib overload strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.008001; 1}) {
    print "Perl 5.008001 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.33.
use strict;
use warnings;
use 5.008001;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Perl bindings to the portable FFI library (libffi)",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>, Alessandro Ghedini <alexbio\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "Alien::libt2t"       => 0,
    "ExtUtils::MakeMaker" => 0,
    "FFI::Build::MM"      => "0.83"
  },
  "DISTNAME"         => "FFI-Platypus-Legacy-Raw",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.008001",
  "NAME"             => "FFI::Platypus::Legacy::Raw",
  "PM"               => {
    "lib/FFI/Platypus/Lang/Raw.pm"            => "\$(INST_LIB)/FFI/Platypus/Lang/Raw.pm",
    "lib/FFI/Platypus/Legacy/Raw.pm"          => "\$(INST_LIB)/FFI/Platypus/Legacy/Raw.pm",
    "lib/FFI/Platypus/Legacy/Raw/Callback.pm" => "\$(INST_LIB)/FFI/Platypus/Legacy/Raw/Callback.pm",
    "lib/FFI/Platypus/Legacy/Raw/MemPtr.pm"   => "\$(INST_LIB)/FFI/Platypus/Legacy/Raw/MemPtr.pm",
    "lib/FFI/Platypus/Legacy/Raw/Platypus.pm" => "\$(INST_LIB)/FFI/Platypus/Legacy/Raw/Platypus.pm",
    "lib/FFI/Platypus/Legacy/Raw/Ptr.pm"      => "\$(INST_LIB)/FFI/Platypus/Legacy/Raw/Ptr.pm"
  },
  "PREREQ_PM" => {
    "FFI::Build"    => "0.83",
    "FFI::Platypus" => "0.83",
    "Ref::Util"     => 0
  },
  "TEST_REQUIRES" => {
    "Test2::Tools::FFI" => "0.04",
    "Test2::V0"         => "0.000060"
  },
  "VERSION" => "0.04",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "FFI::Build"        => "0.83",
  "FFI::Platypus"     => "0.83",
  "Ref::Util"         => 0,
  "Test2::Tools::FFI" => "0.04",
  "Test2::V0"         => "0.000060"
);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
use FFI::Build::MM 0.83;
my $fbmm = FFI::Build::MM->new;
%WriteMakefileArgs = $fbmm->mm_args(%WriteMakefileArgs);

# END code inserted by Dist::Zilla::Plugin::FFI::Build

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
BEGIN {
  # append to any existing postamble.
  if ( my $old = MY->can('postamble') )
  {
    no warnings 'redefine';
    *MY::postamble = sub {
      $old->(@_) .
        "\n" .
        $fbmm->mm_postamble;
    };
  }
  else
  {
    *MY::postamble = sub {
      $fbmm->mm_postamble;
    };
  }
}

# END code inserted by Dist::Zilla::Plugin::FFI::Build