# NAME

Mojolicious::Plugin::ViewBuilder - a Mojolicious plugin that allows to chain templates generated by other plugins

# SYNOPSIS

    # Mojolicious
    $self->plugin('ViewBuilder');

    # Mojolicious::Lite
    plugin 'ViewBuilder';

    # In the template where "profile" attached views should be
    <%= pluggable_view 'profile' %>

      # In the plugin, that will attach the new helper to the view
      sub register {
      my ( $self, $app, $conf ) = @_;
          $app->add_view("profile","test");
          $app->helper(
                  test => sub {
                      my $self=shift;
                       return $self->render_to_string("test", some_data=> 1);
                  }
              );
      }
      1;
      __DATA__
      @@ test.html.ep
      huuuray!
      % if( stash("some_data") and stash("some_data")==1){
       double it!
      % }

# DESCRIPTION

[Mojolicious::Plugin::ViewBuilder](https://metacpan.org/pod/Mojolicious::Plugin::ViewBuilder) is a [Mojolicious](https://metacpan.org/pod/Mojolicious) plugin. Chains templates generated by other plugins, associating them within the view. This is useful only if your workflow is to reap into little pieces the webapp (e.g. in plugins)

# METHODS

[Mojolicious::Plugin::ViewBuilder](https://metacpan.org/pod/Mojolicious::Plugin::ViewBuilder) inherits all methods from
[Mojolicious::Plugin](https://metacpan.org/pod/Mojolicious::Plugin) and implements the following new ones.

## pluggable\_view

    <%=pluggable_view "profile" %>

Will render all the attached plugin associated within the view

## add\_view

    $app->add_view("view","helper");

Attach the "helper" within the "view"

# LICENSE

Copyright (C) mudler.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

# AUTHOR

mudler <mudler@dark-lab.net>
