package Chart::Plotly::Trace::Pie;
use Moose;

use Chart::Plotly::Trace::Attribute::Domain;
use Chart::Plotly::Trace::Attribute::Marker;

our $VERSION = '0.008';    # VERSION

sub TO_JSON {
    my $self = shift;
    my %hash = %$self;
    if ( $self->can('type') && ( !defined $hash{'type'} ) ) {
        $hash{type} = $self->type();
    }
    return \%hash;
}

has direction => ( is            => 'rw',
                   documentation => "Specifies the direction at which succeeding sectors follow one another.", );

has dlabel => ( is            => 'rw',
                isa           => "Num",
                documentation => "Sets the label step. See `label0` for more info.",
);

has domain => ( is  => 'rw',
                isa => "Maybe[HashRef]|Chart::Plotly::Trace::Attribute::Domain" );

has hole => ( is            => 'rw',
              isa           => "Num",
              documentation => "Sets the fraction of the radius to cut out of the pie. Use this to make a donut chart.",
);

has hoverinfo => (
    is => 'rw',
    documentation =>
      "Determines which trace information appear on hover. If `none` or `skip` are set, no information is displayed upon hovering. But, if `none` is set, click and hover events are still fired.",
);

has insidetextfont => ( is            => 'rw',
                        documentation => "Sets the font used for `textinfo` lying inside the pie.", );

has label0 => (
    is  => 'rw',
    isa => "Num",
    documentation =>
      "Alternate to `labels`. Builds a numeric set of labels. Use with `dlabel` where `label0` is the starting label and `dlabel` the step.",
);

has labels => ( is            => 'rw',
                documentation => "Sets the sector labels.", );

has marker => ( is  => 'rw',
                isa => "Maybe[HashRef]|Chart::Plotly::Trace::Attribute::Marker" );

has outsidetextfont => ( is            => 'rw',
                         documentation => "Sets the font used for `textinfo` lying outside the pie.", );

has pull => (
    is  => 'rw',
    isa => "Num",
    documentation =>
      "Sets the fraction of larger radius to pull the sectors out from the center. This can be a constant to pull all slices apart from each other equally or an array to highlight one or more slices.",
);

has rotation => ( is            => 'rw',
                  isa           => "Num",
                  documentation => "Instead of the first slice starting at 12 o'clock, rotate to some other angle.",
);

has scalegroup => (
    is  => 'rw',
    isa => "Str",
    documentation =>
      "If there are multiple pies that should be sized according to their totals, link them by providing a non-empty group id here shared by every trace in the same group.",
);

has sort => ( is            => 'rw',
              isa           => "Bool",
              documentation => "Determines whether or not the sectors of reordered from largest to smallest.",
);

has text => ( is            => 'rw',
              documentation => "Sets text elements associated with each sector.", );

has textfont => ( is            => 'rw',
                  documentation => "Sets the font used for `textinfo`.", );

has textinfo => ( is            => 'rw',
                  documentation => "Determines which trace information appear on the graph.", );

has textposition => ( is            => 'rw',
                      documentation => "Specifies the location of the `textinfo`.", );

has values => ( is            => 'rw',
                documentation => "Sets the values of the sectors of this pie chart.", );

has name => ( is            => 'rw',
              isa           => "Str",
              documentation => "Sets the trace name",
);

sub type {
    my @components = split( /::/, __PACKAGE__ );
    return lc( $components[-1] );
}

__PACKAGE__->meta->make_immutable();
1;

__END__

=pod

=encoding utf-8

=head1 NAME

Chart::Plotly::Trace::Pie

=head1 VERSION

version 0.008

=head1 SYNOPSIS

	use HTML::Show;
	use Chart::Plotly;
	use Chart::Plotly::Trace::Pie;
	my $pie = Chart::Plotly::Trace::Pie->new(x => [1 .. 5], y => [1 .. 5]);
	
	HTML::Show::show(Chart::Plotly::render_full_html(data => [$pie]));

=head1 DESCRIPTION

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#pie>

=head1 NAME 

Chart::Plotly::Trace::Pie

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=head1 ATTRIBUTES

=over

=item * direction

Specifies the direction at which succeeding sectors follow one another.

=item * dlabel

Sets the label step. See `label0` for more info.

=item * domain

=item * hole

Sets the fraction of the radius to cut out of the pie. Use this to make a donut chart.

=item * hoverinfo

Determines which trace information appear on hover. If `none` or `skip` are set, no information is displayed upon hovering. But, if `none` is set, click and hover events are still fired.

=item * insidetextfont

Sets the font used for `textinfo` lying inside the pie.

=item * label0

Alternate to `labels`. Builds a numeric set of labels. Use with `dlabel` where `label0` is the starting label and `dlabel` the step.

=item * labels

Sets the sector labels.

=item * marker

=item * outsidetextfont

Sets the font used for `textinfo` lying outside the pie.

=item * pull

Sets the fraction of larger radius to pull the sectors out from the center. This can be a constant to pull all slices apart from each other equally or an array to highlight one or more slices.

=item * rotation

Instead of the first slice starting at 12 o'clock, rotate to some other angle.

=item * scalegroup

If there are multiple pies that should be sized according to their totals, link them by providing a non-empty group id here shared by every trace in the same group.

=item * sort

Determines whether or not the sectors of reordered from largest to smallest.

=item * text

Sets text elements associated with each sector.

=item * textfont

Sets the font used for `textinfo`.

=item * textinfo

Determines which trace information appear on the graph.

=item * textposition

Specifies the location of the `textinfo`.

=item * values

Sets the values of the sectors of this pie chart.

=item * name

Sets the trace name

=back

=head2 type

Trace type.

=head1 AUTHOR

Pablo Rodríguez González <pablo.rodriguez.gonzalez@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Pablo Rodríguez González.

This is free software, licensed under:

  The MIT (X11) License

=cut
