package WordList::PersonName::PopularBabyNames::US::SSA::1900::FemaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-01'; # DATE
our $DIST = 'WordLists-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.001'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("avg_word_len",5.791,"num_words_contains_nonword_chars",0,"num_words_contain_unicode",0,"num_words_contains_whitespace",0,"shortest_word_len",2,"num_words_contain_whitespace",0,"num_words_contains_unicode",0,"num_words",1000,"num_words_contain_nonword_chars",0,"longest_word_len",10); # STATS

1;
# ABSTRACT: Top 1000 most popular names for female babies born in the USA in 1900 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::PersonName::PopularBabyNames::US::SSA::1900::FemaleTop1000 - Top 1000 most popular names for female babies born in the USA in 1900 (from Social Security Administration)

=head1 VERSION

This document describes version 0.001 of WordList::PersonName::PopularBabyNames::US::SSA::1900::FemaleTop1000 (from Perl distribution WordLists-PersonName-PopularBabyNames-US-SSA), released on 2020-05-01.

=head1 SYNOPSIS

 use WordList::PersonName::PopularBabyNames::US::SSA::1900::FemaleTop1000;

 my $wl = WordList::PersonName::PopularBabyNames::US::SSA::1900::FemaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.791 |
 | longest_word_len                 | 10    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Mary
Helen
Anna
Margaret
Ruth
Elizabeth
Florence
Ethel
Marie
Lillian
Annie
Edna
Emma
Alice
Bessie
Bertha
Grace
Rose
Clara
Mildred
Gladys
Minnie
Gertrude
Pearl
Mabel
Frances
Dorothy
Martha
Hazel
Ida
Irene
Myrtle
Eva
Catherine
Louise
Edith
Sarah
Elsie
Esther
Lillie
Agnes
Ella
Nellie
Mattie
Laura
Julia
Josephine
Carrie
Viola
Hattie
Ruby
Lena
Jessie
Mae
Cora
Beatrice
Alma
Willie
Mamie
Blanche
Lucy
Fannie
Lula
Jennie
Katherine
Marion
Lucille
Stella
Rosa
Evelyn
Pauline
Ada
Thelma
Virginia
Maggie
Vera
Maude
Beulah
Dora
Susie
Daisy
Ellen
Nora
Sadie
Leona
Marguerite
Georgia
Eleanor
Effie
Della
May
Ann
Kathryn
Nettie
Olive
Bernice
Lottie
Sallie
Nancy
Betty
Hilda
Theresa
Lizzie
Lydia
Emily
Flora
Katie
Anne
Violet
Charlotte
Marjorie
Inez
Ollie
Lola
Lois
Rosie
Doris
Estelle
Addie
Alberta
Loretta
Lela
Etta
Mable
Eunice
Rebecca
Goldie
Jane
Essie
Henrietta
Iva
Jean
Ora
Harriet
Caroline
Nannie
Sylvia
Eula
Mollie
Opal
Velma
Genevieve
Verna
Susan
Marian
Amelia
Lucile
Victoria
Madeline
Maria
Christine
Vivian
Rachel
Amanda
Nina
Olga
Sara
Flossie
Estella
Ola
Matilda
Barbara
Sophie
Alta
Amy
Eliza
Janie
Irma
Hannah
Freda
Kathleen
Geneva
Celia
Norma
Callie
Naomi
Winifred
Elva
Frieda
Kate
Belle
Ina
Sally
Allie
Isabel
Maud
Wilma
Erma
Juanita
Winnie
Lila
Luella
Fern
Josie
Cecelia
Virgie
Sophia
Nell
Cecilia
Augusta
Selma
Adeline
Gussie
Leola
Rena
Jeanette
Delia
Mayme
Millie
Isabelle
Muriel
Bonnie
Veronica
Miriam
Roxie
Lelia
Margie
Dollie
Birdie
Teresa
Bertie
Regina
Tillie
Cornelia
Roberta
Cleo
Audrey
Lulu
Faye
Adele
Carolyn
Madge
Adelaide
Hester
Elma
Elnora
Letha
Leila
Lorena
Ila
Jewell
Anita
Lessie
Lora
Maudie
Cecile
Zella
Fay
Jeannette
Bettie
Olivia
Leah
Johnnie
Myra
Jewel
Rita
Francis
Gracie
Hallie
Neva
Sue
Claire
Dovie
Lilly
Lenora
Rhoda
Harriett
Ophelia
Geraldine
Johanna
Louisa
Lettie
Katharine
Dorothea
Lou
Pearlie
Helene
Lee
Elvira
Bess
Angeline
Antoinette
Christina
Hettie
Nona
Rosetta
Zelma
Cecil
Nola
Isabella
June
Lily
Claudia
Dessie
Linda
Marcella
Phyllis
Lucinda
Corinne
Rosalie
Edythe
Lorraine
Gertie
Oma
Reba
Alvina
Angelina
Erna
Wilhelmina
Annette
Blanch
Clarice
Linnie
Mathilda
Merle
Abbie
Constance
Eugenia
Helena
Vesta
Louella
Hulda
Priscilla
Shirley
Corine
Janet
Angela
Eloise
Mittie
Golda
Jannie
Catharine
Lorene
Lona
Elsa
Minerva
Leota
Zora
Jimmie
Meta
Dolly
Orpha
Rosella
Tessie
Wanda
Eddie
Ernestine
Leta
Evie
Isabell
Mina
Carmen
Dolores
Maybelle
Nelle
Odessa
Pansy
Yvonne
Artie
Cynthia
Lura
Patricia
Fanny
Georgie
Aline
Cassie
Eileen
Floy
Willa
Iona
Lauretta
Donna
Lenore
Malinda
Vida
Cordelia
Mazie
Alpha
Polly
Peggy
Billie
Elise
Ivy
Jeanne
Mandy
Ona
Era
Annabelle
Bella
Chloe
Ester
Frankie
Iola
Leora
Phoebe
Zula
Carol
Una
Angie
Mona
Verda
Evangeline
Ione
Maxine
Myrtie
Rae
Aileen
Alva
Leatha
Leone
Molly
Natalie
Ocie
Queen
Aurelia
Estell
Agatha
Ava
Clyde
Ellie
Lina
Sybil
Bell
Clare
Sudie
Iris
Belva
Vada
Hortense
Idella
Beryl
Connie
Florine
Imogene
Joyce
Vina
Emilie
Madeleine
Reva
Avis
Carmela
Florida
Joan
Lilla
Lovie
Marietta
Pinkie
Tommie
Corrine
Esta
Judith
Pearle
Berta
Gretchen
Lida
Mabelle
Claudie
Dixie
Donnie
Elisabeth
Lue
Octavia
Dena
Nan
Savannah
Tina
Tressie
Antonia
Elda
Elinor
Lavina
Lennie
Pattie
Veda
Ferne
Rhea
Tennie
Adelia
Elaine
Ira
Adell
Albina
Celeste
Ludie
Margret
Mercedes
Patsy
Tena
Easter
Emmie
Maurine
Wilda
Zola
Arlene
Bernadette
Camille
Paula
Robbie
Dona
Georgiana
Harriette
John
Zelda
Alyce
Elna
Glenna
Melvina
Rilla
Charity
Kattie
Lyda
Melba
Rachael
William
Zona
Julie
Magnolia
Vinnie
Loraine
Lucia
Luvenia
Marvel
Rowena
Bennie
Eleanora
James
Lavinia
Manuela
Nadine
Ursula
Bridget
Camilla
Carolina
Cordie
Leonora
Melissa
Petra
Retta
Rosemary
Vallie
Vernie
Winnifred
Evalyn
George
Guadalupe
Jenny
Jettie
Kitty
Laverne
Madelyn
Mallie
Minna
Monica
Myrtis
Vergie
Adela
Allene
Clemmie
Emilia
Francisca
Gloria
Hilma
Madie
Mammie
Margery
Philomena
Adah
Annabel
Bernadine
Eleanore
Gwendolyn
Janice
Joanna
Lonie
Vena
Annis
Arvilla
Beaulah
Berniece
Bulah
Delphia
Delphine
Eda
Elenora
Ima
Marcia
Maye
Sadye
Alda
Althea
Arline
Bobbie
Eve
Freddie
Hope
Johnie
Margarita
Mellie
Novella
Queenie
Ray
Sibyl
Susanna
Viva
Icie
Inga
Juana
Katheryn
Kittie
Mertie
Adella
Anastasia
Birtha
Elmira
Eura
Faith
Joe
Lelah
Lonnie
Meda
Rubie
Sophronia
Valeria
Altha
Greta
Justine
Magdalena
Magdalene
Maxie
Maybell
Ossie
Reta
Verdie
Albertine
Etha
Exie
Osie
Serena
Almeda
Bethel
Celestine
Elvera
Ettie
Grayce
Hildegarde
Leslie
Letitia
Lilian
Lorine
Lorna
Luna
Malissa
Myrna
Veva
Yetta
Albertha
Berenice
Beth
Clementine
Diana
Ethelyn
Ethyl
Garnet
Kathrine
Lea
Louvenia
Margarette
Mariah
Nita
Nova
Odell
Onie
Ramona
Roma
Rosia
Charles
Enid
Florrie
Freida
Gail
Lucie
Lucretia
Madaline
Odie
Prudence
Sena
Signe
Amalia
Audie
Cathrine
Charlie
Crystal
Delma
Georgianna
Joy
Millicent
Monnie
Nelda
Rosalia
Rossie
Samantha
Selina
Sula
Velva
Aggie
Alida
Deborah
Elvie
Eulah
Gene
Golden
Hassie
Idell
Kay
Lenna
Liza
Lossie
Marjory
Neta
Ouida
Portia
Therese
Treva
Zoe
Aletha
Ara
Audra
Carmella
Edwina
Elfrieda
Emelia
Emmer
Euna
Filomena
Henry
Kathryne
Lady
Lala
Loma
Myrl
Stephanie
Zada
Amie
Augustine
Berdie
Betsy
Corrie
Dinah
Dorthy
Elizebeth
Fairy
Hertha
Ines
Jo
Mathilde
Missouri
Robert
Rosalee
Theodora
Alene
Arrie
Cordia
Corene
Ebba
Elena
Eugenie
Hazle
Hildegard
Huldah
Jessica
Libbie
Melva
Nevada
Retha
Rosina
Rubye
Sidney
Thora
Trudie
Alfreda
Arlie
Delpha
Docia
Dottie
Eldora
Emeline
Hanna
Hessie
Leda
Leontine
Libby
Manda
Norine
Oda
Phebe
Sammie
Tempie
Theo
Vella
Verla
Verona
Versie
Adrienne
Ammie
Annetta
Aurora
Clora
Delilah
Dellar
Delta
Elberta
Elisa
Ether
Frona
Garnett
Gena
Josefina
Louie
Macie
Margarett
Martina
Mossie
Myrle
Myrtice
Nonie
Ressie
Ruthie
Tilda
Tressa
Valerie
Verlie
Zena
Ardella
Arie
Besse
Clarissa
Concetta
Dana
Elta
Felicia
Glenn
Hildred
Jacqueline
Jamie
Josiephine
Juliette
Lavada
Lelar
Leonore
Lutie
Maryann
Melinda
Mettie
Rosalind
Sabina
Selena
Vernice
Zadie
Zita
Adelina
Almira
Aurore
Berneice
Carmel
Delores
Dorris
Eloisa
Enola
Eulalia
Fleta
Frank
Goldia
Janette
Josefa
Leanna
Marry
Mavis
Ottie
Pollie
Reatha
Rosanna
Tomasa
Violette
Zettie
Adaline
Adelle
Alicia
Ana
Carmelita
Christena
Dell
Earline
Elmer
Gay
Hedwig
Helga
Hellen
Henriette
Hermina
Hildur
India
Isa
Kizzie
Leonia
Lera
Lovina
Lupe
Magdalen
Maymie
Mozelle
Norah
Ova
Ozella
Palma
Rosamond
Winona
Aleen
Almeta
Annabell
Antonette
Arlena
Arthur
Cara
Cathryn
Classie
Daphne
Edyth
Evelina
Katy
Leo
Lilyan
Loretto
Mahala
Margaretta
Neoma
Odelia
Olevia
Otelia
Sofia
Zetta
Adline
Aimee
Atha
Beula
Concepcion
Dale
Dessa
Electa
Florance
Freeda
Henretta
Icy
Jonnie
Juliet
Lacy
Lannie
Lockie
Marianna
Nena
Paralee
Salome
Theda
Thomas
Twila
Vassie
Vernon
Vertie
Vira
Virgil
Alvira
Amber
America
Angelita
Bina
Bula
Caldonia
Celesta
Christie
Clella
Clifford
Dicie
Dorcas
Dortha
Dulcie
Ellar
Elvina
Ena
Erie
Evaline
Eveline
Fae
Isadora
Ivory
Jaunita
Jerry
Jossie
Lexie
Luvinia
Macy
Malvina
