/* -*- buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
 *    2008 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/opcode.pl from its data.
 * Any changes made here will be lost!
 */

typedef enum opcode {
	OP_NULL		 = 0,
	OP_STUB		 = 1,
	OP_SCALAR	 = 2,
	OP_PUSHMARK	 = 3,
	OP_WANTARRAY	 = 4,
	OP_CONST	 = 5,
	OP_GVSV		 = 6,
	OP_GV		 = 7,
	OP_GELEM	 = 8,
	OP_PADSV	 = 9,
	OP_PADSV_STORE	 = 10,
	OP_PADAV	 = 11,
	OP_PADHV	 = 12,
	OP_PADANY	 = 13,
	OP_RV2GV	 = 14,
	OP_RV2SV	 = 15,
	OP_AV2ARYLEN	 = 16,
	OP_RV2CV	 = 17,
	OP_ANONCODE	 = 18,
	OP_PROTOTYPE	 = 19,
	OP_REFGEN	 = 20,
	OP_SREFGEN	 = 21,
	OP_REF		 = 22,
	OP_BLESS	 = 23,
	OP_BACKTICK	 = 24,
	OP_GLOB		 = 25,
	OP_READLINE	 = 26,
	OP_RCATLINE	 = 27,
	OP_REGCMAYBE	 = 28,
	OP_REGCRESET	 = 29,
	OP_REGCOMP	 = 30,
	OP_MATCH	 = 31,
	OP_QR		 = 32,
	OP_SUBST	 = 33,
	OP_SUBSTCONT	 = 34,
	OP_TRANS	 = 35,
	OP_TRANSR	 = 36,
	OP_SASSIGN	 = 37,
	OP_AASSIGN	 = 38,
	OP_CHOP		 = 39,
	OP_SCHOP	 = 40,
	OP_CHOMP	 = 41,
	OP_SCHOMP	 = 42,
	OP_DEFINED	 = 43,
	OP_UNDEF	 = 44,
	OP_STUDY	 = 45,
	OP_POS		 = 46,
	OP_PREINC	 = 47,
	OP_I_PREINC	 = 48,
	OP_PREDEC	 = 49,
	OP_I_PREDEC	 = 50,
	OP_POSTINC	 = 51,
	OP_I_POSTINC	 = 52,
	OP_POSTDEC	 = 53,
	OP_I_POSTDEC	 = 54,
	OP_POW		 = 55,
	OP_MULTIPLY	 = 56,
	OP_I_MULTIPLY	 = 57,
	OP_DIVIDE	 = 58,
	OP_I_DIVIDE	 = 59,
	OP_MODULO	 = 60,
	OP_I_MODULO	 = 61,
	OP_REPEAT	 = 62,
	OP_ADD		 = 63,
	OP_I_ADD	 = 64,
	OP_SUBTRACT	 = 65,
	OP_I_SUBTRACT	 = 66,
	OP_CONCAT	 = 67,
	OP_MULTICONCAT	 = 68,
	OP_STRINGIFY	 = 69,
	OP_LEFT_SHIFT	 = 70,
	OP_RIGHT_SHIFT	 = 71,
	OP_LT		 = 72,
	OP_I_LT		 = 73,
	OP_GT		 = 74,
	OP_I_GT		 = 75,
	OP_LE		 = 76,
	OP_I_LE		 = 77,
	OP_GE		 = 78,
	OP_I_GE		 = 79,
	OP_EQ		 = 80,
	OP_I_EQ		 = 81,
	OP_NE		 = 82,
	OP_I_NE		 = 83,
	OP_NCMP		 = 84,
	OP_I_NCMP	 = 85,
	OP_SLT		 = 86,
	OP_SGT		 = 87,
	OP_SLE		 = 88,
	OP_SGE		 = 89,
	OP_SEQ		 = 90,
	OP_SNE		 = 91,
	OP_SCMP		 = 92,
	OP_BIT_AND	 = 93,
	OP_BIT_XOR	 = 94,
	OP_BIT_OR	 = 95,
	OP_NBIT_AND	 = 96,
	OP_NBIT_XOR	 = 97,
	OP_NBIT_OR	 = 98,
	OP_SBIT_AND	 = 99,
	OP_SBIT_XOR	 = 100,
	OP_SBIT_OR	 = 101,
	OP_NEGATE	 = 102,
	OP_I_NEGATE	 = 103,
	OP_NOT		 = 104,
	OP_COMPLEMENT	 = 105,
	OP_NCOMPLEMENT	 = 106,
	OP_SCOMPLEMENT	 = 107,
	OP_SMARTMATCH	 = 108,
	OP_ATAN2	 = 109,
	OP_SIN		 = 110,
	OP_COS		 = 111,
	OP_RAND		 = 112,
	OP_SRAND	 = 113,
	OP_EXP		 = 114,
	OP_LOG		 = 115,
	OP_SQRT		 = 116,
	OP_INT		 = 117,
	OP_HEX		 = 118,
	OP_OCT		 = 119,
	OP_ABS		 = 120,
	OP_LENGTH	 = 121,
	OP_SUBSTR	 = 122,
	OP_VEC		 = 123,
	OP_INDEX	 = 124,
	OP_RINDEX	 = 125,
	OP_SPRINTF	 = 126,
	OP_FORMLINE	 = 127,
	OP_ORD		 = 128,
	OP_CHR		 = 129,
	OP_CRYPT	 = 130,
	OP_UCFIRST	 = 131,
	OP_LCFIRST	 = 132,
	OP_UC		 = 133,
	OP_LC		 = 134,
	OP_QUOTEMETA	 = 135,
	OP_RV2AV	 = 136,
	OP_AELEMFAST	 = 137,
	OP_AELEMFAST_LEX = 138,
	OP_AELEM	 = 139,
	OP_ASLICE	 = 140,
	OP_KVASLICE	 = 141,
	OP_AEACH	 = 142,
	OP_AVALUES	 = 143,
	OP_AKEYS	 = 144,
	OP_EACH		 = 145,
	OP_VALUES	 = 146,
	OP_KEYS		 = 147,
	OP_DELETE	 = 148,
	OP_EXISTS	 = 149,
	OP_RV2HV	 = 150,
	OP_HELEM	 = 151,
	OP_HSLICE	 = 152,
	OP_KVHSLICE	 = 153,
	OP_MULTIDEREF	 = 154,
	OP_UNPACK	 = 155,
	OP_PACK		 = 156,
	OP_SPLIT	 = 157,
	OP_JOIN		 = 158,
	OP_LIST		 = 159,
	OP_LSLICE	 = 160,
	OP_ANONLIST	 = 161,
	OP_ANONHASH	 = 162,
	OP_SPLICE	 = 163,
	OP_PUSH		 = 164,
	OP_POP		 = 165,
	OP_SHIFT	 = 166,
	OP_UNSHIFT	 = 167,
	OP_SORT		 = 168,
	OP_REVERSE	 = 169,
	OP_GREPSTART	 = 170,
	OP_GREPWHILE	 = 171,
	OP_MAPSTART	 = 172,
	OP_MAPWHILE	 = 173,
	OP_RANGE	 = 174,
	OP_FLIP		 = 175,
	OP_FLOP		 = 176,
	OP_AND		 = 177,
	OP_OR		 = 178,
	OP_XOR		 = 179,
	OP_DOR		 = 180,
	OP_COND_EXPR	 = 181,
	OP_ANDASSIGN	 = 182,
	OP_ORASSIGN	 = 183,
	OP_DORASSIGN	 = 184,
	OP_ENTERSUB	 = 185,
	OP_LEAVESUB	 = 186,
	OP_LEAVESUBLV	 = 187,
	OP_ARGCHECK	 = 188,
	OP_ARGELEM	 = 189,
	OP_ARGDEFELEM	 = 190,
	OP_CALLER	 = 191,
	OP_WARN		 = 192,
	OP_DIE		 = 193,
	OP_RESET	 = 194,
	OP_LINESEQ	 = 195,
	OP_NEXTSTATE	 = 196,
	OP_DBSTATE	 = 197,
	OP_UNSTACK	 = 198,
	OP_ENTER	 = 199,
	OP_LEAVE	 = 200,
	OP_SCOPE	 = 201,
	OP_ENTERITER	 = 202,
	OP_ITER		 = 203,
	OP_ENTERLOOP	 = 204,
	OP_LEAVELOOP	 = 205,
	OP_RETURN	 = 206,
	OP_LAST		 = 207,
	OP_NEXT		 = 208,
	OP_REDO		 = 209,
	OP_DUMP		 = 210,
	OP_GOTO		 = 211,
	OP_EXIT		 = 212,
	OP_METHOD	 = 213,
	OP_METHOD_NAMED	 = 214,
	OP_METHOD_SUPER	 = 215,
	OP_METHOD_REDIR	 = 216,
	OP_METHOD_REDIR_SUPER = 217,
	OP_ENTERGIVEN	 = 218,
	OP_LEAVEGIVEN	 = 219,
	OP_ENTERWHEN	 = 220,
	OP_LEAVEWHEN	 = 221,
	OP_BREAK	 = 222,
	OP_CONTINUE	 = 223,
	OP_OPEN		 = 224,
	OP_CLOSE	 = 225,
	OP_PIPE_OP	 = 226,
	OP_FILENO	 = 227,
	OP_UMASK	 = 228,
	OP_BINMODE	 = 229,
	OP_TIE		 = 230,
	OP_UNTIE	 = 231,
	OP_TIED		 = 232,
	OP_DBMOPEN	 = 233,
	OP_DBMCLOSE	 = 234,
	OP_SSELECT	 = 235,
	OP_SELECT	 = 236,
	OP_GETC		 = 237,
	OP_READ		 = 238,
	OP_ENTERWRITE	 = 239,
	OP_LEAVEWRITE	 = 240,
	OP_PRTF		 = 241,
	OP_PRINT	 = 242,
	OP_SAY		 = 243,
	OP_SYSOPEN	 = 244,
	OP_SYSSEEK	 = 245,
	OP_SYSREAD	 = 246,
	OP_SYSWRITE	 = 247,
	OP_EOF		 = 248,
	OP_TELL		 = 249,
	OP_SEEK		 = 250,
	OP_TRUNCATE	 = 251,
	OP_FCNTL	 = 252,
	OP_IOCTL	 = 253,
	OP_FLOCK	 = 254,
	OP_SEND		 = 255,
	OP_RECV		 = 256,
	OP_SOCKET	 = 257,
	OP_SOCKPAIR	 = 258,
	OP_BIND		 = 259,
	OP_CONNECT	 = 260,
	OP_LISTEN	 = 261,
	OP_ACCEPT	 = 262,
	OP_SHUTDOWN	 = 263,
	OP_GSOCKOPT	 = 264,
	OP_SSOCKOPT	 = 265,
	OP_GETSOCKNAME	 = 266,
	OP_GETPEERNAME	 = 267,
	OP_LSTAT	 = 268,
	OP_STAT		 = 269,
	OP_FTRREAD	 = 270,
	OP_FTRWRITE	 = 271,
	OP_FTREXEC	 = 272,
	OP_FTEREAD	 = 273,
	OP_FTEWRITE	 = 274,
	OP_FTEEXEC	 = 275,
	OP_FTIS		 = 276,
	OP_FTSIZE	 = 277,
	OP_FTMTIME	 = 278,
	OP_FTATIME	 = 279,
	OP_FTCTIME	 = 280,
	OP_FTROWNED	 = 281,
	OP_FTEOWNED	 = 282,
	OP_FTZERO	 = 283,
	OP_FTSOCK	 = 284,
	OP_FTCHR	 = 285,
	OP_FTBLK	 = 286,
	OP_FTFILE	 = 287,
	OP_FTDIR	 = 288,
	OP_FTPIPE	 = 289,
	OP_FTSUID	 = 290,
	OP_FTSGID	 = 291,
	OP_FTSVTX	 = 292,
	OP_FTLINK	 = 293,
	OP_FTTTY	 = 294,
	OP_FTTEXT	 = 295,
	OP_FTBINARY	 = 296,
	OP_CHDIR	 = 297,
	OP_CHOWN	 = 298,
	OP_CHROOT	 = 299,
	OP_UNLINK	 = 300,
	OP_CHMOD	 = 301,
	OP_UTIME	 = 302,
	OP_RENAME	 = 303,
	OP_LINK		 = 304,
	OP_SYMLINK	 = 305,
	OP_READLINK	 = 306,
	OP_MKDIR	 = 307,
	OP_RMDIR	 = 308,
	OP_OPEN_DIR	 = 309,
	OP_READDIR	 = 310,
	OP_TELLDIR	 = 311,
	OP_SEEKDIR	 = 312,
	OP_REWINDDIR	 = 313,
	OP_CLOSEDIR	 = 314,
	OP_FORK		 = 315,
	OP_WAIT		 = 316,
	OP_WAITPID	 = 317,
	OP_SYSTEM	 = 318,
	OP_EXEC		 = 319,
	OP_KILL		 = 320,
	OP_GETPPID	 = 321,
	OP_GETPGRP	 = 322,
	OP_SETPGRP	 = 323,
	OP_GETPRIORITY	 = 324,
	OP_SETPRIORITY	 = 325,
	OP_TIME		 = 326,
	OP_TMS		 = 327,
	OP_LOCALTIME	 = 328,
	OP_GMTIME	 = 329,
	OP_ALARM	 = 330,
	OP_SLEEP	 = 331,
	OP_SHMGET	 = 332,
	OP_SHMCTL	 = 333,
	OP_SHMREAD	 = 334,
	OP_SHMWRITE	 = 335,
	OP_MSGGET	 = 336,
	OP_MSGCTL	 = 337,
	OP_MSGSND	 = 338,
	OP_MSGRCV	 = 339,
	OP_SEMOP	 = 340,
	OP_SEMGET	 = 341,
	OP_SEMCTL	 = 342,
	OP_REQUIRE	 = 343,
	OP_DOFILE	 = 344,
	OP_HINTSEVAL	 = 345,
	OP_ENTEREVAL	 = 346,
	OP_LEAVEEVAL	 = 347,
	OP_ENTERTRY	 = 348,
	OP_LEAVETRY	 = 349,
	OP_GHBYNAME	 = 350,
	OP_GHBYADDR	 = 351,
	OP_GHOSTENT	 = 352,
	OP_GNBYNAME	 = 353,
	OP_GNBYADDR	 = 354,
	OP_GNETENT	 = 355,
	OP_GPBYNAME	 = 356,
	OP_GPBYNUMBER	 = 357,
	OP_GPROTOENT	 = 358,
	OP_GSBYNAME	 = 359,
	OP_GSBYPORT	 = 360,
	OP_GSERVENT	 = 361,
	OP_SHOSTENT	 = 362,
	OP_SNETENT	 = 363,
	OP_SPROTOENT	 = 364,
	OP_SSERVENT	 = 365,
	OP_EHOSTENT	 = 366,
	OP_ENETENT	 = 367,
	OP_EPROTOENT	 = 368,
	OP_ESERVENT	 = 369,
	OP_GPWNAM	 = 370,
	OP_GPWUID	 = 371,
	OP_GPWENT	 = 372,
	OP_SPWENT	 = 373,
	OP_EPWENT	 = 374,
	OP_GGRNAM	 = 375,
	OP_GGRGID	 = 376,
	OP_GGRENT	 = 377,
	OP_SGRENT	 = 378,
	OP_EGRENT	 = 379,
	OP_GETLOGIN	 = 380,
	OP_SYSCALL	 = 381,
	OP_LOCK		 = 382,
	OP_ONCE		 = 383,
	OP_CUSTOM	 = 384,
	OP_COREARGS	 = 385,
	OP_AVHVSWITCH	 = 386,
	OP_RUNCV	 = 387,
	OP_FC		 = 388,
	OP_PADCV	 = 389,
	OP_INTROCV	 = 390,
	OP_CLONECV	 = 391,
	OP_PADRANGE	 = 392,
	OP_REFASSIGN	 = 393,
	OP_LVREF	 = 394,
	OP_LVREFSLICE	 = 395,
	OP_LVAVREF	 = 396,
	OP_ANONCONST	 = 397,
	OP_ISA		 = 398,
	OP_CMPCHAIN_AND	 = 399,
	OP_CMPCHAIN_DUP	 = 400,
	OP_ENTERTRYCATCH = 401,
	OP_LEAVETRYCATCH = 402,
	OP_POPTRY	 = 403,
	OP_CATCH	 = 404,
	OP_PUSHDEFER	 = 405,
	OP_IS_BOOL	 = 406,
	OP_IS_WEAK	 = 407,
	OP_WEAKEN	 = 408,
	OP_UNWEAKEN	 = 409,
	OP_BLESSED	 = 410,
	OP_REFADDR	 = 411,
	OP_REFTYPE	 = 412,
	OP_CEIL		 = 413,
	OP_FLOOR	 = 414,
	OP_IS_TAINTED	 = 415,
	OP_max		
} opcode;

#define MAXO 416
#define OP_FREED MAXO

/* the OP_IS_* macros are optimized to a simple range check because
    all the member OPs are contiguous in regen/opcodes table.
    opcode.pl verifies the range contiguity, or generates an OR-equals
    expression */

#define OP_IS_SOCKET(op)	\
	((op) >= OP_SEND && (op) <= OP_GETPEERNAME)

#define OP_IS_FILETEST(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTBINARY)

#define OP_IS_FILETEST_ACCESS(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTEEXEC)

#define OP_IS_NUMCOMPARE(op)	\
	((op) >= OP_LT && (op) <= OP_I_NCMP)

#define OP_IS_DIRHOP(op)	\
	((op) >= OP_READDIR && (op) <= OP_CLOSEDIR)

#define OP_IS_INFIX_BIT(op)	\
	((op) >= OP_BIT_AND && (op) <= OP_SBIT_OR)

/* ex: set ro: */
