use utf8;

package SemanticWeb::Schema::BusinessFunction;

# ABSTRACT: The business function specifies the type of activity or access (i

use Moo;

extends qw/ SemanticWeb::Schema::Enumeration /;


use MooX::JSON_LD 'BusinessFunction';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v11.1.1';




1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::BusinessFunction - The business function specifies the type of activity or access (i

=head1 VERSION

version v11.1.1

=head1 DESCRIPTION

The business function specifies the type of activity or access (i.e., the bundle of rights) offered by the organization or business person through the offer. Typical are sell, rental or lease, maintenance or repair, manufacture / produce, recycle / dispose, engineering / construction, or installation. Proprietary specifications of access rights are also instances of this class.

Commonly used values:

=over

=item *

http://purl.org/goodrelations/v1#ConstructionInstallation

=item *

http://purl.org/goodrelations/v1#Dispose

=item *

http://purl.org/goodrelations/v1#LeaseOut

=item *

http://purl.org/goodrelations/v1#Maintain

=item *

http://purl.org/goodrelations/v1#ProvideService

=item *

http://purl.org/goodrelations/v1#Repair

=item *

http://purl.org/goodrelations/v1#Sell

=item *

http://purl.org/goodrelations/v1#Buy

=back

=head1 SEE ALSO

L<SemanticWeb::Schema::Enumeration>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2021 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
