package Acme::CPANAuthors::CPAN::Streaks::MonthlyDistributions::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-02-21'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240221.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'SKIM' => '',
    'GENE' => '',
    'VVELOX' => '',
    'ABALAMA' => '',
    'DJERIUS' => '',
    'JGNI' => '',
    'BPS' => '',
    'DERIV' => '',
    'ETHER' => '',
    'JMATES' => '',
    'PEVANS' => '',
    'VKON' => '',
    'LEONT' => '',
    'ARISTOTLE' => '',
    'ATRODO' => '',
    'DRCLAW' => '',
    'GARU' => '',
    'GHE' => '',
    'JROBINSON' => '',
    'MMCCLENN' => '',
    'MSIMERSON' => '',
    'MSLM' => '',
    'NHORNE' => '',
    'NUDDLEGG' => '',
    'OLEG' => '',
    'SANKO' => '',
    'SFOBERSKI' => '',
    'SHE' => '',
    'SISYPHUS' => '',
    'SREZIC' => '',
    'XMOLEX' => '',
    'ASB' => '',
    'BRIANDFOY' => '',
    'CRLCU' => '',
    'DAVECROSS' => '',
    'JANW' => '',
    'LITCHIE' => '',
    'RAWLEYFOW' => '',
    'RRWO' => '',
    'SVW' => '',
    'TYRRMINAL' => '',
    'WATERKIP' => '',
    'ZMUGHAL' => '',
);


1;
# ABSTRACT: Authors with ongoing monthly distributions streak (release a new [for them] distribution every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyDistributions::Current - Authors with ongoing monthly distributions streak (release a new [for them] distribution every month)

=head1 VERSION

This document describes version 20240221.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyDistributions::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-02-21.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-02-21, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 115 | 2014-08    | ongoing     |
  | SKIM      |  12 | 2023-03    | ongoing     |
  | GENE      |   3 | 2023-11    | might-break |
  | VVELOX    |   3 | 2023-11    | might-break |
  | ABALAMA   |   3 | 2023-12    | ongoing     |
  | DJERIUS   |   3 | 2023-12    | ongoing     |
  | JGNI      |   3 | 2023-12    | ongoing     |
  | BPS       |   2 | 2023-12    | might-break |
  | DERIV     |   2 | 2023-12    | might-break |
  | ETHER     |   2 | 2023-12    | might-break |
  | JMATES    |   2 | 2023-12    | might-break |
  | PEVANS    |   2 | 2023-12    | might-break |
  | VKON      |   2 | 2023-12    | might-break |
  | LEONT     |   2 | 2024-01    | ongoing     |
  | ARISTOTLE |   1 | 2024-01    | might-break |
  | ATRODO    |   1 | 2024-01    | might-break |
  | DRCLAW    |   1 | 2024-01    | might-break |
  | GARU      |   1 | 2024-01    | might-break |
  | GHE       |   1 | 2024-01    | might-break |
  | JROBINSON |   1 | 2024-01    | might-break |
  | MMCCLENN  |   1 | 2024-01    | might-break |
  | MSIMERSON |   1 | 2024-01    | might-break |
  | MSLM      |   1 | 2024-01    | might-break |
  | NHORNE    |   1 | 2024-01    | might-break |
  | NUDDLEGG  |   1 | 2024-01    | might-break |
  | OLEG      |   1 | 2024-01    | might-break |
  | SANKO     |   1 | 2024-01    | might-break |
  | SFOBERSKI |   1 | 2024-01    | might-break |
  | SHE       |   1 | 2024-01    | might-break |
  | SISYPHUS  |   1 | 2024-01    | might-break |
  | SREZIC    |   1 | 2024-01    | might-break |
  | XMOLEX    |   1 | 2024-01    | might-break |
  | ASB       |   1 | 2024-02    | ongoing     |
  | BRIANDFOY |   1 | 2024-02    | ongoing     |
  | CRLCU     |   1 | 2024-02    | ongoing     |
  | DAVECROSS |   1 | 2024-02    | ongoing     |
  | JANW      |   1 | 2024-02    | ongoing     |
  | LITCHIE   |   1 | 2024-02    | ongoing     |
  | RAWLEYFOW |   1 | 2024-02    | ongoing     |
  | RRWO      |   1 | 2024-02    | ongoing     |
  | SVW       |   1 | 2024-02    | ongoing     |
  | TYRRMINAL |   1 | 2024-02    | ongoing     |
  | WATERKIP  |   1 | 2024-02    | ongoing     |
  | ZMUGHAL   |   1 | 2024-02    | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
