package Bencher::Scenario::Z::Overhead;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-10-08'; # DATE
our $DIST = 'Bencher-Scenarios-Z'; # DIST
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Measure startup overhead of Z',
    code_startup => 1,
    participants => [
        {code_template=>'use Z;'},
        {code_template=>'use Z -modern;'},
        {code_template=>'use Z -compat;'},
        {code_template=>'use Z -detect;'},

        {code_template=>'use Type::Tiny;'},
        {code_template=>'use Types::Standard;'},

        {code_template=>'use Zydeco;'},

        {code_template=>'use Zydeco::Lite;'},

        {code_template=>'use MooX::Press;'},

        {code_template=>'use Moo;'},
    ],
};

1;
# ABSTRACT: Measure startup overhead of Z

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Z::Overhead - Measure startup overhead of Z

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::Z::Overhead (from Perl distribution Bencher-Scenarios-Z), released on 2020-10-08.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Z>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Z>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Z>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
