#!/usr/bin/perl

use v5.14;
use warnings;

use Test2::V0;

use meta;

# meta's own metapackage
{
   my $metapkg = meta::get_package( "meta" );
   ok( $metapkg, 'meta::get_package for "meta"' );

   is( $metapkg->name, "meta", 'Name of package' );
}

# Test2::V0's metapackage
{
   is( meta::get_package( "Test2::V0" )->name, "Test2::V0",
      'Name of the Test2::V0 package' );
}

# this file's main package
{
   is( meta::get_this_package()->name, "main",
      'Name of the main package from get_this_package' );
}

# missing gets created
{
   my $metapkg;
   ok( lives { $metapkg = meta::get_package( "this-is-not-a-package" ) },
      'get_package creates a new package' );
   is( $metapkg->name, "this-is-not-a-package" );
}

# meta::package->get method
{
   my $metapkg = meta::package->get( "meta" );
   ok( $metapkg, 'meta::package->get for "meta"' );

   is( $metapkg->name, "meta", 'Name of package' );
}

done_testing;
