package App::BPOMUtils::Table::FoodTypeRBAImporter;

use 5.010001;
use strict 'subs', 'vars';
use utf8;
use warnings;
use Log::ger;

use Exporter 'import';
use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-02-14'; # DATE
our $DIST = 'App-BPOMUtils-Table-FoodType'; # DIST
our $VERSION = '0.018'; # VERSION

our @EXPORT_OK = qw(
                       bpom_list_food_types_rba_importer
               );

our %SPEC;

# BEGIN FRAGMENT id=meta-idn_bpom_jenis_pangan_rba_importir varname=meta_idn_bpom_jenis_pangan_rba_importir
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_jenis_pangan_rba_importir/meta.yaml
# src-revision: e2063114ea985d6735726a9c42fb5fb28050df7e (Tue Feb 14 11:36:11 2023 +0700)
# generate-date: Tue Feb 14 04:36:15 2023 UTC
# generated-by: update-fragments-in-perl-module
our $meta_idn_bpom_jenis_pangan_rba_importir = {
  "fields" => {
    category_code => {
      "filterable_regex" => "Yes",
      "pos" => 5,
      "schema" => ["str*"],
      "sortable" => "Yes",
      "summary" => "Food category name",
      "summary.alt.lang.id" => "Nama kategori pangan",
      "unique" => "No",
    },
    dosage_form_code => {
      "filterable_regex" => "Yes",
      "pos" => 2,
      "schema" => ["str*", { match => "^[0-9]+\$" }],
      "sortable" => "Yes",
      "summary" => "Dosage form code",
      "summary.alt.lang.id" => "Kode bentuk sediaan",
      "unique" => "No",
    },
    dosage_form_name => {
      "filterable_regex" => "Yes",
      "pos" => 3,
      "schema" => ["str*"],
      "sortable" => "Yes",
      "summary" => "Dosage form name",
      "summary.alt.lang.id" => "Nama bentuk sediaan",
      "unique" => "No",
    },
    id => {
      filterable_regex => "Yes",
      pos => 0,
      schema => ["posint*"],
      sortable => "Yes",
      summary => "Numeric ID",
      unique => "Yes",
    },
    kbli_code => {
      "filterable_regex" => "Yes",
      "pos" => 1,
      "schema" => ["str*", { match => "^[0-9]+\$" }],
      "sortable" => "Yes",
      "summary" => "KBLI code",
      "summary.alt.lang.id" => "Kode KBLI",
      "unique" => "No",
    },
    mod_price => {
      "filterable_regex" => "Yes",
      "pos" => 8,
      "schema" => ["ufloat*"],
      "sortable" => "Yes",
      "summary" => "Price for modification of product",
      "summary.alt.lang.id" => "Harga perubahan product",
      "unique" => "No",
    },
    new_reg_price => {
      "filterable_regex" => "Yes",
      "pos" => 6,
      "schema" => ["ufloat*"],
      "sortable" => "Yes",
      "summary" => "Price for new registration of new product",
      "summary.alt.lang.id" => "Harga daftar baru produ",
      "unique" => "No",
    },
    rereg_price => {
      "filterable_regex" => "Yes",
      "pos" => 7,
      "schema" => ["ufloat*"],
      "sortable" => "Yes",
      "summary" => "Price for re-registration of product",
      "summary.alt.lang.id" => "Harga daftar ulang produk",
      "unique" => "No",
    },
    status => {
      "filterable_regex" => "Yes",
      "pos" => 9,
      "schema" => ["str*"],
      "sortable" => "Yes",
      "summary" => "Status",
      "summary.alt.lang.id" => "Status",
      "unique" => "No",
    },
  },
  "pk" => "id",
  "summary" => "Food types in BPOM processed food division (RBA version, for importers)",
  "summary.alt.lang.id_ID" => "Jenis pangan di BPOM pangan olahan (versi RBA, importir)",
};
# END FRAGMENT id=meta-idn_bpom_jenis_pangan_rba_importir

# BEGIN FRAGMENT id=data-idn_bpom_jenis_pangan_rba_importir varname=data_idn_bpom_jenis_pangan_rba_importir
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_jenis_pangan_rba_importir/data.csv
# src-revision: e2063114ea985d6735726a9c42fb5fb28050df7e (Tue Feb 14 11:36:11 2023 +0700)
# generate-date: Tue Feb 14 04:36:15 2023 UTC
# generated-by: update-fragments-in-perl-module
our $data_idn_bpom_jenis_pangan_rba_importir = [
  [
    1,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010101000001",
    "Susu Lemak Penuh (Full Cream)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    2,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010101000002",
    "Susu Skim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    3,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010101000003",
    "Susu Skim Sebagian",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    4,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000001",
    "Susu Lemak Penuh Rekombinasi (Recombined Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    5,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000001",
    "Susu Lemak Penuh Rekombinasi (Recombined Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    6,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000002",
    "Susu Lemak Penuh Rekonstitusi (Reconstituted Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    7,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000002",
    "Susu Lemak Penuh Rekonstitusi (Reconstituted Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    8,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000003",
    "Susu Skim Rekonstitusi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    9,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000004",
    "Susu Skim Sebagian Rekonstitusi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    10,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000005",
    "Susu Skim Sebagian Rekombinasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    11,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000006",
    "Susu Lemak Nabati/Susu Minyak Nabati (Filled Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    12,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    13,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    14,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    15,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    16,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    17,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    18,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    19,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    20,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    21,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    22,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    23,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    24,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    25,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    26,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    27,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    28,
    46326,
    "0113",
    "Lassi",
    "010102000010",
    "Lassi (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    29,
    46326,
    "0102",
    "Buttermilk (plain) dengan proses pasteurisasi",
    "010103000001",
    "Buttermilk Cair",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    30,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010104000001",
    "Susu (Rasa) Lemak Penuh (Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    31,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010104000002",
    "Susu Berperisa/Susu Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    32,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    33,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    34,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    35,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    36,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    37,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    38,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    39,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    40,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    41,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    42,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    43,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    44,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    45,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    46,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    47,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    48,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    49,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    50,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    51,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    52,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    53,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    54,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    55,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    56,
    46326,
    "0113",
    "Lassi",
    "010104000006",
    "Lassi (Rasa/Berperisa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    57,
    46326,
    "0104",
    "Cairan whey dan produknya, kecuali keju whey",
    "010104000007",
    "Minuman Berbasis Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    58,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    59,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    60,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    61,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    62,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    63,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    64,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000010",
    "Susu Bubuk Skim Sebagian (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    65,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000010",
    "Susu Bubuk Skim Sebagian (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    66,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000010",
    "Susu Bubuk Skim Sebagian (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    67,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    68,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    69,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    70,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000012",
    "Susu Bubuk Skim Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    71,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000012",
    "Susu Bubuk Skim Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    72,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000012",
    "Susu Bubuk Skim Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    73,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    74,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    75,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    76,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    77,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    78,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    79,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    80,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    81,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    82,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    83,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    84,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    85,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    86,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    87,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    88,
    46326,
    "0127",
    "Susu yang digumpalkan dengan enzim renin",
    "010200000001",
    "Dadih",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    89,
    46326,
    "0125",
    "Susu diasamkan",
    "010201010001",
    "Susu Diasamkan (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    90,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010002",
    "Susu Asidofilus (Acidophilus Milk) (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    91,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010003",
    "Yogurt (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    92,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010004",
    "Yogurt Kultur Lain (Alternate Culture Yogurt) (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    93,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010005",
    "Kefir (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    94,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010006",
    "Kumys (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    95,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010007",
    "Susu Fermentasi atau Susu Berkultur (Cultured Milk) (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    96,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020001",
    "Susu Diasamkan (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    97,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020002",
    "Susu Asidofilus (Acidophilus Milk) (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    98,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020003",
    "Yogurt (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    99,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020004",
    "Yogurt Kultur Lain (Alternate Culture Yogurt) (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    100,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020005",
    "Kefir (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    101,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020006",
    "Kumys (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    102,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020007",
    "Susu Fermentasi atau Susu Berkultur (Cultured Milk) (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    103,
    46326,
    "0127",
    "Susu yang digumpalkan dengan enzim renin",
    "010202000001",
    "Susu yang digumpalkan dengan rennet (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    104,
    46326,
    "0126",
    "Susu evaporasi",
    "010301000001",
    "Susu Evaporasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    105,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010301000002",
    "Susu Skim Evaporasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    106,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010301000003",
    "Susu Skim Sebagian Evaporasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    107,
    46326,
    "0124",
    "Susu dan krim kental manis",
    "010301000004",
    "Susu Kental Manis",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    108,
    46326,
    "0124",
    "Susu dan krim kental manis",
    "010301000005",
    "Susu Skim Kental Manis",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    109,
    46326,
    "0124",
    "Susu dan krim kental manis",
    "010301000006",
    "Krim Kental Manis",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    110,
    46326,
    "0109",
    "Khoa",
    "010301000007",
    "Khoa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    111,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010302000001",
    "Susu Lemak Nabati Evaporasi/ Susu Minyak Nabati Evaporasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    112,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010302000002",
    "Susu Kental Manis Lemak Nabati/ Susu Kental Manis Minyak Nabati",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    113,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010302000003",
    "Krimer Kental Manis",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    114,
    46326,
    "0112",
    "Krimer nabati",
    "010302000004",
    "Krimer Minuman ",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    115,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010400000001",
    "Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    116,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010401000001",
    "Krim Pasteurisasi (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    117,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010401000002",
    "Half and Half",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    118,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010402000001",
    "Krim sterilisasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    119,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010402000002",
    "Whipping cream",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    120,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010402000003",
    "Whipped Cream",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    121,
    46326,
    "0111",
    "Krim yang digumpalkan",
    "010403000001",
    "Krim yang Digumpalkan Dengan Enzim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    122,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010403000002",
    "Krim Asam",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    123,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010403000003",
    "Krim yang Diasamkan",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    124,
    46326,
    "0110",
    "Krim nabati",
    "010404000001",
    "Krim Nabati",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    125,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010501000001",
    "Susu Bubuk Lemak Penuh (Full Cream)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    126,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010501000002",
    "Susu Bubuk Lemak Penuh (Full Cream) Instan",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    127,
    46327,
    "0122",
    "Susu dan krim bubuk",
    "010501000003",
    "Susu Bubuk Skim Sebagian",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    128,
    46328,
    "0122",
    "Susu dan krim bubuk",
    "010501000004",
    "Susu Bubuk Skim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    129,
    46329,
    "0122",
    "Susu dan krim bubuk",
    "010501000005",
    "Campuran Susu dan Krim Bubuk (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    130,
    46330,
    "0122",
    "Susu dan krim bubuk",
    "010501000006",
    "Krim Bubuk",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    131,
    46326,
    "0103",
    "Buttermilk bubuk (plain)",
    "010501000007",
    "Bubuk Buttermilk",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    132,
    46331,
    "0122",
    "Susu dan krim bubuk",
    "010501000008",
    "Minuman Mengandung Susu Bubuk (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    133,
    46332,
    "0122",
    "Susu dan krim bubuk",
    "010502000001",
    "Susu Bubuk Lemak Nabati/Susu Bubuk Minyak Nabati",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    134,
    46326,
    "0107",
    "Keju olahan",
    "010600000001",
    "Keju",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    135,
    46326,
    "0107",
    "Keju olahan",
    "010600000002",
    "Analog Keju",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    136,
    46326,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000001",
    "Keju Cottage (Cottage Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    137,
    46326,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000002",
    "Keju Cottage yang Ditambah Krim (Creamed Cottage Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    138,
    46326,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000003",
    "Keju Krim (Cream Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    139,
    46326,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000004",
    "Keju Mozzarella",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    140,
    46326,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000005",
    "Keju Bocconcini",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    141,
    46326,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000006",
    "Keju Tanpa Pemeraman (Keju Mentah)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    142,
    46326,
    "0107",
    "Keju olahan",
    "010602010001",
    "Keju Cheddar",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    143,
    46326,
    "0107",
    "Keju olahan",
    "010602010002",
    "Keju Edam",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    144,
    46326,
    "0107",
    "Keju olahan",
    "010602010003",
    "Keju Camembert",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    145,
    46326,
    "0107",
    "Keju olahan",
    "010602010004",
    "Keju Bath",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    146,
    46326,
    "0107",
    "Keju olahan",
    "010602010005",
    "Keju Bondard",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    147,
    46326,
    "0107",
    "Keju olahan",
    "010602010006",
    "Keju Bougon",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    148,
    46326,
    "0107",
    "Keju olahan",
    "010602010007",
    "Keju Bouquet des moines",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    149,
    46326,
    "0107",
    "Keju olahan",
    "010602010008",
    "Keju Biru (Blue Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    150,
    46326,
    "0107",
    "Keju olahan",
    "010602010009",
    "Keju Bata (Brick Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    151,
    46326,
    "0107",
    "Keju olahan",
    "010602010010",
    "Keju Gouda",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    152,
    46326,
    "0107",
    "Keju olahan",
    "010602010011",
    "Keju Havarti",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    153,
    46326,
    "0107",
    "Keju olahan",
    "010602010012",
    "Keju Brie",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    154,
    46326,
    "0107",
    "Keju olahan",
    "010602010013",
    "Keju Parmesan",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    155,
    46326,
    "0107",
    "Keju olahan",
    "010602010014",
    "Keju Swiss",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    156,
    46326,
    "0107",
    "Keju olahan",
    "010602010015",
    "Keju Peram Lainnya",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    157,
    46326,
    "0107",
    "Keju olahan",
    "010602020001",
    "Kulit Keju Peram",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    158,
    46326,
    "0107",
    "Keju olahan",
    "010602030001",
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    159,
    46326,
    "0107",
    "Keju olahan",
    "010603000001",
    "Keju Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    160,
    46326,
    "0107",
    "Keju olahan",
    "010604000001",
    "Keju Olahan",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    161,
    46326,
    "0107",
    "Keju olahan",
    "010604010001",
    "Keju Olahan Plain",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    162,
    46326,
    "0107",
    "Keju olahan",
    "010604020001",
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    163,
    46326,
    "0107",
    "Keju olahan",
    "010605000001",
    "Analog Keju (Keju lemak nabati)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    164,
    46326,
    "0107",
    "Keju olahan",
    "010606000001",
    "Keju Protein Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    165,
    46326,
    "0105",
    "Es krim",
    "010700000001",
    "Es Krim Susu (Dairy Ice Cream)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    166,
    46326,
    "0105",
    "Es krim",
    "010700000002",
    "Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    167,
    46326,
    "0106",
    "Es susu / es mengandung susu",
    "010700000003",
    "Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    168,
    46326,
    "0121",
    "Premiks bentuk cair",
    "010700000004",
    "Premiks Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    169,
    46326,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "010700000004",
    "Premiks Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    170,
    46326,
    "0121",
    "Premiks bentuk cair",
    "010700000004",
    "Premiks Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    171,
    46326,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "010700000004",
    "Premiks Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    172,
    46326,
    "0121",
    "Premiks bentuk cair",
    "010700000005",
    "Premiks Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    173,
    46326,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "010700000005",
    "Premiks Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    174,
    46326,
    "0121",
    "Premiks bentuk cair",
    "010700000005",
    "Premiks Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    175,
    46326,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "010700000005",
    "Premiks Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    176,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010700000006",
    "Yogurt Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    177,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010700000007",
    "Yogurt Kultur Lain (Alternate Culture Yogurt)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    178,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000008",
    "Kefir",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    179,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010700000009",
    "Susu Fermentasi atau Susu Berkultur Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    180,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000010",
    "Junket",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    181,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000011",
    "Dulce de leche",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    182,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000012",
    "Puding Butterscotch/Puding Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    183,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000013",
    "Bubuk Puding Butterscotch/Puding Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    184,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000014",
    "Kembang Gula / Permen Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    185,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000015",
    "Makanan pencuci mulut berbasis susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    186,
    46326,
    "0104",
    "Cairan whey dan produknya, kecuali keju whey",
    "010801000001",
    "Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    187,
    46326,
    "0104",
    "Cairan whey dan produknya, kecuali keju whey",
    "010801000002",
    "Whey Asam",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    188,
    46326,
    "0101",
    "Bubuk whey dan produknya, kecuali keju whey",
    "010802000001",
    "Bubuk Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    189,
    46326,
    "0101",
    "Bubuk whey dan produknya, kecuali keju whey",
    "010802000002",
    "Bubuk Whey yang Telah Didemineralisasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    190,
    46326,
    "0101",
    "Bubuk whey dan produknya, kecuali keju whey",
    "010802000003",
    "Bubuk Whey Permeate",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    191,
    46326,
    "0209",
    "Pangan kategori 2 risiko sedang lainnya",
    "020101000001",
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    192,
    46326,
    "0204",
    "Ghee",
    "020101000002",
    "Ghee",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    193,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000001",
    "Lemak dan Minyak Nabati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    194,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000001",
    "Lemak dan Minyak Nabati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    195,
    46315,
    "0210",
    "Virgin oil",
    "020102000002",
    "Virgin Oil ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    196,
    46315,
    "0210",
    "Virgin oil",
    "020102000002",
    "Virgin Oil ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    197,
    46315,
    "0210",
    "Virgin oil",
    "020102000003",
    "Extra Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    198,
    46315,
    "0210",
    "Virgin oil",
    "020102000003",
    "Extra Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    199,
    46315,
    "0210",
    "Virgin oil",
    "020102000004",
    "Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    200,
    46315,
    "0210",
    "Virgin oil",
    "020102000004",
    "Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    201,
    46315,
    "0210",
    "Virgin oil",
    "020102000005",
    "Ordinary Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    202,
    46315,
    "0210",
    "Virgin oil",
    "020102000005",
    "Ordinary Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    203,
    46315,
    "0201",
    "Cold pressed oils",
    "020102000006",
    "Cold Pressed Oils",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    204,
    46315,
    "0201",
    "Cold pressed oils",
    "020102000006",
    "Cold Pressed Oils",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    205,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000007",
    "Minyak Goreng (Frying oil) ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    206,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000007",
    "Minyak Goreng (Frying oil) ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    207,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000008",
    "Minyak Goreng Padat (Frying Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    208,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000008",
    "Minyak Goreng Padat (Frying Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    209,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000008",
    "Minyak Goreng Padat (Frying Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    210,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000009",
    "Minyak Masak atau Minyak Sayur (Cooking Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    211,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000009",
    "Minyak Masak atau Minyak Sayur (Cooking Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    212,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000010",
    "Minyak Salad (Salad Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    213,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000010",
    "Minyak Salad (Salad Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    214,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000011",
    "Serbuk Lemak Nabati (Fat Powder)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    215,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000012",
    "Vanaspati atau Minyak Samin (Vegetable Ghee)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    216,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000012",
    "Vanaspati atau Minyak Samin (Vegetable Ghee)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    217,
    46315,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    218,
    46315,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    219,
    46315,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000014",
    "Pengganti Minyak Mentega (Butter Oil Substitute)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    220,
    46315,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000014",
    "Pengganti Minyak Mentega (Butter Oil Substitute)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    221,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000015",
    "Minyak Inti Kelapa Sawit Mentah (Crude Palm Kernel Oil/CPKO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    222,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000016",
    "Minyak Inti Kelapa Sawit (Refined Bleached Deodorized Palm Kernel Oil/RBDPKO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    223,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000017",
    "Minyak Kelapa Sawit Mentah (Crude Palm Oil/CPO) atau Pretreated Palm Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    224,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000018",
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    225,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000018",
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    226,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000019",
    "Minyak Olein Kelapa Sawit Mentah (Crude Palm Olein)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    227,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000020",
    "Minyak Stearin Kelapa Sawit Mentah (Crude Palm Stearin)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    228,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000021",
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    229,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000022",
    "Stearin Kelapa Sawit (Refined Bleached Deodorized Palm Stearin/RBDPS)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    230,
    46315,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    231,
    46315,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    232,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000024",
    "Minyak Kelapa Mentah atau Unrefined Coconut Oil/Crude Coconut Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    233,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000025",
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil )",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    234,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000026",
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/Refined Bleached Deodorized Groundnut Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    235,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000026",
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/Refined Bleached Deodorized Groundnut Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    236,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000027",
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    237,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000027",
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    238,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000028",
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    239,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000028",
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    240,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000029",
    "Minyak Kedelai (Refined Bleached Deodorized Soybean Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    241,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000029",
    "Minyak Kedelai (Refined Bleached Deodorized Soybean Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    242,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000030",
    "Minyak Wijen (Sesame Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    243,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000030",
    "Minyak Wijen (Sesame Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    244,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000031",
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    245,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000031",
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    246,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000032",
    "Minyak Safflower (Refined Bleached Deodorized Safflower Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    247,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000032",
    "Minyak Safflower (Refined Bleached Deodorized Safflower Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    248,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000033",
    "Minyak Biji Bunga Matahari (Refined Bleached Deodorized Sunflower Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    249,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000034",
    "Minyak Dedak atau Minyak Bekatul atau Minyak Katul (Refined Bleached Deodorized Rice Bran Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    250,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000035",
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    251,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000035",
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    252,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000036",
    "Rapeseed oil (turnip rape oil/colza oil/ravison oil/sarson oil/toria oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    253,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000036",
    "Rapeseed oil (turnip rape oil/colza oil/ravison oil/sarson oil/toria oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    254,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000037",
    "Rapeseed oil - low erucic acid (low erucic acid turnip rape oil/low erucic acid colza oil/canola oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    255,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000038",
    "Mustardseed Oil (Refined Bleached Deodorized Mustardseed Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    256,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000038",
    "Mustardseed Oil (Refined Bleached Deodorized Mustardseed Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    257,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000039",
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    258,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000001",
    "Lemak Hewani",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    259,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000002",
    "Lemak Babi atau Lard",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    260,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000003",
    "Rendered Pork Fat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    261,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000004",
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock))",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    262,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000005",
    "Lemak Sapi (Edible Beef Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    263,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000006",
    "Dripping atau Edible Tallow",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    264,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000007",
    "Secunda Beef Fat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    265,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000008",
    "Suet",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    266,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000009",
    "Minyak Ikan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    267,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000010",
    "Serbuk Lemak Hewani (Fat Powder)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    268,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000010",
    "Serbuk Lemak Hewani (Fat Powder)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    269,
    46326,
    "0202",
    "Emulsi lemak",
    "020201000001",
    "Mentega dan Konsentrat Mentega",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    270,
    46326,
    "0202",
    "Emulsi lemak",
    "020201000002",
    "Mentega (butter)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    271,
    46326,
    "0202",
    "Emulsi lemak",
    "020201000003",
    "Mentega Rekombinasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    272,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000001",
    "Margarin dan Produk Sejenis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    273,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000001",
    "Margarin dan Produk Sejenis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    274,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000002",
    "Margarin",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    275,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000003",
    "Campuran Margarin dan Mentega (Blends of butter and margarine)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    276,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000003",
    "Campuran Margarin dan Mentega (Blends of butter and margarine)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    277,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000004",
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    278,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000004",
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    279,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000005",
    "Minarin atau Halvarine",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    280,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000006",
    "Lemak Oles Loyang (Pan Release)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    281,
    46315,
    "0202",
    "Emulsi lemak",
    "020300000001",
    "Non-Dairy Toppings, Fillings, Frostings",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    282,
    46315,
    "0202",
    "Emulsi lemak",
    "020300000002",
    "Non-Dairy Whipped Cream",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    283,
    46315,
    "0203",
    "Es krim non-dairy",
    "020400000001",
    "Melorin atau Non-Dairy Ice Cream",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    284,
    46315,
    "0203",
    "Es krim non-dairy",
    "020400000001",
    "Melorin atau Non-Dairy Ice Cream",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    285,
    46315,
    "0203",
    "Es krim non-dairy",
    "020400000002",
    "Non-Dairy Mousse",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    286,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000001",
    "Es Batu Untuk Konsumsi ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    287,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000001",
    "Es Batu Untuk Konsumsi ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    288,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000002",
    "Water Ices",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    289,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000002",
    "Water Ices",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    290,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000003",
    "Es Mambo",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    291,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000004",
    "Es Stik (Ice Stick) atau Es Loli",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    292,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000005",
    "Es Buah (Fruit Ice)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    293,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000006",
    "Es Puter",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    294,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000007",
    "Es Lilin",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    295,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000008",
    "Es Kue",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    296,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000009",
    "Sorbet",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    297,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000010",
    "Sherbet",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    298,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000011",
    "Es Mengandung Susu ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    299,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000012",
    "Es Rasa Susu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    300,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000013",
    "Premiks Es Bentuk Bubuk ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    301,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000014",
    "Premiks Es Bentuk Cair ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    302,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000015",
    "Sediaan Cair Yang Akan Dikonsumsi Dalam Keadaan Beku",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    303,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102010001",
    "Buah Beku dengan Penambahan Bahan Pangan Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    304,
    46319,
    "0403",
    "Buah kering",
    "040102020001",
    "Buah Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    305,
    46319,
    "0403",
    "Buah kering",
    "040102020002",
    "Buah Kering Campur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    306,
    46319,
    "0403",
    "Buah kering",
    "040102020003",
    "Kopra",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    307,
    46319,
    "0403",
    "Buah kering",
    "040102020004",
    "Kelapa Parut Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    308,
    46319,
    "0403",
    "Buah kering",
    "040102020004",
    "Kelapa Parut Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    309,
    46319,
    "0403",
    "Buah kering",
    "040102020005",
    "Santan Bubuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    310,
    46319,
    "0403",
    "Buah kering",
    "040102020006",
    "Tepung Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    311,
    46319,
    "0403",
    "Buah kering",
    "040102020006",
    "Tepung Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    312,
    46339,
    "0410",
    "Manisan/asinan buah",
    "040102030001",
    "Buah Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    313,
    46339,
    "0410",
    "Manisan/asinan buah",
    "040102030002",
    "Asinan Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    314,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102030003",
    "Rujak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    315,
    46319,
    "0402",
    "Buah dalam kemasan",
    "040102040001",
    "Buah Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    316,
    46319,
    "0402",
    "Buah dalam kemasan",
    "040102040001",
    "Buah Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    317,
    46319,
    "0402",
    "Buah dalam kemasan",
    "040102040002",
    "Koktil Buah Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    318,
    46319,
    "0402",
    "Buah dalam kemasan",
    "040102040002",
    "Koktil Buah Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    319,
    46319,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040102050001",
    "Jem Buah atau Selai Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    320,
    46319,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040102050002",
    "Jeli Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    321,
    46319,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040102050003",
    "Marmalad",
    500000,
    400000,
    250000,
    "Aktif",
  ],
];
# END FRAGMENT id=data-idn_bpom_jenis_pangan_rba_importir

my $res = gen_read_table_func(
    name => 'bpom_list_food_types_rba_importer',
    summary => 'List food types in BPOM processed food division (RBA version, for importers)',
    table_data => $data_idn_bpom_jenis_pangan_rba_importir,
    table_spec => $meta_idn_bpom_jenis_pangan_rba_importir,
    description => <<'_',
_
    extra_props => {
        examples => [
        ],
    },
);
die "Can't generate function: $res->[0] - $res->[1]" unless $res->[0] == 200;

1;
# ABSTRACT: List food types in BPOM processed food division (RBA version, for importers)

__END__

=pod

=encoding UTF-8

=head1 NAME

App::BPOMUtils::Table::FoodTypeRBAImporter - List food types in BPOM processed food division (RBA version, for importers)

=head1 VERSION

This document describes version 0.018 of App::BPOMUtils::Table::FoodTypeRBAImporter (from Perl distribution App-BPOMUtils-Table-FoodType), released on 2023-02-14.

=head1 FUNCTIONS


=head2 bpom_list_food_types_rba_importer

Usage:

 bpom_list_food_types_rba_importer(%args) -> [$status_code, $reason, $payload, \%result_meta]

List food types in BPOM processed food division (RBA version, for importers).

This function is not exported by default, but exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<category_code> => I<str>

Only return records where the 'category_code' field equals specified value.

=item * B<category_code.contains> => I<str>

Only return records where the 'category_code' field contains specified text.

=item * B<category_code.in> => I<array[str]>

Only return records where the 'category_code' field is in the specified values.

=item * B<category_code.is> => I<str>

Only return records where the 'category_code' field equals specified value.

=item * B<category_code.isnt> => I<str>

Only return records where the 'category_code' field does not equal specified value.

=item * B<category_code.matches> => I<str>

Only return records where the 'category_code' field matches specified regular expression pattern.

=item * B<category_code.max> => I<str>

Only return records where the 'category_code' field is less than or equal to specified value.

=item * B<category_code.min> => I<str>

Only return records where the 'category_code' field is greater than or equal to specified value.

=item * B<category_code.not_contains> => I<str>

Only return records where the 'category_code' field does not contain specified text.

=item * B<category_code.not_in> => I<array[str]>

Only return records where the 'category_code' field is not in the specified values.

=item * B<category_code.not_matches> => I<str>

Only return records where the 'category_code' field does not match specified regular expression.

=item * B<category_code.xmax> => I<str>

Only return records where the 'category_code' field is less than specified value.

=item * B<category_code.xmin> => I<str>

Only return records where the 'category_code' field is greater than specified value.

=item * B<detail> => I<bool> (default: 0)

Return array of full records instead of just ID fields.

By default, only the key (ID) field is returned per result entry.

=item * B<dosage_form_code> => I<str>

Only return records where the 'dosage_form_code' field equals specified value.

=item * B<dosage_form_code.contains> => I<str>

Only return records where the 'dosage_form_code' field contains specified text.

=item * B<dosage_form_code.in> => I<array[str]>

Only return records where the 'dosage_form_code' field is in the specified values.

=item * B<dosage_form_code.is> => I<str>

Only return records where the 'dosage_form_code' field equals specified value.

=item * B<dosage_form_code.isnt> => I<str>

Only return records where the 'dosage_form_code' field does not equal specified value.

=item * B<dosage_form_code.matches> => I<str>

Only return records where the 'dosage_form_code' field matches specified regular expression pattern.

=item * B<dosage_form_code.max> => I<str>

Only return records where the 'dosage_form_code' field is less than or equal to specified value.

=item * B<dosage_form_code.min> => I<str>

Only return records where the 'dosage_form_code' field is greater than or equal to specified value.

=item * B<dosage_form_code.not_contains> => I<str>

Only return records where the 'dosage_form_code' field does not contain specified text.

=item * B<dosage_form_code.not_in> => I<array[str]>

Only return records where the 'dosage_form_code' field is not in the specified values.

=item * B<dosage_form_code.not_matches> => I<str>

Only return records where the 'dosage_form_code' field does not match specified regular expression.

=item * B<dosage_form_code.xmax> => I<str>

Only return records where the 'dosage_form_code' field is less than specified value.

=item * B<dosage_form_code.xmin> => I<str>

Only return records where the 'dosage_form_code' field is greater than specified value.

=item * B<dosage_form_name> => I<str>

Only return records where the 'dosage_form_name' field equals specified value.

=item * B<dosage_form_name.contains> => I<str>

Only return records where the 'dosage_form_name' field contains specified text.

=item * B<dosage_form_name.in> => I<array[str]>

Only return records where the 'dosage_form_name' field is in the specified values.

=item * B<dosage_form_name.is> => I<str>

Only return records where the 'dosage_form_name' field equals specified value.

=item * B<dosage_form_name.isnt> => I<str>

Only return records where the 'dosage_form_name' field does not equal specified value.

=item * B<dosage_form_name.matches> => I<str>

Only return records where the 'dosage_form_name' field matches specified regular expression pattern.

=item * B<dosage_form_name.max> => I<str>

Only return records where the 'dosage_form_name' field is less than or equal to specified value.

=item * B<dosage_form_name.min> => I<str>

Only return records where the 'dosage_form_name' field is greater than or equal to specified value.

=item * B<dosage_form_name.not_contains> => I<str>

Only return records where the 'dosage_form_name' field does not contain specified text.

=item * B<dosage_form_name.not_in> => I<array[str]>

Only return records where the 'dosage_form_name' field is not in the specified values.

=item * B<dosage_form_name.not_matches> => I<str>

Only return records where the 'dosage_form_name' field does not match specified regular expression.

=item * B<dosage_form_name.xmax> => I<str>

Only return records where the 'dosage_form_name' field is less than specified value.

=item * B<dosage_form_name.xmin> => I<str>

Only return records where the 'dosage_form_name' field is greater than specified value.

=item * B<exclude_fields> => I<array[str]>

Select fields to return.

=item * B<fields> => I<array[str]>

Select fields to return.

=item * B<id> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.in> => I<array[int]>

Only return records where the 'id' field is in the specified values.

=item * B<id.is> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.isnt> => I<int>

Only return records where the 'id' field does not equal specified value.

=item * B<id.max> => I<int>

Only return records where the 'id' field is less than or equal to specified value.

=item * B<id.min> => I<int>

Only return records where the 'id' field is greater than or equal to specified value.

=item * B<id.not_in> => I<array[int]>

Only return records where the 'id' field is not in the specified values.

=item * B<id.xmax> => I<int>

Only return records where the 'id' field is less than specified value.

=item * B<id.xmin> => I<int>

Only return records where the 'id' field is greater than specified value.

=item * B<kbli_code> => I<str>

Only return records where the 'kbli_code' field equals specified value.

=item * B<kbli_code.contains> => I<str>

Only return records where the 'kbli_code' field contains specified text.

=item * B<kbli_code.in> => I<array[str]>

Only return records where the 'kbli_code' field is in the specified values.

=item * B<kbli_code.is> => I<str>

Only return records where the 'kbli_code' field equals specified value.

=item * B<kbli_code.isnt> => I<str>

Only return records where the 'kbli_code' field does not equal specified value.

=item * B<kbli_code.matches> => I<str>

Only return records where the 'kbli_code' field matches specified regular expression pattern.

=item * B<kbli_code.max> => I<str>

Only return records where the 'kbli_code' field is less than or equal to specified value.

=item * B<kbli_code.min> => I<str>

Only return records where the 'kbli_code' field is greater than or equal to specified value.

=item * B<kbli_code.not_contains> => I<str>

Only return records where the 'kbli_code' field does not contain specified text.

=item * B<kbli_code.not_in> => I<array[str]>

Only return records where the 'kbli_code' field is not in the specified values.

=item * B<kbli_code.not_matches> => I<str>

Only return records where the 'kbli_code' field does not match specified regular expression.

=item * B<kbli_code.xmax> => I<str>

Only return records where the 'kbli_code' field is less than specified value.

=item * B<kbli_code.xmin> => I<str>

Only return records where the 'kbli_code' field is greater than specified value.

=item * B<mod_price> => I<float>

Only return records where the 'mod_price' field equals specified value.

=item * B<mod_price.in> => I<array[float]>

Only return records where the 'mod_price' field is in the specified values.

=item * B<mod_price.is> => I<float>

Only return records where the 'mod_price' field equals specified value.

=item * B<mod_price.isnt> => I<float>

Only return records where the 'mod_price' field does not equal specified value.

=item * B<mod_price.max> => I<float>

Only return records where the 'mod_price' field is less than or equal to specified value.

=item * B<mod_price.min> => I<float>

Only return records where the 'mod_price' field is greater than or equal to specified value.

=item * B<mod_price.not_in> => I<array[float]>

Only return records where the 'mod_price' field is not in the specified values.

=item * B<mod_price.xmax> => I<float>

Only return records where the 'mod_price' field is less than specified value.

=item * B<mod_price.xmin> => I<float>

Only return records where the 'mod_price' field is greater than specified value.

=item * B<new_reg_price> => I<float>

Only return records where the 'new_reg_price' field equals specified value.

=item * B<new_reg_price.in> => I<array[float]>

Only return records where the 'new_reg_price' field is in the specified values.

=item * B<new_reg_price.is> => I<float>

Only return records where the 'new_reg_price' field equals specified value.

=item * B<new_reg_price.isnt> => I<float>

Only return records where the 'new_reg_price' field does not equal specified value.

=item * B<new_reg_price.max> => I<float>

Only return records where the 'new_reg_price' field is less than or equal to specified value.

=item * B<new_reg_price.min> => I<float>

Only return records where the 'new_reg_price' field is greater than or equal to specified value.

=item * B<new_reg_price.not_in> => I<array[float]>

Only return records where the 'new_reg_price' field is not in the specified values.

=item * B<new_reg_price.xmax> => I<float>

Only return records where the 'new_reg_price' field is less than specified value.

=item * B<new_reg_price.xmin> => I<float>

Only return records where the 'new_reg_price' field is greater than specified value.

=item * B<queries> => I<array[str]>

Search.

This will search all searchable fields with one or more specified queries. Each
query can be in the form of C<-FOO> (dash prefix notation) to require that the
fields do not contain specified string, or C</FOO/> to use regular expression.
All queries must match if the C<query_boolean> option is set to C<and>; only one
query should match if the C<query_boolean> option is set to C<or>.

=item * B<query_boolean> => I<str> (default: "and")

Whether records must match all search queries ('and') or just one ('or').

If set to C<and>, all queries must match; if set to C<or>, only one query should
match. See the C<queries> option for more details on searching.

=item * B<random> => I<bool> (default: 0)

Return records in random order.

=item * B<rereg_price> => I<float>

Only return records where the 'rereg_price' field equals specified value.

=item * B<rereg_price.in> => I<array[float]>

Only return records where the 'rereg_price' field is in the specified values.

=item * B<rereg_price.is> => I<float>

Only return records where the 'rereg_price' field equals specified value.

=item * B<rereg_price.isnt> => I<float>

Only return records where the 'rereg_price' field does not equal specified value.

=item * B<rereg_price.max> => I<float>

Only return records where the 'rereg_price' field is less than or equal to specified value.

=item * B<rereg_price.min> => I<float>

Only return records where the 'rereg_price' field is greater than or equal to specified value.

=item * B<rereg_price.not_in> => I<array[float]>

Only return records where the 'rereg_price' field is not in the specified values.

=item * B<rereg_price.xmax> => I<float>

Only return records where the 'rereg_price' field is less than specified value.

=item * B<rereg_price.xmin> => I<float>

Only return records where the 'rereg_price' field is greater than specified value.

=item * B<result_limit> => I<int>

Only return a certain number of records.

=item * B<result_start> => I<int> (default: 1)

Only return starting from the n'th record.

=item * B<sort> => I<array[str]>

Order records according to certain field(s).

A list of field names separated by comma. Each field can be prefixed with '-' to
specify descending order instead of the default ascending.

=item * B<status> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.contains> => I<str>

Only return records where the 'status' field contains specified text.

=item * B<status.in> => I<array[str]>

Only return records where the 'status' field is in the specified values.

=item * B<status.is> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.isnt> => I<str>

Only return records where the 'status' field does not equal specified value.

=item * B<status.matches> => I<str>

Only return records where the 'status' field matches specified regular expression pattern.

=item * B<status.max> => I<str>

Only return records where the 'status' field is less than or equal to specified value.

=item * B<status.min> => I<str>

Only return records where the 'status' field is greater than or equal to specified value.

=item * B<status.not_contains> => I<str>

Only return records where the 'status' field does not contain specified text.

=item * B<status.not_in> => I<array[str]>

Only return records where the 'status' field is not in the specified values.

=item * B<status.not_matches> => I<str>

Only return records where the 'status' field does not match specified regular expression.

=item * B<status.xmax> => I<str>

Only return records where the 'status' field is less than specified value.

=item * B<status.xmin> => I<str>

Only return records where the 'status' field is greater than specified value.

=item * B<with_field_names> => I<bool>

Return field names in each record (as hashE<sol>associative array).

When enabled, function will return each record as hash/associative array
(field name => value pairs). Otherwise, function will return each record
as list/array (field value, field value, ...).


=back

Returns an enveloped result (an array).

First element ($status_code) is an integer containing HTTP-like status code
(200 means OK, 4xx caller error, 5xx function error). Second element
($reason) is a string containing error message, or something like "OK" if status is
200. Third element ($payload) is the actual result, but usually not present when enveloped result is an error response ($status_code is not 2xx). Fourth
element (%result_meta) is called result metadata and is optional, a hash
that contains extra information, much like how HTTP response headers provide additional metadata.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-BPOMUtils-Table-FoodType>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-BPOMUtils-Table-FoodType>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-BPOMUtils-Table-FoodType>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
