#!/usr/bin/perl

use strict;
use warnings;
use utf8;
use Test::More tests => 4;

use App::Music::ChordPro::Config;
use App::Music::ChordPro::Songbook;

our $config = App::Music::ChordPro::Config::configurator;
# Prevent a dummy {body} for chord grids.
$config->{diagrams}->{show} = 0;
my $s = App::Music::ChordPro::Songbook->new;

my $data = <<EOD;
{title: Swing Low Sweet Chariot}
EOD

eval { $s->parsefile(\$data) } or diag("$@");

ok( scalar( @{ $s->{songs} } ) == 1, "One song" );
isa_ok( $s->{songs}->[0], 'App::Music::ChordPro::Song', "It's a song" );

my $song = {
	    'settings' => {},
	    'meta' => {
		       'title' => [
				   'Swing Low Sweet Chariot'
				  ]
		      },
	    'title' => 'Swing Low Sweet Chariot',
	    'structure' => 'linear'
	   };

is_deeply( { %{ $s->{songs}->[0] } }, $song, "Song contents" );

$s = App::Music::ChordPro::Songbook->new;
$data = <<EOD;
{t: Swing Low Sweet Chariot}
EOD
eval { $s->parsefile(\$data) } or diag("$@");
is_deeply( { %{ $s->{songs}->[0] } }, $song, "Song contents" );
