BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Carp Encode File::Glob File::Path JSON::PP List::Util Module::CoreList Term::ANSIColor autodie strict version warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.024; 1}) {
    print "Perl 5.024 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v(dev).
use strict;
use warnings;
use 5.024;
use ExtUtils::MakeMaker 6.64;
use File::ShareDir::Install;
require "./inc/mymm.pl";

$File::ShareDir::Install::INCLUDE_DOTFILES = 1;
$File::ShareDir::Install::INCLUDE_DOTDIRS  = 1;
install_share dist => "share";

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Dist::Zilla plugin bundle used by Plicease",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker"     => "6.64",
    "File::ShareDir::Install" => "0.06"
  },
  "DISTNAME"         => "Dist-Zilla-PluginBundle-Author-Plicease",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.024",
  "NAME"             => "Dist::Zilla::PluginBundle::Author::Plicease",
  "PM"               => {
    "lib/Dist/Zilla/MintingProfile/Author/Plicease.pm"          => "\$(INST_LIB)/Dist/Zilla/MintingProfile/Author/Plicease.pm",
    "lib/Dist/Zilla/Plugin/Author/Plicease.pm"                  => "\$(INST_LIB)/Dist/Zilla/Plugin/Author/Plicease.pm",
    "lib/Dist/Zilla/Plugin/Author/Plicease/Core.pm"             => "\$(INST_LIB)/Dist/Zilla/Plugin/Author/Plicease/Core.pm",
    "lib/Dist/Zilla/Plugin/Author/Plicease/Init2.pm"            => "\$(INST_LIB)/Dist/Zilla/Plugin/Author/Plicease/Init2.pm",
    "lib/Dist/Zilla/Plugin/Author/Plicease/MakeMaker.pm"        => "\$(INST_LIB)/Dist/Zilla/Plugin/Author/Plicease/MakeMaker.pm",
    "lib/Dist/Zilla/Plugin/Author/Plicease/NoUnsafeInc.pm"      => "\$(INST_LIB)/Dist/Zilla/Plugin/Author/Plicease/NoUnsafeInc.pm",
    "lib/Dist/Zilla/Plugin/Author/Plicease/ReadmeAnyFromPod.pm" => "\$(INST_LIB)/Dist/Zilla/Plugin/Author/Plicease/ReadmeAnyFromPod.pm",
    "lib/Dist/Zilla/Plugin/Author/Plicease/SpecialPrereqs.pm"   => "\$(INST_LIB)/Dist/Zilla/Plugin/Author/Plicease/SpecialPrereqs.pm",
    "lib/Dist/Zilla/Plugin/Author/Plicease/Tests.pm"            => "\$(INST_LIB)/Dist/Zilla/Plugin/Author/Plicease/Tests.pm",
    "lib/Dist/Zilla/Plugin/Author/Plicease/Thanks.pm"           => "\$(INST_LIB)/Dist/Zilla/Plugin/Author/Plicease/Thanks.pm",
    "lib/Dist/Zilla/Plugin/Author/Plicease/Upload.pm"           => "\$(INST_LIB)/Dist/Zilla/Plugin/Author/Plicease/Upload.pm",
    "lib/Dist/Zilla/PluginBundle/Author/Plicease.pm"            => "\$(INST_LIB)/Dist/Zilla/PluginBundle/Author/Plicease.pm"
  },
  "PREREQ_PM" => {
    "Data::Section"                           => 0,
    "Dist::Zilla"                             => "6.00",
    "Dist::Zilla::Plugin::AutoMetaResources"  => "1.20",
    "Dist::Zilla::Plugin::CopyFilesFromBuild" => "0.150250",
    "Dist::Zilla::Plugin::InsertExample"      => "0.04",
    "Dist::Zilla::Plugin::InstallGuide"       => "1.200006",
    "Dist::Zilla::Plugin::MinimumPerl"        => "1.006",
    "Dist::Zilla::Plugin::OurPkgVersion"      => "0.12",
    "Dist::Zilla::Plugin::PodWeaver"          => "4.006",
    "Dist::Zilla::Plugin::ReadmeAnyFromPod"   => "0.150250",
    "Dist::Zilla::Plugin::Run::BeforeBuild"   => "0.035",
    "Dist::Zilla::Role::PluginBundle::Easy"   => 0,
    "Dist::Zilla::Role::TextTemplate"         => 0,
    "Dist::Zilla::Util::CurrentCmd"           => 0,
    "File::ShareDir::Dist"                    => 0,
    "File::Which"                             => 0,
    "File::chdir"                             => 0,
    "IPC::System::Simple"                     => "1.25",
    "Moose"                                   => 0,
    "Path::Tiny"                              => 0,
    "Perl::Tidy"                              => 0,
    "PerlX::Maybe"                            => "0.003",
    "Pod::Markdown"                           => "1.400",
    "Sub::Exporter::ForMethods"               => 0,
    "Test::Fixme"                             => "0.14",
    "Test::Pod"                               => "1.48",
    "Test::Pod::Coverage"                     => "1.10",
    "Test::Script"                            => "1.10",
    "Test::Version"                           => "2.00",
    "URI::Escape"                             => 0,
    "YAML"                                    => "1.15",
    "namespace::autoclean"                    => 0
  },
  "TEST_REQUIRES" => {
    "Test2::V0"    => "0.000060",
    "Test::More"   => "0.98",
    "Test::Script" => "1.10"
  },
  "VERSION" => "2.62",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

mymm::myWriteMakefile(%WriteMakefileArgs);

{
  package
    MY;
  use File::ShareDir::Install qw(postamble);
}