package Finance::SE::IDX::Static;

our $DATE = '2018-09-07'; # DATE
our $VERSION = '20180907.0.0'; # VERSION

use 5.010001;
use strict;
use warnings;

use Perinci::Sub::Gen::AccessTable::Simple qw(gen_read_table_func);

use Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(
                       list_idx_firms
                       list_idx_sectors
                       list_idx_boards
               );
our %SPEC;

# BEGIN FRAGMENT id=meta-idx_stock varname=meta
# note: This fragment is generated by a script. Do not edit manually!
# src-file: /zpool_host_mnt/mnt/home/s1/repos/gudangdata/bin/../table/idx_stock/meta.yaml
# src-revision: 51f1fa73d79829765e0c42c42b5471d95ccfcbfa (Fri Sep 7 22:32:35 2018 +0700)
# generate-date: Fri Sep  7 15:41:41 2018 UTC
# generated-by: update-fragments-in-perl-module
our $meta = {
  _note => "Automatically generated by gen-meta-yaml-from-data-tsv on Fri Sep  7 15:31:31 2018 UTC",
  fields => {
    board        => { pos => 5, schema => "str*", sortable => 1, summary => "board", unique => 0 },
    code         => { pos => 0, schema => "str*", sortable => 1, summary => "code", unique => 1 },
    listing_date => {
                      pos      => 3,
                      schema   => "str*",
                      sortable => 1,
                      summary  => "listing_date",
                      unique   => 0,
                    },
    name         => { pos => 2, schema => "str*", sortable => 1, summary => "name", unique => 0 },
    sector       => { pos => 1, schema => "str*", sortable => 1, summary => "sector", unique => 0 },
    shares       => { pos => 4, schema => "str*", sortable => 1, summary => "shares", unique => 0 },
  },
  header => 1,
  pk => "code",
  summary => "(Summary here)",
};
# END FRAGMENT id=meta-idx_stock

# BEGIN FRAGMENT id=data-idx_stock varname=data
# note: This fragment is generated by a script. Do not edit manually!
# src-file: /zpool_host_mnt/mnt/home/s1/repos/gudangdata/bin/../table/idx_stock/data.tsv
# src-revision: 51f1fa73d79829765e0c42c42b5471d95ccfcbfa (Fri Sep 7 22:32:35 2018 +0700)
# generate-date: Fri Sep  7 15:41:41 2018 UTC
# generated-by: update-fragments-in-perl-module
our $data = [
  [
    "AALI",
    "AGRI",
    "Astra Agro Lestari Tbk.",
    "1997-12-09",
    1924688333,
    "UTAMA",
  ],
  [
    "ABBA",
    "TRADE",
    "Mahaka Media Tbk.",
    "2002-04-03",
    2755125000,
    "PENGEMBANGAN",
  ],
  [
    "ABDA",
    "FINANCE",
    "Asuransi Bina Dana Arta Tbk.",
    "1989-07-06",
    620806680,
    "PENGEMBANGAN",
  ],
  [
    "ABMM",
    "TRADE",
    "ABM Investama Tbk.",
    "2011-12-06",
    2753165000,
    "UTAMA",
  ],
  [
    "ACES",
    "TRADE",
    "Ace Hardware Indonesia Tbk.",
    "2007-11-06",
    17150000000,
    "UTAMA",
  ],
  [
    "ACST",
    "PROPERTY",
    "Acset Indonusa Tbk.",
    "2013-06-24",
    700000000,
    "UTAMA",
  ],
  [
    "ADES",
    "CONSUMER",
    "Akasha Wira International Tbk.",
    "1994-06-13",
    589896800,
    "PENGEMBANGAN",
  ],
  [
    "ADHI",
    "PROPERTY",
    "Adhi Karya (Persero) Tbk.",
    "2004-03-18",
    3560849376,
    "UTAMA",
  ],
  [
    "ADMF",
    "FINANCE",
    "Adira Dinamika Multi Finance T",
    "2004-03-31",
    1000000000,
    "UTAMA",
  ],
  [
    "ADMG",
    "BASIC-IND",
    "Polychem Indonesia Tbk",
    "1993-10-20",
    3889179559,
    "UTAMA",
  ],
  [
    "ADRO",
    "MINING",
    "Adaro Energy Tbk.",
    "2008-07-16",
    31985962000,
    "UTAMA",
  ],
  [
    "AGII",
    "BASIC-IND",
    "Aneka Gas Industri Tbk.",
    "2016-09-28",
    3066660000,
  ],
  [
    "AGRO",
    "FINANCE",
    "Bank Rakyat Indonesia Agroniag",
    "2003-08-08",
    18269663129,
    "UTAMA",
  ],
  [
    "AGRS",
    "FINANCE",
    "Bank Agris Tbk.",
    "2014-12-22",
    5203614878,
    "PENGEMBANGAN",
  ],
  [
    "AHAP",
    "FINANCE",
    "Asuransi Harta Aman Pratama Tb",
    "1990-09-14",
    2940000000,
    "PENGEMBANGAN",
  ],
  [
    "AIMS",
    "TRADE",
    "Akbar Indo Makmur Stimec Tbk",
    "2001-07-20",
    220000000,
    "PENGEMBANGAN",
  ],
  [
    "AISA",
    "CONSUMER",
    "Tiga Pilar Sejahtera Food Tbk.",
    "1997-06-11",
    3218600000,
    "UTAMA",
  ],
  [
    "AKKU",
    "TRADE",
    "Anugerah Kagum Karya Utama Tbk",
    "2004-11-01",
    6449463636,
    "PENGEMBANGAN",
  ],
  [
    "AKPI",
    "BASIC-IND",
    "Argha Karya Prima Industry Tbk",
    "1992-12-18",
    680000000,
    "PENGEMBANGAN",
  ],
  [
    "AKRA",
    "TRADE",
    "AKR Corporindo Tbk.",
    "1994-10-03",
    4014694920,
    "UTAMA",
  ],
  [
    "AKSI",
    "INFRASTRUCT",
    "Majapahit Inti Corpora Tbk.",
    "2001-07-13",
    720000000,
    "PENGEMBANGAN",
  ],
  [
    "ALDO",
    "BASIC-IND",
    "Alkindo Naratama Tbk.",
    "2011-07-12",
    550000000,
    "PENGEMBANGAN",
  ],
  [
    "ALKA",
    "BASIC-IND",
    "Alakasa Industrindo Tbk",
    "1990-07-12",
    507665055,
    "PENGEMBANGAN",
  ],
  [
    "ALMI",
    "BASIC-IND",
    "Alumindo Light Metal Industry ",
    "1997-01-02",
    616000000,
    "PENGEMBANGAN",
  ],
  [
    "ALTO",
    "CONSUMER",
    "Tri Banyan Tirta Tbk.",
    "2012-07-10",
    2191870558,
    "UTAMA",
  ],
  [
    "AMAG",
    "FINANCE",
    "Asuransi Multi Artha Guna Tbk.",
    "2005-12-23",
    5001552516,
    "PENGEMBANGAN",
  ],
  [
    "AMFG",
    "BASIC-IND",
    "Asahimas Flat Glass Tbk.",
    "1995-11-08",
    434000000,
    "UTAMA",
  ],
  [
    "AMIN",
    "MISC-IND",
    "Ateliers Mecaniques D Indonesi",
    "2015-12-10",
    1080000000,
    "PENGEMBANGAN",
  ],
  [
    "AMRT",
    "TRADE",
    "Sumber Alfaria Trijaya Tbk.",
    "2009-01-15",
    41524501700,
    "UTAMA",
  ],
  [
    "ANDI",
    "AGRI",
    "Andira Agro Tbk.",
    "2018-08-16",
    1870000000,
    "PENGEMBANGAN",
  ],
  [
    "ANJT",
    "AGRI",
    "Austindo Nusantara Jaya Tbk.",
    "2013-05-08",
    3354175000,
    "UTAMA",
  ],
  [
    "ANTM",
    "MINING",
    "Aneka Tambang Tbk.",
    "1997-11-27",
    24030764725,
    "UTAMA",
  ],
  [
    "APEX",
    "MINING",
    "Apexindo Pratama Duta Tbk.",
    "2002-07-10",
    2659850000,
    "UTAMA",
  ],
  [
    "APIC",
    "FINANCE",
    "Pacific Strategic Financial Tb",
    "2002-12-18",
    11765963114,
    "PENGEMBANGAN",
  ],
  [
    "APII",
    "TRADE",
    "Arita Prima Indonesia Tbk.",
    "2013-10-29",
    1075760000,
    "PENGEMBANGAN",
  ],
  [
    "APLI",
    "BASIC-IND",
    "Asiaplast Industries Tbk.",
    "2000-05-01",
    1362671400,
    "UTAMA",
  ],
  [
    "APLN",
    "PROPERTY",
    "Agung Podomoro Land Tbk.",
    "2010-11-11",
    19364561700,
    "UTAMA",
  ],
  [
    "APOL",
    "INFRASTRUCT",
    "Arpeni Pratama Ocean Line Tbk.",
    "2005-06-22",
    8670479000,
    "UTAMA",
  ],
  [
    "ARGO",
    "MISC-IND",
    "Argo Pantes Tbk",
    "1991-01-07",
    335557450,
    "PENGEMBANGAN",
  ],
  [
    "ARII",
    "MINING",
    "Atlas Resources Tbk.",
    "2011-11-08",
    3000000000,
    "PENGEMBANGAN",
  ],
  [
    "ARMY",
    "PROPERTY",
    "Armidian Karyatama Tbk.",
    "2017-06-21",
    8187500000,
    "PENGEMBANGAN",
  ],
  [
    "ARNA",
    "BASIC-IND",
    "Arwana Citramulia Tbk.",
    "2001-07-17",
    7341430976,
    "UTAMA",
  ],
  [
    "ARTA",
    "TRADE",
    "Arthavest Tbk",
    "2002-11-05",
    446674175,
    "PENGEMBANGAN",
  ],
  [
    "ARTI",
    "MINING",
    "Ratu Prabu Energi Tbk",
    "2003-04-30",
    7840000000,
    "UTAMA",
  ],
  [
    "ARTO",
    "FINANCE",
    "Bank Artos Indonesia Tbk.",
    "2016-01-12",
    1194187500,
    "PENGEMBANGAN",
  ],
  [
    "ASBI",
    "FINANCE",
    "Asuransi Bintang Tbk.",
    "1989-11-29",
    348386472,
    "PENGEMBANGAN",
  ],
  [
    "ASDM",
    "FINANCE",
    "Asuransi Dayin Mitra Tbk.",
    "1989-12-15",
    192000000,
    "PENGEMBANGAN",
  ],
  [
    "ASGR",
    "TRADE",
    "Astra Graphia Tbk.",
    "1989-11-15",
    1348780500,
    "UTAMA",
  ],
  [
    "ASII",
    "MISC-IND",
    "Astra International Tbk.",
    "1990-04-04",
    40483553140,
    "UTAMA",
  ],
  [
    "ASJT",
    "FINANCE",
    "Asuransi Jasa Tania Tbk.",
    "2003-12-23",
    600000000,
    "PENGEMBANGAN",
  ],
  [
    "ASMI",
    "FINANCE",
    "Asuransi Kresna Mitra Tbk.",
    "2014-01-16",
    8958380460,
    "PENGEMBANGAN",
  ],
  [
    "ASRI",
    "PROPERTY",
    "Alam Sutera Realty Tbk.",
    "2007-12-18",
    19649411888,
    "UTAMA",
  ],
  [
    "ASRM",
    "FINANCE",
    "Asuransi Ramayana Tbk.",
    "1990-03-19",
    214559422,
    "PENGEMBANGAN",
  ],
  [
    "ASSA",
    "INFRASTRUCT",
    "Adi Sarana Armada Tbk.",
    "2012-11-12",
    3397500000,
    "UTAMA",
  ],
  [
    "ATIC",
    "TRADE",
    "Anabatic Technologies Tbk.",
    "2015-07-08",
    1875010000,
    "UTAMA",
  ],
  [
    "ATPK",
    "MINING",
    "Bara Jaya Internasional Tbk.",
    "2002-04-17",
    5760245414,
    "PENGEMBANGAN",
  ],
  [
    "AUTO",
    "MISC-IND",
    "Astra Otoparts Tbk.",
    "1998-06-15",
    4819733000,
    "UTAMA",
  ],
  [
    "BABP",
    "FINANCE",
    "Bank MNC Internasional Tbk.",
    "2002-07-15",
    21567203082,
    "PENGEMBANGAN",
  ],
  [
    "BACA",
    "FINANCE",
    "Bank Capital Indonesia Tbk.",
    "2007-10-04",
    6978884619,
    "PENGEMBANGAN",
  ],
  [
    "BAJA",
    "BASIC-IND",
    "Saranacentral Bajatama Tbk.",
    "2011-12-21",
    1800000000,
    "PENGEMBANGAN",
  ],
  [
    "BALI",
    "INFRASTRUCT",
    "Bali Towerindo Sentra Tbk.",
    "2014-03-13",
    3634476700,
    "PENGEMBANGAN",
  ],
  [
    "BAPA",
    "PROPERTY",
    "Bekasi Asri Pemula Tbk.",
    "2008-01-14",
    661784520,
    "UTAMA",
  ],
  [
    "BATA",
    "MISC-IND",
    "Sepatu Bata Tbk.",
    "1982-03-24",
    1300000000,
    "UTAMA",
  ],
  [
    "BAYU",
    "TRADE",
    "Bayu Buana Tbk",
    "1989-10-30",
    353220780,
    "PENGEMBANGAN",
  ],
  [
    "BBCA",
    "FINANCE",
    "Bank Central Asia Tbk.",
    "2000-05-31",
    24408459120,
    "UTAMA",
  ],
  [
    "BBHI",
    "FINANCE",
    "Bank Harda Internasional Tbk.",
    "2015-08-12",
    4142587477,
    "PENGEMBANGAN",
  ],
  [
    "BBKP",
    "FINANCE",
    "Bank Bukopin Tbk.",
    "2006-07-10",
    11535389661,
    "UTAMA",
  ],
  [
    "BBLD",
    "FINANCE",
    "Buana Finance Tbk.",
    "1990-05-07",
    1645796054,
    "PENGEMBANGAN",
  ],
  [
    "BBMD",
    "FINANCE",
    "Bank Mestika Dharma Tbk.",
    "2013-07-08",
    4049189100,
    "UTAMA",
  ],
  [
    "BBNI",
    "FINANCE",
    "Bank Negara Indonesia (Persero",
    "1996-11-25",
    18462169893,
    "UTAMA",
  ],
  [
    "BBNP",
    "FINANCE",
    "Bank Nusantara Parahyangan Tbk",
    "2001-01-10",
    791895641,
    "UTAMA",
  ],
  [
    "BBRI",
    "FINANCE",
    "Bank Rakyat Indonesia (Persero",
    "2003-11-10",
    122112351900,
    "UTAMA",
  ],
  [
    "BBRM",
    "INFRASTRUCT",
    "Pelayaran Nasional Bina Buana ",
    "2013-01-09",
    5367076248,
    "UTAMA",
  ],
  [
    "BBTN",
    "FINANCE",
    "Bank Tabungan Negara (Persero)",
    "2009-12-17",
    10484100000,
    "UTAMA",
  ],
  [
    "BBYB",
    "FINANCE",
    "Bank Yudha Bhakti Tbk.",
    "2015-01-13",
    5148129999,
    "UTAMA",
  ],
  [
    "BCAP",
    "FINANCE",
    "MNC Kapital Indonesia Tbk.",
    "2001-06-08",
    5504483888,
    "UTAMA",
  ],
  [
    "BCIC",
    "FINANCE",
    "Bank JTrust Indonesia Tbk.",
    "1997-06-25",
    28066675536,
    "PENGEMBANGAN",
  ],
  [
    "BCIP",
    "PROPERTY",
    "Bumi Citra Permai Tbk.",
    "2009-12-11",
    1429915525,
    "PENGEMBANGAN",
  ],
  [
    "BDMN",
    "FINANCE",
    "Bank Danamon Indonesia Tbk.",
    "1989-12-06",
    9488796931,
    "UTAMA",
  ],
  [
    "BEKS",
    "FINANCE",
    "Bank Pembangunan Daerah Banten",
    "2001-07-13",
    63468336053,
    "PENGEMBANGAN",
  ],
  [
    "BELL",
    "MISC-IND",
    "Trisula Textile Industries Tbk",
    "2017-10-03",
    1450000000,
    "PENGEMBANGAN",
  ],
  [
    "BEST",
    "PROPERTY",
    "Bekasi Fajar Industrial Estate",
    "2012-04-10",
    9647311150,
    "UTAMA",
  ],
  [
    "BFIN",
    "FINANCE",
    "BFI Finance  Indonesia Tbk.",
    "1990-05-16",
    15967115620,
    "PENGEMBANGAN",
  ],
  [
    "BGTG",
    "FINANCE",
    "Bank Ganesha Tbk.",
    "2016-05-12",
    11063309400,
    "PENGEMBANGAN",
  ],
  [
    "BHIT",
    "TRADE",
    "MNC Investama Tbk.",
    "1997-11-24",
    48057050367,
    "UTAMA",
  ],
  [
    "BIKA",
    "PROPERTY",
    "Binakarya Jaya Abadi Tbk.",
    "2015-07-14",
    592280000,
    "PENGEMBANGAN",
  ],
  [
    "BIMA",
    "MISC-IND",
    "Primarindo Asia Infrastructure",
    "1994-08-30",
    608175716,
    "PENGEMBANGAN",
  ],
  [
    "BINA",
    "FINANCE",
    "Bank Ina Perdana Tbk.",
    "2014-01-16",
    5597831250,
    "PENGEMBANGAN",
  ],
  [
    "BIPI",
    "MINING",
    "Benakat Integra Tbk.",
    "2010-02-11",
    40158987014,
    "PENGEMBANGAN",
  ],
  [
    "BIPP",
    "PROPERTY",
    "Bhuwanatala Indah Permai Tbk.",
    "1995-10-23",
    5028669338,
    "PENGEMBANGAN",
  ],
  [
    "BIRD",
    "INFRASTRUCT",
    "Blue Bird Tbk.",
    "2014-11-05",
    2502100000,
    "UTAMA",
  ],
  [
    "BISI",
    "AGRI",
    "BISI International Tbk.",
    "2007-05-28",
    3000000000,
    "UTAMA",
  ],
  [
    "BJBR",
    "FINANCE",
    "Bank Pembangunan Daerah Jawa B",
    "2010-07-08",
    9599328254,
    "UTAMA",
  ],
  [
    "BJTM",
    "FINANCE",
    "Bank Pembangunan Daerah Jawa T",
    "2012-07-12",
    14827259768,
    "UTAMA",
  ],
  [
    "BKDP",
    "PROPERTY",
    "Bukit Darmo Property Tbk",
    "2007-06-15",
    6830992252,
    "PENGEMBANGAN",
  ],
  [
    "BKSL",
    "PROPERTY",
    "Sentul City Tbk.",
    "1997-07-28",
    55258657723,
    "UTAMA",
  ],
  [
    "BKSW",
    "FINANCE",
    "Bank QNB Indonesia Tbk.",
    "2002-11-21",
    20232319124,
    "PENGEMBANGAN",
  ],
  [
    "BLTA",
    "INFRASTRUCT",
    "Berlian Laju Tanker Tbk",
    "1990-03-26",
    23483317538,
    "UTAMA",
  ],
  [
    "BLTZ",
    "TRADE",
    "Graha Layar Prima Tbk.",
    "2014-04-10",
    873937142,
    "PENGEMBANGAN",
  ],
  [
    "BMAS",
    "FINANCE",
    "Bank Maspion Indonesia Tbk.",
    "2013-07-11",
    4399026922,
    "PENGEMBANGAN",
  ],
  [
    "BMRI",
    "FINANCE",
    "Bank Mandiri (Persero) Tbk.",
    "2003-07-14",
    46199999998,
    "UTAMA",
  ],
  [
    "BMSR",
    "TRADE",
    "Bintang Mitra Semestaraya Tbk",
    "1999-12-29",
    1159200024,
    "UTAMA",
  ],
  [
    "BMTR",
    "TRADE",
    "Global Mediacom Tbk.",
    "1995-07-17",
    14198621422,
    "UTAMA",
  ],
  [
    "BNBA",
    "FINANCE",
    "Bank Bumi Arta Tbk.",
    "2006-06-01",
    2286900000,
    "PENGEMBANGAN",
  ],
  [
    "BNBR",
    "TRADE",
    "Bakrie & Brothers Tbk",
    "1989-08-28",
    12116043000,
    "PENGEMBANGAN",
  ],
  [
    "BNGA",
    "FINANCE",
    "Bank CIMB Niaga Tbk.",
    "1989-11-29",
    24880290775,
    "UTAMA",
  ],
  [
    "BNII",
    "FINANCE",
    "Bank Maybank Indonesia Tbk.",
    "1989-11-21",
    75452740789,
    "UTAMA",
  ],
  [
    "BNLI",
    "FINANCE",
    "Bank Permata Tbk.",
    "1990-01-15",
    27762311813,
    "UTAMA",
  ],
  [
    "BOGA",
    "TRADE",
    "Bintang Oto Global Tbk.",
    "2016-12-19",
    3803247605,
    "PENGEMBANGAN",
  ],
  [
    "BOLT",
    "MISC-IND",
    "Garuda Metalindo Tbk.",
    "2015-07-07",
    2343750000,
    "PENGEMBANGAN",
  ],
  [
    "BORN",
    "MINING",
    "Borneo Lumbung Energi & Metal ",
    "2010-11-26",
    17693000000,
    "PENGEMBANGAN",
  ],
  [
    "BOSS",
    "MINING",
    "Borneo Olah Sarana Sukses Tbk.",
    "2018-02-15",
    1400000000,
    "PENGEMBANGAN",
  ],
  [
    "BPFI",
    "FINANCE",
    "Batavia Prosperindo Finance Tb",
    "2009-06-01",
    1782663575,
    "PENGEMBANGAN",
  ],
  [
    "BPII",
    "FINANCE",
    "Batavia Prosperindo Internasio",
    "2014-07-08",
    514010900,
    "PENGEMBANGAN",
  ],
  [
    "BPTR",
    "INFRASTRUCT",
    "Batavia Prosperindo Trans Tbk.",
    "2018-07-09",
    1550000000,
    "UTAMA",
  ],
  [
    "BRAM",
    "MISC-IND",
    "Indo Kordsa Tbk.",
    "1990-09-05",
    450000000,
    "UTAMA",
  ],
  [
    "BRIS",
    "FINANCE",
    "Bank BRIsyariah Tbk.",
    "1911-01-01",
    9618952363,
    "UTAMA",
  ],
  [
    "BRMS",
    "TRADE",
    "Bumi Resources Minerals Tbk.",
    "2010-12-09",
    62322456902,
    "PENGEMBANGAN",
  ],
  [
    "BRNA",
    "BASIC-IND",
    "Berlina Tbk.",
    "1989-11-06",
    979110000,
    "PENGEMBANGAN",
  ],
  [
    "BRPT",
    "BASIC-IND",
    "Barito Pacific Tbk.",
    "1993-10-01",
    17791586878,
    "UTAMA",
  ],
  [
    "BSDE",
    "PROPERTY",
    "Bumi Serpong Damai Tbk.",
    "2008-06-06",
    19246696192,
    "UTAMA",
  ],
  [
    "BSIM",
    "FINANCE",
    "Bank Sinarmas Tbk.",
    "2010-12-13",
    15183894786,
    "UTAMA",
  ],
  [
    "BSSR",
    "MINING",
    "Baramulti Suksessarana Tbk.",
    "2012-11-08",
    2616500000,
    "PENGEMBANGAN",
  ],
  [
    "BSWD",
    "FINANCE",
    "Bank Of India Indonesia Tbk.",
    "2002-05-01",
    1374912000,
    "PENGEMBANGAN",
  ],
  [
    "BTEK",
    "CONSUMER",
    "Bumi Teknokultura Unggul Tbk",
    "2004-05-14",
    46277496376,
    "PENGEMBANGAN",
  ],
  [
    "BTEL",
    "INFRASTRUCT",
    "Bakrie Telecom Tbk.",
    "2006-02-03",
    36773904635,
    "UTAMA",
  ],
  [
    "BTON",
    "BASIC-IND",
    "Betonjaya Manunggal Tbk.",
    "2001-07-18",
    720000000,
    "PENGEMBANGAN",
  ],
  [
    "BTPN",
    "FINANCE",
    "Bank Tabungan Pensiunan Nasion",
    "2008-03-12",
    5792554984,
    "UTAMA",
  ],
  [
    "BTPS",
    "FINANCE",
    "Bank Tabungan Pensiunan Nasion",
    "2018-05-08",
    7626663000,
    "UTAMA",
  ],
  [
    "BUDI",
    "CONSUMER",
    "Budi Starch & Sweetener Tbk.",
    "1995-05-08",
    4498997362,
    "UTAMA",
  ],
  [
    "BUKK",
    "INFRASTRUCT",
    "Bukaka Teknik Utama Tbk.",
    "2015-06-29",
    2640452000,
    "PENGEMBANGAN",
  ],
  [
    "BULL",
    "INFRASTRUCT",
    "Buana Lintas Lautan Tbk.",
    "2011-05-23",
    7298710018,
    "UTAMA",
  ],
  [
    "BUMI",
    "MINING",
    "Bumi Resources Tbk.",
    "1990-07-30",
    65475384020,
    "PENGEMBANGAN",
  ],
  [
    "BUVA",
    "TRADE",
    "Bukit Uluwatu Villa Tbk.",
    "2010-07-12",
    6811269200,
    "PENGEMBANGAN",
  ],
  [
    "BVIC",
    "FINANCE",
    "Bank Victoria International Tb",
    "1999-06-30",
    8592141624,
    "UTAMA",
  ],
  [
    "BWPT",
    "AGRI",
    "Eagle High Plantations Tbk.",
    "2009-10-27",
    31525291000,
    "UTAMA",
  ],
  [
    "BYAN",
    "MINING",
    "Bayan Resources Tbk.",
    "2008-08-12",
    3333333500,
    "UTAMA",
  ],
  [
    "CAMP",
    "CONSUMER",
    "Campina Ice Cream Industry Tbk",
    "2017-12-19",
    5885000000,
    "PENGEMBANGAN",
  ],
  [
    "CANI",
    "INFRASTRUCT",
    "Capitol Nusantara Indonesia Tb",
    "2014-01-16",
    833440000,
    "UTAMA",
  ],
  [
    "CARS",
    "TRADE",
    "Industri dan Perdagangan Bintr",
    "2017-04-10",
    1500000000,
    "PENGEMBANGAN",
  ],
  [
    "CASA",
    "FINANCE",
    "Capital Financial Indonesia Tb",
    "2016-07-19",
    54253986337,
    "PENGEMBANGAN",
  ],
  [
    "CASS",
    "INFRASTRUCT",
    "Cardig Aero Services Tbk.",
    "2011-12-05",
    2086950000,
    "PENGEMBANGAN",
  ],
  [
    "CEKA",
    "CONSUMER",
    "Wilmar Cahaya Indonesia Tbk.",
    "1996-07-09",
    595000000,
    "UTAMA",
  ],
  [
    "CENT",
    "INFRASTRUCT",
    "Centratama Telekomunikasi Indo",
    "2001-11-01",
    31183464900,
    "PENGEMBANGAN",
  ],
  [
    "CFIN",
    "FINANCE",
    "Clipan Finance Indonesia Tbk.",
    "1990-10-02",
    3984520457,
    "UTAMA",
  ],
  [
    "CINT",
    "CONSUMER",
    "Chitose Internasional Tbk.",
    "2014-06-27",
    1000000000,
    "PENGEMBANGAN",
  ],
  [
    "CITA",
    "MINING",
    "Cita Mineral Investindo Tbk.",
    "2002-03-20",
    3370734900,
    "PENGEMBANGAN",
  ],
  [
    "CKRA",
    "MINING",
    "Cakra Mineral Tbk.",
    "1999-05-19",
    5106021090,
    "PENGEMBANGAN",
  ],
  [
    "CLEO",
    "CONSUMER",
    "Sariguna Primatirta Tbk.",
    "2017-05-05",
    11000000000,
    "PENGEMBANGAN",
  ],
  [
    "CLPI",
    "TRADE",
    "Colorpak Indonesia Tbk.",
    "2001-11-30",
    306338500,
    "PENGEMBANGAN",
  ],
  [
    "CMNP",
    "INFRASTRUCT",
    "Citra Marga Nusaphala Persada ",
    "1995-01-10",
    3345831944,
    "UTAMA",
  ],
  [
    "CMPP",
    "INFRASTRUCT",
    "AirAsia Indonesia Tbk.",
    "1994-12-08",
    10685124441,
    "PENGEMBANGAN",
  ],
  [
    "CNKO",
    "TRADE",
    "Exploitasi Energi Indonesia Tb",
    "2001-11-20",
    8956361206,
    "UTAMA",
  ],
  [
    "CNTX",
    "MISC-IND",
    "Century Textile Industry Tbk.",
    "1979-05-22",
    70000000,
    "PENGEMBANGAN",
  ],
  [
    "COWL",
    "PROPERTY",
    "Cowell Development Tbk.",
    "2007-12-19",
    4871214021,
    "PENGEMBANGAN",
  ],
  [
    "CPIN",
    "BASIC-IND",
    "Charoen Pokphand Indonesia Tbk",
    "1991-03-18",
    16398000000,
    "UTAMA",
  ],
  [
    "CPRO",
    "BASIC-IND",
    "Central Proteina Prima Tbk.",
    "2006-11-28",
    59572382787,
    "UTAMA",
  ],
  [
    "CSAP",
    "TRADE",
    "Catur Sentosa Adiprana Tbk.",
    "2007-12-12",
    4458352920,
    "UTAMA",
  ],
  [
    "CSIS",
    "PROPERTY",
    "Cahayasakti Investindo Sukses ",
    "2017-05-10",
    1307000000,
    "PENGEMBANGAN",
  ],
  [
    "CTBN",
    "BASIC-IND",
    "Citra Tubindo Tbk.",
    "1989-11-28",
    800371500,
    "UTAMA",
  ],
  [
    "CTRA",
    "PROPERTY",
    "Ciputra Development Tbk.",
    "1994-03-28",
    18560303397,
    "UTAMA",
  ],
  [
    "CTTH",
    "MINING",
    "Citatah Tbk.",
    "1996-07-03",
    1230839821,
    "PENGEMBANGAN",
  ],
  [
    "DART",
    "PROPERTY",
    "Duta Anggada Realty Tbk.",
    "1990-05-08",
    3141390962,
    "UTAMA",
  ],
  [
    "DAYA",
    "TRADE",
    "Duta Intidaya Tbk.",
    "2016-06-28",
    2420547025,
    "PENGEMBANGAN",
  ],
  [
    "DEFI",
    "FINANCE",
    "Danasupra Erapacific Tbk",
    "2001-07-06",
    676000000,
    "PENGEMBANGAN",
  ],
  [
    "DEWA",
    "MINING",
    "Darma Henwa Tbk",
    "2007-09-26",
    21853733792,
    "UTAMA",
  ],
  [
    "DFAM",
    "TRADE",
    "Dafam Property Indonesia Tbk.",
    "2018-04-27",
    1600000000,
    "PENGEMBANGAN",
  ],
  [
    "DGIK",
    "PROPERTY",
    "Nusa Konstruksi Enjiniring Tbk",
    "2007-12-19",
    5541165000,
    "UTAMA",
  ],
  [
    "DILD",
    "PROPERTY",
    "Intiland Development Tbk.",
    "1991-09-04",
    10365854185,
    "UTAMA",
  ],
  [
    "DKFT",
    "MINING",
    "Central Omega Resources Tbk.",
    "1997-11-21",
    5638246600,
    "PENGEMBANGAN",
  ],
  [
    "DLTA",
    "CONSUMER",
    "Delta Djakarta Tbk.",
    "1984-02-12",
    800659050,
    "UTAMA",
  ],
  [
    "DMAS",
    "PROPERTY",
    "Puradelta Lestari Tbk.",
    "2015-05-29",
    48198111100,
    "UTAMA",
  ],
  [
    "DNAR",
    "FINANCE",
    "Bank Dinar Indonesia Tbk.",
    "2014-07-11",
    2227500000,
    "UTAMA",
  ],
  [
    "DNET",
    "TRADE",
    "Indoritel Makmur Internasional",
    "2000-12-11",
    14184000000,
    "PENGEMBANGAN",
  ],
  [
    "DOID",
    "MINING",
    "Delta Dunia Makmur Tbk.",
    "2001-06-15",
    8564339532,
    "PENGEMBANGAN",
  ],
  [
    "DPNS",
    "BASIC-IND",
    "Duta Pertiwi Nusantara Tbk.",
    "1990-08-08",
    331129952,
    "UTAMA",
  ],
  [
    "DPUM",
    "TRADE",
    "Dua Putra Utama Makmur Tbk.",
    "2015-12-08",
    4175000000,
    "UTAMA",
  ],
  [
    "DSFI",
    "AGRI",
    "Dharma Samudera Fishing Indust",
    "2000-03-24",
    1857135500,
    "UTAMA",
  ],
  [
    "DSNG",
    "AGRI",
    "Dharma Satya Nusantara Tbk.",
    "2013-06-14",
    10599842400,
    "UTAMA",
  ],
  [
    "DSSA",
    "MINING",
    "Dian Swastatika Sentosa Tbk",
    "2009-12-10",
    770552320,
    "UTAMA",
  ],
  [
    "DUTI",
    "PROPERTY",
    "Duta Pertiwi Tbk",
    "1994-11-02",
    1850000000,
    "PENGEMBANGAN",
  ],
  [
    "DVLA",
    "CONSUMER",
    "Darya-Varia Laboratoria Tbk.",
    "1994-11-11",
    1120000000,
    "UTAMA",
  ],
  [
    "DWGL",
    "TRADE",
    "Dwi Guna Laksana Tbk.",
    "2017-12-13",
    8637564799,
    "PENGEMBANGAN",
  ],
  [
    "DYAN",
    "TRADE",
    "Dyandra Media International Tb",
    "2013-03-25",
    4272964279,
    "UTAMA",
  ],
  [
    "ECII",
    "TRADE",
    "Electronic City Indonesia Tbk.",
    "2013-07-03",
    1334333000,
    "PENGEMBANGAN",
  ],
  [
    "EKAD",
    "BASIC-IND",
    "Ekadharma International Tbk.",
    "1990-08-14",
    698775000,
    "UTAMA",
  ],
  [
    "ELSA",
    "MINING",
    "Elnusa Tbk.",
    "2008-02-06",
    7298500000,
    "UTAMA",
  ],
  [
    "ELTY",
    "PROPERTY",
    "Bakrieland Development Tbk.",
    "1995-10-30",
    43521913019,
    "PENGEMBANGAN",
  ],
  [
    "EMDE",
    "PROPERTY",
    "Megapolitan Developments Tbk.",
    "2011-01-12",
    3350000000,
    "PENGEMBANGAN",
  ],
  [
    "EMTK",
    "TRADE",
    "Elang Mahkota Teknologi Tbk.",
    "2010-01-12",
    5640032442,
    "UTAMA",
  ],
  [
    "ENRG",
    "MINING",
    "Energi Mega Persada Tbk.",
    "2004-06-07",
    10342179272,
    "PENGEMBANGAN",
  ],
  [
    "EPMT",
    "TRADE",
    "Enseval Putera Megatrading Tbk",
    "1994-08-01",
    2708640000,
    "PENGEMBANGAN",
  ],
  [
    "ERAA",
    "TRADE",
    "Erajaya Swasembada Tbk.",
    "2011-12-14",
    3190000000,
    "UTAMA",
  ],
  [
    "ERTX",
    "MISC-IND",
    "Eratex Djaja Tbk.",
    "1990-08-21",
    1286539792,
    "PENGEMBANGAN",
  ],
  [
    "ESSA",
    "MINING",
    "Surya Esa Perkasa Tbk.",
    "2012-02-01",
    14300000000,
    "UTAMA",
  ],
  [
    "ESTI",
    "MISC-IND",
    "Ever Shine Tex Tbk.",
    "1992-10-13",
    2015208720,
    "UTAMA",
  ],
  [
    "ETWA",
    "BASIC-IND",
    "Eterindo Wahanatama Tbk",
    "1997-05-16",
    968297000,
    "UTAMA",
  ],
  [
    "EXCL",
    "INFRASTRUCT",
    "XL Axiata Tbk.",
    "2005-09-29",
    10687960423,
    "UTAMA",
  ],
  [
    "FAST",
    "TRADE",
    "Fast Food Indonesia Tbk.",
    "1993-05-11",
    1995138579,
    "PENGEMBANGAN",
  ],
  [
    "FASW",
    "BASIC-IND",
    "Fajar Surya Wisesa Tbk.",
    "1994-12-01",
    2477888787,
    "UTAMA",
  ],
  [
    "FILM",
    "TRADE",
    "MD Pictures Tbk.",
    "2018-08-07",
    9511217000,
    "UTAMA",
  ],
  [
    "FINN",
    "FINANCE",
    "First Indo American Leasing Tb",
    "2017-06-08",
    1860225000,
    "PENGEMBANGAN",
  ],
  [
    "FIRE",
    "MINING",
    "Alfa Energi Investama Tbk.",
    "2017-06-09",
    1305782780,
    "PENGEMBANGAN",
  ],
  [
    "FISH",
    "TRADE",
    "FKS Multi Agro Tbk.",
    "2002-01-18",
    480000000,
    "PENGEMBANGAN",
  ],
  [
    "FMII",
    "PROPERTY",
    "Fortune Mate Indonesia Tbk",
    "2000-06-30",
    2721000000,
    "PENGEMBANGAN",
  ],
  [
    "FORU",
    "TRADE",
    "Fortune Indonesia Tbk",
    "2004-01-17",
    465224000,
    "PENGEMBANGAN",
  ],
  [
    "FORZ",
    "PROPERTY",
    "Forza Land Indonesia Tbk.",
    "2017-04-28",
    1914896950,
    "UTAMA",
  ],
  [
    "FPNI",
    "BASIC-IND",
    "Lotte Chemical Titan Tbk.",
    "2002-03-21",
    5566414000,
    "PENGEMBANGAN",
  ],
  [
    "FREN",
    "INFRASTRUCT",
    "Smartfren Telecom Tbk.",
    "2006-11-29",
    103705870101,
    "UTAMA",
  ],
  [
    "GAMA",
    "PROPERTY",
    "Gading Development Tbk.",
    "2012-07-11",
    10011027656,
    "UTAMA",
  ],
  [
    "GDST",
    "BASIC-IND",
    "Gunawan Dianjaya Steel Tbk.",
    "2009-12-23",
    8200000000,
    "PENGEMBANGAN",
  ],
  [
    "GDYR",
    "MISC-IND",
    "Goodyear Indonesia Tbk.",
    "1980-12-01",
    410000000,
    "UTAMA",
  ],
  [
    "GEMA",
    "TRADE",
    "Gema Grahasarana Tbk.",
    "2002-08-12",
    1600000000,
    "PENGEMBANGAN",
  ],
  [
    "GEMS",
    "MINING",
    "Golden Energy Mines Tbk.",
    "2011-11-17",
    5882353000,
    "UTAMA",
  ],
  [
    "GGRM",
    "CONSUMER",
    "Gudang Garam Tbk.",
    "1990-08-27",
    1924088000,
    "UTAMA",
  ],
  [
    "GHON",
    "INFRASTRUCT",
    "Gihon Telekomunikasi Indonesia",
    "2018-04-09",
    550000000,
    "UTAMA",
  ],
  [
    "GIAA",
    "INFRASTRUCT",
    "Garuda Indonesia (Persero) Tbk",
    "2011-02-11",
    25886576254,
    "UTAMA",
  ],
  [
    "GJTL",
    "MISC-IND",
    "Gajah Tunggal Tbk.",
    "1990-05-08",
    3484800000,
    "UTAMA",
  ],
  [
    "GLOB",
    "TRADE",
    "Global Teleshop Tbk.",
    "2012-07-10",
    1111112000,
    "PENGEMBANGAN",
  ],
  [
    "GMCW",
    "TRADE",
    "Grahamas Citrawisata Tbk.",
    "1995-02-14",
    58839958,
    "PENGEMBANGAN",
  ],
  [
    "GMFI",
    "MISC-IND",
    "Garuda Maintenance Facility Ae",
    "2017-10-10",
    28233511500,
    "UTAMA",
  ],
  [
    "GMTD",
    "PROPERTY",
    "Gowa Makassar Tourism Developm",
    "2000-12-11",
    101538000,
    "PENGEMBANGAN",
  ],
  [
    "GOLD",
    "INFRASTRUCT",
    "Visi Telekomunikasi Infrastruk",
    "2010-07-07",
    314600000,
    "PENGEMBANGAN",
  ],
  [
    "GOLL",
    "AGRI",
    "Golden Plantation Tbk.",
    "2014-12-23",
    3665000759,
    "PENGEMBANGAN",
  ],
  [
    "GPRA",
    "PROPERTY",
    "Perdana Gapuraprima Tbk.",
    "2007-10-10",
    4276655336,
    "UTAMA",
  ],
  [
    "GREN",
    "TRADE",
    "Evergreen Invesco Tbk.",
    "2010-07-09",
    4694111791,
    "UTAMA",
  ],
  [
    "GSMF",
    "FINANCE",
    "Equity Development Investment ",
    "1989-10-13",
    7454723337,
    "PENGEMBANGAN",
  ],
  [
    "GTBO",
    "MINING",
    "Garda Tujuh Buana Tbk",
    "2009-07-09",
    2500000000,
    "PENGEMBANGAN",
  ],
  [
    "GWSA",
    "PROPERTY",
    "Greenwood Sejahtera Tbk.",
    "2011-12-23",
    7800760000,
    "UTAMA",
  ],
  [
    "GZCO",
    "AGRI",
    "Gozco Plantations Tbk.",
    "2008-05-15",
    6000000000,
    "UTAMA",
  ],
  [
    "HADE",
    "TRADE",
    "Himalaya Energi Perkasa Tbk.",
    "2004-04-12",
    2120000000,
    "PENGEMBANGAN",
  ],
  [
    "HDFA",
    "FINANCE",
    "Radana Bhaskara Finance Tbk.",
    "2011-05-10",
    2329668917,
    "UTAMA",
  ],
  [
    "HDTX",
    "MISC-IND",
    "Panasia Indo Resources Tbk.",
    "1990-06-06",
    3601462800,
    "UTAMA",
  ],
  [
    "HEAL",
    "TRADE",
    "Medikaloka Hermina Tbk.",
    "2018-05-16",
    2973000000,
    "UTAMA",
  ],
  [
    "HELI",
    "INFRASTRUCT",
    "Jaya Trishindo Tbk.",
    "2018-03-27",
    819000000,
    "PENGEMBANGAN",
  ],
  [
    "HERO",
    "TRADE",
    "Hero Supermarket Tbk.",
    "1989-12-02",
    4183634000,
    "UTAMA",
  ],
  [
    "HEXA",
    "TRADE",
    "Hexindo Adiperkasa Tbk.",
    "1995-02-13",
    840000000,
    "UTAMA",
  ],
  [
    "HITS",
    "INFRASTRUCT",
    "Humpuss Intermoda Transportasi",
    "1997-12-15",
    7101084801,
    "UTAMA",
  ],
  [
    "HMSP",
    "CONSUMER",
    "H.M. Sampoerna Tbk.",
    "1990-08-15",
    116318076900,
    "UTAMA",
  ],
  [
    "HOKI",
    "CONSUMER",
    "Buyung Poetra Sembada Tbk.",
    "2017-06-22",
    2370957920,
    "UTAMA",
  ],
  [
    "HOME",
    "TRADE",
    "Hotel Mandarine Regency Tbk.",
    "2008-07-17",
    2266550488,
    "PENGEMBANGAN",
  ],
  [
    "HOTL",
    "TRADE",
    "Saraswati Griya Lestari Tbk.",
    "2013-01-10",
    3550001452,
    "UTAMA",
  ],
  [
    "HRTA",
    "CONSUMER",
    "Hartadinata Abadi Tbk.",
    "2017-06-21",
    4605262400,
    "PENGEMBANGAN",
  ],
  [
    "HRUM",
    "MINING",
    "Harum Energy Tbk.",
    "2010-10-06",
    2703620000,
    "UTAMA",
  ],
  [
    "IATA",
    "INFRASTRUCT",
    "Indonesia Transport & Infrastr",
    "2006-09-13",
    9979518088,
    "PENGEMBANGAN",
  ],
  [
    "IBFN",
    "FINANCE",
    "Intan Baruprana Finance Tbk.",
    "2014-12-22",
    1322899281,
    "PENGEMBANGAN",
  ],
  [
    "IBST",
    "INFRASTRUCT",
    "Inti Bangun Sejahtera Tbk.",
    "2012-08-31",
    1350904927,
    "UTAMA",
  ],
  [
    "ICBP",
    "CONSUMER",
    "Indofood CBP Sukses Makmur Tbk",
    "2010-10-07",
    11661908000,
    "UTAMA",
  ],
  [
    "ICON",
    "TRADE",
    "Island Concepts Indonesia Tbk.",
    "2005-07-08",
    1089750000,
    "PENGEMBANGAN",
  ],
  [
    "IDPR",
    "PROPERTY",
    "Indonesia Pondasi Raya Tbk.",
    "2015-12-10",
    2003000000,
    "UTAMA",
  ],
  [
    "IGAR",
    "BASIC-IND",
    "Champion Pacific Indonesia Tbk",
    "1990-11-05",
    972204500,
    "UTAMA",
  ],
  [
    "IIKP",
    "CONSUMER",
    "Inti Agri Resources Tbk",
    "2002-10-20",
    33600000000,
    "PENGEMBANGAN",
  ],
  [
    "IKAI",
    "BASIC-IND",
    "Intikeramik Alamasri Industri ",
    "1997-06-04",
    8230391374,
    "UTAMA",
  ],
  [
    "IKBI",
    "MISC-IND",
    "Sumi Indo Kabel Tbk.",
    "1991-01-21",
    1224000000,
    "PENGEMBANGAN",
  ],
  [
    "IMAS",
    "MISC-IND",
    "Indomobil Sukses Internasional",
    "1993-09-15",
    2765278412,
    "UTAMA",
  ],
  [
    "IMJS",
    "FINANCE",
    "Indomobil Multi Jasa Tbk.",
    "2013-12-10",
    5017000000,
    "UTAMA",
  ],
  [
    "IMPC",
    "BASIC-IND",
    "Impack Pratama Industri Tbk.",
    "2014-12-17",
    4833500000,
    "PENGEMBANGAN",
  ],
  [
    "INAF",
    "CONSUMER",
    "Indofarma Tbk.",
    "2001-04-17",
    3099267500,
    "UTAMA",
  ],
  [
    "INAI",
    "BASIC-IND",
    "Indal Aluminium Industry Tbk.",
    "1994-12-05",
    633600000,
    "PENGEMBANGAN",
  ],
  [
    "INCF",
    "BASIC-IND",
    "Indo Komoditi Korpora Tbk.",
    "1989-12-18",
    1438370465,
    "PENGEMBANGAN",
  ],
  [
    "INCI",
    "BASIC-IND",
    "Intanwijaya Internasional Tbk",
    "1990-07-24",
    196121237,
    "UTAMA",
  ],
  [
    "INCO",
    "MINING",
    "Vale Indonesia Tbk.",
    "1990-05-16",
    9936338720,
    "UTAMA",
  ],
  [
    "INDF",
    "CONSUMER",
    "Indofood Sukses Makmur Tbk.",
    "1994-07-14",
    8780426500,
    "UTAMA",
  ],
  [
    "INDR",
    "MISC-IND",
    "Indo-Rama Synthetics Tbk.",
    "1990-08-03",
    654351707,
    "UTAMA",
  ],
  [
    "INDS",
    "MISC-IND",
    "Indospring Tbk.",
    "1990-08-10",
    656249710,
    "UTAMA",
  ],
  [
    "INDX",
    "TRADE",
    "Tanah Laut Tbk",
    "2001-05-17",
    437913588,
    "PENGEMBANGAN",
  ],
  [
    "INDY",
    "MINING",
    "Indika Energy Tbk.",
    "2008-06-11",
    5210192000,
    "UTAMA",
  ],
  [
    "INKP",
    "BASIC-IND",
    "Indah Kiat Pulp & Paper Tbk.",
    "1990-07-16",
    5470982941,
    "UTAMA",
  ],
  [
    "INPC",
    "FINANCE",
    "Bank Artha Graha Internasional",
    "1990-08-29",
    15638233052,
    "UTAMA",
  ],
  [
    "INPP",
    "TRADE",
    "Indonesian Paradise Property T",
    "2004-12-01",
    11181971732,
    "PENGEMBANGAN",
  ],
  [
    "INPS",
    "TRADE",
    "Indah Prakasa Sentosa Tbk.",
    "2018-04-06",
    650000000,
    "PENGEMBANGAN",
  ],
  [
    "INRU",
    "BASIC-IND",
    "Toba Pulp Lestari Tbk.",
    "1990-06-18",
    1388883283,
    "PENGEMBANGAN",
  ],
  [
    "INTA",
    "TRADE",
    "Intraco Penta Tbk.",
    "1993-08-23",
    3334622812,
    "PENGEMBANGAN",
  ],
  [
    "INTD",
    "TRADE",
    "Inter Delta Tbk",
    "1989-12-18",
    591828000,
    "PENGEMBANGAN",
  ],
  [
    "INTP",
    "BASIC-IND",
    "Indocement Tunggal Prakarsa Tb",
    "1989-12-05",
    3681231699,
    "UTAMA",
  ],
  [
    "IPCC",
    "INFRASTRUCT",
    "Indonesia Kendaraan Terminal T",
    "2018-07-09",
    1818384820,
    "PENGEMBANGAN",
  ],
  [
    "IPCM",
    "INFRASTRUCT",
    "Jasa Armada Indonesia Tbk.",
    "2017-12-22",
    5284811100,
    "PENGEMBANGAN",
  ],
  [
    "IPOL",
    "BASIC-IND",
    "Indopoly Swakarsa Industry Tbk",
    "2010-07-09",
    6443379509,
    "UTAMA",
  ],
  [
    "ISAT",
    "INFRASTRUCT",
    "Indosat Tbk.",
    "1994-10-19",
    5433933500,
    "UTAMA",
  ],
  [
    "ISSP",
    "BASIC-IND",
    "Steel Pipe Industry of Indones",
    "2013-02-22",
    7185992035,
    "UTAMA",
  ],
  [
    "ITMA",
    "TRADE",
    "Sumber Energi Andalan Tbk.",
    "1990-12-10",
    680000000,
    "PENGEMBANGAN",
  ],
  [
    "ITMG",
    "MINING",
    "Indo Tambangraya Megah Tbk.",
    "2007-12-18",
    1129925000,
    "UTAMA",
  ],
  [
    "ITTG",
    "TRADE",
    "Leo Investments Tbk.",
    "2001-11-26",
    1379000000,
    "PENGEMBANGAN",
  ],
  [
    "JAWA",
    "AGRI",
    "Jaya Agra Wattie Tbk.",
    "2011-05-30",
    3774685500,
    "UTAMA",
  ],
  [
    "JECC",
    "MISC-IND",
    "Jembo Cable Company Tbk.",
    "1992-11-18",
    151200000,
    "PENGEMBANGAN",
  ],
  [
    "JGLE",
    "TRADE",
    "Graha Andrasentra Propertindo ",
    "2016-06-29",
    22581909405,
    "PENGEMBANGAN",
  ],
  [
    "JIHD",
    "TRADE",
    "Jakarta International Hotels &",
    "1984-02-29",
    2329040482,
    "PENGEMBANGAN",
  ],
  [
    "JKON",
    "PROPERTY",
    "Jaya Konstruksi Manggala Prata",
    "2007-12-04",
    16308519860,
    "UTAMA",
  ],
  [
    "JKSW",
    "BASIC-IND",
    "Jakarta Kyoei Steel Works Tbk.",
    "1997-08-06",
    150000000,
    "PENGEMBANGAN",
  ],
  [
    "JMAS",
    "FINANCE",
    "Asuransi Jiwa Syariah Jasa Mit",
    "2017-12-18",
    1000000000,
    "PENGEMBANGAN",
  ],
  [
    "JPFA",
    "BASIC-IND",
    "Japfa Comfeed Indonesia Tbk.",
    "1989-10-23",
    11726575201,
    "UTAMA",
  ],
  [
    "JPRS",
    "BASIC-IND",
    "Jaya Pari Steel Tbk",
    "1989-08-08",
    750000000,
    "PENGEMBANGAN",
  ],
  [
    "JRPT",
    "PROPERTY",
    "Jaya Real Property Tbk.",
    "1994-06-29",
    13750000000,
    "UTAMA",
  ],
  [
    "JSKY",
    "MISC-IND",
    "Sky Energy Indonesia Tbk.",
    "2018-03-28",
    1016270000,
    "UTAMA",
  ],
  [
    "JSMR",
    "INFRASTRUCT",
    "Jasa Marga (Persero) Tbk.",
    "2007-11-12",
    7257871200,
    "UTAMA",
  ],
  [
    "JSPT",
    "TRADE",
    "Jakarta Setiabudi Internasiona",
    "1998-01-12",
    2318736000,
    "PENGEMBANGAN",
  ],
  [
    "JTPE",
    "TRADE",
    "Jasuindo Tiga Perkasa Tbk.",
    "2002-04-16",
    1713012500,
    "PENGEMBANGAN",
  ],
  [
    "KAEF",
    "CONSUMER",
    "Kimia Farma Tbk.",
    "2001-07-04",
    5554000000,
    "UTAMA",
  ],
  [
    "KARW",
    "INFRASTRUCT",
    "ICTSI Jasa Prima Tbk.",
    "2008-12-20",
    587152700,
    "PENGEMBANGAN",
  ],
  [
    "KBLI",
    "MISC-IND",
    "KMI Wire & Cable Tbk.",
    "1992-07-06",
    4007235107,
    "UTAMA",
  ],
  [
    "KBLM",
    "MISC-IND",
    "Kabelindo Murni Tbk.",
    "1992-06-01",
    1120000000,
    "PENGEMBANGAN",
  ],
  [
    "KBLV",
    "TRADE",
    "First Media Tbk.",
    "2000-02-25",
    1742167907,
    "PENGEMBANGAN",
  ],
  [
    "KBRI",
    "BASIC-IND",
    "Kertas Basuki Rachmat Indonesi",
    "2008-07-11",
    8687995734,
    "PENGEMBANGAN",
  ],
  [
    "KDSI",
    "BASIC-IND",
    "Kedawung Setia Industrial Tbk.",
    "1996-07-29",
    405000000,
    "PENGEMBANGAN",
  ],
  [
    "KIAS",
    "BASIC-IND",
    "Keramika Indonesia Assosiasi T",
    "1994-12-08",
    14929100000,
    "PENGEMBANGAN",
  ],
  [
    "KICI",
    "CONSUMER",
    "Kedaung Indah Can Tbk",
    "1993-10-28",
    276000000,
    "UTAMA",
  ],
  [
    "KIJA",
    "PROPERTY",
    "Kawasan Industri Jababeka Tbk.",
    "1995-01-10",
    20824888369,
    "UTAMA",
  ],
  [
    "KINO",
    "CONSUMER",
    "Kino Indonesia Tbk.",
    "2015-12-11",
    1428571500,
    "PENGEMBANGAN",
  ],
  [
    "KIOS",
    "TRADE",
    "Kioson Komersial Indonesia Tbk",
    "2017-10-05",
    717230800,
    "PENGEMBANGAN",
  ],
  [
    "KKGI",
    "MINING",
    "Resource Alam Indonesia Tbk.",
    "1991-07-01",
    5000000000,
    "UTAMA",
  ],
  [
    "KLBF",
    "CONSUMER",
    "Kalbe Farma Tbk.",
    "1991-07-30",
    46875122110,
    "UTAMA",
  ],
  [
    "KMTR",
    "BASIC-IND",
    "Kirana Megatara Tbk.",
    "2017-06-19",
    7682950000,
    "PENGEMBANGAN",
  ],
  [
    "KOBX",
    "TRADE",
    "Kobexindo Tractors Tbk.",
    "2012-07-05",
    2272500000,
    "UTAMA",
  ],
  [
    "KOIN",
    "TRADE",
    "Kokoh Inti Arebama Tbk",
    "2008-04-09",
    980843732,
    "PENGEMBANGAN",
  ],
  [
    "KONI",
    "TRADE",
    "Perdana Bangun Pusaka Tbk",
    "1995-08-22",
    152000000,
    "PENGEMBANGAN",
  ],
  [
    "KOPI",
    "INFRASTRUCT",
    "Mitra Energi Persada Tbk.",
    "2015-05-04",
    697266668,
    "PENGEMBANGAN",
  ],
  [
    "KPAL",
    "MISC-IND",
    "Steadfast Marine Tbk.",
    "2018-06-08",
    992170000,
    "UTAMA",
  ],
  [
    "KPIG",
    "TRADE",
    "MNC Land Tbk.",
    "2000-03-30",
    7407912279,
    "PENGEMBANGAN",
  ],
  [
    "KRAH",
    "MISC-IND",
    "Grand Kartech Tbk.",
    "2013-11-08",
    971190000,
    "PENGEMBANGAN",
  ],
  [
    "KRAS",
    "BASIC-IND",
    "Krakatau Steel (Persero) Tbk.",
    "2010-11-10",
    19346396900,
    "UTAMA",
  ],
  [
    "KREN",
    "TRADE",
    "Kresna Graha Investama Tbk.",
    "2002-06-28",
    18208470100,
    "UTAMA",
  ],
  [
    "LAND",
    "PROPERTY",
    "Trimitra Propertindo Tbk.",
    "2018-08-23",
    2792620000,
    "PENGEMBANGAN",
  ],
  [
    "LAPD",
    "INFRASTRUCT",
    "Leyand International Tbk.",
    "2001-07-17",
    3966350139,
    "PENGEMBANGAN",
  ],
  [
    "LCGP",
    "PROPERTY",
    "Eureka Prima Jakarta Tbk.",
    "2007-07-13",
    5630000914,
    "PENGEMBANGAN",
  ],
  [
    "LCKM",
    "INFRASTRUCT",
    "LCK Global Kedaton Tbk.",
    "2018-01-16",
    1000000000,
    "PENGEMBANGAN",
  ],
  [
    "LEAD",
    "INFRASTRUCT",
    "Logindo Samudramakmur Tbk.",
    "2013-12-11",
    4049616328,
    "UTAMA",
  ],
  [
    "LINK",
    "TRADE",
    "Link Net Tbk.",
    "2014-06-02",
    3042649384,
    "UTAMA",
  ],
  [
    "LION",
    "BASIC-IND",
    "Lion Metal Works Tbk.",
    "1993-08-20",
    520160000,
    "UTAMA",
  ],
  [
    "LMAS",
    "TRADE",
    "Limas Indonesia Makmur Tbk",
    "2001-12-28",
    787851525,
    "PENGEMBANGAN",
  ],
  [
    "LMPI",
    "CONSUMER",
    "Langgeng Makmur Industri Tbk.",
    "1994-10-17",
    1008517669,
    "PENGEMBANGAN",
  ],
  [
    "LMSH",
    "BASIC-IND",
    "Lionmesh Prima Tbk.",
    "1990-06-04",
    96000000,
    "PENGEMBANGAN",
  ],
  [
    "LPCK",
    "PROPERTY",
    "Lippo Cikarang Tbk",
    "1997-07-24",
    696000000,
    "UTAMA",
  ],
  [
    "LPGI",
    "FINANCE",
    "Lippo General Insurance Tbk.",
    "1997-07-22",
    150000000,
    "UTAMA",
  ],
  [
    "LPIN",
    "MISC-IND",
    "Multi Prima Sejahtera Tbk",
    "1990-02-05",
    106250000,
    "PENGEMBANGAN",
  ],
  [
    "LPKR",
    "PROPERTY",
    "Lippo Karawaci Tbk.",
    "1996-06-28",
    23077689619,
    "UTAMA",
  ],
  [
    "LPLI",
    "TRADE",
    "Star Pacific Tbk",
    "1989-10-23",
    1170432803,
    "PENGEMBANGAN",
  ],
  [
    "LPPF",
    "TRADE",
    "Matahari Department Store Tbk.",
    "1989-10-09",
    2917918080,
    "UTAMA",
  ],
  [
    "LPPS",
    "FINANCE",
    "Lippo Securities Tbk.",
    "1994-03-28",
    2588250000,
    "PENGEMBANGAN",
  ],
  [
    "LRNA",
    "INFRASTRUCT",
    "Eka Sari Lorena Transport Tbk.",
    "2014-04-15",
    350000022,
    "PENGEMBANGAN",
  ],
  [
    "LSIP",
    "AGRI",
    "PP London Sumatra Indonesia Tb",
    "1996-07-05",
    6822863965,
    "UTAMA",
  ],
  [
    "LTLS",
    "TRADE",
    "Lautan Luas Tbk.",
    "1997-07-21",
    1560000000,
    "UTAMA",
  ],
  [
    "MABA",
    "TRADE",
    "Marga Abhinaya Abadi Tbk.",
    "2017-06-22",
    15365229912,
    "PENGEMBANGAN",
  ],
  [
    "MAGP",
    "AGRI",
    "Multi Agro Gemilang Plantation",
    "2013-01-16",
    9000000004,
    "PENGEMBANGAN",
  ],
  [
    "MAIN",
    "BASIC-IND",
    "Malindo Feedmill Tbk.",
    "2006-02-10",
    2238750000,
    "UTAMA",
  ],
  [
    "MAMI",
    "TRADE",
    "Mas Murni Indonesia Tbk",
    "1994-02-09",
    5087239903,
    "PENGEMBANGAN",
  ],
  [
    "MAPA",
    "TRADE",
    "Map Aktif Adiperkasa Tbk.",
    "2018-07-05",
    2850400000,
    "PENGEMBANGAN",
  ],
  [
    "MAPB",
    "TRADE",
    "MAP Boga Adiperkasa Tbk.",
    "2017-06-21",
    2170922900,
    "PENGEMBANGAN",
  ],
  [
    "MAPI",
    "TRADE",
    "Mitra Adiperkasa Tbk.",
    "2004-11-10",
    16600000000,
    "UTAMA",
  ],
  [
    "MARI",
    "TRADE",
    "Mahaka Radio Integra Tbk.",
    "2016-02-11",
    5252644000,
    "PENGEMBANGAN",
  ],
  [
    "MARK",
    "BASIC-IND",
    "Mark Dynamics Indonesia Tbk.",
    "2017-07-12",
    760000062,
    "PENGEMBANGAN",
  ],
  [
    "MASA",
    "MISC-IND",
    "Multistrada Arah Sarana Tbk.",
    "2005-06-09",
    9182946945,
    "UTAMA",
  ],
  [
    "MAYA",
    "FINANCE",
    "Bank Mayapada Internasional Tb",
    "1997-08-29",
    5411269314,
    "UTAMA",
  ],
  [
    "MBAP",
    "MINING",
    "Mitrabara Adiperdana Tbk.",
    "2014-07-10",
    1227271952,
    "PENGEMBANGAN",
  ],
  [
    "MBSS",
    "INFRASTRUCT",
    "Mitrabahtera Segara Sejati Tbk",
    "2011-04-06",
    1750026639,
    "UTAMA",
  ],
  [
    "MBTO",
    "CONSUMER",
    "Martina Berto Tbk.",
    "2011-01-13",
    1070000000,
    "UTAMA",
  ],
  [
    "MCAS",
    "TRADE",
    "M Cash Integrasi Tbk.",
    "2017-11-01",
    867933300,
    "PENGEMBANGAN",
  ],
  [
    "MCOR",
    "FINANCE",
    "Bank China Construction Bank I",
    "2007-07-03",
    16465148150,
    "UTAMA",
  ],
  [
    "MDIA",
    "TRADE",
    "Intermedia Capital Tbk.",
    "2014-04-11",
    39215538400,
    "UTAMA",
  ],
  [
    "MDKA",
    "MINING",
    "Merdeka Copper Gold Tbk.",
    "2015-06-19",
    4164518330,
    "PENGEMBANGAN",
  ],
  [
    "MDKI",
    "BASIC-IND",
    "Emdeki Utama Tbk.",
    "2017-09-25",
    1807250000,
    "PENGEMBANGAN",
  ],
  [
    "MDLN",
    "PROPERTY",
    "Modernland Realty Tbk.",
    "1993-01-18",
    12533067322,
    "UTAMA",
  ],
  [
    "MDRN",
    "TRADE",
    "Modern Internasional Tbk.",
    "1991-07-16",
    5032167798,
    "UTAMA",
  ],
  [
    "MEDC",
    "MINING",
    "Medco Energi Internasional Tbk",
    "1994-10-12",
    17794301894,
    "UTAMA",
  ],
  [
    "MEGA",
    "FINANCE",
    "Bank Mega Tbk.",
    "2000-04-17",
    6894138227,
    "UTAMA",
  ],
  [
    "MERK",
    "CONSUMER",
    "Merck Tbk.",
    "1981-07-23",
    448000000,
    "PENGEMBANGAN",
  ],
  [
    "META",
    "INFRASTRUCT",
    "Nusantara Infrastructure Tbk.",
    "2001-07-18",
    15235671880,
    "UTAMA",
  ],
  [
    "MFIN",
    "FINANCE",
    "Mandala Multifinance Tbk.",
    "2005-09-06",
    2650000000,
    "PENGEMBANGAN",
  ],
  [
    "MFMI",
    "TRADE",
    "Multifiling Mitra Indonesia Tb",
    "2010-12-29",
    757581000,
    "PENGEMBANGAN",
  ],
  [
    "MGNA",
    "CONSUMER",
    "Magna Investama Mandiri Tbk.",
    "2014-07-07",
    1003080977,
    "PENGEMBANGAN",
  ],
  [
    "MGRO",
    "AGRI",
    "Mahkota Group Tbk.",
    "2018-07-12",
    3518438000,
    "UTAMA",
  ],
  [
    "MICE",
    "TRADE",
    "Multi Indocitra Tbk.",
    "2005-11-02",
    600000000,
    "PENGEMBANGAN",
  ],
  [
    "MIDI",
    "TRADE",
    "Midi Utama Indonesia Tbk.",
    "2010-11-30",
    2882353000,
    "PENGEMBANGAN",
  ],
  [
    "MIKA",
    "TRADE",
    "Mitra Keluarga Karyasehat Tbk.",
    "2015-03-24",
    14550736000,
    "UTAMA",
  ],
  [
    "MINA",
    "TRADE",
    "Sanurhasta Mitra Tbk.",
    "2017-04-28",
    6562500000,
    "PENGEMBANGAN",
  ],
  [
    "MIRA",
    "INFRASTRUCT",
    "Mitra International Resources ",
    "1997-01-30",
    3961452039,
    "PENGEMBANGAN",
  ],
  [
    "MITI",
    "MINING",
    "Mitra Investindo Tbk.",
    "1997-07-16",
    1411550800,
    "PENGEMBANGAN",
  ],
  [
    "MKNT",
    "TRADE",
    "Mitra Komunikasi Nusantara Tbk",
    "2015-10-26",
    5000000000,
    "PENGEMBANGAN",
  ],
  [
    "MKPI",
    "PROPERTY",
    "Metropolitan Kentjana Tbk.",
    "2009-07-10",
    948194000,
    "PENGEMBANGAN",
  ],
  [
    "MLBI",
    "CONSUMER",
    "Multi Bintang Indonesia Tbk.",
    "1994-01-17",
    2107000000,
    "UTAMA",
  ],
  [
    "MLIA",
    "BASIC-IND",
    "Mulia Industrindo Tbk",
    "1994-01-17",
    1323000000,
    "PENGEMBANGAN",
  ],
  [
    "MLPL",
    "TRADE",
    "Multipolar Tbk.",
    "1989-11-06",
    14639632470,
    "UTAMA",
  ],
  [
    "MLPT",
    "TRADE",
    "Multipolar Technology Tbk.",
    "2013-07-08",
    1875000000,
    "UTAMA",
  ],
  [
    "MMLP",
    "PROPERTY",
    "Mega Manunggal Property Tbk.",
    "2015-06-12",
    6889134608,
    "PENGEMBANGAN",
  ],
  [
    "MNCN",
    "TRADE",
    "Media Nusantara Citra Tbk.",
    "2007-06-22",
    14276103500,
    "UTAMA",
  ],
  [
    "MOLI",
    "BASIC-IND",
    "Madusari Murni Indah Tbk.",
    "2018-08-30",
    2334888498,
    "PENGEMBANGAN",
  ],
  [
    "MPMX",
    "TRADE",
    "Mitra Pinasthika Mustika Tbk.",
    "2013-05-29",
    4462963276,
    "UTAMA",
  ],
  [
    "MPOW",
    "INFRASTRUCT",
    "Megapower Makmur Tbk.",
    "2017-07-05",
    816997053,
    "PENGEMBANGAN",
  ],
  [
    "MPPA",
    "TRADE",
    "Matahari Putra Prima Tbk.",
    "1992-12-21",
    7529147920,
    "UTAMA",
  ],
  [
    "MRAT",
    "CONSUMER",
    "Mustika Ratu Tbk.",
    "1995-07-27",
    428000000,
    "UTAMA",
  ],
  [
    "MREI",
    "FINANCE",
    "Maskapai Reasuransi Indonesia ",
    "1989-09-04",
    517791681,
    "PENGEMBANGAN",
  ],
  [
    "MSIN",
    "TRADE",
    "MNC Studios International Tbk.",
    "2018-06-08",
    5202000000,
    "PENGEMBANGAN",
  ],
  [
    "MSKY",
    "TRADE",
    "MNC Sky Vision Tbk.",
    "2012-07-09",
    1813064073,
    "UTAMA",
  ],
  [
    "MTDL",
    "TRADE",
    "Metrodata Electronics Tbk.",
    "1990-04-09",
    2455376917,
    "UTAMA",
  ],
  [
    "MTFN",
    "FINANCE",
    "Capitalinc Investment Tbk.",
    "1990-04-16",
    31842082852,
    "PENGEMBANGAN",
  ],
  [
    "MTLA",
    "PROPERTY",
    "Metropolitan Land Tbk.",
    "2011-06-20",
    7655126330,
    "UTAMA",
  ],
  [
    "MTRA",
    "PROPERTY",
    "Mitra Pemuda Tbk.",
    "2016-02-10",
    770000000,
    "PENGEMBANGAN",
  ],
  [
    "MTSM",
    "PROPERTY",
    "Metro Realty Tbk.",
    "1992-01-08",
    232848000,
    "PENGEMBANGAN",
  ],
  [
    "MTWI",
    "FINANCE",
    "Malacca Trust Wuwungan Insuran",
    "2017-10-11",
    1525819116,
    "PENGEMBANGAN",
  ],
  [
    "MYOH",
    "MINING",
    "Samindo Resources Tbk.",
    "2000-07-27",
    2206312500,
    "UTAMA",
  ],
  [
    "MYOR",
    "CONSUMER",
    "Mayora Indah Tbk.",
    "1990-07-04",
    22358699725,
    "UTAMA",
  ],
  [
    "MYRX",
    "PROPERTY",
    "Hanson International Tbk.",
    "1990-10-31",
    86703220792,
    "PENGEMBANGAN",
  ],
  [
    "MYTX",
    "MISC-IND",
    "Asia Pacific Investama Tbk.",
    "1989-10-10",
    1466666577,
    "UTAMA",
  ],
  [
    "NAGA",
    "FINANCE",
    "Bank Mitraniaga Tbk.",
    "2013-07-09",
    1612710000,
    "UTAMA",
  ],
  [
    "NASA",
    "TRADE",
    "Ayana Land International Tbk.",
    "2017-08-07",
    11003909352,
    "PENGEMBANGAN",
  ],
  [
    "NELY",
    "INFRASTRUCT",
    "Pelayaran Nelly Dwi Putri Tbk.",
    "2012-10-11",
    2350000000,
    "PENGEMBANGAN",
  ],
  [
    "NFCX",
    "TRADE",
    "NFC Indonesia Tbk.",
    "2018-07-12",
    666667500,
    "PENGEMBANGAN",
  ],
  [
    "NICK",
    "TRADE",
    "Charnic Capital Tbk.",
    "2018-05-02",
    651150000,
    "PENGEMBANGAN",
  ],
  [
    "NIKL",
    "BASIC-IND",
    "Pelat Timah Nusantara Tbk.",
    "2009-12-14",
    2523350000,
    "UTAMA",
  ],
  [
    "NIPS",
    "MISC-IND",
    "Nipress Tbk.",
    "1991-07-24",
    1635333332,
    "PENGEMBANGAN",
  ],
  [
    "NIRO",
    "PROPERTY",
    "Nirvana Development Tbk.",
    "2012-09-13",
    22198871804,
    "PENGEMBANGAN",
  ],
  [
    "NISP",
    "FINANCE",
    "Bank OCBC NISP Tbk.",
    "1994-10-20",
    22715776032,
    "UTAMA",
  ],
  [
    "NOBU",
    "FINANCE",
    "Bank Nationalnobu Tbk.",
    "2013-05-20",
    4393533177,
    "UTAMA",
  ],
  [
    "NRCA",
    "PROPERTY",
    "Nusa Raya Cipta Tbk.",
    "2013-06-27",
    2496258344,
    "UTAMA",
  ],
  [
    "NUSA",
    "TRADE",
    "Sinergi Megah Internusa Tbk.",
    "2018-07-12",
    7700000000,
    "PENGEMBANGAN",
  ],
  [
    "OASA",
    "INFRASTRUCT",
    "Protech Mitra Perkasa Tbk.",
    "2016-07-18",
    358600000,
    "PENGEMBANGAN",
  ],
  [
    "OCAP",
    "TRADE",
    "Onix Capital Tbk.",
    "2003-11-10",
    273200000,
    "PENGEMBANGAN",
  ],
  [
    "OKAS",
    "TRADE",
    "Ancora Indonesia Resources Tbk",
    "2006-03-29",
    1765927777,
    "PENGEMBANGAN",
  ],
  [
    "OMRE",
    "PROPERTY",
    "Indonesia Prima Property Tbk",
    "1994-08-22",
    1745000000,
    "PENGEMBANGAN",
  ],
  [
    "PADI",
    "FINANCE",
    "Minna Padi Investama Sekuritas",
    "2012-01-09",
    11307246524,
    "UTAMA",
  ],
  [
    "PALM",
    "AGRI",
    "Provident Agro Tbk.",
    "2012-10-08",
    7119540356,
    "PENGEMBANGAN",
  ],
  [
    "PANR",
    "TRADE",
    "Panorama Sentrawisata Tbk.",
    "1950-01-01",
    1200000000,
    "UTAMA",
  ],
  [
    "PANS",
    "FINANCE",
    "Panin Sekuritas Tbk.",
    "2000-12-31",
    720000000,
    "UTAMA",
  ],
  [
    "PBID",
    "BASIC-IND",
    "Panca Budi Idaman Tbk.",
    "2017-12-13",
    1875000000,
    "PENGEMBANGAN",
  ],
  [
    "PBRX",
    "MISC-IND",
    "Pan Brothers Tbk.",
    "1990-08-16",
    6478295611,
    "UTAMA",
  ],
  [
    "PBSA",
    "PROPERTY",
    "Paramita Bangun Sarana Tbk.",
    "2016-09-28",
    1500000000,
    "UTAMA",
  ],
  [
    "PCAR",
    "CONSUMER",
    "Prima Cakrawala Abadi Tbk.",
    "2017-12-29",
    1166666700,
    "PENGEMBANGAN",
  ],
  [
    "PDES",
    "TRADE",
    "Destinasi Tirta Nusantara Tbk",
    "2008-07-08",
    715000000,
    "PENGEMBANGAN",
  ],
  [
    "PEGE",
    "FINANCE",
    "Panca Global Kapital Tbk.",
    "2005-06-24",
    2833417056,
    "PENGEMBANGAN",
  ],
  [
    "PGAS",
    "INFRASTRUCT",
    "Perusahaan Gas Negara (Persero",
    "2003-12-15",
    24241508196,
    "UTAMA",
  ],
  [
    "PGLI",
    "TRADE",
    "Pembangunan Graha Lestari Inda",
    "2000-04-05",
    488000000,
    "PENGEMBANGAN",
  ],
  [
    "PICO",
    "BASIC-IND",
    "Pelangi Indah Canindo Tbk",
    "1996-09-23",
    568375000,
    "PENGEMBANGAN",
  ],
  [
    "PJAA",
    "TRADE",
    "Pembangunan Jaya Ancol Tbk.",
    "2004-07-02",
    1599999996,
    "UTAMA",
  ],
  [
    "PKPK",
    "MINING",
    "Perdana Karya Perkasa Tbk",
    "2007-07-11",
    600000000,
    "PENGEMBANGAN",
  ],
  [
    "PLAS",
    "TRADE",
    "Polaris Investama Tbk",
    "2001-03-16",
    1184200000,
    "PENGEMBANGAN",
  ],
  [
    "PLIN",
    "PROPERTY",
    "Plaza Indonesia Realty Tbk.",
    "1992-06-15",
    3550000000,
    "UTAMA",
  ],
  [
    "PNBN",
    "FINANCE",
    "Bank Pan Indonesia Tbk",
    "1982-12-29",
    23837645998,
    "UTAMA",
  ],
  [
    "PNBS",
    "FINANCE",
    "Bank Panin Dubai Syariah Tbk.",
    "2014-01-15",
    23719447472,
    "UTAMA",
  ],
  [
    "PNIN",
    "FINANCE",
    "Paninvest Tbk.",
    "1983-09-20",
    4068323920,
    "UTAMA",
  ],
  [
    "PNLF",
    "FINANCE",
    "Panin Financial Tbk.",
    "1993-06-14",
    32022073293,
    "UTAMA",
  ],
  [
    "PNSE",
    "TRADE",
    "Pudjiadi & Sons Tbk.",
    "1990-05-01",
    797813496,
    "PENGEMBANGAN",
  ],
  [
    "POLL",
    "PROPERTY",
    "Pollux Properti Indonesia Tbk.",
    "2018-07-11",
    8318823600,
    "UTAMA",
  ],
  [
    "POLY",
    "MISC-IND",
    "Asia Pacific Fibers Tbk",
    "1991-03-12",
    2495753334,
    "PENGEMBANGAN",
  ],
  [
    "POOL",
    "TRADE",
    "Pool Advista Indonesia Tbk.",
    "1991-05-20",
    2250171149,
    "PENGEMBANGAN",
  ],
  [
    "PORT",
    "INFRASTRUCT",
    "Nusantara Pelabuhan Handal Tbk",
    "2017-03-16",
    2813941985,
    "PENGEMBANGAN",
  ],
  [
    "POWR",
    "INFRASTRUCT",
    "Cikarang Listrindo Tbk.",
    "2016-06-14",
    16087156000,
    "UTAMA",
  ],
  [
    "PPRE",
    "INFRASTRUCT",
    "PP Presisi Tbk.",
    "2017-11-24",
    10224271000,
    "UTAMA",
  ],
  [
    "PPRO",
    "PROPERTY",
    "PP Properti Tbk.",
    "2015-05-19",
    61675671883,
    "UTAMA",
  ],
  [
    "PRAS",
    "MISC-IND",
    "Prima Alloy Steel Universal Tb",
    "1990-07-12",
    701043478,
    "UTAMA",
  ],
  [
    "PRDA",
    "TRADE",
    "Prodia Widyahusada Tbk.",
    "2016-12-07",
    937500000,
    "PENGEMBANGAN",
  ],
  [
    "PRIM",
    "TRADE",
    "Royal Prima Tbk.",
    "2018-05-15",
    3392080000,
    "PENGEMBANGAN",
  ],
  [
    "PSAB",
    "MINING",
    "J Resources Asia Pasifik Tbk.",
    "2003-04-22",
    26460000000,
    "PENGEMBANGAN",
  ],
  [
    "PSDN",
    "CONSUMER",
    "Prasidha Aneka Niaga Tbk",
    "1994-10-18",
    1440000000,
    "PENGEMBANGAN",
  ],
  [
    "PSKT",
    "TRADE",
    "Red Planet Indonesia Tbk.",
    "1995-09-19",
    10351231636,
    "PENGEMBANGAN",
  ],
  [
    "PSSI",
    "INFRASTRUCT",
    "Pelita Samudera Shipping Tbk.",
    "2017-12-05",
    5030000000,
    "PENGEMBANGAN",
  ],
  [
    "PTBA",
    "MINING",
    "Bukit Asam Tbk.",
    "2002-12-23",
    11520659250,
    "UTAMA",
  ],
  [
    "PTIS",
    "INFRASTRUCT",
    "Indo Straits Tbk.",
    "2011-07-12",
    550165300,
    "UTAMA",
  ],
  [
    "PTPP",
    "PROPERTY",
    "PP (Persero) Tbk.",
    "2010-02-09",
    6199897354,
    "UTAMA",
  ],
  [
    "PTRO",
    "MINING",
    "Petrosea Tbk.",
    "1990-05-21",
    1008605000,
    "UTAMA",
  ],
  [
    "PTSN",
    "MISC-IND",
    "Sat Nusapersada Tbk",
    "2007-11-08",
    1771448000,
    "UTAMA",
  ],
  [
    "PTSP",
    "TRADE",
    "Pioneerindo Gourmet Internatio",
    "1994-05-30",
    220808000,
    "PENGEMBANGAN",
  ],
  [
    "PUDP",
    "TRADE",
    "Pudjiadi Prestige Tbk.",
    "1994-11-18",
    329560000,
    "UTAMA",
  ],
  [
    "PWON",
    "PROPERTY",
    "Pakuwon Jati Tbk.",
    "1989-10-09",
    48159602400,
    "UTAMA",
  ],
  [
    "PYFA",
    "CONSUMER",
    "Pyridam Farma Tbk",
    "2001-10-16",
    535080000,
    "PENGEMBANGAN",
  ],
  [
    "PZZA",
    "TRADE",
    "Sarimelati Kencana Tbk.",
    "2018-05-23",
    3021875000,
    "UTAMA",
  ],
  [
    "RAJA",
    "INFRASTRUCT",
    "Rukun Raharja Tbk.",
    "2006-04-19",
    4077082500,
    "UTAMA",
  ],
  [
    "RALS",
    "TRADE",
    "Ramayana Lestari Sentosa Tbk.",
    "1996-07-24",
    7096000000,
    "UTAMA",
  ],
  [
    "RANC",
    "TRADE",
    "Supra Boga Lestari Tbk.",
    "2012-06-07",
    1564487500,
    "UTAMA",
  ],
  [
    "RBMS",
    "PROPERTY",
    "Ristia Bintang Mahkotasejati T",
    "1997-12-19",
    1511935500,
    "UTAMA",
  ],
  [
    "RDTX",
    "PROPERTY",
    "Roda Vivatex Tbk",
    "1990-05-14",
    268800000,
    "UTAMA",
  ],
  [
    "RELI",
    "FINANCE",
    "Reliance Sekuritas Indonesia T",
    "2005-07-13",
    1800000000,
    "UTAMA",
  ],
  [
    "RICY",
    "MISC-IND",
    "Ricky Putra Globalindo Tbk",
    "1998-01-22",
    641717510,
    "UTAMA",
  ],
  [
    "RIGS",
    "INFRASTRUCT",
    "Rig Tenders Indonesia Tbk.",
    "1990-03-26",
    609130000,
    "PENGEMBANGAN",
  ],
  [
    "RIMO",
    "TRADE",
    "Rimo International Lestari Tbk",
    "2000-11-10",
    40936000000,
    "PENGEMBANGAN",
  ],
  [
    "RISE",
    "PROPERTY",
    "Jaya Sukses Makmur Sentosa Tbk",
    "2018-07-09",
    9950000000,
    "UTAMA",
  ],
  [
    "RMBA",
    "CONSUMER",
    "Bentoel Internasional Investam",
    "1990-03-05",
    36401136250,
    "UTAMA",
  ],
  [
    "RODA",
    "PROPERTY",
    "Pikko Land Development Tbk.",
    "2001-10-22",
    13592128209,
    "PENGEMBANGAN",
  ],
  [
    "ROTI",
    "CONSUMER",
    "Nippon Indosari Corpindo Tbk.",
    "2010-06-28",
    6186488888,
    "UTAMA",
  ],
  [
    "RUIS",
    "MINING",
    "Radiant Utama Interinsco Tbk.",
    "2006-07-12",
    770000000,
    "PENGEMBANGAN",
  ],
  [
    "SAFE",
    "INFRASTRUCT",
    "Steady Safe Tbk",
    "1994-08-15",
    615145012,
    "PENGEMBANGAN",
  ],
  [
    "SAME",
    "TRADE",
    "Sarana Meditama Metropolitan T",
    "2013-01-11",
    5900000000,
    "PENGEMBANGAN",
  ],
  [
    "SCBD",
    "PROPERTY",
    "Danayasa Arthatama Tbk.",
    "2099-12-31",
    3322092000,
    "PENGEMBANGAN",
  ],
  [
    "SCCO",
    "MISC-IND",
    "Supreme Cable Manufacturing & ",
    "1982-07-20",
    205583400,
    "UTAMA",
  ],
  [
    "SCMA",
    "TRADE",
    "Surya Citra Media Tbk.",
    "2002-07-16",
    14621601234,
    "UTAMA",
  ],
  [
    "SCPI",
    "CONSUMER",
    "Merck Sharp Dohme Pharma Tbk.",
    "1990-06-08",
    3600000,
    "PENGEMBANGAN",
  ],
  [
    "SDMU",
    "INFRASTRUCT",
    "Sidomulyo Selaras Tbk.",
    "2011-07-12",
    1135225000,
    "PENGEMBANGAN",
  ],
  [
    "SDPC",
    "TRADE",
    "Millennium Pharmacon Internati",
    "1990-05-07",
    1274000000,
    "UTAMA",
  ],
  [
    "SDRA",
    "FINANCE",
    "Bank Woori Saudara Indonesia 1",
    "2006-12-15",
    6515116991,
    "UTAMA",
  ],
  [
    "SGRO",
    "AGRI",
    "Sampoerna Agro Tbk.",
    "2007-06-18",
    1890000000,
    "UTAMA",
  ],
  [
    "SHID",
    "TRADE",
    "Hotel Sahid Jaya International",
    "1990-05-08",
    1119326168,
    "PENGEMBANGAN",
  ],
  [
    "SHIP",
    "INFRASTRUCT",
    "Sillo Maritime Perdana Tbk.",
    "2016-06-16",
    2719790000,
    "PENGEMBANGAN",
  ],
  [
    "SIAP",
    "MINING",
    "Sekawan Intipratama Tbk",
    "2008-10-17",
    24000000000,
    "PENGEMBANGAN",
  ],
  [
    "SIDO",
    "CONSUMER",
    "Industri Jamu dan Farmasi Sido",
    "2013-12-18",
    15000000000,
    "UTAMA",
  ],
  [
    "SILO",
    "TRADE",
    "Siloam International Hospitals",
    "2013-09-12",
    1625765625,
    "UTAMA",
  ],
  [
    "SIMA",
    "TRADE",
    "Siwani Makmur Tbk",
    "1994-06-03",
    442589871,
    "PENGEMBANGAN",
  ],
  [
    "SIMP",
    "AGRI",
    "Salim Ivomas Pratama Tbk.",
    "2011-06-09",
    15816310000,
    "UTAMA",
  ],
  [
    "SIPD",
    "BASIC-IND",
    "Sierad Produce Tbk.",
    "1996-12-27",
    1339102579,
    "PENGEMBANGAN",
  ],
  [
    "SKBM",
    "CONSUMER",
    "Sekar Bumi Tbk.",
    "1993-01-05",
    1726003217,
    "PENGEMBANGAN",
  ],
  [
    "SKLT",
    "CONSUMER",
    "Sekar Laut Tbk.",
    "1993-09-08",
    690740500,
    "PENGEMBANGAN",
  ],
  [
    "SKYB",
    "TRADE",
    "Skybee Tbk.",
    "2010-07-07",
    585000000,
    "PENGEMBANGAN",
  ],
  [
    "SMAR",
    "AGRI",
    "Smart Tbk.",
    "1992-11-20",
    2872193366,
    "PENGEMBANGAN",
  ],
  [
    "SMBR",
    "BASIC-IND",
    "Semen Baturaja (Persero) Tbk.",
    "2013-06-28",
    9932534336,
    "UTAMA",
  ],
  [
    "SMCB",
    "BASIC-IND",
    "Holcim Indonesia Tbk.",
    "1997-08-10",
    7662900000,
    "UTAMA",
  ],
  [
    "SMDM",
    "PROPERTY",
    "Suryamas Dutamakmur Tbk.",
    "1995-10-12",
    4772138237,
    "PENGEMBANGAN",
  ],
  [
    "SMDR",
    "INFRASTRUCT",
    "Samudera Indonesia  Tbk.",
    "1999-12-05",
    3275120000,
    "UTAMA",
  ],
  [
    "SMGR",
    "BASIC-IND",
    "Semen Indonesia (Persero) Tbk.",
    "1991-07-08",
    5931520000,
    "UTAMA",
  ],
  [
    "SMMA",
    "FINANCE",
    "Sinarmas Multiartha Tbk.",
    "1995-07-05",
    6367664717,
    "UTAMA",
  ],
  [
    "SMMT",
    "MINING",
    "Golden Eagle Energy Tbk.",
    "2007-12-01",
    3150000000,
    "PENGEMBANGAN",
  ],
  [
    "SMRA",
    "PROPERTY",
    "Summarecon Agung Tbk.",
    "1990-05-07",
    14426781680,
    "UTAMA",
  ],
  [
    "SMRU",
    "MINING",
    "SMR Utama Tbk.",
    "2011-10-10",
    12499385782,
    "PENGEMBANGAN",
  ],
  [
    "SMSM",
    "MISC-IND",
    "Selamat Sempurna Tbk.",
    "1996-09-09",
    5758675440,
    "UTAMA",
  ],
  [
    "SOCI",
    "INFRASTRUCT",
    "Soechi Lines Tbk.",
    "2014-12-03",
    7059000000,
    "UTAMA",
  ],
  [
    "SONA",
    "TRADE",
    "Sona Topas Tourism Industry Tb",
    "1992-07-12",
    331200000,
    "PENGEMBANGAN",
  ],
  [
    "SPMA",
    "BASIC-IND",
    "Suparma Tbk.",
    "1994-11-16",
    2114570958,
    "UTAMA",
  ],
  [
    "SPTO",
    "TRADE",
    "Surya Pertiwi Tbk.",
    "2018-05-14",
    2700000000,
    "PENGEMBANGAN",
  ],
  [
    "SQMI",
    "TRADE",
    "Renuka Coalindo Tbk.",
    "2004-07-15",
    301200000,
    "PENGEMBANGAN",
  ],
  [
    "SRAJ",
    "TRADE",
    "Sejahteraraya Anugrahjaya Tbk.",
    "2011-04-11",
    12000705445,
    "UTAMA",
  ],
  [
    "SRIL",
    "MISC-IND",
    "Sri Rejeki Isman Tbk.",
    "2013-06-17",
    20452176844,
    "UTAMA",
  ],
  [
    "SRSN",
    "BASIC-IND",
    "Indo Acidatama Tbk",
    "1993-01-11",
    6020000000,
    "UTAMA",
  ],
  [
    "SRTG",
    "TRADE",
    "Saratoga Investama Sedaya Tbk.",
    "2013-06-26",
    2712967000,
    "PENGEMBANGAN",
  ],
  [
    "SSIA",
    "PROPERTY",
    "Surya Semesta Internusa Tbk.",
    "1997-03-27",
    4705249440,
    "UTAMA",
  ],
  [
    "SSMS",
    "AGRI",
    "Sawit Sumbermas Sarana Tbk.",
    "2013-12-12",
    9525000000,
    "UTAMA",
  ],
  [
    "SSTM",
    "MISC-IND",
    "Sunson Textile Manufacture Tbk",
    "1997-08-20",
    1170909181,
    "PENGEMBANGAN",
  ],
  [
    "STAR",
    "MISC-IND",
    "Star  Petrochem Tbk.",
    "2011-07-13",
    4800000602,
    "UTAMA",
  ],
  [
    "STTP",
    "CONSUMER",
    "Siantar Top Tbk.",
    "1996-12-16",
    1310000000,
    "PENGEMBANGAN",
  ],
  [
    "SUGI",
    "TRADE",
    "Sugih Energy Tbk.",
    "2002-06-19",
    24811541414,
    "PENGEMBANGAN",
  ],
  [
    "SULI",
    "BASIC-IND",
    "SLJ Global Tbk.",
    "1994-03-21",
    3986916802,
    "UTAMA",
  ],
  [
    "SUPR",
    "INFRASTRUCT",
    "Solusi Tunas Pratama Tbk.",
    "2011-10-11",
    1137579698,
    "PENGEMBANGAN",
  ],
  [
    "SWAT",
    "BASIC-IND",
    "Sriwahana Adityakarta Tbk.",
    "2018-06-08",
    3019200000,
    "PENGEMBANGAN",
  ],
  [
    "TALF",
    "BASIC-IND",
    "Tunas Alfin Tbk.",
    "2014-01-17",
    1353435000,
    "PENGEMBANGAN",
  ],
  [
    "TAMU",
    "INFRASTRUCT",
    "Pelayaran Tamarin Samudra Tbk.",
    "2017-05-10",
    3750000000,
    "PENGEMBANGAN",
  ],
  [
    "TARA",
    "PROPERTY",
    "Sitara Propertindo Tbk.",
    "2014-07-11",
    10069645750,
    "UTAMA",
  ],
  [
    "TAXI",
    "INFRASTRUCT",
    "Express Transindo Utama Tbk.",
    "2012-11-02",
    2145600000,
    "UTAMA",
  ],
  [
    "TBIG",
    "INFRASTRUCT",
    "Tower Bersama Infrastructure T",
    "2010-10-26",
    4531399889,
    "UTAMA",
  ],
  [
    "TBLA",
    "AGRI",
    "Tunas Baru Lampung Tbk.",
    "2000-02-14",
    5342098939,
    "UTAMA",
  ],
  [
    "TBMS",
    "BASIC-IND",
    "Tembaga Mulia Semanan Tbk.",
    "1993-09-30",
    367340000,
    "PENGEMBANGAN",
  ],
  [
    "TCID",
    "CONSUMER",
    "Mandom Indonesia Tbk.",
    "1993-09-30",
    201066667,
    "UTAMA",
  ],
  [
    "TCPI",
    "INFRASTRUCT",
    "Transcoal Pacific Tbk.",
    "2018-07-06",
    5000000000,
    "PENGEMBANGAN",
  ],
  [
    "TDPM",
    "BASIC-IND",
    "Tridomain Performance Material",
    "2018-04-09",
    10485050500,
    "UTAMA",
  ],
  [
    "TELE",
    "TRADE",
    "Tiphone Mobile Indonesia Tbk.",
    "2012-01-12",
    7302194889,
    "UTAMA",
  ],
  [
    "TFCO",
    "MISC-IND",
    "Tifico Fiber Indonesia Tbk.",
    "1980-02-26",
    4823076400,
    "PENGEMBANGAN",
  ],
  [
    "TGKA",
    "TRADE",
    "Tigaraksa Satria Tbk.",
    "1990-06-11",
    918492750,
    "PENGEMBANGAN",
  ],
  [
    "TGRA",
    "INFRASTRUCT",
    "Terregra Asia Energy Tbk.",
    "2017-05-16",
    2750000000,
    "UTAMA",
  ],
  [
    "TIFA",
    "FINANCE",
    "Tifa Finance Tbk.",
    "2011-07-08",
    1079700000,
    "PENGEMBANGAN",
  ],
  ["TINS", "MINING", "Timah Tbk.", "1995-10-19", 7447753454, "UTAMA"],
  [
    "TIRA",
    "TRADE",
    "Tira Austenite Tbk",
    "1993-07-27",
    588000000,
    "PENGEMBANGAN",
  ],
  [
    "TIRT",
    "BASIC-IND",
    "Tirta Mahakam Resources Tbk",
    "1999-12-13",
    1011774750,
    "UTAMA",
  ],
  [
    "TKIM",
    "BASIC-IND",
    "Pabrik Kertas Tjiwi Kimia Tbk.",
    "1990-04-03",
    3113223570,
    "UTAMA",
  ],
  [
    "TLKM",
    "INFRASTRUCT",
    "Telekomunikasi Indonesia (Pers",
    "1995-11-14",
    99062216600,
    "UTAMA",
  ],
  [
    "TMAS",
    "INFRASTRUCT",
    "Pelayaran Tempuran Emas Tbk.",
    "2003-07-09",
    1141030000,
    "UTAMA",
  ],
  [
    "TMPI",
    "TRADE",
    "Sigmagold Inti Perkasa Tbk.",
    "1995-01-26",
    5502083747,
    "UTAMA",
  ],
  [
    "TMPO",
    "TRADE",
    "Tempo Intimedia Tbk.",
    "2001-01-08",
    1058333250,
    "PENGEMBANGAN",
  ],
  [
    "TNCA",
    "INFRASTRUCT",
    "Trimuda Nuansa Citra Tbk.",
    "2018-06-28",
    421640000,
    "PENGEMBANGAN",
  ],
  [
    "TOBA",
    "MINING",
    "Toba Bara Sejahtra Tbk.",
    "2012-07-06",
    2012491000,
    "UTAMA",
  ],
  [
    "TOPS",
    "PROPERTY",
    "Totalindo Eka Persada Tbk.",
    "2017-06-16",
    33330000000,
    "UTAMA",
  ],
  [
    "TOTL",
    "PROPERTY",
    "Total Bangun Persada Tbk.",
    "2006-07-25",
    3410000000,
    "UTAMA",
  ],
  [
    "TOTO",
    "BASIC-IND",
    "Surya Toto Indonesia Tbk.",
    "1990-10-30",
    10320000000,
    "PENGEMBANGAN",
  ],
  [
    "TOWR",
    "INFRASTRUCT",
    "Sarana Menara Nusantara Tbk.",
    "2010-03-08",
    51014625000,
    "PENGEMBANGAN",
  ],
  [
    "TPIA",
    "BASIC-IND",
    "Chandra Asri Petrochemical Tbk",
    "2008-05-26",
    17833520260,
    "PENGEMBANGAN",
  ],
  [
    "TPMA",
    "INFRASTRUCT",
    "Trans Power Marine Tbk.",
    "2013-02-20",
    2633300000,
    "PENGEMBANGAN",
  ],
  [
    "TRAM",
    "INFRASTRUCT",
    "Trada Alam Minera Tbk.",
    "2008-09-10",
    49633687721,
    "UTAMA",
  ],
  [
    "TRIL",
    "TRADE",
    "Triwira Insanlestari Tbk.",
    "2008-01-28",
    1200000000,
    "PENGEMBANGAN",
  ],
  [
    "TRIM",
    "FINANCE",
    "Trimegah Sekuritas Indonesia T",
    "2000-01-31",
    7109300000,
    "UTAMA",
  ],
  [
    "TRIO",
    "TRADE",
    "Trikomsel Oke Tbk.",
    "2009-04-14",
    26007494645,
    "UTAMA",
  ],
  [
    "TRIS",
    "MISC-IND",
    "Trisula International Tbk.",
    "2012-06-28",
    1047587802,
    "PENGEMBANGAN",
  ],
  [
    "TRST",
    "BASIC-IND",
    "Trias Sentosa Tbk.",
    "1990-07-02",
    2808000000,
    "UTAMA",
  ],
  [
    "TRUB",
    "INFRASTRUCT",
    "Truba Alam Manunggal Engineeri",
    "2006-10-16",
    15799456267,
    "UTAMA",
  ],
  [
    "TRUK",
    "INFRASTRUCT",
    "Guna Timur Raya Tbk.",
    "2018-05-23",
    435000000,
    "PENGEMBANGAN",
  ],
  [
    "TRUS",
    "FINANCE",
    "Trust Finance Indonesia Tbk",
    "2002-11-28",
    800000000,
    "PENGEMBANGAN",
  ],
  [
    "TSPC",
    "CONSUMER",
    "Tempo Scan Pacific Tbk.",
    "1994-06-17",
    4500000000,
    "UTAMA",
  ],
  [
    "TUGU",
    "FINANCE",
    "Asuransi Tugu Pratama Indonesi",
    "2018-05-28",
    1777777800,
    "PENGEMBANGAN",
  ],
  [
    "TURI",
    "TRADE",
    "Tunas Ridean Tbk.",
    "1995-05-06",
    5580000000,
    "UTAMA",
  ],
  [
    "ULTJ",
    "CONSUMER",
    "Ultra Jaya Milk Industry & Tra",
    "1990-07-02",
    11553528000,
    "UTAMA",
  ],
  [
    "UNIC",
    "BASIC-IND",
    "Unggul Indah Cahaya Tbk.",
    "1989-11-06",
    383331363,
    "UTAMA",
  ],
  [
    "UNIT",
    "MISC-IND",
    "Nusantara Inti Corpora Tbk",
    "2002-04-18",
    75422200,
    "PENGEMBANGAN",
  ],
  [
    "UNSP",
    "AGRI",
    "Bakrie Sumatera Plantations Tb",
    "1990-03-06",
    2500162344,
    "UTAMA",
  ],
  [
    "UNTR",
    "TRADE",
    "United Tractors Tbk.",
    "1989-09-19",
    3730135136,
    "UTAMA",
  ],
  [
    "UNVR",
    "CONSUMER",
    "Unilever Indonesia Tbk.",
    "1982-01-11",
    7630000000,
    "UTAMA",
  ],
  [
    "VICO",
    "FINANCE",
    "Victoria Investama Tbk.",
    "2013-07-08",
    9150094680,
    "UTAMA",
  ],
  [
    "VINS",
    "FINANCE",
    "Victoria Insurance Tbk.",
    "2015-09-28",
    1453582700,
    "PENGEMBANGAN",
  ],
  [
    "VIVA",
    "TRADE",
    "Visi Media Asia Tbk.",
    "2011-11-21",
    16464270400,
    "UTAMA",
  ],
  [
    "VOKS",
    "MISC-IND",
    "Voksel Electric Tbk.",
    "1990-12-20",
    4155602595,
    "UTAMA",
  ],
  [
    "VRNA",
    "FINANCE",
    "Verena Multi Finance Tbk.",
    "2008-06-25",
    2585160908,
    "PENGEMBANGAN",
  ],
  [
    "WAPO",
    "TRADE",
    "Wahana Pronatural Tbk.",
    "2001-06-22",
    520000000,
    "PENGEMBANGAN",
  ],
  [
    "WEGE",
    "PROPERTY",
    "Wijaya Karya Bangunan Gedung T",
    "2017-11-30",
    9572000000,
    "UTAMA",
  ],
  [
    "WEHA",
    "INFRASTRUCT",
    "WEHA Transportasi Indonesia Tb",
    "2007-05-31",
    886411265,
    "UTAMA",
  ],
  [
    "WICO",
    "TRADE",
    "Wicaksana Overseas Internation",
    "1994-08-08",
    1268950977,
    "PENGEMBANGAN",
  ],
  [
    "WIIM",
    "CONSUMER",
    "Wismilak Inti Makmur Tbk.",
    "2012-12-18",
    2099873760,
    "UTAMA",
  ],
  [
    "WIKA",
    "PROPERTY",
    "Wijaya Karya (Persero) Tbk.",
    "2007-10-29",
    8969951372,
    "UTAMA",
  ],
  [
    "WINS",
    "INFRASTRUCT",
    "Wintermar Offshore Marine Tbk.",
    "2010-11-29",
    4238011640,
    "UTAMA",
  ],
  [
    "WOMF",
    "FINANCE",
    "Wahana Ottomitra Multiartha Tb",
    "2004-12-13",
    3481481480,
    "UTAMA",
  ],
  [
    "WOOD",
    "CONSUMER",
    "Integra Indocabinet Tbk.",
    "2017-06-21",
    6250000000,
    "PENGEMBANGAN",
  ],
  [
    "WSBP",
    "BASIC-IND",
    "Waskita Beton Precast Tbk.",
    "2016-09-20",
    26361157534,
    "PENGEMBANGAN",
  ],
  [
    "WSKT",
    "PROPERTY",
    "Waskita Karya (Persero) Tbk.",
    "2012-12-19",
    13573902600,
    "UTAMA",
  ],
  [
    "WTON",
    "BASIC-IND",
    "Wijaya Karya Beton Tbk.",
    "2014-04-08",
    8715466600,
    "UTAMA",
  ],
  [
    "YPAS",
    "BASIC-IND",
    "Yanaprima Hastapersada Tbk",
    "2008-03-05",
    668000089,
    "PENGEMBANGAN",
  ],
  [
    "YULE",
    "FINANCE",
    "Yulie Sekuritas Indonesia Tbk.",
    "2004-12-10",
    1785000000,
    "PENGEMBANGAN",
  ],
  [
    "ZBRA",
    "TRADE",
    "Zebra Nusantara Tbk",
    "1991-08-01",
    856133009,
    "PENGEMBANGAN",
  ],
  [
    "ZINC",
    "MINING",
    "Kapuas Prima Coal Tbk.",
    "2017-10-16",
    5050000000,
    "PENGEMBANGAN",
  ],
];
# END FRAGMENT id=data-idx_stock

my $field_names = [];
for my $fn (keys %{ $meta->{fields} }) {
    my $f = $meta->{fields}{$fn};
    $field_names->[ $f->{pos} ] = $fn;
}

my $res = gen_read_table_func(
    name => 'list_idx_firms',
    summary => 'List firms listed on the IDX',
    table_data => $data,
    field_names => $field_names,
    filter_fields => ['sector', 'board'],
);
$res->[0] == 200 or die "Can't generate list_idx_firms function: $res->[0] - $res->[1]";

$SPEC{list_idx_boards} = {
    v => 1.1,
    summary => 'List boards',
    args => {},
};
sub list_idx_boards {
    state $res = do {
        my %seen;
        for (@$data) { next unless $_->[5]; $seen{$_->[5]}++ }
        [200, "OK", [sort keys %seen]];
    };
    $res;
}

$SPEC{list_idx_sectors} = {
    v => 1.1,
    summary => 'List sectors',
    args => {},
};
sub list_idx_sectors {
    state $res = do {
        my %seen;
        for (@$data) { $seen{$_->[1]}++ }
        [200, "OK", [sort keys %seen]];
    };
    $res;
}

1;
# ABSTRACT: List firms listed on the IDX

__END__

=pod

=encoding UTF-8

=head1 NAME

Finance::SE::IDX::Static - List firms listed on the IDX

=head1 VERSION

This document describes version 20180907.0.0 of Finance::SE::IDX::Static (from Perl distribution Finance-SE-IDX-Static), released on 2018-09-07.

=head1 SYNOPSIS

 use Finance::SE::IDX::Static qw(list_idx_firms list_idx_sectors list_idx_boards);

 my $res = list_idx_boards();

 my $res = list_idx_firms();

 # filter by sectors and/or board
 my $res = list_idx_firms(
     board => "PENGEMBANGAN", # for development board, or "UTAMA" for main board
     sector => "AGRI",
 );

 my $res = list_idx_sectors();

=head1 DESCRIPTION

This module is the static (offline) version of L<Finance::SE::IDX>. It provides
the same functions and arguments, but the data is cached in the source code. It
is useful as a fallback when the source that Finance::SE::IDX uses is
unavailable. As a consequence, the data will be somewhat out of date.

=head1 FUNCTIONS


=head2 list_idx_boards

Usage:

 list_idx_boards() -> [status, msg, result, meta]

List boards.

This function is not exported by default, but exportable.

No arguments.

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (result) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)


=head2 list_idx_firms

Usage:

 list_idx_firms(%args) -> [status, msg, result, meta]

List firms listed on the IDX.

REPLACE ME

This function is not exported by default, but exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<board> => I<str>

Filter by value of board.

=item * B<sector> => I<str>

Filter by value of sector.

=back

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (result) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)


=head2 list_idx_sectors

Usage:

 list_idx_sectors() -> [status, msg, result, meta]

List sectors.

This function is not exported by default, but exportable.

No arguments.

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (result) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Finance-SE-IDX-Static>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Finance-SE-IDX-Static>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Finance-SE-IDX-Static>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Finance::SE::IDX>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
