#!/usr/bin/perl

use v5.14;
use warnings;

use Test2::V0;

use meta;
no warnings qw( meta::experimental );

{
   my $metapkg = meta::package->get( "meta" );
   my $metaglob = $metapkg->get_glob( "get_package" );
   ok( $metaglob, '$metapkg->get_glob on get_package' );

   is( $metaglob->basename, "get_package",
      '$metaglob->basename' );
}

# missing
{
   my $metapkg = meta::package->get( "meta" );
   ok( !defined $metapkg->can_glob( "not-a-glob" ),
      'can_glob yields undef on missing glob' );

   like( dies { $metapkg->get_glob( "not-a-glob" ) },
      qr/^Package does not contain a glob called "not-a-glob" /,
      'get_glob throws on missing glob' );
}

# meta::glob->get method
{
   my $metaglob = meta::glob->get( "meta::get_package" );
   ok( $metaglob, 'meta:;glob->get on meta::get_package' );

   is( $metaglob->basename, "get_package",
      '$metaglob->basename' );
}

done_testing;
