package WordList::Test::Dynamic::RandomWord::1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-04'; # DATE
our $DIST = 'WordList-Test-Dynamic-RandomWord-1000'; # DIST
our $VERSION = '0.001'; # VERSION

use strict;

use WordList;
our @ISA = qw(WordList);

use Role::Tiny::With;
with 'WordListRole::EachFromFirstNextReset';

our $DYNAMIC = 2;
our $SORT = 'random';

sub reset_iterator {
    my $self = shift;
    $self->[0] = 0;
}

sub first_word {
    my $self = shift;
    $self->reset_iterator;
    $self->next_word;
}

my @letters = "a".."z";
sub next_word {
    my $self = shift;
    return undef if $self->[0]++ >= 1000;
    join("", map { $letters[rand @letters] } 1..int(5*rand)+3);
}

our %STATS = ("longest_word_len",7,"num_words_contain_whitespace",0,"shortest_word_len",3,"num_words",1000,"avg_word_len",5.04,"num_words_contains_whitespace",0,"num_words_contains_nonword_chars",0,"num_words_contain_nonword_chars",0,"num_words_contains_unicode",0,"num_words_contain_unicode",0); # STATS

1;
# ABSTRACT: 1000 random words

__END__

=pod

=encoding UTF-8

=head1 NAME

WordList::Test::Dynamic::RandomWord::1000 - 1000 random words

=head1 VERSION

This document describes version 0.001 of WordList::Test::Dynamic::RandomWord::1000 (from Perl distribution WordList-Test-Dynamic-RandomWord-1000), released on 2020-05-04.

=head1 SYNOPSIS

 use WordList::Test::Dynamic::RandomWord::1000;

 my $wl = WordList::Test::Dynamic::RandomWord::1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

This wordlist demoes a dynamic, non-deterministic wordlist.

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.04  |
 | longest_word_len                 | 7     |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 3     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-Test-Dynamic-RandomWord-1000>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-Test-Dynamic-RandomWord-1000>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-Test-Dynamic-RandomWord-1000>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
