# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210602223300;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              496|
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"819785", "Bungotakada\,\ Oita",
"817686", "Noto\,\ Ishikawa",
"817684", "Wajima\,\ Ishikawa",
"818680", "Okayama\,\ Okayama",
"819685", "Tamana\,\ Kumamoto",
"812858", "Mooka\,\ Tochigi",
"812830", "Utsunomiya\,\ Tochigi",
"81134", "Otaru\,\ Hokkaido",
"812917", "Mito\,\ Ibaraki",
"812552", "Joetsu\,\ Niigata",
"8153970", "Hamamatsu\,\ Shizuoka",
"819808", "Yaeyama\ District\,\ Okinawa",
"818955", "Uwajima\,\ Ehime",
"819938", "Kaseda\,\ Kagoshima",
"812834", "Utsunomiya\,\ Tochigi",
"819956", "Kajiki\,\ Kagoshima",
"818655", "Kamogata\,\ Okayama",
"811392", "Kikonai\,\ Hokkaido",
"818593", "Yonago\,\ Tottori",
"81742", "Nara\,\ Nara",
"817955", "Sanda\,\ Hyogo",
"819738", "Kusu\,\ Oita",
"819954", "Kajiki\,\ Kagoshima",
"812836", "Sano\,\ Tochigi",
"817997", "Tsuna\,\ Hyogo",
"818797", "Tonosho\,\ Kagawa",
"81467", "Fujisawa\,\ Kanagawa",
"818686", "Tsuyama\,\ Okayama",
"812574", "Kashiwazaki\,\ Niigata",
"818697", "Bizen\,\ Okayama",
"812576", "Tokamachi\,\ Niigata",
"818684", "Tsuyama\,\ Okayama",
"818369", "Ube\,\ Yamaguchi",
"811938", "Miyako\,\ Iwate",
"811656", "Bifuka\,\ Hokkaido",
"811754", "Mutsu\,\ Aomori",
"815993", "Toba\,\ Mie",
"811756", "Noheji\,\ Aomori",
"81934", "Kitakyushu\,\ Fukuoka",
"811654", "Nayoro\,\ Hokkaido",
"8186998", "Seto\,\ Okayama",
"817453", "Yamatotakada\,\ Nara",
"81236", "Yamagata\,\ Yamagata",
"811972", "Mizusawa\,\ Iwate",
"814289", "Ome\,\ Tokyo",
"8153973", "Hamamatsu\,\ Shizuoka",
"818293", "Hatsukaichi\,\ Hiroshima",
"818843", "Anan\,\ Tokushima",
"815584", "Shimoda\,\ Shizuoka",
"81244", "Hobara\,\ Fukushima",
"812383", "Yonezawa\,\ Yamagata",
"81420", "Tokorozawa\,\ Saitama",
"815586", "Shimoda\,\ Shizuoka",
"81963", "Kumamoto\,\ Kumamoto",
"811954", "Ninohe\,\ Iwate",
"818377", "Shimonoseki\,\ Yamaguchi",
"81946", "Amagi\,\ Fukuoka",
"81439", "Kisarazu\,\ Chiba",
"811956", "Iwate\,\ Iwate",
"81484", "Kawaguchi\,\ Saitama",
"81429", "Tokorozawa\,\ Saitama",
"8126173", "Omachi\,\ Nagano",
"817475", "Shimonoseki\,\ Yamaguchi",
"8186553", "Kurashiki\,\ Okayama",
"815977", "Kumano\,\ Mie",
"815769", "Shokawa\,\ Gifu",
"818475", "Fuchu\,\ Hiroshima",
"81226", "Kesennuma\,\ Miyagi",
"817482", "Yokaichi\,\ Shiga",
"812376", "Sagae\,\ Yamagata",
"8112395", "Kuriyama\,\ Hokkaido",
"8153969", "Hamamatsu\,\ Shizuoka",
"818203", "Yanai\,\ Yamaguchi",
"81924", "Fukuoka\,\ Fukuoka",
"81989", "Naha\,\ Okinawa",
"812374", "Murayama\,\ Yamagata",
"814298", "Hanno\,\ Saitama",
"812996", "Itako\,\ Ibaraki",
"812994", "Ishioka\,\ Ibaraki",
"817614", "Komatsu\,\ Ishikawa",
"8126170", "Omachi\,\ Nagano",
"817716", "Sonobe\,\ Kyoto",
"811548", "Teshikaga\,\ Hokkaido",
"817673", "Hakui\,\ Ishikawa",
"817714", "Kameoka\,\ Kyoto",
"818973", "Niihama\,\ Ehime",
"817616", "Komatsu\,\ Ishikawa",
"81124", "Ashibetsu\,\ Hokkaido",
"811452", "Hayakita\,\ Hokkaido",
"812583", "Nagaoka\,\ Niigata",
"817707", "Obama\,\ Fukui",
"817914", "Aioi\,\ Hyogo",
"812694", "Nakano\,\ Nagano",
"819592", "Oseto\,\ Nagasaki",
"812796", "Shibukawa\,\ Gunma",
"812794", "Shibukawa\,\ Gunma",
"812911", "Hokota\,\ Ibaraki",
"812696", "Iiyama\,\ Nagano",
"812787", "Numata\,\ Gunma",
"814284", "Tachikawa\,\ Tokyo",
"814297", "Hanno\,\ Saitama",
"81550", "Gotenba\,\ Shizuoka",
"8186992", "Bizen\,\ Okayama",
"81827", "Iwakuni\,\ Yamaguchi",
"814286", "Sagamihara\,\ Kanagawa",
"811547", "Shiranuka\,\ Hokkaido",
"818364", "Ube\,\ Yamaguchi",
"818366", "Ube\,\ Yamaguchi",
"812935", "Mito\,\ Ibaraki",
"81577", "Takayama\,\ Gifu",
"818360", "Ogori\,\ Yamaguchi",
"815398", "Hamamatsu\,\ Shizuoka",
"81567", "Tsushima\,\ Aichi",
"811333", "Tobetsu\,\ Hokkaido",
"817366", "Iwade\,\ Wakayama",
"814280", "Tachikawa\,\ Tokyo",
"811943", "Iwaizumi\,\ Iwate",
"818872", "Muroto\,\ Kochi",
"81727", "Ikeda\,\ Osaka",
"8186999", "Seto\,\ Okayama",
"812788", "Maebashi\,\ Gunma",
"81298", "Tsuchiura\,\ Ibaraki",
"8183768", "Shimonoseki\,\ Yamaguchi",
"819547", "Kashima\,\ Saga",
"8198297", "Hyuga\,\ Miyazaki",
"815978", "Kumano\,\ Mie",
"819743", "Mie\,\ Oita",
"814771", "Ichikawa\,\ Chiba",
"818689", "Okayama\,\ Okayama",
"814793", "Choshi\,\ Chiba",
"819943", "Kanoya\,\ Kagoshima",
"811855", "Noshiro\,\ Akita",
"81857", "Tottori\,\ Tottori",
"812963", "Shimodate\,\ Ibaraki",
"812839", "Sano\,\ Tochigi",
"815732", "Ena\,\ Gifu",
"811365", "Kutchan\,\ Hokkaido",
"81268", "Ueda\,\ Nagano",
"814703", "Tateyama\,\ Chiba",
"819233", "Maebaru\,\ Fukuoka",
"811937", "Miyako\,\ Iwate",
"81899", "Matsuyama\,\ Ehime",
"817942", "Kakogawa\,\ Hyogo",
"81779", "Ono\,\ Gifu",
"81584", "Ogaki\,\ Gifu",
"812999", "Itako\,\ Ibaraki",
"818564", "Masuda\,\ Shimane",
"811533", "Nemuro\,\ Hokkaido",
"811524", "Abashiri\,\ Hokkaido",
"811526", "Abashiri\,\ Hokkaido",
"81545", "Fuji\,\ Shizuoka",
"812799", "Naganohara\,\ Gunma",
"811873", "Kakunodate\,\ Akita",
"818378", "Shimonoseki\,\ Yamaguchi",
"814777", "Funabashi\,\ Chiba",
"812545", "Murakami\,\ Niigata",
"818942", "Yawatahama\,\ Ehime",
"815766", "Gero\,\ Gifu",
"815764", "Gero\,\ Gifu",
"81737", "Yuasa\,\ Wakayama",
"812245", "Ogawara\,\ Miyagi",
"812895", "Utsunomiya\,\ Tochigi",
"812857", "Mooka\,\ Tochigi",
"819937", "Kaseda\,\ Kagoshima",
"8153968", "Hamamatsu\,\ Shizuoka",
"811233", "Chitose\,\ Hokkaido",
"814291", "Hanno\,\ Saitama",
"812618", "Omachi\,\ Nagano",
"819737", "Kusu\,\ Oita",
"81559", "Numazu\,\ Shizuoka",
"8124197", "Yanaizu\,\ Fukushima",
"817998", "Tsuna\,\ Hyogo",
"818798", "Tonosho\,\ Kagawa",
"818698", "Bizen\,\ Okayama",
"811541", "Teshikaga\,\ Hokkaido",
"8145", "Yokohama\,\ Kanagawa",
"81864", "Kurashiki\,\ Okayama",
"812653", "Iida\,\ Nagano",
"819977", "Setouchi\,\ Kagoshima",
"812649", "Nagano\,\ Nagano",
"811397", "Okushiri\,\ Hokkaido",
"812612", "Omachi\,\ Nagano",
"81833", "Kudamatsu\,\ Yamaguchi",
"819573", "Isahaya\,\ Nagasaki",
"8164", "Osaka\,\ Osaka",
"811865", "Odate\,\ Akita",
"819826", "Hyuga\,\ Miyazaki",
"81774", "Uji\,\ Kyoto",
"817992", "Sumoto\,\ Hyogo",
"814220", "Kokubunji\,\ Tokyo",
"819824", "Nobeoka\,\ Miyazaki",
"81764", "Toyama\,\ Toyama",
"818692", "Oku\,\ Okayama",
"81292", "Mito\,\ Ibaraki",
"818385", "Hagi\,\ Yamaguchi",
"817948", "Miki\,\ Hyogo",
"811977", "Kitakami\,\ Iwate",
"812484", "Shirakawa\,\ Fukushima",
"81554", "Otsuki\,\ Yamanashi",
"812486", "Sukagawa\,\ Fukushima",
"8188095", "Tosashimizu\,\ Kochi",
"817354", "Shingu\,\ Fukuoka",
"817356", "Kushimoto\,\ Wakayama",
"818372", "Nagato\,\ Yamaguchi",
"81262", "Nagano\,\ Nagano",
"818948", "Uwajima\,\ Ehime",
"81272", "Maebashi\,\ Gunma",
"812416", "Tajima\,\ Fukushima",
"812473", "Ishikawa\,\ Fukushima",
"815754", "Sekigahara\,\ Gifu",
"812414", "Yanaizu\,\ Fukushima",
"815972", "Owase\,\ Mie",
"811586", "Nakayubetsu\,\ Hokkaido",
"817496", "Nagahama\,\ Shiga",
"817238", "Neyagawa\,\ Osaka",
"815985", "Matsusaka\,\ Mie",
"812879", "Nasukarasuyama\,\ Tochigi",
"81853", "Izumo\,\ Shimane",
"818490", "Onomichi\,\ Hiroshima",
"8125485", "Tsugawa\,\ Niigata",
"817487", "Minakuchi\,\ Shiga",
"811584", "Engaru\,\ Hokkaido",
"817494", "Hikone\,\ Shiga",
"811555", "Obihiro\,\ Hokkaido",
"815738", "Nakatsugawa\,\ Gifu",
"8186996", "Seto\,\ Okayama",
"81593", "Yokkaichi\,\ Mie",
"818585", "Kurayoshi\,\ Tottori",
"812675", "Saku\,\ Nagano",
"812239", "Sendai\,\ Miyagi",
"818556", "Gotsu\,\ Shimane",
"81823", "Kure\,\ Hiroshima",
"818554", "Hamada\,\ Shimane",
"817902", "Fukusaki\,\ Hyogo",
"81534", "Hamamatsu\,\ Shizuoka",
"81546", "Shizuoka\,\ Shizuoka",
"817702", "Tsuruga\,\ Fukui",
"815392", "Hamamatsu\,\ Shizuoka",
"819555", "Karatsu\,\ Saga",
"818832", "Kamojima\,\ Tokushima",
"81723", "Sakai\,\ Osaka",
"819597", "Fukue\,\ Nagasaki",
"812551", "Joetsu\,\ Niigata",
"812782", "Numata\,\ Gunma",
"81563", "Nishio\,\ Aichi",
"812489", "Sukagawa\,\ Fukushima",
"81929", "Fukuoka\,\ Fukuoka",
"81984", "Kobayashi\,\ Miyazaki",
"817724", "Miyazu\,\ Kyoto",
"817733", "Fukuchiyama\,\ Kyoto",
"819725", "Saiki\,\ Oita",
"811542", "Kushiro\,\ Hokkaido",
"817463", "Yoshino\,\ Nara",
"81848", "Onomichi\,\ Hiroshima",
"81235", "Tsuruoka\,\ Yamagata",
"81286", "Utsunomiya\,\ Tochigi",
"81930", "Yukuhashi\,\ Fukuoka",
"818463", "Takehara\,\ Hiroshima",
"819598", "Fukue\,\ Nagasaki",
"8153966", "Hamamatsu\,\ Shizuoka",
"81489", "Soka\,\ Saitama",
"812744", "Fujioka\,\ Gunma",
"819434", "Yame\,\ Fukuoka",
"812646", "Nagano\,\ Nagano",
"819542", "Takeo\,\ Saga",
"812746", "Tomioka\,\ Gunma",
"812562", "Sanjo\,\ Niigata",
"819664", "Hitoyoshi\,\ Kumamoto",
"81184", "Yurihonjo\,\ Akita",
"819666", "Minamata\,\ Kumamoto",
"818665", "Takahashi\,\ Okayama",
"819966", "Izumi\,\ Kagoshima",
"8152", "Nagoya\,\ Aichi",
"817965", "Toyooka\,\ Hyogo",
"819964", "Satsumasendai\,\ Kagoshima",
"817488", "Minakuchi\,\ Shiga",
"812640", "Nagano\,\ Nagano",
"815737", "Nakatsugawa\,\ Gifu",
"811932", "Kamaishi\,\ Iwate",
"817947", "Miki\,\ Hyogo",
"818559", "Kawamoto\,\ Shimane",
"8198290", "Nobeoka\,\ Miyazaki",
"814754", "Mobara\,\ Chiba",
"812236", "Sendai\,\ Miyagi",
"81950", "Hirado\,\ Nagasaki",
"811978", "Kitakami\,\ Iwate",
"812234", "Sendai\,\ Miyagi",
"814756", "Togane\,\ Chiba",
"818543", "Yasugi\,\ Shimane",
"8183766", "Shimonoseki\,\ Yamaguchi",
"812230", "Sendai\,\ Miyagi",
"811462", "Urakawa\,\ Hokkaido",
"81977", "Beppu\,\ Oita",
"814772", "Ichikawa\,\ Chiba",
"811732", "Goshogawara\,\ Aomori",
"811632", "Teshio\,\ Hokkaido",
"818947", "Uwajima\,\ Ehime",
"81434", "Chiba\,\ Chiba",
"815743", "Minokamo\,\ Gifu",
"819978", "Tokunoshima\,\ Kagoshima",
"812852", "Oyama\,\ Tochigi",
"8198293", "Nobeoka\,\ Miyazaki",
"812419", "Tajima\,\ Fukushima",
"819802", "Minamidaito\,\ Okinawa",
"81493", "Higashimatsuyama\,\ Saitama",
"81249", "Koriyama\,\ Fukushima",
"819932", "Ibusuki\,\ Kagoshima",
"81480", "Kuki\,\ Saitama",
"81463", "Hiratsuka\,\ Kanagawa",
"818243", "Higashi\-ku\,\ Hiroshima",
"81225", "Ishinomaki\,\ Miyagi",
"811398", "Kumaishi\,\ Hokkaido",
"818893", "Sakawa\,\ Kochi",
"81167", "Furano\,\ Hokkaido",
"815959", "Kameyama\,\ Mie",
"819732", "Hita\,\ Oita",
"81177", "Aomori\,\ Aomori",
"81473", "Ichikawa\,\ Chiba",
"81939", "Kitakyushu\,\ Fukuoka",
"812874", "Otawara\,\ Tochigi",
"811589", "Okoppe\,\ Hokkaido",
"812876", "Kuroiso\,\ Tochigi",
"817676", "Nanao\,\ Ishikawa",
"811357", "Iwanai\,\ Hokkaido",
"817713", "Kameoka\,\ Kyoto",
"812580", "Tokamachi\,\ Niigata",
"818974", "Niihama\,\ Ehime",
"817613", "Komatsu\,\ Ishikawa",
"818976", "Niihama\,\ Ehime",
"811867", "Takanosu\,\ Akita",
"81585", "Ibigawa\,\ Gifu",
"8153975", "Hamamatsu\,\ Shizuoka",
"814709", "Kamogawa\,\ Chiba",
"817674", "Hakui\,\ Ishikawa",
"8186691", "Kurashiki\,\ Okayama",
"817952", "Nishiwaki\,\ Hyogo",
"812993", "Ishioka\,\ Ibaraki",
"811395", "Esashi\,\ Hokkaido",
"818652", "Kurashiki\,\ Okayama",
"818952", "Uwajima\,\ Ehime",
"812793", "Shibukawa\,\ Gunma",
"812693", "Nakano\,\ Nagano",
"812555", "Itoigawa\,\ Niigata",
"819682", "Yamaga\,\ Kumamoto",
"8162", "Osaka\,\ Osaka",
"81544", "Fujinomiya\,\ Shizuoka",
"812584", "Nagaoka\,\ Niigata",
"819975", "Naze\,\ Kagoshima",
"81468", "Yokosuka\,\ Kanagawa",
"818676", "Kuse\,\ Okayama",
"818674", "Kuse\,\ Okayama",
"819782", "Bungotakada\,\ Oita",
"812586", "Nagaoka\,\ Niigata",
"81478", "Sawara\,\ Chiba",
"8182943", "Hiroshima\,\ Hiroshima",
"815368", "Shitara\,\ Aichi",
"8165", "Osaka\,\ Osaka",
"811982", "Hanamaki\,\ Iwate",
"818206", "Yanai\,\ Yamaguchi",
"812373", "Murayama\,\ Yamagata",
"811975", "Mizusawa\,\ Iwate",
"8144", "Kawasaki\,\ Kanagawa",
"818204", "Yanai\,\ Yamaguchi",
"818387", "Tamagawa\,\ Yamaguchi",
"8125487", "Tsugawa\,\ Niigata",
"817456", "Yamatotakada\,\ Nara",
"818294", "Hatsukaichi\,\ Hiroshima",
"818844", "Anan\,\ Tokushima",
"8186994", "Seto\,\ Okayama",
"81992", "Kagoshima\,\ Kagoshima",
"818296", "Hiroshima\,\ Hiroshima",
"817454", "Yamatotakada\,\ Nara",
"815996", "Ago\,\ Mie",
"817485", "Yokaichi\,\ Shiga",
"817968", "Hamasaka\,\ Hyogo",
"811653", "Shibetsu\,\ Hokkaido",
"818668", "Ibara\,\ Okayama",
"815994", "Ago\,\ Mie",
"811753", "Mutsu\,\ Aomori",
"811953", "Ninohe\,\ Iwate",
"8112390", "Yubari\,\ Hokkaido",
"8188097", "Tosashimizu\,\ Kochi",
"81962", "Kumamoto\,\ Kumamoto",
"812386", "Nagai\,\ Yamagata",
"818290", "Hiroshima\,\ Hiroshima",
"815583", "Shimoda\,\ Shizuoka",
"812384", "Yonezawa\,\ Yamagata",
"8163", "Osaka\,\ Osaka",
"8126175", "Omachi\,\ Nagano",
"817683", "Wajima\,\ Ishikawa",
"81192", "Ofunato\,\ Iwate",
"819557", "Karatsu\,\ Saga",
"811455", "Mukawa\,\ Hokkaido",
"81172", "Hirosaki\,\ Aomori",
"818683", "Tsuyama\,\ Okayama",
"81766", "Takaoka\,\ Toyama",
"81471", "Kashiwa\,\ Chiba",
"81162", "Wakkanai\,\ Hokkaido",
"8112393", "Yubari\,\ Hokkaido",
"81896", "Iyomishima\,\ Ehime",
"812573", "Kashiwazaki\,\ Niigata",
"81776", "Fukui\,\ Fukui",
"818596", "Yonago\,\ Tottori",
"819728", "Usuki\,\ Oita",
"812677", "Saku\,\ Nagano",
"81743", "Nara\,\ Nara",
"819953", "Okuchi\,\ Kagoshima",
"812833", "Utsunomiya\,\ Tochigi",
"818587", "Koge\,\ Tottori",
"818594", "Yonago\,\ Tottori",
"811234", "Chitose\,\ Hokkaido",
"811236", "Chitose\,\ Hokkaido",
"8153964", "Hamamatsu\,\ Shizuoka",
"81828", "Hiroshima\,\ Hiroshima",
"815763", "Gero\,\ Gifu",
"819558", "Karatsu\,\ Saga",
"81485", "Kumagaya\,\ Saitama",
"81949", "Nogata\,\ Fukuoka",
"8199331", "Kagoshima\,\ Kagoshima",
"81436", "Ichihara\,\ Chiba",
"812932", "Takahagi\,\ Ibaraki",
"81578", "Kamioka\,\ Akita",
"81925", "Fukuoka\,\ Fukuoka",
"81568", "Kasugai\,\ Aichi",
"8186698", "Kurashiki\,\ Okayama",
"819727", "Usuki\,\ Oita",
"812678", "Saku\,\ Nagano",
"818263", "Kake\,\ Hiroshima",
"81728", "Neyagawa\,\ Osaka",
"818588", "Koge\,\ Tottori",
"811362", "Kutchan\,\ Hokkaido",
"818563", "Masuda\,\ Shimane",
"815735", "Ena\,\ Gifu",
"811558", "Hiroo\,\ Hokkaido",
"811852", "Oga\,\ Akita",
"81250", "Niitsu\,\ Niigata",
"814704", "Tateyama\,\ Chiba",
"818667", "Ibara\,\ Okayama",
"812589", "Nagaoka\,\ Niigata",
"811876", "Omagari\,\ Akita",
"814700", "Kamogawa\,\ Chiba",
"811874", "Kakunodate\,\ Akita",
"818679", "Niimi\,\ Okayama",
"81277", "Kiryu\,\ Gunma",
"811536", "Akkeshi\,\ Hokkaido",
"81125", "Takikawa\,\ Hokkaido",
"811534", "Nakashibetsu\,\ Hokkaido",
"811523", "Shari\,\ Hokkaido",
"819744", "Mie\,\ Oita",
"819940", "Shibushi\,\ Kagoshima",
"818945", "Yawatahama\,\ Ehime",
"812542", "Shibata\,\ Niigata",
"815367", "Shitara\,\ Aichi",
"819746", "Taketa\,\ Oita",
"813", "Tokyo",
"812964", "Shimodate\,\ Ibaraki",
"817945", "Kakogawa\,\ Hyogo",
"814794", "Choshi\,\ Chiba",
"819944", "Kanoya\,\ Kagoshima",
"818388", "Tamagawa\,\ Yamaguchi",
"819946", "Kanoya\,\ Kagoshima",
"814796", "Yokaichiba\,\ Chiba",
"81259", "Sado\,\ Niigata",
"81284", "Ashikaga\,\ Tochigi",
"81591", "Tsu\,\ Mie",
"815999", "Tsu\,\ Mie",
"811562", "Honbetsu\,\ Hokkaido",
"818363", "Ube\,\ Yamaguchi",
"81738", "Gobo\,\ Wakayama",
"811868", "Takanosu\,\ Akita",
"818299", "Hiroshima\,\ Hiroshima",
"81935", "Kitakyushu\,\ Fukuoka",
"811644", "Rumoi\,\ Hokkaido",
"814283", "Ome\,\ Tokyo",
"811646", "Haboro\,\ Hokkaido",
"81986", "Miyakonojo\,\ Miyazaki",
"811946", "Kuji\,\ Iwate",
"81721", "Tondabayashi\,\ Osaka",
"811944", "Iwaizumi\,\ Iwate",
"812389", "Yonezawa\,\ Yamagata",
"81426", "Hachioji\,\ Tokyo",
"812892", "Utsunomiya\,\ Tochigi",
"81940", "Munakata\,\ Fukuoka",
"812242", "Shiroishi\,\ Miyagi",
"81561", "Seto\,\ Aichi",
"81245", "Fukushima\,\ Fukushima",
"811336", "Ishikari\,\ Hokkaido",
"818695", "Seto\,\ Okayama",
"81822", "Hiroshima\,\ Hiroshima",
"818553", "Hamada\,\ Shimane",
"811352", "Yoichi\,\ Hokkaido",
"817995", "Sumoto\,\ Hyogo",
"811862", "Kazuno\,\ Akita",
"812615", "Omachi\,\ Nagano",
"81592", "Tsu\,\ Mie",
"818657", "Kasaoka\,\ Okayama",
"81956", "Sasebo\,\ Nagasaki",
"811374", "Mori\,\ Hokkaido",
"818957", "Misho\,\ Ehime",
"818512", "Nishigo\,\ Fukushima",
"811376", "Yakumo\,\ Hokkaido",
"81572", "Tajimi\,\ Gifu",
"812248", "Ogawara\,\ Miyagi",
"812898", "Kanuma\,\ Tochigi",
"81722", "Sakai\,\ Osaka",
"819687", "Tamana\,\ Kumamoto",
"81126", "Iwamizawa\,\ Hokkaido",
"819787", "Kunisaki\,\ Oita",
"818493", "Onomichi\,\ Hiroshima",
"818375", "Mine\,\ Yamaguchi",
"812474", "Ishikawa\,\ Fukushima",
"815753", "Sekigahara\,\ Gifu",
"81486", "Urawa\,\ Saitama",
"812413", "Kitakata\,\ Fukushima",
"811987", "Tono\,\ Iwate",
"812476", "Miharu\,\ Fukushima",
"81926", "Fukuoka\,\ Fukuoka",
"8112397", "Kuriyama\,\ Hokkaido",
"818249", "Higashi\-ku\,\ Hiroshima",
"818382", "Hagi\,\ Yamaguchi",
"817493", "Hikone\,\ Shiga",
"811583", "Monbetsu\,\ Hokkaido",
"81852", "Matsue\,\ Shimane",
"811858", "Noshiro\,\ Akita",
"81234", "Sakata\,\ Yamagata",
"812483", "Shirakawa\,\ Fukushima",
"811552", "Obihiro\,\ Hokkaido",
"81936", "Kitakyushu\,\ Fukuoka",
"81280", "Koga\,\ Ibaraki",
"818477", "Tojo\,\ Hiroshima",
"81985", "Miyazaki\,\ Miyazaki",
"815982", "Matsusaka\,\ Mie",
"81944", "Setaka\,\ Fukuoka",
"81273", "Takasaki\,\ Gunma",
"81263", "Matsumoto\,\ Nagano",
"81425", "Tachikawa\,\ Tokyo",
"81888", "Kochi\,\ Kochi",
"8125480", "Murakami\,\ Niigata",
"817353", "Shingu\,\ Fukuoka",
"81246", "Iwaki\,\ Fukushima",
"812785", "Numata\,\ Gunma",
"818835", "Mima\,\ Tokushima",
"819552", "Imari\,\ Saga",
"812654", "Iida\,\ Nagano",
"815395", "Hamamatsu\,\ Shizuoka",
"817705", "Obama\,\ Fukui",
"812938", "Mito\,\ Ibaraki",
"812656", "Ina\,\ Nagano",
"819823", "Nobeoka\,\ Miyazaki",
"817905", "Fukusaki\,\ Hyogo",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"81832", "Shimonoseki\,\ Yamaguchi",
"8125483", "Murakami\,\ Niigata",
"819574", "Isahaya\,\ Nagasaki",
"812672", "Komoro\,\ Nagano",
"819576", "Shimabara\,\ Nagasaki",
"818582", "Kurayoshi\,\ Tottori",
"81144", "Tomakomai\,\ Hokkaido",
"81492", "Kawagoe\,\ Saitama",
"81191", "Ichinoseki\,\ Iwate",
"818240", "Higashi\-ku\,\ Hiroshima",
"815744", "Minokamo\,\ Gifu",
"812937", "Mito\,\ Ibaraki",
"815746", "Minokamo\,\ Gifu",
"811545", "Kushiro\,\ Hokkaido",
"812873", "Otawara\,\ Tochigi",
"818896", "Susaki\,\ Kochi",
"818246", "Miyoshi\,\ Hiroshima",
"819722", "Saiki\,\ Oita",
"818244", "Miyoshi\,\ Hiroshima",
"818894", "Susaki\,\ Kochi",
"81462", "Atsugi\,\ Kanagawa",
"811367", "Suttsu\,\ Hokkaido",
"812233", "Iwanuma\,\ Miyagi",
"81535", "Hamamatsu\,\ Shizuoka",
"818544", "Kisuki\,\ Shimane",
"811857", "Noshiro\,\ Akita",
"818546", "Kakeya\,\ Shimane",
"814753", "Mobara\,\ Chiba",
"81586", "Ichinomiya\,\ Aichi",
"817962", "Toyooka\,\ Hyogo",
"818478", "Tojo\,\ Hiroshima",
"818662", "Takahashi\,\ Okayama",
"812565", "Sanjo\,\ Niigata",
"811635", "Hamatonbetsu\,\ Hokkaido",
"81998", "Kagoshima\,\ Kagoshima",
"812659", "Ina\,\ Nagano",
"811735", "Goshogawara\,\ Aomori",
"81549", "Shizuoka\,\ Shizuoka",
"819663", "Hitoyoshi\,\ Kumamoto",
"8168", "Osaka\,\ Osaka",
"814775", "Funabashi\,\ Chiba",
"815362", "Shinshiro\,\ Aichi",
"812547", "Murakami\,\ Niigata",
"8198295", "Hyuga\,\ Miyazaki",
"811465", "Shizunai\,\ Hokkaido",
"812743", "Fujioka\,\ Gunma",
"81875", "Kan\'onji\,\ Kagawa",
"819433", "Yame\,\ Fukuoka",
"81765", "Uozu\,\ Toyama",
"81775", "Otsu\,\ Shiga",
"819963", "Satsumasendai\,\ Kagoshima",
"811935", "Kamaishi\,\ Iwate",
"817466", "Totsukawa\,\ Nara",
"81555", "Fujiyoshida\,\ Yamanashi",
"817464", "Yoshino\,\ Nara",
"817723", "Miyazu\,\ Kyoto",
"817734", "Fukuchiyama\,\ Kyoto",
"819735", "Hita\,\ Oita",
"818806", "Sukumo\,\ Kochi",
"817736", "Maizuru\,\ Kyoto",
"818958", "Misho\,\ Ehime",
"819935", "Kaseda\,\ Kagoshima",
"819805", "Nago\,\ Okinawa",
"81178", "Hachinohe\,\ Aomori",
"812855", "Oyama\,\ Tochigi",
"819688", "Tamana\,\ Kumamoto",
"812247", "Ogawara\,\ Miyagi",
"812897", "Kanuma\,\ Tochigi",
"818466", "Mima\,\ Tokushima",
"819788", "Kunisaki\,\ Oita",
"818464", "Takehara\,\ Hiroshima",
"81744", "Yamatotakada\,\ Nara",
"815974", "Owase\,\ Mie",
"81885", "Komatsushima\,\ Tokushima",
"819809", "Yaeyama\ District\,\ Okinawa",
"812412", "Kitakata\,\ Fukushima",
"8166", "Osaka\,\ Osaka",
"815752", "Sekigahara\,\ Gifu",
"812859", "Oyama\,\ Tochigi",
"8167", "Osaka\,\ Osaka",
"8153972", "Hamamatsu\,\ Shizuoka",
"8153979", "Hamamatsu\,\ Shizuoka",
"81988", "Naha\,\ Okinawa",
"812377", "Sagae\,\ Yamagata",
"8198296", "Hyuga\,\ Miyazaki",
"8169", "Osaka\,\ Osaka",
"818383", "Hagi\,\ Yamaguchi",
"811582", "Monbetsu\,\ Hokkaido",
"817492", "Hikone\,\ Shiga",
"818552", "Hamada\,\ Shimane",
"817904", "Fukusaki\,\ Hyogo",
"812571", "Muika\,\ Niigata",
"817717", "Sonobe\,\ Kyoto",
"811353", "Yoichi\,\ Hokkaido",
"811939", "Miyako\,\ Iwate",
"818368", "Ube\,\ Yamaguchi",
"811863", "Kazuno\,\ Akita",
"817617", "Kaga\,\ Ishikawa",
"81242", "Aizuwakamatsu\,\ Fukushima",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"812997", "Itako\,\ Ibaraki",
"812780", "Maebashi\,\ Gunma",
"819575", "Isahaya\,\ Nagasaki",
"814288", "Ome\,\ Tokyo",
"81932", "Kitakyushu\,\ Fukuoka",
"812797", "Shibukawa\,\ Gunma",
"812784", "Numata\,\ Gunma",
"812786", "Numata\,\ Gunma",
"812697", "Iiyama\,\ Nagano",
"8153971", "Hamamatsu\,\ Shizuoka",
"812655", "Iida\,\ Nagano",
"818834", "Kamojima\,\ Tokushima",
"817704", "Tsuruga\,\ Fukui",
"815394", "Hamamatsu\,\ Shizuoka",
"817706", "Obama\,\ Fukui",
"818836", "Mima\,\ Tokushima",
"81188", "Akita\,\ Akita",
"817368", "Iwade\,\ Wakayama",
"811375", "Yakumo\,\ Hokkaido",
"812914", "Hokota\,\ Ibaraki",
"817687", "Noto\,\ Ishikawa",
"81922", "Fukuoka\,\ Fukuoka",
"818690", "Okayama\,\ Okayama",
"8124196", "Yanaizu\,\ Fukushima",
"819553", "Imari\,\ Saga",
"815768", "Gero\,\ Gifu",
"818694", "Okayama\,\ Okayama",
"81482", "Kawaguchi\,\ Saitama",
"817996", "Tsuna\,\ Hyogo",
"819822", "Nobeoka\,\ Miyazaki",
"818687", "Mimasaka\,\ Okayama",
"818796", "Tonosho\,\ Kagawa",
"817994", "Sumoto\,\ Hyogo",
"818696", "Bizen\,\ Okayama",
"812577", "Muika\,\ Niigata",
"8126171", "Omachi\,\ Nagano",
"812673", "Komoro\,\ Nagano",
"812614", "Omachi\,\ Nagano",
"819957", "Kajiki\,\ Kagoshima",
"8161", "Osaka\,\ Osaka",
"818583", "Kurayoshi\,\ Tottori",
"812616", "Omachi\,\ Nagano",
"812837", "Sano\,\ Tochigi",
"818568", "Tsuwano\,\ Shimane",
"81726", "Ibaraki\,\ Osaka",
"81543", "Shizuoka\,\ Shizuoka",
"812482", "Shirakawa\,\ Fukushima",
"811553", "Obihiro\,\ Hokkaido",
"8186552", "Kurashiki\,\ Okayama",
"81566", "Kariya\,\ Aichi",
"815983", "Matsusaka\,\ Mie",
"8126172", "Omachi\,\ Nagano",
"811757", "Noheji\,\ Aomori",
"811549", "Kushiro\,\ Hokkaido",
"81438", "Kisarazu\,\ Chiba",
"818376", "Mine\,\ Yamaguchi",
"8126179", "Omachi\,\ Nagano",
"81952", "Saga\,\ Saga",
"811957", "Iwate\,\ Iwate",
"818374", "Nagato\,\ Yamaguchi",
"81596", "Ise\,\ Mie",
"812475", "Ishikawa\,\ Fukushima",
"811528", "Bihoro\,\ Hokkaido",
"817352", "Shingu\,\ Fukuoka",
"81965", "Yatsushiro\,\ Kumamoto",
"81270", "Isesaki\,\ Gunma",
"818567", "Tsuwano\,\ Shimane",
"812232", "Iwanuma\,\ Miyagi",
"81975", "Oita\,\ Oita",
"81260", "Anan\,\ Nagano",
"814752", "Mobara\,\ Chiba",
"811936", "Miyako\,\ Iwate",
"81778", "Takefu\,\ Fukui",
"811658", "Kamikawa\,\ Hokkaido",
"81898", "Imabari\,\ Ehime",
"817963", "Toyooka\,\ Hyogo",
"814770", "Ichikawa\,\ Chiba",
"818663", "Soja\,\ Okayama",
"811934", "Kamaishi\,\ Iwate",
"811634", "Hamatonbetsu\,\ Hokkaido",
"8112394", "Yubari\,\ Hokkaido",
"81531", "Tahara\,\ Aichi",
"81798", "Nishinomiya\,\ Hyogo",
"811736", "Goshogawara\,\ Aomori",
"81878", "Takamatsu\,\ Kagawa",
"8147957", "Yokaichiba\,\ Chiba",
"814776", "Funabashi\,\ Chiba",
"811734", "Goshogawara\,\ Aomori",
"811958", "Iwate\,\ Iwate",
"812789", "Maebashi\,\ Gunma",
"811464", "Shizunai\,\ Hokkaido",
"811466", "Erimo\,\ Hokkaido",
"811527", "Bihoro\,\ Hokkaido",
"812856", "Mooka\,\ Tochigi",
"819934", "Ibusuki\,\ Kagoshima",
"819804", "Nago\,\ Okinawa",
"8153978", "Hamamatsu\,\ Shizuoka",
"812854", "Oyama\,\ Tochigi",
"819936", "Kaseda\,\ Kagoshima",
"8186993", "Bizen\,\ Okayama",
"815979", "Kumano\,\ Mie",
"815767", "Gero\,\ Gifu",
"817688", "Noto\,\ Ishikawa",
"81227", "Sendai\,\ Miyagi",
"818688", "Mimasaka\,\ Okayama",
"812578", "Muika\,\ Niigata",
"812872", "Otawara\,\ Tochigi",
"817465", "Yoshino\,\ Nara",
"817735", "Fukuchiyama\,\ Kyoto",
"819734", "Hita\,\ Oita",
"819723", "Saiki\,\ Oita",
"814281", "Sagamihara\,\ Kanagawa",
"812838", "Sano\,\ Tochigi",
"81947", "Tagawa\,\ Fukuoka",
"817718", "Sonobe\,\ Kyoto",
"811546", "Kushiro\,\ Hokkaido",
"811544", "Kushiro\,\ Hokkaido",
"8126178", "Omachi\,\ Nagano",
"818367", "Ube\,\ Yamaguchi",
"817618", "Kaga\,\ Ishikawa",
"812998", "Itako\,\ Ibaraki",
"817722", "Miyazu\,\ Kyoto",
"814287", "Ome\,\ Tokyo",
"818895", "Susaki\,\ Kochi",
"818245", "Miyoshi\,\ Hiroshima",
"812798", "Naganohara\,\ Gunma",
"81551", "Nirasaki\,\ Yamanashi",
"812698", "Iiyama\,\ Nagano",
"815745", "Minokamo\,\ Gifu",
"81582", "Gifu\,\ Gifu",
"817367", "Iwade\,\ Wakayama",
"812566", "Sanjo\,\ Niigata",
"81476", "Narita\,\ Chiba",
"81466", "Fujisawa\,\ Kanagawa",
"812564", "Sanjo\,\ Niigata",
"819662", "Hitoyoshi\,\ Kumamoto",
"815363", "Shinshiro\,\ Aichi",
"819544", "Takeo\,\ Saga",
"819432", "Yame\,\ Fukuoka",
"819546", "Kashima\,\ Saga",
"812742", "Fujioka\,\ Gunma",
"812378", "Sagae\,\ Yamagata",
"812619", "Omachi\,\ Nagano",
"818545", "Kisuki\,\ Shimane",
"819962", "Satsumasendai\,\ Kagoshima",
"81538", "Iwata\,\ Shizuoka",
"8199343", "Kagoshima\,\ Kagoshima",
"812560", "Itoigawa\,\ Niigata",
"81143", "Muroran\,\ Hokkaido",
"819668", "Minamata\,\ Kumamoto",
"81762", "Kanazawa\,\ Ishikawa",
"811983", "Hanamaki\,\ Iwate",
"814240", "Kokubunji\,\ Tokyo",
"81176", "Towada\,\ Aomori",
"812648", "Nagano\,\ Nagano",
"812385", "Yonezawa\,\ Yamagata",
"81892", "Kumakogen\,\ Ehime",
"819438", "Tanushimaru\,\ Fukuoka",
"812748", "Tomioka\,\ Gunma",
"81166", "Asahikawa\,\ Hokkaido",
"812372", "Murayama\,\ Yamagata",
"81196", "Morioka\,\ Iwate",
"81862", "Okayama\,\ Okayama",
"818295", "Hatsukaichi\,\ Hiroshima",
"81792", "Himeji\,\ Hyogo",
"817455", "Yamatotakada\,\ Nara",
"817484", "Yokaichi\,\ Shiga",
"819968", "Izumi\,\ Kagoshima",
"811587", "Nakayubetsu\,\ Hokkaido",
"817497", "Nagahama\,\ Shiga",
"815995", "Ago\,\ Mie",
"817486", "Minakuchi\,\ Shiga",
"817949", "Kakogawa\,\ Hyogo",
"817712", "Kameoka\,\ Kyoto",
"818557", "Kawamoto\,\ Shimane",
"817612", "Komatsu\,\ Ishikawa",
"8153967", "Hamamatsu\,\ Shizuoka",
"817953", "Nishiwaki\,\ Hyogo",
"812992", "Ishioka\,\ Ibaraki",
"818595", "Yonago\,\ Tottori",
"819596", "Fukue\,\ Nagasaki",
"812792", "Shibukawa\,\ Gunma",
"818953", "Uwajima\,\ Ehime",
"81294", "Hitachiota\,\ Ibaraki",
"812692", "Nakano\,\ Nagano",
"818949", "Uwajima\,\ Ehime",
"817912", "Aioi\,\ Hyogo",
"819683", "Yamaga\,\ Kumamoto",
"811454", "Mukawa\,\ Hokkaido",
"81552", "Kofu\,\ Yamanashi",
"81233", "Shinjo\,\ Yamagata",
"819783", "Bungotakada\,\ Oita",
"812556", "Itoigawa\,\ Niigata",
"81465", "Odawara\,\ Kanagawa",
"812554", "Joetsu\,\ Niigata",
"812585", "Nagaoka\,\ Niigata",
"819974", "Yakushima\,\ Kagoshima",
"817682", "Wajima\,\ Ishikawa",
"819976", "Naze\,\ Kagoshima",
"818675", "Kuse\,\ Okayama",
"818682", "Tsuyama\,\ Okayama",
"819827", "Takachiho\,\ Miyazaki",
"818975", "Niihama\,\ Ehime",
"819676", "Takamori\,\ Kumamoto",
"812878", "Nasukarasuyama\,\ Tochigi",
"817239", "Neyagawa\,\ Osaka",
"812572", "Kashiwazaki\,\ Niigata",
"817675", "Nanao\,\ Ishikawa",
"819952", "Okuchi\,\ Kagoshima",
"81495", "Honjo\,\ Saitama",
"811396", "Esashi\,\ Hokkaido",
"811394", "Matsumae\,\ Hokkaido",
"812832", "Sano\,\ Tochigi",
"812550", "Yasuzuka\,\ Niigata",
"812238", "Sendai\,\ Miyagi",
"811976", "Kitakami\,\ Iwate",
"811974", "Mizusawa\,\ Iwate",
"8198298", "Hyuga\,\ Miyazaki",
"818205", "Yanai\,\ Yamaguchi",
"812487", "Sukagawa\,\ Fukushima",
"814758", "Togane\,\ Chiba",
"811652", "Shibetsu\,\ Hokkaido",
"8183767", "Shimonoseki\,\ Yamaguchi",
"811752", "Mutsu\,\ Aomori",
"811952", "Ninohe\,\ Iwate",
"81253", "Niigata\,\ Niigata",
"81532", "Toyohashi\,\ Aichi",
"818879", "Muroto\,\ Kochi",
"817357", "Kushimoto\,\ Wakayama",
"815582", "Shimoda\,\ Shizuoka",
"812237", "Sendai\,\ Miyagi",
"811363", "Kutchan\,\ Hokkaido",
"818562", "Masuda\,\ Shimane",
"8128798", "Otawara\,\ Tochigi",
"814757", "Togane\,\ Chiba",
"812488", "Sukagawa\,\ Fukushima",
"811853", "Oga\,\ Akita",
"812965", "Shimodate\,\ Ibaraki",
"814795", "Choshi\,\ Chiba",
"817944", "Kakogawa\,\ Hyogo",
"81547", "Shimada\,\ Shizuoka",
"819945", "Kanoya\,\ Kagoshima",
"817946", "Miki\,\ Hyogo",
"817940", "Kakogawa\,\ Hyogo",
"818944", "Yawatahama\,\ Ehime",
"818946", "Uwajima\,\ Ehime",
"81138", "Hakodate\,\ Hokkaido",
"8125484", "Murakami\,\ Niigata",
"819599", "Oseto\,\ Nagasaki",
"811522", "Shari\,\ Hokkaido",
"81835", "Hofu\,\ Yamaguchi",
"811945", "Kuji\,\ Iwate",
"81886", "Tokushima\,\ Tokushima",
"81740", "Imazu\,\ Shiga",
"815762", "Gero\,\ Gifu",
"812933", "Takahagi\,\ Ibaraki",
"8126176", "Omachi\,\ Nagano",
"819828", "Takachiho\,\ Miyazaki",
"81938", "Kitakyushu\,\ Fukuoka",
"812877", "Kuroiso\,\ Tochigi",
"811645", "Rumoi\,\ Hokkaido",
"8199347", "Kagoshima\,\ Kagoshima",
"81182", "Yokote\,\ Akita",
"818262", "Kake\,\ Hiroshima",
"81725", "Izumi\,\ Osaka",
"818558", "Kawamoto\,\ Shimane",
"81849", "Fukuyama\,\ Hiroshima",
"811563", "Honbetsu\,\ Hokkaido",
"818362", "Ube\,\ Yamaguchi",
"81565", "Toyota\,\ Aichi",
"81928", "Fukuoka\,\ Fukuoka",
"8198292", "Nobeoka\,\ Miyazaki",
"814282", "Ome\,\ Tokyo",
"8198299", "Hyuga\,\ Miyazaki",
"811235", "Yubari\,\ Hokkaido",
"818874", "Aki\,\ Kochi",
"8153976", "Hamamatsu\,\ Shizuoka",
"81488", "Urawa\,\ Saitama",
"812893", "Utsunomiya\,\ Tochigi",
"81825", "Hiroshima\,\ Hiroshima",
"812243", "Shiroishi\,\ Miyagi",
"819979", "Tokunoshima\,\ Kagoshima",
"8186997", "Seto\,\ Okayama",
"819667", "Minamata\,\ Kumamoto",
"811875", "Kakunodate\,\ Akita",
"812543", "Shibata\,\ Niigata",
"817230", "Neyagawa\,\ Osaka",
"812647", "Nagano\,\ Nagano",
"812747", "Tomioka\,\ Gunma",
"812559", "Yasuzuka\,\ Niigata",
"819437", "Tanushimaru\,\ Fukuoka",
"811535", "Akkeshi\,\ Hokkaido",
"81958", "Nagasaki\,\ Nagasaki",
"815958", "Kameyama\,\ Mie",
"815734", "Ena\,\ Gifu",
"81432", "Chiba\,\ Chiba",
"815736", "Nakatsugawa\,\ Gifu",
"8147950", "Yokaichiba\,\ Chiba",
"8198291", "Nobeoka\,\ Miyazaki",
"817498", "Nagahama\,\ Shiga",
"811588", "Okoppe\,\ Hokkaido",
"819967", "Izumi\,\ Kagoshima",
"814705", "Tateyama\,\ Chiba",
"819679", "Takamori\,\ Kumamoto",
"818391", "Ogori\,\ Yamaguchi",
"815984", "Matsusaka\,\ Mie",
"8182941", "Hiroshima\,\ Hiroshima",
"815997", "Ago\,\ Mie",
"815986", "Matsusaka\,\ Mie",
"817495", "Nagahama\,\ Shiga",
"811585", "Engaru\,\ Hokkaido",
"811554", "Obihiro\,\ Hokkaido",
"81427", "Sagamihara\,\ Kanagawa",
"817457", "Yamatotakada\,\ Nara",
"811556", "Obihiro\,\ Hokkaido",
"81542", "Shizuoka\,\ Shizuoka",
"818297", "Hatsukaichi\,\ Hiroshima",
"812387", "Nagai\,\ Yamagata",
"81987", "Nichinan\,\ Miyazaki",
"815755", "Sekigahara\,\ Gifu",
"812415", "Yanaizu\,\ Fukushima",
"818373", "Nagato\,\ Yamaguchi",
"811878", "Omagari\,\ Akita",
"81460", "Odawara\,\ Kanagawa",
"819556", "Karatsu\,\ Saga",
"81923", "Fukuoka\,\ Fukuoka",
"819554", "Imari\,\ Saga",
"812652", "Iida\,\ Nagano",
"812913", "Hokota\,\ Ibaraki",
"811238", "Kuriyama\,\ Hokkaido",
"818584", "Kurayoshi\,\ Tottori",
"812676", "Saku\,\ Nagano",
"819572", "Isahaya\,\ Nagasaki",
"812674", "Komoro\,\ Nagano",
"812613", "Omachi\,\ Nagano",
"818586", "Kurayoshi\,\ Tottori",
"817993", "Sumoto\,\ Hyogo",
"8182942", "Hiroshima\,\ Hiroshima",
"818693", "Oku\,\ Okayama",
"818555", "Gotsu\,\ Shimane",
"81266", "Suwa\,\ Nagano",
"81276", "Ota\,\ Gunma",
"811864", "Odate\,\ Akita",
"817677", "Nanao\,\ Ishikawa",
"818669", "Soja\,\ Okayama",
"811356", "Iwanai\,\ Hokkaido",
"81243", "Nihonmatsu\,\ Fukushima",
"817903", "Fukusaki\,\ Hyogo",
"8153965", "Hamamatsu\,\ Shizuoka",
"811354", "Yoichi\,\ Hokkaido",
"819825", "Hyuga\,\ Miyazaki",
"817969", "Hamasaka\,\ Hyogo",
"818977", "Hakata\,\ Ehime",
"8112399", "Kuriyama\,\ Hokkaido",
"811866", "Takanosu\,\ Akita",
"8112392", "Yubari\,\ Hokkaido",
"818677", "Niimi\,\ Okayama",
"812587", "Nagaoka\,\ Niigata",
"818833", "Kamojima\,\ Tokushima",
"817703", "Tsuruga\,\ Fukui",
"815393", "Hamamatsu\,\ Shizuoka",
"81933", "Kitakyushu\,\ Fukuoka",
"818514", "Ama\,\ Shimane",
"812783", "Numata\,\ Gunma",
"811372", "Shikabe\,\ Hokkaido",
"817355", "Shingu\,\ Fukuoka",
"812472", "Ishikawa\,\ Fukushima",
"81174", "Kanita\,\ Aomori",
"8112391", "Yubari\,\ Hokkaido",
"814998", "Ogasawara\,\ Tokyo",
"815973", "Owase\,\ Mie",
"8178", "Kobe\,\ Hyogo",
"818384", "Hagi\,\ Yamaguchi",
"819948", "Shibushi\,\ Kagoshima",
"814798", "Yokaichiba\,\ Chiba",
"818397", "Ogori\,\ Yamaguchi",
"812968", "Kasama\,\ Ibaraki",
"812485", "Shirakawa\,\ Fukushima",
"8125486", "Tsugawa\,\ Niigata",
"819543", "Takeo\,\ Saga",
"812563", "Sanjo\,\ Niigata",
"8186995", "Seto\,\ Okayama",
"815366", "Shitara\,\ Aichi",
"819747", "Taketa\,\ Oita",
"8111", "Sapporo\,\ Hokkaido",
"81797", "Nishinomiya\,\ Hyogo",
"81877", "Marugame\,\ Kagawa",
"818398", "Ogori\,\ Yamaguchi",
"814797", "Yokaichiba\,\ Chiba",
"814701", "Kamogawa\,\ Chiba",
"819947", "Shibushi\,\ Kagoshima",
"814755", "Togane\,\ Chiba",
"812967", "Kasama\,\ Ibaraki",
"812235", "Sendai\,\ Miyagi",
"812679", "Saku\,\ Nagano",
"811559", "Obihiro\,\ Hokkaido",
"811647", "Haboro\,\ Hokkaido",
"817732", "Fukuchiyama\,\ Kyoto",
"811543", "Kushiro\,\ Hokkaido",
"817678", "Nanao\,\ Ishikawa",
"81739", "Tanabe\,\ Wakayama",
"812875", "Otawara\,\ Tochigi",
"818978", "Hakata\,\ Ehime",
"8126174", "Omachi\,\ Nagano",
"81583", "Gifu\,\ Gifu",
"818462", "Takehara\,\ Hiroshima",
"818678", "Niimi\,\ Okayama",
"81839", "Yamaguchi\,\ Yamaguchi",
"812588", "Nagaoka\,\ Niigata",
"811337", "Ishikari\,\ Hokkaido",
"811947", "Kuji\,\ Iwate",
"81557", "Ito\,\ Shizuoka",
"81948", "Iizuka\,\ Fukuoka",
"815742", "Minokamo\,\ Gifu",
"815566", "Minobu\,\ Yamanashi",
"812853", "Oyama\,\ Tochigi",
"819933", "Ibusuki\,\ Kagoshima",
"811237", "Kuriyama\,\ Hokkaido",
"819803", "Nago\,\ Okinawa",
"819726", "Usuki\,\ Oita",
"8199345", "Kagoshima\,\ Kagoshima",
"818242", "Higashi\-ku\,\ Hiroshima",
"818892", "Sakawa\,\ Kochi",
"81729", "Yao\,\ Osaka",
"817725", "Miyazu\,\ Kyoto",
"81845", "Innoshima\,\ Hiroshima",
"819733", "Hita\,\ Oita",
"819724", "Saiki\,\ Oita",
"81569", "Handa\,\ Aichi",
"815998", "Ago\,\ Mie",
"818664", "Takahashi\,\ Okayama",
"811933", "Kamaishi\,\ Iwate",
"811869", "Odate\,\ Akita",
"8188096", "Tosashimizu\,\ Kochi",
"817964", "Toyooka\,\ Hyogo",
"818666", "Ibara\,\ Okayama",
"819965", "Satsumasendai\,\ Kagoshima",
"818542", "Yasugi\,\ Shimane",
"818298", "Hatsukaichi\,\ Hiroshima",
"812745", "Fujioka\,\ Gunma",
"812388", "Nagai\,\ Yamagata",
"819435", "Yame\,\ Fukuoka",
"811537", "Nakashibetsu\,\ Hokkaido",
"81282", "Tochigi\,\ Tochigi",
"811463", "Urakawa\,\ Hokkaido",
"819665", "Hitoyoshi\,\ Kumamoto",
"811877", "Omagari\,\ Akita",
"811733", "Goshogawara\,\ Aomori",
"818660", "Seto\,\ Okayama",
"8112398", "Kuriyama\,\ Hokkaido",
"81537", "Kakegawa\,\ Shizuoka",
"815992", "Toba\,\ Mie",
"818474", "Fuchu\,\ Hiroshima",
"81564", "Okazaki\,\ Aichi",
"818476", "Fuchu\,\ Hiroshima",
"817452", "Yamatotakada\,\ Nara",
"811973", "Mizusawa\,\ Iwate",
"818292", "Hiroshima\,\ Hiroshima",
"818842", "Anan\,\ Tokushima",
"8198294", "Nobeoka\,\ Miyazaki",
"812375", "Murayama\,\ Yamagata",
"812382", "Yonezawa\,\ Yamagata",
"81252", "Niigata\,\ Niigata",
"81533", "Toyohashi\,\ Aichi",
"81594", "Kuwana\,\ Mie",
"81281", "Utsunomiya\,\ Tochigi",
"812899", "Kanuma\,\ Tochigi",
"817476", "Shimonoseki\,\ Yamaguchi",
"812549", "Tsugawa\,\ Niigata",
"812657", "Ina\,\ Nagano",
"817915", "Aioi\,\ Hyogo",
"8188099", "Tosashimizu\,\ Kochi",
"81222", "Sendai\,\ Miyagi",
"812695", "Nakano\,\ Nagano",
"812553", "Joetsu\,\ Niigata",
"812795", "Shibukawa\,\ Gunma",
"811393", "Matsumae\,\ Hokkaido",
"818592", "Yonago\,\ Tottori",
"818248", "Shobara\,\ Hiroshima",
"812995", "Ishioka\,\ Ibaraki",
"819577", "Shimabara\,\ Nagasaki",
"817615", "Komatsu\,\ Ishikawa",
"812957", "Daigo\,\ Ibaraki",
"817715", "Kameoka\,\ Kyoto",
"818654", "Kamogata\,\ Okayama",
"812835", "Sano\,\ Tochigi",
"8125489", "Tsugawa\,\ Niigata",
"817956", "Sanda\,\ Hyogo",
"817954", "Nishiwaki\,\ Hyogo",
"818808", "Tosashimizu\,\ Kochi",
"819955", "Kajiki\,\ Kagoshima",
"817738", "Maizuru\,\ Kyoto",
"81942", "Kurume\,\ Fukuoka",
"818656", "Kasaoka\,\ Okayama",
"817468", "Kamikitayama\,\ Nara",
"817672", "Hakui\,\ Ishikawa",
"812575", "Tokamachi\,\ Niigata",
"818972", "Niihama\,\ Ehime",
"818685", "Tsuyama\,\ Okayama",
"8186697", "Kurashiki\,\ Okayama",
"819686", "Tamana\,\ Kumamoto",
"81553", "Yamanashi\,\ Yamanashi",
"819784", "Bungotakada\,\ Oita",
"819786", "Kitsuki\,\ Oita",
"817685", "Wajima\,\ Ishikawa",
"811453", "Hayakita\,\ Hokkaido",
"819684", "Yamaga\,\ Kumamoto",
"812582", "Nagaoka\,\ Niigata",
"818956", "Uwajima\,\ Ehime",
"81587", "Ichinomiya\,\ Aichi",
"819593", "Oseto\,\ Nagasaki",
"8125482", "Murakami\,\ Niigata",
"817950", "Sanda\,\ Hyogo",
"811377", "Yakumo\,\ Hokkaido",
"818954", "Uwajima\,\ Ehime",
"81893", "Ozu\,\ Ehime",
"815585", "Shimoda\,\ Shizuoka",
"811986", "Tono\,\ Iwate",
"81763", "Fukuno\,\ Toyama",
"8125481", "Murakami\,\ Niigata",
"812477", "Miharu\,\ Fukushima",
"811984", "Hanamaki\,\ Iwate",
"81142", "Date\,\ Hokkaido",
"811955", "Ninohe\,\ Iwate",
"812939", "Mito\,\ Ibaraki",
"81834", "Tokuyama\,\ Yamaguchi",
"81288", "Imabari\,\ Ehime",
"8182920", "Hatsukaichi\,\ Hiroshima",
"81734", "Wakayama\,\ Wakayama",
"817483", "Yokaichi\,\ Shiga",
"811655", "Nayoro\,\ Hokkaido",
"818202", "Yanai\,\ Yamaguchi",
"81793", "Himeji\,\ Hyogo",
"81863", "Tamano\,\ Okayama",
"811525", "Abashiri\,\ Hokkaido",
"812478", "Miharu\,\ Fukushima",
"81464", "Atsugi\,\ Kanagawa",
"812544", "Shibata\,\ Niigata",
"81548", "Haibara\,\ Shizuoka",
"8112396", "Kuriyama\,\ Hokkaido",
"81474", "Funabashi\,\ Chiba",
"812546", "Murakami\,\ Niigata",
"819742", "Mie\,\ Oita",
"81969", "Amakusa\,\ Kumamoto",
"8175", "Kyoto\,\ Kyoto",
"8188098", "Tosashimizu\,\ Kochi",
"81979", "Nakatsu\,\ Oita",
"814792", "Choshi\,\ Chiba",
"81494", "Chichibu\,\ Saitama",
"81433", "Chiba\,\ Chiba",
"812962", "Shimodate\,\ Ibaraki",
"818565", "Masuda\,\ Shimane",
"815733", "Ena\,\ Gifu",
"81199", "Morioka\,\ Iwate",
"817737", "Maizuru\,\ Kyoto",
"818807", "Sukumo\,\ Kochi",
"811564", "Kamishihoro\,\ Hokkaido",
"818479", "Tojo\,\ Hiroshima",
"812890", "Utsunomiya\,\ Tochigi",
"812246", "Ogawara\,\ Miyagi",
"812896", "Kanuma\,\ Tochigi",
"818467", "Mima\,\ Tokushima",
"811332", "Tobetsu\,\ Hokkaido",
"815765", "Gero\,\ Gifu",
"812894", "Utsunomiya\,\ Tochigi",
"81937", "Kitakyushu\,\ Fukuoka",
"812244", "Shiroishi\,\ Miyagi",
"81179", "Sannohe\,\ Aomori",
"811942", "Iwaizumi\,\ Iwate",
"811378", "Imakane\,\ Hokkaido",
"818873", "Aki\,\ Kochi",
"812934", "Takahagi\,\ Ibaraki",
"812936", "Mito\,\ Ibaraki",
"812658", "Ina\,\ Nagano",
"811232", "Chitose\,\ Hokkaido",
"81927", "Fukuoka\,\ Fukuoka",
"814285", "Sagamihara\,\ Kanagawa",
"818247", "Shobara\,\ Hiroshima",
"819578", "Shimabara\,\ Nagasaki",
"81183", "Yuzawa\,\ Akita",
"81487", "Urawa\,\ Saitama",
"812930", "Mito\,\ Ibaraki",
"818365", "Ube\,\ Yamaguchi",
"81157", "Kitami\,\ Hokkaido",
"81423", "Kokubunji\,\ Tokyo",
"814702", "Tateyama\,\ Chiba",
"819232", "Maebaru\,\ Fukuoka",
"817943", "Kakogawa\,\ Hyogo",
"811854", "Oga\,\ Akita",
"811366", "Suttsu\,\ Hokkaido",
"811364", "Kutchan\,\ Hokkaido",
"818547", "Kakeya\,\ Shimane",
"811856", "Noshiro\,\ Akita",
"817959", "Sanda\,\ Hyogo",
"811532", "Nemuro\,\ Hokkaido",
"8125488", "Tsugawa\,\ Niigata",
"819789", "Kitsuki\,\ Oita",
"8147955", "Yokaichiba\,\ Chiba",
"81983", "Takanabe\,\ Miyazaki",
"818943", "Yawatahama\,\ Ehime",};
$areanames{ja} = {"812375", "村山",
"8198294", "延岡",
"81564", "岡崎",
"818476", "府中",
"818474", "府中",
"815992", "鳥羽",
"817476", "下市",
"81594", "桑名",
"817474", "五条",
"81252", "新潟",
"81533", "豊橋",
"819973", "種子島",
"812549", "津川",
"819673", "熊本一の宮",
"819577", "島原",
"818248", "庄原",
"818592", "米子",
"811393", "松前",
"818685", "津山",
"817468", "上北山",
"812575", "十日町",
"817954", "西脇",
"818656", "笠岡",
"812835", "佐野",
"818654", "鴨方",
"8125489", "津川",
"817956", "三田",
"8125482", "村上",
"818954", "宇和島",
"818956", "宇和島",
"81587", "一宮",
"817685", "輪島",
"81553", "山梨",
"81834", "徳山",
"811955", "二戸",
"81142", "伊達",
"812939", "水戸",
"8125481", "村上",
"81763", "福野",
"811984", "花巻",
"811986", "遠野",
"815585", "下田",
"81893", "大洲",
"81863", "玉野",
"818202", "柳井",
"81793", "姫路",
"81734", "和歌山",
"811655", "名寄",
"81288", "今市",
"8112396", "栗山",
"812546", "村上",
"814992", "伊豆大島",
"81474", "船橋",
"819742", "三重",
"81464", "厚木",
"81548", "榛原",
"812544", "新発田",
"811525", "網走",
"812962", "下館",
"81433", "千葉",
"819942", "大根占",
"81979", "中津",
"81494", "秩父",
"814792", "銚子",
"81969", "天草",
"8175", "京都",
"812890", "宇都宮",
"818479", "東城",
"818265", "安芸吉田",
"818467", "木江",
"811232", "千歳",
"81927", "福岡",
"812936", "水戸",
"812934", "高萩",
"81157", "北見",
"819578", "島原",
"81487", "浦和",
"81183", "湯沢",
"818247", "庄原",
"817959", "三田",
"811856", "能代",
"811854", "男鹿",
"8125488", "津川",
"81542", "静岡",
"811556", "帯広",
"815955", "上野",
"811554", "帯広",
"811585", "遠軽",
"815986", "松阪",
"815984", "松阪",
"815997", "阿児",
"815755", "関",
"812976", "竜ケ崎",
"811238", "栗山",
"812913", "鉾田",
"812974", "水海道",
"81923", "福岡",
"81460", "小田原",
"818693", "邑久",
"818555", "江津",
"817993", "洲本",
"818793", "三本松",
"812674", "小諸",
"819572", "諫早",
"818586", "倉吉",
"812613", "大町",
"818584", "倉吉",
"818597", "根雨",
"812676", "佐久",
"811354", "余市",
"8112399", "栗山",
"81243", "二本松",
"811356", "岩内",
"815393", "浜松",
"8112392", "夕張",
"814998", "小笠原",
"8112391", "夕張",
"81174", "蟹田",
"817355", "新宮",
"812968", "笠間",
"812485", "白河",
"818207", "久賀",
"819948", "志布志",
"818384", "萩",
"818397", "小郡",
"814798", "八日市場",
"8178", "神戸",
"819747", "竹田",
"812563", "三条",
"819543", "武雄",
"812979", "竜ケ崎",
"8125486", "津川",
"812679", "佐久",
"814755", "東金",
"818208", "久賀",
"812967", "笠間",
"818398", "小郡",
"814797", "八日市場",
"819947", "志布志",
"814701", "鴨川",
"81877", "丸亀",
"81797", "西宮",
"812875", "大田原",
"811559", "帯広",
"81557", "伊東",
"81583", "岐阜",
"818462", "竹原",
"819933", "指宿",
"819803", "名護",
"811237", "栗山",
"817725", "宮津",
"81845", "因島",
"819733", "日田",
"818892", "佐川",
"81729", "八尾",
"818598", "根雨",
"818242", "東広島",
"819965", "川内",
"815998", "阿児",
"817960", "八鹿",
"81537", "掛川",
"818660", "岡山瀬戸",
"819665", "人吉",
"8112398", "栗山",
"81282", "栃木",
"812645", "木曾福島",
"811463", "浦河",
"812745", "藤岡",
"81892", "久万",
"819438", "田主丸",
"812385", "米沢",
"81762", "金沢",
"814240", "国分寺",
"812417", "会津山口",
"81143", "室蘭",
"817486", "水口",
"817484", "八日市",
"817497", "長浜",
"817455", "大和高田",
"81792", "姫路",
"818295", "廿日市",
"81862", "岡山",
"818845", "丹生谷",
"812992", "石岡",
"817612", "小松",
"817712", "亀岡",
"817949", "加古川",
"811456", "門別富川",
"81233", "新庄",
"81552", "甲府",
"819783", "豊後高田",
"817912", "相生",
"818949", "宇和",
"819683", "山鹿",
"811454", "鵡川",
"819594", "有川",
"812692", "中野",
"819596", "福江",
"812792", "渋川",
"81294", "常陸太田",
"818675", "久世",
"814227", "武蔵野三鷹",
"812585", "長岡",
"81465", "小田原",
"812554", "上越",
"812556", "糸魚川",
"819952", "大口",
"81495", "本庄",
"817675", "七尾",
"819827", "高千穂",
"818975", "新居浜",
"8183767", "下関",
"8198298", "日向",
"811974", "水沢",
"811976", "北上",
"812238", "仙台",
"819204", "郷ノ浦",
"818879", "室戸",
"81253", "新潟",
"81532", "豊橋",
"817946", "三木",
"817944", "加古川",
"81547", "島田",
"818562", "益田",
"812237", "仙台",
"811363", "倶知安",
"8125484", "村上",
"819599", "大瀬戸",
"81138", "函館",
"818946", "宇和",
"818944", "八幡浜",
"814228", "武蔵野三鷹",
"81740", "今津",
"815762", "下呂",
"811945", "久慈",
"81835", "防府",
"81182", "横手",
"811645", "留萌",
"819828", "高千穂",
"81928", "福岡",
"8198292", "延岡",
"814282", "青梅",
"81565", "豊田",
"818362", "宇部",
"811563", "本別",
"817362", "和歌山橋本",
"812243", "白石",
"812893", "宇都宮",
"818876", "土佐山田",
"81488", "浦和",
"8198299", "日向",
"818874", "安芸",
"812559", "安塚",
"819437", "田主丸",
"811535", "厚岸",
"812418", "会津山口",
"811875", "角館",
"817230", "寝屋川",
"814705", "館山",
"817498", "長浜",
"81432", "千葉",
"815736", "中津川",
"8198291", "延岡",
"815734", "恵那",
"812859", "小山",
"812412", "喜多方",
"81885", "小松島",
"81744", "大和高田",
"815974", "尾鷲",
"817492", "彦根",
"8198296", "日向",
"814288", "青梅",
"812997", "潮来",
"817617", "加賀",
"818368", "宇部",
"811863", "鹿角",
"811939", "宮古",
"817906", "播磨山崎",
"812955", "常陸大宮",
"81242", "会津若松",
"817717", "園部",
"812571", "六日町",
"817904", "福崎",
"817706", "小浜",
"817368", "岩出",
"81188", "秋田",
"818836", "脇町",
"818834", "鴨島",
"812655", "飯田",
"811639", "利尻礼文",
"817704", "敦賀",
"817917", "竜野",
"812786", "沼田",
"812697", "飯山",
"812797", "渋川",
"812784", "沼田",
"81922", "福岡",
"8124196", "柳津",
"818690", "岡山",
"815768", "下呂",
"814222", "武蔵野三鷹",
"819553", "伊万里",
"811375", "八雲",
"8161", "大阪",
"819957", "加治木",
"81482", "川口",
"819822", "延岡",
"811549", "釧路",
"81726", "茨木",
"818568", "津和野",
"81543", "静岡",
"812475", "石川",
"818374", "長門",
"818376", "美祢",
"81438", "木更津",
"818663", "総社",
"811934", "釜石",
"817963", "豊岡",
"81898", "今治",
"811936", "宮古",
"81778", "武生",
"81260", "阿南町",
"81270", "伊勢崎",
"812232", "岩沼",
"818567", "津和野",
"812789", "前橋",
"811734", "五所川原",
"811636", "北見枝幸",
"8112394", "夕張",
"811634", "浜頓別",
"81878", "高松",
"814776", "船橋",
"81798", "西宮",
"811736", "五所川原",
"815767", "下呂",
"815979", "熊野",
"812854", "小山",
"812856", "真岡",
"815563", "鰍沢青柳",
"817735", "福知山",
"818805", "土佐中村",
"819723", "佐伯",
"814287", "青梅",
"812998", "潮来",
"811544", "釧路",
"817618", "加賀",
"818367", "宇部",
"811546", "釧路",
"817718", "園部",
"817367", "岩出",
"81582", "岐阜",
"815745", "美濃加茂",
"812698", "飯山",
"812798", "長野原",
"819432", "八女",
"815363", "新城",
"81538", "磐田",
"812560", "糸魚川",
"818545", "木次",
"818657", "笠岡",
"817957", "丹波柏原",
"812615", "大町",
"818795", "三本松",
"817995", "洲本",
"81822", "広島",
"818695", "岡山瀬戸",
"811352", "余市",
"818553", "浜田",
"81722", "堺",
"818957", "御荘",
"815753", "関",
"811987", "遠野",
"81486", "浦和",
"811583", "紋別",
"818382", "萩",
"818249", "東広島",
"815953", "上野",
"8112397", "栗山",
"81926", "福岡",
"818477", "東城",
"815982", "松阪",
"81985", "宮崎",
"811552", "帯広",
"811858", "能代",
"812483", "白河",
"81246", "いわき",
"817353", "新宮",
"8125480", "村上",
"81425", "立川",
"81944", "瀬高",
"812938", "水戸",
"815395", "浜松",
"812972", "水海道",
"819576", "島原",
"818582", "倉吉",
"8125483", "村上",
"812672", "小諸",
"819574", "諫早",
"812937", "水戸",
"81191", "一関",
"818894", "須崎",
"818244", "三次",
"818246", "三次",
"818896", "須崎",
"812873", "大田原",
"818478", "東城",
"811857", "能代",
"814753", "茂原",
"81586", "一宮",
"812565", "三条",
"812743", "藤岡",
"812643", "木曾福島",
"811465", "静内",
"8168", "大阪",
"819663", "人吉",
"81549", "静岡",
"812547", "村上",
"8198295", "日向",
"81998", "鹿児島",
"819963", "川内",
"817723", "宮津",
"817958", "丹波柏原",
"819735", "日田",
"817464", "吉野",
"817466", "十津川",
"818464", "竹原",
"818466", "木江",
"819935", "加世田",
"818958", "御荘",
"819805", "名護",
"811395", "江差",
"818652", "倉敷",
"817952", "西脇",
"819675", "熊本一の宮",
"812580", "十日町",
"811357", "岩内",
"819975", "名瀬",
"818952", "宇和島",
"811982", "花巻",
"8165", "大阪",
"8125487", "津川",
"818387", "田万川",
"818204", "柳井",
"818206", "柳井",
"812373", "村山",
"815987", "三瀬谷",
"818472", "甲山",
"811753", "むつ",
"815994", "阿児",
"815996", "阿児",
"811653", "士別",
"81992", "鹿児島",
"811557", "十勝池田",
"815583", "下田",
"818290", "広島",
"81962", "熊本",
"811953", "二戸",
"817472", "五条",
"8112390", "夕張",
"817683", "輪島",
"819912", "中之島",
"812977", "竜ケ崎",
"8163", "大阪",
"818587", "郡家",
"812833", "宇都宮",
"818594", "米子",
"818596", "米子",
"812677", "佐久",
"8112393", "夕張",
"81776", "福井",
"812573", "柏崎",
"81896", "伊予三島",
"819949", "大根占",
"81471", "柏",
"818683", "津山",
"81766", "高岡",
"8199331", "鹿児島",
"812932", "高萩",
"81436", "市原",
"81828", "広島",
"812978", "竜ケ崎",
"811236", "千歳",
"811234", "千歳",
"818588", "郡家",
"818263", "加計",
"81728", "寝屋川",
"812678", "佐久",
"81220", "迫",
"815988", "三瀬谷",
"811852", "男鹿",
"811558", "広尾",
"81125", "滝川",
"811523", "斜里",
"814700", "鴨川",
"812542", "新発田",
"814996", "八丈島",
"819746", "竹田",
"819744", "三重",
"814994", "三宅",
"819946", "鹿屋",
"81259", "佐渡",
"814796", "八日市場",
"814794", "銚子",
"818388", "田万川",
"819944", "鹿屋",
"812964", "下館",
"81935", "北九州",
"815999", "津",
"81591", "津",
"81940", "宗像",
"81561", "瀬戸",
"812557", "新井",
"812653", "飯田",
"814224", "武蔵野三鷹",
"814226", "武蔵野三鷹",
"819824", "延岡",
"811865", "大館",
"819826", "日向",
"8164", "大阪",
"811977", "北上",
"817948", "三木",
"818948", "宇和",
"818372", "長門",
"815972", "尾鷲",
"812473", "石川",
"812414", "柳津",
"812416", "田島",
"815738", "中津川",
"8125485", "津川",
"817487", "水口",
"817494", "彦根",
"817496", "長浜",
"81823", "呉",
"817902", "福崎",
"812239", "仙台",
"818878", "嶺北",
"812782", "沼田",
"819597", "福江",
"81546", "静岡",
"817702", "敦賀",
"811457", "門別富川",
"818832", "鴨島",
"81723", "堺",
"819555", "唐津",
"81286", "宇都宮",
"81930", "行橋",
"811542", "釧路",
"817733", "福知山",
"819725", "佐伯",
"818803", "土佐中村",
"81984", "小林",
"81929", "福岡",
"818877", "嶺北",
"815565", "鰍沢青柳",
"819598", "福江",
"81424", "武蔵野三鷹",
"81489", "草加",
"814229", "武蔵野三鷹",
"819434", "八女",
"812640", "長野",
"815737", "中津川",
"8152", "名古屋",
"817965", "豊岡",
"817488", "水口",
"818665", "高梁",
"812234", "仙台",
"818543", "安来",
"8198290", "延岡",
"811978", "北上",
"812236", "仙台",
"81950", "平戸",
"817947", "三木",
"811932", "釜石",
"818947", "宇和",
"811632", "天塩",
"81977", "別府",
"811732", "五所川原",
"814772", "市川",
"8183766", "下関",
"819208", "対馬佐賀",
"81249", "郡山",
"812419", "田島",
"812852", "小山",
"812558", "新井",
"8198293", "延岡",
"815743", "美濃加茂",
"81225", "石巻",
"812552", "上越",
"812858", "真岡",
"812830", "宇都宮",
"819685", "玉名",
"818680", "岡山",
"812570", "小出",
"819785", "豊後高田",
"819954", "加治木",
"819956", "加治木",
"818843", "阿南",
"818293", "廿日市",
"814289", "青梅",
"81236", "山形",
"811972", "水沢",
"817453", "大和高田",
"81934", "北九州",
"818369", "宇部",
"811938", "宮古",
"811638", "利尻礼文",
"81439", "木更津",
"818377", "下関",
"811738", "鰺ケ沢",
"81963", "熊本",
"812383", "米沢",
"81420", "所沢",
"815769", "荘川",
"815977", "熊野",
"8112395", "栗山",
"817482", "八日市",
"817714", "亀岡",
"817907", "播磨山崎",
"817616", "小松",
"818973", "新居浜",
"817614", "小松",
"811548", "弟子屈",
"817673", "羽咋",
"817716", "園部",
"812994", "石岡",
"812996", "潮来",
"814298", "飯能",
"812794", "渋川",
"812696", "飯山",
"812787", "沼田",
"812911", "鉾田",
"819592", "大瀬戸",
"812694", "中野",
"812796", "渋川",
"812583", "長岡",
"811452", "早来",
"818837", "阿波池田",
"817914", "相生",
"817707", "小浜",
"81124", "芦別",
"818673", "福渡",
"817916", "竜野",
"818366", "宇部",
"817908", "播磨山崎",
"811547", "白糠",
"818364", "宇部",
"814286", "相模原",
"81827", "岩国",
"811643", "石狩深川",
"814284", "立川",
"814297", "飯能",
"812788", "前橋",
"818872", "室戸",
"81727", "池田",
"811943", "岩泉",
"817366", "岩出",
"811333", "当別",
"818838", "阿波池田",
"817364", "和歌山橋本",
"815978", "熊野",
"8198297", "日向",
"8183768", "下関",
"811365", "倶知安",
"815732", "恵那",
"812999", "潮来",
"818564", "益田",
"817942", "加古川",
"81779", "大野",
"81899", "松山",
"814703", "館山",
"819233", "前原",
"811937", "宮古",
"811637", "北見枝幸",
"818942", "八幡浜",
"814777", "船橋",
"811873", "角館",
"818378", "下関",
"811737", "鰺ケ沢",
"812799", "長野原",
"811533", "根室",
"812857", "真岡",
"815764", "下呂",
"812895", "宇都宮",
"812245", "大河原",
"815766", "下呂",
"8124197", "柳津",
"81559", "沼津",
"818842", "阿南",
"81724", "岸和田貝塚",
"818292", "広島",
"818548", "石見大田",
"817452", "大和高田",
"811973", "水沢",
"8188091", "窪川",
"812899", "鹿沼",
"81281", "宇都宮",
"812382", "米沢",
"812795", "渋川",
"812695", "中野",
"81222", "仙台",
"812553", "上越",
"812657", "伊那",
"8188099", "土佐清水",
"815748", "美濃白川",
"817915", "相生",
"817715", "亀岡",
"817615", "小松",
"8188092", "窪川",
"812957", "大子",
"812995", "石岡",
"818972", "新居浜",
"817672", "羽咋",
"818808", "土佐清水",
"81942", "久留米",
"817738", "舞鶴",
"819955", "加治木",
"817950", "三田",
"811377", "八雲",
"819593", "大瀬戸",
"819786", "杵築",
"812582", "長岡",
"819684", "山鹿",
"811453", "早来",
"819686", "玉名",
"8186697", "倉敷",
"819784", "豊後高田",
"818672", "福渡",
"812477", "三春",
"817483", "八日市",
"8182920", "廿日市",
"812478", "三春",
"815733", "恵那",
"818565", "益田",
"8188098", "土佐清水",
"811566", "十勝清水",
"811564", "上士幌",
"817737", "舞鶴",
"811642", "石狩深川",
"818807", "宿毛",
"81199", "盛岡",
"818873", "安芸",
"811378", "今金",
"81179", "三戸",
"811942", "岩泉",
"815765", "下呂",
"811332", "当別",
"812244", "白石",
"812894", "宇都宮",
"81937", "北九州",
"812896", "鹿沼",
"812246", "大河原",
"815747", "美濃白川",
"812658", "伊那",
"817365", "和歌山橋本",
"812930", "水戸",
"818365", "宇部",
"814285", "相模原",
"811364", "倶知安",
"818547", "掛合",
"811366", "寿都",
"817943", "加古川",
"81423", "国分寺",
"819232", "前原",
"814702", "館山",
"818943", "八幡浜",
"81983", "高鍋",
"819789", "杵築",
"8147955", "八日市場",
"811532", "根室",
"818297", "廿日市",
"818847", "牟岐",
"817457", "大和高田",
"81427", "相模原",
"817495", "長浜",
"818391", "小郡",
"814708", "大原",
"8182941", "広島",
"811878", "大曲",
"818373", "長門",
"812415", "柳津",
"811538", "根室標津",
"812387", "長井",
"81987", "日南",
"812652", "飯田",
"819554", "伊万里",
"819556", "唐津",
"8182942", "広島",
"819825", "日向",
"81964", "松橋",
"817903", "福崎",
"811866", "鷹巣",
"818977", "伯方",
"817969", "浜坂",
"811864", "大館",
"818669", "総社",
"817677", "七尾",
"811648", "焼尻",
"81276", "太田",
"81266", "諏訪",
"818514", "海士",
"81933", "北九州",
"811372", "鹿部",
"812783", "沼田",
"814225", "武蔵野三鷹",
"818833", "鴨島",
"812587", "長岡",
"817703", "敦賀",
"818677", "新見",
"815973", "尾鷲",
"812472", "石川",
"815366", "設楽",
"8186995", "岡山瀬戸",
"812235", "仙台",
"8111", "札幌",
"818978", "伯方",
"81228", "築館",
"81739", "田辺",
"817678", "七尾",
"811543", "釧路",
"818802", "窪川",
"811647", "羽幌",
"817732", "福知山",
"811947", "久慈",
"811337", "石狩",
"812588", "長岡",
"81839", "山口",
"818678", "新見",
"815564", "鰍沢青柳",
"8153974", "天竜",
"815566", "身延",
"812853", "小山",
"815742", "美濃加茂",
"81948", "飯塚",
"81569", "半田",
"819724", "佐伯",
"8199345", "鹿児島",
"819726", "臼杵",
"818298", "廿日市",
"818542", "安来",
"818848", "牟岐",
"817458", "大和榛原",
"817964", "豊岡",
"8188096", "土佐清水",
"818666", "井原",
"818664", "高梁",
"814707", "大原",
"811933", "釜石",
"811869", "大館",
"817966", "八鹿",
"811733", "五所川原",
"811877", "大曲",
"811537", "中標津",
"819435", "八女",
"812388", "長井",
"81166", "旭川",
"812748", "富岡",
"815757", "郡上八幡",
"812648", "長野",
"81176", "十和田",
"811983", "花巻",
"819668", "水俣",
"815995", "阿児",
"819968", "出水",
"811587", "中湧別",
"812372", "村山",
"81196", "盛岡",
"815957", "上野",
"818595", "米子",
"817953", "西脇",
"817728", "峰山",
"818557", "川本",
"81581", "高富",
"818953", "宇和島",
"819976", "名瀬",
"819913", "硫黄島",
"817682", "輪島",
"819974", "屋久島",
"811394", "松前",
"812550", "安塚",
"812832", "佐野",
"811396", "江差",
"812572", "柏崎",
"812878", "烏山",
"819674", "熊本一の宮",
"817239", "寝屋川",
"818682", "津山",
"819676", "高森",
"818473", "甲山",
"811752", "むつ",
"811652", "士別",
"812487", "須賀川",
"814758", "東金",
"818205", "柳井",
"817357", "串本",
"815582", "下田",
"817473", "五条",
"811952", "二戸",
"814795", "銚子",
"819945", "鹿屋",
"811853", "男鹿",
"814757", "東金",
"812488", "須賀川",
"812965", "下館",
"8128798", "大田原",
"811522", "斜里",
"817940", "加古川",
"812933", "高萩",
"81886", "徳島",
"818262", "加計",
"8199347", "鹿児島",
"81938", "北九州",
"812877", "黒磯",
"817727", "峰山",
"81849", "福山",
"818558", "川本",
"81725", "和泉",
"81825", "広島",
"811235", "夕張",
"812747", "富岡",
"812647", "長野",
"815758", "郡上八幡",
"819667", "水俣",
"812543", "新発田",
"8186997", "岡山瀬戸",
"819979", "徳之島",
"819679", "高森",
"8188094", "窪川",
"811588", "興部",
"819967", "出水",
"8147950", "八日市場",
"815958", "亀山",
"81958", "長崎",
"8167", "大阪",
"819809", "八重山",
"8166", "大阪",
"815752", "関",
"811582", "紋別",
"818383", "萩",
"8169", "大阪",
"815952", "上野",
"81988", "那覇",
"812377", "寒河江",
"819575", "諫早",
"812780", "前橋",
"811353", "余市",
"818552", "浜田",
"815396", "浜松",
"815394", "浜松",
"81932", "北九州",
"812569", "巻",
"817687", "能都",
"812914", "鉾田",
"812973", "水海道",
"8153960", "天竜",
"818268", "千代田",
"812616", "大町",
"812837", "佐野",
"818583", "倉吉",
"812673", "小諸",
"812614", "大町",
"817994", "洲本",
"818794", "三本松",
"812577", "六日町",
"818696", "備前",
"818694", "岡山",
"818796", "土庄",
"818687", "美作",
"817996", "津名",
"815983", "松阪",
"811757", "野辺地",
"81566", "刈谷",
"8186552", "倉敷",
"811553", "帯広",
"812482", "白河",
"8153963", "天竜",
"815587", "修善寺大仁",
"811528", "美幌",
"817352", "新宮",
"811957", "岩手",
"81952", "佐賀",
"81596", "伊勢",
"814770", "市川",
"811658", "上川",
"81975", "大分",
"814752", "茂原",
"81965", "八代",
"811466", "えりも",
"815588", "修善寺大仁",
"811527", "美幌",
"811464", "静内",
"811958", "岩手",
"81531", "田原",
"815399", "天竜",
"8147957", "八日市場",
"81227", "仙台",
"817688", "能都",
"819806", "沖縄宮古",
"819936", "加世田",
"8186993", "備前",
"819934", "指宿",
"819804", "名護",
"818267", "千代田",
"812838", "佐野",
"814281", "相模原",
"819734", "日田",
"812872", "大田原",
"812578", "六日町",
"817465", "吉野",
"818688", "美作",
"818245", "三次",
"818895", "須崎",
"817722", "宮津",
"81947", "田川",
"81551", "韮崎",
"819546", "鹿島",
"812742", "藤岡",
"819544", "武雄",
"812642", "木曾福島",
"81466", "藤沢",
"819662", "人吉",
"812564", "三条",
"81476", "成田",
"812566", "三条",
"8199343", "鹿児島",
"819962", "川内",
"812619", "大町",
"812378", "寒河江",
"81592", "津",
"81956", "佐世保",
"818549", "石見大田",
"811862", "鹿角",
"81126", "岩見沢",
"8188093", "窪川",
"819787", "国東",
"812898", "鹿沼",
"812248", "大河原",
"819687", "玉名",
"81572", "多治見",
"811376", "八雲",
"811374", "森",
"818512", "西郷",
"81562", "尾張横須賀",
"812476", "三春",
"812474", "石川",
"812413", "喜多方",
"818375", "美祢",
"818493", "尾道",
"81852", "松江",
"8188090", "窪川",
"817493", "彦根",
"81280", "古河",
"81936", "北九州",
"81234", "酒田",
"81888", "高知",
"81263", "松本",
"81273", "高崎",
"812656", "伊那",
"812654", "飯田",
"818835", "脇町",
"819552", "伊万里",
"814223", "武蔵野三鷹",
"817705", "小浜",
"812785", "沼田",
"81144", "苫小牧",
"81832", "下関",
"817905", "福崎",
"812956", "常陸大宮",
"819823", "延岡",
"815746", "美濃加茂",
"815744", "美濃加茂",
"818240", "東広島",
"815562", "鰍沢青柳",
"81492", "川越",
"81462", "厚木",
"819722", "佐伯",
"811545", "釧路",
"818662", "高梁",
"817962", "豊岡",
"818546", "掛合",
"812233", "岩沼",
"811367", "寿都",
"818544", "木次",
"81535", "浜松",
"81875", "観音寺",
"819433", "八女",
"814775", "船橋",
"815362", "新城",
"811735", "五所川原",
"811635", "浜頓別",
"812659", "伊那",
"811935", "釜石",
"81775", "大津",
"81765", "魚津",
"818806", "宿毛",
"817736", "舞鶴",
"817734", "福知山",
"818804", "土佐中村",
"811567", "十勝清水",
"81555", "吉田",
"819788", "国東",
"819688", "玉名",
"812897", "鹿沼",
"812247", "大河原",
"81178", "八戸",
"812855", "小山",
"812993", "石岡",
"8186691", "倉敷",
"811867", "鷹巣",
"818976", "新居浜",
"817613", "小松",
"814709", "鴨川",
"817674", "羽咋",
"81585", "揖斐川",
"817713", "亀岡",
"817676", "七尾",
"818974", "新居浜",
"819782", "豊後高田",
"818674", "久世",
"8182943", "広島",
"812586", "長岡",
"81478", "佐原",
"812584", "長岡",
"819682", "山鹿",
"8162", "大阪",
"81544", "富士宮",
"81468", "横須賀",
"818676", "久世",
"811539", "根室標津",
"812693", "中野",
"812555", "糸魚川",
"812793", "渋川",
"819205", "厳原",
"815368", "設楽",
"811975", "水沢",
"8144", "川崎",
"811551", "十勝池田",
"818668", "井原",
"817485", "八日市",
"817968", "浜坂",
"818296", "広島",
"818846", "丹生谷",
"817454", "大和高田",
"817456", "大和高田",
"8186994", "岡山瀬戸",
"818844", "阿南",
"818294", "廿日市",
"812384", "米沢",
"812386", "長井",
"8188097", "土佐清水",
"811455", "鵡川",
"819557", "唐津",
"81192", "大船渡",
"819595", "有川",
"81743", "奈良",
"819728", "臼杵",
"819953", "大口",
"81162", "稚内",
"81172", "弘前",
"81949", "直方",
"819558", "唐津",
"815763", "下呂",
"81485", "熊谷",
"818875", "土佐山田",
"8186698", "倉敷",
"819727", "臼杵",
"81568", "春日井",
"81578", "神岡",
"81925", "福岡",
"818667", "井原",
"814704", "館山",
"817967", "八鹿",
"81250", "新津",
"814706", "大原",
"818563", "益田",
"815735", "恵那",
"811362", "倶知安",
"811534", "中標津",
"811536", "厚岸",
"81277", "桐生",
"811874", "角館",
"818679", "新見",
"811876", "大曲",
"812589", "長岡",
"813", "東京",
"815367", "設楽",
"818945", "八幡浜",
"819940", "志布志",
"817945", "加古川",
"811646", "羽幌",
"817459", "大和榛原",
"814283", "青梅",
"81986", "都城",
"818299", "広島",
"811644", "留萌",
"811868", "鷹巣",
"818363", "宇部",
"81738", "御坊",
"811562", "本別",
"81229", "古川",
"81284", "足利",
"811336", "石狩",
"817363", "和歌山橋本",
"81245", "福島",
"812242", "白石",
"812892", "宇都宮",
"811944", "岩泉",
"81426", "八王子",
"812389", "米沢",
"81721", "富田林",
"811946", "久慈",
"8126177", "長野",
"812649", "長野",
"81864", "倉敷",
"8145", "横浜",
"819977", "瀬戸内",
"819969", "中甑",
"814220", "国分寺",
"818692", "邑久",
"81764", "富山",
"819677", "矢部",
"81774", "宇治",
"817992", "洲本",
"818792", "三本松",
"81833", "下松",
"812612", "大町",
"819573", "諫早",
"811397", "奥尻",
"812486", "須賀川",
"81554", "大月",
"812484", "白河",
"818385", "萩",
"81292", "水戸",
"81272", "前橋",
"81262", "長野",
"817356", "串本",
"8188095", "土佐清水",
"817354", "新宮",
"815754", "関",
"815756", "郡上八幡",
"815954", "上野",
"8186996", "岡山瀬戸",
"815956", "上野",
"811555", "帯広",
"818490", "尾道",
"811584", "遠軽",
"81853", "出雲",
"815985", "松阪",
"817238", "寝屋川",
"811586", "中湧別",
"812879", "烏山",
"8153977", "天竜",
"81534", "浜松",
"818554", "浜田",
"818556", "江津",
"812675", "佐久",
"818585", "倉吉",
"81593", "四日市",
"812551", "上越",
"81563", "西尾",
"812975", "水海道",
"815392", "浜松",
"817463", "吉野",
"81848", "尾道",
"81235", "鶴岡",
"817724", "宮津",
"812489", "須賀川",
"817726", "峰山",
"81240", "磐城富岡",
"818463", "竹原",
"81184", "本荘",
"819666", "水俣",
"819664", "人吉",
"812562", "三条",
"819542", "武雄",
"812644", "木曾福島",
"812746", "富岡",
"812744", "藤岡",
"812646", "長野",
"819964", "川内",
"819966", "出水",
"814756", "東金",
"814754", "茂原",
"818559", "川本",
"811462", "浦河",
"812230", "仙台",
"81493", "東松山",
"819802", "南大東",
"81480", "久喜",
"819932", "指宿",
"819978", "徳之島",
"81434", "千葉",
"811589", "興部",
"812876", "黒磯",
"819678", "矢部",
"81939", "北九州",
"812874", "大田原",
"815959", "亀山",
"819732", "日田",
"81473", "市川",
"81177", "青森",
"818893", "佐川",
"81167", "富良野",
"811398", "熊石",
"818243", "東広島",
"81463", "平塚",
"819808", "八重山",
"819938", "加世田",
"818955", "宇和島",
"81134", "小樽",
"812917", "水戸",
"819972", "種子島",
"817684", "輪島",
"817686", "能都",
"812576", "十日町",
"818697", "備前",
"818684", "津山",
"818797", "土庄",
"818686", "津山",
"81467", "藤沢",
"817997", "津名",
"812574", "柏崎",
"819672", "熊本一の宮",
"819738", "玖珠",
"817955", "三田",
"81742", "奈良",
"812836", "佐野",
"812617", "大町",
"818655", "鴨方",
"812834", "宇都宮",
"818593", "米子",
"811392", "木古内",
"8186998", "岡山瀬戸",
"811756", "野辺地",
"811654", "名寄",
"811656", "美深",
"811754", "むつ",
"815993", "鳥羽",
"81946", "甘木",
"811956", "岩手",
"811954", "二戸",
"815586", "下田",
"81244", "原町",
"815584", "下田",
"8186553", "倉敷",
"812568", "巻",
"817475", "下市",
"8153962", "天竜",
"81429", "所沢",
"81484", "川口",
"812374", "村山",
"81989", "那覇",
"81924", "福岡",
"812376", "寒河江",
"818203", "柳井",
"818475", "府中",
"81226", "気仙沼",
"8153961", "天竜",
"815397", "浜松",
"8186992", "備前",
"81550", "御殿場",
"8186999", "岡山瀬戸",
"814280", "立川",
"815589", "修善寺大仁",
"81567", "津島",
"815398", "浜松",
"81577", "高山",
"812935", "水戸",
"818360", "小郡",
"819743", "三重",
"814771", "市川",
"812567", "巻",
"819547", "鹿島",
"81298", "土浦",
"81268", "上田",
"811855", "能代",
"812963", "下館",
"812839", "佐野",
"81857", "鳥取",
"814793", "銚子",
"818689", "岡山",
"819943", "鹿屋",
"812579", "小出",
"81584", "大垣",
"812545", "村上",
"81545", "富士",
"811526", "網走",
"811524", "網走",
"819937", "加世田",
"819807", "沖縄宮古",
"811233", "千歳",
"81737", "湯浅",
"811541", "弟子屈",
"818698", "備前",
"818798", "土庄",
"817998", "津名",
"812618", "大町",
"818266", "千代田",
"814291", "飯能",
"819737", "玖珠",
"818264", "安芸吉田",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;