# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210602223300;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1534[0-24-8]\\d{5}',
                'geographic' => '1534[0-24-8]\\d{5}',
                'mobile' => '
          7(?:
            (?:
              (?:
                50|
                82
              )9|
              937
            )\\d|
            7(?:
              00[378]|
              97[7-9]
            )
          )\\d{5}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-2]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            81|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '701511\\d{4}',
                'specialrate' => '(
          (?:
            8(?:
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            90(?:
              066[59]|
              1810|
              71(?:
                07|
                55
              )
            )
          )\\d{4}
        )|(
          (?:
            3(?:
              0(?:
                07(?:
                  35|
                  81
                )|
                8901
              )|
              3\\d{4}|
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '
          80(?:
            07(?:
              35|
              81
            )|
            8901
          )\\d{4}
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441592", "Kirkcaldy",
"441248", "Bangor\ \(Gwynedd\)",
"441915", "Sunderland",
"4419755", "Alford\ \(Aberdeen\)",
"44113", "Leeds",
"4418477", "Tongue",
"441452", "Gloucester",
"441529", "Sleaford",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441476", "Grantham",
"441302", "Doncaster",
"441474", "Gravesend",
"4414376", "Haverfordwest",
"4415395", "Grange\-over\-Sands",
"441548", "Kingsbridge",
"441292", "Ayr",
"441842", "Thetford",
"441392", "Exeter",
"4412293", "Millom",
"441202", "Bournemouth",
"441889", "Rugeley",
"441483", "Guildford",
"442830", "Newry",
"4418908", "Coldstream",
"441772", "Preston",
"441985", "Warminster",
"441672", "Marlborough",
"4415077", "Louth",
"441750", "Selkirk",
"4412290", "Barrow\-in\-Furness\/Millom",
"441738", "Perth",
"441954", "Madingley",
"441650", "Cemmaes\ Road",
"441638", "Newmarket",
"441329", "Fareham",
"441502", "Lowestoft",
"441808", "Tomatin",
"441754", "Skegness",
"4413395", "Aboyne",
"441938", "Welshpool",
"441950", "Sandwick",
"441656", "Bridgend",
"441654", "Machynlleth",
"441756", "Skipton",
"441972", "Glenborrodale",
"441685", "Merthyr\ Tydfil",
"441348", "Fishguard",
"441785", "Stafford",
"441524", "Lancaster",
"441143", "Sheffield",
"441467", "Inverurie",
"441526", "Martin",
"441873", "Abergavenny",
"441737", "Redhill",
"441637", "Newquay",
"441241", "Arbroath",
"441937", "Wetherby",
"441807", "Ballindalloch",
"441520", "Lochcarron",
"44291", "Cardiff",
"441347", "Easingwold",
"441479", "Grantown\-on\-Spey",
"441565", "Knutsford",
"442895", "Belfast",
"441226", "Barnsley",
"441233", "Ashford\ \(Kent\)",
"441224", "Aberdeen",
"441959", "Westerham",
"441326", "Falmouth",
"441324", "Falkirk",
"4414237", "Harrogate",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"4414347", "Hexham",
"4418902", "Coldstream",
"441943", "Guiseley",
"441743", "Shrewsbury",
"4419647", "Patrington",
"4418909", "Ayton",
"441643", "Minehead",
"441759", "Pocklington",
"441547", "Knighton",
"441320", "Fort\ Augustus",
"4414307", "Market\ Weighton",
"441659", "Sanquhar",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441884", "Tiverton",
"441931", "Shap",
"441341", "Barmouth",
"441855", "Ballachulish",
"441461", "Gretna",
"4418901", "Coldstream\/Ayton",
"441445", "Gairloch",
"441631", "Oban",
"441880", "Tarbert",
"442879", "Magherafelt",
"441586", "Campbeltown",
"441584", "Ludlow",
"441501", "Harthill",
"441597", "Llandrindod\ Wells",
"441555", "Lanark",
"441971", "Scourie",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441793", "Swindon",
"4412297", "Millom",
"441671", "Newton\ Stewart",
"441993", "Witney",
"4418906", "Ayton",
"441771", "Maud",
"442867", "Lisnaskea",
"441580", "Cranbrook",
"441280", "Buckingham",
"441457", "Glossop",
"441495", "Pontypool",
"4415073", "Louth",
"441373", "Frome",
"441255", "Clacton\-on\-Sea",
"441307", "Forfar",
"441284", "Bury\ St\ Edmunds",
"44147984", "Carrbridge",
"441297", "Axminster",
"441286", "Caernarfon",
"441384", "Dudley",
"4414378", "Haverfordwest",
"441301", "Arrochar",
"441397", "Fort\ William",
"4418470", "Thurso\/Tongue",
"441386", "Evesham",
"441865", "Oxford",
"441210", "Birmingham",
"441841", "Newquay\ \(Padstow\)",
"441291", "Chepstow",
"441207", "Consett",
"441355", "East\ Kilbride",
"441451", "Stow\-on\-the\-Wold",
"441216", "Birmingham",
"441214", "Birmingham",
"441273", "Brighton",
"441380", "Devizes",
"441405", "Goole",
"441824", "Ruthin",
"441777", "Retford",
"441833", "Barnard\ Castle",
"441969", "Leyburn",
"441903", "Worthing",
"441677", "Bedale",
"4418473", "Thurso",
"441573", "Kelso",
"44147983", "Boat\ of\ Garten",
"441591", "Llanwrtyd\ Wells",
"441439", "Helmsley",
"44292", "Cardiff",
"441977", "Pontefract",
"441769", "South\ Molton",
"441603", "Norwich",
"441669", "Rothbury",
"441778", "Bourne",
"4414233", "Boroughbridge",
"4414343", "Haltwhistle",
"441462", "Hitchin",
"441678", "Bala",
"441732", "Sevenoaks",
"441508", "Brooke",
"4416974", "Raughton\ Head",
"441932", "Weybridge",
"441289", "Berwick\-upon\-Tweed",
"4416864", "Llanidloes",
"4413882", "Stanhope\ \(Eastgate\)",
"4419643", "Patrington",
"441978", "Wrexham",
"4414303", "North\ Cave",
"441342", "East\ Grinstead",
"4414230", "Harrogate\/Boroughbridge",
"441398", "Dulverton",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441208", "Bodmin",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"442870", "Coleraine",
"4419640", "Hornsea\/Patrington",
"4414300", "North\ Cave\/Market\ Weighton",
"441458", "Glastonbury",
"441760", "Swaffham",
"441829", "Tarporley",
"441764", "Crieff",
"441666", "Malmesbury",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441308", "Bridport",
"441664", "Melton\ Mowbray",
"441766", "Porthmadog",
"441848", "Thornhill",
"441436", "Helensburgh",
"441542", "Keith",
"441298", "Buxton",
"441925", "Warrington",
"441598", "Lynton",
"441242", "Cheltenham",
"441892", "Tunbridge\ Wells",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441389", "Dumbarton",
"44117", "Bristol",
"4418515", "Stornoway",
"4414379", "Haverfordwest",
"441725", "Rockbourne",
"442868", "Kesh",
"441625", "Macclesfield",
"441628", "Maidenhead",
"442841", "Rostrevor",
"441728", "Saxmundham",
"441953", "Wymondham",
"4418904", "Coldstream",
"441949", "Whatton",
"441912", "Tyneside",
"441749", "Shepton\ Mallet",
"441557", "Kirkcudbright",
"441653", "Malton",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441753", "Slough",
"441928", "Runcorn",
"441845", "Thirsk",
"441295", "Banbury",
"441257", "Coppull",
"441305", "Dorchester",
"441480", "Huntingdon",
"441497", "Hay\-on\-Wye",
"442820", "Ballycastle",
"441484", "Huddersfield",
"441455", "Hinckley",
"4419753", "Strathdon",
"441407", "Holyhead",
"441491", "Henley\-on\-Thames",
"441539", "Kendal",
"441879", "Scarinish",
"441205", "Boston",
"441357", "Strathaven",
"441473", "Ipswich",
"441395", "Budleigh\ Salterton",
"4413393", "Aboyne",
"441782", "Stoke\-on\-Trent",
"4412295", "Barrow\-in\-Furness",
"441505", "Johnstone",
"441675", "Coleshill",
"442310", "Portsmouth",
"441982", "Builth\ Wells",
"441239", "Cardigan",
"441775", "Spalding",
"4413390", "Aboyne\/Ballater",
"442829", "Kilrea",
"441262", "Bridlington",
"441883", "Caterham",
"4416866", "Newtown",
"441721", "Peebles",
"441621", "Maldon",
"4418517", "Stornoway",
"441489", "Bishops\ Waltham",
"441946", "Whitehaven",
"441408", "Golspie",
"441740", "Sedgefield",
"441944", "West\ Heslerton",
"441323", "Eastbourne",
"441334", "St\ Andrews",
"442892", "Lisburn",
"441358", "Ellon",
"441330", "Banchory",
"441562", "Kidderminster",
"441644", "New\ Galloway",
"441746", "Bridgnorth",
"441744", "St\ Helens",
"441646", "Milford\ Haven",
"441258", "Blandford",
"44239", "Portsmouth",
"441234", "Bedford",
"441223", "Cambridge",
"441236", "Coatbridge",
"44147986", "Cairngorm",
"441876", "Lochmaddy",
"441727", "St\ Albans",
"441874", "Brecon",
"441144", "Sheffield",
"441442", "Hemel\ Hempstead",
"441536", "Kettering",
"441534", "Jersey",
"441140", "Sheffield",
"441362", "Dereham",
"441852", "Kilmelford",
"441558", "Llandeilo",
"441530", "Coalville",
"441870", "Isle\ of\ Benbecula",
"442889", "Fivemiletown",
"441576", "Lockerbie",
"4415075", "Spilsby\ \(Horncastle\)",
"441600", "Monmouth",
"441823", "Taunton",
"441834", "Narberth",
"441700", "Rothesay",
"441981", "Wormbridge",
"441904", "York",
"441604", "Northampton",
"441368", "Dunbar",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441706", "Rochdale",
"441858", "Market\ Harborough",
"441830", "Kirkwhelpington",
"441704", "Southport",
"441917", "Sunderland",
"441606", "Northwich",
"441900", "Workington",
"441429", "Hartlepool",
"4413397", "Ballater",
"441570", "Lampeter",
"441270", "Crewe",
"441252", "Aldershot",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441383", "Dunfermline",
"441492", "Colwyn\ Bay",
"441213", "Birmingham",
"441274", "Bradford",
"441276", "Camberley",
"441376", "Braintree",
"4418475", "Thurso",
"442898", "Belfast",
"4416869", "Newtown",
"441352", "Mold",
"441568", "Leominster",
"4416862", "Llanidloes",
"441283", "Burton\-on\-Trent",
"441862", "Tain",
"441794", "Romsey",
"441787", "Sudbury",
"441911", "Tyneside\/Durham\/Sunderland",
"441694", "Church\ Stretton",
"441796", "Pitlochry",
"441687", "Mallaig",
"441583", "Carradale",
"441268", "Basildon",
"4416861", "Newtown\/Llanidloes",
"442842", "Kircubbin",
"441987", "Ebbsfleet",
"441790", "Spilsby",
"441994", "St\ Clears",
"4419757", "Strathdon",
"441690", "Betws\-y\-Coed",
"441788", "Rugby",
"441361", "Duns",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441267", "Carmarthen",
"441935", "Yeovil",
"441805", "Torrington",
"441279", "Bishops\ Stortford",
"441635", "Newbury",
"441465", "Girvan",
"441988", "Wigtown",
"441909", "Worksop",
"441963", "Wincanton",
"442897", "Saintfield",
"441420", "Alton",
"441579", "Liskeard",
"442886", "Cookstown",
"4414345", "Haltwhistle",
"4414235", "Harrogate",
"441433", "Hathersage",
"442880", "Carrickmore",
"441424", "Hastings",
"4414305", "North\ Cave",
"441567", "Killin",
"441663", "New\ Mills",
"4419467", "Gosforth",
"4419645", "Hornsea",
"441609", "Northallerton",
"441763", "Royston",
"441709", "Rotherham",
"441561", "Laurencekirk",
"4417684", "Pooley\ Bridge",
"441545", "Llanarth",
"441799", "Saffron\ Walden",
"44161", "Manchester",
"4418513", "Stornoway",
"442891", "Bangor\ \(Co\.\ Down\)",
"441622", "Maidstone",
"441722", "Salisbury",
"441379", "Diss",
"44118", "Reading",
"441367", "Faringdon",
"441918", "Tyneside",
"441857", "Sanday",
"441895", "Uxbridge",
"441245", "Chelmsford",
"441261", "Banff",
"4418510", "Great\ Bernera\/Stornoway",
"4416868", "Newtown",
"441922", "Walsall",
"441899", "Biggar",
"441249", "Chippenham",
"441253", "Blackpool",
"442837", "Armagh",
"441382", "Dundee",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"441228", "Carlisle",
"441375", "Grays\ Thurrock",
"441493", "Great\ Yarmouth",
"441212", "Birmingham",
"4420", "London",
"441957", "Mid\ Yell",
"441995", "Garstang",
"441822", "Tavistock",
"441528", "Laggan",
"441795", "Sittingbourne",
"441695", "Skelmersdale",
"441553", "Kings\ Lynn",
"441757", "Selby",
"441549", "Lairg",
"441751", "Pickering",
"441582", "Luton",
"441888", "Turriff",
"441651", "Oldmeldrum",
"441951", "Colonsay",
"442843", "Newcastle\ \(Co\.\ Down\)",
"4412291", "Barrow\-in\-Furness\/Millom",
"441575", "Kirriemuir",
"441835", "St\ Boswells",
"441905", "Worcester",
"441403", "Horsham",
"4414306", "Market\ Weighton",
"441469", "Killingholme",
"4417687", "Keswick",
"441639", "Neath",
"441275", "Clevedon",
"441328", "Fakenham",
"4419646", "Patrington",
"4412292", "Barrow\-in\-Furness",
"4412299", "Millom",
"441353", "Ely",
"441809", "Tomdoun",
"441863", "Ardgay",
"441939", "Wem",
"441282", "Burnley",
"441349", "Dingwall",
"441477", "Holmes\ Chapel",
"4414236", "Harrogate",
"4414346", "Hexham",
"441962", "Winchester",
"4414377", "Haverfordwest",
"441327", "Daventry",
"441540", "Kingussie",
"441546", "Lochgilphead",
"441432", "Hereford",
"441544", "Kington",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"4418476", "Tongue",
"441887", "Aberfeldy",
"441244", "Chester",
"441896", "Galashiels",
"44115", "Nottingham",
"441246", "Chesterfield",
"4413394", "Ballater",
"441736", "Penzance",
"441623", "Mansfield",
"441634", "Medway",
"441636", "Newark\-on\-Trent",
"4412298", "Barrow\-in\-Furness",
"441723", "Scarborough",
"441464", "Insch",
"441340", "Craigellachie\ \(Aberlour\)",
"4418900", "Coldstream\/Ayton",
"441527", "Redditch",
"441466", "Huntly",
"441460", "Chard",
"441344", "Bracknell",
"441346", "Fraserburgh",
"4415076", "Louth",
"441806", "Shetland",
"441630", "Market\ Drayton",
"441934", "Weston\-super\-Mare",
"441923", "Watford",
"441758", "Pwllheli",
"441730", "Petersfield",
"4419754", "Alford\ \(Aberdeen\)",
"441425", "Ringwood",
"442838", "Portadown",
"4418903", "Coldstream",
"441227", "Canterbury",
"4415242", "Hornby",
"442885", "Ballygawley",
"4415394", "Hawkshead",
"441204", "Bolton",
"441206", "Colchester",
"4415072", "Spilsby\ \(Horncastle\)",
"4414348", "Hexham",
"441387", "Dumfries",
"4414238", "Harrogate",
"44116", "Leicester",
"441394", "Felixstowe",
"4414308", "Market\ Weighton",
"4415079", "Alford\ \(Lincs\)",
"4419648", "Hornsea",
"441217", "Birmingham",
"441200", "Clitheroe",
"4417683", "Appleby",
"441952", "Telford",
"441674", "Montrose",
"441776", "Stranraer",
"44147982", "Nethy\ Bridge",
"441827", "Tamworth",
"441970", "Aberystwyth",
"441676", "Meriden",
"441670", "Morpeth",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441913", "Durham",
"441770", "Isle\ of\ Arran",
"441974", "Llanon",
"4418514", "Great\ Bernera",
"441506", "Bathgate",
"441652", "Brigg",
"441581", "New\ Luce",
"441752", "Plymouth",
"4418472", "Thurso",
"441683", "Moffat",
"441594", "Lydney",
"4413873", "Langholm",
"442866", "Enniskillen",
"441590", "Lymington",
"441983", "Isle\ of\ Wight",
"441821", "Kinrossie",
"4418479", "Tongue",
"4416865", "Newtown",
"441300", "Cerne\ Abbas",
"441968", "Penicuik",
"441485", "Hunstanton",
"441454", "Chipping\ Sodbury",
"441290", "Cumnock",
"441456", "Glenurquhart",
"441840", "Camelford",
"441211", "Birmingham",
"441438", "Stevenage",
"441450", "Hawick",
"441296", "Aylesbury",
"441287", "Guisborough",
"441294", "Ardrossan",
"441844", "Thame",
"441668", "Bamburgh",
"4418471", "Thurso\/Tongue",
"441304", "Dover",
"441381", "Fortrose",
"441472", "Grimsby",
"441306", "Dorking",
"441768", "Penrith",
"442825", "Ballymena",
"441235", "Abingdon",
"4412180", "Birmingham",
"4414301", "North\ Cave\/Market\ Weighton",
"441779", "Peterhead",
"441967", "Strontian",
"442893", "Ballyclare",
"441322", "Dartford",
"4419641", "Hornsea\/Patrington",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"442871", "Londonderry",
"441509", "Loughborough",
"441288", "Bude",
"441563", "Kilmarnock",
"441667", "Nairn",
"44241", "Coventry",
"441767", "Sandy",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"4414231", "Harrogate\/Boroughbridge",
"4414309", "Market\ Weighton",
"4415078", "Alford\ \(Lincs\)",
"44131", "Edinburgh",
"4414232", "Harrogate",
"4414342", "Bellingham",
"4418907", "Ayton",
"441209", "Redruth",
"441263", "Cromer",
"441882", "Kinloch\ Rannoch",
"441588", "Bishops\ Castle",
"4419649", "Hornsea",
"4419642", "Hornsea",
"4412296", "Barrow\-in\-Furness",
"441875", "Tranent",
"4414349", "Bellingham",
"441145", "Sheffield",
"4414239", "Boroughbridge",
"441535", "Keighley",
"4414302", "North\ Cave",
"441443", "Pontypridd",
"441522", "Lincoln",
"4414373", "Clynderwen\ \(Clunderwen\)",
"441828", "Coupar\ Angus",
"441309", "Forres",
"441363", "Crediton",
"441299", "Bewdley",
"441599", "Kyle",
"44151", "Liverpool",
"441431", "Helmsdale",
"442877", "Limavady",
"4418478", "Thurso",
"441761", "Temple\ Cloud",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441745", "Rhyl",
"441661", "Prudhoe",
"441388", "Bishop\ Auckland",
"441945", "Wisbech",
"441335", "Ashbourne",
"441729", "Settle",
"4419759", "Alford\ \(Aberdeen\)",
"44147985", "Dulnain\ Bridge",
"441629", "Matlock",
"441215", "Birmingham",
"441350", "Dunkeld",
"441948", "Whitchurch",
"441406", "Holbeach",
"441481", "Guernsey",
"441372", "Esher",
"441404", "Honiton",
"441748", "Richmond",
"441400", "Honington",
"442821", "Martinstown",
"441356", "Brechin",
"441929", "Wareham",
"441864", "Abington\ \(Crawford\)",
"441866", "Kilchrenan",
"441354", "Chatteris",
"4419752", "Alford\ \(Aberdeen\)",
"442840", "Banbridge",
"4418516", "Great\ Bernera",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441692", "North\ Walsham",
"441792", "Swansea",
"441825", "Uckfield",
"441992", "Lea\ Valley",
"4416867", "Llanidloes",
"442844", "Downpatrick",
"441902", "Wolverhampton",
"4413391", "Aboyne\/Ballater",
"441550", "Llandovery",
"441538", "Ipstones",
"441832", "Clopton",
"441572", "Oakham",
"441878", "Lochboisdale",
"442311", "Southampton",
"441554", "Llanelli",
"441702", "Southend\-on\-Sea",
"441556", "Castle\ Douglas",
"441256", "Basingstoke",
"441490", "Corwen",
"442827", "Ballymoney",
"4413399", "Ballater",
"441254", "Blackburn",
"441285", "Cirencester",
"441494", "High\ Wycombe",
"441487", "Warboys",
"4413392", "Aboyne",
"441496", "Port\ Ellen",
"441250", "Blairgowrie",
"441765", "Ripon",
"442828", "Larne",
"441641", "Strathy",
"441665", "Alnwick",
"44238", "Southampton",
"441435", "Heathfield",
"441488", "Hungerford",
"441237", "Bideford",
"441463", "Inverness",
"441409", "Holsworthy",
"441626", "Newton\ Abbot",
"441920", "Ware",
"441733", "Peterborough",
"441724", "Scunthorpe",
"441877", "Callander",
"441726", "St\ Austell",
"441624", "Isle\ of\ Man",
"4412294", "Barrow\-in\-Furness",
"441633", "Newport",
"441933", "Wellingborough",
"441869", "Bicester",
"441924", "Wakefield",
"441803", "Torquay",
"441720", "Isles\ of\ Scilly",
"4419758", "Strathdon",
"441359", "Pakenham",
"441926", "Warwick",
"441620", "North\ Berwick",
"441343", "Elgin",
"4418905", "Ayton",
"441243", "Chichester",
"441259", "Alloa",
"4413398", "Aboyne",
"44141", "Glasgow",
"441141", "Sheffield",
"441499", "Inveraray",
"441531", "Ledbury",
"441871", "Castlebay",
"442882", "Omagh",
"441337", "Ladybank",
"441947", "Whitby",
"441747", "Shaftesbury",
"441559", "Llandysul",
"441647", "Moretonhampstead",
"441543", "Cannock",
"441422", "Halifax",
"441271", "Barnstaple",
"441453", "Dursley",
"441449", "Stowmarket",
"441377", "Driffield",
"441859", "Harris",
"441369", "Dunoon",
"441303", "Folkestone",
"441293", "Crawley",
"441843", "Thanet",
"441428", "Haslemere",
"441655", "Maybole",
"441593", "Lybster",
"441697", "Brampton",
"441786", "Stirling",
"441684", "Malvern",
"441797", "Rye",
"441980", "Amesbury",
"441784", "Staines",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441986", "Bungay",
"441984", "Watchet\ \(Williton\)",
"441780", "Stamford",
"441997", "Strathpeffer",
"441955", "Wick",
"441571", "Lochinver",
"441910", "Tyneside\/Durham\/Sunderland",
"441837", "Okehampton",
"441773", "Ripley",
"441673", "Market\ Rasen",
"441577", "Kinross",
"44281", "Northern\ Ireland",
"441569", "Stonehaven",
"441503", "Looe",
"4416860", "Newtown\/Llanidloes",
"4418518", "Stornoway",
"441707", "Welwyn\ Garden\ City",
"441914", "Tyneside",
"441691", "Oswestry",
"441916", "Tyneside",
"441475", "Greenock",
"4414234", "Boroughbridge",
"4414344", "Bellingham",
"441269", "Ammanford",
"4416863", "Llanidloes",
"4419644", "Patrington",
"4416973", "Wigton",
"441277", "Brentwood",
"441371", "Great\ Dunmow",
"441482", "Kingston\-upon\-Hull",
"4414304", "North\ Cave",
"441689", "Orpington",
"4418474", "Thurso",
"441789", "Stratford\-upon\-Avon",
"442881", "Newtownstewart",
"441278", "Bridgwater",
"441325", "Darlington",
"441989", "Ross\-on\-Wye",
"4413885", "Stanhope\ \(Eastgate\)",
"441908", "Milton\ Keynes",
"441838", "Dalmally",
"441446", "Barry",
"441444", "Haywards\ Heath",
"44147981", "Aviemore",
"441142", "Sheffield",
"4413396", "Ballater",
"441360", "Killearn",
"441872", "Truro",
"441578", "Lauder",
"441885", "Pencombe",
"441366", "Downham\ Market",
"441854", "Ullapool",
"441708", "Romford",
"441440", "Haverhill",
"441856", "Orkney",
"441608", "Chipping\ Norton",
"441364", "Ashburton",
"4418511", "Great\ Bernera\/Stornoway",
"4419756", "Strathdon",
"441264", "Andover",
"441698", "Motherwell",
"4415074", "Alford\ \(Lincs\)",
"441798", "Pulborough",
"441525", "Leighton\ Buzzard",
"441260", "Congleton",
"442896", "Belfast",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441560", "Moscow",
"4415396", "Sedbergh",
"442894", "Antrim",
"441332", "Derby",
"442887", "Dungannon",
"4418519", "Great\ Bernera",
"441942", "Wigan",
"441225", "Bath",
"44247", "Coventry",
"441919", "Durham",
"441642", "Middlesbrough",
"4418512", "Stornoway",
"441564", "Lapworth",
"441566", "Launceston",
"442890", "Belfast",
"441427", "Gainsborough",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:0|([0-24-8]\d{5})$)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/1534$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;