# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210602223256;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '1',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          9(?:
            0[01]|
            3[019]
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{de} = {"433834", "Wald\ am\ Schoberpaß",
"432823", "Großglobnitz",
"432617", "Draßmarkt",
"432268", "Großmugl",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"435678", "Weißenbach\ am\ Lech",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"4313", "Wien",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"434286", "Weißbriach",
"432618", "Markt\ Sankt\ Martin",
"432857", "Bad\ Großpertholz",
"4315", "Wien",
"437566", "Rosenau\ am\ Hengstpaß",
"4312", "Wien",
"436414", "Großarl",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"4318", "Wien",
"434226", "Sankt\ Margareten\ im\ Rosental",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"437254", "Großraming",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"437435", "Sankt\ Valentin",
"436276", "Nußdorf\ am\ Haunsberg",
"433868", "Tragöß",
"433362", "Großpetersdorf",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"434785", "Außerfragant",
"436565", "Neukirchen\ am\ Großvenediger",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"432847", "Groß\-Siegharts",
"436241", "Sankt\ Koloman",
"436247", "Großgmain",
"433386", "Großsteinbach",
"435352", "Sankt\ Johann\ in\ Tirol",
"437667", "Sankt\ Georgen\ im\ Attergau",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"433632", "Sankt\ Gallen",
"435279", "Sankt\ Jodok\ am\ Brenner",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"432242", "Sankt\ Andrä\-Wördern",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"437218", "Großtraberg",
"435245", "Hinterriß",
"435557", "Sankt\ Gallenkirch",
"434358", "Sankt\ Andrä",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"432756", "Sankt\ Leonhard\ am\ Forst",
"437751", "Sankt\ Martin\ im\ Innkreis",
"434876", "Kals\ am\ Großglockner",
"437477", "Sankt\ Peter\ in\ der\ Au",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"432233", "Preßbaum",
"434879", "Sankt\ Veit\ in\ Defereggen",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"4314", "Wien",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"432686", "Draßburg",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"437717", "Sankt\ Aegidi",
"432955", "Großweikersdorf",
"433684", "Sankt\ Martin\ am\ Grimming",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"433119", "Sankt\ Marein\ bei\ Graz",
"436215", "Straßwalchen",
"434783", "Reißeck",
"432719", "Droß",
"432642", "Aspangberg\-Sankt\ Peter",
"432742", "Sankt\ Pölten",
"432815", "Großschönau",
"433864", "Sankt\ Marein\ im\ Mürztal",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"432629", "Warth\,\ Niederösterreich",
"433585", "Sankt\ Lambrecht",
"432556", "Großkrut",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"434253", "Sankt\ Jakob\ im\ Rosental",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"436412", "Sankt\ Johann\ im\ Pongau",
"433537", "Sankt\ Georgen\ ob\ Murau",
"432647", "Krumbach\,\ Niederösterreich",
"436277", "Sankt\ Pantaleon",
"435449", "Fließ",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"432674", "Weißenbach\ an\ der\ Triesting",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"434266", "Straßburg",
"434264", "Klein\ Sankt\ Paul",
"436227", "Sankt\ Gilgen",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"432263", "Großrußbach",
"434843", "Außervillgraten",
"435446", "Sankt\ Anton\ am\ Arlberg",
"436477", "Sankt\ Michael\ im\ Lungau",
"432812", "Groß\ Gerungs",
"4319", "Wien",
"437219", "Vorderweißenbach",
"4316", "Wien",
"4317", "Wien",
"432822", "Zwettl\-Niederösterreich",
"432249", "Groß\-Enzersdorf",
"434877", "Prägraten\ am\ Großvenediger",
"433575", "Sankt\ Johann\ am\ Tauern",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"437956", "Unterweißenbach",
"433469", "Sankt\ Oswald\ im\ Freiland",
"437954", "Sankt\ Georgen\ am\ Walde",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"433158", "Sankt\ Anna\ am\ Aigen",
"433327", "Sankt\ Michael\ im\ Burgenland",
"437224", "Sankt\ Florian",
"434825", "Großkirchheim",
"437565", "Sankt\ Pankraz",
"433464", "Groß\ Sankt\ Florian",};
$areanames{en} = {"433461", "Trahütten",
"432943", "Obritz",
"435523", "Götzis",
"434782", "Obervellach",
"433631", "Unterlaussa",
"4314", "Vienna",
"432959", "Sitzendorf\ an\ der\ Schmida",
"435442", "Landeck",
"437227", "Neuhofen\ an\ der\ Krems",
"435558", "Gaschurn",
"433886", "Weichselboden",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"433884", "Wegscheid",
"432643", "Lichtenegg",
"433855", "Krieglach",
"436216", "Neumarkt\ am\ Wallersee",
"436214", "Henndorf\ am\ Wallersee",
"432743", "Böheimkirchen",
"433365", "Deutsch\ Schützen\-Eisenberg",
"437758", "Obernberg\ am\ Inn",
"434879", "St\.\ Veit\ in\ Defereggen",
"432855", "Waldenstein",
"432247", "Deutsch\-Wagram",
"435230", "Sellrain",
"433137", "Söding",
"432731", "Idolsberg",
"433326", "Stegersbach",
"435236", "Gries\ im\ Sellrain",
"435234", "Axams",
"433333", "Sebersdorf",
"435223", "Hall\ in\ Tirol",
"433324", "Strem",
"432631", "Pöttsching",
"437723", "Altheim",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"434357", "St\.\ Paul\ im\ Lavanttal",
"437736", "Pram",
"432816", "Karlstift",
"434257", "Fürnitz",
"432637", "Grünbach\ am\ Schneeberg",
"432814", "Langschlag",
"432873", "Kottes",
"432143", "Kittsee",
"435336", "Alpbach",
"432526", "Stronsdorf",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"432533", "Neusiedl\ an\ der\ Zaya",
"437240", "Sipbachzell",
"432524", "Kautendorf",
"435334", "Westendorf",
"437246", "Gunskirchen",
"435358", "Ellmau",
"437244", "Sattledt",
"432265", "Hausleiten",
"437762", "Raab",
"437662", "Seewalchen\ am\ Attersee",
"437478", "Oed\-Oehling",
"434712", "Greifenburg",
"435262", "Telfs",
"436457", "Flachau",
"437432", "Strengberg",
"433533", "Turrach",
"432233", "Pressbaum",
"433467", "Schwanberg",
"433143", "Krottendorf",
"437221", "Hörsching",
"433159", "Bad\ Gleichenberg",
"433637", "Gams\ bei\ Hieflau",
"437477", "St\.\ Peter\ in\ der\ Au",
"437282", "Neufelden",
"434876", "Kals\ am\ Grossglockner",
"433685", "Gröbming",
"437353", "Gaflenz",
"436458", "Hüttau",
"434874", "Virgen",
"436542", "Zell\ am\ See",
"43512", "Innsbruck",
"436132", "Bad\ Ischl",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"436434", "Bad\ Gastein",
"434852", "Lienz",
"435675", "Tannheim",
"433638", "Palfau",
"433329", "Jennersdorf",
"435239", "Kühtai",
"434258", "Gummern",
"432956", "Ziersdorf",
"434230", "Globasnitz",
"432638", "Winzendorf\-Muthmannsdorf",
"432738", "Fels\ am\ Wagram",
"432954", "Göllersdorf",
"432985", "Gars\ am\ Kamp",
"432672", "Berndorf",
"436242", "Russbach\ am\ Pass\ Gschütt",
"432772", "Neulengbach",
"43732", "Linz",
"437751", "St\.\ Martin\ im\ Innkreis",
"437582", "Kirchdorf\ an\ der\ Krems",
"432685", "Rust",
"436219", "Obertrum\ am\ See",
"433115", "Studenzen",
"435357", "Kirchberg\ in\ Tirol",
"434223", "Maria\ Saal",
"434234", "Ruden",
"432756", "St\.\ Leonhard\ am\ Forst",
"432754", "Loosdorf",
"435473", "Nauders",
"435414", "Wenns",
"434236", "Eberndorf",
"433476", "Bad\ Radkersburg",
"437757", "Gurten",
"432915", "Drosendorf\-Zissersdorf",
"433474", "Deutsch\ Goritz",
"433172", "Weiz",
"433842", "Leoben",
"432248", "Markgrafneusiedl",
"433150", "Paldau",
"436462", "Bischofshofen",
"433452", "Leibnitz",
"434358", "St\.\ Andrä",
"433185", "Preding",
"432615", "Lutzmannsburg",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"434262", "Treibach",
"437212", "Zwettl\ an\ der\ Rodl",
"435339", "Wildschönau",
"436589", "Unken",
"433615", "Trieben",
"437228", "Kematen\ an\ der\ Krems",
"437471", "Neustadtl\ an\ der\ Donau",
"435557", "St\.\ Gallenkirch",
"432842", "Waidhofen\ an\ der\ Thaya",
"437253", "Wolfern",
"432172", "Frauenkirchen",
"437249", "Bad\ Schallerbach",
"434268", "Friesach",
"437218", "Grosstraberg",
"432829", "Schweiggers",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"435447", "Flirsch",
"437745", "Lochen",
"436483", "Göriach",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"432664", "Semmering",
"432766", "Kleinzell",
"432764", "Hainfeld",
"432666", "Reichenau",
"435245", "Hinterriss",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"432242", "St\.\ Andrä\-Wördern",
"433848", "Eisenerz",
"433132", "Kumberg",
"436468", "Werfen",
"432625", "Bad\ Sauerbrunn",
"437443", "Ybbsitz",
"432725", "Frankenfels",
"434352", "Wolfsberg",
"434283", "St\.\ Stefan\ im\ Gailtal",
"434252", "Wernberg",
"432632", "Pernitz",
"432732", "Krems\ an\ der\ Donau",
"432164", "Rohrau",
"435579", "Alberschwende",
"432166", "Parndorf",
"432160", "Jois",
"434213", "Launsdorf",
"434274", "Velden\ am\ Wörther\ See",
"437588", "Ried\ im\ Traunkreis",
"437263", "Bad\ Zell",
"434276", "Feldkirchen\ in\ Kärnten",
"433125", "Übelbach",
"436229", "Hof\ bei\ Salzburg",
"432289", "Matzen",
"437767", "Eggerding",
"434823", "Tresdorf\,\ Rangersdorf",
"436470", "Atzmannsdorf",
"434717", "Steinfeld",
"437667", "St\.\ Georgen\ im\ Attergau",
"437563", "Spital\ am\ Pyhrn",
"437288", "Ulrichsberg",
"436452", "Radstadt",
"436548", "Niedernsill",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"435279", "St\.\ Jodok\ am\ Brenner",
"435635", "Elmen",
"433462", "Deutschlandsberg",
"436476", "St\.\ Margarethen\ im\ Lungau",
"435441", "See",
"433632", "St\.\ Gallen",
"434858", "Nikolsdorf",
"436474", "Tamsweg",
"436413", "Wagrain",
"437235", "Gallneukirchen",
"432841", "Vitis",
"437472", "Amstetten",
"434718", "Dellach",
"432865", "Litschau",
"437287", "Peilstein\ im\ Mühlviertel",
"435583", "Lech",
"433833", "Traboch",
"437211", "Reichenau\ im\ Mühlkreis",
"436547", "Kaprun",
"434245", "Feistritz\ an\ der\ Drau",
"436137", "Strobl",
"433514", "Seckau",
"437485", "Gaming",
"432214", "Kopfstetten",
"432273", "Tulbing",
"433573", "Fohnsdorf",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"433516", "Kleinlobming",
"435376", "Thiersee",
"435374", "Walchsee",
"432573", "Wilfersdorf",
"432826", "Rastenfeld",
"432824", "Allentsteig",
"436247", "Grossgmain",
"435283", "Kaltenbach",
"433171", "Gasen",
"435352", "St\.\ Johann\ in\ Tirol",
"437587", "Wartberg\ an\ der\ Krems",
"433386", "Grosssteinbach",
"432769", "Türnitz",
"437683", "Frankenburg\ am\ Hausruck",
"433865", "Kindberg",
"436461", "Dienten\ am\ Hochkönig",
"433355", "Stadtschlaining",
"437752", "Ried\ im\ Innkreis",
"433177", "Puch\ bei\ Weiz",
"432555", "Herrnbaumgarten",
"433847", "Trofaiach",
"435252", "Oetz",
"436467", "Mühlbach\ am\ Hochkönig",
"437676", "Ottnang\ am\ Hausruck",
"437713", "Schardenberg",
"437613", "Laakirchen",
"433457", "Gleinstätten",
"436479", "Muhr",
"437674", "Attnang\-Puchheim",
"435276", "Gschnitz",
"436241", "St\.\ Koloman",
"437952", "Weitersfelden",
"435213", "Scharnitz",
"435274", "Gries\ am\ Brenner",
"436131", "Obertraun",
"435513", "Hittisau",
"434267", "Metnitz",
"436565", "Neukirchen\ am\ Grossvenediger",
"435574", "Bregenz",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"436541", "Saalbach",
"435576", "Hohenems",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"435448", "Pettneu\ am\ Arlberg",
"435552", "Bludenz",
"436226", "Fuschl\ am\ See",
"433586", "Mühlen",
"432286", "Obersiebenbrunn",
"437415", "Altenmarkt\,\ Yspertal",
"436233", "Oberwang",
"432284", "Oberweiden",
"436224", "Hintersee",
"433584", "Neumarkt\ in\ Steiermark",
"432847", "Gross\-Siegharts",
"432177", "Podersdorf\ am\ See",
"434279", "Sirnitz",
"432255", "Deutsch\ Brodersdorf",
"437281", "Aigen\ im\ Mühlkreis",
"434735", "Kremsbrücke",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"433362", "Grosspetersdorf",
"433852", "Mürzzuschlag",
"432258", "Alland",
"432230", "Schwadorf",
"437747", "Kirchberg\ bei\ Mattighofen",
"435445", "Kappl",
"437947", "Kefermarkt",
"437231", "Herzogsdorf",
"434785", "Ausserfragant",
"433144", "Köflach",
"432236", "Mödling",
"433536", "St\.\ Peter\ am\ Kammersberg",
"433534", "Stadl\ an\ der\ Mur",
"432234", "Gramatneusiedl",
"433146", "Modriach",
"436583", "Leogang",
"432534", "Niedersulz",
"435333", "Söll",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"432146", "Nickelsdorf",
"432144", "Deutsch\ Jahrndorf",
"432536", "Drösing",
"432813", "Arbesbach",
"432874", "Martinsberg",
"432876", "Els",
"432627", "Pitten",
"437259", "Sierning",
"432852", "Gmünd",
"437243", "Marchtrenk",
"433358", "Litzelsdorf",
"433127", "Peggau",
"432262", "Korneuburg",
"433868", "Tragöss",
"434842", "Sillian",
"437724", "Mauerkirchen",
"437733", "Neumarkt\ im\ Hausruckkreis",
"432621", "Sieggraben",
"433334", "Kaindorf",
"435224", "Wattens",
"433323", "Eberau",
"435226", "Neustift\ im\ Stubaital",
"433336", "Waldbach",
"437941", "Neumarkt\ im\ Mühlkreis",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"435526", "Laterns",
"435524", "Satteins",
"437488", "Steinakirchen\ am\ Forst",
"432944", "Haugsdorf",
"432946", "Pulkau",
"434248", "Treffen",
"436213", "Oberhofen\ am\ Irrsee",
"437435", "St\.\ Valentin",
"432744", "Kasten\ bei\ Böheimkirchen",
"436274", "Lamprechtshausen",
"435265", "Nassereith",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"436276", "Nussdorf\ am\ Haunsberg",
"432644", "Grimmenstein",
"432746", "Wilhelmsburg",
"433883", "Terz",
"434715", "Kötschach\-Mauthen",
"437665", "Unterach\ am\ Attersee",
"437765", "Lambrechten",
"434229", "Krumpendorf\ am\ Wörther\ See",
"437238", "Mauthausen",
"437250", "Maria\ Neustift",
"434855", "Assling",
"435672", "Reutte",
"437487", "Gresten",
"436135", "Bad\ Goisern",
"437272", "Eferding",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"434247", "Afritz",
"433682", "Stainach",
"437285", "Hofkirchen\ im\ Mühlkreis",
"437254", "Grossraming",
"437256", "Ternberg",
"433357", "Pinkafeld",
"433867", "Pernegg\ an\ der\ Mur",
"433473", "Straden",
"433112", "Gleisdorf",
"432682", "Eisenstadt",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"432782", "Herzogenburg",
"436245", "Hallein",
"433149", "Geistthal",
"432982", "Horn",
"432239", "Breitenfurt\ bei\ Wien",
"433153", "Riegersburg",
"432949", "Niederfladnitz",
"432712", "Aggsbach",
"432612", "Oberpullendorf",
"433182", "Wildon",
"433455", "Arnfels",
"432728", "Wienerbruck",
"432953", "Nappersdorf",
"432628", "Felixdorf",
"434220", "Köttmannsdorf",
"432753", "Gansbach",
"433861", "Aflenz",
"435474", "Pfunds",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"434226", "St\.\ Margareten\ im\ Rosental",
"434224", "Pischeldorf",
"434233", "Griffen",
"435476", "Serfaus",
"433845", "Mautern\ in\ Steiermark",
"433175", "Anger",
"432557", "Bernhardsthal",
"432749", "Prinzersdorf",
"432912", "Geras",
"4318", "Vienna",
"432649", "Mönichkirchen",
"435248", "Steinberg\ am\ Rofan",
"434873", "St\.\ Jakob\ in\ Defereggen",
"432175", "Apetlon",
"432257", "Klausen\-Leopoldsdorf",
"432845", "Weikertschlag\ an\ der\ Thaya",
"437748", "Eggelsberg",
"433339", "Friedberg",
"437948", "Hirschbach\ im\ Mühlkreis",
"433612", "Liezen",
"436433", "Dorfgastein",
"437215", "Hellmonsödt",
"434265", "Weitensfeld\ im\ Gurktal",
"437729", "Neukirchen\ an\ der\ Enknach",
"435242", "Schwaz",
"437566", "Rosenau\ am\ Hengstpass",
"4312", "Vienna",
"437564", "Hinterstoder",
"433857", "Neuberg\ an\ der\ Mürz",
"434824", "Heiligenblut",
"437742", "Mattighofen",
"434826", "Mörtschach",
"433622", "Bad\ Aussee",
"436473", "Mariapfarr",
"434769", "Möllbrücke",
"436414", "Grossarl",
"437225", "Hargelsberg",
"437619", "Kirchham",
"436416", "Lend",
"437719", "Taufkirchen\ an\ der\ Pram",
"437942", "Freistadt",
"433618", "Hohentauern",
"432718", "Lichtenau\ im\ Waldviertel",
"437260", "Waldhausen",
"432163", "Petronell\-Carnuntum",
"432618", "Markt\ St\.\ Martin",
"434355", "Gemmersdorf",
"435519", "Schröcken",
"432722", "Kirchberg\ an\ der\ Pielach",
"432622", "Wiener\ Neustadt",
"433135", "Kalsdorf\ bei\ Graz",
"432245", "Wolkersdorf\ im\ Weinviertel",
"437264", "Windhaag\ bei\ Perg",
"432857", "Bad\ Grosspertholz",
"434214", "Brückl",
"437266", "Bad\ Kreuzen",
"434273", "Reifnitz",
"4315", "Vienna",
"432267", "Sierndorf",
"432688", "Steinbrunn",
"433118", "Sinabelkirchen",
"434284", "Kirchbach",
"434847", "Obertilliach",
"434286", "Weissbriach",
"432988", "Neupölla",
"432735", "Hadersdorf\ am\ Kamp",
"437444", "Opponitz",
"433579", "Pöls",
"432279", "Kirchberg\ am\ Wagram",
"434255", "Arnoldstein",
"432635", "Neunkirchen",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"435678", "Weissenbach\ am\ Lech",
"433635", "Radmer",
"433465", "Pölfing\-Brunn",
"435632", "Stanzach",
"437278", "Neukirchen\ am\ Walde",
"43662", "Salzburg",
"436455", "Untertauern",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"432663", "Schottwien",
"433688", "Tauplitz",
"435289", "Häusling",
"4313", "Vienna",
"436484", "Lessach",
"435677", "Vils",
"437482", "Scheibbs",
"437277", "Waizenkirchen",
"435516", "Doren",
"435514", "Bezau",
"434242", "Villach",
"433611", "Johnsbach",
"435573", "Hörbranz",
"437269", "Baumgartenberg",
"435510", "Damüls",
"433687", "Schladming",
"432862", "Heidenreichstein",
"436234", "Zell\ am\ Moos",
"432283", "Angern\ an\ der\ March",
"433583", "Unzmarkt",
"436223", "Anthering",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"433352", "Oberwart",
"433862", "Bruck\ an\ der\ Mur",
"432268", "Grossmugl",
"432687", "Siegendorf",
"435355", "Jochberg",
"433117", "Eggersdorf\ bei\ Graz",
"435214", "Leutasch",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"434848", "Kartitsch",
"435273", "Matrei\ am\ Brenner",
"432711", "Dürnstein",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"437614", "Vorchdorf",
"437716", "Münzkirchen",
"437673", "Schwanenstadt",
"437714", "Esternberg",
"434766", "Millstatt",
"437616", "Grünau\ im\ Almtal",
"432823", "Grossglobnitz",
"432717", "Unter\-Meisling",
"435280", "Hochfügen",
"437955", "Königswiesen",
"432617", "Drassmarkt",
"435373", "Ebbs",
"432574", "Gaweinstal",
"432576", "Ernstbrunn",
"435255", "Umhausen",
"437684", "Frankenmarkt",
"432858", "Moorbad\ Harbach",
"432552", "Poysdorf",
"435286", "Ginzling",
"433383", "Burgau",
"435284", "Gerlos",
"437755", "Mettmach",
"434732", "Gmünd\ in\ Kärnten",
"433858", "Mitterdorf\ im\ Mürztal",
"432252", "Baden",
"437412", "Ybbs\ an\ der\ Donau",
"433576", "Bretstein",
"432276", "Reidling",
"433513", "Bischoffeld",
"432213", "Lassee",
"432274", "Sieghartskirchen",
"433574", "Pusterwald",
"433617", "Gaishorn\ am\ See",
"433834", "Wald\ am\ Schoberpass",
"436562", "Mittersill",
"432527", "Wulzeshofen",
"435337", "Brixlegg",
"434285", "Tröpolach",
"432162", "Bruck\ an\ der\ Leitha",
"432958", "Maissau",
"432636", "Puchberg\ am\ Schneeberg",
"434256", "Nötsch\ im\ Gailtal",
"432723", "Rabenstein\ an\ der\ Pielach",
"437445", "Hollenstein\ an\ der\ Ybbs",
"432734", "Langenlois",
"432736", "Paudorf",
"432634", "Gutenstein",
"434254", "Faak\ am\ See",
"432623", "Pottendorf",
"435418", "Schönwies",
"432758", "Pöggstall",
"435559", "Brand",
"432630", "Ternitz",
"434238", "Eisenkappel\-Vellach",
"437247", "Kematen\ am\ Innbach",
"434272", "Pörtschach\ am\ Wörther\ See",
"436454", "Mandling",
"433460", "Soboth",
"435243", "Maurach",
"437759", "Antiesenhofen",
"436456", "Obertauern",
"437743", "Maria\ Schmolln",
"433634", "Hieflau",
"436472", "Mauterndorf",
"433623", "Bad\ Mitterndorf",
"437943", "Windhaag\ bei\ Freistadt",
"433636", "Wildalpen",
"433464", "Gross\ St\.\ Florian",
"433466", "Eibiswald",
"437224", "St\.\ Florian",
"436415", "Schwarzach\ im\ Pongau",
"437233", "Feldkirchen\ an\ der\ Donau",
"437226", "Wilhering",
"435633", "Hägerau",
"436217", "Mattsee",
"435359", "Hochfilzen",
"432762", "Lilienfeld",
"437565", "St\.\ Pankraz",
"432662", "Gloggnitz",
"434825", "Grosskirchheim",
"432246", "Gerasdorf\ bei\ Wien",
"437479", "Ardagger",
"433134", "Heiligenkreuz\ am\ Waasen",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"433136", "Dobl",
"432244", "Langenzersdorf",
"437265", "Pabneukirchen",
"434215", "Liebenfels",
"437241", "Steinerkirchen\ an\ der\ Traun",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"434356", "Lavamünd",
"435331", "Brandenberg",
"434354", "Preitenegg",
"433327", "St\.\ Michael\ im\ Burgenland",
"433158", "St\.\ Anna\ am\ Aigen",
"434231", "Mittertrixen",
"435254", "Sölden",
"433353", "Oberschützen",
"435256", "Untergurgl",
"433863", "Turnau",
"433477", "St\.\ Peter\ am\ Ottersbach",
"435285", "Mayrhofen",
"437754", "Waldzell",
"435272", "Steinach\ am\ Brenner",
"433469", "St\.\ Oswald\ im\ Freiland",
"437956", "Unterweissenbach",
"437954", "St\.\ Georgen\ am\ Walde",
"437750", "Andrichsfurt",
"433157", "Kapfenstein",
"437672", "Vöcklabruck",
"433328", "Kukmirn",
"432575", "Ladendorf",
"435238", "Zirl",
"432951", "Guntersdorf",
"432739", "Tiefenfucha",
"437483", "Oberndorf\ an\ der\ Melk",
"432639", "Bad\ Fischau",
"433575", "St\.\ Johann\ am\ Tauern",
"435550", "Thüringen",
"432275", "Atzenbrugg",
"435572", "Dornbirn",
"434243", "Bodensdorf",
"435585", "Dalaas",
"435556", "Schruns",
"432282", "Gänserndorf",
"432863", "Eggern",
"433582", "Scheifling",
"435554", "Sonntag",
"434877", "Prägraten\ am\ Grossvenediger",
"434733", "Malta",
"432253", "Oberwaltersdorf",
"436235", "Thalgau",
"437413", "Marbach\ an\ der\ Donau",
"437474", "Euratsfeld",
"432249", "Gross\-Enzersdorf",
"437476", "Aschbach\-Markt",
"433512", "Knittelfeld",
"432212", "Orth\ an\ der\ Donau",
"435515", "Au",
"434359", "Reichenfels",
"436563", "Uttendorf",
"435338", "Kundl",
"432822", "Zwettl\,\ Lower\ Austria",
"436588", "Lofer",
"435372", "Kufstein",
"437229", "Traun",
"437615", "Scharnstein",
"432957", "Hohenwarth",
"433151", "Gnas",
"432757", "Pöchlarn",
"435417", "Roppen",
"434237", "Miklauzhof",
"437248", "Grieskirchen",
"4346", "Klagenfurt",
"435354", "Fieberbrunn",
"435356", "Kitzbühel",
"433382", "Fürstenfeld",
"437219", "Vorderweissenbach",
"432828", "Rappottenstein",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"432522", "Laa\ an\ der\ Thaya",
"435332", "Wörgl",
"434269", "Flattnitz",
"432167", "Neusiedl\ am\ See",
"435225", "Fulpmes",
"433335", "Pöllau",
"432812", "Gross\ Gerungs",
"4319", "Vienna",
"4316", "Vienna",
"432849", "Schwarzenau",
"4317", "Vienna",
"437242", "Wels",
"432853", "Schrems",
"434277", "Glanegg",
"432745", "Pyhra",
"437434", "Haag",
"433363", "Rechnitz",
"433179", "Passail",
"435264", "Mieming",
"435266", "Ötztal\-Bahnhof",
"432645", "Wiesmath",
"433853", "Spital\ am\ Semmering",
"437766", "Andorf",
"437664", "Weyregg\ am\ Attersee",
"434714", "Dellach\ im\ Drautal",
"434716", "Lesachtal",
"433849", "Vordernberg",
"437666", "Attersee",
"437764", "Riedau",
"436477", "St\.\ Michael\ im\ Lungau",
"434710", "Oberdrauburg",
"435525", "Nenzing",
"432945", "Zellerndorf",
"435444", "Ischgl",
"436471", "Tweng",
"434784", "Mallnitz",
"435446", "St\.\ Anton\ am\ Arlberg",
"433145", "Edelschrott",
"432235", "Maria\-Lanzendorf",
"433535", "Krakaudorf",
"435578", "Höchst",
"432767", "Hohenberg",
"436212", "Seekirchen\ am\ Wallersee",
"432667", "Schwarzau\ im\ Gebirge",
"433588", "Katsch\ an\ der\ Mur",
"436228", "Faistenau",
"432288", "Auersthal",
"433882", "Mariazell",
"432263", "Grossrussbach",
"434271", "Steuerberg",
"437289", "Rohrbach\ in\ Oberösterreich",
"435278", "Navis",
"432535", "Hohenau\ an\ der\ March",
"434843", "Ausservillgraten",
"436549", "Piesendorf",
"432145", "Prellenkirchen",
"437732", "Haag\ am\ Hausruck",
"432875", "Grafenschlag",
"435232", "Kematen\ in\ Tirol",
"433322", "Güssing",
"435475", "Feichten",
"433846", "Kalwang",
"434225", "Grafenstein",
"433844", "Kammern\ im\ Liesingtal",
"436466", "Werfenweng",
"433174", "Birkfeld",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"433472", "Mureck",
"432683", "Purbach\ am\ Neusiedler\ See",
"433176", "Stubenberg",
"432783", "Traismauer",
"433170", "Fischbach",
"432983", "Sigmundsherberg",
"433454", "Leutschach",
"433152", "Feldbach",
"433456", "Fresing",
"435673", "Ehrwald",
"437273", "Aschach\ an\ der\ Donau",
"434266", "Strassburg",
"437214", "Reichenthal",
"437216", "Helfenberg",
"434264", "Klein\ St\.\ Paul",
"435577", "Lustenau",
"437355", "Weyer",
"432176", "Tadten",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"432174", "Wallern\ im\ Burgenland",
"433683", "Donnersbach",
"436227", "St\.\ Gilgen",
"433587", "Schönberg\-Lachtal",
"432287", "Strasshof\ an\ der\ Nordbahn",
"432844", "Karlstein\ an\ der\ Thaya",
"432846", "Raabs\ an\ der\ Thaya",
"434872", "Huben",
"437286", "Lembach\ im\ Mühlkreis",
"437284", "Oberkappel",
"437255", "Losenstein",
"436221", "Koppl",
"433581", "Oberwölz",
"436478", "Zederhaus",
"436432", "Bad\ Hofgastein",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"433613", "Admont",
"436134", "Hallstatt",
"436136", "Gosau",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"436544", "Rauris",
"432774", "Innermanzing",
"432827", "Schönbach",
"436244", "Golling\ an\ der\ Salzach",
"432713", "Spitz",
"432674", "Weissenbach\ an\ der\ Triesting",
"436246", "Grödig",
"432613", "Deutschkreutz",
"432168", "Mannersdorf\ am\ Leithagebirge",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"432952", "Hollabrunn",
"435449", "Fliess",
"435412", "Imst",
"432752", "Melk",
"434232", "Völkermarkt",
"432913", "Hötzelsdorf",
"436240", "Krispl",
"437584", "Molln",
"433387", "Söchau",
"437586", "Pettenbach",
"43316", "Graz",
"434278", "Gnesau",
"432259", "Münchendorf",
"434275", "Ebene\ Reichenau",
"433126", "Frohnleiten",
"432243", "Klosterneuburg",
"433133", "Nestelbach",
"433124", "Gratkorn",
"433337", "Vorau",
"437442", "Waidhofen\ an\ der\ Ybbs",
"432165", "Hainburg\ a\.d\.\ Donau",
"437727", "Ach",
"434353", "Prebl",
"434282", "Hermagor",
"433141", "Hirschegg",
"432231", "Purkersdorf",
"432947", "Theras",
"435634", "Elbigenalp",
"437236", "Pregarten",
"436475", "Ramingstein",
"437223", "Enns",
"437234", "Ottensheim",
"437258", "Bad\ Hall",
"437230", "Altenberg\ bei\ Linz",
"432647", "Krumbach\,\ Lower\ Austria",
"432747", "Ober\-Grafendorf",
"436277", "St\.\ Pantaleon",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"437744", "Munderfing",
"433359", "Loipersdorf\-Kitzladen",
"437746", "Friedburg",
"434822", "Winklern",
"435246", "Achenkirch",
"432665", "Prein\ an\ der\ Rax",
"432741", "Flinsbach",
"437562", "Windischgarsten",
"432765", "Kaumberg",
"436453", "Filzmoos",
"435244", "Jenbach",
"432641", "Kirchberg\ am\ Wechsel",
"432237", "Gaaden",
"433537", "St\.\ Georgen\ ob\ Murau",
"433147", "Salla",
"433463", "Stainz",
"437944", "Sandl",
"436412", "St\.\ Johann\ im\ Pongau",
"437946", "Gutau",
"433633", "Landl",
"433624", "Pichl\-Kainisch",
"432726", "Puchenstuben",
"432633", "Markt\ Piesting",
"434253", "St\.\ Jakob\ im\ Rosental",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"437489", "Purgstall\ an\ der\ Erlauf",
"432624", "Ebenfurth",
"432626", "Mattersburg",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"432877", "Grainbrunn",
"432733", "Schönberg\ am\ Kamp",
"432147", "Zurndorf",
"434212", "St\.\ Veit\ an\ der\ Glan",
"437262", "Perg",
"432620", "Willendorf",
"434228", "Feistritz\ im\ Rosental",
"432878", "Traunstein",
"437239", "Lichtenberg",
"432572", "Mistelbach",
"437675", "Ampflwang\ im\ Hausruckwald",
"435275", "Trins",
"432538", "Velm\-Götzendorf",
"432556", "Grosskrut",
"435282", "Zell\ am\ Ziller",
"435353", "Waidring",
"432554", "Stützenhofen",
"434227", "Ferlach",
"437682", "Vöcklamarkt",
"435477", "Tösens",
"437416", "Wieselburg",
"437251", "Schiedlberg",
"433585", "St\.\ Lambrecht",
"436225", "Eugendorf",
"437414", "Weins\-Isperdorf",
"432285", "Marchegg",
"437473", "Blindenmarkt",
"434736", "Innerkrems",
"432254", "Ebreichsdorf",
"437357", "Kleinreifling",
"432256", "Leobersdorf",
"435582", "Klösterle",
"434734", "Rennweg",
"432238", "Kaltenleutgeben",
"433832", "Kraubath\ an\ der\ Mur",
"436564", "Krimml",
"435575", "Langen\ bei\ Bregenz",
"436566", "Bramberg\ am\ Wildkogel",
"433148", "Kainach\ bei\ Voitsberg",
"432272", "Tulln\ an\ der\ Donau",
"433572", "Judenburg",
"434244", "Bad\ Bleiberg",
"435512", "Egg",
"434246", "Radenthein",
"432948", "Weitersfeld",
"437484", "Göstling\ an\ der\ Ybbs",
"432629", "Warth\,\ Lower\ Austria",
"432215", "Probstdorf",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"437486", "Lunz\ am\ See",
"437480", "Langau\,\ Gaming",
"435553", "Raggal",
"437257", "Grünburg",
"436232", "Mondsee",
"432864", "Kautzen",
"432648", "Hochneukirchen",
"434240", "Bad\ Kleinkirchheim",
"436278", "Ostermiething",
"432748", "Kilb",
"433385", "Ilz",
"437753", "Eberschwang",
"433356", "Markt\ Allhau",
"433864", "St\.\ Marein\ im\ Mürztal",
"433866", "Breitenau\ am\ Hochlantsch",
"434221", "Gallizien",
"435253", "Längenfeld",
"433354", "Bernstein",
"437949", "Rainbach\ im\ Mühlkreis",
"437712", "Schärding",
"437612", "Gmunden",
"434762", "Spittal\ an\ der\ Drau",
"433338", "Lafnitz",
"435375", "Kössen",
"437953", "Liebenau",
"437728", "Schwand\ im\ Innkreis",
"432825", "Göpfritz\ an\ der\ Wild",
"435212", "Seefeld\ in\ Tirol",
"437261", "Schönau\ im\ Mühlkreis",
"437245", "Lambach",
"432264", "Rückersdorf\,\ Harmannsdorf",
"432266", "Stockerau",
"437718", "Waldkirchen\ am\ Wesen",
"432815", "Grossschönau",
"433332", "Hartberg",
"434768", "Kleblach\-Lind",
"437618", "Neukirchen\,\ Altmünster",
"434846", "Abfaltersbach",
"437722", "Braunau\ am\ Inn",
"432525", "Gnadendorf",
"435335", "Hopfgarten\ im\ Brixental",
"433619", "Oppenberg",
"432619", "Lackendorf",
"435518", "Mellau",
"432719", "Dross",
"432942", "Retz",
"435522", "Feldkirch",
"434783", "Reisseck",
"435443", "Galtür",
"432642", "Aspangberg\-St\.\ Peter",
"436272", "Oberndorf\ bei\ Salzburg",
"432742", "St\.\ Pölten",
"437763", "Kopfing\ im\ Innkreis",
"433885", "Greith",
"437663", "Steinbach\ am\ Attersee",
"434713", "Techendorf",
"433366", "Kohfidisch",
"433854", "Langenwang",
"433856", "Veitsch",
"432689", "Hornstein",
"437433", "Wallsee",
"433119", "St\.\ Marein\ bei\ Graz",
"436215", "Strasswalchen",
"433364", "Hannersdorf",
"435263", "Silz",
"433532", "Murau",
"432232", "Fischamend",
"432989", "Brunn\ an\ der\ Wild",
"433142", "Voitsberg",
"433578", "Obdach",
"432278", "Absdorf",
"436417", "Hüttschlag",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"432872", "Ottenschlag",
"437735", "Gaspoltshofen",
"432142", "Gattendorf",
"432532", "Zistersdorf",
"437279", "Haibach\ ob\ der\ Donau",
"432856", "Weitra",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"435288", "Fügen",
"437267", "Mönchdorf",
"432854", "Kirchberg\ am\ Walde",
"434761", "Stockenboi",
"433155", "Fehring",
"432577", "Asparn\ an\ der\ Zaya",
"437711", "Suben",
"432716", "Gföhl",
"432673", "Altenmarkt\ an\ der\ Triesting",
"432614", "Kleinwarasdorf",
"433184", "Wolfsberg\ im\ Schwarzautal",
"432773", "Eichgraben",
"432616", "Lockenhaus",
"436243", "Abtenau",
"432714", "Rossatz",
"435287", "Tux",
"432610", "Horitschon",
"432916", "Riegersburg\,\ Hardegg",
"433475", "Hürth",
"432914", "Japons",
"437268", "Grein",
"437583", "Kremsmünster",
"435472", "Prutz",
"432269", "Niederfellabrunn",
"437283", "Sarleinsbach",
"433616", "Selzthal",
"436543", "Taxenbach",
"433614", "Rottenmann",
"436133", "Ebensee",
"433577", "Zeltweg",
"432277", "Zwentendorf",
"436418", "Kleinarl",
"434853", "Ainet",
"435517", "Riezlern",
"434263", "Hüttenberg",
"437276", "Peuerbach",
"433680", "Donnersbachwald",
"437274", "Alkoven",
"437213", "Bad\ Leonfelden",
"435676", "Jungholz",
"435674", "Bichlbach",
"433571", "Möderbrugg",
"432271", "Ried\ am\ Riederberg",
"432843", "Dobersberg",
"437252", "Steyr",
"432173", "Gols",
"433684", "St\.\ Martin\ am\ Grimming",
"432859", "Brand\-Nagelberg",
"433686", "Haus",
"434875", "Matrei\ in\ Osttirol",
"432686", "Drassburg",
"433859", "Mürzsteg",
"433116", "Kirchbach\ in\ Steiermark",
"432784", "Perschling",
"433173", "Ratten",
"432786", "Oberwölbling",
"433114", "Markt\ Hartmannsdorf",
"432684", "Schützen\ am\ Gebirge",
"434235", "Bleiburg",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"436463", "Annaberg\-Lungötz",
"432755", "Mank",
"437717", "St\.\ Aegidi",
"433453", "Ehrenhausen",
"437448", "Kematen\ an\ der\ Ybbs",
"434767", "Rothenthurn",
"437617", "Traunkirchen",
"432955", "Grossweikersdorf",
"432984", "Eggenburg",
"432986", "Irnfritz",
"432680", "St\.\ Margarethen\ im\ Burgenland",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;