package PDK::Firewall::Element::Zone::Role;

#------------------------------------------------------------------------------
# 加载扩展模块
#------------------------------------------------------------------------------
use Moose::Role;
use namespace::autoclean;
use PDK::Utils::Ip;
use PDK::Utils::Set;

#------------------------------------------------------------------------------
# 引用 PDK::Firewall::Element::Role 角色
#------------------------------------------------------------------------------
with 'PDK::Firewall::Element::Role';

#------------------------------------------------------------------------------
# 定义防火墙安全区通用方法和属性
#------------------------------------------------------------------------------
has name => (is => 'ro', isa => 'Str', required => 1,);

has interfaces => (is => 'ro', does => 'HashRef[PDK::Firewall::Element::Interface::Role]', default => sub { {} },);

has range => (is => 'ro', isa => 'PDK::Utils::Set', default => sub { PDK::Utils::Set->new });

#------------------------------------------------------------------------------
# 安全区添加接口 -- 入参为接口对象
#------------------------------------------------------------------------------
sub addInterface {
  my ($self, $interface) = @_;
  $self->interfaces->{$interface->sign} = $interface;
  $self->range->mergeToSet($interface->range);
}

#------------------------------------------------------------------------------
# 安全区添加地址段
#------------------------------------------------------------------------------
sub addrIpRange {
  my $self   = shift;
  my $result = [];
  my $Ip     = PDK::Utils::Ip->new;
  for (my $i = 0; $i < $self->range->length; $i++) {
    my $ipMin  = $Ip->changeIntToIp($self->range->mins->[$i]);
    my $ipMax  = $Ip->changeIntToIp($self->range->maxs->[$i]);
    my $ipAddr = $ipMin . '-' . $ipMax;
    push @{$result}, $ipAddr;
  }
  return $result;
}

#------------------------------------------------------------------------------
# 安全区地址段 - 最小地址结合
#------------------------------------------------------------------------------
sub mins {
  my $self = shift;
  return $self->range->mins;
}

#------------------------------------------------------------------------------
# 安全区地址段 - 最大地址结合
#------------------------------------------------------------------------------
sub maxs {
  my $self = shift;
  return $self->range->maxs;
}

#------------------------------------------------------------------------------
# 设定防火墙区域通用签名方法
#------------------------------------------------------------------------------
sub _buildSign {
  my $self = shift;
  return $self->createSign($self->name);
}

1;
