package PDK::Firewall::Element::Route::Srx;

#------------------------------------------------------------------------------
# 加载扩展模块
#------------------------------------------------------------------------------
use Moose;
use namespace::autoclean;

#------------------------------------------------------------------------------
# 引用 PDK::Firewall::Element::Route::Role 角色
#------------------------------------------------------------------------------
with 'PDK::Firewall::Element::Route::Role';

#------------------------------------------------------------------------------
# Juniper 防火墙路由对象方法和属性
#------------------------------------------------------------------------------
has '+routeInstance' => (required => 1);

#------------------------------------------------------------------------------
# 路由对象通用签名方法
#------------------------------------------------------------------------------
sub _buildSign {
  my $self = shift;
  if ($self->type =~ /static|connect/i) {
    return $self->createSign($self->network, $self->routeInstance);
  }
  else {
    return $self->createSign($self->network, $self->srcIpmask);
  }
}

__PACKAGE__->meta->make_immutable;
1;
