package Firewall::Config::Element::AddressGroup::Srx;

#------------------------------------------------------------------------------
# 加载扩展模块
#------------------------------------------------------------------------------
use Moose;
use namespace::autoclean;
use Firewall::Config::Element::Address::Srx;

#------------------------------------------------------------------------------
# 引用 Firewall::Config::Element::AddressGroup::Role 角色
#------------------------------------------------------------------------------
with 'Firewall::Config::Element::AddressGroup::Role';

#------------------------------------------------------------------------------
# Firewall::Config::Element::AddressGroup::Netscreen 通用属性
#------------------------------------------------------------------------------
has zone => (is => 'ro', isa => 'Str', required => 1,);

#------------------------------------------------------------------------------
# 重写 Firewall::Config::Element::Role => _buildSign 方法，
#------------------------------------------------------------------------------
sub _buildSign {
  my $self = shift;
  return $self->createSign($self->zone, $self->addrGroupName);
}

__PACKAGE__->meta->make_immutable;
1;
