use lib "t/lib";
use TestAuto;

use strict;
use warnings;

use Test::More 'no_plan';


use FindBin;
use lib "$FindBin::Bin/lib";

use SPVM 'TestCase::BitNot';

# Start objects count
my $start_memory_blocks_count = SPVM::get_memory_blocks_count();

# Spec tests
{
  # Bit not - Operation
  {
    ok(TestCase::BitNot->bit_not_byte);
    ok(TestCase::BitNot->bit_not_short);
    ok(TestCase::BitNot->bit_not_int);
    ok(TestCase::BitNot->bit_not_int_theory);
    ok(TestCase::BitNot->bit_not_long);
  }

  # Bit not - Compile Error
  {
    {
      my $build = SPVM::Builder->new;
      $build->use('TestCase::CompileError::BitNot::NotIntegral');
      my $success = $build->compile_spvm();
      ok($success == 0);
    }
  }
}

# All object is freed
my $end_memory_blocks_count = SPVM::get_memory_blocks_count();
is($end_memory_blocks_count, $start_memory_blocks_count);
