#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_byte_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_byte_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_double_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_double_double_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_float_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_overflow(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_long_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_long_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_long_overflow(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_long_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_short_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Multiply__multiply_short_short(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Multiply__multiply(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[11];
  float float_vars[9];
  int32_t int_vars[15];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L4: // MULTIPLY_INT
  int_vars[5] = int_vars[3] * int_vars[4];
L5: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L7: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L8: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L9: // MULTIPLY_INT
  int_vars[7] = int_vars[4] * int_vars[6];
L10: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L12: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L13: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L14: // MULTIPLY_INT
  int_vars[8] = int_vars[3] * int_vars[6];
L15: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L16: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L17: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L19: // MULTIPLY_INT
  int_vars[9] = int_vars[4] * int_vars[6];
L20: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L22: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L23: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[0];
L24: // MULTIPLY_INT
  int_vars[10] = int_vars[3] * int_vars[6];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L26: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L27: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[6] = 7;
L29: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L30: // CONVERT_BYTE_TO_INT
  int_vars[11] = (int32_t)byte_vars[1];
L31: // MULTIPLY_INT
  int_vars[12] = int_vars[4] * int_vars[11];
L32: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L33: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L34: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L35: // MOVE_CONSTANT_INT
  int_vars[6] = 8;
L36: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L37: // CONVERT_SHORT_TO_INT
  int_vars[11] = (int32_t)short_vars[1];
L38: // MULTIPLY_INT
  int_vars[13] = int_vars[4] * int_vars[11];
L39: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L42: // MOVE_CONSTANT_INT
  int_vars[6] = 9;
L43: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[6];
L44: // CONVERT_SHORT_TO_INT
  int_vars[11] = (int32_t)short_vars[0];
L45: // MULTIPLY_INT
  int_vars[14] = int_vars[4] * int_vars[11];
L46: // MOVE_CONSTANT_INT
  int_vars[3] = -4;
L47: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[3]);
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L50: // MOVE_CONSTANT_INT
  int_vars[3] = -6;
L51: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[3]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L86; }
L54: // MOVE_CONSTANT_INT
  int_vars[3] = -8;
L55: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[3]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L58: // MOVE_CONSTANT_INT
  int_vars[3] = -10;
L59: // EQ_INT
  int_vars[0] = (int_vars[9] == int_vars[3]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L62: // MOVE_CONSTANT_INT
  int_vars[3] = -12;
L63: // EQ_INT
  int_vars[0] = (int_vars[10] == int_vars[3]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L83; }
L66: // MOVE_CONSTANT_INT
  int_vars[3] = -14;
L67: // EQ_INT
  int_vars[0] = (int_vars[12] == int_vars[3]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L70: // MOVE_CONSTANT_INT
  int_vars[3] = -16;
L71: // EQ_INT
  int_vars[0] = (int_vars[13] == int_vars[3]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L74: // MOVE_CONSTANT_INT
  int_vars[3] = -18;
L75: // EQ_INT
  int_vars[0] = (int_vars[14] == int_vars[3]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L80; }
L78: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L79: // GOTO
  goto L80;
L80: // GOTO
  goto L81;
L81: // GOTO
  goto L82;
L82: // GOTO
  goto L83;
L83: // GOTO
  goto L84;
L84: // GOTO
  goto L85;
L85: // GOTO
  goto L86;
L86: // GOTO
  goto L87;
L87: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L88: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L89: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L90: // MULTIPLY_FLOAT
  float_vars[2] = float_vars[0] * float_vars[1];
L91: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L92: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L93: // CONVERT_BYTE_TO_FLOAT
  float_vars[0] = (float)byte_vars[0];
L94: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L95: // MULTIPLY_FLOAT
  float_vars[3] = float_vars[0] * float_vars[1];
L96: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L97: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L98: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L99: // CONVERT_BYTE_TO_FLOAT
  float_vars[1] = (float)byte_vars[0];
L100: // MULTIPLY_FLOAT
  float_vars[4] = float_vars[0] * float_vars[1];
L101: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L102: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L103: // CONVERT_SHORT_TO_FLOAT
  float_vars[0] = (float)short_vars[0];
L104: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L105: // MULTIPLY_FLOAT
  float_vars[5] = float_vars[0] * float_vars[1];
L106: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L107: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L108: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L109: // CONVERT_SHORT_TO_FLOAT
  float_vars[1] = (float)short_vars[0];
L110: // MULTIPLY_FLOAT
  float_vars[6] = float_vars[0] * float_vars[1];
L111: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L112: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[4];
L113: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L114: // MULTIPLY_FLOAT
  float_vars[7] = float_vars[0] * float_vars[1];
L115: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L116: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L117: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L118: // MULTIPLY_FLOAT
  float_vars[8] = float_vars[0] * float_vars[1];
L119: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.125;
L120: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L121: // BOOL_INT
  int_vars[0] = int_vars[0];
L122: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L155; }
L123: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L124: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L125: // BOOL_INT
  int_vars[0] = int_vars[0];
L126: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L154; }
L127: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L128: // EQ_FLOAT
  int_vars[0] = (float_vars[4] == float_vars[0]);
L129: // BOOL_INT
  int_vars[0] = int_vars[0];
L130: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L153; }
L131: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L132: // EQ_FLOAT
  int_vars[0] = (float_vars[5] == float_vars[0]);
L133: // BOOL_INT
  int_vars[0] = int_vars[0];
L134: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L152; }
L135: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L136: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[0]);
L137: // BOOL_INT
  int_vars[0] = int_vars[0];
L138: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L151; }
L139: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L140: // EQ_FLOAT
  int_vars[0] = (float_vars[7] == float_vars[0]);
L141: // BOOL_INT
  int_vars[0] = int_vars[0];
L142: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L150; }
L143: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L144: // EQ_FLOAT
  int_vars[0] = (float_vars[8] == float_vars[0]);
L145: // BOOL_INT
  int_vars[0] = int_vars[0];
L146: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L149; }
L147: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L148: // GOTO
  goto L149;
L149: // GOTO
  goto L150;
L150: // GOTO
  goto L151;
L151: // GOTO
  goto L152;
L152: // GOTO
  goto L153;
L153: // GOTO
  goto L154;
L154: // GOTO
  goto L155;
L155: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L156: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L157: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L158: // CONVERT_BYTE_TO_DOUBLE
  double_vars[0] = (double)byte_vars[0];
L159: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L160: // MULTIPLY_DOUBLE
  double_vars[2] = double_vars[0] * double_vars[1];
L161: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L162: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L163: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L164: // CONVERT_BYTE_TO_DOUBLE
  double_vars[1] = (double)byte_vars[0];
L165: // MULTIPLY_DOUBLE
  double_vars[3] = double_vars[0] * double_vars[1];
L166: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L167: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L168: // CONVERT_SHORT_TO_DOUBLE
  double_vars[0] = (double)short_vars[0];
L169: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L170: // MULTIPLY_DOUBLE
  double_vars[4] = double_vars[0] * double_vars[1];
L171: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L172: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L173: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L174: // CONVERT_SHORT_TO_DOUBLE
  double_vars[1] = (double)short_vars[0];
L175: // MULTIPLY_DOUBLE
  double_vars[5] = double_vars[0] * double_vars[1];
L176: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L177: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[5];
L178: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L179: // MULTIPLY_DOUBLE
  double_vars[6] = double_vars[0] * double_vars[1];
L180: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L181: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L182: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[5];
L183: // MULTIPLY_DOUBLE
  double_vars[7] = double_vars[0] * double_vars[1];
L184: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L185: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L186: // MULTIPLY_DOUBLE
  double_vars[8] = double_vars[0] * double_vars[1];
L187: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L188: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L189: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[1] = (double)float_vars[0];
L190: // MULTIPLY_DOUBLE
  double_vars[9] = double_vars[0] * double_vars[1];
L191: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L192: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L193: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L194: // MULTIPLY_DOUBLE
  double_vars[10] = double_vars[0] * double_vars[1];
L195: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L196: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L197: // BOOL_INT
  int_vars[0] = int_vars[0];
L198: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L241; }
L199: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L200: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[0]);
L201: // BOOL_INT
  int_vars[0] = int_vars[0];
L202: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L240; }
L203: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L204: // EQ_DOUBLE
  int_vars[0] = (double_vars[4] == double_vars[0]);
L205: // BOOL_INT
  int_vars[0] = int_vars[0];
L206: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L239; }
L207: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L208: // EQ_DOUBLE
  int_vars[0] = (double_vars[5] == double_vars[0]);
L209: // BOOL_INT
  int_vars[0] = int_vars[0];
L210: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L238; }
L211: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L212: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[0]);
L213: // BOOL_INT
  int_vars[0] = int_vars[0];
L214: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L237; }
L215: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L216: // EQ_DOUBLE
  int_vars[0] = (double_vars[7] == double_vars[0]);
L217: // BOOL_INT
  int_vars[0] = int_vars[0];
L218: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L236; }
L219: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.125;
L220: // EQ_DOUBLE
  int_vars[0] = (double_vars[8] == double_vars[0]);
L221: // BOOL_INT
  int_vars[0] = int_vars[0];
L222: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L235; }
L223: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.125;
L224: // EQ_DOUBLE
  int_vars[0] = (double_vars[9] == double_vars[0]);
L225: // BOOL_INT
  int_vars[0] = int_vars[0];
L226: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L234; }
L227: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.125;
L228: // EQ_DOUBLE
  int_vars[0] = (double_vars[10] == double_vars[0]);
L229: // BOOL_INT
  int_vars[0] = int_vars[0];
L230: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L233; }
L231: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L232: // GOTO
  goto L233;
L233: // GOTO
  goto L234;
L234: // GOTO
  goto L235;
L235: // GOTO
  goto L236;
L236: // GOTO
  goto L237;
L237: // GOTO
  goto L238;
L238: // GOTO
  goto L239;
L239: // GOTO
  goto L240;
L240: // GOTO
  goto L241;
L241: // BOOL_INT
  int_vars[0] = int_vars[1];
L242: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L251; }
L243: // BOOL_INT
  int_vars[0] = int_vars[3];
L244: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L248; }
L245: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L246: // BOOL_INT
  int_vars[0] = int_vars[5];
L247: // GOTO
  goto L250;
L248: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L249: // BOOL_INT
  int_vars[0] = int_vars[6];
L250: // GOTO
  goto L253;
L251: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L252: // BOOL_INT
  int_vars[0] = int_vars[7];
L253: // BOOL_INT
  int_vars[0] = int_vars[0];
L254: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L263; }
L255: // BOOL_INT
  int_vars[0] = int_vars[4];
L256: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L260; }
L257: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L258: // BOOL_INT
  int_vars[0] = int_vars[5];
L259: // GOTO
  goto L262;
L260: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L261: // BOOL_INT
  int_vars[0] = int_vars[6];
L262: // GOTO
  goto L265;
L263: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L264: // BOOL_INT
  int_vars[0] = int_vars[7];
L265: // BOOL_INT
  int_vars[0] = int_vars[0];
L266: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L270; }
L267: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L268: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L274;
L269: // GOTO
  goto L270;
L270: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L271: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L274;
L272: // INIT_INT
  int_vars[9] = 0;
L273: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L274;
L274: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_byte_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // MULTIPLY_INT
  int_vars[5] = int_vars[2] * int_vars[4];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L9: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[4];
L17: // MOVE_INT
  int_vars[0] = int_vars[0];
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[7] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L27;
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_byte_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = -6;
L5: // MULTIPLY_INT
  int_vars[4] = int_vars[2] * int_vars[3];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = -18;
L7: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[5];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L25;
L23: // INIT_INT
  int_vars[7] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_double_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.0;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L3: // MULTIPLY_DOUBLE
  double_vars[2] = double_vars[0] * double_vars[1];
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L5: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[4];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_double_double_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1000000000.5;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L3: // MULTIPLY_DOUBLE
  double_vars[2] = double_vars[0] * double_vars[1];
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 500000000.25;
L5: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[4];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_float_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L3: // MULTIPLY_FLOAT
  float_vars[2] = float_vars[0] * float_vars[1];
L4: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L5: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[4];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L4: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L5: // MULTIPLY_INT
  int_vars[4] = int_vars[1] * int_vars[3];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L7: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[5];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L25;
L23: // INIT_INT
  int_vars[7] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L4: // MULTIPLY_DOUBLE
  double_vars[2] = double_vars[0] * double_vars[1];
L5: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L6: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L13: // BOOL_INT
  int_vars[0] = int_vars[4];
L14: // MOVE_INT
  int_vars[0] = int_vars[0];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L4: // MULTIPLY_FLOAT
  float_vars[2] = float_vars[0] * float_vars[1];
L5: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L6: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L13: // BOOL_INT
  int_vars[0] = int_vars[4];
L14: // MOVE_INT
  int_vars[0] = int_vars[0];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1000000000;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L3: // MULTIPLY_INT
  int_vars[3] = int_vars[1] * int_vars[2];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 2000000000;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[5];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L23;
L21: // INIT_INT
  int_vars[7] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 536870912;
L2: // MOVE_INT
  int_vars[2] = int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MULTIPLY_INT
  int_vars[5] = int_vars[2] * int_vars[4];
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L9;
L7: // INIT_INT
  int_vars[7] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_overflow(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1073741824;
L2: // MOVE_INT
  int_vars[2] = int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MULTIPLY_INT
  int_vars[5] = int_vars[2] * int_vars[4];
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L9;
L7: // INIT_INT
  int_vars[7] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 536870912;
L2: // MOVE_INT
  int_vars[2] = int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MULTIPLY_INT
  int_vars[5] = int_vars[2] * int_vars[4];
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L9;
L7: // INIT_INT
  int_vars[7] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_int_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 7;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L4: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L5: // MULTIPLY_INT
  int_vars[4] = int_vars[1] * int_vars[3];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L7: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[5];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L25;
L23: // INIT_INT
  int_vars[7] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_long_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 2000000000LL;
L2: // MOVE_CONSTANT_LONG
  long_vars[1] = 2LL;
L3: // MULTIPLY_LONG
  long_vars[2] = long_vars[0] * long_vars[1];
L4: // MOVE_CONSTANT_LONG
  long_vars[0] = 4000000000LL;
L5: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[4];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_long_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[6];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 2305843009213693952LL;
L2: // MOVE_LONG
  long_vars[1] = long_vars[0];
L3: // MOVE_CONSTANT_LONG
  long_vars[2] = -2LL;
L4: // MOVE_LONG
  long_vars[3] = long_vars[2];
L5: // MULTIPLY_LONG
  long_vars[4] = long_vars[1] * long_vars[3];
L6: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[4];
  goto L9;
L7: // INIT_LONG
  long_vars[5] = 0;
L8: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[5];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_long_overflow(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[6];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 4611686018427387904LL;
L2: // MOVE_LONG
  long_vars[1] = long_vars[0];
L3: // MOVE_CONSTANT_LONG
  long_vars[2] = 2LL;
L4: // MOVE_LONG
  long_vars[3] = long_vars[2];
L5: // MULTIPLY_LONG
  long_vars[4] = long_vars[1] * long_vars[3];
L6: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[4];
  goto L9;
L7: // INIT_LONG
  long_vars[5] = 0;
L8: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[5];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_long_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[6];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 2305843009213693952LL;
L2: // MOVE_LONG
  long_vars[1] = long_vars[0];
L3: // MOVE_CONSTANT_LONG
  long_vars[2] = 2LL;
L4: // MOVE_LONG
  long_vars[3] = long_vars[2];
L5: // MULTIPLY_LONG
  long_vars[4] = long_vars[1] * long_vars[3];
L6: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[4];
  goto L9;
L7: // INIT_LONG
  long_vars[5] = 0;
L8: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[5];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_short_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L5: // MULTIPLY_INT
  int_vars[4] = int_vars[2] * int_vars[3];
L6: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L7: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[5];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L25;
L23: // INIT_INT
  int_vars[7] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Multiply__multiply_short_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // MULTIPLY_INT
  int_vars[5] = int_vars[2] * int_vars[4];
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L9: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[4];
L17: // MOVE_INT
  int_vars[0] = int_vars[0];
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[7] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L27;
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


