#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_TestCase__Minimal__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Minimal__x = -1;
static int32_t FIELD_ID_TestCase__Minimal__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Minimal__y = -1;
// Sub id declarations
// Basic type id declarations
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
// Function Declarations
// [SIG]int(self)
int32_t SPPRECOMPILE__TestCase__Minimal__get_x(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Minimal()
int32_t SPPRECOMPILE__TestCase__Minimal__new(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Minimal(int,int)
int32_t SPPRECOMPILE__TestCase__Minimal__newp(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]string(self)
int32_t SPPRECOMPILE__TestCase__Minimal__to_string(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Minimal__get_x(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[1] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Minimal";
    const char* sub_name = "get_x";
    const char* file = "TestCase/Minimal.spvm";
    int32_t line = 6;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L7;
  }
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L7;
L5: // INIT_INT
  int_vars[3] = 0;
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Minimal__new(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L7;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L6: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Minimal__newp(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  int_vars[1] = *(int32_t*)&stack[0];
  int_vars[2] = *(int32_t*)&stack[1];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[1];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Minimal";
    const char* sub_name = "newp";
    const char* file = "TestCase/Minimal.spvm";
    int32_t line = 16;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L11;
  }
L5: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__y < 0, 0)) {
      FIELD_ID_TestCase__Minimal__y = env->get_field_id(env, "TestCase::Minimal", "y", "int");
      if (FIELD_ID_TestCase__Minimal__y < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal y");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__y = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__y);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__y) = int_vars[2];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Minimal";
    const char* sub_name = "newp";
    const char* file = "TestCase/Minimal.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L11;
  }
L7: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L11;
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L11;
L11: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L12: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Minimal__to_string(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[10] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[12];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x28", 1));
L4: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[1] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Minimal";
    const char* sub_name = "to_string";
    const char* file = "TestCase/Minimal.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L7: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[1]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string);
  }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L9: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[2];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Minimal";
    const char* sub_name = "to_string";
    const char* file = "TestCase/Minimal.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L12: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x2C", 1));
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L14: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Minimal";
    const char* sub_name = "to_string";
    const char* file = "TestCase/Minimal.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L16: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__y < 0, 0)) {
      FIELD_ID_TestCase__Minimal__y = env->get_field_id(env, "TestCase::Minimal", "y", "int");
      if (FIELD_ID_TestCase__Minimal__y < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal y");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__y = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__y);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__y);
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Minimal";
    const char* sub_name = "to_string";
    const char* file = "TestCase/Minimal.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L19: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string);
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L21: // CONCAT
  {
    void* string1 = object_vars[5];
    void* string2 = object_vars[6];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string3);
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Minimal";
    const char* sub_name = "to_string";
    const char* file = "TestCase/Minimal.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L24: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->new_string_len_raw(env, "\x29", 1));
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L26: // CONCAT
  {
    void* string1 = object_vars[7];
    void* string2 = object_vars[8];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], string3);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Minimal";
    const char* sub_name = "to_string";
    const char* file = "TestCase/Minimal.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L40;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L30: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L32: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L33: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L35: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L36: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[9];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L40;
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L38: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L39: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L40;
L40: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L41: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}


