
package Paws::PersonalizeEvents::PutEvents;
  use Moose;
  has EventList => (is => 'ro', isa => 'ArrayRef[Paws::PersonalizeEvents::Event]', traits => ['NameInRequest'], request_name => 'eventList', required => 1);
  has SessionId => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'sessionId', required => 1);
  has TrackingId => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'trackingId', required => 1);
  has UserId => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'userId');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'PutEvents');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/events');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'POST');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::API::Response');
1;

### main pod documentation begin ###

=head1 NAME

Paws::PersonalizeEvents::PutEvents - Arguments for method PutEvents on L<Paws::PersonalizeEvents>

=head1 DESCRIPTION

This class represents the parameters used for calling the method PutEvents on the
L<Amazon Personalize Events|Paws::PersonalizeEvents> service. Use the attributes of this class
as arguments to method PutEvents.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to PutEvents.

=head1 SYNOPSIS

    my $personalize-events = Paws->service('PersonalizeEvents');
    $personalize -events->PutEvents(
      EventList => [
        {
          EventType  => 'MyStringType',             # min: 1, max: 256
          Properties => 'MyEventPropertiesJSON',    # min: 1, max: 1024
          SentAt     => '1970-01-01T01:00:00',
          EventId    => 'MyStringType',             # min: 1, max: 256
        },
        ...
      ],
      SessionId  => 'MyStringType',
      TrackingId => 'MyStringType',
      UserId     => 'MyUserId',                     # OPTIONAL
    );

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/personalize-events/PutEvents>

=head1 ATTRIBUTES


=head2 B<REQUIRED> EventList => ArrayRef[L<Paws::PersonalizeEvents::Event>]

A list of event data from the session.



=head2 B<REQUIRED> SessionId => Str

The session ID associated with the user's visit.



=head2 B<REQUIRED> TrackingId => Str

The tracking ID for the event. The ID is generated by a call to the
CreateEventTracker
(https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html)
API.



=head2 UserId => Str

The user associated with the event.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method PutEvents in L<Paws::PersonalizeEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

