package Paws::AlexaForBusiness::DeviceNetworkProfileInfo;
  use Moose;
  has CertificateArn => (is => 'ro', isa => 'Str');
  has CertificateExpirationTime => (is => 'ro', isa => 'Str');
  has NetworkProfileArn => (is => 'ro', isa => 'Str');
1;

### main pod documentation begin ###

=head1 NAME

Paws::AlexaForBusiness::DeviceNetworkProfileInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AlexaForBusiness::DeviceNetworkProfileInfo object:

  $service_obj->Method(Att1 => { CertificateArn => $value, ..., NetworkProfileArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AlexaForBusiness::DeviceNetworkProfileInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->CertificateArn

=head1 DESCRIPTION

Detailed information about a device's network profile.

=head1 ATTRIBUTES


=head2 CertificateArn => Str

  The ARN of the certificate associated with a device.


=head2 CertificateExpirationTime => Str

  The time (in epoch) when the certificate expires.


=head2 NetworkProfileArn => Str

  The ARN of the network profile associated with a device.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AlexaForBusiness>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

