package PerlPowerTools;

our $VERSION = '1.019_01';

1;

=encoding utf8

=head1 NAME

PerlPowerTools - BSD utilities written in pure Perl

=head1 SYNOPSIS

Install the commands and use them just as you would the normal
BSD utilities.

=head1 DESCRIPTION

The Unix Reconstruction Project. By default, these install into the
F<~/perlpowertools> directory. You'll probably need to add that directory
to C<PATH> to use them. You can install them anywhere you like by
setting C<INSTALL_BASE> when you run F<Makefile.PL>.

=head2 Utilities

=over 4

=item addbib - create or extend a bibliographic database

=item apply - Run a command many times with different arguments

=item ar - create and maintain library archives

=item arch - display system machine type

=item arithmetic - improve your arithmetic skills

=item asa - interpret ASA/FORTRAN carriage-controls

=item awk - pattern-directed scanning and processing language

=item banner - print large banner on printer

=item basename -- print the basename of a file

=item bc - An arbitrary precision calculator language

=item cal - display a calendar

=item cat - concatenate and print files.

=item chgrp - change group ownership of files

=item ching - the Book of Changes

=item chmod - change permissions of files.

=item chown - change ownership of files.

=item clear - clear the screen

=item cmp - compare two files

=item col - filter reverse line feeds from input

=item colrm - remove columns from a file

=item comm - select or reject lines common to two files

=item cp - copy files and/or directories

=item cut - select portions of each line of a file

=item date - display or set date and time

=item dc - an arbitrary precision calculator

=item deroff - strip troff, eqn and tbl sequences from text

=item diff - Compute `intelligent' differences between two files / lists

=item dirname - print the directory name of a path

=item du - display disk usage statistics

=item echo - echo arguments

=item ed - text editor

=item env - Run a program in a modified environment

=item expand, unexpand - expand tabs to spaces, and vice versa

=item expr - evaluate expression

=item factor - factor a number

=item false - Exit unsuccesfully

=item file - determine file type

=item find - search directory tree for files matching a pattern

=item fish - plays the children's game of Go Fish

=item fold - wrap each input line to fit specified width

=item fortune - print a random, hopefully interesting, adage

=item from - print names of those who have sent mail

=item glob - 100% Perl implementation of (t)csh "globbing"

=item grep - search for regular expressions and print

=item hangman - perl version of the game hangman

=item head - print the first lines of a file

=item id - show user information

=item install - install files and directories

=item join - relational database operator

=item kill - send signals to a process

=item ln - create links

=item lock - reserves a terminal

=item look - find lines in a sorted list

=item ls - list file/directory information

=item mail - implementation of Berkeley mail(1)

=item pmake - a perl 'make' replacement

=item man - format and display the on-line manual page

=item maze - generate a maze problem

=item mimedecode - extract MIME attachments in uudecode-like manner

=item mkdir - create directories

=item mkfifo - make named pipes

=item moo - play a game of MOO

=item demorse - read morse and translate it to text

=item od - dump files in octal and other formats

=item par - create a Perl archive of files

=item paste - merge corresponding or subsequent lines of files

=item patch - apply a diff file to an original

=item pig - eformatray inputway asway Igpay Atinlay

=item ping - probe for network hosts

=item pom - display the phase of the moon

=item ppt - reformat input as paper tape

=item pr - convert text files for printing

=item primes - generate primes

=item printenv - Display the environment

=item printf - format and print data

=item pwd - working directory name

=item rain - Let it rain.

=item random - display lines at random, or exit with a random value

=item rev - reverse lines of a file

=item rm - remove directory entries

=item rmdir - remove directories

=item robots - fight off villainous robots

=item shar - create a shell archive of files

=item sleep - suspend execution for a number of seconds

=item sort - sort or merge text files

=item spell - scan a file for misspelled words

=item split - split a file into pieces

=item strings - extract strings

=item sum - display file checksums and block counts

=item tac - concatenate and print files in reverse

=item tail - display the last part of a file

=item tar - manipulate tape archives

=item tee - pipe fitting

=item test - condition evaluation utility

=item time - times the execution of a command

=item touch - change access and modification times of files

=item tr - translate or delete characters

=item true - Exit succesfully

=item tcsort - topological sort

=item tty - return user's terminal name

=item uname - print system information

=item expand, unexpand - expand tabs to spaces, and vice versa

=item uniq - report or filter out repeated lines in a file

=item units - conversion program

=item unpar - extract files from a Perl archive

=item unshar - extract files from a shell archive

=item uudecode, uuencode - encode/decode a binary file

=item uudecode, uuencode - encode/decode a binary file

=item wc - paragraph, line, word, character, and byte counter

=item what - extract version information from a file

=item which - report full paths of commands.

=item whois - Internet domain name and network number directory service

=item words - find words which can be made from a string of letters

=item wump - Perl port of the "Hunt the Wumpus" game

=item xargs - construct argument list(s) and execute utility

=item yes - print out a string till doomsday


=back

=head1 SOURCE AVAILABILITY

This source is in Github:

	https://github.com/briandfoy/PerlPowerTools

=head1 AUTHOR

brian d foy, C<< <bdfoy@cpan.org> >> is the current maintainer, even
though he wrote none of the utilities.

=head1 COPYRIGHT AND LICENSE

Copyright (c) 2004-2020 by various authors. See each program for
specific information.

This program is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut




__END__
