package Sah::SchemaR::isbn;

our $DATE = '2019-11-29'; # DATE
our $VERSION = '0.007'; # VERSION

our $rschema = ["str",[{description=>"\nNondigits [^0-9Xx] will be removed during coercion.\n\nChecksum digit must be valid.\n\n",match=>"\\A(?:[0-9]{13}|[0-9]{9}[0-9Xx])\\z",summary=>"ISBN 10 or ISBN 13 number","x.perl.coerce_rules"=>["From_str::to_isbn"]}],["str"]];

1;
# ABSTRACT: ISBN 10 or ISBN 13 number

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::isbn - ISBN 10 or ISBN 13 number

=head1 VERSION

This document describes version 0.007 of Sah::SchemaR::isbn (from Perl distribution Sah-Schemas-ISBN), released on 2019-11-29.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-ISBN>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-ISBN>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-ISBN>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2019, 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
