use PDLA::Doc;
use Getopt::Std;
use Config;
use Cwd;

require PDLA; # always needed to pick up PDLA::VERSION

$opt_v = 0;

getopts('v');
$dirarg = shift @ARGV;
$outdb  = shift @ARGV;
$outindex  = shift @ARGV;

unless (defined $dirarg) {
	($dirarg = $INC{'PDLA.pm'}) =~ s/PDLA\.pm$//i;
	umask 0022;
	print "DIR = $dirarg\n";
}
my @dirs = split /,/,$dirarg;
unless (defined $outdb) {
	$outdb = "$dirs[0]/PDLA/pdldoc.db";
	print "DB  = $outdb\n";
}

$currdir = getcwd;

unlink $outdb if -e $outdb;
$onldc = new PDLA::Doc();
$onldc->outfile($outdb);

foreach $dir (@dirs) {
    chdir $dir or die "can't change to $dir";
    $dir = getcwd;

    $onldc->scantree($dir."/PDLA",$opt_v);
    $onldc->scan($dir."/PDLA.pm",$opt_v) if (-s $dir."/PDLA.pm");
    chdir $currdir;
}

print STDERR "saving...\n";
$onldc->savedb();
@mods = $onldc->search('module:',['Ref'],1);
@mans = $onldc->search('manual:',['Ref'],1);
@scripts = $onldc->search('script:',['Ref'],1);
$outdir = "$dirs[0]/PDLA";
# ($outdir = $INC{'PDLA.pm'}) =~ s/\.pm$//i;
$outindex="$outdir/Index.pod" unless (defined $outindex);
unlink $outindex if -e $outindex;  # Handle read only file
open POD, ">$outindex"
  or die "couldn't open $outindex";
print POD <<'EOPOD';

=head1 NAME

PDLA::Index - an index of PDLA documentation

=head1 DESCRIPTION

A meta document listing the documented PDLA modules and
the PDLA manual documents

=head1 PDLA manuals

EOPOD

#print POD "=over ",$#mans+1,"\n\n";
print POD "=over 4\n\n";
for (@mans) {
  my $ref = $_->[1]->{Ref};
  $ref =~ s/Manual:/L<$_->[0]|$_->[0]> -/;
##  print POD "=item L<$_->[0]>\n\n$ref\n\n";
#  print POD "=item $_->[0]\n\n$ref\n\n";
  print POD "=item *\n\n$ref\n\n";
}

print POD << 'EOPOD';

=back

=head1 PDLA scripts

EOPOD

#print POD "=over ",$#mods+1,"\n\n";
print POD "=over 4\n\n";
for (@scripts) {
  my $ref = $_->[1]->{Ref};
  $ref =~ s/Script:/L<$_->[0]|PDLA::$_->[0]> -/;
##  print POD "=item L<$_->[0]>\n\n$ref\n\n";
#  print POD "=item $_->[0]\n\n$ref\n\n";
  print POD "=item *\n\n$ref\n\n";
}

print POD << 'EOPOD';

=back

=head1 PDLA modules

EOPOD

#print POD "=over ",$#mods+1,"\n\n";
print POD "=over 4\n\n";
for (@mods) {
  my $ref = $_->[1]->{Ref};
  next unless $_->[0] =~ /^PDLA/;
  if( $_->[0] eq 'PDLA'){ # special case needed to find the main PDLA.pm file.
	  $ref =~ s/Module:/L<PDLA::PDLA|PDLA::PDLA> -/;
##	  print POD "=item L<PDLA::PDLA>\n\n$ref\n\n";
#	  print POD "=item PDLA::PDLA\n\n$ref\n\n";
	  print POD "=item *\n\n$ref\n\n";
	  next;
  }
  $ref =~ s/Module:/L<$_->[0]|$_->[0]> -/;
##  print POD "=item L<$_->[0]>\n\n$ref\n\n";
#  print POD "=item $_->[0]\n\n$ref\n\n";
  print POD "=item *\n\n$ref\n\n";
}

print POD << "EOPOD";

=back

=head1 HISTORY

Automatically generated by scantree.pl for PDLA version $PDLA::VERSION.

EOPOD

close POD;


