package Graphics::ColorNamesLite::EN;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-12-01'; # DATE
our $DIST = 'Graphics-ColorNamesLite-EN'; # DIST
our $VERSION = '0.003'; # VERSION

# note: SVG=CSS, WWW=CSS. GrayScale returns coderef. Pantone are numbers.
our $NAMES_RGB_TABLE = {
  "aab"                     => "0066ff",
  "aac"                     => "0099ff",
  "airyblue"                => "92b6d5",
  "aliceblue"               => "f0f8ff",
  "almondbuff"              => "d1b894",
  "almostmauve"             => "eadedb",
  "amazon"                  => "1c734b",
  "amberglow"               => "dc793e",
  "amethystorchid"          => "926aa6",
  "antiquewhite"            => "faebd7",
  "antiquewhite1"           => "ffefdb",
  "antiquewhite2"           => "eedfcc",
  "antiquewhite3"           => "cdc0b0",
  "antiquewhite4"           => "8b8378",
  "applegreen"              => "adba98",
  "apricot"                 => "f7ca83",
  "aqua"                    => "00ffff",
  "aquamarine"              => "7fffd4",
  "aquamarine1"             => "7fffd4",
  "aquamarine2"             => "76eec6",
  "aquamarine3"             => "66cdaa",
  "aquamarine4"             => "458b74",
  "aquasky"                 => "7fcdcd",
  "arcadia"                 => "00a591",
  "arcticwolf"              => "e6decf",
  "arterialbloodred"        => 711518,
  "ash"                     => "a09998",
  "ashgrey"                 => "cbc8b7",
  "asparagusgreen"          => "c2c190",
  "aspengold"               => "ffd662",
  "auriculapurple"          => 533552,
  "aurorared"               => "b93a32",
  "autumnblonde"            => "f2d6b3",
  "autumnmaple"             => "d2691e",
  "azure"                   => "f0ffff",
  "azure-azure-blue"        => "0066ff",
  "azure-azure-cyan"        => "0099ff",
  "azure1"                  => "f0ffff",
  "azure2"                  => "e0eeee",
  "azure3"                  => "c1cdcd",
  "azure4"                  => "838b8b",
  "azureazureblue"          => "0066ff",
  "azureazurecyan"          => "0099ff",
  "azureblue"               => "5c6b8f",
  "b"                       => "0000ff",
  "bakerschocolate"         => "5c3317",
  "balletslipper"           => "f3d6e4",
  "basil"                   => "829f82",
  "bba"                     => "0033ff",
  "bbv"                     => "3300ff",
  "beige"                   => "f5f5dc",
  "berlinblue"              => "7994b5",
  "bikingred"               => "77212e",
  "biscaygreen"             => "56c6a9",
  "bisque"                  => "ffe4c4",
  "bisque1"                 => "ffe4c4",
  "bisque2"                 => "eed5b7",
  "bisque3"                 => "cdb79e",
  "bisque4"                 => "8b7d6b",
  "black"                   => "000000",
  "blackishbrown"           => "453b32",
  "blackishgreen"           => "5d6161",
  "blackishgrey"            => "5b5c61",
  "blanchedalmond"          => "ffebcd",
  "bloomingdahlia"          => "ec9787",
  "blue"                    => "0000ff",
  "blue-blue-azure"         => "0033ff",
  "blue-blue-violet"        => "3300ff",
  "blue1"                   => "0000ff",
  "blue2"                   => "0000ee",
  "blue3"                   => "0000cd",
  "blue4"                   => "00008b",
  "blueblueazure"           => "0033ff",
  "blueblueviolet"          => "3300ff",
  "bluegreen"               => "0083ae",
  "bluegrey"                => "b2bbc0",
  "blueizis"                => "5b5ea6",
  "bluestone"               => 577284,
  "blueturquoise"           => "55b4b0",
  "blueviolet"              => "8a2be2",
  "bluishblack"             => "413f44",
  "bluishgreen"             => "a4b6a7",
  "bluishgrey"              => "9c9d9a",
  "bluishlilacpurple"       => "d0d5d3",
  "bluishpurple"            => "8590ae",
  "bodacious"               => "b76ba3",
  "brass"                   => "b5a642",
  "brightgold"              => "d9d919",
  "brilliantwhite"          => "edf1ff",
  "broccolibrown"           => "9b856b",
  "bronze"                  => "8c7853",
  "bronzeii"                => "a67d3d",
  "brown"                   => "a52a2a",
  "brown1"                  => "ff4040",
  "brown2"                  => "ee3b3b",
  "brown3"                  => "cd3333",
  "brown4"                  => "8b2323",
  "browngranite"            => 615550,
  "brownishorange"          => "92462f",
  "brownishpurplered"       => "8d746f",
  "brownishred"             => "6e3b31",
  "bufforange"              => "ebbc71",
  "burlywood"               => "deb887",
  "burlywood1"              => "ffd39b",
  "burlywood2"              => "eec591",
  "burlywood3"              => "cdaa7d",
  "burlywood4"              => "8b7355",
  "burntcoral"              => "e9897e",
  "burntsienna"             => "bd6638",
  "buttercream"             => "efe1ce",
  "buttercup"               => "fae03c",
  "butterum"                => "c48f65",
  "c"                       => "00ffff",
  "cadetblue"               => "5f9ea0",
  "cadetblue1"              => "98f5ff",
  "cadetblue2"              => "8ee5ee",
  "cadetblue3"              => "7ac5cd",
  "cadetblue4"              => "53868b",
  "campanulapurple"         => "6c6d94",
  "caramelcafe"             => "8b5a3e",
  "carminered"              => "ce536b",
  "carnationpink"           => "fa7fc1",
  "cca"                     => "00ccff",
  "cct"                     => "00ffcc",
  "celadinegreen"           => "b8bfaf",
  "cerulean"                => "9bb7d4",
  "ceruleanblue"            => "98b4d4",
  "cerulian"                => "0071cd",
  "ceylonyellow"            => "d5ae41",
  "chartreuse"              => "7fff00",
  "chartreuse1"             => "7fff00",
  "chartreuse2"             => "76ee00",
  "chartreuse3"             => "66cd00",
  "chartreuse4"             => "458b00",
  "cherrytomato"            => "e94b3c",
  "chestnut"                => 954535,
  "chestnutbrown"           => "7a4b3a",
  "chilioil"                => 944743,
  "chilipepper"             => "9b2335",
  "chinablue"               => 383867,
  "chiseledstone"           => "8f8f93",
  "chive"                   => "4b5335",
  "chocolate"               => "d2691e",
  "chocolate1"              => "ff7f24",
  "chocolate2"              => "ee7621",
  "chocolate3"              => "cd661d",
  "chocolate4"              => "8b4513",
  "chocolatered"            => "4d3635",
  "cinnamonstic"            => "9c4722",
  "classicblue"             => "34568b",
  "clovebrown"              => 766051,
  "cobalt"                  => "3d414c",
  "cocamocha"               => "8c725f",
  "cochinealred"            => "7a4848",
  "coconutmilk"             => "f0ede5",
  "coolcopper"              => "d98719",
  "copper"                  => "b87333",
  "coral"                   => "ff7f50",
  "coral1"                  => "ff7256",
  "coral2"                  => "ee6a50",
  "coral3"                  => "cd5b45",
  "coral4"                  => "8b3e2f",
  "coralpink"               => "e8a798",
  "cornflower"              => "6590d8",
  "cornflowerblue"          => "6495ed",
  "cornsilk"                => "fff8dc",
  "cornsilk1"               => "fff8dc",
  "cornsilk2"               => "eee8cd",
  "cornsilk3"               => "cdc8b1",
  "cornsilk4"               => "8b8878",
  "creamyellow"             => "f3daa7",
  "cremedepeche"            => "f5d6c6",
  "crimson"                 => "dc143c",
  "crimsonred"              => "b7757c",
  "crocuspetal"             => "be9ec9",
  "cyan"                    => "00ffff",
  "cyan-cyan-azure"         => "00ccff",
  "cyan-cyan-teal"          => "00ffcc",
  "cyan1"                   => "00ffff",
  "cyan2"                   => "00eeee",
  "cyan3"                   => "00cdcd",
  "cyan4"                   => "008b8b",
  "cyancyanazure"           => "00ccff",
  "cyancyanteal"            => "00ffcc",
  "dab"                     => "003399",
  "dac"                     => "006699",
  "daffodil"                => "fdc04e",
  "dahliamauve"             => "a64f82",
  "dandelion"               => "edd80b",
  "dark azure-blue"         => "003399",
  "dark azure-cyan"         => "006699",
  "dark blue-azure"         => "0033cc",
  "dark blue-violet"        => "3300cc",
  "dark cyan-azure"         => "0099cc",
  "dark cyan-teal"          => "00cc99",
  "dark dull azure"         => 336699,
  "dark dull blue"          => 333399,
  "dark dull cyan"          => 339999,
  "dark dull green"         => 339933,
  "dark dull magenta"       => 993399,
  "dark dull orange"        => 996633,
  "dark dull pink"          => 993366,
  "dark dull red"           => 993333,
  "dark dull spring"        => 669933,
  "dark dull teal"          => 339966,
  "dark dull violet"        => 663399,
  "dark dull yellow"        => 999933,
  "dark faded blue"         => "000099",
  "dark faded cyan"         => "009999",
  "dark faded green"        => "009900",
  "dark faded magenta"      => 990099,
  "dark faded red"          => 990000,
  "dark faded yellow"       => 999900,
  "dark gray"               => 666666,
  "dark green-spring"       => "33cc00",
  "dark green-teal"         => "00cc33",
  "dark hard azure"         => "0066cc",
  "dark hard blue"          => "0000cc",
  "dark hard cyan"          => "00cccc",
  "dark hard green"         => "00cc00",
  "dark hard magenta"       => "cc00cc",
  "dark hard orange"        => "cc6600",
  "dark hard pink"          => "cc0066",
  "dark hard red"           => "cc0000",
  "dark hard spring"        => "66cc00",
  "dark hard teal"          => "00cc66",
  "dark hard violet"        => "6600cc",
  "dark hard yellow"        => "cccc00",
  "dark magenta-pink"       => "cc0099",
  "dark magenta-violet"     => "9900cc",
  "dark orange-red"         => 993300,
  "dark orange-yellow"      => 996600,
  "dark pink-magenta"       => 990066,
  "dark pink-red"           => 990033,
  "dark red-orange"         => "cc3300",
  "dark red-pink"           => "cc0033",
  "dark spring-green"       => 339900,
  "dark spring-yellow"      => 669900,
  "dark teal-cyan"          => "009966",
  "dark teal-green"         => "009933",
  "dark violet-blue"        => 330099,
  "dark violet-magenta"     => 660099,
  "dark weak blue"          => 333366,
  "dark weak cyan"          => 336666,
  "dark weak green"         => 336633,
  "dark weak magenta"       => 663366,
  "dark weak red"           => 663333,
  "dark weak yellow"        => 666633,
  "dark yellow-orange"      => "cc9900",
  "dark yellow-spring"      => "99cc00",
  "darkazure-blue"          => "003399",
  "darkazure-cyan"          => "006699",
  "darkazureblue"           => "003399",
  "darkazurecyan"           => "006699",
  "darkblue"                => "00008b",
  "darkblue-azure"          => "0033cc",
  "darkblue-violet"         => "3300cc",
  "darkblueazure"           => "0033cc",
  "darkblueviolet"          => "3300cc",
  "darkbrown"               => "5c4033",
  "darkcheddar"             => "e08119",
  "darkcyan"                => "008b8b",
  "darkcyan-azure"          => "0099cc",
  "darkcyan-teal"           => "00cc99",
  "darkcyanazure"           => "0099cc",
  "darkcyanteal"            => "00cc99",
  "darkdullazure"           => 336699,
  "darkdullblue"            => 333399,
  "darkdullcyan"            => 339999,
  "darkdullgreen"           => 339933,
  "darkdullmagenta"         => 993399,
  "darkdullorange"          => 996633,
  "darkdullpink"            => 993366,
  "darkdullred"             => 993333,
  "darkdullspring"          => 669933,
  "darkdullteal"            => 339966,
  "darkdullviolet"          => 663399,
  "darkdullyellow"          => 999933,
  "darkfadedblue"           => "000099",
  "darkfadedcyan"           => "009999",
  "darkfadedgreen"          => "009900",
  "darkfadedmagenta"        => 990099,
  "darkfadedred"            => 990000,
  "darkfadedyellow"         => 999900,
  "darkgoldenrod"           => "b8860b",
  "darkgoldenrod1"          => "ffb90f",
  "darkgoldenrod2"          => "eead0e",
  "darkgoldenrod3"          => "cd950c",
  "darkgoldenrod4"          => "8b6508",
  "darkgray"                => "a9a9a9",
  "darkgreen"               => "006400",
  "darkgreen-spring"        => "33cc00",
  "darkgreen-teal"          => "00cc33",
  "darkgreencopper"         => "4a766e",
  "darkgreenspring"         => "33cc00",
  "darkgreenteal"           => "00cc33",
  "darkgrey"                => "a9a9a9",
  "darkhardazure"           => "0066cc",
  "darkhardblue"            => "0000cc",
  "darkhardcyan"            => "00cccc",
  "darkhardgreen"           => "00cc00",
  "darkhardmagenta"         => "cc00cc",
  "darkhardorange"          => "cc6600",
  "darkhardpink"            => "cc0066",
  "darkhardred"             => "cc0000",
  "darkhardspring"          => "66cc00",
  "darkhardteal"            => "00cc66",
  "darkhardviolet"          => "6600cc",
  "darkhardyellow"          => "cccc00",
  "darkkhaki"               => "bdb76b",
  "darkmagenta"             => "8b008b",
  "darkmagenta-pink"        => "cc0099",
  "darkmagenta-violet"      => "9900cc",
  "darkmagentapink"         => "cc0099",
  "darkmagentaviolet"       => "9900cc",
  "darkolivegreen"          => "556b2f",
  "darkolivegreen1"         => "caff70",
  "darkolivegreen2"         => "bcee68",
  "darkolivegreen3"         => "a2cd5a",
  "darkolivegreen4"         => "6e8b3d",
  "darkorange"              => "ff8c00",
  "darkorange-red"          => 993300,
  "darkorange-yellow"       => 996600,
  "darkorange1"             => "ff7f00",
  "darkorange2"             => "ee7600",
  "darkorange3"             => "cd6600",
  "darkorange4"             => "8b4500",
  "darkorangered"           => 993300,
  "darkorangeyellow"        => 996600,
  "darkorchid"              => "9932cc",
  "darkorchid1"             => "bf3eff",
  "darkorchid2"             => "b23aee",
  "darkorchid3"             => "9a32cd",
  "darkorchid4"             => "68228b",
  "darkpink-magenta"        => 990066,
  "darkpink-red"            => 990033,
  "darkpinkmagenta"         => 990066,
  "darkpinkred"             => 990033,
  "darkpurple"              => "871f78",
  "darkred"                 => "8b0000",
  "darkred-orange"          => "cc3300",
  "darkred-pink"            => "cc0033",
  "darkredorange"           => "cc3300",
  "darkredpink"             => "cc0033",
  "darksalmon"              => "e9967a",
  "darkseagreen"            => "8fbc8f",
  "darkseagreen1"           => "c1ffc1",
  "darkseagreen2"           => "b4eeb4",
  "darkseagreen3"           => "9bcd9b",
  "darkseagreen4"           => "698b69",
  "darkslateblue"           => "483d8b",
  "darkslategray"           => "2f4f4f",
  "darkslategray1"          => "97ffff",
  "darkslategray2"          => "8deeee",
  "darkslategray3"          => "79cdcd",
  "darkslategray4"          => "528b8b",
  "darkslategrey"           => "2f4f4f",
  "darkspring-green"        => 339900,
  "darkspring-yellow"       => 669900,
  "darkspringgreen"         => 339900,
  "darkspringyellow"        => 669900,
  "darktan"                 => "97694f",
  "darkteal-cyan"           => "009966",
  "darkteal-green"          => "009933",
  "darktealcyan"            => "009966",
  "darktealgreen"           => "009933",
  "darkturquoise"           => "00ced1",
  "darkviolet"              => "9400d3",
  "darkviolet-blue"         => 330099,
  "darkviolet-magenta"      => 660099,
  "darkvioletblue"          => 330099,
  "darkvioletmagenta"       => 660099,
  "darkweakblue"            => 333366,
  "darkweakcyan"            => 336666,
  "darkweakgreen"           => 336633,
  "darkweakmagenta"         => 663366,
  "darkweakred"             => 663333,
  "darkweakyellow"          => 666633,
  "darkwood"                => "855e42",
  "darkyellow"              => 808000,
  "darkyellow-orange"       => "cc9900",
  "darkyellow-spring"       => "99cc00",
  "darkyelloworange"        => "cc9900",
  "darkyellowspring"        => "99cc00",
  "dba"                     => "0033cc",
  "dbv"                     => "3300cc",
  "dca"                     => "0099cc",
  "dct"                     => "00cc99",
  "dda"                     => 336699,
  "ddb"                     => 333399,
  "ddc"                     => 339999,
  "ddg"                     => 339933,
  "ddm"                     => 993399,
  "ddo"                     => 996633,
  "ddp"                     => 993366,
  "ddr"                     => 993333,
  "dds"                     => 669933,
  "ddt"                     => 339966,
  "ddv"                     => 663399,
  "ddy"                     => 999933,
  "deeporangecolouredbrown" => 864735,
  "deeppink"                => "ff1493",
  "deeppink1"               => "ff1493",
  "deeppink2"               => "ee1289",
  "deeppink3"               => "cd1076",
  "deeppink4"               => "8b0a50",
  "deepreddishbrown"        => "553d3a",
  "deepreddishorange"       => "bb603c",
  "deepskyblue"             => "00bfff",
  "deepskyblue1"            => "00bfff",
  "deepskyblue2"            => "00b2ee",
  "deepskyblue3"            => "009acd",
  "deepskyblue4"            => "00688b",
  "desertmist"              => "e0b589",
  "dfb"                     => "000099",
  "dfc"                     => "009999",
  "dfg"                     => "009900",
  "dfm"                     => 990099,
  "dfr"                     => 990000,
  "dfy"                     => 999900,
  "dg"                      => 666666,
  "dgs"                     => "33cc00",
  "dgt"                     => "00cc33",
  "dha"                     => "0066cc",
  "dhb"                     => "0000cc",
  "dhc"                     => "00cccc",
  "dhg"                     => "00cc00",
  "dhm"                     => "cc00cc",
  "dho"                     => "cc6600",
  "dhp"                     => "cc0066",
  "dhr"                     => "cc0000",
  "dhs"                     => "66cc00",
  "dht"                     => "00cc66",
  "dhv"                     => "6600cc",
  "dhy"                     => "cccc00",
  "dimgray"                 => 696969,
  "dimgrey"                 => 696969,
  "dmp"                     => "cc0099",
  "dmv"                     => "9900cc",
  "dodgerblue"              => "1e90ff",
  "dodgerblue1"             => "1e90ff",
  "dodgerblue2"             => "1c86ee",
  "dodgerblue3"             => "1874cd",
  "dodgerblue4"             => "104e8b",
  "dor"                     => 993300,
  "doy"                     => 996600,
  "dpm"                     => 990066,
  "dpr"                     => 990033,
  "dro"                     => "cc3300",
  "drp"                     => "cc0033",
  "dsg"                     => 339900,
  "dsy"                     => 669900,
  "dtc"                     => "009966",
  "dtg"                     => "009933",
  "duckgreen"               => "33431e",
  "dustycedar"              => "ad5d5d",
  "dustyrose"               => 856363,
  "dutchorange"             => "dfa837",
  "dvb"                     => 330099,
  "dvm"                     => 660099,
  "dwb"                     => 333366,
  "dwc"                     => 336666,
  "dwg"                     => 336633,
  "dwm"                     => 663366,
  "dwr"                     => 663333,
  "dwy"                     => 666633,
  "dyo"                     => "cc9900",
  "dys"                     => "99cc00",
  "eclipse"                 => 343148,
  "eden"                    => "264e36",
  "emerald"                 => "009b77",
  "emeraldgreen"            => "93b778",
  "emperador"               => "6c4f3d",
  "eveningblue"             => "2a293e",
  "fadeddenim"              => "798ea4",
  "feldspar"                => "d19275",
  "fiesta"                  => "dd4132",
  "firebrick"               => "b22222",
  "firebrick1"              => "ff3030",
  "firebrick2"              => "ee2c2c",
  "firebrick3"              => "cd2626",
  "firebrick4"              => "8b1a1a",
  "firedbrick"              => "6a2e2a",
  "flame"                   => "f2552c",
  "flamescarlet"            => "cd212a",
  "flaxflowerblue"          => "6f88af",
  "flesh"                   => "f5ccb0",
  "fleshred"                => "e9c49d",
  "floralwhite"             => "fffaf0",
  "forestgreen"             => "228b22",
  "frenchblue"              => "0072b5",
  "frenchgrey"              => "bebeb3",
  "fruitdove"               => "ce5b78",
  "fuchsia"                 => "ff00ff",
  "fuchsiarose"             => "c3447a",
  "fuscia"                  => "ff00ff",
  "g"                       => "00ff00",
  "gainsboro"               => "dcdcdc",
  "galaxyblue"              => "2a4b7c",
  "gallstoneyellow"         => "a36629",
  "gambogeyellow"           => "e6d058",
  "ggs"                     => "33ff00",
  "ggt"                     => "00ff33",
  "ghostwhite"              => "f8f8ff",
  "glacierlake"             => "84a2bb",
  "gold"                    => "ffd700",
  "gold1"                   => "ffd700",
  "gold2"                   => "eec900",
  "gold3"                   => "cdad00",
  "gold4"                   => "8b7500",
  "goldenlime"              => "9c9a40",
  "goldenrod"               => "daa520",
  "goldenrod1"              => "ffc125",
  "goldenrod2"              => "eeb422",
  "goldenrod3"              => "cd9b1d",
  "goldenrod4"              => "8b6914",
  "gossamerpink"            => "f9c5c2",
  "grannysmithapple"        => "5cbf64",
  "grapecompote"            => "6b5876",
  "grassgreen"              => "7d8c55",
  "gray"                    => 808080,
  "gray0"                   => "000000",
  "gray1"                   => "030303",
  "gray10"                  => "1a1a1a",
  "gray100"                 => "ffffff",
  "gray11"                  => "1c1c1c",
  "gray12"                  => "1f1f1f",
  "gray13"                  => 212121,
  "gray14"                  => 242424,
  "gray15"                  => 262626,
  "gray16"                  => 292929,
  "gray17"                  => "2b2b2b",
  "gray18"                  => "2e2e2e",
  "gray19"                  => 303030,
  "gray2"                   => "050505",
  "gray20"                  => 333333,
  "gray21"                  => 363636,
  "gray22"                  => 383838,
  "gray23"                  => "3b3b3b",
  "gray24"                  => "3d3d3d",
  "gray25"                  => 404040,
  "gray26"                  => 424242,
  "gray27"                  => 454545,
  "gray28"                  => 474747,
  "gray29"                  => "4a4a4a",
  "gray3"                   => "080808",
  "gray30"                  => "4d4d4d",
  "gray31"                  => "4f4f4f",
  "gray32"                  => 525252,
  "gray33"                  => 545454,
  "gray34"                  => 575757,
  "gray35"                  => 595959,
  "gray36"                  => "5c5c5c",
  "gray37"                  => "5e5e5e",
  "gray38"                  => 616161,
  "gray39"                  => 636363,
  "gray4"                   => "0a0a0a",
  "gray40"                  => 666666,
  "gray41"                  => 696969,
  "gray42"                  => "6b6b6b",
  "gray43"                  => "6e6e6e",
  "gray44"                  => 707070,
  "gray45"                  => 737373,
  "gray46"                  => 757575,
  "gray47"                  => 787878,
  "gray48"                  => "7a7a7a",
  "gray49"                  => "7d7d7d",
  "gray5"                   => "0d0d0d",
  "gray50"                  => "7f7f7f",
  "gray51"                  => 828282,
  "gray52"                  => 858585,
  "gray53"                  => 878787,
  "gray54"                  => "8a8a8a",
  "gray55"                  => "8c8c8c",
  "gray56"                  => "8f8f8f",
  "gray57"                  => 919191,
  "gray58"                  => 949494,
  "gray59"                  => 969696,
  "gray6"                   => "0f0f0f",
  "gray60"                  => 999999,
  "gray61"                  => "9c9c9c",
  "gray62"                  => "9e9e9e",
  "gray63"                  => "a1a1a1",
  "gray64"                  => "a3a3a3",
  "gray65"                  => "a6a6a6",
  "gray66"                  => "a8a8a8",
  "gray67"                  => "ababab",
  "gray68"                  => "adadad",
  "gray69"                  => "b0b0b0",
  "gray7"                   => 121212,
  "gray70"                  => "b3b3b3",
  "gray71"                  => "b5b5b5",
  "gray72"                  => "b8b8b8",
  "gray73"                  => "bababa",
  "gray74"                  => "bdbdbd",
  "gray75"                  => "bfbfbf",
  "gray76"                  => "c2c2c2",
  "gray77"                  => "c4c4c4",
  "gray78"                  => "c7c7c7",
  "gray79"                  => "c9c9c9",
  "gray8"                   => 141414,
  "gray80"                  => "cccccc",
  "gray81"                  => "cfcfcf",
  "gray82"                  => "d1d1d1",
  "gray83"                  => "d4d4d4",
  "gray84"                  => "d6d6d6",
  "gray85"                  => "d9d9d9",
  "gray86"                  => "dbdbdb",
  "gray87"                  => "dedede",
  "gray88"                  => "e0e0e0",
  "gray89"                  => "e3e3e3",
  "gray9"                   => 171717,
  "gray90"                  => "e5e5e5",
  "gray91"                  => "e8e8e8",
  "gray92"                  => "ebebeb",
  "gray93"                  => "ededed",
  "gray94"                  => "f0f0f0",
  "gray95"                  => "f2f2f2",
  "gray96"                  => "f5f5f5",
  "gray97"                  => "f7f7f7",
  "gray98"                  => "fafafa",
  "gray99"                  => "fcfcfc",
  "green"                   => "008000",
  "green-green-spring"      => "33ff00",
  "green-green-teal"        => "00ff33",
  "green1"                  => "00ff00",
  "green2"                  => "00ee00",
  "green3"                  => "00cd00",
  "green4"                  => "008b00",
  "greenash"                => "a0daa9",
  "greencopper"             => 856363,
  "greenflash"              => "79c753",
  "greengreenspring"        => "33ff00",
  "greengreenteal"          => "00ff33",
  "greenishblack"           => 454445,
  "greenishblue"            => "719ba2",
  "greenishgrey"            => "8a8d84",
  "greenishwhite"           => "f2ebcd",
  "greensheen"              => "d9ce52",
  "greenyellow"             => "adff2f",
  "grenadine"               => "dc4c46",
  "grey"                    => 808080,
  "grey0"                   => "000000",
  "grey1"                   => "030303",
  "grey10"                  => "1a1a1a",
  "grey100"                 => "ffffff",
  "grey11"                  => "1c1c1c",
  "grey12"                  => "1f1f1f",
  "grey13"                  => 212121,
  "grey14"                  => 242424,
  "grey15"                  => 262626,
  "grey16"                  => 292929,
  "grey17"                  => "2b2b2b",
  "grey18"                  => "2e2e2e",
  "grey19"                  => 303030,
  "grey2"                   => "050505",
  "grey20"                  => 333333,
  "grey21"                  => 363636,
  "grey22"                  => 383838,
  "grey23"                  => "3b3b3b",
  "grey24"                  => "3d3d3d",
  "grey25"                  => 404040,
  "grey26"                  => 424242,
  "grey27"                  => 454545,
  "grey28"                  => 474747,
  "grey29"                  => "4a4a4a",
  "grey3"                   => "080808",
  "grey30"                  => "4d4d4d",
  "grey31"                  => "4f4f4f",
  "grey32"                  => 525252,
  "grey33"                  => 545454,
  "grey34"                  => 575757,
  "grey35"                  => 595959,
  "grey36"                  => "5c5c5c",
  "grey37"                  => "5e5e5e",
  "grey38"                  => 616161,
  "grey39"                  => 636363,
  "grey4"                   => "0a0a0a",
  "grey40"                  => 666666,
  "grey41"                  => 696969,
  "grey42"                  => "6b6b6b",
  "grey43"                  => "6e6e6e",
  "grey44"                  => 707070,
  "grey45"                  => 737373,
  "grey46"                  => 757575,
  "grey47"                  => 787878,
  "grey48"                  => "7a7a7a",
  "grey49"                  => "7d7d7d",
  "grey5"                   => "0d0d0d",
  "grey50"                  => "7f7f7f",
  "grey51"                  => 828282,
  "grey52"                  => 858585,
  "grey53"                  => 878787,
  "grey54"                  => "8a8a8a",
  "grey55"                  => "8c8c8c",
  "grey56"                  => "8f8f8f",
  "grey57"                  => 919191,
  "grey58"                  => 949494,
  "grey59"                  => 969696,
  "grey6"                   => "0f0f0f",
  "grey60"                  => 999999,
  "grey61"                  => "9c9c9c",
  "grey62"                  => "9e9e9e",
  "grey63"                  => "a1a1a1",
  "grey64"                  => "a3a3a3",
  "grey65"                  => "a6a6a6",
  "grey66"                  => "a8a8a8",
  "grey67"                  => "ababab",
  "grey68"                  => "adadad",
  "grey69"                  => "b0b0b0",
  "grey7"                   => 121212,
  "grey70"                  => "b3b3b3",
  "grey71"                  => "b5b5b5",
  "grey72"                  => "b8b8b8",
  "grey73"                  => "bababa",
  "grey74"                  => "bdbdbd",
  "grey75"                  => "bfbfbf",
  "grey76"                  => "c2c2c2",
  "grey77"                  => "c4c4c4",
  "grey78"                  => "c7c7c7",
  "grey79"                  => "c9c9c9",
  "grey8"                   => 141414,
  "grey80"                  => "cccccc",
  "grey81"                  => "cfcfcf",
  "grey82"                  => "d1d1d1",
  "grey83"                  => "d4d4d4",
  "grey84"                  => "d6d6d6",
  "grey85"                  => "d9d9d9",
  "grey86"                  => "dbdbdb",
  "grey87"                  => "dedede",
  "grey88"                  => "e0e0e0",
  "grey89"                  => "e3e3e3",
  "grey9"                   => 171717,
  "grey90"                  => "e5e5e5",
  "grey91"                  => "e8e8e8",
  "grey92"                  => "ebebeb",
  "grey93"                  => "ededed",
  "grey94"                  => "f0f0f0",
  "grey95"                  => "f2f2f2",
  "grey96"                  => "f5f5f5",
  "grey97"                  => "f7f7f7",
  "grey98"                  => "fafafa",
  "grey99"                  => "fcfcfc",
  "greyishblack"            => 555152,
  "greyishblue"             => "8aa1a6",
  "greyishwhite"            => "e2ddc6",
  "guacamole"               => "797b3a",
  "hairbrown"               => "8b7859",
  "harborblue"              => "16737f",
  "harbormist"              => "b4b7ba",
  "hazelnut"                => "cfb095",
  "honeydew"                => "f0fff0",
  "honeydew1"               => "f0fff0",
  "honeydew2"               => "e0eee0",
  "honeydew3"               => "c1cdc1",
  "honeydew4"               => "838b83",
  "honeysucle"              => "d65076",
  "honeyyellow"             => "a77d35",
  "hotpink"                 => "ff69b4",
  "hotpink1"                => "ff6eb4",
  "hotpink2"                => "ee6aa7",
  "hotpink3"                => "cd6090",
  "hotpink4"                => "8b3a62",
  "huntergreen"             => "8e2323",
  "hyacinthred"             => "a75536",
  "icedcoffee"              => "b18f6a",
  "illuminating"            => "f5df4d",
  "imperialpurple"          => "584c77",
  "indianred"               => "cd5c5c",
  "indianred1"              => "ff6a6a",
  "indianred2"              => "ee6363",
  "indianred3"              => "cd5555",
  "indianred4"              => "8b3a3a",
  "indigo"                  => "4b0082",
  "indigoblue"              => "4f638d",
  "inkblack"                => 252024,
  "inkwell"                 => 363945,
  "innuendo"                => "c43f66",
  "islandparadise"          => "95dee3",
  "ivory"                   => "fffff0",
  "ivory1"                  => "fffff0",
  "ivory2"                  => "eeeee0",
  "ivory3"                  => "cdcdc1",
  "ivory4"                  => "8b8b83",
  "jesterred"               => "9e1030",
  "k"                       => "000000",
  "kale"                    => "5a7247",
  "khaki"                   => "f0e68c",
  "khaki1"                  => "fff68f",
  "khaki2"                  => "eee685",
  "khaki3"                  => "cdc673",
  "khaki4"                  => "8b864e",
  "kingsyellow"             => "ead665",
  "lab"                     => "6699ff",
  "lac"                     => "66ccff",
  "lakered"                 => "b74a70",
  "lapisblue"               => "004b8d",
  "lark"                    => "b89b72",
  "lavafalls"               => "9f383a",
  "lavender"                => "e6e6fa",
  "lavenderblush"           => "fff0f5",
  "lavenderblush1"          => "fff0f5",
  "lavenderblush2"          => "eee0e5",
  "lavenderblush3"          => "cdc1c5",
  "lavenderblush4"          => "8b8386",
  "lavenderpurple"          => "77747f",
  "lawngreen"               => "7cfc00",
  "lba"                     => "3366ff",
  "lbv"                     => "6633ff",
  "lca"                     => "33ccff",
  "lct"                     => "33ffcc",
  "lda"                     => "6699cc",
  "ldb"                     => "6666cc",
  "ldc"                     => "66cccc",
  "ldg"                     => "66cc66",
  "ldm"                     => "cc66cc",
  "ldo"                     => "cc9966",
  "ldp"                     => "cc6699",
  "ldr"                     => "cc6666",
  "lds"                     => "99cc66",
  "ldt"                     => "66cc99",
  "ldv"                     => "9966cc",
  "ldy"                     => "cccc66",
  "leekgreen"               => "979c84",
  "lemonchiffon"            => "fffacd",
  "lemonchiffon1"           => "fffacd",
  "lemonchiffon2"           => "eee9bf",
  "lemonchiffon3"           => "cdc9a5",
  "lemonchiffon4"           => "8b8970",
  "lemonyellow"             => "dbc364",
  "lfb"                     => "6666ff",
  "lfc"                     => "66ffff",
  "lfg"                     => "66ff66",
  "lfm"                     => "ff66ff",
  "lfr"                     => "ff6666",
  "lfy"                     => "ffff66",
  "lg"                      => 999999,
  "lgs"                     => "66ff33",
  "lgt"                     => "33ff66",
  "lha"                     => "3399ff",
  "lhb"                     => "3333ff",
  "lhc"                     => "33ffff",
  "lhg"                     => "33ff33",
  "lhm"                     => "ff33ff",
  "lho"                     => "ff9933",
  "lhp"                     => "ff3399",
  "lhr"                     => "ff3333",
  "lhs"                     => "99ff33",
  "lht"                     => "33ff99",
  "lhv"                     => "9933ff",
  "lhy"                     => "ffff33",
  "light azure-blue"        => "6699ff",
  "light azure-cyan"        => "66ccff",
  "light blue-azure"        => "3366ff",
  "light blue-violet"       => "6633ff",
  "light cyan-azure"        => "33ccff",
  "light cyan-teal"         => "33ffcc",
  "light dull azure"        => "6699cc",
  "light dull blue"         => "6666cc",
  "light dull cyan"         => "66cccc",
  "light dull green"        => "66cc66",
  "light dull magenta"      => "cc66cc",
  "light dull orange"       => "cc9966",
  "light dull pink"         => "cc6699",
  "light dull red"          => "cc6666",
  "light dull spring"       => "99cc66",
  "light dull teal"         => "66cc99",
  "light dull violet"       => "9966cc",
  "light dull yellow"       => "cccc66",
  "light faded blue"        => "6666ff",
  "light faded cyan"        => "66ffff",
  "light faded green"       => "66ff66",
  "light faded magenta"     => "ff66ff",
  "light faded red"         => "ff6666",
  "light faded yellow"      => "ffff66",
  "light gray"              => 999999,
  "light green-spring"      => "66ff33",
  "light green-teal"        => "33ff66",
  "light hard azure"        => "3399ff",
  "light hard blue"         => "3333ff",
  "light hard cyan"         => "33ffff",
  "light hard green"        => "33ff33",
  "light hard magenta"      => "ff33ff",
  "light hard orange"       => "ff9933",
  "light hard pink"         => "ff3399",
  "light hard red"          => "ff3333",
  "light hard spring"       => "99ff33",
  "light hard teal"         => "33ff99",
  "light hard violet"       => "9933ff",
  "light hard yellow"       => "ffff33",
  "light magenta-pink"      => "ff33cc",
  "light magenta-violet"    => "cc33ff",
  "light orange-red"        => "ff9966",
  "light orange-yellow"     => "ffcc66",
  "light pink-magenta"      => "ff66cc",
  "light pink-red"          => "ff6699",
  "light red-orange"        => "ff6633",
  "light red-pink"          => "ff3366",
  "light spring-green"      => "99ff66",
  "light spring-yellow"     => "ccff66",
  "light teal-cyan"         => "66ffcc",
  "light teal-green"        => "66ff99",
  "light violet-blue"       => "9966ff",
  "light violet-magenta"    => "cc66ff",
  "light weak blue"         => "9999cc",
  "light weak cyan"         => "99cccc",
  "light weak green"        => "99cc99",
  "light weak magenta"      => "cc99cc",
  "light weak red"          => "cc9999",
  "light weak yellow"       => "cccc99",
  "light yellow-orange"     => "ffcc33",
  "light yellow-spring"     => "ccff33",
  "lightazure-blue"         => "6699ff",
  "lightazure-cyan"         => "66ccff",
  "lightazureblue"          => "6699ff",
  "lightazurecyan"          => "66ccff",
  "lightblue"               => "add8e6",
  "lightblue-azure"         => "3366ff",
  "lightblue-violet"        => "6633ff",
  "lightblue1"              => "bfefff",
  "lightblue2"              => "b2dfee",
  "lightblue3"              => "9ac0cd",
  "lightblue4"              => "68838b",
  "lightblueazure"          => "3366ff",
  "lightblueviolet"         => "6633ff",
  "lightcoral"              => "f08080",
  "lightcyan"               => "e0ffff",
  "lightcyan-azure"         => "33ccff",
  "lightcyan-teal"          => "33ffcc",
  "lightcyan1"              => "e0ffff",
  "lightcyan2"              => "d1eeee",
  "lightcyan3"              => "b4cdcd",
  "lightcyan4"              => "7a8b8b",
  "lightcyanazure"          => "33ccff",
  "lightcyanteal"           => "33ffcc",
  "lightdullazure"          => "6699cc",
  "lightdullblue"           => "6666cc",
  "lightdullcyan"           => "66cccc",
  "lightdullgreen"          => "66cc66",
  "lightdullmagenta"        => "cc66cc",
  "lightdullorange"         => "cc9966",
  "lightdullpink"           => "cc6699",
  "lightdullred"            => "cc6666",
  "lightdullspring"         => "99cc66",
  "lightdullteal"           => "66cc99",
  "lightdullviolet"         => "9966cc",
  "lightdullyellow"         => "cccc66",
  "lightfadedblue"          => "6666ff",
  "lightfadedcyan"          => "66ffff",
  "lightfadedgreen"         => "66ff66",
  "lightfadedmagenta"       => "ff66ff",
  "lightfadedred"           => "ff6666",
  "lightfadedyellow"        => "ffff66",
  "lightgoldenrod"          => "eedd82",
  "lightgoldenrod1"         => "ffec8b",
  "lightgoldenrod2"         => "eedc82",
  "lightgoldenrod3"         => "cdbe70",
  "lightgoldenrod4"         => "8b814c",
  "lightgoldenrodyellow"    => "fafad2",
  "lightgray"               => "d3d3d3",
  "lightgreen"              => "90ee90",
  "lightgreen-spring"       => "66ff33",
  "lightgreen-teal"         => "33ff66",
  "lightgreenspring"        => "66ff33",
  "lightgreenteal"          => "33ff66",
  "lightgrey"               => "d3d3d3",
  "lighthardazure"          => "3399ff",
  "lighthardblue"           => "3333ff",
  "lighthardcyan"           => "33ffff",
  "lighthardgreen"          => "33ff33",
  "lighthardmagenta"        => "ff33ff",
  "lighthardorange"         => "ff9933",
  "lighthardpink"           => "ff3399",
  "lighthardred"            => "ff3333",
  "lighthardspring"         => "99ff33",
  "lighthardteal"           => "33ff99",
  "lighthardviolet"         => "9933ff",
  "lighthardyellow"         => "ffff33",
  "lightmagenta-pink"       => "ff33cc",
  "lightmagenta-violet"     => "cc33ff",
  "lightmagentapink"        => "ff33cc",
  "lightmagentaviolet"      => "cc33ff",
  "lightorange-red"         => "ff9966",
  "lightorange-yellow"      => "ffcc66",
  "lightorangered"          => "ff9966",
  "lightorangeyellow"       => "ffcc66",
  "lightpink"               => "ffb6c1",
  "lightpink-magenta"       => "ff66cc",
  "lightpink-red"           => "ff6699",
  "lightpink1"              => "ffaeb9",
  "lightpink2"              => "eea2ad",
  "lightpink3"              => "cd8c95",
  "lightpink4"              => "8b5f65",
  "lightpinkmagenta"        => "ff66cc",
  "lightpinkred"            => "ff6699",
  "lightred-orange"         => "ff6633",
  "lightred-pink"           => "ff3366",
  "lightredorange"          => "ff6633",
  "lightredpink"            => "ff3366",
  "lightsalmon"             => "ffa07a",
  "lightsalmon1"            => "ffa07a",
  "lightsalmon2"            => "ee9572",
  "lightsalmon3"            => "cd8162",
  "lightsalmon4"            => "8b5742",
  "lightseagreen"           => "20b2aa",
  "lightskyblue"            => "87cefa",
  "lightskyblue1"           => "b0e2ff",
  "lightskyblue2"           => "a4d3ee",
  "lightskyblue3"           => "8db6cd",
  "lightskyblue4"           => "607b8b",
  "lightslateblue"          => "8470ff",
  "lightslategray"          => 778899,
  "lightslategrey"          => 778899,
  "lightspring-green"       => "99ff66",
  "lightspring-yellow"      => "ccff66",
  "lightspringgreen"        => "99ff66",
  "lightspringyellow"       => "ccff66",
  "lightsteelblue"          => "b0c4de",
  "lightsteelblue1"         => "cae1ff",
  "lightsteelblue2"         => "bcd2ee",
  "lightsteelblue3"         => "a2b5cd",
  "lightsteelblue4"         => "6e7b8b",
  "lightteal-cyan"          => "66ffcc",
  "lightteal-green"         => "66ff99",
  "lighttealcyan"           => "66ffcc",
  "lighttealgreen"          => "66ff99",
  "lightviolet-blue"        => "9966ff",
  "lightviolet-magenta"     => "cc66ff",
  "lightvioletblue"         => "9966ff",
  "lightvioletmagenta"      => "cc66ff",
  "lightweakblue"           => "9999cc",
  "lightweakcyan"           => "99cccc",
  "lightweakgreen"          => "99cc99",
  "lightweakmagenta"        => "cc99cc",
  "lightweakred"            => "cc9999",
  "lightweakyellow"         => "cccc99",
  "lightwood"               => 856363,
  "lightyellow"             => "ffffe0",
  "lightyellow-orange"      => "ffcc33",
  "lightyellow-spring"      => "ccff33",
  "lightyellow1"            => "ffffe0",
  "lightyellow2"            => "eeeed1",
  "lightyellow3"            => "cdcdb4",
  "lightyellow4"            => "8b8b7a",
  "lightyelloworange"       => "ffcc33",
  "lightyellowspring"       => "ccff33",
  "lilacgrey"               => "9896a4",
  "lime"                    => "00ff00",
  "limegreen"               => "32cd32",
  "limelight"               => "f1ea7f",
  "limepunc"                => "bfd641",
  "limpetshell"             => "98ddde",
  "linen"                   => "faf0e6",
  "littleboyblue"           => "6f9fd8",
  "liverbrown"              => "513e32",
  "livingcoral"             => "ff6f61",
  "lmp"                     => "ff33cc",
  "lmv"                     => "cc33ff",
  "lodenfrost"              => "758e77",
  "lor"                     => "ff9966",
  "loy"                     => "ffcc66",
  "lpm"                     => "ff66cc",
  "lpr"                     => "ff6699",
  "lro"                     => "ff6633",
  "lrp"                     => "ff3366",
  "lsg"                     => "99ff66",
  "lsy"                     => "ccff66",
  "ltc"                     => "66ffcc",
  "ltg"                     => "66ff99",
  "lushmeadow"              => "006e51",
  "lvb"                     => "9966ff",
  "lvm"                     => "cc66ff",
  "lwb"                     => "9999cc",
  "lwc"                     => "99cccc",
  "lwg"                     => "99cc99",
  "lwm"                     => "cc99cc",
  "lwr"                     => "cc9999",
  "lwy"                     => "cccc99",
  "lyo"                     => "ffcc33",
  "lys"                     => "ccff33",
  "m"                       => "ff00ff",
  "mab"                     => "3366cc",
  "mac"                     => "3399cc",
  "macaroniandcheese"       => "f6a94b",
  "magenta"                 => "ff00ff",
  "magenta-magenta-pink"    => "ff00cc",
  "magenta-magenta-violet"  => "cc00ff",
  "magenta1"                => "ff00ff",
  "magenta2"                => "ee00ee",
  "magenta3"                => "cd00cd",
  "magenta4"                => "8b008b",
  "magentamagentapink"      => "ff00cc",
  "magentamagentaviolet"    => "cc00ff",
  "magentapurple"           => "6c244c",
  "mahogany"                => "ba4f35",
  "mandarianorange"         => "8e2323",
  "mangomojito"             => "d69c2f",
  "marigold"                => "fdac53",
  "marina"                  => "4f84c4",
  "maroon"                  => 800000,
  "maroon1"                 => "ff34b3",
  "maroon2"                 => "ee30a7",
  "maroon3"                 => "cd2990",
  "maroon4"                 => "8b1c62",
  "marsala"                 => 955251,
  "martiniolive"            => "766f57",
  "mauvelous"               => "d0687e",
  "meadowlark"              => "ecdb54",
  "medium azure-blue"       => "3366cc",
  "medium azure-cyan"       => "3399cc",
  "medium faded blue"       => "3333cc",
  "medium faded cyan"       => "33cccc",
  "medium faded green"      => "33cc33",
  "medium faded magenta"    => "cc33cc",
  "medium faded red"        => "cc3333",
  "medium faded yellow"     => "cccc33",
  "medium orange-red"       => "cc6633",
  "medium orange-yellow"    => "cc9933",
  "medium pink-magenta"     => "cc3399",
  "medium pink-red"         => "cc3366",
  "medium spring-green"     => "66cc33",
  "medium spring-yellow"    => "99cc33",
  "medium teal-cyan"        => "33cc99",
  "medium teal-green"       => "33cc66",
  "medium violet-blue"      => "6633cc",
  "medium violet-magenta"   => "9933cc",
  "medium weak blue"        => 666699,
  "medium weak cyan"        => 669999,
  "medium weak green"       => 669966,
  "medium weak magenta"     => 996699,
  "medium weak red"         => 996666,
  "medium weak yellow"      => 999966,
  "mediumaquamarine"        => "66cdaa",
  "mediumazure-blue"        => "3366cc",
  "mediumazure-cyan"        => "3399cc",
  "mediumazureblue"         => "3366cc",
  "mediumazurecyan"         => "3399cc",
  "mediumblue"              => "0000cd",
  "mediumfadedblue"         => "3333cc",
  "mediumfadedcyan"         => "33cccc",
  "mediumfadedgreen"        => "33cc33",
  "mediumfadedmagenta"      => "cc33cc",
  "mediumfadedred"          => "cc3333",
  "mediumfadedyellow"       => "cccc33",
  "mediumforestgreen"       => "dbdb70",
  "mediumgoldenrod"         => "eaeaae",
  "mediumorange-red"        => "cc6633",
  "mediumorange-yellow"     => "cc9933",
  "mediumorangered"         => "cc6633",
  "mediumorangeyellow"      => "cc9933",
  "mediumorchid"            => "ba55d3",
  "mediumorchid1"           => "e066ff",
  "mediumorchid2"           => "d15fee",
  "mediumorchid3"           => "b452cd",
  "mediumorchid4"           => "7a378b",
  "mediumpink-magenta"      => "cc3399",
  "mediumpink-red"          => "cc3366",
  "mediumpinkmagenta"       => "cc3399",
  "mediumpinkred"           => "cc3366",
  "mediumpurple"            => "9370db",
  "mediumpurple1"           => "ab82ff",
  "mediumpurple2"           => "9f79ee",
  "mediumpurple3"           => "8968cd",
  "mediumpurple4"           => "5d478b",
  "mediumseagreen"          => "3cb371",
  "mediumslateblue"         => "7b68ee",
  "mediumspring-green"      => "66cc33",
  "mediumspring-yellow"     => "99cc33",
  "mediumspringgreen"       => "00fa9a",
  "mediumspringyellow"      => "99cc33",
  "mediumteal-cyan"         => "33cc99",
  "mediumteal-green"        => "33cc66",
  "mediumtealcyan"          => "33cc99",
  "mediumtealgreen"         => "33cc66",
  "mediumturquoise"         => "48d1cc",
  "mediumviolet-blue"       => "6633cc",
  "mediumviolet-magenta"    => "9933cc",
  "mediumvioletblue"        => "6633cc",
  "mediumvioletmagenta"     => "9933cc",
  "mediumvioletred"         => "c71585",
  "mediumweakblue"          => 666699,
  "mediumweakcyan"          => 669999,
  "mediumweakgreen"         => 669966,
  "mediumweakmagenta"       => 996699,
  "mediumweakred"           => 996666,
  "mediumweakyellow"        => 999966,
  "mediumwood"              => "a68064",
  "meerkat"                 => "a9754f",
  "melon"                   => "f6857d",
  "mfb"                     => "3333cc",
  "mfc"                     => "33cccc",
  "mfg"                     => "33cc33",
  "mfm"                     => "cc33cc",
  "mfr"                     => "cc3333",
  "mfy"                     => "cccc33",
  "midnight"                => "315d78",
  "midnightblue"            => 191970,
  "mimosa"                  => "efc050",
  "mint"                    => "00a170",
  "mintcream"               => "f5fffa",
  "mistyrose"               => "ffe4e1",
  "mistyrose1"              => "ffe4e1",
  "mistyrose2"              => "eed5d2",
  "mistyrose3"              => "cdb7b5",
  "mistyrose4"              => "8b7d7b",
  "mmp"                     => "ff00cc",
  "mmv"                     => "cc00ff",
  "moccasin"                => "ffe4b5",
  "mor"                     => "cc6633",
  "mosaicblue"              => "00758f",
  "mountaingreen"           => "b2b599",
  "moy"                     => "cc9933",
  "mpm"                     => "cc3399",
  "mpr"                     => "cc3366",
  "msg"                     => "66cc33",
  "msy"                     => "99cc33",
  "mtc"                     => "33cc99",
  "mtg"                     => "33cc66",
  "mvb"                     => "6633cc",
  "mvm"                     => "9933cc",
  "mwb"                     => 666699,
  "mwc"                     => 669999,
  "mwg"                     => 669966,
  "mwm"                     => 996699,
  "mwr"                     => 996666,
  "mwy"                     => 999966,
  "navajowhite"             => "ffdead",
  "navajowhite1"            => "ffdead",
  "navajowhite2"            => "eecfa1",
  "navajowhite3"            => "cdb38b",
  "navajowhite4"            => "8b795e",
  "navy"                    => "000080",
  "navyblazer"              => "282d3c",
  "navyblue"                => "23238e",
  "navypeony"               => "223a5e",
  "nebulasblue"             => "3f69aa",
  "neonblue"                => "4d4dff",
  "neonpink"                => "ff6ec7",
  "neutralgray"             => "898e8c",
  "newmidnightblue"         => "00009c",
  "newtan"                  => "ebc79e",
  "niagara"                 => "578ca9",
  "northerndroplet"         => "bdc0bf",
  "nosegay"                 => "f0c0d8",
  "obscure dull azure"      => "003366",
  "obscure dull blue"       => "000066",
  "obscure dull cyan"       => "006666",
  "obscure dull green"      => "006600",
  "obscure dull magenta"    => 660066,
  "obscure dull orange"     => 663300,
  "obscure dull pink"       => 660033,
  "obscure dull red"        => 660000,
  "obscure dull spring"     => 336600,
  "obscure dull teal"       => "006633",
  "obscure dull violet"     => 330066,
  "obscure dull yellow"     => 666600,
  "obscure gray"            => 333333,
  "obscure weak blue"       => "000033",
  "obscure weak cyan"       => "003333",
  "obscure weak green"      => "003300",
  "obscure weak magenta"    => 330033,
  "obscure weak red"        => 330000,
  "obscure weak yellow"     => 333300,
  "obscuredullazure"        => "003366",
  "obscuredullblue"         => "000066",
  "obscuredullcyan"         => "006666",
  "obscuredullgreen"        => "006600",
  "obscuredullmagenta"      => 660066,
  "obscuredullorange"       => 663300,
  "obscuredullpink"         => 660033,
  "obscuredullred"          => 660000,
  "obscuredullspring"       => 336600,
  "obscuredullteal"         => "006633",
  "obscuredullviolet"       => 330066,
  "obscuredullyellow"       => 666600,
  "obscuregray"             => 333333,
  "obscureweakblue"         => "000033",
  "obscureweakcyan"         => "003333",
  "obscureweakgreen"        => "003300",
  "obscureweakmagenta"      => 330033,
  "obscureweakred"          => 330000,
  "obscureweakyellow"       => 333300,
  "ochreyellow"             => "efcc83",
  "oda"                     => "003366",
  "odb"                     => "000066",
  "odc"                     => "006666",
  "odg"                     => "006600",
  "odm"                     => 660066,
  "odo"                     => 663300,
  "odp"                     => 660033,
  "odr"                     => 660000,
  "ods"                     => 336600,
  "odt"                     => "006633",
  "odv"                     => 330066,
  "ody"                     => 666600,
  "og"                      => 333333,
  "oilgreen"                => "ab924b",
  "oldgold"                 => "cfb53b",
  "oldlace"                 => "fdf5e6",
  "olive"                   => 808000,
  "olivedrab"               => "6b8e23",
  "olivedrab1"              => "c0ff3e",
  "olivedrab2"              => "b3ee3a",
  "olivedrab3"              => "9acd32",
  "olivedrab4"              => "698b22",
  "olivegreen"              => "8aa845",
  "oor"                     => "ff6600",
  "ooy"                     => "ff9900",
  "orange"                  => "ffa500",
  "orange-orange-red"       => "ff6600",
  "orange-orange-yellow"    => "ff9900",
  "orange1"                 => "ffa500",
  "orange2"                 => "ee9a00",
  "orange3"                 => "cd8500",
  "orange4"                 => "8b5a00",
  "orangecolouredwhite"     => "f3e9ca",
  "orangeorangered"         => "ff6600",
  "orangeorangeyellow"      => "ff9900",
  "orangepeel"              => "fa7a35",
  "orangered"               => "ff4500",
  "orangered1"              => "ff4500",
  "orangered2"              => "ee4000",
  "orangered3"              => "cd3700",
  "orangered4"              => "8b2500",
  "orangetiger"             => "f96714",
  "orchid"                  => "da70d6",
  "orchid1"                 => "ff83fa",
  "orchid2"                 => "ee7ae9",
  "orchid3"                 => "cd69c9",
  "orchid4"                 => "8b4789",
  "orpimentorange"          => "d17c3f",
  "owb"                     => "000033",
  "owc"                     => "003333",
  "owg"                     => "003300",
  "owm"                     => 330033,
  "owr"                     => 330000,
  "owy"                     => 333300,
  "pale dull azure"         => "99ccff",
  "pale dull blue"          => "9999ff",
  "pale dull cyan"          => "99ffff",
  "pale dull green"         => "99ff99",
  "pale dull magenta"       => "ff99ff",
  "pale dull orange"        => "ffcc99",
  "pale dull pink"          => "ff99cc",
  "pale dull red"           => "ff9999",
  "pale dull spring"        => "ccff99",
  "pale dull teal"          => "99ffcc",
  "pale dull violet"        => "cc99ff",
  "pale dull yellow"        => "ffff99",
  "pale gray"               => "cccccc",
  "pale weak blue"          => "ccccff",
  "pale weak cyan"          => "ccffff",
  "pale weak green"         => "ccffcc",
  "pale weak magenta"       => "ffccff",
  "pale weak red"           => "ffcccc",
  "pale weak yellow"        => "ffffcc",
  "paleblackishpurple"      => "4a475c",
  "paledogwood"             => "edcdc2",
  "paledullazure"           => "99ccff",
  "paledullblue"            => "9999ff",
  "paledullcyan"            => "99ffff",
  "paledullgreen"           => "99ff99",
  "paledullmagenta"         => "ff99ff",
  "paledullorange"          => "ffcc99",
  "paledullpink"            => "ff99cc",
  "paledullred"             => "ff9999",
  "paledullspring"          => "ccff99",
  "paledullteal"            => "99ffcc",
  "paledullviolet"          => "cc99ff",
  "paledullyellow"          => "ffff99",
  "palegoldenrod"           => "eee8aa",
  "palegray"                => "cccccc",
  "palegreen"               => "98fb98",
  "palegreen1"              => "9aff9a",
  "palegreen2"              => "90ee90",
  "palegreen3"              => "7ccd7c",
  "palegreen4"              => "548b54",
  "paleturquoise"           => "afeeee",
  "paleturquoise1"          => "bbffff",
  "paleturquoise2"          => "aeeeee",
  "paleturquoise3"          => "96cdcd",
  "paleturquoise4"          => "668b8b",
  "palevioletred"           => "db7093",
  "palevioletred1"          => "ff82ab",
  "palevioletred2"          => "ee799f",
  "palevioletred3"          => "cd6889",
  "palevioletred4"          => "8b475d",
  "paleweakblue"            => "ccccff",
  "paleweakcyan"            => "ccffff",
  "paleweakgreen"           => "ccffcc",
  "paleweakmagenta"         => "ffccff",
  "paleweakred"             => "ffcccc",
  "paleweakyellow"          => "ffffcc",
  "paloma"                  => "9f9c99",
  "pansypurple"             => "39334a",
  "papayawhip"              => "ffefd5",
  "pda"                     => "99ccff",
  "pdb"                     => "9999ff",
  "pdc"                     => "99ffff",
  "pdg"                     => "99ff99",
  "pdm"                     => "ff99ff",
  "pdo"                     => "ffcc99",
  "pdp"                     => "ff99cc",
  "pdr"                     => "ff9999",
  "pds"                     => "ccff99",
  "pdt"                     => "99ffcc",
  "pdv"                     => "cc99ff",
  "pdy"                     => "ffff99",
  "peach"                   => "f5bc89",
  "peachblossomred"         => "eecfbf",
  "peachecho"               => "f7786b",
  "peachnougat"             => "e6af91",
  "peachpink"               => "fa9a85",
  "peachpuff"               => "ffdab9",
  "peachpuff1"              => "ffdab9",
  "peachpuff2"              => "eecbad",
  "peachpuff3"              => "cdaf95",
  "peachpuff4"              => "8b7765",
  "pearlgrey"               => "b7b5ac",
  "pepperstem"              => "8d9440",
  "perfectlypale"           => "d5ccc1",
  "peru"                    => "cd853f",
  "pg"                      => "cccccc",
  "pink"                    => "ffc0cb",
  "pink-pink-magenta"       => "ff0099",
  "pink-pink-red"           => "ff0066",
  "pink1"                   => "ffb5c5",
  "pink2"                   => "eea9b8",
  "pink3"                   => "cd919e",
  "pink4"                   => "8b636c",
  "pinklavender"            => "dbb1cd",
  "pinkpeacock"             => "c62168",
  "pinkpinkmagenta"         => "ff0099",
  "pinkpinkred"             => "ff0066",
  "pinkyarrow"              => "ce3175",
  "pistachiogreen"          => "8e9849",
  "pitchorbrownishblack"    => 423937,
  "plum"                    => "dda0dd",
  "plum1"                   => "ffbbff",
  "plum2"                   => "eeaeee",
  "plum3"                   => "cd96cd",
  "plum4"                   => "8b668b",
  "plumpurple"              => 463759,
  "poinciana"               => "c94235",
  "polarnight"              => 434550,
  "poppyseed"               => "66686c",
  "pottersclay"             => "9e4624",
  "powderblue"              => "b0e0e6",
  "ppm"                     => "ff0099",
  "ppr"                     => "ff0066",
  "primroseyellow"          => "f6d155",
  "princessblue"            => "00539c",
  "prussianblue"            => "1c1949",
  "purple"                  => 800080,
  "purple1"                 => "9b30ff",
  "purple2"                 => "912cee",
  "purple3"                 => "7d26cd",
  "purple4"                 => "551a8b",
  "purplemountainsmajesty"  => "8a6dc1",
  "purplishred"             => 612741,
  "purplishwhite"           => "ece6d0",
  "pwb"                     => "ccccff",
  "pwc"                     => "ccffff",
  "pwg"                     => "ccffcc",
  "pwm"                     => "ffccff",
  "pwr"                     => "ffcccc",
  "pwy"                     => "ffffcc",
  "quartz"                  => "d9d9f3",
  "quetzalgreen"            => "006e6d",
  "quietgray"               => "bcbcbe",
  "r"                       => "ff0000",
  "radiandorchid"           => "b565a7",
  "raspberrysorbet"         => "d2386c",
  "rawsienna"               => "9f6a3b",
  "rebeccapurple"           => 663399,
  "red"                     => "ff0000",
  "red-red-orange"          => "ff3300",
  "red-red-pink"            => "ff0033",
  "red1"                    => "ff0000",
  "red2"                    => "ee0000",
  "red3"                    => "cd0000",
  "red4"                    => "8b0000",
  "reddishblack"            => 433635,
  "reddishorange"           => "be7249",
  "reddishwhite"            => "f2e7cf",
  "redlilacpurple"          => "bfbac0",
  "redorange"               => "f1612a",
  "redpear"                 => "7f4145",
  "redredorange"            => "ff3300",
  "redredpink"              => "ff0033",
  "redviolet"               => "b32f79",
  "richblue"                => "5959ab",
  "riverside"               => "4c6a92",
  "rockyroad"               => "5a3e36",
  "rosequartz"              => "f7cac9",
  "rosered"                 => "eedac3",
  "rosetan"                 => "d19c97",
  "roseviolet"              => "c15391",
  "rosybrown"               => "bc8f8f",
  "rosybrown1"              => "ffc1c1",
  "rosybrown2"              => "eeb4b4",
  "rosybrown3"              => "cd9b9b",
  "rosybrown4"              => "8b6969",
  "royalblue"               => "4169e1",
  "royalblue1"              => "4876ff",
  "royalblue2"              => "436eee",
  "royalblue3"              => "3a5fcd",
  "royalblue4"              => "27408b",
  "rro"                     => "ff3300",
  "rrp"                     => "ff0033",
  "russetorange"            => "e47a2e",
  "rust"                    => "b55a30",
  "rustyred"                => 822007,
  "saddlebrown"             => "8b4513",
  "saffron"                 => "ffa500",
  "saffronyellow"           => "d09b2c",
  "sailorblue"              => "2e4a62",
  "salmon"                  => "fa8072",
  "salmon1"                 => "ff8c69",
  "salmon2"                 => "ee8262",
  "salmon3"                 => "cd7054",
  "salmon4"                 => "8b4c39",
  "samba"                   => "a2242f",
  "samoansun"               => "f5cc72",
  "sanddollar"              => "dfcfbe",
  "sandstone"               => "c48a69",
  "sandybrown"              => "f4a460",
  "sapgreen"                => "7c8635",
  "sargassosea"             => 485167,
  "scarlet"                 => "ed3825",
  "scarletred"              => "b63e36",
  "scotchblue"              => "281f3f",
  "seagreen"                => "2e8b57",
  "seagreen1"               => "54ff9f",
  "seagreen2"               => "4eee94",
  "seagreen3"               => "43cd80",
  "seagreen4"               => "2e8b57",
  "seashell"                => "fff5ee",
  "seashell1"               => "fff5ee",
  "seashell2"               => "eee5de",
  "seashell3"               => "cdc5bf",
  "seashell4"               => "8b8682",
  "semisweetchocolate"      => "6b4226",
  "sepia"                   => "6c4f3c",
  "serenity"                => "91a8d0",
  "shadedspruce"            => "005960",
  "sharkskin"               => 838487,
  "sienna"                  => "a0522d",
  "sienna1"                 => "ff8247",
  "sienna2"                 => "ee7942",
  "sienna3"                 => "cd6839",
  "sienna4"                 => "8b4726",
  "siennayellow"            => "f1d28c",
  "silver"                  => "c0c0c0",
  "siskingreen"             => "c8c76f",
  "skimmedmilkwhite"        => "e6e1c9",
  "skyblue"                 => "87ceeb",
  "skyblue1"                => "87ceff",
  "skyblue2"                => "7ec0ee",
  "skyblue3"                => "6ca6cd",
  "skyblue4"                => "4a708b",
  "skydiver"                => "1e609e",
  "slateblue"               => "6a5acd",
  "slateblue1"              => "836fff",
  "slateblue2"              => "7a67ee",
  "slateblue3"              => "6959cd",
  "slateblue4"              => "473c8b",
  "slategray"               => 708090,
  "slategray1"              => "c6e2ff",
  "slategray2"              => "b9d3ee",
  "slategray3"              => "9fb6cd",
  "slategray4"              => "6c7b8b",
  "slategrey"               => 708090,
  "smokegrey"               => "bfbbb0",
  "snorkelblue"             => "034f84",
  "snow"                    => "fffafa",
  "snow1"                   => "fffafa",
  "snow2"                   => "eee9e9",
  "snow3"                   => "cdc9c9",
  "snow4"                   => "8b8989",
  "snowwhite"               => "f2f0eb",
  "soybean"                 => "d2c29d",
  "spicymustard"            => "d8ae47",
  "spicypink"               => "ff1cae",
  "spring-spring-green"     => "66ff00",
  "spring-spring-yellow"    => "99ff00",
  "springcrocus"            => "bc70a4",
  "springgreen"             => "00ff7f",
  "springgreen1"            => "00ff7f",
  "springgreen2"            => "00ee76",
  "springgreen3"            => "00cd66",
  "springgreen4"            => "008b45",
  "springspringgreen"       => "66ff00",
  "springspringyellow"      => "99ff00",
  "spunsugar"               => "b8deec",
  "ssg"                     => "66ff00",
  "ssy"                     => "99ff00",
  "steelblue"               => "4682b4",
  "steelblue1"              => "63b8ff",
  "steelblue2"              => "5cacee",
  "steelblue3"              => "4f94cd",
  "steelblue4"              => "36648b",
  "strawyellow"             => "f0d696",
  "sugaralmond"             => 935529,
  "sulphuryellow"           => "ccc050",
  "summersky"               => "38b0de",
  "sunlight"                => "edd59e",
  "sweetcorn"               => "f0ead6",
  "sweetlilac"              => "e8b5ce",
  "tan"                     => "d2b48c",
  "tan1"                    => "ffa54f",
  "tan2"                    => "ee9a49",
  "tan3"                    => "cd853f",
  "tan4"                    => "8b5a2b",
  "tangerinetango"          => "dd4124",
  "tawnyport"               => "672e3b",
  "teal"                    => "008080",
  "teal-teal-cyan"          => "00ff99",
  "teal-teal-green"         => "00ff66",
  "tealtealcyan"            => "00ff99",
  "tealtealgreen"           => "00ff66",
  "terrariummoss"           => 616247,
  "thistle"                 => "d8bfd8",
  "thistle1"                => "ffe1ff",
  "thistle2"                => "eed2ee",
  "thistle3"                => "cdb5cd",
  "thistle4"                => "8b7b8b",
  "tigerlily"               => "e15d44",
  "tilered"                 => "c76b4a",
  "timberwolf"              => "adb0aa",
  "toffee"                  => 755139,
  "tofu"                    => "eae6da",
  "tomato"                  => "ff6347",
  "tomato1"                 => "ff6347",
  "tomato2"                 => "ee5c42",
  "tomato3"                 => "cd4f39",
  "tomato4"                 => "8b3626",
  "truered"                 => "bc243c",
  "ttc"                     => "00ff99",
  "ttg"                     => "00ff66",
  "tumbleweed"              => "b98a64",
  "turmeric"                => "fe840e",
  "turquoise"               => "40e0d0",
  "turquoise1"              => "00f5ff",
  "turquoise2"              => "00e5ee",
  "turquoise3"              => "00c5cd",
  "turquoise4"              => "00868b",
  "ultimategray"            => "96999b",
  "ultramarineblue"         => "657abb",
  "ultramarinegreen"        => "006b54",
  "ultraviolet"             => "6b5b95",
  "umberbrown"              => 613936,
  "valiantpoppy"            => "bd3d3a",
  "vanillacustard"          => "f3e0be",
  "veinousbloodred"         => "3f3033",
  "velvetblack"             => "241f20",
  "verdigrisgreen"          => "61ac86",
  "verditterblue"           => "6fb5a8",
  "vermilionred"            => "b5493a",
  "verydarkbrown"           => "5c4033",
  "verylightgrey"           => "cdcdcd",
  "veryperi"                => "696aad",
  "violet"                  => "ee82ee",
  "violet-violet-blue"      => "6600ff",
  "violet-violet-magenta"   => "9900ff",
  "violetpurple"            => "3a2f52",
  "violetred"               => "e82362",
  "violetred1"              => "ff3e96",
  "violetred2"              => "ee3a8c",
  "violetred3"              => "cd3278",
  "violetred4"              => "8b2252",
  "violetvioletblue"        => "6600ff",
  "violetvioletmagenta"     => "9900ff",
  "vvb"                     => "6600ff",
  "vvm"                     => "9900ff",
  "w"                       => "ffffff",
  "warmsand"                => "c0ab8e",
  "warmtaupe"               => "af9483",
  "waterspout"              => "93dbe0",
  "waxyellow"               => "ab9649",
  "webgray"                 => 808080,
  "webgreen"                => "008000",
  "webgrey"                 => 808080,
  "webmaroon"               => 800000,
  "webpurple"               => 800080,
  "wheat"                   => "f5deb3",
  "wheat1"                  => "ffe7ba",
  "wheat2"                  => "eed8ae",
  "wheat3"                  => "cdba96",
  "wheat4"                  => "8b7e66",
  "white"                   => "ffffff",
  "whitesmoke"              => "f5f5f5",
  "willow"                  => "9a8b4f",
  "wineyellow"              => "d7c485",
  "wistera"                 => "b681cf",
  "woodbrown"               => "c39e6d",
  "x11gray"                 => "bebebe",
  "x11green"                => "00ff00",
  "x11grey"                 => "bebebe",
  "x11maroon"               => "b03060",
  "x11purple"               => "a020f0",
  "y"                       => "ffff00",
  "yellow"                  => "ffff00",
  "yellow-yellow-orange"    => "ffcc00",
  "yellow-yellow-spring"    => "ccff00",
  "yellow1"                 => "ffff00",
  "yellow2"                 => "eeee00",
  "yellow3"                 => "cdcd00",
  "yellow4"                 => "8b8b00",
  "yellowgreen"             => "9acd32",
  "yellowishbrown"          => 946943,
  "yellowishgrey"           => "bab191",
  "yellowishwhite"          => "f2eacc",
  "yelloworange"            => "f59506",
  "yellowyelloworange"      => "ffcc00",
  "yellowyellowspring"      => "ccff00",
  "yyo"                     => "ffcc00",
  "yys"                     => "ccff00",
}
;

our $NAMES_SUMMARY_TABLE = {
  "aab"                     => "from VACCC",
  "aac"                     => "from VACCC",
  "airyblue"                => "from PantoneReport",
  "aliceblue"               => "from CSS",
  "almondbuff"              => "from PantoneReport",
  "almostmauve"             => "from PantoneReport",
  "amazon"                  => "from PantoneReport",
  "amberglow"               => "from PantoneReport",
  "amethystorchid"          => "from PantoneReport",
  "antiquewhite"            => "from CSS",
  "antiquewhite1"           => "from X",
  "antiquewhite2"           => "from X",
  "antiquewhite3"           => "from X",
  "antiquewhite4"           => "from X",
  "applegreen"              => "from Werner",
  "apricot"                 => "from Crayola",
  "aqua"                    => "from CSS",
  "aquamarine"              => "from CSS",
  "aquamarine1"             => "from X",
  "aquamarine2"             => "from X",
  "aquamarine3"             => "from X",
  "aquamarine4"             => "from X",
  "aquasky"                 => "from PantoneReport",
  "arcadia"                 => "from PantoneReport",
  "arcticwolf"              => "from PantoneReport",
  "arterialbloodred"        => "from Werner",
  "ash"                     => "from PantoneReport",
  "ashgrey"                 => "from Werner",
  "asparagusgreen"          => "from Werner",
  "aspengold"               => "from PantoneReport",
  "auriculapurple"          => "from Werner",
  "aurorared"               => "from PantoneReport",
  "autumnblonde"            => "from PantoneReport",
  "autumnmaple"             => "from PantoneReport",
  "azure"                   => "from CSS",
  "azure-azure-blue"        => "from VACCC",
  "azure-azure-cyan"        => "from VACCC",
  "azure1"                  => "from X",
  "azure2"                  => "from X",
  "azure3"                  => "from X",
  "azure4"                  => "from X",
  "azureazureblue"          => "from VACCC",
  "azureazurecyan"          => "from VACCC",
  "azureblue"               => "from Werner",
  "b"                       => "from VACCC",
  "bakerschocolate"         => "from Netscape",
  "balletslipper"           => "from PantoneReport",
  "basil"                   => "from PantoneReport",
  "bba"                     => "from VACCC",
  "bbv"                     => "from VACCC",
  "beige"                   => "from CSS",
  "berlinblue"              => "from Werner",
  "bikingred"               => "from PantoneReport",
  "biscaygreen"             => "from PantoneReport",
  "bisque"                  => "from CSS",
  "bisque1"                 => "from X",
  "bisque2"                 => "from X",
  "bisque3"                 => "from X",
  "bisque4"                 => "from X",
  "black"                   => "from CSS",
  "blackishbrown"           => "from Werner",
  "blackishgreen"           => "from Werner",
  "blackishgrey"            => "from Werner",
  "blanchedalmond"          => "from CSS",
  "bloomingdahlia"          => "from PantoneReport",
  "blue"                    => "from CSS",
  "blue-blue-azure"         => "from VACCC",
  "blue-blue-violet"        => "from VACCC",
  "blue1"                   => "from X",
  "blue2"                   => "from X",
  "blue3"                   => "from X",
  "blue4"                   => "from X",
  "blueblueazure"           => "from VACCC",
  "blueblueviolet"          => "from VACCC",
  "bluegreen"               => "from Crayola",
  "bluegrey"                => "from EmergyC",
  "blueizis"                => "from PantoneReport",
  "bluestone"               => "from PantoneReport",
  "blueturquoise"           => "from PantoneReport",
  "blueviolet"              => "from CSS",
  "bluishblack"             => "from Werner",
  "bluishgreen"             => "from Werner",
  "bluishgrey"              => "from Werner",
  "bluishlilacpurple"       => "from Werner",
  "bluishpurple"            => "from Werner",
  "bodacious"               => "from PantoneReport",
  "brass"                   => "from Netscape",
  "brightgold"              => "from Netscape",
  "brilliantwhite"          => "from PantoneReport",
  "broccolibrown"           => "from Werner",
  "bronze"                  => "from Netscape",
  "bronzeii"                => "from Netscape",
  "brown"                   => "from CSS",
  "brown1"                  => "from X",
  "brown2"                  => "from X",
  "brown3"                  => "from X",
  "brown4"                  => "from X",
  "browngranite"            => "from PantoneReport",
  "brownishorange"          => "from Werner",
  "brownishpurplered"       => "from Werner",
  "brownishred"             => "from Werner",
  "bufforange"              => "from Werner",
  "burlywood"               => "from CSS",
  "burlywood1"              => "from X",
  "burlywood2"              => "from X",
  "burlywood3"              => "from X",
  "burlywood4"              => "from X",
  "burntcoral"              => "from PantoneReport",
  "burntsienna"             => "from Crayola",
  "buttercream"             => "from PantoneReport",
  "buttercup"               => "from PantoneReport",
  "butterum"                => "from PantoneReport",
  "c"                       => "from VACCC",
  "cadetblue"               => "from CSS",
  "cadetblue1"              => "from X",
  "cadetblue2"              => "from X",
  "cadetblue3"              => "from X",
  "cadetblue4"              => "from X",
  "campanulapurple"         => "from Werner",
  "caramelcafe"             => "from PantoneReport",
  "carminered"              => "from Werner",
  "carnationpink"           => "from Crayola",
  "cca"                     => "from VACCC",
  "cct"                     => "from VACCC",
  "celadinegreen"           => "from Werner",
  "cerulean"                => "from PantoneReport",
  "ceruleanblue"            => "from PantoneReport",
  "cerulian"                => "from Crayola",
  "ceylonyellow"            => "from PantoneReport",
  "chartreuse"              => "from CSS",
  "chartreuse1"             => "from X",
  "chartreuse2"             => "from X",
  "chartreuse3"             => "from X",
  "chartreuse4"             => "from X",
  "cherrytomato"            => "from PantoneReport",
  "chestnut"                => "from Crayola",
  "chestnutbrown"           => "from Werner",
  "chilioil"                => "from PantoneReport",
  "chilipepper"             => "from PantoneReport",
  "chinablue"               => "from Werner",
  "chiseledstone"           => "from PantoneReport",
  "chive"                   => "from PantoneReport",
  "chocolate"               => "from CSS",
  "chocolate1"              => "from X",
  "chocolate2"              => "from X",
  "chocolate3"              => "from X",
  "chocolate4"              => "from X",
  "chocolatered"            => "from Werner",
  "cinnamonstic"            => "from PantoneReport",
  "classicblue"             => "from PantoneReport",
  "clovebrown"              => "from Werner",
  "cobalt"                  => "from EmergyC",
  "cocamocha"               => "from PantoneReport",
  "cochinealred"            => "from Werner",
  "coconutmilk"             => "from PantoneReport",
  "coolcopper"              => "from Netscape",
  "copper"                  => "from Netscape",
  "coral"                   => "from CSS",
  "coral1"                  => "from X",
  "coral2"                  => "from X",
  "coral3"                  => "from X",
  "coral4"                  => "from X",
  "coralpink"               => "from PantoneReport",
  "cornflower"              => "from Crayola",
  "cornflowerblue"          => "from CSS",
  "cornsilk"                => "from CSS",
  "cornsilk1"               => "from X",
  "cornsilk2"               => "from X",
  "cornsilk3"               => "from X",
  "cornsilk4"               => "from X",
  "creamyellow"             => "from Werner",
  "cremedepeche"            => "from PantoneReport",
  "crimson"                 => "from CSS",
  "crimsonred"              => "from Werner",
  "crocuspetal"             => "from PantoneReport",
  "cyan"                    => "from CSS",
  "cyan-cyan-azure"         => "from VACCC",
  "cyan-cyan-teal"          => "from VACCC",
  "cyan1"                   => "from X",
  "cyan2"                   => "from X",
  "cyan3"                   => "from X",
  "cyan4"                   => "from X",
  "cyancyanazure"           => "from VACCC",
  "cyancyanteal"            => "from VACCC",
  "dab"                     => "from VACCC",
  "dac"                     => "from VACCC",
  "daffodil"                => "from PantoneReport",
  "dahliamauve"             => "from PantoneReport",
  "dandelion"               => "from Crayola",
  "dark azure-blue"         => "from VACCC",
  "dark azure-cyan"         => "from VACCC",
  "dark blue-azure"         => "from VACCC",
  "dark blue-violet"        => "from VACCC",
  "dark cyan-azure"         => "from VACCC",
  "dark cyan-teal"          => "from VACCC",
  "dark dull azure"         => "from VACCC",
  "dark dull blue"          => "from VACCC",
  "dark dull cyan"          => "from VACCC",
  "dark dull green"         => "from VACCC",
  "dark dull magenta"       => "from VACCC",
  "dark dull orange"        => "from VACCC",
  "dark dull pink"          => "from VACCC",
  "dark dull red"           => "from VACCC",
  "dark dull spring"        => "from VACCC",
  "dark dull teal"          => "from VACCC",
  "dark dull violet"        => "from VACCC",
  "dark dull yellow"        => "from VACCC",
  "dark faded blue"         => "from VACCC",
  "dark faded cyan"         => "from VACCC",
  "dark faded green"        => "from VACCC",
  "dark faded magenta"      => "from VACCC",
  "dark faded red"          => "from VACCC",
  "dark faded yellow"       => "from VACCC",
  "dark gray"               => "from VACCC",
  "dark green-spring"       => "from VACCC",
  "dark green-teal"         => "from VACCC",
  "dark hard azure"         => "from VACCC",
  "dark hard blue"          => "from VACCC",
  "dark hard cyan"          => "from VACCC",
  "dark hard green"         => "from VACCC",
  "dark hard magenta"       => "from VACCC",
  "dark hard orange"        => "from VACCC",
  "dark hard pink"          => "from VACCC",
  "dark hard red"           => "from VACCC",
  "dark hard spring"        => "from VACCC",
  "dark hard teal"          => "from VACCC",
  "dark hard violet"        => "from VACCC",
  "dark hard yellow"        => "from VACCC",
  "dark magenta-pink"       => "from VACCC",
  "dark magenta-violet"     => "from VACCC",
  "dark orange-red"         => "from VACCC",
  "dark orange-yellow"      => "from VACCC",
  "dark pink-magenta"       => "from VACCC",
  "dark pink-red"           => "from VACCC",
  "dark red-orange"         => "from VACCC",
  "dark red-pink"           => "from VACCC",
  "dark spring-green"       => "from VACCC",
  "dark spring-yellow"      => "from VACCC",
  "dark teal-cyan"          => "from VACCC",
  "dark teal-green"         => "from VACCC",
  "dark violet-blue"        => "from VACCC",
  "dark violet-magenta"     => "from VACCC",
  "dark weak blue"          => "from VACCC",
  "dark weak cyan"          => "from VACCC",
  "dark weak green"         => "from VACCC",
  "dark weak magenta"       => "from VACCC",
  "dark weak red"           => "from VACCC",
  "dark weak yellow"        => "from VACCC",
  "dark yellow-orange"      => "from VACCC",
  "dark yellow-spring"      => "from VACCC",
  "darkazure-blue"          => "from VACCC",
  "darkazure-cyan"          => "from VACCC",
  "darkazureblue"           => "from VACCC",
  "darkazurecyan"           => "from VACCC",
  "darkblue"                => "from CSS",
  "darkblue-azure"          => "from VACCC",
  "darkblue-violet"         => "from VACCC",
  "darkblueazure"           => "from VACCC",
  "darkblueviolet"          => "from VACCC",
  "darkbrown"               => "from Netscape",
  "darkcheddar"             => "from PantoneReport",
  "darkcyan"                => "from CSS",
  "darkcyan-azure"          => "from VACCC",
  "darkcyan-teal"           => "from VACCC",
  "darkcyanazure"           => "from VACCC",
  "darkcyanteal"            => "from VACCC",
  "darkdullazure"           => "from VACCC",
  "darkdullblue"            => "from VACCC",
  "darkdullcyan"            => "from VACCC",
  "darkdullgreen"           => "from VACCC",
  "darkdullmagenta"         => "from VACCC",
  "darkdullorange"          => "from VACCC",
  "darkdullpink"            => "from VACCC",
  "darkdullred"             => "from VACCC",
  "darkdullspring"          => "from VACCC",
  "darkdullteal"            => "from VACCC",
  "darkdullviolet"          => "from VACCC",
  "darkdullyellow"          => "from VACCC",
  "darkfadedblue"           => "from VACCC",
  "darkfadedcyan"           => "from VACCC",
  "darkfadedgreen"          => "from VACCC",
  "darkfadedmagenta"        => "from VACCC",
  "darkfadedred"            => "from VACCC",
  "darkfadedyellow"         => "from VACCC",
  "darkgoldenrod"           => "from CSS",
  "darkgoldenrod1"          => "from X",
  "darkgoldenrod2"          => "from X",
  "darkgoldenrod3"          => "from X",
  "darkgoldenrod4"          => "from X",
  "darkgray"                => "from CSS",
  "darkgreen"               => "from CSS",
  "darkgreen-spring"        => "from VACCC",
  "darkgreen-teal"          => "from VACCC",
  "darkgreencopper"         => "from Netscape",
  "darkgreenspring"         => "from VACCC",
  "darkgreenteal"           => "from VACCC",
  "darkgrey"                => "from CSS",
  "darkhardazure"           => "from VACCC",
  "darkhardblue"            => "from VACCC",
  "darkhardcyan"            => "from VACCC",
  "darkhardgreen"           => "from VACCC",
  "darkhardmagenta"         => "from VACCC",
  "darkhardorange"          => "from VACCC",
  "darkhardpink"            => "from VACCC",
  "darkhardred"             => "from VACCC",
  "darkhardspring"          => "from VACCC",
  "darkhardteal"            => "from VACCC",
  "darkhardviolet"          => "from VACCC",
  "darkhardyellow"          => "from VACCC",
  "darkkhaki"               => "from CSS",
  "darkmagenta"             => "from CSS",
  "darkmagenta-pink"        => "from VACCC",
  "darkmagenta-violet"      => "from VACCC",
  "darkmagentapink"         => "from VACCC",
  "darkmagentaviolet"       => "from VACCC",
  "darkolivegreen"          => "from CSS",
  "darkolivegreen1"         => "from X",
  "darkolivegreen2"         => "from X",
  "darkolivegreen3"         => "from X",
  "darkolivegreen4"         => "from X",
  "darkorange"              => "from CSS",
  "darkorange-red"          => "from VACCC",
  "darkorange-yellow"       => "from VACCC",
  "darkorange1"             => "from X",
  "darkorange2"             => "from X",
  "darkorange3"             => "from X",
  "darkorange4"             => "from X",
  "darkorangered"           => "from VACCC",
  "darkorangeyellow"        => "from VACCC",
  "darkorchid"              => "from CSS",
  "darkorchid1"             => "from X",
  "darkorchid2"             => "from X",
  "darkorchid3"             => "from X",
  "darkorchid4"             => "from X",
  "darkpink-magenta"        => "from VACCC",
  "darkpink-red"            => "from VACCC",
  "darkpinkmagenta"         => "from VACCC",
  "darkpinkred"             => "from VACCC",
  "darkpurple"              => "from Netscape",
  "darkred"                 => "from CSS",
  "darkred-orange"          => "from VACCC",
  "darkred-pink"            => "from VACCC",
  "darkredorange"           => "from VACCC",
  "darkredpink"             => "from VACCC",
  "darksalmon"              => "from CSS",
  "darkseagreen"            => "from CSS",
  "darkseagreen1"           => "from X",
  "darkseagreen2"           => "from X",
  "darkseagreen3"           => "from X",
  "darkseagreen4"           => "from X",
  "darkslateblue"           => "from CSS",
  "darkslategray"           => "from CSS",
  "darkslategray1"          => "from X",
  "darkslategray2"          => "from X",
  "darkslategray3"          => "from X",
  "darkslategray4"          => "from X",
  "darkslategrey"           => "from CSS",
  "darkspring-green"        => "from VACCC",
  "darkspring-yellow"       => "from VACCC",
  "darkspringgreen"         => "from VACCC",
  "darkspringyellow"        => "from VACCC",
  "darktan"                 => "from Netscape",
  "darkteal-cyan"           => "from VACCC",
  "darkteal-green"          => "from VACCC",
  "darktealcyan"            => "from VACCC",
  "darktealgreen"           => "from VACCC",
  "darkturquoise"           => "from CSS",
  "darkviolet"              => "from CSS",
  "darkviolet-blue"         => "from VACCC",
  "darkviolet-magenta"      => "from VACCC",
  "darkvioletblue"          => "from VACCC",
  "darkvioletmagenta"       => "from VACCC",
  "darkweakblue"            => "from VACCC",
  "darkweakcyan"            => "from VACCC",
  "darkweakgreen"           => "from VACCC",
  "darkweakmagenta"         => "from VACCC",
  "darkweakred"             => "from VACCC",
  "darkweakyellow"          => "from VACCC",
  "darkwood"                => "from Netscape",
  "darkyellow"              => "from Windows",
  "darkyellow-orange"       => "from VACCC",
  "darkyellow-spring"       => "from VACCC",
  "darkyelloworange"        => "from VACCC",
  "darkyellowspring"        => "from VACCC",
  "dba"                     => "from VACCC",
  "dbv"                     => "from VACCC",
  "dca"                     => "from VACCC",
  "dct"                     => "from VACCC",
  "dda"                     => "from VACCC",
  "ddb"                     => "from VACCC",
  "ddc"                     => "from VACCC",
  "ddg"                     => "from VACCC",
  "ddm"                     => "from VACCC",
  "ddo"                     => "from VACCC",
  "ddp"                     => "from VACCC",
  "ddr"                     => "from VACCC",
  "dds"                     => "from VACCC",
  "ddt"                     => "from VACCC",
  "ddv"                     => "from VACCC",
  "ddy"                     => "from VACCC",
  "deeporangecolouredbrown" => "from Werner",
  "deeppink"                => "from CSS",
  "deeppink1"               => "from X",
  "deeppink2"               => "from X",
  "deeppink3"               => "from X",
  "deeppink4"               => "from X",
  "deepreddishbrown"        => "from Werner",
  "deepreddishorange"       => "from Werner",
  "deepskyblue"             => "from CSS",
  "deepskyblue1"            => "from X",
  "deepskyblue2"            => "from X",
  "deepskyblue3"            => "from X",
  "deepskyblue4"            => "from X",
  "desertmist"              => "from PantoneReport",
  "dfb"                     => "from VACCC",
  "dfc"                     => "from VACCC",
  "dfg"                     => "from VACCC",
  "dfm"                     => "from VACCC",
  "dfr"                     => "from VACCC",
  "dfy"                     => "from VACCC",
  "dg"                      => "from VACCC",
  "dgs"                     => "from VACCC",
  "dgt"                     => "from VACCC",
  "dha"                     => "from VACCC",
  "dhb"                     => "from VACCC",
  "dhc"                     => "from VACCC",
  "dhg"                     => "from VACCC",
  "dhm"                     => "from VACCC",
  "dho"                     => "from VACCC",
  "dhp"                     => "from VACCC",
  "dhr"                     => "from VACCC",
  "dhs"                     => "from VACCC",
  "dht"                     => "from VACCC",
  "dhv"                     => "from VACCC",
  "dhy"                     => "from VACCC",
  "dimgray"                 => "from CSS",
  "dimgrey"                 => "from CSS",
  "dmp"                     => "from VACCC",
  "dmv"                     => "from VACCC",
  "dodgerblue"              => "from CSS",
  "dodgerblue1"             => "from X",
  "dodgerblue2"             => "from X",
  "dodgerblue3"             => "from X",
  "dodgerblue4"             => "from X",
  "dor"                     => "from VACCC",
  "doy"                     => "from VACCC",
  "dpm"                     => "from VACCC",
  "dpr"                     => "from VACCC",
  "dro"                     => "from VACCC",
  "drp"                     => "from VACCC",
  "dsg"                     => "from VACCC",
  "dsy"                     => "from VACCC",
  "dtc"                     => "from VACCC",
  "dtg"                     => "from VACCC",
  "duckgreen"               => "from Werner",
  "dustycedar"              => "from PantoneReport",
  "dustyrose"               => "from Netscape",
  "dutchorange"             => "from Werner",
  "dvb"                     => "from VACCC",
  "dvm"                     => "from VACCC",
  "dwb"                     => "from VACCC",
  "dwc"                     => "from VACCC",
  "dwg"                     => "from VACCC",
  "dwm"                     => "from VACCC",
  "dwr"                     => "from VACCC",
  "dwy"                     => "from VACCC",
  "dyo"                     => "from VACCC",
  "dys"                     => "from VACCC",
  "eclipse"                 => "from PantoneReport",
  "eden"                    => "from PantoneReport",
  "emerald"                 => "from PantoneReport",
  "emeraldgreen"            => "from Werner",
  "emperador"               => "from PantoneReport",
  "eveningblue"             => "from PantoneReport",
  "fadeddenim"              => "from PantoneReport",
  "feldspar"                => "from Netscape",
  "fiesta"                  => "from PantoneReport",
  "firebrick"               => "from CSS",
  "firebrick1"              => "from X",
  "firebrick2"              => "from X",
  "firebrick3"              => "from X",
  "firebrick4"              => "from X",
  "firedbrick"              => "from PantoneReport",
  "flame"                   => "from PantoneReport",
  "flamescarlet"            => "from PantoneReport",
  "flaxflowerblue"          => "from Werner",
  "flesh"                   => "from Netscape",
  "fleshred"                => "from Werner",
  "floralwhite"             => "from CSS",
  "forestgreen"             => "from CSS",
  "frenchblue"              => "from PantoneReport",
  "frenchgrey"              => "from Werner",
  "fruitdove"               => "from PantoneReport",
  "fuchsia"                 => "from CSS",
  "fuchsiarose"             => "from PantoneReport",
  "fuscia"                  => "from CSS",
  "g"                       => "from VACCC",
  "gainsboro"               => "from CSS",
  "galaxyblue"              => "from PantoneReport",
  "gallstoneyellow"         => "from Werner",
  "gambogeyellow"           => "from Werner",
  "ggs"                     => "from VACCC",
  "ggt"                     => "from VACCC",
  "ghostwhite"              => "from CSS",
  "glacierlake"             => "from PantoneReport",
  "gold"                    => "from CSS",
  "gold1"                   => "from X",
  "gold2"                   => "from X",
  "gold3"                   => "from X",
  "gold4"                   => "from X",
  "goldenlime"              => "from PantoneReport",
  "goldenrod"               => "from CSS",
  "goldenrod1"              => "from X",
  "goldenrod2"              => "from X",
  "goldenrod3"              => "from X",
  "goldenrod4"              => "from X",
  "gossamerpink"            => "from PantoneReport",
  "grannysmithapple"        => "from Crayola",
  "grapecompote"            => "from PantoneReport",
  "grassgreen"              => "from Werner",
  "gray"                    => "from CSS",
  "gray0"                   => "from X",
  "gray1"                   => "from X",
  "gray10"                  => "from X",
  "gray100"                 => "from X",
  "gray11"                  => "from X",
  "gray12"                  => "from X",
  "gray13"                  => "from X",
  "gray14"                  => "from X",
  "gray15"                  => "from X",
  "gray16"                  => "from X",
  "gray17"                  => "from X",
  "gray18"                  => "from X",
  "gray19"                  => "from X",
  "gray2"                   => "from X",
  "gray20"                  => "from X",
  "gray21"                  => "from X",
  "gray22"                  => "from X",
  "gray23"                  => "from X",
  "gray24"                  => "from X",
  "gray25"                  => "from X",
  "gray26"                  => "from X",
  "gray27"                  => "from X",
  "gray28"                  => "from X",
  "gray29"                  => "from X",
  "gray3"                   => "from X",
  "gray30"                  => "from X",
  "gray31"                  => "from X",
  "gray32"                  => "from X",
  "gray33"                  => "from X",
  "gray34"                  => "from X",
  "gray35"                  => "from X",
  "gray36"                  => "from X",
  "gray37"                  => "from X",
  "gray38"                  => "from X",
  "gray39"                  => "from X",
  "gray4"                   => "from X",
  "gray40"                  => "from X",
  "gray41"                  => "from X",
  "gray42"                  => "from X",
  "gray43"                  => "from X",
  "gray44"                  => "from X",
  "gray45"                  => "from X",
  "gray46"                  => "from X",
  "gray47"                  => "from X",
  "gray48"                  => "from X",
  "gray49"                  => "from X",
  "gray5"                   => "from X",
  "gray50"                  => "from X",
  "gray51"                  => "from X",
  "gray52"                  => "from X",
  "gray53"                  => "from X",
  "gray54"                  => "from X",
  "gray55"                  => "from X",
  "gray56"                  => "from X",
  "gray57"                  => "from X",
  "gray58"                  => "from X",
  "gray59"                  => "from X",
  "gray6"                   => "from X",
  "gray60"                  => "from X",
  "gray61"                  => "from X",
  "gray62"                  => "from X",
  "gray63"                  => "from X",
  "gray64"                  => "from X",
  "gray65"                  => "from X",
  "gray66"                  => "from X",
  "gray67"                  => "from X",
  "gray68"                  => "from X",
  "gray69"                  => "from X",
  "gray7"                   => "from X",
  "gray70"                  => "from X",
  "gray71"                  => "from X",
  "gray72"                  => "from X",
  "gray73"                  => "from X",
  "gray74"                  => "from X",
  "gray75"                  => "from X",
  "gray76"                  => "from X",
  "gray77"                  => "from X",
  "gray78"                  => "from X",
  "gray79"                  => "from X",
  "gray8"                   => "from X",
  "gray80"                  => "from X",
  "gray81"                  => "from X",
  "gray82"                  => "from X",
  "gray83"                  => "from X",
  "gray84"                  => "from X",
  "gray85"                  => "from X",
  "gray86"                  => "from X",
  "gray87"                  => "from X",
  "gray88"                  => "from X",
  "gray89"                  => "from X",
  "gray9"                   => "from X",
  "gray90"                  => "from X",
  "gray91"                  => "from X",
  "gray92"                  => "from X",
  "gray93"                  => "from X",
  "gray94"                  => "from X",
  "gray95"                  => "from X",
  "gray96"                  => "from X",
  "gray97"                  => "from X",
  "gray98"                  => "from X",
  "gray99"                  => "from X",
  "green"                   => "from CSS",
  "green-green-spring"      => "from VACCC",
  "green-green-teal"        => "from VACCC",
  "green1"                  => "from X",
  "green2"                  => "from X",
  "green3"                  => "from X",
  "green4"                  => "from X",
  "greenash"                => "from PantoneReport",
  "greencopper"             => "from Netscape",
  "greenflash"              => "from PantoneReport",
  "greengreenspring"        => "from VACCC",
  "greengreenteal"          => "from VACCC",
  "greenishblack"           => "from Werner",
  "greenishblue"            => "from Werner",
  "greenishgrey"            => "from Werner",
  "greenishwhite"           => "from Werner",
  "greensheen"              => "from PantoneReport",
  "greenyellow"             => "from CSS",
  "grenadine"               => "from PantoneReport",
  "grey"                    => "from CSS",
  "grey0"                   => "from X",
  "grey1"                   => "from X",
  "grey10"                  => "from X",
  "grey100"                 => "from X",
  "grey11"                  => "from X",
  "grey12"                  => "from X",
  "grey13"                  => "from X",
  "grey14"                  => "from X",
  "grey15"                  => "from X",
  "grey16"                  => "from X",
  "grey17"                  => "from X",
  "grey18"                  => "from X",
  "grey19"                  => "from X",
  "grey2"                   => "from X",
  "grey20"                  => "from X",
  "grey21"                  => "from X",
  "grey22"                  => "from X",
  "grey23"                  => "from X",
  "grey24"                  => "from X",
  "grey25"                  => "from X",
  "grey26"                  => "from X",
  "grey27"                  => "from X",
  "grey28"                  => "from X",
  "grey29"                  => "from X",
  "grey3"                   => "from X",
  "grey30"                  => "from X",
  "grey31"                  => "from X",
  "grey32"                  => "from X",
  "grey33"                  => "from X",
  "grey34"                  => "from X",
  "grey35"                  => "from X",
  "grey36"                  => "from X",
  "grey37"                  => "from X",
  "grey38"                  => "from X",
  "grey39"                  => "from X",
  "grey4"                   => "from X",
  "grey40"                  => "from X",
  "grey41"                  => "from X",
  "grey42"                  => "from X",
  "grey43"                  => "from X",
  "grey44"                  => "from X",
  "grey45"                  => "from X",
  "grey46"                  => "from X",
  "grey47"                  => "from X",
  "grey48"                  => "from X",
  "grey49"                  => "from X",
  "grey5"                   => "from X",
  "grey50"                  => "from X",
  "grey51"                  => "from X",
  "grey52"                  => "from X",
  "grey53"                  => "from X",
  "grey54"                  => "from X",
  "grey55"                  => "from X",
  "grey56"                  => "from X",
  "grey57"                  => "from X",
  "grey58"                  => "from X",
  "grey59"                  => "from X",
  "grey6"                   => "from X",
  "grey60"                  => "from X",
  "grey61"                  => "from X",
  "grey62"                  => "from X",
  "grey63"                  => "from X",
  "grey64"                  => "from X",
  "grey65"                  => "from X",
  "grey66"                  => "from X",
  "grey67"                  => "from X",
  "grey68"                  => "from X",
  "grey69"                  => "from X",
  "grey7"                   => "from X",
  "grey70"                  => "from X",
  "grey71"                  => "from X",
  "grey72"                  => "from X",
  "grey73"                  => "from X",
  "grey74"                  => "from X",
  "grey75"                  => "from X",
  "grey76"                  => "from X",
  "grey77"                  => "from X",
  "grey78"                  => "from X",
  "grey79"                  => "from X",
  "grey8"                   => "from X",
  "grey80"                  => "from X",
  "grey81"                  => "from X",
  "grey82"                  => "from X",
  "grey83"                  => "from X",
  "grey84"                  => "from X",
  "grey85"                  => "from X",
  "grey86"                  => "from X",
  "grey87"                  => "from X",
  "grey88"                  => "from X",
  "grey89"                  => "from X",
  "grey9"                   => "from X",
  "grey90"                  => "from X",
  "grey91"                  => "from X",
  "grey92"                  => "from X",
  "grey93"                  => "from X",
  "grey94"                  => "from X",
  "grey95"                  => "from X",
  "grey96"                  => "from X",
  "grey97"                  => "from X",
  "grey98"                  => "from X",
  "grey99"                  => "from X",
  "greyishblack"            => "from Werner",
  "greyishblue"             => "from Werner",
  "greyishwhite"            => "from Werner",
  "guacamole"               => "from PantoneReport",
  "hairbrown"               => "from Werner",
  "harborblue"              => "from PantoneReport",
  "harbormist"              => "from PantoneReport",
  "hazelnut"                => "from PantoneReport",
  "honeydew"                => "from CSS",
  "honeydew1"               => "from X",
  "honeydew2"               => "from X",
  "honeydew3"               => "from X",
  "honeydew4"               => "from X",
  "honeysucle"              => "from PantoneReport",
  "honeyyellow"             => "from Werner",
  "hotpink"                 => "from CSS",
  "hotpink1"                => "from X",
  "hotpink2"                => "from X",
  "hotpink3"                => "from X",
  "hotpink4"                => "from X",
  "huntergreen"             => "from Netscape",
  "hyacinthred"             => "from Werner",
  "icedcoffee"              => "from PantoneReport",
  "illuminating"            => "from PantoneReport",
  "imperialpurple"          => "from Werner",
  "indianred"               => "from CSS",
  "indianred1"              => "from X",
  "indianred2"              => "from X",
  "indianred3"              => "from X",
  "indianred4"              => "from X",
  "indigo"                  => "from CSS",
  "indigoblue"              => "from Werner",
  "inkblack"                => "from Werner",
  "inkwell"                 => "from PantoneReport",
  "innuendo"                => "from PantoneReport",
  "islandparadise"          => "from PantoneReport",
  "ivory"                   => "from CSS",
  "ivory1"                  => "from X",
  "ivory2"                  => "from X",
  "ivory3"                  => "from X",
  "ivory4"                  => "from X",
  "jesterred"               => "from PantoneReport",
  "k"                       => "from VACCC",
  "kale"                    => "from PantoneReport",
  "khaki"                   => "from CSS",
  "khaki1"                  => "from X",
  "khaki2"                  => "from X",
  "khaki3"                  => "from X",
  "khaki4"                  => "from X",
  "kingsyellow"             => "from Werner",
  "lab"                     => "from VACCC",
  "lac"                     => "from VACCC",
  "lakered"                 => "from Werner",
  "lapisblue"               => "from PantoneReport",
  "lark"                    => "from PantoneReport",
  "lavafalls"               => "from PantoneReport",
  "lavender"                => "from CSS",
  "lavenderblush"           => "from CSS",
  "lavenderblush1"          => "from X",
  "lavenderblush2"          => "from X",
  "lavenderblush3"          => "from X",
  "lavenderblush4"          => "from X",
  "lavenderpurple"          => "from Werner",
  "lawngreen"               => "from CSS",
  "lba"                     => "from VACCC",
  "lbv"                     => "from VACCC",
  "lca"                     => "from VACCC",
  "lct"                     => "from VACCC",
  "lda"                     => "from VACCC",
  "ldb"                     => "from VACCC",
  "ldc"                     => "from VACCC",
  "ldg"                     => "from VACCC",
  "ldm"                     => "from VACCC",
  "ldo"                     => "from VACCC",
  "ldp"                     => "from VACCC",
  "ldr"                     => "from VACCC",
  "lds"                     => "from VACCC",
  "ldt"                     => "from VACCC",
  "ldv"                     => "from VACCC",
  "ldy"                     => "from VACCC",
  "leekgreen"               => "from Werner",
  "lemonchiffon"            => "from CSS",
  "lemonchiffon1"           => "from X",
  "lemonchiffon2"           => "from X",
  "lemonchiffon3"           => "from X",
  "lemonchiffon4"           => "from X",
  "lemonyellow"             => "from Werner",
  "lfb"                     => "from VACCC",
  "lfc"                     => "from VACCC",
  "lfg"                     => "from VACCC",
  "lfm"                     => "from VACCC",
  "lfr"                     => "from VACCC",
  "lfy"                     => "from VACCC",
  "lg"                      => "from VACCC",
  "lgs"                     => "from VACCC",
  "lgt"                     => "from VACCC",
  "lha"                     => "from VACCC",
  "lhb"                     => "from VACCC",
  "lhc"                     => "from VACCC",
  "lhg"                     => "from VACCC",
  "lhm"                     => "from VACCC",
  "lho"                     => "from VACCC",
  "lhp"                     => "from VACCC",
  "lhr"                     => "from VACCC",
  "lhs"                     => "from VACCC",
  "lht"                     => "from VACCC",
  "lhv"                     => "from VACCC",
  "lhy"                     => "from VACCC",
  "light azure-blue"        => "from VACCC",
  "light azure-cyan"        => "from VACCC",
  "light blue-azure"        => "from VACCC",
  "light blue-violet"       => "from VACCC",
  "light cyan-azure"        => "from VACCC",
  "light cyan-teal"         => "from VACCC",
  "light dull azure"        => "from VACCC",
  "light dull blue"         => "from VACCC",
  "light dull cyan"         => "from VACCC",
  "light dull green"        => "from VACCC",
  "light dull magenta"      => "from VACCC",
  "light dull orange"       => "from VACCC",
  "light dull pink"         => "from VACCC",
  "light dull red"          => "from VACCC",
  "light dull spring"       => "from VACCC",
  "light dull teal"         => "from VACCC",
  "light dull violet"       => "from VACCC",
  "light dull yellow"       => "from VACCC",
  "light faded blue"        => "from VACCC",
  "light faded cyan"        => "from VACCC",
  "light faded green"       => "from VACCC",
  "light faded magenta"     => "from VACCC",
  "light faded red"         => "from VACCC",
  "light faded yellow"      => "from VACCC",
  "light gray"              => "from VACCC",
  "light green-spring"      => "from VACCC",
  "light green-teal"        => "from VACCC",
  "light hard azure"        => "from VACCC",
  "light hard blue"         => "from VACCC",
  "light hard cyan"         => "from VACCC",
  "light hard green"        => "from VACCC",
  "light hard magenta"      => "from VACCC",
  "light hard orange"       => "from VACCC",
  "light hard pink"         => "from VACCC",
  "light hard red"          => "from VACCC",
  "light hard spring"       => "from VACCC",
  "light hard teal"         => "from VACCC",
  "light hard violet"       => "from VACCC",
  "light hard yellow"       => "from VACCC",
  "light magenta-pink"      => "from VACCC",
  "light magenta-violet"    => "from VACCC",
  "light orange-red"        => "from VACCC",
  "light orange-yellow"     => "from VACCC",
  "light pink-magenta"      => "from VACCC",
  "light pink-red"          => "from VACCC",
  "light red-orange"        => "from VACCC",
  "light red-pink"          => "from VACCC",
  "light spring-green"      => "from VACCC",
  "light spring-yellow"     => "from VACCC",
  "light teal-cyan"         => "from VACCC",
  "light teal-green"        => "from VACCC",
  "light violet-blue"       => "from VACCC",
  "light violet-magenta"    => "from VACCC",
  "light weak blue"         => "from VACCC",
  "light weak cyan"         => "from VACCC",
  "light weak green"        => "from VACCC",
  "light weak magenta"      => "from VACCC",
  "light weak red"          => "from VACCC",
  "light weak yellow"       => "from VACCC",
  "light yellow-orange"     => "from VACCC",
  "light yellow-spring"     => "from VACCC",
  "lightazure-blue"         => "from VACCC",
  "lightazure-cyan"         => "from VACCC",
  "lightazureblue"          => "from VACCC",
  "lightazurecyan"          => "from VACCC",
  "lightblue"               => "from CSS",
  "lightblue-azure"         => "from VACCC",
  "lightblue-violet"        => "from VACCC",
  "lightblue1"              => "from X",
  "lightblue2"              => "from X",
  "lightblue3"              => "from X",
  "lightblue4"              => "from X",
  "lightblueazure"          => "from VACCC",
  "lightblueviolet"         => "from VACCC",
  "lightcoral"              => "from CSS",
  "lightcyan"               => "from CSS",
  "lightcyan-azure"         => "from VACCC",
  "lightcyan-teal"          => "from VACCC",
  "lightcyan1"              => "from X",
  "lightcyan2"              => "from X",
  "lightcyan3"              => "from X",
  "lightcyan4"              => "from X",
  "lightcyanazure"          => "from VACCC",
  "lightcyanteal"           => "from VACCC",
  "lightdullazure"          => "from VACCC",
  "lightdullblue"           => "from VACCC",
  "lightdullcyan"           => "from VACCC",
  "lightdullgreen"          => "from VACCC",
  "lightdullmagenta"        => "from VACCC",
  "lightdullorange"         => "from VACCC",
  "lightdullpink"           => "from VACCC",
  "lightdullred"            => "from VACCC",
  "lightdullspring"         => "from VACCC",
  "lightdullteal"           => "from VACCC",
  "lightdullviolet"         => "from VACCC",
  "lightdullyellow"         => "from VACCC",
  "lightfadedblue"          => "from VACCC",
  "lightfadedcyan"          => "from VACCC",
  "lightfadedgreen"         => "from VACCC",
  "lightfadedmagenta"       => "from VACCC",
  "lightfadedred"           => "from VACCC",
  "lightfadedyellow"        => "from VACCC",
  "lightgoldenrod"          => "from X",
  "lightgoldenrod1"         => "from X",
  "lightgoldenrod2"         => "from X",
  "lightgoldenrod3"         => "from X",
  "lightgoldenrod4"         => "from X",
  "lightgoldenrodyellow"    => "from CSS",
  "lightgray"               => "from CSS",
  "lightgreen"              => "from CSS",
  "lightgreen-spring"       => "from VACCC",
  "lightgreen-teal"         => "from VACCC",
  "lightgreenspring"        => "from VACCC",
  "lightgreenteal"          => "from VACCC",
  "lightgrey"               => "from CSS",
  "lighthardazure"          => "from VACCC",
  "lighthardblue"           => "from VACCC",
  "lighthardcyan"           => "from VACCC",
  "lighthardgreen"          => "from VACCC",
  "lighthardmagenta"        => "from VACCC",
  "lighthardorange"         => "from VACCC",
  "lighthardpink"           => "from VACCC",
  "lighthardred"            => "from VACCC",
  "lighthardspring"         => "from VACCC",
  "lighthardteal"           => "from VACCC",
  "lighthardviolet"         => "from VACCC",
  "lighthardyellow"         => "from VACCC",
  "lightmagenta-pink"       => "from VACCC",
  "lightmagenta-violet"     => "from VACCC",
  "lightmagentapink"        => "from VACCC",
  "lightmagentaviolet"      => "from VACCC",
  "lightorange-red"         => "from VACCC",
  "lightorange-yellow"      => "from VACCC",
  "lightorangered"          => "from VACCC",
  "lightorangeyellow"       => "from VACCC",
  "lightpink"               => "from CSS",
  "lightpink-magenta"       => "from VACCC",
  "lightpink-red"           => "from VACCC",
  "lightpink1"              => "from X",
  "lightpink2"              => "from X",
  "lightpink3"              => "from X",
  "lightpink4"              => "from X",
  "lightpinkmagenta"        => "from VACCC",
  "lightpinkred"            => "from VACCC",
  "lightred-orange"         => "from VACCC",
  "lightred-pink"           => "from VACCC",
  "lightredorange"          => "from VACCC",
  "lightredpink"            => "from VACCC",
  "lightsalmon"             => "from CSS",
  "lightsalmon1"            => "from X",
  "lightsalmon2"            => "from X",
  "lightsalmon3"            => "from X",
  "lightsalmon4"            => "from X",
  "lightseagreen"           => "from CSS",
  "lightskyblue"            => "from CSS",
  "lightskyblue1"           => "from X",
  "lightskyblue2"           => "from X",
  "lightskyblue3"           => "from X",
  "lightskyblue4"           => "from X",
  "lightslateblue"          => "from X",
  "lightslategray"          => "from CSS",
  "lightslategrey"          => "from CSS",
  "lightspring-green"       => "from VACCC",
  "lightspring-yellow"      => "from VACCC",
  "lightspringgreen"        => "from VACCC",
  "lightspringyellow"       => "from VACCC",
  "lightsteelblue"          => "from CSS",
  "lightsteelblue1"         => "from X",
  "lightsteelblue2"         => "from X",
  "lightsteelblue3"         => "from X",
  "lightsteelblue4"         => "from X",
  "lightteal-cyan"          => "from VACCC",
  "lightteal-green"         => "from VACCC",
  "lighttealcyan"           => "from VACCC",
  "lighttealgreen"          => "from VACCC",
  "lightviolet-blue"        => "from VACCC",
  "lightviolet-magenta"     => "from VACCC",
  "lightvioletblue"         => "from VACCC",
  "lightvioletmagenta"      => "from VACCC",
  "lightweakblue"           => "from VACCC",
  "lightweakcyan"           => "from VACCC",
  "lightweakgreen"          => "from VACCC",
  "lightweakmagenta"        => "from VACCC",
  "lightweakred"            => "from VACCC",
  "lightweakyellow"         => "from VACCC",
  "lightwood"               => "from Netscape",
  "lightyellow"             => "from CSS",
  "lightyellow-orange"      => "from VACCC",
  "lightyellow-spring"      => "from VACCC",
  "lightyellow1"            => "from X",
  "lightyellow2"            => "from X",
  "lightyellow3"            => "from X",
  "lightyellow4"            => "from X",
  "lightyelloworange"       => "from VACCC",
  "lightyellowspring"       => "from VACCC",
  "lilacgrey"               => "from PantoneReport",
  "lime"                    => "from CSS",
  "limegreen"               => "from CSS",
  "limelight"               => "from PantoneReport",
  "limepunc"                => "from PantoneReport",
  "limpetshell"             => "from PantoneReport",
  "linen"                   => "from CSS",
  "littleboyblue"           => "from PantoneReport",
  "liverbrown"              => "from Werner",
  "livingcoral"             => "from PantoneReport",
  "lmp"                     => "from VACCC",
  "lmv"                     => "from VACCC",
  "lodenfrost"              => "from PantoneReport",
  "lor"                     => "from VACCC",
  "loy"                     => "from VACCC",
  "lpm"                     => "from VACCC",
  "lpr"                     => "from VACCC",
  "lro"                     => "from VACCC",
  "lrp"                     => "from VACCC",
  "lsg"                     => "from VACCC",
  "lsy"                     => "from VACCC",
  "ltc"                     => "from VACCC",
  "ltg"                     => "from VACCC",
  "lushmeadow"              => "from PantoneReport",
  "lvb"                     => "from VACCC",
  "lvm"                     => "from VACCC",
  "lwb"                     => "from VACCC",
  "lwc"                     => "from VACCC",
  "lwg"                     => "from VACCC",
  "lwm"                     => "from VACCC",
  "lwr"                     => "from VACCC",
  "lwy"                     => "from VACCC",
  "lyo"                     => "from VACCC",
  "lys"                     => "from VACCC",
  "m"                       => "from VACCC",
  "mab"                     => "from VACCC",
  "mac"                     => "from VACCC",
  "macaroniandcheese"       => "from Crayola",
  "magenta"                 => "from CSS",
  "magenta-magenta-pink"    => "from VACCC",
  "magenta-magenta-violet"  => "from VACCC",
  "magenta1"                => "from X",
  "magenta2"                => "from X",
  "magenta3"                => "from X",
  "magenta4"                => "from X",
  "magentamagentapink"      => "from VACCC",
  "magentamagentaviolet"    => "from VACCC",
  "magentapurple"           => "from PantoneReport",
  "mahogany"                => "from Crayola",
  "mandarianorange"         => "from Netscape",
  "mangomojito"             => "from PantoneReport",
  "marigold"                => "from PantoneReport",
  "marina"                  => "from PantoneReport",
  "maroon"                  => "from CSS",
  "maroon1"                 => "from X",
  "maroon2"                 => "from X",
  "maroon3"                 => "from X",
  "maroon4"                 => "from X",
  "marsala"                 => "from PantoneReport",
  "martiniolive"            => "from PantoneReport",
  "mauvelous"               => "from Crayola",
  "meadowlark"              => "from PantoneReport",
  "medium azure-blue"       => "from VACCC",
  "medium azure-cyan"       => "from VACCC",
  "medium faded blue"       => "from VACCC",
  "medium faded cyan"       => "from VACCC",
  "medium faded green"      => "from VACCC",
  "medium faded magenta"    => "from VACCC",
  "medium faded red"        => "from VACCC",
  "medium faded yellow"     => "from VACCC",
  "medium orange-red"       => "from VACCC",
  "medium orange-yellow"    => "from VACCC",
  "medium pink-magenta"     => "from VACCC",
  "medium pink-red"         => "from VACCC",
  "medium spring-green"     => "from VACCC",
  "medium spring-yellow"    => "from VACCC",
  "medium teal-cyan"        => "from VACCC",
  "medium teal-green"       => "from VACCC",
  "medium violet-blue"      => "from VACCC",
  "medium violet-magenta"   => "from VACCC",
  "medium weak blue"        => "from VACCC",
  "medium weak cyan"        => "from VACCC",
  "medium weak green"       => "from VACCC",
  "medium weak magenta"     => "from VACCC",
  "medium weak red"         => "from VACCC",
  "medium weak yellow"      => "from VACCC",
  "mediumaquamarine"        => "from CSS",
  "mediumazure-blue"        => "from VACCC",
  "mediumazure-cyan"        => "from VACCC",
  "mediumazureblue"         => "from VACCC",
  "mediumazurecyan"         => "from VACCC",
  "mediumblue"              => "from CSS",
  "mediumfadedblue"         => "from VACCC",
  "mediumfadedcyan"         => "from VACCC",
  "mediumfadedgreen"        => "from VACCC",
  "mediumfadedmagenta"      => "from VACCC",
  "mediumfadedred"          => "from VACCC",
  "mediumfadedyellow"       => "from VACCC",
  "mediumforestgreen"       => "from Netscape",
  "mediumgoldenrod"         => "from Netscape",
  "mediumorange-red"        => "from VACCC",
  "mediumorange-yellow"     => "from VACCC",
  "mediumorangered"         => "from VACCC",
  "mediumorangeyellow"      => "from VACCC",
  "mediumorchid"            => "from CSS",
  "mediumorchid1"           => "from X",
  "mediumorchid2"           => "from X",
  "mediumorchid3"           => "from X",
  "mediumorchid4"           => "from X",
  "mediumpink-magenta"      => "from VACCC",
  "mediumpink-red"          => "from VACCC",
  "mediumpinkmagenta"       => "from VACCC",
  "mediumpinkred"           => "from VACCC",
  "mediumpurple"            => "from CSS",
  "mediumpurple1"           => "from X",
  "mediumpurple2"           => "from X",
  "mediumpurple3"           => "from X",
  "mediumpurple4"           => "from X",
  "mediumseagreen"          => "from CSS",
  "mediumslateblue"         => "from CSS",
  "mediumspring-green"      => "from VACCC",
  "mediumspring-yellow"     => "from VACCC",
  "mediumspringgreen"       => "from CSS",
  "mediumspringyellow"      => "from VACCC",
  "mediumteal-cyan"         => "from VACCC",
  "mediumteal-green"        => "from VACCC",
  "mediumtealcyan"          => "from VACCC",
  "mediumtealgreen"         => "from VACCC",
  "mediumturquoise"         => "from CSS",
  "mediumviolet-blue"       => "from VACCC",
  "mediumviolet-magenta"    => "from VACCC",
  "mediumvioletblue"        => "from VACCC",
  "mediumvioletmagenta"     => "from VACCC",
  "mediumvioletred"         => "from CSS",
  "mediumweakblue"          => "from VACCC",
  "mediumweakcyan"          => "from VACCC",
  "mediumweakgreen"         => "from VACCC",
  "mediumweakmagenta"       => "from VACCC",
  "mediumweakred"           => "from VACCC",
  "mediumweakyellow"        => "from VACCC",
  "mediumwood"              => "from Netscape",
  "meerkat"                 => "from PantoneReport",
  "melon"                   => "from Crayola",
  "mfb"                     => "from VACCC",
  "mfc"                     => "from VACCC",
  "mfg"                     => "from VACCC",
  "mfm"                     => "from VACCC",
  "mfr"                     => "from VACCC",
  "mfy"                     => "from VACCC",
  "midnight"                => "from PantoneReport",
  "midnightblue"            => "from CSS",
  "mimosa"                  => "from PantoneReport",
  "mint"                    => "from PantoneReport",
  "mintcream"               => "from CSS",
  "mistyrose"               => "from CSS",
  "mistyrose1"              => "from X",
  "mistyrose2"              => "from X",
  "mistyrose3"              => "from X",
  "mistyrose4"              => "from X",
  "mmp"                     => "from VACCC",
  "mmv"                     => "from VACCC",
  "moccasin"                => "from CSS",
  "mor"                     => "from VACCC",
  "mosaicblue"              => "from PantoneReport",
  "mountaingreen"           => "from Werner",
  "moy"                     => "from VACCC",
  "mpm"                     => "from VACCC",
  "mpr"                     => "from VACCC",
  "msg"                     => "from VACCC",
  "msy"                     => "from VACCC",
  "mtc"                     => "from VACCC",
  "mtg"                     => "from VACCC",
  "mvb"                     => "from VACCC",
  "mvm"                     => "from VACCC",
  "mwb"                     => "from VACCC",
  "mwc"                     => "from VACCC",
  "mwg"                     => "from VACCC",
  "mwm"                     => "from VACCC",
  "mwr"                     => "from VACCC",
  "mwy"                     => "from VACCC",
  "navajowhite"             => "from CSS",
  "navajowhite1"            => "from X",
  "navajowhite2"            => "from X",
  "navajowhite3"            => "from X",
  "navajowhite4"            => "from X",
  "navy"                    => "from CSS",
  "navyblazer"              => "from PantoneReport",
  "navyblue"                => "from Netscape",
  "navypeony"               => "from PantoneReport",
  "nebulasblue"             => "from PantoneReport",
  "neonblue"                => "from Netscape",
  "neonpink"                => "from Netscape",
  "neutralgray"             => "from PantoneReport",
  "newmidnightblue"         => "from Netscape",
  "newtan"                  => "from Netscape",
  "niagara"                 => "from PantoneReport",
  "northerndroplet"         => "from PantoneReport",
  "nosegay"                 => "from PantoneReport",
  "obscure dull azure"      => "from VACCC",
  "obscure dull blue"       => "from VACCC",
  "obscure dull cyan"       => "from VACCC",
  "obscure dull green"      => "from VACCC",
  "obscure dull magenta"    => "from VACCC",
  "obscure dull orange"     => "from VACCC",
  "obscure dull pink"       => "from VACCC",
  "obscure dull red"        => "from VACCC",
  "obscure dull spring"     => "from VACCC",
  "obscure dull teal"       => "from VACCC",
  "obscure dull violet"     => "from VACCC",
  "obscure dull yellow"     => "from VACCC",
  "obscure gray"            => "from VACCC",
  "obscure weak blue"       => "from VACCC",
  "obscure weak cyan"       => "from VACCC",
  "obscure weak green"      => "from VACCC",
  "obscure weak magenta"    => "from VACCC",
  "obscure weak red"        => "from VACCC",
  "obscure weak yellow"     => "from VACCC",
  "obscuredullazure"        => "from VACCC",
  "obscuredullblue"         => "from VACCC",
  "obscuredullcyan"         => "from VACCC",
  "obscuredullgreen"        => "from VACCC",
  "obscuredullmagenta"      => "from VACCC",
  "obscuredullorange"       => "from VACCC",
  "obscuredullpink"         => "from VACCC",
  "obscuredullred"          => "from VACCC",
  "obscuredullspring"       => "from VACCC",
  "obscuredullteal"         => "from VACCC",
  "obscuredullviolet"       => "from VACCC",
  "obscuredullyellow"       => "from VACCC",
  "obscuregray"             => "from VACCC",
  "obscureweakblue"         => "from VACCC",
  "obscureweakcyan"         => "from VACCC",
  "obscureweakgreen"        => "from VACCC",
  "obscureweakmagenta"      => "from VACCC",
  "obscureweakred"          => "from VACCC",
  "obscureweakyellow"       => "from VACCC",
  "ochreyellow"             => "from Werner",
  "oda"                     => "from VACCC",
  "odb"                     => "from VACCC",
  "odc"                     => "from VACCC",
  "odg"                     => "from VACCC",
  "odm"                     => "from VACCC",
  "odo"                     => "from VACCC",
  "odp"                     => "from VACCC",
  "odr"                     => "from VACCC",
  "ods"                     => "from VACCC",
  "odt"                     => "from VACCC",
  "odv"                     => "from VACCC",
  "ody"                     => "from VACCC",
  "og"                      => "from VACCC",
  "oilgreen"                => "from Werner",
  "oldgold"                 => "from Netscape",
  "oldlace"                 => "from CSS",
  "olive"                   => "from CSS",
  "olivedrab"               => "from CSS",
  "olivedrab1"              => "from X",
  "olivedrab2"              => "from X",
  "olivedrab3"              => "from X",
  "olivedrab4"              => "from X",
  "olivegreen"              => "from Crayola",
  "oor"                     => "from VACCC",
  "ooy"                     => "from VACCC",
  "orange"                  => "from CSS",
  "orange-orange-red"       => "from VACCC",
  "orange-orange-yellow"    => "from VACCC",
  "orange1"                 => "from X",
  "orange2"                 => "from X",
  "orange3"                 => "from X",
  "orange4"                 => "from X",
  "orangecolouredwhite"     => "from Werner",
  "orangeorangered"         => "from VACCC",
  "orangeorangeyellow"      => "from VACCC",
  "orangepeel"              => "from PantoneReport",
  "orangered"               => "from CSS",
  "orangered1"              => "from X",
  "orangered2"              => "from X",
  "orangered3"              => "from X",
  "orangered4"              => "from X",
  "orangetiger"             => "from PantoneReport",
  "orchid"                  => "from CSS",
  "orchid1"                 => "from X",
  "orchid2"                 => "from X",
  "orchid3"                 => "from X",
  "orchid4"                 => "from X",
  "orpimentorange"          => "from Werner",
  "owb"                     => "from VACCC",
  "owc"                     => "from VACCC",
  "owg"                     => "from VACCC",
  "owm"                     => "from VACCC",
  "owr"                     => "from VACCC",
  "owy"                     => "from VACCC",
  "pale dull azure"         => "from VACCC",
  "pale dull blue"          => "from VACCC",
  "pale dull cyan"          => "from VACCC",
  "pale dull green"         => "from VACCC",
  "pale dull magenta"       => "from VACCC",
  "pale dull orange"        => "from VACCC",
  "pale dull pink"          => "from VACCC",
  "pale dull red"           => "from VACCC",
  "pale dull spring"        => "from VACCC",
  "pale dull teal"          => "from VACCC",
  "pale dull violet"        => "from VACCC",
  "pale dull yellow"        => "from VACCC",
  "pale gray"               => "from VACCC",
  "pale weak blue"          => "from VACCC",
  "pale weak cyan"          => "from VACCC",
  "pale weak green"         => "from VACCC",
  "pale weak magenta"       => "from VACCC",
  "pale weak red"           => "from VACCC",
  "pale weak yellow"        => "from VACCC",
  "paleblackishpurple"      => "from Werner",
  "paledogwood"             => "from PantoneReport",
  "paledullazure"           => "from VACCC",
  "paledullblue"            => "from VACCC",
  "paledullcyan"            => "from VACCC",
  "paledullgreen"           => "from VACCC",
  "paledullmagenta"         => "from VACCC",
  "paledullorange"          => "from VACCC",
  "paledullpink"            => "from VACCC",
  "paledullred"             => "from VACCC",
  "paledullspring"          => "from VACCC",
  "paledullteal"            => "from VACCC",
  "paledullviolet"          => "from VACCC",
  "paledullyellow"          => "from VACCC",
  "palegoldenrod"           => "from CSS",
  "palegray"                => "from VACCC",
  "palegreen"               => "from CSS",
  "palegreen1"              => "from X",
  "palegreen2"              => "from X",
  "palegreen3"              => "from X",
  "palegreen4"              => "from X",
  "paleturquoise"           => "from CSS",
  "paleturquoise1"          => "from X",
  "paleturquoise2"          => "from X",
  "paleturquoise3"          => "from X",
  "paleturquoise4"          => "from X",
  "palevioletred"           => "from CSS",
  "palevioletred1"          => "from X",
  "palevioletred2"          => "from X",
  "palevioletred3"          => "from X",
  "palevioletred4"          => "from X",
  "paleweakblue"            => "from VACCC",
  "paleweakcyan"            => "from VACCC",
  "paleweakgreen"           => "from VACCC",
  "paleweakmagenta"         => "from VACCC",
  "paleweakred"             => "from VACCC",
  "paleweakyellow"          => "from VACCC",
  "paloma"                  => "from PantoneReport",
  "pansypurple"             => "from Werner",
  "papayawhip"              => "from CSS",
  "pda"                     => "from VACCC",
  "pdb"                     => "from VACCC",
  "pdc"                     => "from VACCC",
  "pdg"                     => "from VACCC",
  "pdm"                     => "from VACCC",
  "pdo"                     => "from VACCC",
  "pdp"                     => "from VACCC",
  "pdr"                     => "from VACCC",
  "pds"                     => "from VACCC",
  "pdt"                     => "from VACCC",
  "pdv"                     => "from VACCC",
  "pdy"                     => "from VACCC",
  "peach"                   => "from Crayola",
  "peachblossomred"         => "from Werner",
  "peachecho"               => "from PantoneReport",
  "peachnougat"             => "from PantoneReport",
  "peachpink"               => "from PantoneReport",
  "peachpuff"               => "from CSS",
  "peachpuff1"              => "from X",
  "peachpuff2"              => "from X",
  "peachpuff3"              => "from X",
  "peachpuff4"              => "from X",
  "pearlgrey"               => "from Werner",
  "pepperstem"              => "from PantoneReport",
  "perfectlypale"           => "from PantoneReport",
  "peru"                    => "from CSS",
  "pg"                      => "from VACCC",
  "pink"                    => "from CSS",
  "pink-pink-magenta"       => "from VACCC",
  "pink-pink-red"           => "from VACCC",
  "pink1"                   => "from X",
  "pink2"                   => "from X",
  "pink3"                   => "from X",
  "pink4"                   => "from X",
  "pinklavender"            => "from PantoneReport",
  "pinkpeacock"             => "from PantoneReport",
  "pinkpinkmagenta"         => "from VACCC",
  "pinkpinkred"             => "from VACCC",
  "pinkyarrow"              => "from PantoneReport",
  "pistachiogreen"          => "from Werner",
  "pitchorbrownishblack"    => "from Werner",
  "plum"                    => "from CSS",
  "plum1"                   => "from X",
  "plum2"                   => "from X",
  "plum3"                   => "from X",
  "plum4"                   => "from X",
  "plumpurple"              => "from Werner",
  "poinciana"               => "from PantoneReport",
  "polarnight"              => "from PantoneReport",
  "poppyseed"               => "from PantoneReport",
  "pottersclay"             => "from PantoneReport",
  "powderblue"              => "from CSS",
  "ppm"                     => "from VACCC",
  "ppr"                     => "from VACCC",
  "primroseyellow"          => "from PantoneReport",
  "princessblue"            => "from PantoneReport",
  "prussianblue"            => "from Werner",
  "purple"                  => "from CSS",
  "purple1"                 => "from X",
  "purple2"                 => "from X",
  "purple3"                 => "from X",
  "purple4"                 => "from X",
  "purplemountainsmajesty"  => "from Crayola",
  "purplishred"             => "from Werner",
  "purplishwhite"           => "from Werner",
  "pwb"                     => "from VACCC",
  "pwc"                     => "from VACCC",
  "pwg"                     => "from VACCC",
  "pwm"                     => "from VACCC",
  "pwr"                     => "from VACCC",
  "pwy"                     => "from VACCC",
  "quartz"                  => "from Netscape",
  "quetzalgreen"            => "from PantoneReport",
  "quietgray"               => "from PantoneReport",
  "r"                       => "from VACCC",
  "radiandorchid"           => "from PantoneReport",
  "raspberrysorbet"         => "from PantoneReport",
  "rawsienna"               => "from Crayola",
  "rebeccapurple"           => "from X",
  "red"                     => "from CSS",
  "red-red-orange"          => "from VACCC",
  "red-red-pink"            => "from VACCC",
  "red1"                    => "from X",
  "red2"                    => "from X",
  "red3"                    => "from X",
  "red4"                    => "from X",
  "reddishblack"            => "from Werner",
  "reddishorange"           => "from Werner",
  "reddishwhite"            => "from Werner",
  "redlilacpurple"          => "from Werner",
  "redorange"               => "from Crayola",
  "redpear"                 => "from PantoneReport",
  "redredorange"            => "from VACCC",
  "redredpink"              => "from VACCC",
  "redviolet"               => "from Crayola",
  "richblue"                => "from Netscape",
  "riverside"               => "from PantoneReport",
  "rockyroad"               => "from PantoneReport",
  "rosequartz"              => "from PantoneReport",
  "rosered"                 => "from Werner",
  "rosetan"                 => "from PantoneReport",
  "roseviolet"              => "from PantoneReport",
  "rosybrown"               => "from CSS",
  "rosybrown1"              => "from X",
  "rosybrown2"              => "from X",
  "rosybrown3"              => "from X",
  "rosybrown4"              => "from X",
  "royalblue"               => "from CSS",
  "royalblue1"              => "from X",
  "royalblue2"              => "from X",
  "royalblue3"              => "from X",
  "royalblue4"              => "from X",
  "rro"                     => "from VACCC",
  "rrp"                     => "from VACCC",
  "russetorange"            => "from PantoneReport",
  "rust"                    => "from PantoneReport",
  "rustyred"                => "from EmergyC",
  "saddlebrown"             => "from CSS",
  "saffron"                 => "from PantoneReport",
  "saffronyellow"           => "from Werner",
  "sailorblue"              => "from PantoneReport",
  "salmon"                  => "from CSS",
  "salmon1"                 => "from X",
  "salmon2"                 => "from X",
  "salmon3"                 => "from X",
  "salmon4"                 => "from X",
  "samba"                   => "from PantoneReport",
  "samoansun"               => "from PantoneReport",
  "sanddollar"              => "from PantoneReport",
  "sandstone"               => "from PantoneReport",
  "sandybrown"              => "from CSS",
  "sapgreen"                => "from Werner",
  "sargassosea"             => "from PantoneReport",
  "scarlet"                 => "from Crayola",
  "scarletred"              => "from Werner",
  "scotchblue"              => "from Werner",
  "seagreen"                => "from CSS",
  "seagreen1"               => "from X",
  "seagreen2"               => "from X",
  "seagreen3"               => "from X",
  "seagreen4"               => "from X",
  "seashell"                => "from CSS",
  "seashell1"               => "from X",
  "seashell2"               => "from X",
  "seashell3"               => "from X",
  "seashell4"               => "from X",
  "semisweetchocolate"      => "from Netscape",
  "sepia"                   => "from Crayola",
  "serenity"                => "from PantoneReport",
  "shadedspruce"            => "from PantoneReport",
  "sharkskin"               => "from PantoneReport",
  "sienna"                  => "from CSS",
  "sienna1"                 => "from X",
  "sienna2"                 => "from X",
  "sienna3"                 => "from X",
  "sienna4"                 => "from X",
  "siennayellow"            => "from Werner",
  "silver"                  => "from CSS",
  "siskingreen"             => "from Werner",
  "skimmedmilkwhite"        => "from Werner",
  "skyblue"                 => "from CSS",
  "skyblue1"                => "from X",
  "skyblue2"                => "from X",
  "skyblue3"                => "from X",
  "skyblue4"                => "from X",
  "skydiver"                => "from PantoneReport",
  "slateblue"               => "from CSS",
  "slateblue1"              => "from X",
  "slateblue2"              => "from X",
  "slateblue3"              => "from X",
  "slateblue4"              => "from X",
  "slategray"               => "from CSS",
  "slategray1"              => "from X",
  "slategray2"              => "from X",
  "slategray3"              => "from X",
  "slategray4"              => "from X",
  "slategrey"               => "from CSS",
  "smokegrey"               => "from Werner",
  "snorkelblue"             => "from PantoneReport",
  "snow"                    => "from CSS",
  "snow1"                   => "from X",
  "snow2"                   => "from X",
  "snow3"                   => "from X",
  "snow4"                   => "from X",
  "snowwhite"               => "from PantoneReport",
  "soybean"                 => "from PantoneReport",
  "spicymustard"            => "from PantoneReport",
  "spicypink"               => "from Netscape",
  "spring-spring-green"     => "from VACCC",
  "spring-spring-yellow"    => "from VACCC",
  "springcrocus"            => "from PantoneReport",
  "springgreen"             => "from CSS",
  "springgreen1"            => "from X",
  "springgreen2"            => "from X",
  "springgreen3"            => "from X",
  "springgreen4"            => "from X",
  "springspringgreen"       => "from VACCC",
  "springspringyellow"      => "from VACCC",
  "spunsugar"               => "from PantoneReport",
  "ssg"                     => "from VACCC",
  "ssy"                     => "from VACCC",
  "steelblue"               => "from CSS",
  "steelblue1"              => "from X",
  "steelblue2"              => "from X",
  "steelblue3"              => "from X",
  "steelblue4"              => "from X",
  "strawyellow"             => "from Werner",
  "sugaralmond"             => "from PantoneReport",
  "sulphuryellow"           => "from Werner",
  "summersky"               => "from Netscape",
  "sunlight"                => "from PantoneReport",
  "sweetcorn"               => "from PantoneReport",
  "sweetlilac"              => "from PantoneReport",
  "tan"                     => "from CSS",
  "tan1"                    => "from X",
  "tan2"                    => "from X",
  "tan3"                    => "from X",
  "tan4"                    => "from X",
  "tangerinetango"          => "from PantoneReport",
  "tawnyport"               => "from PantoneReport",
  "teal"                    => "from CSS",
  "teal-teal-cyan"          => "from VACCC",
  "teal-teal-green"         => "from VACCC",
  "tealtealcyan"            => "from VACCC",
  "tealtealgreen"           => "from VACCC",
  "terrariummoss"           => "from PantoneReport",
  "thistle"                 => "from CSS",
  "thistle1"                => "from X",
  "thistle2"                => "from X",
  "thistle3"                => "from X",
  "thistle4"                => "from X",
  "tigerlily"               => "from PantoneReport",
  "tilered"                 => "from Werner",
  "timberwolf"              => "from Crayola",
  "toffee"                  => "from PantoneReport",
  "tofu"                    => "from PantoneReport",
  "tomato"                  => "from CSS",
  "tomato1"                 => "from X",
  "tomato2"                 => "from X",
  "tomato3"                 => "from X",
  "tomato4"                 => "from X",
  "truered"                 => "from PantoneReport",
  "ttc"                     => "from VACCC",
  "ttg"                     => "from VACCC",
  "tumbleweed"              => "from Crayola",
  "turmeric"                => "from PantoneReport",
  "turquoise"               => "from CSS",
  "turquoise1"              => "from X",
  "turquoise2"              => "from X",
  "turquoise3"              => "from X",
  "turquoise4"              => "from X",
  "ultimategray"            => "from PantoneReport",
  "ultramarineblue"         => "from Werner",
  "ultramarinegreen"        => "from PantoneReport",
  "ultraviolet"             => "from PantoneReport",
  "umberbrown"              => "from Werner",
  "valiantpoppy"            => "from PantoneReport",
  "vanillacustard"          => "from PantoneReport",
  "veinousbloodred"         => "from Werner",
  "velvetblack"             => "from Werner",
  "verdigrisgreen"          => "from Werner",
  "verditterblue"           => "from Werner",
  "vermilionred"            => "from Werner",
  "verydarkbrown"           => "from Netscape",
  "verylightgrey"           => "from Netscape",
  "veryperi"                => "from PantoneReport",
  "violet"                  => "from CSS",
  "violet-violet-blue"      => "from VACCC",
  "violet-violet-magenta"   => "from VACCC",
  "violetpurple"            => "from Werner",
  "violetred"               => "from Crayola",
  "violetred1"              => "from X",
  "violetred2"              => "from X",
  "violetred3"              => "from X",
  "violetred4"              => "from X",
  "violetvioletblue"        => "from VACCC",
  "violetvioletmagenta"     => "from VACCC",
  "vvb"                     => "from VACCC",
  "vvm"                     => "from VACCC",
  "w"                       => "from VACCC",
  "warmsand"                => "from PantoneReport",
  "warmtaupe"               => "from PantoneReport",
  "waterspout"              => "from PantoneReport",
  "waxyellow"               => "from Werner",
  "webgray"                 => "from X",
  "webgreen"                => "from X",
  "webgrey"                 => "from X",
  "webmaroon"               => "from X",
  "webpurple"               => "from X",
  "wheat"                   => "from CSS",
  "wheat1"                  => "from X",
  "wheat2"                  => "from X",
  "wheat3"                  => "from X",
  "wheat4"                  => "from X",
  "white"                   => "from CSS",
  "whitesmoke"              => "from CSS",
  "willow"                  => "from PantoneReport",
  "wineyellow"              => "from Werner",
  "wistera"                 => "from Crayola",
  "woodbrown"               => "from Werner",
  "x11gray"                 => "from X",
  "x11green"                => "from X",
  "x11grey"                 => "from X",
  "x11maroon"               => "from X",
  "x11purple"               => "from X",
  "y"                       => "from VACCC",
  "yellow"                  => "from CSS",
  "yellow-yellow-orange"    => "from VACCC",
  "yellow-yellow-spring"    => "from VACCC",
  "yellow1"                 => "from X",
  "yellow2"                 => "from X",
  "yellow3"                 => "from X",
  "yellow4"                 => "from X",
  "yellowgreen"             => "from CSS",
  "yellowishbrown"          => "from Werner",
  "yellowishgrey"           => "from Werner",
  "yellowishwhite"          => "from Werner",
  "yelloworange"            => "from Crayola",
  "yellowyelloworange"      => "from VACCC",
  "yellowyellowspring"      => "from VACCC",
  "yyo"                     => "from VACCC",
  "yys"                     => "from VACCC",
}
;

1;
# ABSTRACT: Lots of English color names and equivalent RGB values (lite version)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesLite::EN - Lots of English color names and equivalent RGB values (lite version)

=head1 VERSION

This document describes version 0.003 of Graphics::ColorNamesLite::EN (from Perl distribution Graphics-ColorNamesLite-EN), released on 2023-12-01.

=head1 DESCRIPTION

This is a merge of various English Graphics::ColorNames::* modules.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesLite-EN>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesLite-EN>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesLite::*> modules.

Other C<Graphics::ColorNames::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesLite-EN>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
