package Dist::Zilla::Plugin::Test::Map::Tube;

$Dist::Zilla::Plugin::Test::Map::Tube::VERSION   = '0.04';
$Dist::Zilla::Plugin::Test::Map::Tube::AUTHORITY = 'cpan:MANWAR';

=head1 NAME

Dist::Zilla::Plugin::Test::Map::Tube - Provides release test for Test::Map::Tube.

=head1 VERSION

Version 0.04

=cut

use Moose;
with 'Dist::Zilla::Role::FileGatherer';
with 'Dist::Zilla::Role::PrereqSource';

use Dist::Zilla::File::InMemory;

=head1 DESCRIPTION

This is an extension  of L<Dist::Zilla::Plugin::InlineFiles>, providing following
file:

    xt/release/map.t

This test uses L<Test::Map::Tube> to check your map data and basic functions.

=head1 SYNOPSIS

Just add the following line to your C<dist.ini> file.

    [Test::Map::Tube]

=cut

sub register_prereqs {
    my ($self) = @_;

    $self->zilla->register_prereqs(
        {
            type  => 'requires',
            phase => 'develop',
        },
        'Test::Map::Tube' => '0.13',
    );
}

sub gather_files {
    my ($self) = @_;

    my $file_name = "xt/release/map.t";
    my $file_content = <<'_';
#!perl

# This file was automatically generated by Dist::Zilla::Plugin::Test::Map::Tube.

use strict; use warnings;
use Test::More;
eval "use Test::Map::Tube 0.13 tests => 2";
plan skip_all => "Test::Map::Tube 0.13 required" if $@;

_

    my $map_module = $self->zilla->name;
    $map_module =~ s/\-/\:\:/g;
    $file_content .=
        sprintf("\n\nuse %s; \n\n ok_map(%s->new); \n\n ok_map_functions(%s->new);\n\n",
                $map_module, $map_module, $map_module);

    $self->log(["Adding %s ...", $file_name]);
    $self->add_file(
        Dist::Zilla::File::InMemory->new(
            {
                name    => $file_name,
                content => $file_content,
            })
    );
}

=head1 BUGS

None that I am aware of.Of course, if you find a bug, let me know, and I would do
my best  to fix it.  This is still a very early version, so it is always possible
that I have just "gotten it wrong" in some places.

=head1 SEE ALSO

=over 4

=item L<Map::Tube>

=item L<Test::Map::Tube>

=back

=head1 AUTHOR

Mohammad S Anwar, C<< <mohammad.anwar at yahoo.com> >>

=head1 REPOSITORY

L<https://github.com/manwar/Dist-Zilla-Plugin-Test-Map-Tube>

=head1 BUGS

Please report any bugs / feature requests to C<bug-dist-zilla-plugin-test-map-tube at rt.cpan.org>,
or through the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Dist-Zilla-Plugin-Test-Map-Tube>.
I will be notified, and then you'll automatically be notified of progress on your
bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Dist::Zilla::Plugin::Test::Map::Tube

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Dist-Zilla-Plugin=Test-Map-Tube>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Dist-Zilla-Plugin=Test-Map-Tube>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Dist-Zilla-Plugin-Test-Map-Tube>

=item * Search CPAN

L<http://search.cpan.org/dist/Dist-Zilla-Plugin-Test-Map-Tube/>

=back

=head1 LICENSE AND COPYRIGHT

Copyright (C) 2015 - 2016 Mohammad S Anwar.

This  program  is  free software; you can redistribute it  and/or modify it under
the  terms  of the the Artistic License (2.0). You may  obtain a copy of the full
license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any  use,  modification, and distribution of the Standard or Modified Versions is
governed by this Artistic License.By using, modifying or distributing the Package,
you accept this license. Do not use, modify, or distribute the Package, if you do
not accept this license.

If your Modified Version has been derived from a Modified Version made by someone
other than you,you are nevertheless required to ensure that your Modified Version
 complies with the requirements of this license.

This  license  does  not grant you the right to use any trademark,  service mark,
tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge patent license
to make,  have made, use,  offer to sell, sell, import and otherwise transfer the
Package with respect to any patent claims licensable by the Copyright Holder that
are  necessarily  infringed  by  the  Package. If you institute patent litigation
(including  a  cross-claim  or  counterclaim) against any party alleging that the
Package constitutes direct or contributory patent infringement,then this Artistic
License to you shall terminate on the date that such litigation is filed.

Disclaimer  of  Warranty:  THE  PACKAGE  IS  PROVIDED BY THE COPYRIGHT HOLDER AND
CONTRIBUTORS  "AS IS'  AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES. THE IMPLIED
WARRANTIES    OF   MERCHANTABILITY,   FITNESS   FOR   A   PARTICULAR  PURPOSE, OR
NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY YOUR LOCAL LAW. UNLESS
REQUIRED BY LAW, NO COPYRIGHT HOLDER OR CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL,  OR CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE
OF THE PACKAGE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=cut

__PACKAGE__->meta->make_immutable;

1; # End of Dist::Zilla::Plugin::Test::Map::Tube
