/******************************
 * pdl.c - perldla spawner
 * Works around a problem with many unices that you can't use an interpreter
 * to run an interpreter -- so "#!/usr/bin/perldla" won't work.
 * This is a compiled piece of code that launches perldla "directly", 
 * so that the poor kernel's mind isn't blown.
 *
 * If you feed in a single non-switch argument it gets prepended with a 
 * "-" to let perldla know that it's an input file.  That way you can be lazy
 * and say "#!/usr/bin/pdl" at the top of your script.
 * 
 * Don't modify this .c code -- modify the generator, pdl.PL, instead.
 *
 * CED 21-Jul-2004
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>

int main(int argc, char **argv) {
  char perldla[BUFSIZ];
  int pipes[2];
  int pid,i;
  int status;

  if(pipe(pipes)) {perror("pdl (perldla spawn wrapper)"); exit(1);}
  pid = fork();
  if(pid==0) {
    dup2(pipes[1],1);
    dup2(pipes[1],2);
    system("which perldla");
    exit(0);
  }
  read(pipes[0],perldla,BUFSIZ);
  pid = wait(&status);
  if(! WIFEXITED(status) ) {
    fprintf(stderr,"Hmmm... couldn't seem to find perldla anywhere. Quitting.\n");
    goto exit;
  }

  /* Remove trailing newline */
  for(i=0;i<BUFSIZ && perldla[i]; i++) 
    if(perldla[i]=='\n' || perldla[i]=='\r')
        perldla[i]='\0';

  if(argc==2) {
    if(argv[1][0]!='-') {
      char **argv2 = malloc((argc+2)*sizeof(char *));
      int i;

      if(!argv2) 
	goto exit;

      for(i=0;i<argc;i++)
	argv2[i+1]=argv[i];

      argv2[1]="-";
      argv2[0]="perldla";
      argv2[argc+1]=0;

      execv(perldla,argv2);
      fprintf(stderr,"couldn't execv %s\n",perldla);
      goto exit;
    }
  }

  argv[0]="perldla";
  execv(perldla,argv);
  fprintf(stderr,"couldn't execv %s (%d args)\n",perldla,argc);
  goto exit;

exit: 
  perror("pdl (perldla trampoline)");
  exit(-1);
}
