use strict;
use warnings;
use ExtUtils::MakeMaker;
use PDLA::Core::Dev;

our ($GSL_includes, $GSL_libs); 

sub gsl_sf_links_ok {
  my($lib,$inc) = @_;
  return defined($lib) && defined($inc) &&
  trylink('gsl SF libraries',
  << 'EOI',
#include <gsl/gsl_sf_bessel.h>
EOI
  << 'EOB', $lib, $inc);

  double x = 5.0;
  double expected = -0.17759677131433830434739701;
  
  double y = gsl_sf_bessel_J0 (x);

  return 0;

EOB
}

my $skip = 0;
my $msg = undef;
my $forcebuild=0;

if (defined $PDLA::Config{WITH_GSL} && $PDLA::Config{WITH_GSL}==0) {
  $msg = "\n   Will skip build of PDLA::GSLSF on this system   \n";
  $skip = 1;
} elsif (defined $PDLA::Config{WITH_GSL} && $PDLA::Config{WITH_GSL}==1) {
  print "\n   Will forcibly try and build PDLA::GSLSF on this system   \n\n";
  $forcebuild=1;
}

if (($skip && !$forcebuild) ||
    !gsl_sf_links_ok($GSL_libs, $GSL_includes)) {
  warn "trying to force GSL build but link test failed\n".
    "\t -- aborting GSL build\n" if $forcebuild;
  $msg ||=
    "\n GSL Libraries not found... Skipping build of PDLA::GSLSF.\n";
  write_dummy_make( $msg );
  return;
} else {
  print "\n   Building PDLA::GSLSF.", 
    "Turn off WITH_GSL if there are any problems\n\n";
}

WriteMakefile(
	'NAME' => 'PDLA::GSLSF',
	VERSION => '0.5',
	# VERSION_FROM => '../../../lib/PDLA/Rest.pm',
       #DIR =>  [ qw/airy bessel chebyshev clausen coulomb coupling dawson debye dilog elementary ellint elljac erf exp expint fermi_dirac gamma gegenbauer hyperg laguerre legendre log poly pow_int psi synchrotron transport trig zeta/ ],
    (eval ($ExtUtils::MakeMaker::VERSION) >= 6.57_02 ? ('NO_MYMETA' => 1) : ()),
);
