package Chart::Plotly::Trace::Choropleth;
use Moose;

our $VERSION = '0.003';    # VERSION

=encoding utf-8

=head1 NAME 

Chart::Plotly::Trace::Choropleth

=head1 SYNOPSIS

	use HTML::Show;
	use Chart::Plotly;
	use Chart::Plotly::Trace::Choropleth;
	my $choropleth = Chart::Plotly::Trace::Choropleth->new(x => [1 .. 5], y => [1 .. 5]);
	
	HTML::Show::show(Chart::Plotly::render_full_html(data => [$choropleth]));


=head1 DESCRIPTION

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#choropleth>

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=cut

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=cut

sub TO_JSON {
    my $self = shift;
    my %hash = %$self;
    $hash{type} = $self->type();
    return \%hash;
}

=head2 type

Trace type.

=cut

sub type {
    my @components = split( /::/, __PACKAGE__ );
    return lc( $components[-1] );
}

=head1 ATTRIBUTES

=over

=cut

=item * zmax

Sets the upper bound of color domain.

=cut

has zmax => ( is            => 'rw',
              documentation => "Sets the upper bound of color domain.", );

=item * z

Sets the color values.

=cut

has z => ( is            => 'rw',
           documentation => "Sets the color values.", );

=item * autocolorscale

Determines whether or not the colorscale is picked using the sign of the input z values.

=cut

has autocolorscale => (
            is            => 'rw',
            documentation => "Determines whether or not the colorscale is picked using the sign of the input z values.",
);

=item * showscale

Determines whether or not a colorbar is displayed for this trace.

=cut

has showscale => ( is            => 'rw',
                   documentation => "Determines whether or not a colorbar is displayed for this trace.", );

=item * hoverinfo

Determines which trace information appear on hover. If `none` or `skip` are set, no information is displayed upon hovering. But, if `none` is set, click and hover events are still fired.

=cut

has hoverinfo => (
    is => 'rw',
    documentation =>
      "Determines which trace information appear on hover. If `none` or `skip` are set, no information is displayed upon hovering. But, if `none` is set, click and hover events are still fired.",
);

=item * zauto

Determines the whether or not the color domain is computed with respect to the input data.

=cut

has zauto => (
          is            => 'rw',
          documentation => "Determines the whether or not the color domain is computed with respect to the input data.",
);

=item * locations

Sets the coordinates via location IDs or names. See `locationmode` for more info.

=cut

has locations => ( is            => 'rw',
                   documentation => "Sets the coordinates via location IDs or names. See `locationmode` for more info.",
);

=item * colorscale

Sets the colorscale. The colorscale must be an array containing arrays mapping a normalized value to an rgb, rgba, hex, hsl, hsv, or named color string. At minimum, a mapping for the lowest (0) and highest (1) values are required. For example, `[[0, 'rgb(0,0,255)', [1, 'rgb(255,0,0)']]`. To control the bounds of the colorscale in z space, use zmin and zmax

=cut

has colorscale => (
    is => 'rw',
    documentation =>
      "Sets the colorscale. The colorscale must be an array containing arrays mapping a normalized value to an rgb, rgba, hex, hsl, hsv, or named color string. At minimum, a mapping for the lowest (0) and highest (1) values are required. For example, `[[0, 'rgb(0,0,255)', [1, 'rgb(255,0,0)']]`. To control the bounds of the colorscale in z space, use zmin and zmax",
);

=item * locationmode

Determines the set of locations used to match entries in `locations` to regions on the map.

=cut

has locationmode => (
         is            => 'rw',
         documentation => "Determines the set of locations used to match entries in `locations` to regions on the map.",
);

=item * zmin

Sets the lower bound of color domain.

=cut

has zmin => ( is            => 'rw',
              documentation => "Sets the lower bound of color domain.", );

=item * text

Sets the text elements associated with each location.

=cut

has text => ( is            => 'rw',
              documentation => "Sets the text elements associated with each location.", );

=item * _nestedModules


=cut

has _nestedModules => ( is => 'rw', );

=item * reversescale

Reverses the colorscale.

=cut

has reversescale => ( is            => 'rw',
                      documentation => "Reverses the colorscale.", );

=item * marker


=cut

has marker => ( is => 'rw', );

=pod

=back

=cut

__PACKAGE__->meta->make_immutable();
1;
