use 5.008_007;
use ExtUtils::MakeMaker;

use strict;
use warnings;
use Config;
use Getopt::Long;
use FindBin;
use lib "$FindBin::Bin/lib";
use Getopt::Long 'GetOptions';
use File::Find 'find';

use SPVM::Builder::Util;

# If you edit yacc/spvm_yacc.y, spvm_yacc.c must be re-generated by the following command before "perl Makefile.PL"
#   yacc/bison.sh

# Check supported environment
{
  # SPVM only support 64bit integer Perl
  my $ivsize = $Config{ivsize};
  if ($ivsize < 8) {
    warn "SPVM don't support the Perl which \"ivsize\" is lower than 8\n";
    die "OS unsupported\n";
  }
}

my @defines;
my $optimize;

GetOptions(
  "--DEFINE=s" => \@defines,
  "--OPTIMIZE=s" => \$optimize,
);

# Macro
@defines = map { "-D$_" } @defines;

# OPTIMIZE
unless ($optimize) {
  $optimize = '-O3';
}

# CCFLAGS
my $ccflags = $Config{ccflags};

# SPVM is compiled as C99, but some platforms can't compile XS which contains perl.h with pure C99(-std=c99). I select -std=gnu99.
$ccflags .= ' -std=gnu99';

# I want to print warnings, but if gcc version is different, can't suppress no needed warning message.
# so I dicide not to print warning in release version
if ($ENV{SPVM_TEST_ENABLE_WARNINGS}) {
  $ccflags .= ' -Wall -Wextra -Wno-unused-label -Wno-unused-function -Wno-unused-label -Wno-unused-parameter -Wno-unused-variable -Wno-missing-field-initializers';
}

# INC
my $inc = '-Ilib/SPVM/Builder/include';

# Source files
my @spvm_csource_files = qw(
  lib/SPVM/Builder/src/spvm_allow.c
  lib/SPVM/Builder/src/spvm_api.c
  lib/SPVM/Builder/src/spvm_array_field_access.c
  lib/SPVM/Builder/src/spvm_basic_type.c
  lib/SPVM/Builder/src/spvm_block.c
  lib/SPVM/Builder/src/spvm_call_method.c
  lib/SPVM/Builder/src/spvm_case_info.c
  lib/SPVM/Builder/src/spvm_class.c
  lib/SPVM/Builder/src/spvm_class_var_access.c
  lib/SPVM/Builder/src/spvm_class_var.c
  lib/SPVM/Builder/src/spvm_allocator.c
  lib/SPVM/Builder/src/spvm_compiler.c
  lib/SPVM/Builder/src/spvm_constant.c
  lib/SPVM/Builder/src/spvm_csource_builder_precompile.c
  lib/SPVM/Builder/src/spvm_descriptor.c
  lib/SPVM/Builder/src/spvm_dumper.c
  lib/SPVM/Builder/src/spvm_enumeration.c
  lib/SPVM/Builder/src/spvm_enumeration_value.c
  lib/SPVM/Builder/src/spvm_field_access.c
  lib/SPVM/Builder/src/spvm_field.c
  lib/SPVM/Builder/src/spvm_hash.c
  lib/SPVM/Builder/src/spvm_list.c
  lib/SPVM/Builder/src/spvm_method.c
  lib/SPVM/Builder/src/spvm_my.c
  lib/SPVM/Builder/src/spvm_op.c
  lib/SPVM/Builder/src/spvm_op_checker.c
  lib/SPVM/Builder/src/spvm_opcode_array.c
  lib/SPVM/Builder/src/spvm_opcode_builder.c
  lib/SPVM/Builder/src/spvm_opcode.c
  lib/SPVM/Builder/src/spvm_string_buffer.c
  lib/SPVM/Builder/src/spvm_switch_info.c
  lib/SPVM/Builder/src/spvm_toke.c
  lib/SPVM/Builder/src/spvm_type.c
  lib/SPVM/Builder/src/spvm_use.c
  lib/SPVM/Builder/src/spvm_var.c
  lib/SPVM/Builder/src/spvm_yacc.c
  lib/SPVM/Builder/src/spvm_yacc_util.c
);
my @csource_files = ('SPVM.c', @spvm_csource_files);

# Header files(This is only used to resolve dependencies)
my @spvm_header_files = glob 'lib/SPVM/Builder/include/*.h';
my @header_files = ('ppport.h', @spvm_header_files);

WriteMakefile(
    NAME              => 'SPVM',
    VERSION_FROM      => 'lib/SPVM.pm', # finds $VERSION
    PREREQ_PM         => {}, # e.g., Module::Name => 1.1
    LICENSE           => 'perl_5',
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM  => 'lib/SPVM.pm', # retrieve abstract from module
       AUTHOR         => 'Yuki Kimoto<kimoto.yuki@gmail.com>') : ()),
    CCFLAGS => $ccflags,
    OPTIMIZE => $optimize,
    C => [@csource_files],
    H => [@header_files],
    OBJECT            => '$(O_FILES)', # link all the C files too
    INC => $inc,
    test => {TESTS => 't/*.t t/*/*.t t/*/*/*.t'},
    clean => {FILES => "SPVM.o lib/SPVM/Builder/src/*.o .spvm_build t/.spvm_build t/default/.spvm_build t/precompile t/test_files_tmp t/exe/.spvm_build"},
    DEFINE => "@defines -o \$@",
    META_MERGE => {
        'meta-spec' => { version => 2 },
        resources => {
            repository => {
                type => 'git',
                url  => 'https://github.com/yuki-kimoto/SPVM.git',
                web  => 'https://github.com/yuki-kimoto/SPVM',
            },
        },
    },
    EXE_FILES => ['script/spvmcc'],
    PREREQ_PM => {
        'ExtUtils::CBuilder' => '0.2602',
    },
);

# Add Build shared library make rule
sub MY::postamble {
  
  # The content of Makefile
  my $make_rule = '';
  
  # Compile native and precompile codes of standard modules
  unless (grep { $_ eq '-DSPVM_DONT_COMPILE_CORE_MODULES' } @defines) {
    # Native compile make rule
    $make_rule .= SPVM::Builder::Util::create_make_rule_native('Fn');
    $make_rule .= SPVM::Builder::Util::create_make_rule_native('Hash');
    $make_rule .= SPVM::Builder::Util::create_make_rule_native('Time');
    $make_rule .= SPVM::Builder::Util::create_make_rule_native('Unicode');
    
    # Precompile make rule
    $make_rule .= SPVM::Builder::Util::create_make_rule_precompile('Fn');
    $make_rule .= SPVM::Builder::Util::create_make_rule_precompile('List');
    $make_rule .= SPVM::Builder::Util::create_make_rule_precompile('ByteList');
    $make_rule .= SPVM::Builder::Util::create_make_rule_precompile('ShortList');
    $make_rule .= SPVM::Builder::Util::create_make_rule_precompile('IntList');
    $make_rule .= SPVM::Builder::Util::create_make_rule_precompile('LongList');
    $make_rule .= SPVM::Builder::Util::create_make_rule_precompile('FloatList');
    $make_rule .= SPVM::Builder::Util::create_make_rule_precompile('DoubleList');
    $make_rule .= SPVM::Builder::Util::create_make_rule_precompile('StringList');
    $make_rule .= SPVM::Builder::Util::create_make_rule_precompile('StringBuffer');
    $make_rule .= SPVM::Builder::Util::create_make_rule_precompile('Hash');
    $make_rule .= SPVM::Builder::Util::create_make_rule_precompile('Unicode');
    $make_rule .= SPVM::Builder::Util::create_make_rule_precompile('Regex');
  }
  
  # Create precompile tests
  my @test_files;
  find(
    sub {
      if (-f $File::Find::name) {
        my $rel_path = $File::Find::name;
        $rel_path =~ s|^\Q$FindBin::Bin/||;
        if ($rel_path =~ /(\.t|\.pm|\.spvm|\.c|\.cpp|\.h)$/) {
          push @test_files, $rel_path;
        }
      }
    },
    "$FindBin::Bin/t/default"
  );
  my $test_files_str = join(' ', @test_files);
  $make_rule .= "dynamic :: $test_files_str\n";
  $make_rule .= "\tperl t/copy_default_to_precompile.pl\n";
  
  return $make_rule;
}

1;
