package Sah::Schema::date::dow_nums::id;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-08-04'; # DATE
our $DIST = 'Sah-Schemas-Date-ID'; # DIST
our $VERSION = '0.006'; # VERSION

our $schema = ['array' => {
    summary => 'Array of required day-of-week numbers (1-7, 1=Monday, like DateTime, with coercions)',
    of => ['date::dow_num::id', {req=>1}],
    'x.perl.coerce_rules' => ['From_str::comma_sep'],
    'x.completion' => ['date_dow_nums_id'],
    description => <<'_',

See also <pm:Sah::Schema::date::dow_num::id> which is the schema for the
elements.

See also related schemas that coerce from other locales, e.g.
<pm:Sah::Schema::date::dow_nums> (English),
<pm:Sah::Schema::date::dow_num::en_or_id> (English/Indonesian), etc.

_
    examples => [
        {value=>'', valid=>1, validated_value=>[]},
        {value=>0, valid=>0, summary=>'Has number not in 1-7'},
        {value=>1, valid=>1, validated_value=>[1]},
        {value=>"1,7", valid=>1, validated_value=>[1,7]},
        {value=>[1,undef], valid=>0, summary=>'Contains undef'},
        {value=>[1,7], valid=>1},
        {value=>["Sen","MinggU"], valid=>1, validated_value=>[1,7]},
        {value=>'Sn,MG', valid=>1, validated_value=>[1,7]},
        {value=>"1,7,8", valid=>0, summary=>'Has number not in 1-7'},
        {value=>[1,7,8], valid=>0, summary=>'Has number not in 1-7'},
    ],
}];

1;

# ABSTRACT: Array of required day-of-week numbers (1-7, 1=Monday, like DateTime, with coercions)

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::Schema::date::dow_nums::id - Array of required day-of-week numbers (1-7, 1=Monday, like DateTime, with coercions)

=head1 VERSION

This document describes version 0.006 of Sah::Schema::date::dow_nums::id (from Perl distribution Sah-Schemas-Date-ID), released on 2021-08-04.

=head1 SYNOPSIS

To check data against this schema (requires L<Data::Sah>):

 use Data::Sah qw(gen_validator);
 my $validator = gen_validator("date::dow_nums::id*");
 say $validator->($data) ? "valid" : "INVALID!";

 # Data::Sah can also create validator that returns nice error message string
 # and/or coerced value. Data::Sah can even create validator that targets other
 # language, like JavaScript. All from the same schema. See its documentation
 # for more details.

To validate function parameters against this schema (requires L<Params::Sah>):

 use Params::Sah qw(gen_validator);

 sub myfunc {
     my @args = @_;
     state $validator = gen_validator("date::dow_nums::id*");
     $validator->(\@args);
     ...
 }

To specify schema in L<Rinci> function metadata and use the metadata with
L<Perinci::CmdLine> to create a CLI:

 # in lib/MyApp.pm
 package
   MyApp;
 our %SPEC;
 $SPEC{myfunc} = {
     v => 1.1,
     summary => 'Routine to do blah ...',
     args => {
         arg1 => {
             summary => 'The blah blah argument',
             schema => ['date::dow_nums::id*'],
         },
         ...
     },
 };
 sub myfunc {
     my %args = @_;
     ...
 }
 1;

 # in myapp.pl
 package
   main;
 use Perinci::CmdLine::Any;
 Perinci::CmdLine::Any->new(url=>'/MyApp/myfunc')->run;

 # in command-line
 % ./myapp.pl --help
 myapp - Routine to do blah ...
 ...

 % ./myapp.pl --version

 % ./myapp.pl --arg1 ...

Sample data:

 ""  # valid, becomes []

 0  # INVALID (Has number not in 1-7)

 1  # valid, becomes [1]

 "1,7"  # valid, becomes [1,7]

 [1,undef]  # INVALID (Contains undef)

 [1,7]  # valid

 ["Sen","MinggU"]  # valid, becomes [1,7]

 "Sn,MG"  # valid, becomes [1,7]

 "1,7,8"  # INVALID (Has number not in 1-7)

 [1,7,8]  # INVALID (Has number not in 1-7)

=head1 DESCRIPTION

Like the L<date::dow_nums|Sah::Schema::date::dow_nums> except the elements are
L<date::dow_num::id|Sah::Schema::date::dow_num::id> instead of
L<date::dow_num|Sah::Schema::date::dow_num>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Date-ID>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Date-ID>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Date-ID>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Sah::Schema::date::dow_nums>

L<Sah::Schema::date::dow_nums::en_or_id>

L<Sah::Schema::date::dow_num::id>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2020, 2019 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
