package Sah::SchemaR::perl::tables::modname;

our $DATE = '2020-11-10'; # DATE
our $VERSION = '0.001'; # VERSION

our $rschema = ["str",[{description=>"\nContains coercion rule so you can also input `Foo-Bar`, `Foo/Bar`, `Foo/Bar.pm`\nor even 'Foo.Bar' and it will be normalized into `Foo::Bar`.\n\n",examples=>[{valid=>0,value=>""},{valid=>1,value=>"Foo::Bar"},{valid=>1,validated_value=>"Foo::Bar",value=>"Foo-Bar"},{valid=>1,validated_value=>"Foo::Bar",value=>"Foo/Bar"},{valid=>1,validated_value=>"Foo::Bar",value=>"Foo/Bar.pm"},{valid=>1,validated_value=>"Foo::Bar",value=>"Foo.Bar"},{valid=>0,value=>"Foo|Bar"}],match=>"\\A[A-Za-z_][A-Za-z_0-9]*(::[A-Za-z_0-9]+)*\\z",summary=>"Perl module name, e.g. Foo::Bar","x.completion"=>"perl_modname","x.perl.coerce_rules"=>["From_str::normalize_perl_modname"]},{description=>"\nContains coercion rule so you can also input `Sample-DeNiro`, `Sample/DeNiro`, `Sample/DeNiro.pm`\nor even 'Sample.DeNiro' and it will be normalized into `Sample::DeNiro`.\n\n",examples=>[{valid=>0,value=>""},{valid=>1,validated_value=>"Foo::Bar",value=>"Foo/Bar"},{valid=>0,value=>"Foo bar"}],match=>"\\A[A-Za-z_][A-Za-z_0-9]*(::[A-Za-z_0-9]+)*\\z",summary=>"Perl Tables::* module name without the prefix, e.g. Sample::DeNiro","x.completion"=>["perl_modname",{ns_prefix=>"Tables"}],"x.perl.coerce_rules"=>["From_str::normalize_perl_modname"]}],["perl::modname","str"]];

1;
# ABSTRACT: Perl Tables::* module name without the prefix, e.g. Sample::DeNiro

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::perl::tables::modname - Perl Tables::* module name without the prefix, e.g. Sample::DeNiro

=head1 VERSION

This document describes version 0.001 of Sah::SchemaR::perl::tables::modname (from Perl distribution Sah-Schemas-Tables), released on 2020-11-10.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Tables>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Tables>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Tables>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
