
package Google::Ads::AdWords::v201708::OfflineDataUploadService::mutate;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'https://adwords.google.com/api/adwords/rm/v201708' }

__PACKAGE__->__set_name('mutate');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    Google::Ads::SOAP::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %operations_of :ATTR(:get<operations>);

__PACKAGE__->_factory(
    [ qw(        operations

    ) ],
    {
        'operations' => \%operations_of,
    },
    {
        'operations' => 'Google::Ads::AdWords::v201708::OfflineDataUploadOperation',
    },
    {

        'operations' => 'operations',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

Google::Ads::AdWords::v201708::OfflineDataUploadService::mutate

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
mutate from the namespace https://adwords.google.com/api/adwords/rm/v201708.

Uploads offline data for each entry in operations. Some operations can fail for upload level errors like invalid {@code UploadMetadata}. Check {@code OfflineDataUploadReturnValue} for partial failure list. <p><b>Note:</b> Operation might possibly succeed even with errors in {@code OfflineData}. Data errors are reported in {@link OfflineDataUpload#partialDataErrors} <p><b>Note:</b> Supports only the {@code ADD} operator. ({@code SET} and {@code REMOVE} are not supported. @param operations A list of Offline data upload operations. @return The list of offline data upload results in the same order as operations. @throws {@link ApiException} if problems occur. 





=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * operations

 $element->set_operations($data);
 $element->get_operations();





=back


=head1 METHODS

=head2 new

 my $element = Google::Ads::AdWords::v201708::OfflineDataUploadService::mutate->new($data);

Constructor. The following data structure may be passed to new():

 {
   operations =>  $a_reference_to, # see Google::Ads::AdWords::v201708::OfflineDataUploadOperation
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

