package Google::Ads::AdWords::v201708::FeedAttributeReferenceError;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201708' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201708::ApiError);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %fieldPath_of :ATTR(:get<fieldPath>);
my %fieldPathElements_of :ATTR(:get<fieldPathElements>);
my %trigger_of :ATTR(:get<trigger>);
my %errorString_of :ATTR(:get<errorString>);
my %ApiError__Type_of :ATTR(:get<ApiError__Type>);
my %reason_of :ATTR(:get<reason>);
my %feedName_of :ATTR(:get<feedName>);
my %feedAttributeName_of :ATTR(:get<feedAttributeName>);

__PACKAGE__->_factory(
    [ qw(        fieldPath
        fieldPathElements
        trigger
        errorString
        ApiError__Type
        reason
        feedName
        feedAttributeName

    ) ],
    {
        'fieldPath' => \%fieldPath_of,
        'fieldPathElements' => \%fieldPathElements_of,
        'trigger' => \%trigger_of,
        'errorString' => \%errorString_of,
        'ApiError__Type' => \%ApiError__Type_of,
        'reason' => \%reason_of,
        'feedName' => \%feedName_of,
        'feedAttributeName' => \%feedAttributeName_of,
    },
    {
        'fieldPath' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'fieldPathElements' => 'Google::Ads::AdWords::v201708::FieldPathElement',
        'trigger' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'errorString' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'ApiError__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'reason' => 'Google::Ads::AdWords::v201708::FeedAttributeReferenceError::Reason',
        'feedName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'feedAttributeName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'fieldPath' => 'fieldPath',
        'fieldPathElements' => 'fieldPathElements',
        'trigger' => 'trigger',
        'errorString' => 'errorString',
        'ApiError__Type' => 'ApiError.Type',
        'reason' => 'reason',
        'feedName' => 'feedName',
        'feedAttributeName' => 'feedAttributeName',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201708::FeedAttributeReferenceError

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
FeedAttributeReferenceError from the namespace https://adwords.google.com/api/adwords/cm/v201708.

An error indicating a problem with a reference to a feed attribute in an ad. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * reason


=item * feedName


=item * feedAttributeName




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

