package Netstack::Utils::Cache;

#------------------------------------------------------------------------------
# 加载扩展模块功能
#------------------------------------------------------------------------------
use 5.016;
use Moose;
use namespace::autoclean;

#------------------------------------------------------------------------------
# 定义 Netstack::Utils::Cache 方法属性
#------------------------------------------------------------------------------
has cache => (
  is      => 'ro',
  isa     => 'HashRef[Ref]',
  default => sub { {} },
);

#------------------------------------------------------------------------------
# get 加载缓存对象
#------------------------------------------------------------------------------
sub get {
  my $self = shift;
  return $self->locate(@_);
}

#------------------------------------------------------------------------------
# set 设置缓存
#------------------------------------------------------------------------------
sub set {
  my $self = shift;
  # 入参检查，异常拦截
  confess "ERROR: must have at least one key and one value" if @_ < 2;
  # 截取最后的键值对
  my $lastValue = pop;
  my $lastKey   = pop;

  my @keys = @_;
  my @step;
  my $ref = $self->cache;
  while ( my $key = shift @keys ) {
    push @step, $key;
    if ( not exists $ref->{$key} ) {
      $ref->{$key} = undef;
    }
    $ref = $ref->{$key};
    if ( defined $ref and ref($ref) ne 'HASH' ) {
      confess "ERROR: cache->" . join( '->', @step ) . " not a valid HashRef";
    }
  }
  $ref->{$lastKey} = $lastValue;
}

#------------------------------------------------------------------------------
# clear 清除缓存键值对
#------------------------------------------------------------------------------
sub clear {
  my $self = shift;
  my @keys = @_;
  if (@keys) {
    my $lastKey = pop @keys;
    my $ref     = $self->locate(@keys);
    if ( defined $ref and ref($ref) eq 'HASH' ) {
      delete( $ref->{$lastKey} );
    }
  }
  else {
    $self->cache = {};
  }
}

#------------------------------------------------------------------------------
# locate 加载缓存 | 此处不会自动去重
#------------------------------------------------------------------------------
sub locate {
  my $self = shift;
  my @keys = @_;
  my $ref  = $self->cache;

  # 检查是否存在缓存
  while ( my $key = shift @keys ) {
    return if not exists $ref->{$key};
    $ref = $ref->{$key};
  }

  # 返回计算结果
  return $ref;
}

__PACKAGE__->meta->make_immutable;
1;
