package Statocles::Plugin::AudioTag;
our $AUTHORITY = 'cpan:GENE';

# ABSTRACT: Change audio file anchors to audio elements

our $VERSION = '0.0104';

use v5.20.0;

use Statocles::Base 'Class';
with 'Statocles::Plugin';


has file_type => (
    is      => 'ro',
    isa     => Str,
    default => sub { 'mp3' },
);


sub register {
    my ($self, $site) = @_;
    $site->on(build => sub {
        my ($event) = @_;
        for my $page ($event->pages->@*) {
            if ($page->DOES('Statocles::Page::Document')) {
                $page->dom->find('a[href$=.'. $self->file_type .']' )->each(sub {
                    my ($el) = @_;
                    $el->replace(sprintf '<audio controls><source type="audio/%s" src="%s"></audio>', $self->file_type, $el->attr('href'));
                } );
            }
        }
    });
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Statocles::Plugin::AudioTag - Change audio file anchors to audio elements

=head1 VERSION

version 0.0104

=head1 SYNOPSIS

  # site.yml
  site:
    class: Statocles::Site
    args:
        plugins:
            audio_tag:
                $class: Statocles::Plugin::AudioTag
                $args:
                     file_type: 'ogg'

=head1 DESCRIPTION

C<Statocles::Plugin::AudioTag> changes audio file anchor elements to
audio elements.

=head1 ATTRIBUTES

=head2 file_type

The file type to replace.

Default: C<mp3>

=head1 METHODS

=head2 register

Register this plugin to install its event handlers. Called automatically.

=head1 SEE ALSO

L<Statocles>

L<Statocles::Plugin>

=head1 AUTHOR

Gene Boggs <gene@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by Gene Boggs.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
