package Bencher::Scenario::StringFunctions::Trim;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-06-16'; # DATE
our $DIST = 'Bencher-Scenarios-StringFunctions'; # DIST
our $VERSION = '0.002'; # VERSION

use strict;
use warnings;

our $scenario = {
    summary => "Benchmark string trimming (removing whitespace at the start and end of string)",
    participants => [
        #{fcall_template=>'String::Trim::trim(<str>)'}, # currently disabled, see https://github.com/doherty/String-Trim/issues/7
        {fcall_template=>'String::Trim::More::trim(<str>)'},
        {fcall_template=>'String::Trim::NonRegex::trim(<str>)'},
        {fcall_template=>'String::Trim::Regex::trim(<str>)'},
        {fcall_template=>'String::Util::trim(<str>)'},
    ],
    datasets => [
        {name=>'empty'        , args=>{str=>''}},
        {name=>'len10ws1'     , args=>{str=>' '.('x' x   10).' '}},
        {name=>'len100ws1'    , args=>{str=>' '.('x' x  100).' '}},
        {name=>'len100ws10'   , args=>{str=>(' ' x   10).('x' x  100).(' ' x 10)}},
        {name=>'len100ws100'  , args=>{str=>(' ' x  100).('x' x  100).(' ' x 100)}},
        {name=>'len1000ws1'   , args=>{str=>' '.('x' x 1000).' '}},
        {name=>'len1000ws10'  , args=>{str=>(' ' x   10).('x' x 1000).(' ' x 10)}},
        {name=>'len1000ws100' , args=>{str=>(' ' x  100).('x' x 1000).(' ' x 100)}},
        {name=>'len1000ws1000', args=>{str=>(' ' x 1000).('x' x 1000).(' ' x 1000)}},
    ],
};

1;
# ABSTRACT: Benchmark string trimming (removing whitespace at the start and end of string)

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::StringFunctions::Trim - Benchmark string trimming (removing whitespace at the start and end of string)

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::StringFunctions::Trim (from Perl distribution Bencher-Scenarios-StringFunctions), released on 2021-06-16.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m StringFunctions::Trim

To run module startup overhead benchmark:

 % bencher --module-startup -m StringFunctions::Trim

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<String::Trim::More> 0.03

L<String::Trim::NonRegex> 0.001

L<String::Trim::Regex> 20210604

L<String::Util> 1.32

=head1 BENCHMARK PARTICIPANTS

=over

=item * String::Trim::More::trim (perl_code)

Function call template:

 String::Trim::More::trim(<str>)



=item * String::Trim::NonRegex::trim (perl_code)

Function call template:

 String::Trim::NonRegex::trim(<str>)



=item * String::Trim::Regex::trim (perl_code)

Function call template:

 String::Trim::Regex::trim(<str>)



=item * String::Util::trim (perl_code)

Function call template:

 String::Util::trim(<str>)



=back

=head1 BENCHMARK DATASETS

=over

=item * empty

=item * len10ws1

=item * len100ws1

=item * len100ws10

=item * len100ws100

=item * len1000ws1

=item * len1000ws10

=item * len1000ws100

=item * len1000ws1000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.34.0 >>, CPU: I<< Intel(R) Core(TM) i5-7200U CPU @ 2.50GHz (2 cores) >>, OS: I<< GNU/Linux Ubuntu version 20.04 >>, OS kernel: I<< Linux version 5.3.0-64-generic >>.

Benchmark with default options (C<< bencher -m StringFunctions::Trim >>):

 #table1#
 {dataset=>"empty"}
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                  | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | String::Util::trim           |    520000 |      1.9  |                 0.00% |               276.49% | 3.3e-09 |      20 |
 | String::Trim::NonRegex::trim |    700000 |      1    |                34.65% |               179.60% |   8e-08 |      34 |
 | String::Trim::More::trim     |   1600000 |      0.61 |               216.36% |                19.01% | 1.9e-09 |      20 |
 | String::Trim::Regex::trim    |   1900000 |      0.52 |               276.49% |                 0.00% | 3.5e-09 |      21 |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+

 #table2#
 {dataset=>"len1000ws1"}
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                  | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | String::Trim::Regex::trim    |      5900 |     170   |                 0.00% |              6768.62% | 2.7e-07 |      20 |
 | String::Util::trim           |     23000 |      43   |               297.53% |              1627.84% | 5.3e-08 |      20 |
 | String::Trim::NonRegex::trim |    300000 |       3.3 |              4983.90% |                35.11% | 1.5e-08 |      20 |
 | String::Trim::More::trim     |    400000 |       2.5 |              6768.62% |                 0.00% | 4.2e-09 |      20 |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+

 #table3#
 {dataset=>"len1000ws10"}
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                  | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | String::Trim::Regex::trim    |      5700 |     180   |                 0.00% |              6979.99% | 8.1e-07 |      22 |
 | String::Util::trim           |     20000 |      49   |               257.49% |              1880.48% | 1.1e-07 |      22 |
 | String::Trim::NonRegex::trim |     84000 |      12   |              1381.40% |               377.92% | 1.3e-08 |      20 |
 | String::Trim::More::trim     |    400000 |       2.5 |              6979.99% |                 0.00% | 3.3e-09 |      20 |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+

 #table4#
 {dataset=>"len1000ws100"}
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                  | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | String::Trim::Regex::trim    |      5900 |     170   |                 0.00% |              6383.02% | 2.1e-07 |      20 |
 | String::Trim::NonRegex::trim |      9000 |     100   |                46.95% |              4311.63% | 3.1e-06 |      20 |
 | String::Util::trim           |     23000 |      43   |               297.42% |              1531.29% | 5.3e-08 |      20 |
 | String::Trim::More::trim     |    380000 |       2.6 |              6383.02% |                 0.00% | 3.3e-09 |      20 |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+

 #table5#
 {dataset=>"len1000ws1000"}
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                  | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | String::Trim::NonRegex::trim |      1100 |     920   |                 0.00% |             24266.77% | 1.8e-06 |      20 |
 | String::Trim::Regex::trim    |      5800 |     170   |               436.16% |              4444.69% | 2.7e-07 |      20 |
 | String::Util::trim           |     23000 |      44   |              1981.75% |              1070.49% | 6.5e-08 |      21 |
 | String::Trim::More::trim     |    260000 |       3.8 |             24266.77% |                 0.00% | 6.7e-09 |      20 |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+

 #table6#
 {dataset=>"len100ws1"}
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                  | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | String::Trim::Regex::trim    |     53102 |    18.832 |                 0.00% |               660.17% | 4.5e-11 |      20 |
 | String::Util::trim           |     71000 |    14     |                34.37% |               465.73% | 2.7e-08 |      20 |
 | String::Trim::NonRegex::trim |    310000 |     3.2   |               483.90% |                30.19% | 1.3e-08 |      20 |
 | String::Trim::More::trim     |    400000 |     2.5   |               660.17% |                 0.00% | 6.8e-09 |      20 |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+

 #table7#
 {dataset=>"len100ws10"}
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                  | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | String::Trim::Regex::trim    |     53000 |      19   |                 0.00% |               647.47% | 3.3e-08 |      20 |
 | String::Util::trim           |     72000 |      14   |                36.82% |               446.30% | 3.3e-08 |      20 |
 | String::Trim::NonRegex::trim |     84000 |      12   |                60.14% |               366.77% | 1.3e-08 |      20 |
 | String::Trim::More::trim     |    390000 |       2.5 |               647.47% |                 0.00% | 1.1e-08 |      20 |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+

 #table8#
 {dataset=>"len100ws100"}
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                  | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | String::Trim::NonRegex::trim |     10000 |        96 |                 0.00% |              7887.53% | 1.1e-07 |      20 |
 | String::Trim::Regex::trim    |     52000 |        19 |               396.11% |              1510.03% | 2.6e-08 |      21 |
 | String::Util::trim           |    200000 |         7 |              1366.84% |               444.54% | 8.5e-08 |      20 |
 | String::Trim::More::trim     |    800000 |         1 |              7887.53% |                 0.00% | 1.7e-08 |      24 |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+

 #table9#
 {dataset=>"len10ws1"}
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                  | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | String::Trim::Regex::trim    |    280000 |       3.6 |                 0.00% |                76.85% | 6.7e-09 |      20 |
 | String::Util::trim           |    310000 |       3.3 |                 9.01% |                62.24% | 6.7e-09 |      20 |
 | String::Trim::NonRegex::trim |    310000 |       3.3 |                 9.07% |                62.15% | 6.7e-09 |      20 |
 | String::Trim::More::trim     |    500000 |       2   |                76.85% |                 0.00% | 6.7e-09 |      20 |
 +------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m StringFunctions::Trim --module-startup >>):

 #table10#
 +------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | participant            | time (ms) | mod_overhead_time | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors   | samples |
 +------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | String::Util           |        23 |                13 |                 0.00% |               104.86% | 9.4e-05   |      20 |
 | String::Trim::Regex    |        21 |                11 |                 8.32% |                89.12% |   0.00021 |      20 |
 | String::Trim::More     |        20 |                10 |                36.41% |                50.18% |   0.00021 |      20 |
 | String::Trim::NonRegex |        16 |                 6 |                46.69% |                39.66% |   0.00014 |      20 |
 | perl -e1 (baseline)    |        10 |                 0 |               104.86% |                 0.00% |   0.0002  |      20 |
 +------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+


To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-StringFunctions>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-StringFunctions>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-StringFunctions>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
