# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230305170052;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"4939454", "Elbingerode\ Harz",
"497843", "Renchen",
"496405", "Laubach\ Hessen",
"498250", "Hilgertshausen\-Tandern",
"499384", "Schwanfeld",
"4936332", "Ellrich",
"492448", "Hellenthal\-Rescheid",
"496552", "Olzheim",
"492758", "Bad\ Berleburg\-Girkhausen",
"493863", "Crivitz",
"496362", "Alsenz",
"497675", "Bernau\ Baden",
"495685", "Knüllwald",
"495103", "Wennigsen\ Deister",
"4939777", "Borkenfriede",
"496085", "Waldsolms",
"492333", "Ennepetal",
"4933835", "Golzow\ bei\ Brandenburg",
"496744", "Oberwesel",
"499732", "Hammelburg",
"496454", "Lichtenfels\-Sachsenberg",
"495945", "Wilsum",
"498649", "Schleching",
"4937423", "Adorf\ Vogtland",
"494955", "Westoverledingen",
"498751", "Mainburg",
"496337", "Grossbundenbach",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"497202", "Karlsbad",
"494833", "Wesselburen",
"4935053", "Glashütte\ Sachsen",
"497325", "Sontheim\ an\ der\ Brenz",
"4935209", "Mohorn",
"493529", "Heidenau\ Sachsen",
"499653", "Eslarn",
"497708", "Geisingen\-Leipferdingen",
"497461", "Tuttlingen",
"4938756", "Grabow",
"492324", "Hattingen\ Ruhr",
"494276", "Borstel\ bei\ Sulingen",
"499238", "Röslau",
"497669", "St\ Märgen",
"497125", "Bad\ Urach",
"497221", "Baden\-Baden",
"493441", "Zeitz",
"4936965", "Stadtlengsfeld",
"492252", "Zülpich",
"499184", "Deining\ Oberpfalz",
"4939928", "Möllenhagen",
"497771", "Stockach",
"494481", "Hatten\-Sandkrug",
"492674", "Bad\ Bertrich",
"4934422", "Osterfeld",
"494824", "Krempe",
"4938853", "Drönnewitz\ bei\ Hagenow",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"497720", "Schwenningen\ am\ Neckar",
"495266", "Lemgo\-Kirchheide",
"498027", "Dietramszell",
"492133", "Dormagen",
"495426", "Glandorf",
"495303", "Wendeburg",
"496162", "Reinheim\ Odenwald",
"496668", "Birstein\-Lichenroth",
"495068", "Elze\ Leine",
"4933742", "Oehna\ Brandenburg",
"497939", "Schrozberg\-Spielbach",
"499865", "Adelshofen\ Mittelfranken",
"494253", "Asendorf\ Kreis\ Diepholz",
"4933203", "Kleinmachnow",
"496697", "Willingshausen",
"499676", "Winklarn",
"4935025", "Liebstadt",
"498454", "Karlshuld",
"498744", "Gerzen",
"499292", "Konradsreuth",
"4939366", "Kehnert",
"498846", "Uffing\ am\ Staffelsee",
"495177", "Edemissen\-Abbensen",
"4939037", "Pretzier",
"494638", "Tarp",
"494132", "Amelinghausen",
"494506", "Stockelsdorf\-Krumbeck",
"498337", "Altenstadt\ Iller",
"496441", "Wetzlar",
"495978", "Hörstel\-Dreierwalde",
"496751", "Bad\ Sobernheim",
"4935697", "Bagenz",
"4936703", "Gräfenthal",
"499326", "Markt\ Einersheim",
"499531", "Ebern",
"498405", "Stammham\ bei\ Ingolstadt",
"497142", "Bietigheim\-Bissingen",
"497528", "Neukirch\ bei\ Tettnang",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"492693", "Antweiler",
"499403", "Donaustauf",
"498085", "Sankt\ Wolfgang",
"4939406", "Harbke",
"495802", "Wrestedt",
"499083", "Möttingen",
"494167", "Apensen",
"4939388", "Goldbeck\ Altm",
"495901", "Fürstenau\ bei\ Bramsche",
"4937381", "Penig",
"499289", "Schwarzenbach\ am\ Wald",
"498552", "Grafenau\ Niederbayern",
"4933932", "Fehrbellin",
"4934293", "Naunhof\ bei\ Grimma",
"498362", "Füssen",
"494968", "Neulehe",
"4937367", "Lengefeld\ Erzgebirge",
"4936602", "Ronneburg\ Thüringen",
"498709", "Eching\ Niederbayern",
"4936023", "Horsmar",
"4939600", "Zwiedorf",
"499126", "Eckental",
"4933457", "Altreetz",
"492779", "Greifenstein\-Beilstein",
"495484", "Lienen\-Kattenvenne",
"497474", "Haigerloch",
"493362", "Erkner",
"492360", "Haltern\-Lippramsdorf",
"495922", "Bad\ Bentheim",
"495821", "Bad\ Bevensen",
"4933969", "Stepenitz",
"494557", "Blunk",
"494367", "Grossenbrode",
"496027", "Stockstadt\ am\ Main",
"492832", "Kevelaer",
"492931", "Arnsberg",
"4938825", "Klütz",
"495582", "Sankt\ Andreasberg",
"497572", "Mengen\ Württemberg",
"493744", "Auerbach\ Vogtland",
"495055", "Fassberg",
"49375", "Zwickau",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"496655", "Neuhof\ Kreis\ Fulda",
"493496", "Köthen\ Anhalt",
"4936841", "Schleusingen",
"492661", "Bad\ Marienberg\ Westerwald",
"4934975", "Görzig\ Kreis\ Köthen",
"497764", "Herrischried",
"4934495", "Dobitschen",
"493337", "Biesenthal\ Brandenburg",
"4935474", "Schönwalde\ bei\ Lübben",
"498137", "Petershausen",
"494332", "Hamdorf\ bei\ Rendsburg",
"497387", "Hohenstein\ Württemberg",
"4938486", "Gustävel",
"495377", "Ehra\-Lessien",
"4938308", "Göhren\ Rügen",
"492867", "Heiden\ Kreis\ Borken",
"4939224", "Büden",
"4937292", "Oederan",
"499088", "Mönchsdeggingen",
"4939951", "Faulenrost",
"496630", "Schwalmtal\-Storndorf",
"4939207", "Colbitz",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"4938727", "Mestlin",
"493663", "Schleiz",
"494963", "Dörpen",
"4938332", "Gross\ Bisdorf",
"499286", "Oberkotzau",
"4939489", "Strassberg\ Harz",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"495164", "Hodenhagen",
"499408", "Altenthann",
"492192", "Hückeswagen",
"4934263", "Hohburg",
"497643", "Herbolzheim\ Breisgau",
"496331", "Pirmasens",
"4939087", "Jerchel\ Altmark",
"494633", "Satrup",
"496526", "Bollendorf",
"493933", "Genthin",
"496646", "Grebenau",
"4937206", "Frankenberg\ Sachsen",
"4939061", "Weferlingen",
"4938854", "Redefin",
"499260", "Wilhelmsthal\ Oberfranken",
"498584", "Breitenberg\ Niederbayern",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"499420", "Feldkirchen\ Niederbayern",
"495248", "Langenberg\ Kreis\ Gütersloh",
"4939396", "Neukirchen\ Altmark",
"494258", "Schwarme",
"499471", "Burglengenfeld",
"494174", "Stelle\ Kreis\ Harburg",
"494509", "Gross\ Grönau",
"492535", "Sendenhorst\-Albersloh",
"497227", "Lichtenau\ Baden",
"495742", "Preussisch\ Oldendorf",
"494442", "Lohne\ Oldenburg",
"495452", "Mettingen\ Westfalen",
"494752", "Neuhaus\ Oste",
"4939453", "Derenburg",
"499935", "Stephansposching",
"497534", "Reichenau\ Baden",
"493447", "Altenburg\ Thüringen",
"492389", "Werne",
"4934909", "Aken\ Elbe",
"4933395", "Zerpenschleuse",
"496235", "Schifferstadt",
"496131", "Mainz",
"493691", "Eisenach\ Thüringen",
"494892", "Schenefeld\ Mittelholstein",
"4934465", "Bad\ Bibra",
"492226", "Rheinbach",
"4939248", "Dobritz",
"495505", "Hardegsen",
"497467", "Neuhausen\ ob\ Eck",
"499853", "Wilburgstetten",
"4937349", "Scheibenberg",
"498663", "Ruhpolding",
"499129", "Wendelstein",
"4936922", "Gerstungen",
"496868", "Mettlach\-Tünsdorf",
"49591", "Lingen\ \(Ems\)",
"498021", "Waakirchen",
"498706", "Vilsheim",
"499665", "Königstein\ Oberpfalz",
"4939972", "Walkendorf",
"492776", "Bad\ Endbach\-Hartenrod",
"492874", "Isselburg",
"494544", "Berkenthin",
"492392", "Werdohl",
"495364", "Velpke",
"4933479", "Küstrin\-Kietz",
"494624", "Kropp",
"495554", "Moringen",
"494487", "Grossenkneten\-Huntlosen",
"497777", "Sauldorf",
"497432", "Albstadt\-Tailfingen",
"4935054", "Lauenstein\ Sachsen",
"495171", "Peine",
"495275", "Höxter\-Ottbergen",
"497181", "Schorndorf\ Württemberg",
"496584", "Wellen\ Mosel",
"4936024", "Diedorf\ bei\ Mühlhausen",
"496757", "Becherbach\ bei\ Kirn",
"498331", "Memmingen",
"494838", "Tellingstedt",
"496447", "Langgöns\-Niederkleen",
"4935823", "Ostritz",
"499774", "Oberelsbach",
"494393", "Boostedt",
"499876", "Rohr\ Mittelfranken",
"496691", "Schwalmstadt",
"4934746", "Giersleben",
"4935952", "Grossröhrsdorf\ OL",
"496849", "Kirkel",
"496897", "Sulzbach\ Saar",
"499562", "Sonnefeld",
"499352", "Lohr\ am\ Main",
"494161", "Buxtehude",
"494265", "Fintel",
"495907", "Geeste",
"492753", "Erndtebrück",
"493868", "Rastow",
"492443", "Mechernich",
"492338", "Breckerfeld",
"498630", "Oberneukirchen",
"4935726", "Gross\ Särchen",
"496002", "Ober\-Mörlen",
"499464", "Walderbach",
"495108", "Gehrden\ Han",
"495602", "Hessisch\ Lichtenau",
"4933876", "Buschow",
"496482", "Runkel",
"4935473", "Neu\ Lübbenau",
"4939223", "Theessen",
"4934635", "Bad\ Lauchstädt",
"495725", "Lindhorst\ bei\ Stadthagen",
"494425", "Wangerland\-Hooksiel",
"495308", "Lehre",
"495827", "Unterlüss",
"4935268", "Stauchitz",
"4933204", "Beelitz\ Mark",
"492632", "Andernach",
"496021", "Aschaffenburg",
"495063", "Bad\ Salzdetfurth",
"496706", "Wallhausen\ Nahe",
"492937", "Arnsberg\-Oeventrop",
"4939608", "Staven",
"495541", "Hann\.\ Münden",
"4937601", "Mülsen\ Skt\ Jacob",
"494551", "Bad\ Segeberg",
"496663", "Steinau\ an\ der\ Strasse",
"495621", "Bad\ Wildungen",
"498868", "Schwabsoien",
"494361", "Oldenburg\ in\ Holstein",
"4939886", "Milmersdorf",
"496804", "Mandelbachtal",
"495429", "Melle\-Wellingholzhausen",
"497936", "Schrozberg\-Bartenstein",
"496190", "Hattersheim\ am\ Main",
"495956", "Rastdorf",
"4936704", "Steinheid",
"493331", "Angermünde",
"498131", "Dachau",
"492667", "Stein\-Neukirch",
"494946", "Grossefehn\-Bagband",
"499233", "Arzberg\ Oberfranken",
"4933084", "Gutengermendorf",
"492861", "Borken\ Westfalen",
"4938841", "Neuhaus\ Elbe",
"495320", "Torfhaus",
"492962", "Olsberg",
"497381", "Münsingen",
"495371", "Gifhorn",
"499658", "Georgenberg",
"499152", "Hartenstein\ Mittelfranken",
"497703", "Bonndorf\ im\ Schwarzwald",
"4933672", "Pfaffendorfb\ Beeskow",
"4935971", "Sebnitz",
"4938300", "Insel\ Hiddensee",
"4939425", "Dingelstedt\ am\ Huy",
"497666", "Denzlingen",
"496855", "Freisen",
"497940", "Künzelsau",
"4934294", "Rackwitz",
"494193", "Henstedt\-Ulzburg",
"498732", "Frontenhausen",
"496292", "Seckach",
"496676", "Hohenroda\ Hessen",
"499529", "Oberaurach",
"492407", "Herzogenrath\-Kohlscheid",
"494953", "Bunde",
"495943", "Emlichheim",
"495278", "Höxter\-Ovenhausen",
"495196", "Wietzendorf",
"499441", "Kelheim",
"494144", "Himmelpforten",
"494835", "Albersdorf\ Holstein",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"497323", "Gerstetten",
"495154", "Aerzen",
"496403", "Linden\ Hessen",
"496326", "Deidesheim",
"497134", "Weinsberg",
"496531", "Bernkastel\-Kues",
"498384", "Röthenbach\ Allgäu",
"4938427", "Blowatz",
"494268", "Bötersen",
"493865", "Holthusen",
"496083", "Weilrod",
"492335", "Wetter\ Ruhr",
"497673", "Schönau\ im\ Schwarzwald",
"495683", "Wabern\ Hessen",
"495201", "Halle\ Westfalen",
"495105", "Barsinghausen",
"4934927", "Globig\-Bleddin",
"499604", "Wernberg\-Köblitz",
"495462", "Ankum",
"4936371", "Schlossvippach",
"4939856", "Beenz\ bei\ Prenzlau",
"494762", "Kutenholz",
"497334", "Deggingen",
"492456", "Selfkant",
"496126", "Idstein",
"4935829", "Gersdorf\ bei\ Görlitz",
"4939321", "Arneburg",
"4937328", "Grossschirma",
"495305", "Sickte",
"492844", "Rheinberg\-Orsoy",
"4933964", "Fretzdorf",
"494109", "Tangstedt\ Bz\ Hamburg",
"497457", "Rottenburg\-Ergenzingen",
"495222", "Bad\ Salzuflen",
"497747", "Berau",
"494472", "Lastrup",
"498036", "Stephanskirchen\ Simssee",
"495772", "Espelkamp",
"499655", "Tännesberg",
"495437", "Menslage",
"4936621", "Elsterberg\ bei\ Plauen",
"494737", "Stadland\-Schwei",
"4939753", "Strasburg",
"4933848", "Raben",
"496858", "Ottweiler\-Fürth",
"4938736", "Goldberg",
"49761", "Freiburg\ im\ Breisgau",
"495354", "Jerxheim",
"497123", "Metzingen\ Württemberg",
"492592", "Selm",
"495564", "Dassel",
"498238", "Gessertshausen",
"495839", "Wittingen\-Ohrdorf",
"494344", "Schönberg\ Holstein",
"4933054", "Liebenwalde",
"492473", "Simmerath",
"496384", "Konken",
"4939459", "Hasselfelde",
"494204", "Thedinghausen",
"498326", "Fischen\ im\ Allgäu",
"498531", "Pocking",
"499405", "Bad\ Abbach",
"492695", "Insul",
"4934903", "Coswig\ Anhalt",
"498403", "Pförring",
"499085", "Alerheim",
"4935773", "Schleife",
"498083", "Isen",
"499552", "Burghaslach",
"492606", "Winningen\ Mosel",
"497024", "Wendlingen\ am\ Neckar",
"495141", "Celle",
"495245", "Herzebrock\-Clarholz",
"4937343", "Jöhstadt",
"494151", "Schwarzenbek",
"494255", "Martfeld",
"492763", "Drolshagen\-Bleche",
"499454", "Aufhausen\ Oberpfalz",
"499744", "Zeitlofs\-Detter",
"496477", "Greifenstein\-Nenderoth",
"498292", "Dinkelscherben",
"496732", "Wörrstadt",
"492538", "Drensteinfurt\-Rinkerode",
"4939005", "Kusey",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"499846", "Ipsheim",
"4935876", "Weissenberg\ Sachsen",
"4933473", "Zechin",
"499337", "Gaukönigshofen",
"4934446", "Grosskorbetha",
"4937435", "Reuth\ bei\ Plauen",
"494976", "Spiekeroog",
"4935204", "Wilsdruff",
"495508", "Gleichen\-Rittmarshausen",
"494249", "Bassum\-Nordwohlde",
"49241", "Aachen",
"496653", "Burghaun",
"495636", "Lichtenfels\-Goddelsheim",
"494561", "Neustadt\ in\ Holstein",
"494351", "Eckernförde",
"498858", "Kochel\-Walchensee",
"495341", "Salzgitter",
"496036", "Wölfersheim",
"495053", "Fassberg\-Müden",
"495259", "Bad\ Driburg\-Neuenheerse",
"494297", "Ottersberg\-Posthausen",
"4938205", "Tessin\ bei\ Rostock",
"4939483", "Ballenstedt",
"4935322", "Doberlug\-Kirchhain",
"499938", "Moos\ Niederbayern",
"497822", "Ettenheim",
"496238", "Dirmstein",
"492657", "Uersfeld",
"493531", "Finsterwalde",
"495966", "Meppen\-Apeldorn",
"4934342", "Neukieritzsch",
"497581", "Saulgau",
"495571", "Uslar",
"4934361", "Dahlen\ Sachsen",
"496184", "Langenselbold",
"4933437", "Reichenberg\ bei\ Strausberg",
"495520", "Braunlage",
"492851", "Rees",
"492952", "Rüthen",
"4933971", "Kyritz\ Brandenburg",
"496865", "Mettlach\-Orscholz",
"497656", "Schluchsee",
"499162", "Scheinfeld",
"497033", "Weil\ Der\ Stadt",
"499447", "Essing",
"4936029", "Menteroda",
"496774", "Kaub",
"499499", "Painten",
"4939827", "Schwarz\ bei\ Neustrelitz",
"494635", "Sörup",
"493935", "Tangerhütte",
"495975", "Rheine\-Mesum",
"498679", "Burgkirchen\ an\ der\ Alz",
"496562", "Speicher",
"49760", "Oberried\ Breisgau",
"496352", "Kirchheimbolanden",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"4938393", "Binz\ Ostseebad",
"492533", "Münster\-Nienberge",
"496876", "Weiskirchen\ Saar",
"492401", "Baesweiler",
"496464", "Angelburg",
"4939754", "Löcknitz\ Vorpom",
"4939931", "Röbel\ Müritz",
"495883", "Lemgow",
"495207", "Schloss\ Holte\-Stukenbrock",
"494965", "Surwold",
"4938352", "Kemnitz\ bei\ Greifswald",
"498761", "Moosburg\ an\ der\ Isar",
"4936427", "Dornburg\ Saale",
"499924", "Bodenmais",
"497645", "Freiamt",
"499482", "Wörth\ an\ der\ Donau",
"497525", "Aulendorf",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"496224", "Sandhausen\ Baden",
"4939997", "Jarmen",
"499070", "Tapfheim",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"493329", "Stahnsdorf",
"492237", "Kerpen\ Rheinland\-Türnich",
"498665", "Inzell",
"4937320", "Mulda\ Sachsen",
"4933209", "Caputh",
"4934722", "Preusslitz",
"492644", "Linz\ am\ Rhein",
"497741", "Tiengen\ Hochrhein",
"497451", "Horb\ am\ Neckar",
"494230", "Verden\-Walle",
"492524", "Ennigerloh",
"497236", "Keltern",
"4936645", "Mühltroff",
"499190", "Heroldsbach",
"499804", "Aurach",
"493761", "Werdau\ Sachsen",
"4938371", "Karlshagen",
"4934208", "Löbnitz\ bei\ Delitzsch",
"495294", "Hövelhof\-Espeln",
"492262", "Wiehl",
"493679", "Neuhaus\ am\ Rennweg",
"496039", "Karben",
"49781", "Offenburg",
"496233", "Frankenthal\ Pfalz",
"4938456", "Langhagen\ bei\ Güstrow",
"494246", "Twistringen\-Heiligenloh",
"499933", "Wallersdorf",
"4933089", "Himmelpfort",
"497240", "Pfinztal",
"495503", "Nörten\-Hardenberg",
"4936736", "Arnsgereuth",
"495431", "Quakenbrück",
"494731", "Nordenham",
"4934956", "Zörbig",
"492984", "Hallenberg",
"4934299", "Gaschwitz",
"499855", "Dentlein\ am\ Forst",
"4939345", "Parchen",
"493471", "Bernburg\ Saale",
"492422", "Kreuzau",
"496658", "Poppenhausen\ Wasserkuppe",
"496152", "Gross\-Gerau",
"497300", "Roggenburg",
"496329", "Weidenthal\ Pfalz",
"4935203", "Tharandt",
"492445", "Schleiden\ Eifel",
"494263", "Scheessel",
"492755", "Bad\ Berleburg\-Schwarzenau",
"497172", "Lorch\ Württemberg",
"495182", "Gronau\ Leine",
"4930", "Berlin",
"498464", "Dietfurt\ an\ der\ Altmühl",
"4939484", "Harzgerode",
"498224", "Offingen\ Donau",
"4938226", "Dierhagen\ Ostseebad",
"496408", "Buseck",
"496761", "Simmern\ Hunsrück",
"495723", "Bad\ Nenndorf",
"494423", "Fedderwarden",
"4934607", "Wettin",
"498537", "Bad\ Füssing\-Aigen",
"496286", "Walldürn\-Rippberg",
"495273", "Beverungen",
"497807", "Neuried\ Ortenaukreis",
"499646", "Freihung",
"497328", "Königsbronn",
"499331", "Ochsenfurt",
"499526", "Riedbach",
"4938859", "Alt\ Zachun",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"495199", "Schneverdingen\-Heber",
"4936946", "Erbenhausen\ Thüringen",
"49208", "Oberhausen\ Rheinland",
"495147", "Uetze\-Hänigsen",
"495948", "Itterbeck",
"496471", "Weilburg",
"4933631", "Bad\ Saarow\-Pieskow",
"4937755", "Schönheide\ Erzgebirge",
"498562", "Triftern",
"496420", "Lahntal",
"492150", "Meerbusch\-Lank",
"4935932", "Guttau",
"494958", "Jemgum",
"493774", "Schwarzenberg",
"497542", "Tettnang",
"499235", "Thierstein",
"499131", "Erlangen",
"498039", "Rott\ am\ Inn",
"497622", "Schopfheim",
"497128", "Sonnenbühl",
"498233", "Kissing",
"4936257", "Luisenthal\ Thüringen",
"4936205", "Gräfenroda",
"4934904", "Oranienbaum",
"495734", "Bergkirchen\ Westfalen",
"494434", "Colnrade",
"498152", "Herrsching\ am\ Ammersee",
"493562", "Forst\ Lausitz",
"495836", "Wittingen\-Radenbeck",
"496853", "Marpingen",
"4935774", "Boxberg\ Sachsen",
"497705", "Wolterdingen\ Schwarzw",
"495347", "Burgdorf\ bei\ Salzgitter",
"494195", "Hartenholm",
"493876", "Perleberg",
"494357", "Sehestedt\ Eider",
"493464", "Sangerhausen",
"4939741", "Jatznick",
"4936085", "Reinholterode",
"4937344", "Crottendorf\ Sachsen",
"495382", "Bad\ Gandersheim",
"49521", "Bielefeld",
"496665", "Sinntal\-Altengronau",
"495065", "Sibbesse",
"4935365", "Falkenberg\ Elster",
"492586", "Beelen",
"499868", "Schillingsfürst",
"496129", "Schlangenbad",
"493537", "Jessen\ Elster",
"497444", "Alpirsbach",
"495840", "Schnackenburg",
"4933474", "Neutrebbin",
"494106", "Quickborn\ Kreis\ Pinneberg",
"492651", "Mayen",
"497754", "Görwihl",
"4936076", "Niederorschel",
"492857", "Rees\-Mehr",
"497587", "Hosskirch",
"494532", "Bargteheide",
"494849", "Hooge",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"4938733", "Karbow\-Vietlübbe",
"498258", "Sielenbach",
"4934605", "Gröbers",
"492104", "Mettmann",
"495859", "Thomasburg",
"493991", "Waren\ Müritz",
"497462", "Immendingen",
"496393", "Fischbach\ bei\ Dahn",
"498509", "Ruderting",
"498056", "Eggstätt",
"499635", "Bärnau",
"494499", "Barssel",
"495457", "Hopsten\-Schale",
"494757", "Wanna",
"494447", "Vechta\-Langförden",
"498633", "Tüssling",
"497222", "Rastatt",
"496838", "Saarwellingen",
"492440", "Nettersheim\-Tondorf",
"498094", "Steinhöring",
"497305", "Erbach\ Donau",
"4936453", "Mellingen",
"492750", "Diedenshausen",
"49355", "Cottbus",
"496425", "Rauschenberg\ Hessen",
"492251", "Euskirchen",
"4937757", "Rittersgrün",
"493544", "Luckau\ Brandenburg",
"494482", "Hatten",
"4933748", "Treuenbrietzen",
"4939853", "Holzendorf\ bei\ Prenzlau",
"494924", "Moormerland\-Oldersum",
"493624", "Ohrdruf",
"497564", "Bad\ Wurzach",
"4936920", "Grossenlupnitz",
"497354", "Erolzheim",
"49561", "Kassel",
"4939922", "Dambeck\ bei\ Röbel",
"495123", "Schellerten",
"496265", "Billigheim\ Baden",
"496161", "Brensbach",
"492436", "Wegberg\-Rödgen",
"499965", "Sankt\ Englmar",
"497839", "Schapbach",
"498624", "Obing",
"4938454", "Kritzkow",
"498544", "Eging\ am\ See",
"497943", "Schöntal\ Jagst",
"495086", "Celle\-Scheuen",
"492355", "Schalksmühle",
"492565", "Gronau\-Epe",
"494804", "Nordhastedt",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"494706", "Schiffdorf",
"4936207", "Plaue\ Thüringen",
"4936255", "Goldbach\ bei\ Gotha",
"495406", "Belm",
"496361", "Rockenhausen",
"495323", "Clausthal\-Zellerfeld",
"497154", "Kornwestheim",
"4935455", "Walddrehna",
"493963", "Woldegk",
"496551", "Prüm",
"494663", "Süderlügum",
"4936338", "Bleicherode",
"4936734", "Leutenberg",
"498374", "Dietmannsried",
"497728", "Niedereschach",
"492304", "Schwerte",
"495845", "Bergen\ Dumme",
"494855", "Eddelak",
"496660", "Steinau\-Marjoss",
"498752", "Au\ in\ der\ Hallertau",
"496073", "Babenhausen\ Hessen",
"498442", "Wolnzach",
"495673", "Immenhausen\ Hessen",
"497683", "Simonswald",
"495060", "Bodenburg",
"4936087", "Wüstheuterode",
"494795", "Garlstedt",
"495495", "Vörden\ Kreis\ Vechta",
"494933", "Dornum\ Ostfriesland",
"499246", "Pegnitz\-Trockau",
"4933234", "Wustermark",
"4939889", "Boitzenburg",
"4936042", "Tonna",
"497636", "Münstertal\ Schwarzwald",
"497259", "Östringen\-Odenheim",
"497053", "Bad\ Teinach\-Zavelstein",
"499306", "Kist",
"4937209", "Einsiedel\ bei\ Chemnitz",
"4938462", "Baumgarten",
"499423", "Geiselhöring",
"493686", "Eisfeld",
"492637", "Weissenthurm",
"4936875", "Straufhain\-Streufdorf",
"499263", "Ludwigsstadt",
"4936608", "Seelingstädt\ bei\ Gera",
"495921", "Nordhorn",
"495822", "Ebstorf",
"493361", "Fürstenwalde\ Spree",
"498265", "Pfaffenhausen\ Schwaben",
"498161", "Freising",
"4939399", "Kleinau",
"492244", "Königswinter\-Oberpleis",
"4936944", "Rentwertshausen",
"4935891", "Rothenburg\ OL",
"4939825", "Wokuhl",
"494630", "Barderup",
"492831", "Geldern",
"492932", "Neheim\-Hüsten",
"496174", "Königstein\ im\ Taunus",
"497571", "Sigmaringen",
"499395", "Triefenstein",
"4939995", "Nossendorf",
"499157", "Alfeld\ Mittelfranken",
"498393", "Holzgünz",
"496509", "Büdlich",
"497520", "Bodnegg",
"4936425", "Isserstedt",
"4939291", "Calbe\ Saale",
"4936783", "Gehren\ Thüringen",
"4937298", "Oelsnitz\ Erzgebirge",
"497966", "Unterschneidheim",
"4938302", "Sagard",
"496258", "Gernsheim",
"495694", "Diemelstadt",
"492662", "Hachenburg",
"496094", "Weibersbrunn",
"494526", "Ascheberg\ Holstein",
"496633", "Homberg\ Ohm",
"495656", "Waldkappel",
"494331", "Rendsburg",
"496056", "Bad\ Soden\-Salmünster",
"495033", "Wunstorf\-Grossenheidorn",
"4938224", "Gresenhorst",
"494646", "Mohrkirch",
"493946", "Quedlinburg",
"499357", "Gräfendorf\ Bayern",
"498193", "Geltendorf",
"499567", "Sesslach\-Gemünda",
"4937346", "Geyer",
"499195", "Adelsdorf\ Mittelfranken",
"4936647", "Saalburg\ Thüringen",
"496374", "Weilerbach",
"4936074", "Worbis",
"494131", "Lüneburg",
"494235", "Langwedel\-Etelsen",
"4934443", "Teuchern",
"493838", "Bergen\ auf\ Rügen",
"4933476", "Neuhardenberg",
"496442", "Braunfels",
"4935873", "Herrnhut",
"499434", "Bodenwöhr",
"499075", "Glött",
"492368", "Oer\-Erkenschwick",
"496752", "Kirn\ Nahe",
"498073", "Gars\ am\ Inn",
"492558", "Horstmar",
"4939347", "Kade",
"498686", "Petting",
"4934906", "Raguhn",
"493425", "Wurzen",
"499106", "Markt\ Erlbach",
"4939382", "Kamern",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"499532", "Maroldsweisach",
"497245", "Durmersheim",
"497141", "Ludwigsburg\ Württemberg",
"496544", "Rhaunen",
"496624", "Heringen\ Werra",
"4938784", "Kleinow\ Kreis\ Prignitz",
"495902", "Freren",
"495607", "Fuldatal",
"498361", "Nesselwang",
"498551", "Freyung",
"496007", "Rosbach\-Rodheim",
"495741", "Lübbecke",
"4935601", "Peitz",
"494441", "Vechta",
"496506", "Welschbillig",
"4938453", "Mistorf",
"495451", "Ibbenbüren",
"492163", "Schwalmtal\ Niederrhein",
"4939242", "Prödel",
"494751", "Otterndorf",
"499835", "Ehingen\ Mittelfranken",
"499080", "Harburg\ Schwaben",
"496638", "Schwalmtal\-Renzendorf",
"496132", "Ingelheim\ am\ Rhein",
"499144", "Pleinfeld",
"4934953", "Gräfenhainichen",
"496059", "Jossgrund",
"4936733", "Kaulsdorf",
"493949", "Oschersleben\ Bode",
"495236", "Blomberg\-Grossenmarpe",
"496253", "Fürth\ Odenwald",
"499953", "Pilsting",
"494529", "Süsel\-Bujendorf",
"495659", "Ringgau",
"4939409", "Eilsleben",
"49581", "Uelzen",
"4937437", "Bad\ Elster",
"497256", "Philippsburg",
"498022", "Tegernsee",
"499268", "Teuschnitz",
"496595", "Dockweiler",
"4939055", "Hörsingen",
"4939007", "Tangeln",
"493726", "Flöha",
"496167", "Modautal",
"4935842", "Oderwitz",
"4936928", "Neuenhof\ Thüringen",
"492257", "Reckerscheid",
"492974", "Schmallenberg\-Fredeburg",
"492391", "Plettenberg",
"497503", "Wilhelmsdorf\ Württemberg",
"499428", "Kirchroth",
"4933233", "Ketzin",
"497431", "Albstadt\-Ebingen",
"4939978", "Gross\ Roge",
"497975", "Untergröningen",
"496557", "Hallschlag",
"498726", "Schönau\ Niederbayern",
"499574", "Marktzeuln",
"4938207", "Stäbelow",
"496784", "Weierbach",
"494863", "Sankt\ Peter\-Ording",
"4939727", "Spantekow",
"4936330", "Grossberndten",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"499762", "Saal\ an\ der\ Saale",
"493904", "Haldensleben",
"494604", "Grossenwiehe",
"4936454", "Magdala",
"492191", "Remscheid",
"492295", "Ruppichteroth",
"498824", "Oberau\ Loisach",
"499344", "Gerchsheim",
"496332", "Zweibrücken",
"4939854", "Kleptow",
"492363", "Datteln",
"492553", "Ochtrup",
"495873", "Eimke",
"495645", "Borgentreich\-Borgholz",
"492206", "Overath",
"496045", "Gedern",
"499737", "Wartmannsroth",
"495525", "Walkenried",
"499472", "Hohenfels\ Oberpfalz",
"4933435", "Rehfelde",
"498276", "Baar\ Schwaben",
"4934385", "Mutzschen",
"4933966", "Dranse",
"498167", "Zolling",
"492631", "Neuwied",
"497734", "Gailingen",
"494830", "Süderhastedt",
"495542", "Witzenhausen",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"492837", "Weeze",
"496022", "Obernburg\ am\ Main",
"494362", "Heiligenhafen",
"495622", "Fritzlar",
"495128", "Hohenhameln",
"494552", "Leezen",
"4934444", "Lützen",
"499204", "Plankenfels",
"497347", "Dietenheim",
"493886", "Gadebusch",
"4936462", "Ossmannstedt",
"4939602", "Kleeth",
"497836", "Schiltach",
"494405", "Edewecht",
"495705", "Petershagen\-Windheim",
"4935874", "Bernstadt\ an\ der\ Eigen",
"4935241", "Lommatzsch",
"493332", "Schwedt\/Oder",
"498638", "Waldkraiburg",
"4933678", "Storkow\ Mark",
"49721", "Karlsruhe",
"492330", "Herdecke",
"496833", "Rehlingen\-Siersburg",
"4934925", "Bad\ Schmiedeberg",
"494846", "Hattstedt",
"4939862", "Schmölln\ bei\ Prenzlau",
"492862", "Südlohn",
"492961", "Brilon",
"493860", "Raben\ Steinfeld",
"497382", "Römerstein",
"495372", "Meinersen",
"4934221", "Schildau\ Gneisenaustadt",
"498506", "Bad\ Höhenstadt",
"494337", "Jevenstedt",
"499255", "Marktleugast",
"499151", "Hersbruck",
"4938425", "Kirchdorf\ Poel",
"494496", "Friesoythe\-Markhausen",
"497577", "Veringenstadt",
"498253", "Pöttmes",
"4938783", "Dallmin",
"495444", "Wagenfeld",
"494744", "Loxstedt",
"495754", "Extertal\-Bremke",
"494454", "Jade",
"496398", "Vorderweidenthal",
"494137", "Barendorf",
"495172", "Ilsede",
"497182", "Welzheim",
"498860", "Bernbeuren",
"496078", "Gross\-Umstadt",
"495300", "Salzgitter\-Üfingen",
"498332", "Ottobeuren",
"494938", "Hagermarsch",
"496692", "Neustadt\ Hessen",
"496198", "Eppstein",
"497723", "Furtwangen\ im\ Schwarzwald",
"499976", "Rötz",
"496276", "Hesseneck",
"492064", "Dinslaken",
"498045", "Lenggries\-Fall",
"499351", "Gemünden\ am\ Main",
"4936943", "Bettenhausen\ Thüringen",
"499561", "Coburg",
"495328", "Altenau\ Harz",
"4934781", "Greifenhagen",
"494668", "Klanxbüll",
"495807", "Altenmedingen",
"493968", "Schönbeck",
"494162", "Jork",
"4938759", "Tewswoos",
"498784", "Hohenthann",
"496726", "Lorch\ Rheingau",
"4936784", "Stützerbach",
"495601", "Schauenburg",
"498367", "Rosshaupten\ Forggensee",
"4935206", "Kreischa\ bei\ Dresden",
"497273", "Hagenbach\ Pfalz",
"498557", "Mauth",
"495283", "Lügde\-Rischenau",
"497948", "Öhringen\-Ohrnberg",
"492735", "Neunkirchen\ Siegerl",
"492993", "Marsberg\-Canstein",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"496824", "Ottweiler",
"4938223", "Saal\ Vorpom",
"497147", "Sachsenheim\ Württemberg",
"496423", "Wetter\ Hessen",
"492153", "Nettetal\-Lobberich",
"495461", "Bramsche\ Hase",
"4938856", "Pritzier\ bei\ Hagenow",
"494761", "Bremervörde",
"494286", "Gyhum",
"496306", "Trippstadt",
"4933601", "Podelzig",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"4938792", "Lenzen\ \(Elbe\)",
"4938321", "Martensdorf\ bei\ Stralsund",
"494408", "Hude\ Oldenburg",
"497959", "Frankenhardt",
"4937204", "Lichtenstein\ Sachsen",
"492944", "Rietberg\-Mastholte",
"492232", "Brühl\ Rheinland",
"499963", "Konzell",
"494329", "Langwedel\ Holstein",
"4939394", "Hohenberg\-Krusemark",
"4937322", "Brand\-Erbisdorf",
"4936949", "Obermassfeld\-Grimmenthal",
"4934772", "Helbra",
"495221", "Herford",
"496263", "Neckargerach",
"492684", "Puderbach\ Westerwald",
"4934637", "Frankleben",
"494471", "Cloppenburg",
"495771", "Rahden\ Westfalen",
"497266", "Kirchardt",
"4938753", "Wöbbelin",
"492427", "Nideggen",
"496157", "Pfungstadt",
"499174", "Hilpoltstein",
"493731", "Freiberg\ Sachsen",
"496395", "Münchweiler\ an\ der\ Rodalb",
"492591", "Lüdinghausen",
"4936694", "Schkölen\ Thüringen",
"498635", "Pleiskirchen",
"495939", "Sustrum",
"499633", "Mitterteich",
"492267", "Wipperfürth",
"497426", "Gosheim",
"4938229", "Bad\ Sülze",
"494260", "Visselhövede\-Wittorf",
"499094", "Tagmersheim",
"4934691", "Könnern",
"497303", "Illertissen",
"496195", "Kelkheim\ Taunus",
"498731", "Dingolfing",
"496291", "Adelsheim",
"499374", "Eschau",
"496357", "Standenbühl",
"496567", "Oberkail",
"494853", "Sankt\ Michaelisdonn",
"495843", "Wustrow\ Wendland",
"495675", "Trendelburg",
"497685", "Gutach\-Bleibach",
"499442", "Riedenburg",
"496434", "Bad\ Camberg",
"4935056", "Altenberg\ Sachsen",
"498246", "Waal",
"494793", "Hambergen",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"494935", "Juist",
"493635", "Kölleda",
"499624", "Ensdorf\ Oberpfalz",
"497945", "Wüstenrot",
"496532", "Zeltingen\-Rachtig",
"492738", "Netphen",
"499544", "Baunach",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"496106", "Rodgau",
"492041", "Bottrop",
"492353", "Halver",
"4939427", "Ströbeck",
"492563", "Stadtlohn",
"495325", "Goslar\-Hahnenklee",
"4935435", "Gollmitz\ bei\ Calau",
"493965", "Burow\ bei\ Altentreptow",
"494665", "Emmelsbüll\-Horsbüll",
"4938789", "Wolfshagen\ bei\ Perleberg",
"494129", "Haseldorf",
"498230", "Gablingen",
"4934673", "Heldrungen",
"495202", "Oerlinghausen",
"492626", "Selters\ Westferwald",
"4935724", "Lohsa",
"498395", "Tannheim\ Württemberg",
"499393", "Rothenfels\ Unterfranken",
"498157", "Feldafing",
"494876", "Reher\ Holstein",
"492546", "Coesfeld\-Lette",
"494352", "Damp",
"494562", "Grömitz",
"4939205", "Langenweddingen",
"497627", "Steinen\ Kreis\ Lörrach",
"4938483", "Brüel",
"4938725", "Gross\ Godems",
"495035", "Gross\ Munzel",
"497484", "Simmersfeld",
"494774", "Hechthausen",
"4933874", "Stechow\ Brandenburg",
"495474", "Stemwede\-Dielingen",
"496635", "Kirtorf",
"497821", "Lahr\ Schwarzwald",
"497055", "Neuweiler\ Kreis\ Calw",
"494224", "Gross\ Ippener",
"494537", "Sülfeld\ Holstein",
"498306", "Ronsberg",
"497582", "Bad\ Buchau",
"495572", "Bodenfelde",
"492852", "Hamminkeln",
"492951", "Büren",
"498423", "Titting",
"4936026", "Struth\ bei\ Mühlhausen",
"498263", "Breitenbrunn\ Schwaben",
"4936762", "Steinach\ Thüringen",
"499161", "Neustadt\ an\ der\ Aisch",
"499265", "Pressig",
"4934348", "Frohburg",
"495764", "Steyerberg",
"494464", "Wittmund\-Carolinensiel",
"4939085", "Zichtau",
"4936741", "Bad\ Blankenburg",
"499729", "Grettstadt",
"493423", "Eilenburg",
"4933086", "Grieben\ Kreis\ Oberhavel",
"498106", "Vaterstetten",
"4938459", "Laage",
"493306", "Gransee",
"498532", "Griesbach\ im\ Rottal",
"4936484", "Knau\ bei\ Pössneck",
"4934467", "Eckartsberga",
"497243", "Ettlingen",
"4933331", "Casekow",
"492054", "Essen\-Kettwig",
"4933397", "Wandlitz",
"4940", "Hamburg",
"4934296", "Groitzsch\ bei\ Pegau",
"499551", "Burgwindheim",
"4936739", "Rottenbach",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"495187", "Delligsen",
"495142", "Eschede",
"495648", "Brakel\-Gehrden",
"4935930", "Seitschen",
"496048", "Büdingen\-Eckartshausen",
"494152", "Geesthacht",
"495528", "Gieboldehausen",
"499193", "Höchstadt\ an\ der\ Aisch",
"492485", "Schleiden\-Dreiborn",
"4933206", "Fichtenwalde",
"498291", "Zusmarshausen",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"496731", "Alzey",
"493395", "Pritzwalk",
"499946", "Hohenwarth\ bei\ Kötzing",
"494233", "Blender",
"496246", "Eich\ Rheinhessen",
"4933239", "Gross\ Behnitz",
"4939884", "Hassleben\ bei\ Prenzlau",
"498434", "Rennertshofen",
"498075", "Amerang",
"499279", "Mistelgau",
"497802", "Oberkirch\ Baden",
"499073", "Gundelfingen\ an\ der\ Donau",
"4939363", "Angern",
"492379", "Menden\-Asbeck",
"495534", "Eschershausen\ an\ der\ Lenne",
"498268", "Tussenhausen",
"497742", "Klettgau",
"493574", "Lauchhammer",
"496593", "Hillesheim\ Eifel",
"4934202", "Delitzsch",
"497452", "Nagold",
"4939035", "Kuhfelde",
"4935027", "Weesenstein",
"498066", "Bad\ Feilnbach",
"495467", "Voltlage",
"494767", "Bremervörde\-Bevern",
"493762", "Crimmitschau",
"499904", "Lalling",
"4934324", "Ostrau\ Sachsen",
"497505", "Fronreute",
"496204", "Viernheim",
"494384", "Selent",
"492261", "Gummersbach",
"492165", "Jüchen",
"492597", "Senden\ Westfalen",
"49335", "Frankfurt\ \(Oder\)",
"4937365", "Sayda",
"4939456", "Altenbrak",
"49791", "Schwäbisch\ Hall",
"493344", "Bad\ Freienwalde",
"498144", "Grafrath",
"499833", "Heidenheim\ Mittelfranken",
"499398", "Birkenfeld\ bei\ Würzburg",
"495432", "Löningen",
"494732", "Stadland\-Rodenkirchen",
"494477", "Lastrup\-Hemmelte",
"495777", "Diepenau\-Essern",
"499955", "Mamming",
"493737", "Rochlitz",
"497554", "Heiligenberg\ Baden",
"4935695", "Simmersdorf",
"497364", "Oberkochen",
"496151", "Darmstadt",
"496255", "Lindenfels",
"492421", "Düren",
"498344", "Westendorf\ bei\ Kaufbeuren",
"494238", "Neddenaverbergen",
"4938827", "Kalkhorst",
"495875", "Emmendorf",
"4937203", "Gersdorf\ bei\ Chemnitz",
"499078", "Mertingen",
"492365", "Marl",
"492555", "Schöppingen",
"496351", "Eisenberg\ Pfalz",
"496043", "Nidda",
"497164", "Boll\ Kreis\ Göppingen",
"495523", "Bad\ Sachsa",
"496561", "Bitburg",
"496249", "Guntersblum",
"496297", "Ravenstein\ Baden",
"495643", "Borgentreich",
"499276", "Bischofsgrün",
"4936652", "Wurzbach",
"4939393", "Werben\ Elbe",
"492402", "Stolberg\ Rheinland",
"499198", "Heiligenstadt\ in\ Oberfranken",
"4938754", "Leussow\ bei\ Ludwigslust",
"499726", "Euerbach",
"498574", "Wittibreut",
"497973", "Obersontheim",
"494865", "Osterhever",
"4934977", "Quellendorf",
"497046", "Zaberfeld",
"492504", "Telgte",
"4934497", "Langenleuba\-Niederhain",
"494184", "Hanstedt\ Nordheide",
"4933367", "Friedrichswalde\ Brandenburg",
"4936693", "Crossen\ an\ der\ Elster",
"498762", "Wartenberg\ Oberbayern",
"496650", "Hosenfeld",
"4935755", "Ortrand",
"497248", "Marxzell",
"499824", "Dietenhofen",
"492293", "Nümbrecht",
"499481", "Pfatter",
"497541", "Friedrichshafen",
"4939775", "Ahlbeck\ bei\ Torgelow",
"499638", "Neualbenreuth",
"499132", "Herzogenaurach",
"497269", "Sulzfeld\ Baden",
"497063", "Bad\ Wimpfen",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"4933837", "Brielow",
"492724", "Finnentrop\-Serkenrode",
"496835", "Beckingen",
"497621", "Lörrach",
"497308", "Nersingen",
"4936483", "Ziegenrück",
"495936", "Twist",
"493561", "Guben",
"498151", "Starnberg",
"499253", "Weissenstadt",
"494292", "Ritterhude",
"492826", "Kranenburg\ Niederrhein",
"4939404", "Ausleben",
"497429", "Egesheim",
"496400", "Mücke",
"493976", "Torgelow\ bei\ Ueckermünde",
"494289", "Kirchtimke",
"498593", "Untergriesbach",
"499167", "Oberscheinfeld",
"495381", "Seesen",
"4933921", "Zechlinerhütte",
"497371", "Riedlingen\ Württemberg",
"496268", "Hüffenhardt",
"498204", "Mickhausen",
"494950", "Holtland",
"492158", "Grefrath\ bei\ Krefeld",
"496428", "Stadtallendorf",
"492652", "Mendig",
"496066", "Michelstadt\-Vielbrunn",
"494403", "Bad\ Zwischenahn",
"4939364", "Dolle",
"492957", "Wünnenberg\-Haaren",
"495703", "Hille",
"492274", "Elsdorf\ Rheinland",
"494531", "Bad\ Oldesloe",
"494326", "Wankendorf",
"4939883", "Gross\ Dölln",
"4936967", "Geisa",
"4935723", "Bernsdorf\ OL",
"496574", "Hasborn",
"497171", "Schwäbisch\ Gmünd",
"497275", "Kandel",
"495181", "Alfeld\ Leine",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"499367", "Unterpleichfeld",
"496109", "Frankfurt\-Bergen\-Enkheim",
"494126", "Horst\ Holstein",
"492733", "Hilchenbach",
"4938484", "Ventschow",
"4939226", "Hohenziatz",
"492358", "Meinerzhagen\-Valbert",
"498650", "Marktschellenberg",
"496762", "Kastellaun",
"492568", "Heek",
"4936459", "Blankenhain\ Thüringen",
"4935476", "Wittmannsdorf\-Bückchen",
"4933873", "Grosswudicke",
"4935826", "Königshain\ bei\ Görlitz",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"496344", "Schwegenheim",
"4935938", "Grosspostwitz\ OL",
"4939859", "Fürstenwerder",
"499332", "Marktbreit",
"4934743", "Ermsleben",
"497725", "Königsfeld\ im\ Schwarzwald",
"496737", "Köngernheim",
"496472", "Weilmünster",
"495848", "Trebel",
"494858", "Sankt\ Margarethen\ Holstein",
"498043", "Jachenau",
"498561", "Pfarrkirchen\ Niederbayern",
"498249", "Ettringen\ Wertach",
"499644", "Pressath",
"496138", "Mommenheim",
"4938234", "Born\ Darss",
"499524", "Zeil\ am\ Main",
"495032", "Neustadt\ am\ Rübenberge",
"4935477", "Rietzneuendorf\-Friedrichshof",
"492663", "Westerburg\ Westerwald",
"4938755", "Eldena",
"495345", "Baddeckenstedt",
"492804", "Xanten\-Marienbaum",
"495159", "Coppenbrügge\-Bisperode",
"494149", "Fredenbeck",
"494355", "Rieseby",
"4935931", "Königswartha",
"4936966", "Kaltennordheim",
"4935754", "Klettwitz",
"498392", "Markt\ Rettenbach",
"497707", "Bräunlingen",
"4933632", "Hangelsberg",
"496667", "Steinau\-Ulmbach",
"492933", "Sundern\ Sauerland",
"495067", "Bockenem",
"498389", "Weissensberg",
"498466", "Denkendorf\ Oberbayern",
"497139", "Neuenstadt\ am\ Kocher",
"499262", "Wallenfels",
"498028", "Fischbachau",
"496861", "Merzig",
"495823", "Bienenbüttel",
"492855", "Voerde\ Niederrhein",
"497585", "Ostrach",
"499422", "Bogen\ Niederbayern",
"496284", "Mudau",
"4935827", "Nieder\-Seifersdorf",
"4933454", "Wölsickendorf\/Wollenberg",
"493535", "Herzberg\ Elster",
"498226", "Bibertal",
"497052", "Bad\ Liebenzell",
"497854", "Kehl\-Goldscheuer",
"4939742", "Brüssow\ bei\ Pasewalk",
"492584", "Warendorf\-Milte",
"493466", "Artern\ Unstrut",
"492447", "Dahlem\ bei\ Kall",
"4934929", "Straach",
"495903", "Emsbüren",
"499081", "Nördlingen",
"4937364", "Reitzenhain\ Erzgebirge",
"4933928", "Wildberg\ Brandenburg",
"499533", "Untermerzbach",
"492691", "Adenau",
"499401", "Neutraubling",
"498535", "Haarbach",
"4935694", "Gosda\ bei\ Klinge",
"494104", "Aumühle\ bei\ Hamburg",
"4938429", "Glasin",
"497446", "Lossburg",
"4935433", "Vetschau",
"4933836", "Butzow\ bei\ Brandenburg",
"497805", "Appenweier",
"496443", "Ehringshausen\ Dill",
"498072", "Haag\ in\ Oberbayern",
"4939034", "Fleetmark",
"496753", "Meisenheim",
"496338", "Hornbach\ Pfalz",
"492924", "Möhnesee",
"496893", "Saarbrücken\-Ensheim",
"498192", "Schondorf\ am\ Ammersee",
"492482", "Hellenthal",
"4934325", "Mochau\-Lüttewitz",
"493874", "Ludwigslust",
"494155", "Büchen",
"494251", "Hoya",
"4933733", "Stülpe",
"495834", "Wittingen\-Knesebeck",
"494349", "Dänischenhagen",
"495241", "Gütersloh",
"495145", "Beedenbostel",
"494558", "Todesfelde",
"4939932", "Malchow\ bei\ Waren",
"498861", "Schongau",
"496028", "Sulzbach\ am\ Main",
"494209", "Schwanewede",
"492131", "Neuss",
"496466", "Dautphetal\-Friedensdorf",
"492235", "Erftstadt",
"498667", "Seeon\-Seebruck",
"495301", "Lehre\-Essenrode",
"497773", "Bodman\-Ludwigshafen",
"494483", "Ovelgönne\-Grossenmeer",
"499926", "Frauenau",
"4938351", "Mesekenhagen",
"496226", "Meckesheim",
"4939083", "Messdorf",
"499560", "Grub\ am\ Forst",
"4933439", "Fredersdorf\-Vogelsdorf",
"499350", "Eussenheim\-Hundsbach",
"498284", "Ziemetshausen",
"4938826", "Dassow",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"499749", "Oberbach\ Unterfranken",
"495378", "Sassenburg\-Platendorf",
"497388", "Pfronstetten",
"4933366", "Chorin",
"496776", "Dachsenhausen",
"497223", "Bühl\ Baden",
"498138", "Schwabhausen\ bei\ Dachau",
"493338", "Bernau\ Brandenburg",
"4934976", "Gröbzig",
"496392", "Hauenstein\ Pfalz",
"497463", "Mühlheim\ an\ der\ Donau",
"499857", "Schopfloch\ Mittelfranken",
"496874", "Wadern\-Nunkirchen",
"4934496", "Nöbdenitz",
"4938723", "Kladrum",
"4938485", "Dabel",
"49202", "Wuppertal",
"499651", "Vohenstrauss",
"4939203", "Barleben",
"494932", "Norderney",
"493632", "Sondershausen",
"498338", "Böhen",
"495977", "Spelle",
"495254", "Paderborn\-Schloss\ Neuhaus",
"492630", "Mülheim\-Kärlich",
"4939059", "Wegenstedt",
"494244", "Harpstedt",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"498753", "Elsendorf\ Niederbayern",
"499445", "Neustadt\ an\ der\ Donau",
"497682", "Elzach",
"495672", "Bad\ Karlshafen",
"493937", "Osterburg\ Altmark",
"498443", "Hohenwart\ Paar",
"494637", "Sterup",
"4939365", "Bellingen\ bei\ Stendal",
"49771", "Donaueschingen",
"496192", "Hofheim\ am\ Taunus",
"496698", "Schrecksbach",
"492646", "Königsfeld\ Eifel",
"494967", "Rhauderfehn\-Burlage",
"495101", "Pattensen",
"495205", "Bielefeld\-Sennestadt",
"492331", "Hagen\ Westfalen",
"492526", "Sendenhorst",
"4939774", "Mönkebude",
"499704", "Euerdorf",
"493861", "Plate",
"493962", "Penzlin\ bei\ Waren",
"494662", "Leck",
"494168", "Neu\ Wulmstorf\-Elstorf",
"4934721", "Nienburg\ Saale",
"495322", "Bad\ Harzburg",
"4939457", "Benneckenstein\ Harz",
"4939405", "Hötensleben",
"4938320", "Tribsees",
"497527", "Wolfegg",
"497234", "Tiefenbronn",
"496535", "Osann\-Monzel",
"497841", "Achern",
"4938372", "Usedom",
"497942", "Neuenstein\ Württemberg",
"499746", "Zeitlofs",
"494295", "Emtinghausen",
"494191", "Kaltenkirchen\ Holstein",
"492604", "Nassau\ Lahn",
"4937363", "Zöblitz",
"497026", "Lenningen",
"498252", "Schrobenhausen",
"4933396", "Klosterfelde",
"4934297", "Liebertwolkwitz",
"496550", "Irrhausen",
"4935693", "Lauschütz",
"492863", "Velen",
"4934466", "Janisroda",
"493448", "Meuselwitz\ Thüringen",
"495373", "Hillerse\ Kreis\ Gifhorn",
"497383", "Münsingen\-Buttenhausen",
"4933087", "Bredereiche",
"497228", "Forbach",
"496832", "Beckingen\-Reimsbach",
"498133", "Haimhausen\ Oberbayern",
"499844", "Obernzenn",
"4935434", "Altdöbern",
"499231", "Marktredwitz",
"499135", "Hessdorf\ Mittelfranken",
"498324", "Hindelang",
"4939033", "Wallstawe",
"494488", "Westerstede",
"492655", "Weibern",
"494206", "Stuhr\-Heiligenrode",
"496386", "Altenkirchen\ Pfalz",
"496023", "Alzenau\ in\ Unterfranken",
"4933207", "Gross\ Kreutz",
"496229", "Neckarsteinach",
"495543", "Staufenberg\ Niedersachsen",
"496661", "Schlüchtern",
"494553", "Geschendorf",
"495623", "Edertal",
"49511", "Hannover",
"499929", "Ruhmannsfelden",
"494363", "Lensahn",
"4933338", "Stolpe\/Oder",
"496867", "Perl",
"4933734", "Felgentreu",
"4938233", "Prerow\ Ostseebad",
"499407", "Wenzenbach",
"496186", "Grosskrotzenburg",
"492529", "Oelde\-Stromberg",
"492697", "Blankenheim\-Ahrhütte",
"4934341", "Geithain",
"496765", "Gemünden\ Hunsrück",
"4939999", "Tutow",
"4934362", "Mügeln\ bei\ Oschatz",
"495964", "Lähden",
"492992", "Marsberg",
"498124", "Forstern\ Oberbayern",
"495282", "Schieder\-Schwalenberg",
"4933972", "Breddin",
"497272", "Rülzheim",
"492751", "Bad\ Berleburg",
"499087", "Marktoffingen",
"4933920", "Walsleben\ bei\ Neuruppin",
"494163", "Horneburg\ Niederelbe",
"497654", "Löffingen",
"49531", "Braunschweig",
"4935753", "Grossräschen",
"4936695", "Söllmnitz",
"492441", "Kall",
"495634", "Waldeck\-Sachsenhausen",
"496475", "Weilmünster\-Wolfenhausen",
"496034", "Wöllstadt",
"497722", "Triberg\ im\ Schwarzwald",
"495247", "Harsewinkel",
"496693", "Neuental",
"494257", "Schweringen",
"494974", "Neuharlingersiel",
"499335", "Aub\ Kreis\ Würzburg",
"4939829", "Blankenförde",
"498333", "Babenhausen\ Schwaben",
"4939395", "Wanzer",
"4935792", "Ossling",
"4936027", "Lengenfeld\ Unterm\ Stein",
"497183", "Rudersberg\ Württemberg",
"495173", "Uetze",
"49941", "Regensburg",
"498386", "Oberstaufen",
"497502", "Wolpertswende",
"498469", "Freystadt\-Burggriesbach",
"493765", "Reichenbach\ Vogtland",
"497136", "Bad\ Friedrichshall",
"496324", "Hassloch",
"4935057", "Hermsdorf\ Erzgebirge",
"492938", "Ense",
"497455", "Dornhan",
"4939885", "Jakobshagen",
"498867", "Rottenbuch\ Oberbayern",
"497745", "Jestetten",
"498661", "Grabenstätt\ Chiemsee",
"495307", "Braunschweig\-Wenden",
"495828", "Himbergen",
"498023", "Bayrischzell",
"492137", "Neuss\-Norf",
"496252", "Heppenheim\ Bergstrasse",
"499851", "Dinkelsbühl",
"493475", "Lutherstadt\ Eisleben",
"499952", "Eichendorf",
"499657", "Waldthurn",
"493693", "Meiningen",
"494735", "Butjadingen\-Stollhamm",
"495074", "Rodewald",
"495435", "Berge\ bei\ Quakenbrück",
"497084", "Schömberg\ bei\ Neuenbürg",
"4939773", "Altwarp",
"496674", "Friedewald\ Hessen",
"497404", "Epfendorf",
"494146", "Stade\-Bützfleth",
"495156", "Coppenbrügge",
"496133", "Oppenheim",
"4939426", "Hessen",
"4936259", "Tabarz\ Thüringer\ Wald",
"498550", "Philippsreut",
"495194", "Bispingen",
"492162", "Viersen",
"497340", "Neenstetten",
"492405", "Würselen",
"496898", "Völklingen",
"4936622", "Triebes",
"498034", "Brannenburg",
"499473", "Kallmünz",
"492552", "Steinfurt\-Borghorst",
"4939084", "Lindstedt",
"496758", "Waldböckelheim",
"492362", "Dorsten",
"494837", "Neuenkirchen\ Dithmarschen",
"495971", "Rheine",
"495872", "Stoetze",
"496333", "Waldfischbach\-Burgalben",
"495356", "Helmstedt\-Barmke",
"494631", "Glücksburg\ Ostsee",
"4934745", "Winningen\ Sachsen\-Anhalt",
"493931", "Stendal",
"494346", "Gettorf",
"492454", "Gangelt",
"496124", "Bad\ Schwalbach",
"497336", "Lonsee",
"492744", "Herdorf",
"497570", "Sigmaringen\-Gutenstein",
"497641", "Emmendingen",
"4936372", "Kleinneuhausen",
"4934609", "Salzmünde",
"4939322", "Tangermünde",
"498765", "Bruckberg\ Niederbayern",
"499606", "Pfreimd",
"4935725", "Wittichenau",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"493386", "Premnitz",
"492337", "Hagen\-Dahl",
"4933875", "Rhinow",
"4933608", "Jacobsdorf\ Mark",
"494961", "Papenburg",
"493661", "Greiz",
"494862", "Garding",
"493867", "Lübstorf",
"495908", "Wietmarschen\-Lohne",
"4938328", "Miltzow",
"4939204", "Niederndodeleben",
"4934636", "Schafstädt",
"497449", "Baiersbronn\-Obertal",
"494330", "Emkendorf",
"4938724", "Siggelkow",
"492935", "Sundern\-Hachen",
"497458", "Ebhausen",
"4939855", "Parmen\-Weggun",
"499466", "Stamsried",
"497748", "Grafenhausen\ Hochschwarzwald",
"498262", "Mittelneufnach",
"495825", "Wieren",
"497031", "Böblingen",
"495573", "Uslar\-Volpriehausen",
"497583", "Bad\ Schussenried",
"4934384", "Grossbothen",
"498422", "Dollnstein",
"492853", "Schermbeck",
"493533", "Elsterwerda",
"4933434", "Herzfelde\ bei\ Strausberg",
"499776", "Mellrichstadt",
"498237", "Aindling",
"496586", "Beuren\ Hochwald",
"492129", "Haan\ Rheinland",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"4938735", "Plau\ am\ See",
"494563", "Scharbeutz\-Haffkrug",
"496651", "Rasdorf",
"494353", "Ascheffel",
"4935207", "Moritzburg",
"495051", "Bergen\ Kreis\ Celle",
"499480", "Sünching",
"499874", "Neuendettelsau",
"4933652", "Neuzelle",
"495438", "Bakum\-Lüsche",
"499392", "Faulbach\ Unterfranken",
"4935951", "Neukirch\ Lausitz",
"496857", "Namborn",
"4939054", "Flechtingen",
"496755", "Odernheim\ am\ Glan",
"499072", "Lauingen\ Donau",
"497803", "Gengenbach",
"49365", "Gera",
"496445", "Schöffengrund",
"495954", "Lorup",
"495277", "Höxter\-Fürstenau",
"494232", "Langwedel\ Kreis\ Verden",
"4938842", "Lüttenmark",
"493644", "Apolda",
"494944", "Wiesmoor",
"499192", "Gräfenberg",
"492408", "Aachen\-Kornelimünster",
"4933671", "Lieberose",
"495143", "Winsen\ Aller",
"49551", "Göttingen",
"492761", "Olpe\ Biggesee",
"494153", "Lauenburg\ Elbe",
"497664", "Freiburg\-Tiengen",
"496704", "Langenlonsheim",
"494829", "Wewelsfleth",
"495905", "Beesten",
"494267", "Lauenbrück",
"4935248", "Schönfeld\ bei\ Grossenhain",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"498081", "Dorfen\ Stadt",
"4937602", "Kirchberg\ Sachsen",
"4939779", "Eggesin",
"498533", "Rotthalmünster",
"497934", "Weikersheim",
"497242", "Rheinstetten",
"499535", "Pfarrweisach",
"4935453", "Drahnsdorf",
"496150", "Weiterstadt",
"492471", "Roetgen\ Eifel",
"494684", "Langeness\ Hallig",
"496806", "Heusweiler",
"493984", "Prenzlau",
"4936253", "Georgenthal\ Thüringer\ Wald",
"4936785", "Gräfinau\-Angstedt",
"499937", "Oberpöring",
"4936423", "Orlamünde",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"493445", "Naumburg\ Saale",
"496237", "Maxdorf",
"498459", "Manching",
"498586", "Hauzenberg",
"497121", "Reutlingen",
"497225", "Gaggenau",
"495044", "Springe\-Eldagsen",
"4939993", "Hohenmocker",
"496524", "Rodershausen",
"496644", "Grebenhain",
"499632", "Waldsassen",
"4939062", "Bebertal",
"4938206", "Graal\-Müritz\ Seeheilbad",
"498857", "Benediktbeuern",
"494176", "Marschacht",
"4939726", "Ducherow",
"497465", "Emmingen\-Liptingen",
"494298", "Lilienthal",
"498651", "Bad\ Reichenhall",
"495507", "Ebergötzen",
"499861", "Rothenburg\ ob\ der\ Tauber",
"4933967", "Freyenstein",
"499962", "Schwarzach\ Niederbayern",
"496262", "Aglasterhausen",
"4939952", "Grammentin",
"4933981", "Putlitz",
"492233", "Hürth\ Rheinland",
"49340", "Dessau\ Anh",
"4939823", "Rechlin",
"495166", "Walsrode\-Kirchboitzen",
"497775", "Mühlingen",
"4934243", "Bad\ Düben",
"494485", "Elsfleth\-Huntorf",
"4938331", "Rakow\ Vorpom",
"492152", "Kempen",
"496422", "Kirchhain",
"499284", "Schwarzenbach\ an\ der\ Saale",
"4936873", "Themar",
"497620", "Schopfheim\-Gersbach",
"496081", "Usingen",
"4936921", "Wutha\-Farnroda",
"495681", "Homberg\ Efze",
"497671", "Todtnau",
"495203", "Werther\ Westfalen",
"492774", "Dietzhölztal",
"4937369", "Wolkenstein",
"4939971", "Gnoien",
"498704", "Altdorf\-Pfettrach",
"4934924", "Zahna",
"498806", "Utting\ am\ Ammersee",
"495594", "Bovenden\-Reyershausen",
"492562", "Gronau\ Westfalen",
"492352", "Altena\ Westfalen",
"494546", "Mustin\ Lauenburg",
"496401", "Grünberg\ Hessen",
"4938424", "Bobitz",
"495366", "Jembke",
"496533", "Morbach\ Hunsrück",
"494626", "Treia",
"495556", "Lindau\ Harz",
"4939039", "Bonese",
"499338", "Röttingen\ Unterfranken",
"4938874", "Lützow",
"492464", "Aldenhoven\ bei\ Jülich",
"495492", "Steinfeld\ Oldenburg",
"497321", "Heidenheim\ an\ der\ Brenz",
"494792", "Worpswede",
"493586", "Neugersdorf\ Sachsen",
"498445", "Gerolsbach",
"499443", "Abensberg",
"494951", "Weener",
"4939006", "Miesterhorst",
"494852", "Brunsbüttel",
"496478", "Greifenstein\-Ulm",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"495842", "Schnega",
"495941", "Neuenhaus\ Dinkel",
"4935608", "Gross\ Ossnig",
"4934445", "Stössen",
"4937436", "Weischlitz",
"492224", "Bad\ Honnef",
"4939268", "Egeln",
"499324", "Dettelbach",
"4933477", "Trebnitz\ bei\ Müncheberg",
"495702", "Petershagen\-Lahde",
"494402", "Rastede",
"4939053", "Süplingen",
"49641", "Giessen",
"492653", "Kaisersesch",
"495625", "Naumburg\ Hessen",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"4937382", "Geringswalde",
"494365", "Heringsdorf\ Holstein",
"4936646", "Tanna\ bei\ Schleiz",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"4933235", "Friesack",
"495545", "Hedemünden",
"498592", "Wegscheid\ Niederbayern",
"492238", "Pulheim",
"4933931", "Rheinsberg\ Mark",
"494293", "Ottersberg\-Fischerhude",
"499674", "Schönsee",
"498456", "Lenting",
"496657", "Hofbieber",
"4938455", "Plaaz",
"496851", "St\ Wendel",
"499252", "Helmbrechts",
"494504", "Ratekau",
"495375", "Müden\ Aller",
"497385", "Gomadingen",
"4936735", "Probstzella",
"494179", "Winsen\-Tönnhausen",
"492865", "Raesfeld",
"4936254", "Friedrichswerth",
"497062", "Beilstein\ Württemberg",
"4939346", "Tucheim",
"499133", "Baiersdorf\ Mittelfranken",
"4934907", "Jeber\-Bergfrieden",
"4934955", "Gossa",
"498231", "Königsbrunn\ bei\ Augsburg",
"498135", "Sulzemoos",
"4935454", "Uckro",
"493335", "Finowfurt",
"492384", "Welver",
"496473", "Leun",
"493494", "Wolfen",
"498042", "Lenggries",
"4938292", "Kröpelin",
"496695", "Jesberg",
"498335", "Fellheim",
"493844", "Schwaan",
"4939089", "Bismark\ Altmark",
"4934383", "Trebsen\ Mulde",
"499333", "Sommerhausen",
"4936842", "Oberhof\ Thüringen",
"4939298", "Barby\ Elbe",
"4937291", "Augustusburg",
"4933433", "Buckow\ Märkische\ Schweiz",
"499448", "Hausen\ Niederbayern",
"495175", "Lehrte\-Arpke",
"495271", "Höxter",
"49385", "Schwerin",
"494421", "Wilhelmshaven",
"4939487", "Friedrichsbrunn",
"496763", "Kirchberg\ Hunsrück",
"495721", "Stadthagen",
"498407", "Grossmehring",
"4935240", "Tauscha\ bei\ Grossenhain",
"494884", "Schwabstedt",
"4936601", "Hermsdorf\ Thüringen",
"4937468", "Treuen\ Vogtland",
"492732", "Kreuztal",
"4934604", "Niemberg",
"495208", "Leopoldshöhe",
"493592", "Kirschau",
"492590", "Dülmen\-Buldern",
"498809", "Wessobrunn",
"497476", "Bisingen",
"4938729", "Marnitz",
"494165", "Hollenstedt\ Nordheide",
"494261", "Rotenburg\ Wümme",
"4939209", "Wanzleben",
"499779", "Nordheim\ von\ der\ Rhön",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"498851", "Kochel\ am\ See",
"494358", "Loose\ bei\ Eckernförde",
"498657", "Ramsau\ bei\ Berchtesgaden",
"4934923", "Cobbelsdorf",
"496746", "Pfalzfeld",
"4935388", "Klöden",
"4936206", "Grossfahner",
"493695", "Bad\ Salzungen",
"494733", "Butjadingen\-Burhave",
"496589", "Kell\ am\ See",
"496456", "Haina\ Kloster",
"495433", "Badbergen",
"496231", "Hochdorf\-Assenheim",
"496135", "Bodenheim\ Rhein",
"499832", "Wassertrüdingen",
"499931", "Plattling",
"496844", "Blieskastel\-Altheim",
"4938785", "Berge\ bei\ Perleberg",
"4938423", "Bad\ Kleinen",
"497127", "Neckartenzlingen",
"499360", "Thüngen",
"4935439", "Zinnitz",
"49841", "Ingolstadt\ Donau",
"499386", "Prosselsheim",
"492858", "Hünxe",
"499469", "Roding\-Neubäu",
"493763", "Glauchau",
"4938873", "Carlow",
"493606", "Heiligenstadt\ Heilbad",
"4936331", "Ilfeld",
"497743", "Ühlingen\-Birkendorf",
"497453", "Altensteig\ Württemberg",
"499867", "Geslau",
"496592", "Daun",
"499661", "Sulzbach\-Rosenberg",
"498025", "Miesbach",
"4936075", "Dingelstädt\ Eichsfeld",
"499229", "Mainleus",
"492676", "Ulmen",
"494826", "Hohenlockstedt",
"492292", "Windeck\ Sieg",
"495264", "Kalletal",
"4936424", "Kahla\ Thüringen",
"498538", "Pocking\-Hartkirchen",
"499765", "Trappstadt",
"499186", "Lauterhofen\ Oberpfalz",
"496407", "Rabenau\ Hessen",
"49341", "Leipzig",
"4939994", "Metschow",
"496087", "Waldems",
"4933762", "Zeuthen",
"4938225", "Trinwillershagen",
"494724", "Cuxhaven\-Lüdingworth",
"496809", "Grossrosseln",
"4933741", "Niedergörsdorf",
"495424", "Bad\ Rothenfelde",
"497972", "Gschwend\ bei\ Gaildorf",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"495947", "Laar\ Vechte",
"494957", "Detern",
"494274", "Varrel\ bei\ Sulingen",
"492403", "Eschweiler\ Rheinland",
"495522", "Osterode\ am\ Harz",
"494158", "Roseburg",
"496042", "Büdingen\ Hessen",
"495148", "Steinhorst\ Niedersachsen",
"495642", "Warburg\-Scherfede",
"4936945", "Henneberg",
"497808", "Hohberg\ bei\ Offenburg",
"497327", "Dischingen",
"4934244", "Mockrehna",
"4939824", "Hohenzieritz",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"496335", "Trulben",
"4935600", "Döbern\ NL",
"4937756", "Breitenbrunn\ Erzgebirge",
"498363", "Pfronten",
"4938787", "Glöwen",
"498553", "Spiegelau",
"4933922", "Karwesee",
"497954", "Kirchberg\ an\ der\ Jagst",
"497277", "Wörth\-Büchelberg",
"499365", "Rimpar",
"499555", "Schlüsselfeld\-Aschbach",
"496130", "Schwabenheim\ an\ der\ Selz",
"499082", "Oettingen\ in\ Bayern",
"4933970", "Neustadt\ Dosse",
"495803", "Rosche",
"4936256", "Wechmar",
"497143", "Besigheim",
"4939344", "Güsen",
"499402", "Regenstauf",
"492692", "Kelberg",
"495664", "Morschen",
"494324", "Brokstedt",
"49751", "Ravensburg",
"4939748", "Viereck",
"4935456", "Terpt",
"498206", "Egling\ an\ der\ Paar",
"499179", "Freystadt",
"4936077", "Grossbodungen",
"498020", "Weyarn",
"497905", "Langenburg",
"498071", "Wasserburg\ am\ Inn",
"499504", "Stadelhofen",
"496146", "Hochheim\ am\ Main",
"494133", "Wittorf\ Kreis\ Lüneburg",
"492689", "Dierdorf",
"493391", "Neuruppin",
"498295", "Altenmünster\ Schwaben",
"496735", "Eppelsheim",
"498191", "Landsberg\ am\ Lech",
"492824", "Kalkar",
"494674", "Ockholm",
"499293", "Berg\ Oberfranken",
"499099", "Kaisheim",
"495934", "Haren\-Rütenbrock",
"494252", "Bruchhausen\-Vilsen",
"4936644", "Hirschberg\ Saale",
"495242", "Rheda\-Wiedenbrück",
"497727", "Vöhrenbach",
"496631", "Alsfeld",
"497825", "Kippenheim",
"494333", "Erfde",
"4934606", "Teicha\ Sachsen\-Anhalt",
"495031", "Wunstorf",
"496346", "Annweiler\ am\ Trifels",
"494758", "Nordleda",
"495458", "Hopsten",
"4938227", "Lüdershagen\ bei\ Barth",
"4933638", "Rüdersdorf\ bei\ Berlin",
"496837", "Wallerfangen",
"492904", "Bestwig",
"4934639", "Wallendorf\ Luppe",
"498257", "Inchenhofen",
"497573", "Stetten\ am\ kalten\ Markt",
"495583", "Braunlage\-Hohegeiss",
"496439", "Holzappel",
"492833", "Kerken",
"499261", "Kronach",
"499165", "Sugenheim",
"4936947", "Jüchsen",
"499549", "Lisberg",
"495923", "Schüttorf",
"492955", "Büren\-Wewelsburg",
"499421", "Straubing",
"494124", "Glückstadt",
"497343", "Buch\ bei\ Illertissen",
"497051", "Calw",
"4933704", "Baruth\ Mark",
"493631", "Nordhausen\ Thüringen",
"494931", "Norden",
"494832", "Meldorf",
"492367", "Henrichenburg",
"498146", "Moorenweis",
"492557", "Wettringen\ Kreis\ Steinfurt",
"4935364", "Lebusa",
"493346", "Seelow",
"4936084", "Heuthen",
"496071", "Dieburg",
"494550", "Bühnsdorf",
"4933237", "Paulinenaue",
"497203", "Walzbachtal",
"497681", "Waldkirch\ Breisgau",
"496020", "Heigenbrücken",
"495671", "Hofgeismar",
"499358", "Gössenheim",
"499568", "Neustadt\ bei\ Coburg",
"497556", "Uhldingen\-Mühlhofen",
"494779", "Freiburg\ Elbe",
"4937433", "Gutenfürst",
"497366", "Abtsgmünd",
"499733", "Münnerstadt",
"4933475", "Letschin",
"4939003", "Jübar",
"498735", "Gangkofen\-Kollbach",
"496295", "Rosenberg\ Baden",
"4934905", "Wörlitz",
"495102", "Laatzen",
"495608", "Söhrewald",
"493576", "Weisswasser",
"4936204", "Stotternheim",
"496008", "Echzell",
"492332", "Gevelsberg",
"495321", "Goslar",
"496363", "Niederkirchen",
"494661", "Niebüll",
"496553", "Schönecken",
"495536", "Holzminden\-Neuhaus",
"493961", "Altentreptow",
"4936737", "Drognitz",
"4938378", "Heringsdorf\ Seebad",
"499906", "Mariaposching",
"492045", "Bottrop\-Kirchhellen",
"4938457", "Krakow\ am\ See",
"4939320", "Schinne",
"494469", "Wangerooge",
"495769", "Steyerberg\-Voigtei",
"496206", "Lampertheim",
"498064", "Au\ bei\ Bad\ Aibling",
"4936370", "Grossenehrich",
"497842", "Kappelrodeck",
"4935775", "Pechern",
"497941", "Öhringen",
"498862", "Steingaden\ Oberbayern",
"495225", "Spenge",
"496163", "Höchst\ im\ Odenwald",
"495121", "Hildesheim",
"497044", "Mönsheim",
"492506", "Münster\-Wolbeck",
"492638", "Waldbreitbach",
"492132", "Meerbusch\-Büderich",
"498330", "Legau",
"499724", "Stadtlauringen",
"495302", "Vechelde",
"499826", "Weidenbach\ Mittelfranken",
"4937754", "Zwönitz",
"494186", "Buchholz\-Trelde",
"494765", "Ebersdorf\ bei\ Bremervörde",
"495465", "Neuenkirchen\ bei\ Bramsche",
"492253", "Bad\ Münstereifel",
"4939826", "Blankensee\ bei\ Neustrelitz",
"4939996", "Törpin",
"498346", "Pforzen",
"498631", "Mühldorf\ am\ Inn",
"492595", "Olfen",
"4936426", "Ottendorf\ bei\ Stadtroda",
"499274", "Hollfeld",
"496391", "Dahn",
"493735", "Marienberg\ Sachsen",
"496257", "Seeheim\-Jugenheim",
"4934654", "Stolberg\ Harz",
"497166", "Adelberg",
"4939485", "Gernrode\ Harz",
"4939723", "Krien",
"4936651", "Lobenstein",
"499652", "Waidhaus",
"499158", "Offenhausen\ Mittelfranken",
"4938203", "Bad\ Doberan",
"495775", "Diepenau",
"494475", "Molbergen",
"498304", "Wildpoldsried",
"4933369", "Oderberg",
"4933978", "Segeletz",
"492374", "Iserlohn\-Letmathe",
"496483", "Selters\ Taunus",
"495864", "Jameln",
"492991", "Marsberg\-Bredelar",
"496003", "Rosbach\ von\ der\ Höhe",
"494466", "Wittmund\-Ardorf",
"495766", "Rehburg\-Loccum",
"4936761", "Heubisch",
"4933055", "Kremmen",
"497220", "Forbach\-Hundsbach",
"496209", "Mörlenbach",
"495603", "Gudensberg",
"495281", "Bad\ Pyrmont",
"495185", "Duingen",
"497271", "Wörth\ am\ Rhein",
"497175", "Leinzell",
"492752", "Bad\ Laasphe",
"496558", "Büdesheim\ Eifel",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"4936742", "Uhlstädt",
"4939740", "Nechlin",
"498565", "Dietersburg\-Baumgarten",
"499353", "Karlstadt",
"499563", "Rödental",
"492624", "Höhr\-Grenzhausen",
"494392", "Nortorf\ bei\ Neumünster",
"497721", "Villingen\ im\ Schwarzwald",
"499738", "Rottershausen",
"494874", "Todenbüttel",
"494480", "Ovelgönne\-Strückhausen",
"495476", "Ostercappeln\-Venne",
"494776", "Osten\-Altendorf",
"497486", "Horb\-Altheim",
"4933436", "Prötzel",
"4933965", "Herzsprung\ bei\ Wittstock",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"493998", "Demmin",
"494192", "Bad\ Bramstedt",
"497702", "Blumberg\ Baden",
"499153", "Schnaittach",
"498349", "Stötten\ am\ Auerberg",
"498251", "Aichach",
"492963", "Brilon\-Messinghausen",
"495037", "Bad\ Rehburg",
"496637", "Feldatal",
"4939343", "Jerichow",
"499944", "Miltach",
"497625", "Zell\ im\ Wiesental",
"496831", "Saarlouis",
"499232", "Wunsiedel",
"497545", "Immenstaad\ am\ Bodensee",
"496244", "Westhofen\ Rheinhessenen",
"494535", "Nahe",
"499427", "Leiblfing",
"492509", "Nottuln\-Appelhülsen",
"492174", "Burscheid\ Rheinland",
"4939056", "Klüden",
"4933332", "Gartz\ Oder",
"493304", "Velten",
"498104", "Sauerlach",
"4935877", "Cunewalde",
"495062", "Holle\ bei\ Hildesheim",
"499829", "Flachslanden",
"492056", "Heiligenhaus",
"497375", "Obermarchtal",
"4936643", "Thimmendorf",
"492633", "Brohl\-Lützing",
"494189", "Undeloh",
"499267", "Nordhalben",
"499176", "Allersberg",
"492686", "Weyerbusch",
"497264", "Bad\ Rappenau",
"496355", "Albisheim\ Pfrimm",
"496565", "Dudeldorf",
"4933841", "Belzig",
"492361", "Recklinghausen",
"495820", "Suhlendorf",
"497424", "Spaichingen",
"492551", "Steinfurt\-Burgsteinfurt",
"4936628", "Zeulenroda",
"493831", "Stralsund",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"494632", "Steinbergkirche",
"4939857", "Drense",
"495677", "Calden\-Westuffeln",
"4934692", "Alsleben\ Saale",
"492193", "Dabringhausen",
"4933602", "Alt\ Zeschdorf",
"497522", "Wangen\ im\ Allgäu",
"497642", "Endingen\ Kaiserstuhl",
"497148", "Grossbottwar",
"4938370", "Kröslin",
"497947", "Forchtenberg",
"4938322", "Richtenberg",
"4938791", "Bad\ Wilsnack",
"496304", "Wolfstein\ Pfalz",
"494284", "Selsingen",
"4935205", "Ottendorf\-Okrilla",
"4934653", "Rottleberode",
"494962", "Papenburg\-Aschendorf",
"4938737", "Ganzlin",
"498368", "Halblech",
"494861", "Tönning",
"4936378", "Ostramondra",
"4936969", "Merkers",
"498558", "Hohenau\ Niederbayern",
"495327", "Bad\ Grund\ Harz",
"4938204", "Broderstorf",
"4934771", "Querfurt",
"4937321", "Frankenstein\ Sachsen",
"4939328", "Rochau",
"494667", "Dagebüll",
"495808", "Gerdau",
"493967", "Oertzenhof\ bei\ Strasburg",
"4939724", "Klein\ Bünzow",
"4935363", "Fermerswalde",
"496104", "Heusenstamm",
"497433", "Balingen",
"4933703", "Sperenberg",
"499626", "Hohenburg",
"4938876", "Roggendorf",
"497348", "Beimerstetten",
"4936083", "Uder",
"492393", "Sundern\-Allendorf",
"499546", "Burgebrach",
"4937434", "Bobenneukirchen",
"492838", "Sonsbeck",
"495127", "Harsum",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"498168", "Attenkirchen",
"4939004", "Köckte\ bei\ Gardelegen",
"496440", "Kölschhausen",
"496349", "Billigheim\-Ingenheim",
"492425", "Nideggen\-Embken",
"496251", "Bensheim",
"496155", "Griesheim\ Hessen",
"499852", "Feuchtwangen",
"4936203", "Vieselbach",
"499951", "Landau\ an\ der\ Isar",
"4934926", "Pretzsch\ Elbe",
"496397", "Leimen\ Pfalz",
"499376", "Collenberg",
"494893", "Hohenaspe",
"497578", "Wald\ Hohenz",
"4933839", "Wusterwitz",
"4938426", "Neuburg\-Steinhausen",
"494338", "Alt\ Duvenstedt",
"494443", "Dinklage",
"498637", "Lohkirchen",
"495743", "Espelkamp\-Gestringen",
"49201", "Essen",
"494753", "Balje",
"496436", "Dornburg\ Hessen",
"492265", "Reichshof\-Eckenhagen",
"495453", "Recke",
"492161", "Mönchengladbach",
"4939861", "Gramzow\ bei\ Prenzlau",
"493379", "Mahlow",
"498179", "Eurasburg\ an\ der\ Loisach",
"499071", "Dillingen\ an\ der\ Donau",
"498504", "Tittling",
"497903", "Mainhardt",
"4939887", "Gerswalde",
"494231", "Verden\ Aller",
"494135", "Kirchgellersen",
"495854", "Bleckede\-Barskamp",
"4934222", "Arzberg\ bei\ Torgau",
"492574", "Saerbeck",
"495339", "Gielde",
"494844", "Pellworm",
"4936840", "Trusetal",
"499295", "Töpen",
"499191", "Forchheim\ Oberfranken",
"494746", "Hagen\ bei\ Bremerhaven",
"495446", "Rehden",
"494456", "Varel\-Altjührden",
"496733", "Gau\-Odernheim",
"498293", "Welden\ bei\ Augsburg",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"496358", "Kriegsfeld",
"492762", "Wenden\ Südsauerland",
"496568", "Wolsfeld",
"4938848", "Vellahn",
"494494", "Bösel\ Oldenburg",
"499363", "Arnstein\ Unterfranken",
"494929", "Ihlow\ Kreis\ Aurich",
"493629", "Stadtilm",
"499553", "Ebrach\ Oberfranken",
"4933394", "Blumberg\ Kreis\ Barnim",
"498365", "Wertach",
"498555", "Perlesreut",
"4936209", "Klettbach",
"495805", "Oetzen",
"497736", "Tengen",
"498082", "Schwindegg",
"497834", "Wolfach",
"4936461", "Bad\ Sulza",
"4933833", "Wollin\ bei\ Brandenburg",
"4935436", "Laasow\ bei\ Calau",
"497145", "Markgröningen",
"498402", "Münchsmünster",
"497569", "Isny\-Eisenbach",
"4935242", "Nossen",
"493421", "Torgau",
"499206", "Mistelgau\-Obernsees",
"4934464", "Freyburg\ Unstrut",
"492737", "Netphen\-Deuz",
"492472", "Monschau",
"4939601", "Friedland",
"4937608", "Waldenburg\ Sachsen",
"4938855", "Lübtheen",
"496724", "Stromberg\ Hunsrück",
"492835", "Issum",
"4934782", "Mansfeld\ Südharz",
"495925", "Wietmarschen",
"498261", "Mindelheim",
"498165", "Neufahrn\ bei\ Freising",
"498549", "Vilshofen\-Pleinting",
"498629", "Palling",
"497032", "Herrenberg",
"499163", "Dachsbach",
"492953", "Wünnenberg",
"495707", "Petershagen\ Weser",
"494407", "Wardenburg",
"498421", "Eichstätt\ Bayern",
"497159", "Renningen",
"497345", "Langenau\ Württemberg",
"496826", "Bexbach",
"495139", "Burgwedel",
"497823", "Seelbach\ Schutter",
"492309", "Waltrop",
"494335", "Hohn\ bei\ Rendsburg",
"493504", "Dippoldiswalde",
"4933877", "Nitzahn",
"498379", "Waltenhofen\-Oberdorf",
"492268", "Kürten",
"492428", "Niederzier",
"496652", "Hünfeld",
"496158", "Riedstadt",
"4935727", "Burghammer",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"4936963", "Dorndorf\ Rhön",
"495052", "Hermannsburg",
"499974", "Traitsching",
"499257", "Zell\ Oberfranken",
"492066", "Duisburg\-Homberg",
"496274", "Waldbrunn\ Odenwald",
"497575", "Messkirch",
"499391", "Marktheidenfeld",
"495585", "Herzberg\-Sieber",
"493724", "Burgstädt",
"496082", "Niederreifenberg",
"4933085", "Seilershof",
"495682", "Borken\ Hessen",
"497672", "St\ Blasien",
"497977", "Oberrot\ bei\ Gaildorf",
"497254", "Waghäusel",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"496555", "Bleialf",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"492297", "Wildbergerhütte",
"492043", "Gladbeck",
"492351", "Lüdenscheid",
"4934295", "Krensitz",
"4939349", "Parey\ Elbe",
"49571", "Minden\ Westfalen",
"4935841", "Grossschönau\ Sachsen",
"492561", "Ahaus",
"49441", "Oldenburg",
"496402", "Hungen",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"4939241", "Leitzkau",
"495491", "Damme\ Dümmer",
"497322", "Giengen\ an\ der\ Brenz",
"494791", "Osterholz\-Scharmbeck",
"499146", "Markt\ Berolzheim",
"4935602", "Drebkau",
"4935023", "Bad\ Gottleuba",
"4933205", "Michendorf",
"496504", "Thalfang",
"4939262", "Güsten\ Anh",
"494952", "Rhauderfehn",
"494851", "Marne",
"495234", "Horn\-Bad\ Meinberg",
"495841", "Lüchow\ Wendland",
"495942", "Uelsen",
"495647", "Lichtenau\-Kleinenberg",
"4936649", "Gefell\ bei\ Schleiz",
"498733", "Mengkofen",
"496293", "Schefflenz",
"499735", "Massbach",
"496047", "Altenstadt\ Hessen",
"495527", "Duderstadt",
"499837", "Haundorf",
"4933363", "Altenhof\ Kreis\ Barnim",
"492593", "Ascheberg\ Westfalen",
"499346", "Grünsfeld",
"497122", "St\ Johann\ Württemberg",
"497628", "Efringen\-Kirchen",
"499631", "Tirschenreuth",
"498274", "Buttenwiesen",
"4939206", "Eichenbarleben",
"499439", "Neunburg\-Kemnath",
"493733", "Annaberg\-Buchholz",
"4938726", "Spornitz",
"4934493", "Gössnitz\ Thüringen",
"495773", "Stemwede\-Wehdem",
"492204", "Bensberg",
"494473", "Emstek",
"498652", "Berchtesgaden",
"498158", "Tutzing",
"4934973", "Osternienburg",
"496629", "Schenklengsfeld",
"496597", "Jünkerath",
"496786", "Kempfeld",
"499961", "Mitterfels",
"496261", "Mosbach\ Baden",
"496165", "Breuberg",
"495223", "Bünde",
"499576", "Lichtenfels\-Isling",
"4936025", "Körner",
"498724", "Massing",
"4939397", "Geestgottberg",
"4938823", "Selmsdorf",
"4939086", "Jävenitz",
"494763", "Gnarrenburg",
"496421", "Marburg",
"492255", "Euskirchen\-Flamersheim",
"492151", "Krefeld",
"494606", "Wanderup",
"4937207", "Hainichen\ Sachsen",
"499355", "Frammersbach",
"499149", "Weissenburg\-Suffersheim",
"499565", "Untersiemau",
"499197", "Egloffstein",
"4936848", "Wernshausen",
"498041", "Bad\ Tölz",
"497964", "Stödtlen",
"498563", "Bad\ Birnbach\ Rottal",
"4938301", "Putbus",
"4939292", "Biederitz",
"496298", "Möckmühl",
"49731", "Ulm\ Donau",
"495654", "Herleshausen",
"494524", "Scharbeutz\-Pönitz",
"4933456", "Wriezen",
"499077", "Bachhagel",
"496054", "Birstein",
"494644", "Karby",
"493944", "Blankenburg\ Harz",
"495696", "Bad\ Arolsen\-Landau",
"49395", "Neubrandenburg",
"49465", "Sylt",
"494237", "Bendingbostel",
"496096", "Wiesen\ Unterfranken",
"495272", "Brakel\ Westfalen",
"497247", "Linkenheim\-Hochstetten",
"494422", "Sande\ Kreis\ Friesl",
"495722", "Bückeburg",
"497634", "Sulzburg",
"4938461", "Bützow",
"496485", "Nentershausen\ Westerwald",
"495605", "Kaufungen\ Hessen",
"495183", "Lamspringe",
"492246", "Lohmar\ Rheinland",
"497173", "Heubach",
"4936964", "Dermbach\ Rhön",
"4935756", "Hosena",
"493591", "Bautzen",
"4937600", "Neumark\ Sachsen",
"4937462", "Rothenkirchen\ Vogtland",
"4935892", "Horka\ OL",
"4938209", "Sanitz\ bei\ Rostock",
"494262", "Visselhövede",
"494401", "Brake\ Unterweser",
"495026", "Steimbke",
"498427", "Wellheim",
"496626", "Wildeck\-Obersuhl",
"494533", "Reinfeld\ Holstein",
"496789", "Heimbach\ Nahe",
"498684", "Fridolfing",
"4939036", "Binde",
"494768", "Hipstedt",
"495468", "Bramsche\-Engter",
"499104", "Emskirchen",
"495228", "Vlotho\-Exter",
"4937439", "Jocketa",
"498591", "Obernzell",
"492635", "Rheinbrohl",
"494609", "Eggebek",
"493909", "Klötze\ Altmark",
"497373", "Zwiefalten",
"495383", "Lutter\ am\ Barenberge",
"498267", "Dirlewang",
"4939009", "Badel",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"4937366", "Rübenau",
"496852", "Nohfelden",
"493563", "Spremberg",
"498153", "Wessling",
"499397", "Wertheim\-Dertingen",
"4939455", "Schierke",
"4939407", "Seehausen\ Börde",
"499349", "Werbach\-Wenkheim",
"499251", "Münchberg",
"499155", "Simmelsdorf",
"494478", "Cappeln\ Oldenburg",
"499436", "Nittenau",
"4933834", "Pritzerbe",
"497543", "Kressbronn\ am\ Bodensee",
"4934463", "Bad\ Kösen",
"498232", "Schwabmünchen",
"492598", "Senden\-Ottmarsbocholt",
"497623", "Rheinfelden\ Baden",
"49711", "Stuttgart",
"4935696", "Briesnig",
"492357", "Herscheid\ Westfalen",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"493546", "Lübben\ Spreewald",
"492567", "Ahaus\-Alstätte",
"492291", "Waldbröl",
"492195", "Radevormwald",
"494926", "Krummhörn\-Greetsiel",
"4933768", "Prieros",
"497739", "Hilzingen",
"4938757", "Neustadt\-Glewe",
"497566", "Argenbühl",
"492434", "Wegberg",
"497356", "Schemmerhofen",
"4939225", "Altengrabow",
"4934633", "Braunsbedra",
"497394", "Schelklingen",
"495882", "Gorleben",
"497971", "Gaildorf",
"4935475", "Straupitz",
"4939921", "Ankershagen",
"4934494", "Ehrenhain",
"499209", "Emtmannsberg",
"492532", "Ostbevern",
"4935825", "Kodersdorf",
"498176", "Egling\ bei\ Wolfratshausen",
"494857", "Barlt",
"492850", "Rees\-Haldern",
"496041", "Glauburg",
"496353", "Freinsheim",
"495336", "Semmenstedt",
"496563", "Kyllburg",
"495521", "Herzberg\ am\ Harz",
"495641", "Warburg",
"4938824", "Mallentin",
"494749", "Schiffdorf\-Geestenseth",
"498054", "Breitbrunn\ am\ Chiemsee",
"492306", "Lünen",
"4939776", "Hintersee",
"495136", "Burgdorf\ Kreis\ Hannover",
"492423", "Langerwehe",
"495502", "Dransfeld",
"498376", "Sulzberg\ Allgäu",
"496232", "Speyer",
"499244", "Betzenstein",
"497307", "Senden\ Iller",
"499831", "Gunzenhausen",
"499932", "Osterhofen",
"4939423", "Wegeleben",
"499637", "Falkenberg\ Oberpfalz",
"4936041", "Bad\ Tennstedt",
"494755", "Ihlienworth",
"492263", "Engelskirchen",
"495455", "Tecklenburg\-Brochterbeck",
"494445", "Visbek\ Kreis\ Vechta",
"495745", "Stemwede\-Levern",
"492958", "Büren\-Harth",
"4935024", "Stadt\ Wehlen",
"495084", "Hambühren",
"497435", "Albstadt\-Laufen",
"494806", "Sarzbüttel",
"496684", "Hofbieber\-Schwarzbach",
"492395", "Finnentrop\-Rönkhausen",
"4934327", "Waldheim\ Sachsen",
"498546", "Windorf\-Otterskirchen",
"492157", "Nettetal\-Kaldenkirchen",
"496427", "Cölbe\-Schönstadt",
"496267", "Fahrenbach\ Baden",
"496591", "Gerolstein",
"497194", "Spiegelberg",
"495404", "Westerkappeln",
"499662", "Vilseck",
"494704", "Drangstedt",
"497156", "Ditzingen",
"4938309", "Trent",
"493564", "Schwarze\ Pumpe",
"492208", "Niederkassel",
"498196", "Pürgen",
"492486", "Nettersheim",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"492369", "Dorsten\-Wulfen",
"493772", "Schneeberg\ Erzgebirge",
"496245", "Biblis",
"493437", "Grimma",
"497544", "Markdorf",
"492770", "Eschenburg",
"497624", "Grenzach\-Wyhlen",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"499945", "Arnbruck",
"492721", "Lennestadt",
"4936692", "Bürgel",
"495732", "Löhne",
"494432", "Dötlingen\-Brettorf",
"498076", "Pfaffing",
"494777", "Cadenberge",
"4933844", "Brück\ Brandenburg",
"497442", "Baiersbronn",
"498105", "Gilching",
"496888", "Lebach\-Steinbach",
"4938794", "Cumlosen",
"498683", "Tittmoning",
"499103", "Cadolzburg",
"4937202", "Claussnitz\ bei\ Chemnitz",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"492175", "Leichlingen\ Rheinland",
"492271", "Bergheim\ Erft",
"494534", "Steinburg\ Kreis\ Storman",
"493462", "Bad\ Dürrenberg",
"4939721", "Liepen\ bei\ Anklam",
"498728", "Geratskirchen",
"4935795", "Königsbrück",
"4936653", "Lehesten\ Thüringer\ Wald",
"4937324", "Reinsberg\ Sachsen",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"495384", "Seesen\-Gross\ Rhüden",
"497374", "Uttenweiler",
"4934774", "Röblingen\ am\ See",
"4938201", "Gelbensande",
"495767", "Warmsen",
"494467", "Wittmund\-Funnix",
"497633", "Staufen\ im\ Breisgau",
"495865", "Gusborn",
"498222", "Burgau\ Schwaben",
"497056", "Gechingen",
"492375", "Balve",
"4939389", "Schollene",
"499303", "Eibelstadt",
"499426", "Oberschneiding",
"493683", "Schmalkalden",
"499266", "Mitwitz",
"4939001", "Apenburg",
"497258", "Oberderdingen\-Flehingen",
"497174", "Mögglingen",
"495184", "Freden\ Leine",
"496571", "Wittlich",
"498462", "Berching",
"4937431", "Mehltheuer\ Vogtland",
"4934203", "Zwenkau",
"492545", "Rosendahl\-Darfeld",
"494875", "Stafstedt",
"4936926", "Creuzburg",
"492625", "Ochtendung",
"497963", "Adelmannsfelden",
"498564", "Johanniskirchen",
"495238", "Nieheim\-Himmighausen",
"4939976", "Gross\ Bützin",
"499280", "Selbitz\ Oberfranken",
"496508", "Hetzerath\ Mosel",
"4939267", "Schneidlingen",
"496636", "Romrod",
"494523", "Malente",
"495653", "Sontra",
"494643", "Gelting\ Angeln",
"493943", "Wernigerode",
"495036", "Neustadt\-Schneeren",
"496341", "Landau\ in\ der\ Pfalz",
"496053", "Wächtersbach",
"498772", "Mallersdorf\-Pfaffenberg",
"4935607", "Jänschwalde",
"4933470", "Lietzen",
"497946", "Bretzfeld",
"4936625", "Langenwetzendorf",
"497660", "St\ Peter\ Schwarzwald",
"499802", "Ansbach\-Katterbach",
"495083", "Hohne\ bei\ Celle",
"499901", "Hengersberg\ Bayern",
"497073", "Ammerbuch",
"496105", "Mörfelden\-Walldorf",
"496201", "Weinheim\ Bergstr",
"494381", "Lütjenburg",
"496683", "Ehrenberg\ Rhön",
"494703", "Loxstedt\-Donnern",
"495403", "Bad\ Iburg",
"495531", "Holzminden",
"494666", "Ladelund",
"493966", "Cölpin",
"495326", "Langelsheim",
"4939929", "Jabel\ bei\ Waren",
"492947", "Anröchte",
"4934742", "Sylda",
"492642", "Remagen",
"493571", "Hoyerswerda",
"497193", "Sulzbach\ an\ der\ Murr",
"4936764", "Neuhaus\-Schierschnitz",
"496728", "Ober\-Hilbersheim",
"492522", "Oelde",
"4936375", "Kindelbrück",
"499978", "Schönthal\ Oberpfalz",
"496196", "Bad\ Soden\ am\ Taunus",
"492687", "Horhausen\ Westerwald",
"497930", "Boxberg\ Baden",
"492982", "Medebach",
"499177", "Heideck",
"4935722", "Lauta\ bei\ Hoyerswerda",
"4939325", "Vinzelberg",
"497361", "Aalen",
"492424", "Vettweiss",
"496154", "Ober\-Ramstadt",
"497551", "Überlingen\ Bodensee",
"495292", "Lichtenau\-Atteln",
"492264", "Marienheide",
"4933872", "Hohennauen",
"497729", "Tennenbronn",
"495676", "Liebenau\ Hessen",
"493636", "Greussen",
"499243", "Pottenstein",
"494936", "Grossheide",
"493341", "Strausberg",
"499097", "Marxheim",
"498141", "Fürstenfeldbruck",
"498245", "Türkheim\ Wertach",
"4935208", "Radeburg",
"494498", "Saterland\-Ramsloh",
"496564", "Neuerburg\ Eifel",
"497265", "Angelbachtal",
"497161", "Göppingen",
"499377", "Freudenberg\-Boxtal",
"496396", "Hinterweidenthal",
"498259", "Schiltberg",
"4939882", "Gollin",
"494848", "Rantrum",
"498341", "Kaufbeuren",
"498053", "Bad\ Endorf",
"496772", "Nastätten",
"495858", "Hitzacker\-Wietzetze",
"498636", "Ampfing",
"497425", "Trossingen",
"499547", "Zapfendorf",
"4935247", "Zehren\ Sachsen",
"4936482", "Triptis",
"494285", "Rhade\ bei\ Zeven",
"494181", "Buchholz\ in\ der\ Nordheide",
"496305", "Hochspeyer",
"499627", "Freudenberg\ Oberpfalz",
"499922", "Zwiesel",
"499484", "Brennberg",
"496222", "Wiesloch",
"497838", "Nordrach",
"496462", "Gladenbach",
"4933676", "Friedland\ bei\ Beeskow",
"497393", "Munderkingen",
"498640", "Reit\ Im\ Winkl",
"498571", "Simbach\ am\ Inn",
"492433", "Hückelhoven",
"495126", "Algermissen",
"492501", "Münster\-Hiltrup",
"4935387", "Seyda",
"496147", "Trebur",
"4939745", "Hetzdorf\ bei\ Strasburg",
"493431", "Döbeln",
"4935342", "Mühlberg\ Elbe",
"4936081", "Arenshausen",
"4935361", "Schlieben",
"494771", "Hemmoor",
"4936336", "Klettenberg",
"495471", "Bohmte",
"497824", "Schwanau",
"4933701", "Grossbeeren",
"497726", "Bad\ Dürrheim",
"499973", "Furth\ im\ Wald",
"4934672", "Rossleben",
"494939", "Baltrum",
"492905", "Bestwig\-Ramsbeck",
"497949", "Pfedelbach\-Untersteinbach",
"494708", "Ringstedt",
"499164", "Langenfeld\ Mittelfranken",
"4934204", "Schkeuditz",
"49251", "Münster",
"496723", "Oestrich\-Winkel",
"495761", "Stolzenau",
"494461", "Jever",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"495286", "Ottenstein\ Niedersachsen",
"4936201", "Walschleben",
"493969", "Siedenbollentin",
"495329", "Schulenberg\ im\ Oberharz",
"498207", "Affing",
"4934322", "Rosswein",
"494221", "Delmenhorst",
"494125", "Seestermühe",
"496182", "Seligenstadt",
"492954", "Rüthen\-Oestereiden",
"492051", "Velbert",
"499554", "Untersteinbach\ Unterfranken",
"4938752", "Zierzow\ bei\ Ludwigslust",
"499364", "Zellingen",
"497955", "Wallhausen\ Württemberg",
"496382", "Lauterecken",
"494202", "Achim\ bei\ Bremen",
"493883", "Hagenow",
"4933843", "Niemegk",
"49621", "Mannheim",
"495665", "Guxhagen",
"497833", "Hornberg\ Schwarzwaldbahn",
"49991", "Deggendorf",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"495129", "Söhlde",
"496836", "Überherrn",
"495853", "Neu\ Darchau",
"4939832", "Wesenberg",
"4938793", "Dergenthin",
"494843", "Viöl",
"492573", "Nordwalde",
"498431", "Neuburg\ an\ der\ Donau",
"499505", "Litzendorf",
"496347", "Hochstadt\ Pfalz",
"4934426", "Kayna",
"497904", "Ilshofen",
"498503", "Neuhaus\ am\ Inn",
"4934773", "Schwittersdorf",
"497022", "Nürtingen",
"498639", "Neumarkt\-Sankt\ Veit",
"4937323", "Lichtenberg\ Erzgebirge",
"494493", "Friesoythe\-Gehlenberg",
"495935", "Twist\-Schöninghsdorf",
"4934651", "Rossla",
"499452", "Langquaid",
"499742", "Kalbach\ Rhön",
"492825", "Uedem",
"4933746", "Werbig\ bei\ Jüterbog",
"496734", "Flonheim",
"498294", "Horgau",
"499725", "Poppenhausen\ Unterfranken",
"492842", "Kamp\-Lintfort",
"492941", "Lippstadt",
"498723", "Arnstorf",
"4933478", "Gross\ Neuendorf",
"497045", "Oberderdingen",
"495224", "Enger\ Westfalen",
"495464", "Alfhausen",
"499602", "Neustadt\ an\ der\ Waldnaab",
"4939362", "Grieben\ bei\ Tangerhütte",
"494764", "Gnarrenburg\-Klenkendorf",
"493382", "Lehnin",
"496207", "Wald\-Michelbach",
"497332", "Lauterstein",
"4939341", "Redekin",
"499907", "Zenting",
"4937348", "Oberwiesenthal\ Kurort",
"495352", "Schöningen",
"492594", "Dülmen",
"495562", "Dassel\-Markoldendorf",
"493836", "Wolgast",
"494342", "Preetz\ Kreis\ Plön",
"492556", "Metelen",
"499091", "Monheim\ Schwaben",
"492366", "Herten\ Westfalen",
"494474", "Garrel",
"495774", "Wagenfeld\-Ströhen",
"492203", "Cologne\-Porz",
"4939402", "Völpke",
"492681", "Altenkirchen\ Westerwald",
"4935200", "Arnsdorf\ bei\ Dresden",
"497367", "Aalen\-Ebnat",
"499120", "Leinburg",
"498273", "Nordendorf",
"497557", "Herdwangen\-Schönach",
"4938375", "Koserow",
"499275", "Speichersdorf",
"499171", "Roth\ Mittelfranken",
"4936606", "Kraftsdorf",
"496503", "Hermeskeil",
"496431", "Limburg\ an\ der\ Lahn",
"492166", "Mönchengladbach\-Rheydt",
"498347", "Friesenried",
"494142", "Steinkirchen\ Kreis\ Stade",
"496058", "Gründau",
"495152", "Hessisch\ Oldendorf",
"495658", "Wehretal",
"494528", "Schönwalde\ am\ Bungsberg",
"499371", "Miltenberg",
"498734", "Reisbach\ Niederbayern",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"496294", "Krautheim\ Jagst",
"496256", "Lampertheim\-Hüttenfeld",
"495233", "Steinheim\ Westfalen",
"499956", "Eichendorf\-Aufhausen",
"496639", "Ottrau",
"4937467", "Klingenthal\ Sachsen",
"497253", "Bad\ Schönborn",
"493723", "Hohenstein\-Ernstthal",
"499429", "Rain\ Niederbayern",
"492507", "Havixbeck",
"4939488", "Güntersberge",
"498065", "Tuntenhausen\-Schönau",
"499621", "Amberg\ Oberpfalz",
"497132", "Neckarsulm",
"499269", "Tettau\ Kreis\ Kronach",
"49821", "Augsburg",
"494187", "Holm\-Seppensen",
"498382", "Lindau\ Bodensee",
"4938482", "Warin",
"497506", "Wangen\-Leupolz",
"499827", "Lichtenau\ Mittelfranken",
"4937296", "Stollberg\ Erzgebirge",
"499105", "Grosshabersdorf",
"499201", "Gesees",
"499683", "Friedenfels",
"493303", "Birkenwerder",
"496802", "Völklingen\-Lauterbach",
"498685", "Kirchanschöring",
"49481", "Heide\ Holstein",
"4938295", "Satow\ bei\ Bad\ Doberan",
"497246", "Malsch\ Kreis\ Karlsruhe",
"4933361", "Joachimsthal",
"492173", "Langenfeld\ Rheinland",
"494240", "Syke\-Heiligenfelde",
"4934491", "Schmölln\ Thüringen",
"499728", "Wülfershausen\ Unterfranken",
"4939924", "Stuer",
"4936845", "Gehlberg",
"497731", "Singen\ Hohentwiel",
"492634", "Rengsdorf",
"495250", "Delbrück\ Westfalen",
"492247", "Neunkirchen\-Seelscheid",
"499154", "Pommelsbrunn",
"495441", "Diepholz",
"494741", "Nordholz\ bei\ Bremerhaven",
"499196", "Wiesenttal",
"49231", "Dortmund",
"495751", "Rinteln",
"499278", "Weidenberg",
"494451", "Varel\ Jadebusen",
"499943", "Lam\ Oberpfalz",
"494236", "Kirchlinteln",
"495529", "Rhumspringe",
"496243", "Monsheim",
"4938356", "Behrenhoff",
"496049", "Kefenrod",
"4938821", "Lüdersdorf",
"492964", "Brilon\-Alme",
"499076", "Wittislingen",
"492623", "Ransbach\-Baumbach",
"49211", "Düsseldorf",
"492543", "Billerbeck\ Westfalen",
"499396", "Urspringen\ bei\ Lohr",
"494873", "Aukrug",
"497965", "Ellwangen\-Röhlingen",
"499564", "Bad\ Rodach",
"499354", "Rieneck",
"496582", "Freudenburg",
"4933232", "Brieselang",
"4938850", "Gammelin",
"496055", "Freigericht",
"4935843", "Hirschfelde\ bei\ Zittau",
"499772", "Bischofsheim\ an\ der\ Rhön",
"495655", "Wanfried",
"494525", "Ahrensbök",
"492373", "Menden\ Sauerland",
"496484", "Beselich",
"499222", "Presseck",
"495863", "Zernien",
"497635", "Schliengen",
"496821", "Neunkirchen\ Saar",
"4939243", "Nedlitz\ bei\ Zerbst",
"493685", "Hildburghausen",
"4938452", "Lalendorf",
"498303", "Waltenhofen",
"496599", "Weidenbach\ bei\ Gerolstein",
"496627", "Nentershausen\ Hessen",
"498426", "Walting\ Kreis\ Eichstätt",
"4935021", "Königstein\ Sächsische\ Schweiz",
"495027", "Linsburg",
"499305", "Estenfeld",
"498266", "Kirchheim\ in\ Schwaben",
"498781", "Rottenburg\ an\ der\ Laaber",
"4936732", "Könitz",
"4939458", "Heudeber",
"496004", "Lich\-Eberstadt",
"499462", "Falkenstein\ Oberpfalz",
"495604", "Grossalmerode",
"494372", "Westfehmarn",
"495337", "Kissenbrück",
"4938304", "Garz\ Rügen",
"498177", "Münsing\ Starnberger\ See",
"494856", "Kronprinzenkoog",
"493377", "Zossen\ Brandenburg",
"4935478", "Goyatz",
"495846", "Gartow\ Niedersachsen",
"495744", "Hüllhorst",
"494444", "Goldenstedt",
"495454", "Hörstel\-Riesenbeck",
"4938222", "Semlow",
"494754", "Bülkau",
"4933765", "Märkisch\ Buchholz",
"498243", "Fuchstal",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"4933849", "Wiesenburg\ Mark",
"497532", "Meersburg",
"499245", "Obertrubach",
"499141", "Weissenburg\ in\ Bayern",
"494796", "Teufelsmoor",
"492971", "Schmallenberg\-Dorlar",
"494542", "Mölln\ Lauenburg",
"492872", "Rhede\ Westfalen",
"495362", "Wolfsburg\-Fallersleben",
"492394", "Neuenrade\-Affeln",
"4938464", "Bernitt",
"495552", "Katlenburg",
"494622", "Taarstedt",
"494128", "Kollmar",
"493821", "Ribnitz\-Damgarten",
"496103", "Langen\ Hessen",
"494927", "Krummhörn\-Loquard",
"498802", "Huglfing",
"492566", "Legden",
"495085", "Burgdorf\-Ehlershausen",
"497434", "Winterlingen",
"4937329", "Grosshartmannsdorf",
"4933200", "Bergholz\-Rehbrücke",
"4935828", "Reichenbach\ OL",
"4934779", "Abberode",
"494705", "Wremen",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"492739", "Wilnsdorf",
"497195", "Winnenden",
"497357", "Attenweiler",
"4936961", "Bad\ Liebenstein",
"497567", "Leutkirch\-Friesenhofen",
"4935936", "Sohland\ Spree",
"492156", "Willich\-Anrath",
"498547", "Osterhofen\-Gergweis",
"496426", "Fronhausen",
"493901", "Salzwedel",
"494283", "Tarmstedt",
"496303", "Enkenbach\-Alsenborn",
"498821", "Garmisch\-Partenkirchen",
"494328", "Rickling",
"4939863", "Seehausen\ bei\ Prenzlau",
"495162", "Fallingbostel",
"4939384", "Arendsee\ Altmark",
"496068", "Beerfelden",
"497157", "Waldenbuch",
"499571", "Lichtenfels\ Bayern",
"497395", "Ehingen\-Dächingen",
"4938782", "Reetz\ bei\ Perleberg",
"496781", "Idar\-Oberstein",
"499966", "Wiesenfelden",
"4933927", "Linum",
"497958", "Rot\ Am\ See\-Brettheim",
"492435", "Erkelenz\-Lövenich",
"496266", "Hassmersheim",
"494409", "Westerstede\-Ocholt",
"498377", "Unterthingau",
"497263", "Waibstadt",
"495137", "Seelze",
"494172", "Salzhausen",
"492828", "Emmerich\-Elten",
"492307", "Kamen",
"499341", "Tauberbischofsheim",
"4936020", "Ebeleben",
"4939603", "Burg\ Stargard",
"498055", "Halfing",
"499636", "Plössberg",
"4936463", "Gebstedt",
"4936072", "Weissenborn\-Lüderode",
"497423", "Oberndorf\ am\ Neckar",
"4933831", "Weseram",
"497306", "Vöhringen\ Iller",
"498582", "Röhrnbach",
"4935263", "Gröditz\ bei\ Riesa",
"495482", "Tecklenburg",
"497472", "Rottenburg\ am\ Neckar",
"4935058", "Pretzschendorf",
"493364", "Eisenhüttenstadt",
"495924", "Bad\ Bentheim\-Gildehaus",
"492241", "Siegburg",
"492359", "Kierspe",
"492834", "Straelen",
"493596", "Neustadt\ in\ Sachsen",
"496725", "Gau\-Algesheim",
"4938845", "Kaarssen",
"4935975", "Hohnstein",
"4939421", "Osterwieck",
"4936043", "Kirchheilingen",
"494123", "Barmstedt",
"49391", "Magdeburg",
"492736", "Burbach\ Siegerl",
"49461", "Flensburg",
"499207", "Königsfeld\ Oberfranken",
"497344", "Blaubeuren",
"4935844", "Oybin\ Kurort",
"496108", "Mühlheim\ am\ Main",
"495691", "Bad\ Arolsen",
"497762", "Wehr\ Baden",
"495849", "Waddeweitz",
"494334", "Bredenbek\ bei\ Rendsburg",
"498248", "Lamerdingen",
"4939244", "Steutz",
"4937605", "Hartenstein\ Sachsen",
"494859", "Windbergen",
"495584", "Hattorf\ am\ Harz",
"497574", "Gammertingen",
"496171", "Oberursel\ Taunus",
"496275", "Rothenberg\ Odenwald",
"499975", "Waldmünchen\-Geigant",
"496120", "Aarbergen",
"492903", "Meschede\-Freienohl",
"495447", "Lembruch",
"494747", "Beverstedt",
"498046", "Bad\ Heilbrunn",
"497066", "Bad\ Rappenau\-Bonfeld",
"4939852", "Schönermark\ bei\ Prenzlau",
"494845", "Ostenfeld\ Husum",
"492575", "Greven\-Reckenfeld",
"495855", "Nahrendorf",
"494134", "Embsen\ Kreis\ Lüneburg",
"499431", "Schwandorf",
"498505", "Hutthurm",
"499503", "Oberhaid\ Oberfranken",
"497428", "Rosenfeld",
"4938858", "Lassahn",
"494495", "Friesoythe\-Thüle",
"495933", "Lathen",
"497268", "Bad\ Rappenau\-Obergimpern",
"499639", "Mähring",
"4939923", "Priborn",
"499256", "Stammbach",
"492823", "Goch",
"497309", "Weissenhorn",
"498452", "Geisenfeld",
"498742", "Velden\ Vils",
"496371", "Landstuhl",
"499294", "Regnitzlosau",
"493973", "Pasewalk",
"494673", "Joldelund",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"496429", "Schweinsberg\ Hessen",
"492159", "Meerbusch\-Osterath",
"498554", "Schönberg\ Niederbayern",
"497953", "Blaufelden",
"495190", "Soltau\-Emmingen",
"498364", "Seeg",
"4938732", "Gallin\ bei\ Lübz",
"4936452", "Berlstedt",
"496827", "Eppelborn",
"494288", "Horstedt\ Kreis\ Rotenburg",
"496308", "Olsbrücken",
"4938327", "Elmenhorst\ Vorpom",
"496541", "Traben\-Trarbach",
"496269", "Gundelsheim\ Württemberg",
"4933607", "Briesen\ Mark",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"494406", "Berne",
"496063", "Bad\ König",
"495021", "Nienburg\ Weser",
"497144", "Marbach\ am\ Neckar",
"495706", "Porta\ Westfalica",
"496670", "Ludwigsau\ Hessen",
"494323", "Bornhöved",
"497835", "Zell\ am\ Harmersbach",
"495663", "Spangenberg",
"496621", "Bad\ Hersfeld",
"4934298", "Taucha\ bei\ Leipzig",
"499948", "Eschlkam",
"499147", "Nennslingen",
"4939383", "Sandau\ Elbe",
"498091", "Kirchseeon",
"499199", "Kunreuth",
"496046", "Ortenberg\ Hessen",
"4933088", "Falkenthal",
"495331", "Wolfenbüttel",
"492205", "Rösrath",
"494239", "Dörverden\-Westen",
"495646", "Willebadessen",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"493994", "Malchin",
"498171", "Wolfratshausen",
"493371", "Luckenwalde",
"498725", "Wurmannsquick",
"499723", "Röthlein",
"497976", "Sulzbach\-Laufen",
"497351", "Biberach\ an\ der\ Riss",
"497043", "Maulbronn",
"496164", "Reichelsheim\ Odenwald",
"497561", "Leutkirch\ im\ Allgäu",
"497249", "Stutensee",
"4939604", "Wildberg\ bei\ Altentreptow",
"4933337", "Altkünkendorf",
"492254", "Weilerswist",
"492977", "Schmallenberg\-Bödefeld",
"4934461", "Nebra\ Unstrut",
"4935872", "Neusalza\-Spremberg",
"499182", "Velburg",
"4933208", "Fahrland",
"4935264", "Strehla",
"493541", "Calau",
"492672", "Treis\-Karden",
"4935820", "Zodel",
"494822", "Kellinghusen",
"494921", "Emden\ Stadt",
"493621", "Gotha\ Thüringen",
"492296", "Reichshof\-Brüchermühle",
"4936464", "Wormstedt",
"4938303", "Sellin\ Ostseebad",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"496554", "Waxweiler",
"496364", "Nussbach\ Pfalz",
"497255", "Graben\-Neudorf",
"497151", "Waiblingen",
"493725", "Zschopau",
"496787", "Niederbrombach",
"496596", "Üdersdorf",
"494607", "Janneby",
"493907", "Gardelegen",
"498621", "Trostberg",
"498541", "Vilshofen\ Niederbayern",
"492378", "Fröndenberg\-Langschede",
"498269", "Unteregg\ bei\ Mindelheim",
"49921", "Bayreuth",
"498063", "Feldkirchen\-Westerham",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"498670", "Reischach\ Kreis\ Altötting",
"499382", "Gerolzhofen",
"494902", "Jemgum\-Ditzum",
"4934346", "Narsdorf",
"496505", "Kordel",
"499347", "Wittighausen",
"497204", "Malsch\-Völkersbach",
"4939955", "Jürgenstorf",
"499836", "Gunzenhausen\-Cronheim",
"496742", "Boppard",
"492548", "Dülmen\-Rorup",
"499734", "Burkardroth",
"498320", "Missen\-Wilhams",
"492628", "Rhens",
"496452", "Battenberg\ Eder",
"492301", "Holzwickede",
"4936028", "Kammerforst\ Thüringen",
"495131", "Garbsen",
"495235", "Blomberg\ Lippe",
"498221", "Günzburg",
"496387", "Sankt\ Julian",
"495965", "Klein\ Berssen",
"494207", "Oyten",
"49961", "Weiden\ in\ der\ Oberpfalz",
"499123", "Lauf\ an\ der\ Pegnitz",
"4939246", "Lindau\ Anh",
"498669", "Traunreut",
"496764", "Rheinböllen",
"4989", "Munich",
"494883", "Süderstapel",
"498708", "Weihmichl\-Unterneuhausen",
"4938750", "Malliss",
"496866", "Perl\-Nennig",
"497655", "Feldberg\-Altglashütten",
"492778", "Siegbach",
"496572", "Manderscheid\ Eifel",
"498461", "Beilngries",
"494975", "Westerholt\ Ostfriesland",
"493675", "Sonneberg\ Thüringen",
"492228", "Remagen\-Rolandseck",
"4933335", "Pinnow\ Kreis\ Uckermark",
"496035", "Reichelsheim\ Wetterau",
"499747", "Geroda\ Bayern",
"496474", "Villmar\-Aumenau",
"492383", "Bönen",
"493493", "Bitterfeld",
"495635", "Vöhl",
"496342", "Schweigen\-Rechtenbach",
"498771", "Ergoldsbach",
"499334", "Giebelstadt",
"493843", "Güstrow",
"494256", "Hilgermissen",
"494639", "Schafflund",
"492183", "Rommerskirchen",
"495246", "Verl",
"492605", "Löf",
"499495", "Breitenbrunn\ Oberpfalz",
"499673", "Tiefenbach\ Oberpfalz",
"494294", "Riede\ Kreis\ Verden",
"4933052", "Leegebruch",
"499134", "Neunkirchen\ am\ Brand",
"496142", "Rüsselsheim",
"496648", "Bad\ Salzschlirf",
"493771", "Aue\ Sachsen",
"499845", "Oberdachstetten",
"492722", "Attendorn",
"4938353", "Gützkow\ bei\ Greifswald",
"494503", "Timmendorfer\ Strand",
"497250", "Kraichtal",
"495731", "Bad\ Oeynhausen",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"494431", "Wildeshausen",
"497441", "Freudenstadt",
"498202", "Althegnenberg",
"497751", "Waldshut",
"499288", "Bad\ Steben",
"492654", "Polch",
"4939398", "Gross\ Garz",
"492272", "Bedburg\ Erft",
"499323", "Iphofen",
"499406", "Mintraching",
"496187", "Schöneck",
"492696", "Nohn\ Eifel",
"498325", "Oberstaufen\-Thalkirchdorf",
"4938721", "Ziegendorf",
"493461", "Merseburg\ Saale",
"4937208", "Auerswalde",
"4939201", "Wolmirstedt",
"4938392", "Sassnitz",
"499086", "Fremdingen",
"4933962", "Heiligengrabe",
"4933093", "Fürstenberg\ Havel",
"4939957", "Gielow",
"496500", "Waldrach",
"497529", "Waldburg\ Württemberg",
"497668", "Ihringen",
"497162", "Süssen",
"4939888", "Lychen",
"498035", "Raubling",
"499656", "Moosbach\ bei\ Vohenstrauss",
"492404", "Alsdorf\ Rheinland",
"494273", "Kirchdorf\ bei\ Sulingen",
"498342", "Marktoberdorf",
"4935266", "Heyda\ bei\ Riesa",
"494948", "Wiesmoor\-Marcardsmoor",
"496771", "St\ Goarshausen",
"4938847", "Boizenburg\ Elbe",
"497709", "Wutach",
"493528", "Radeberg",
"4939606", "Glienke",
"495157", "Emmerthal\-Börry",
"494182", "Tostedt",
"4969", "Frankfurt\ am\ Main",
"498764", "Mauern\ Kreis\ Freising",
"499921", "Regen",
"496669", "Neuhof\-Hauswurz",
"499822", "Bechhofen\ an\ der\ Heide",
"492745", "Brachbach\ Sieg",
"497938", "Mulfingen\ Jagst",
"496221", "Heidelberg",
"492455", "Waldfeucht",
"495263", "Barntrup",
"495069", "Nordstemmen",
"498387", "Weiler\-Simmerberg",
"4933731", "Trebbin",
"496461", "Biedenkopf",
"495423", "Versmold",
"494723", "Cuxhaven\-Altenwalde",
"498572", "Tann\ Niederbayern",
"4937607", "Ebersbrunn\ Sachsen",
"495306", "Cremlingen",
"492502", "Nottuln",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"49421", "Bremen",
"492449", "Blankenheim\ Ahr",
"496325", "Lambrecht\ Pfalz",
"499607", "Luhe\-Wildenau",
"492759", "Bad\ Berleburg\-Aue",
"493764", "Meerane",
"497337", "Nellingen\ Alb",
"4934344", "Kohren\-Sahlis",
"496202", "Schwetzingen",
"494382", "Wangels",
"4935933", "Neschwitz",
"495532", "Stadtoldendorf",
"493866", "Cambs",
"497744", "Stühlingen",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"492521", "Beckum",
"495850", "Neetze",
"497454", "Sulz\ am\ Neckar",
"492336", "Schwelm",
"496675", "Breitenbach\ am\ Herzberg",
"4933657", "Steinsdorf\ Brandenburg",
"4933605", "Boossen",
"4933878", "Nennhausen",
"495434", "Essen\ Oldenburg",
"497085", "Enzklösterle",
"494734", "Stadland\-Seefeld",
"4939400", "Wefensleben",
"4938325", "Rolofshagen",
"492981", "Winterberg\ Westfalen",
"497552", "Pfullendorf",
"4935202", "Klingenberg\ Sachsen",
"497362", "Bopfingen",
"494347", "Flintbek",
"495195", "Neuenkirchen\ bei\ Soltau",
"495357", "Grasleben",
"4935728", "Uhyst\ Spree",
"494836", "Hennstedt\ Dithmarschen",
"496843", "Gersheim",
"493342", "Neuenhagen\ bei\ Berlin",
"4935324", "Crinitz",
"498142", "Olching",
"492052", "Velbert\-Langenberg",
"495428", "Melle\-Neuenkirchen",
"498467", "Kinding",
"492585", "Warendorf\-Hoetmar",
"495066", "Sarstedt",
"4939752", "Blumenhagen\ bei\ Strasburg",
"496703", "Wöllstein\ Rheinhessen",
"4933767", "Friedersdorf\ bei\ Berlin",
"496666", "Freiensteinau",
"495309", "Lehre\-Wendhausen",
"494683", "Oldsum",
"496381", "Kusel",
"494105", "Seevetal",
"497933", "Creglingen",
"498534", "Tettenweis",
"4938758", "Dömitz",
"498869", "Kinsau",
"4938354", "Wusterhusen",
"49981", "Ansbach",
"495953", "Börger",
"493523", "Coswig\ bei\ Dresden",
"499659", "Leuchtenberg",
"499236", "Nagel",
"493643", "Weimar\ Thüringen",
"494943", "Grossefehn",
"498432", "Burgheim",
"497804", "Oppenau",
"497021", "Kirchheim\ unter\ Teck",
"495144", "Wathlingen",
"497706", "Oberbaldingen",
"497663", "Eichstetten",
"495835", "Wahrenholz",
"494154", "Trittau",
"499451", "Schierling",
"4939926", "Grabowhöfe",
"4933094", "Löwenberg",
"499741", "Bad\ Brückenau",
"492925", "Warstein\-Allagen",
"4933925", "Wustrau\-Altfriesack",
"494772", "Oberndorf\ Oste",
"499525", "Königsberg\ in\ Bayern",
"497482", "Horb\-Dettingen",
"496848", "Homburg\-Einöd",
"495472", "Bad\ Essen",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"499873", "Abenberg\-Wassermungenau",
"494354", "Fleckeby",
"494564", "Schashagen",
"494839", "Wöhrden\ Dithmarschen",
"495344", "Lengede",
"4933679", "Wendisch\ Rietz",
"4939771", "Ueckermünde",
"492446", "Heimbach\ Eifel",
"4934328", "Hartha\ bei\ Döbeln",
"494462", "Wittmund",
"4939390", "Iden",
"4935032", "Langenhennersdorf",
"493869", "Dümmer",
"494222", "Ganderkesee",
"497447", "Baiersbronn\-Schwarzenberg",
"494305", "Westensee",
"496181", "Hanau",
"496285", "Walldürn\-Altheim",
"497584", "Altshausen",
"495574", "Oberweser",
"492339", "Sprockhövel\-Hasslinghausen",
"495109", "Ronnenberg",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"499444", "Siegenburg",
"496432", "Diez",
"4938231", "Barth",
"494141", "Stade",
"494245", "Neuenkirchen\ bei\ Bassum",
"4934343", "Regis\-Breitingen",
"495151", "Hameln",
"492463", "Titz",
"4938466", "Jürgenshagen",
"495255", "Altenbeken",
"4936847", "Steinbach\-Hallenberg",
"492223", "Königswinter",
"4938297", "Moitin",
"4935751", "Welzow",
"499372", "Klingenberg\ am\ Main",
"4935934", "Grossdubrau",
"499856", "Dürrwangen",
"492388", "Hamm\-Uentrop",
"4933989", "Sadenbeck",
"498666", "Teisendorf",
"496467", "Hatzfeld\ Eder",
"498703", "Essenbach",
"4938488", "Demen",
"492773", "Haiger",
"495204", "Steinhagen\ Westfalen",
"4938306", "Samtens",
"496869", "Merzig\-Silwingen",
"499622", "Hirschau\ Oberpfalz",
"499128", "Feucht",
"496534", "Mülheim\ Mosel",
"499542", "Schesslitz",
"497131", "Heilbronn\ Neckar",
"497235", "Unterreichenbach\ Kreis\ Calw",
"4933451", "Heckelberg",
"496227", "Walldorf\ Baden",
"4939482", "Gatersleben",
"4935323", "Sonnewalde",
"498381", "Lindenberg\ im\ Allgäu",
"499927", "Kirchberg\ Wald",
"495593", "Bovenden\-Lenglern",
"492841", "Moers",
"492942", "Geseke",
"496050", "Biebergemünd",
"4937361", "Neuhausen\ Erzgebirge",
"492234", "Frechen",
"495650", "Cornberg",
"499409", "Pielenhofen",
"492527", "Lippetal\-Lippborg",
"4937342", "Cranzahl",
"494966", "Neubörger",
"492647", "Kesseling",
"4936929", "Ruhla",
"499283", "Rehau",
"499089", "Bissingen\-Unterringingen",
"493381", "Brandenburg\ an\ der\ Havel",
"498285", "Burtenbach",
"497331", "Geislingen\ an\ der\ Steige",
"4935691", "Bärenklau\ NL",
"4933472", "Golzow\ bei\ Seelow",
"497646", "Weisweil\ Breisgau",
"496523", "Holsthum",
"494636", "Langballig",
"495561", "Einbeck",
"49271", "Siegen",
"4939408", "Hadmersleben",
"495043", "Lauenau",
"495351", "Helmstedt",
"4939386", "Seehausen\ Altmark",
"496643", "Herbstein",
"4939031", "Dähre",
"4933870", "Zollchow\ bei\ Rathenow",
"499092", "Wemding",
"495976", "Salzbergen",
"494508", "Krummesse",
"492682", "Hamm\ Sieg",
"496875", "Nonnweiler\-Primstal",
"4935772", "Rietschen",
"499172", "Georgensgmünd",
"496694", "Neukirchen\ Knüll",
"4939973", "Altkalen",
"494973", "Wittmund\-Burhafe",
"4933238", "Senzke",
"496656", "Ebersburg",
"495633", "Diemelsee",
"498457", "Vohburg\ an\ der\ Donau",
"496239", "Bobenheim\-Roxheim",
"4936923", "Treffurt",
"495056", "Winsen\-Meissendorf",
"496033", "Butzbach",
"492385", "Hamm\-Rhynern",
"4934206", "Rötha",
"496581", "Saarburg",
"495174", "Lahstedt",
"497184", "Kaisersbach",
"495509", "Rosdorf\ Kreis\ Göttingen",
"499720", "Üchtelhausen",
"494248", "Bassum\-Neubruchhausen",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"495258", "Salzkotten",
"498334", "Bad\ Grönenbach",
"499221", "Kulmbach",
"4936334", "Wolkramshausen",
"49861", "Traunstein",
"499270", "Creussen",
"498123", "Moosinning",
"4938377", "Zinnowitz",
"4936738", "Königsee",
"495963", "Bawinkel",
"4939452", "Ilsenburg",
"4936450", "Kranichfeld",
"494885", "Bergenhusen",
"497653", "Lenzkirch",
"494164", "Harsefeld",
"499708", "Bad\ Bocklet",
"498782", "Pfeffenhausen",
"4938458", "Zehna",
"499461", "Roding",
"4939991", "Daberkow",
"4934424", "Reuden\ bei\ Zeitz",
"499202", "Waischenfeld",
"4936421", "Camburg",
"4939295", "Zuchau",
"49491", "Leer\ Ostfriesland",
"498323", "Immenstadt\ im\ Allgäu",
"49361", "Erfurt",
"498406", "Böhmfeld",
"499325", "Kleinlangheim",
"4933744", "Hohenseefeld",
"497477", "Jungingen\ bei\ Hechingen",
"498086", "Buchbach\ Oberbayern",
"497732", "Radolfzell\ am\ Bodensee",
"495544", "Reinhardshagen",
"496024", "Schöllkrippen",
"494364", "Dahme\ Kreis\ Ostholstein",
"494554", "Wahlstedt",
"495624", "Bad\ Emstal",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"492603", "Bad\ Ems",
"499493", "Beratzhausen",
"495442", "Barnstorf\ Kreis\ Diepholz",
"494742", "Dorum",
"495752", "Auetal\-Hattendorf",
"499675", "Altendorf\ am\ Nabburg",
"494452", "Zetel\-Neuenburg",
"493334", "Eberswalde",
"499843", "Burgbernheim",
"498134", "Odelzhausen",
"4934262", "Falkenhain\ bei\ Wurzen",
"498845", "Bad\ Kohlgrub",
"4936871", "Bad\ Colberg\-Heldburg",
"492864", "Reken",
"4939821", "Carpin",
"4937465", "Tannenbergsthal\ Vogtland",
"4935329", "Dollenchen",
"497384", "Schelklingen\-Hütten",
"495374", "Isenbüttel",
"4934241", "Jesewitz",
"4938333", "Horst\ bei\ Grimmen",
"494505", "Stockelsdorf\-Curau",
"4935895", "Klitten",
"499764", "Höchheim",
"493902", "Diesdorf\ Altm",
"494108", "Rosengarten\ Kreis\ Harburg",
"494602", "Freienwill",
"49661", "Fulda",
"496123", "Eltville\ am\ Rhein",
"495161", "Walsrode",
"492453", "Heinsberg\-Randerath",
"495265", "Dörentrup",
"4938788", "Gross\ Warnow",
"498822", "Oberammergau",
"492743", "Daaden",
"495425", "Borgholzhausen",
"499572", "Burgkunstadt",
"494725", "Helgoland",
"496782", "Birkenfeld\ Nahe",
"492588", "Harsewinkel\-Greffen",
"4935385", "Annaburg",
"4939747", "Züsedom",
"4933673", "Weichensdorf",
"496457", "Burgwald\ Eder",
"498239", "Langenneufnach",
"498033", "Oberaudorf",
"495838", "Gross\ Oesingen",
"496747", "Emmelshausen",
"498656", "Anger",
"499474", "Schmidmühlen",
"494275", "Ehrenburg",
"494171", "Winsen\ Luhe",
"494120", "Ellerhoop",
"492928", "Soest\-Ostönnen",
"499342", "Wertheim",
"4935451", "Dahme\ Brandenburg",
"496334", "Thaleischweiler\-Fröschen",
"497126", "Burladingen\-Melchingen",
"498581", "Waldkirchen\ Niederbayern",
"497083", "Bad\ Herrenalb",
"495073", "Neustadt\-Esperke",
"494320", "Heidmühlen",
"496673", "Haunetal",
"494371", "Burg\ auf\ Fehmarn",
"4938228", "Dettmannsdorf\-Kölzow",
"4933637", "Beerfelde",
"494956", "Uplengen",
"495946", "Georgsdorf",
"492327", "Bochum\-Wattenscheid",
"493581", "Görlitz",
"4937294", "Grünhainichen",
"495193", "Schneverdingen",
"497950", "Schnelldorf",
"4939222", "Möser",
"49228", "Bonn",
"499528", "Donnersdorf",
"497403", "Dunningen",
"497326", "Neresheim",
"496134", "Mainz\-Kastel",
"497531", "Konstanz",
"4935472", "Schlepzig",
"499648", "Neustadt\ am\ Kulm",
"499142", "Treuchtlingen",
"496406", "Lollar",
"499187", "Altdorf\ bei\ Nürnberg",
"4936948", "Römhild",
"4935822", "Hagenwerder",
"4934601", "Teutschenthal",
"492972", "Schmallenberg",
"494269", "Ahausen\-Kirchwalsede",
"492871", "Bocholt",
"494541", "Ratzeburg",
"495551", "Northeim",
"494621", "Schleswig",
"493921", "Burg\ bei\ Magdeburg",
"495361", "Wolfsburg",
"496323", "Edenkoben",
"494308", "Schwedeneck",
"498801", "Seeshaupt",
"4936604", "Münchenbernsdorf",
"494827", "Wacken",
"492677", "Lutzerath",
"4935953", "Burkau",
"498024", "Holzkirchen",
"496086", "Grävenwiesbach",
"497676", "Feldberg\ Schwarzwald",
"495686", "Schwarzenborn\ Knüll",
"494945", "Grossefehn\-Timmel",
"4938852", "Wittenburg",
"49212", "Solingen",
"4934785", "Sandersleben",
"496587", "Zerf",
"4934423", "Heuckewalde",
"498236", "Fischach",
"495955", "Esterwegen",
"493525", "Riesa",
"496444", "Bischoffen",
"499777", "Ostheim\ von\ der\ Rhön",
"4938796", "Viesecke",
"496754", "Martinstein",
"4933230", "Börnicke\ Kreis\ Havelland",
"497665", "March\ Breisgau",
"495833", "Brome",
"496856", "St\ Wendel\-Niederkirchen",
"4933743", "Blönsdorf",
"4935939", "Hochkirch",
"4939858", "Bietikow",
"498038", "Vogtareuth",
"497129", "Lichtenstein\ Württemberg",
"496894", "St\ Ingbert",
"492923", "Lippetal\-Herzfeld",
"4937326", "Frauenstein\ Sachsen",
"498741", "Vilsbiburg",
"4934776", "Rothenschirmbach",
"496372", "Bruchmühlbach\-Miesau",
"4936458", "Bad\ Berka",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"495904", "Lengerich\ Emsl",
"499467", "Michelsneukirchen",
"497853", "Kehl\-Bodersweier",
"492583", "Sassenberg",
"4936730", "Sitzendorf",
"4939327", "Klietz",
"4938450", "Tarnow\ bei\ Bützow",
"494103", "Wedel",
"499227", "Neuenmarkt",
"4933846", "Dippmannsdorf",
"499534", "Burgpreppach",
"495022", "Wietzen",
"4938334", "Grammendorf",
"496542", "Bullay",
"497935", "Schrozberg",
"496622", "Bebra",
"499869", "Wettringen\ Mittelfranken",
"496128", "Taunusstein",
"49881", "Weilheim\ in\ Oberbayern",
"4936377", "Rastenberg",
"4938738", "Karow\ bei\ Lübz",
"495481", "Lengerich\ Westfalen",
"4934921", "Kemberg",
"497471", "Hechingen",
"4937422", "Markneukirchen",
"497420", "Deisslingen",
"495824", "Bad\ Bodenteich",
"496409", "Biebertal",
"494266", "Brockel",
"492242", "Hennef\ Sieg",
"4936924", "Mihla",
"492934", "Sundern\-Altenhellefeld",
"49381", "Rostock",
"496328", "Elmstein",
"4935052", "Kipsdorf\ Kurort",
"497260", "Sinsheim\-Hilsbach",
"495726", "Wiedensahl",
"494426", "Wangerland\-Horumersiel",
"494303", "Schlesen",
"496283", "Hardheim\ Odenwald",
"497761", "Bad\ Säckingen",
"492664", "Rennerod",
"495692", "Wolfhagen",
"495198", "Schneverdingen\-Wintermoor",
"4936333", "Heringen\ Helme",
"495276", "Marienmünster",
"496092", "Heimbuchenthal",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"499523", "Hofheim\ in\ Unterfranken",
"4938871", "Mühlen\ Eichsen",
"494959", "Dollart",
"496678", "Wildeck\-Hönebach",
"493741", "Plauen",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"499875", "Wolframs\-Eschenbach",
"497329", "Steinheim\ am\ Albuch",
"492803", "Wesel\-Büderich",
"4935245", "Burkhardswalde\-Munzig",
"499666", "Illschwang",
"498705", "Altfraunhofen",
"4938780", "Lanz\ Brandenburg",
"49203", "Duisburg",
"497152", "Leonberg\ Württemberg",
"492775", "Driedorf",
"4933977", "Gumtow",
"493328", "Teltow",
"498622", "Tacherting\-Peterskirchen",
"4937293", "Eppendorf\ Sachsen",
"49681", "Saarbrücken",
"497233", "Niefern\-Öschelbronn",
"498542", "Ortenburg",
"499381", "Volkach",
"493601", "Mühlhausen\ Thüringen",
"495167", "Walsrode\-Westenholz",
"4934381", "Colditz",
"494802", "Wrohm",
"498754", "Volkenschwand",
"498444", "Schweitenkirchen",
"496236", "Neuhofen\ Pfalz",
"495253", "Bad\ Driburg",
"492465", "Inden",
"499936", "Wallerfing",
"494243", "Twistringen",
"496659", "Eichenzell",
"4936022", "Grossengottern",
"4935797", "Schwepnitz",
"4936603", "Weida",
"495506", "Adelebsen",
"496741", "St\ Goar",
"498372", "Obergünzburg",
"4935954", "Grossharthau",
"496451", "Frankenberg\ Eder",
"492225", "Meckenheim\ Rheinland",
"4936766", "Schalkau",
"492302", "Witten",
"494177", "Drage\ Elbe",
"498856", "Penzberg",
"495132", "Lehrte",
"4933082", "Menz\ Kreis\ Oberhavel",
"49345", "Halle\ Saale",
"496645", "Ulrichstein",
"496525", "Irrel",
"499848", "Simmershofen",
"495045", "Springe\-Bennigsen",
"497224", "Gernsbach",
"4936702", "Lauscha",
"498092", "Grafing\ bei\ München",
"4938220", "Wustrow\ Ostseebad",
"4939051", "Calvörde",
"495332", "Schöppenstedt",
"4933933", "Lindow\ Mark",
"492608", "Welschneudorf",
"499498", "Laaber",
"492102", "Ratingen",
"4934292", "Brandis\ bei\ Wurzen",
"492536", "Münster\-Albachten",
"4933674", "Trebatsch",
"497464", "Talheim\ Kreis\ Tuttlingen",
"498678", "Marktl",
"493372", "Jüterbog",
"496873", "Nonnweiler",
"4935605", "Komptendorf",
"497562", "Isny\ im\ Allgäu",
"4936940", "Oepfershausen",
"4933202", "Töplitz",
"497352", "Ochsenhausen",
"4939265", "Löderburg",
"494627", "Dörpstedt",
"498283", "Neuburg\ an\ der\ Kammel",
"495367", "Rühen",
"499285", "Kirchenlamitz",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"494547", "Gudow\ Lauenburg",
"493542", "Lübbenau\ Spreewald",
"492671", "Cochem",
"494484", "Hude\-Wüsting",
"497774", "Eigeltingen",
"498807", "Diessen\ am\ Ammersee",
"492620", "Neuhäusel\ Westerwald",
"498328", "Balderschwang",
"494821", "Itzehoe",
"494922", "Borkum",
"493622", "Waltershausen\ Thüringen",
"496166", "Fischbachtal",
"492431", "Erkelenz",
"493727", "Mittweida",
"496785", "Herrstein",
"499575", "Weismain",
"494722", "Cuxhaven\-Altenbruch",
"497391", "Ehingen\ Donau",
"495422", "Melle",
"497257", "Bruchsal\-Untergrombach",
"498573", "Ering",
"497974", "Bühlerzell",
"492058", "Wülfrath",
"499823", "Leutershausen",
"4935244", "Krögis",
"4934462", "Laucha\ Unstrut",
"498825", "Krün",
"492294", "Morsbach\ Sieg",
"495262", "Extertal",
"494605", "Medelby",
"492639", "Anhausen\ Kreis\ Neuwied",
"494183", "Jesteburg",
"4934441", "Hohenmölsen",
"492256", "Mechernich\-Satzvey",
"4934600", "Ostrau\ Saalkreis",
"4936925", "Marksuhl",
"4934224", "Belgern\ Sachsen",
"498343", "Aitrang",
"498051", "Prien\ am\ Chiemsee",
"49351", "Dresden",
"496507", "Neumagen\-Dhron",
"499345", "Külsheim\ Baden",
"4939975", "Thürkow",
"493996", "Teterow",
"495237", "Augustdorf",
"494272", "Siedenburg",
"495524", "Bad\ Lauterberg\ im\ Harz",
"497163", "Ebersbach\ an\ der\ Fils",
"496044", "Schotten\ Hessen",
"4939058", "Uthmöden",
"495644", "Willebadessen\-Peckelsheim",
"499145", "Solnhofen",
"499241", "Pegnitz",
"499569", "Sesslach",
"49851", "Passau",
"499359", "Karlstadt\-Wiesenfeld",
"499834", "Theilenhofen",
"498143", "Inning\ am\ Ammersee",
"496842", "Blieskastel",
"494778", "Wingst",
"4935893", "Mücka",
"4933976", "Wutike",
"4937463", "Bergen\ Vogtland",
"497363", "Lauchheim",
"497553", "Salem\ Baden",
"499736", "Oberthulba",
"492207", "Kürten\-Dürscheid",
"493573", "Senftenberg",
"4939293", "Dreileben",
"4936781", "Grossbreitenbach",
"497191", "Backnang",
"494468", "Friedeburg\-Reepsholt",
"496594", "Birresborn",
"4933438", "Altlandsberg",
"495768", "Petershagen\-Heimsen",
"495401", "Georgsmarienhütte",
"498727", "Falkenberg\ Niederbayern",
"496556", "Pronsfeld",
"495533", "Bodenwerder",
"497071", "Tübingen",
"499903", "Schöllnach",
"495609", "Ahnatal",
"494383", "Grebin",
"496203", "Ladenburg",
"496681", "Hilders",
"4935796", "Panschwitz\-Kuckau",
"496887", "Schmelz\ Saar",
"492975", "Schmallenberg\-Oberkirchen",
"494336", "Owschlag",
"498507", "Neuburg\ am\ Inn",
"495651", "Eschwege",
"494521", "Eutin",
"4939820", "Triepkendorf",
"493941", "Halberstadt",
"494641", "Süderbrarup",
"4939264", "Kroppenstedt",
"496343", "Bad\ Bergzabern",
"496051", "Gelnhausen",
"496438", "Hünfelden",
"494847", "Oster\-Ohrstedt",
"4936870", "Masserberg",
"495857", "Bleckede\-Brackede",
"4935604", "Krieschow",
"492382", "Ahlen\ Westfalen",
"497961", "Ellwangen\ Jagst",
"497576", "Krauchenwies",
"495586", "Wieda",
"494497", "Barssel\-Harkebrügge",
"495459", "Hörstel",
"492065", "Duisburg\-Rheinhausen",
"499378", "Eichenbühl\-Riedern",
"49221", "Cologne",
"496573", "Gillenfeld",
"494340", "Achterwehr",
"493594", "Bischofswerda",
"492836", "Wachtendonk",
"4938428", "Hohenkirchen\ bei\ Wismar",
"498785", "Rottenburg\-Oberroning",
"498166", "Allershausen\ Oberbayern",
"493366", "Beeskow",
"4933929", "Gühlen\-Glienicke",
"495926", "Engden",
"4933675", "Tauche",
"493681", "Suhl",
"4934928", "Seegrehna",
"494882", "Lunden",
"4939422", "Badersleben",
"497837", "Oberharmersbach",
"4935383", "Elster\ Elbe",
"497631", "Müllheim\ Baden",
"496825", "Illingen\ Saar",
"499548", "Mühlhausen\ Mittelfranken",
"492734", "Freudenberg\ Westfalen",
"497346", "Illerkirchberg",
"499122", "Schwabach",
"499628", "Ursensollen",
"498556", "Haidmühle",
"498366", "Oy\-Mittelberg",
"4936626", "Auma",
"4937327", "Rechenberg\-Bienenmühle",
"496727", "Gensingen",
"497735", "Öhningen",
"4938731", "Lübz",
"494140", "Estorf\ Kreis\ Stade",
"495806", "Barum\ bei\ Bad\ Bevensen",
"492948", "Lippstadt\-Rebbeke",
"492273", "Kerpen\-Horrem",
"497146", "Remseck\ am\ Neckar",
"495704", "Petershagen\-Friedewalde",
"494404", "Elsfleth",
"4938797", "Karstädt\ Kreis\ Prignitz",
"4936451", "Buttelstedt",
"498203", "Grossaitingen",
"4935955", "Pulsnitz",
"498681", "Waging\ am\ See",
"499101", "Langenzenn",
"499205", "Vorbach",
"494502", "Lübeck\-Travemünde",
"4939851", "Göritz\ bei\ Prenzlau",
"4936376", "Straussfurt",
"49651", "Trier",
"492723", "Kirchhundem",
"494136", "Scharnebeck",
"4933847", "Görzke",
"497130", "Löwenstein\ Württemberg",
"494455", "Jade\-Schweiburg",
"499178", "Abenberg\ Mittelfranken",
"499672", "Neunburg\ vorm\ Wald",
"495755", "Kalletal\-Varenholz",
"494745", "Bad\ Bederkesa",
"495445", "Drebber",
"4934632", "Mücheln\ Geiseltal",
"499977", "Arnschwang",
"499254", "Gefrees",
"498380", "Achberg",
"492182", "Grevenbroich\-Kapellen",
"492688", "Kroppach",
"492839", "Straelen\-Herongen",
"494805", "Schafstedt",
"495592", "Gleichen\-Bremke",
"492564", "Vreden",
"492354", "Meinerzhagen",
"497436", "Messstetten\-Oberdigisheim",
"498545", "Hofkirchen\ Bayern",
"49911", "Nuremberg",
"4933609", "Brieskow\-Finkenheerd",
"49234", "Bochum",
"499543", "Hirschaid",
"493721", "Meinersdorf",
"4937464", "Schöneck\ Vogtland",
"4936941", "Wasungen",
"4935894", "Hähnichen",
"496578", "Salmtal",
"492772", "Herborn\ Hessen",
"497251", "Bruchsal",
"4936962", "Vacha",
"498702", "Wörth\ an\ der\ Isar",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"495135", "Burgwedel\-Fuhrberg",
"495231", "Detmold",
"4939294", "Gross\ Rosenburg",
"494854", "Friedrichskoog",
"497440", "Bad\ Rippoldsau",
"495844", "Clenze",
"494339", "Christiansholm",
"492305", "Castrop\-Rauxel",
"499373", "Amorbach",
"4934425", "Droyssig",
"4934783", "Gerbstedt",
"492222", "Bornheim\ Rheinland",
"498375", "Weitnau",
"4938221", "Marlow",
"496348", "Offenbach\ an\ der\ Queich",
"4939050", "Bartensleben",
"495494", "Holdorf\ Niedersachsen",
"492462", "Linnich",
"494794", "Worpswede\-Ostersode",
"496501", "Konz",
"494446", "Bakum\ Kreis\ Vechta",
"495746", "Rödinghausen",
"497579", "Schwenningen\ Baden",
"494756", "Odisheim",
"496433", "Hadamar",
"495456", "Westerkappeln\-Velpe",
"4933745", "Petkus",
"498057", "Aschau\-Sachrang",
"493375", "Königs\ Wusterhausen",
"4936258", "Friemar",
"498271", "Meitingen",
"4939746", "Krackow",
"499173", "Thalmässing",
"4936335", "Grosswechsungen",
"492683", "Asbach\ Westerwald",
"494139", "Hohnstorf\ Elbe",
"495335", "Schladen",
"499093", "Polsingen",
"497304", "Blaustein\ Württemberg",
"498095", "Aying",
"4935243", "Weinböhla",
"495042", "Bad\ Münder\ am\ Deister",
"498460", "Berching\-Holnstein",
"496522", "Mettendorf",
"4933832", "Rogäsen",
"496642", "Schlitz",
"499634", "Wiesau",
"4936071", "Teistungen",
"494925", "Hinte",
"492196", "Wermelskirchen",
"49214", "Leverkusen",
"4934223", "Dommitzsch",
"49931", "Würzburg",
"498369", "Rückholz",
"492154", "Willich",
"496424", "Ebsdorfergrund",
"499282", "Naila",
"496881", "Lebach",
"498208", "Eurasburg\ bei\ Augsburg",
"499964", "Stallwang",
"496264", "Neudenau",
"497355", "Hochdorf\ Riss",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"492943", "Erwitte",
"495407", "Wallenhorst",
"494707", "Langen\-Neuenwalde",
"4938781", "Mellen",
"498721", "Eggenfelden",
"496375", "Wallhalben",
"497967", "Jagstzell",
"4936605", "Bad\ Köstritz",
"499194", "Ebermannstadt",
"4936878", "Oberland",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"494491", "Friesoythe",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"493947", "Thale",
"498433", "Königsmoos",
"496057", "Flörsbachtal",
"499074", "Höchstädt\ an\ der\ Donau",
"498501", "Thyrnau",
"499435", "Schwarzenfeld",
"495657", "Meissner",
"494527", "Bosau",
"495851", "Dahlenburg",
"495952", "Sögel",
"493522", "Grossenhain\ Sachsen",
"494234", "Dörverden",
"492520", "Wadersloh\-Diestedde",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"494942", "Südbrookmerland",
"498348", "Bidingen",
"492571", "Greven\ Westfalen",
"494841", "Husum\ Nordsee",
"496625", "Niederaula",
"497831", "Hausach",
"497932", "Niederstetten\ Württemberg",
"499828", "Rügland",
"496545", "Blankenrath",
"499307", "Altertheim",
"497244", "Weingarten\ Baden",
"495025", "Estorf\ Weser",
"4933362", "Liepe\ Kreis\ Barnim",
"493881", "Grevesmühlen",
"494188", "Welle\ Nordheide",
"494682", "Amrum",
"492508", "Drensteinfurt",
"4939998", "Loitz\ bei\ Demmin",
"4934492", "Lucka",
"49906", "Donauwörth",
"492053", "Velbert\-Neviges",
"4937295", "Lugau\ Erzgebirge",
"4934920", "Kropstädt",
"4936428", "Stadtroda",
"49541", "Osnabrück",
"492636", "Burgbrohl",
"49471", "Bremerhaven",
"4939263", "Unseburg",
"498424", "Nassenfels",
"499908", "Schöfweg",
"499107", "Trautskirchen",
"496559", "Leidenborn",
"496486", "Katzenelnbogen",
"4935022", "Bad\ Schandau",
"4935603", "Burg\ Spreewald",
"4938451", "Hoppenrade\ bei\ Güstrow",
"498687", "Taching\-Tengling",
"494223", "Ganderkesee\-Bookholzberg",
"4936731", "Unterloquitz",
"494463", "Wangerland",
"496721", "Bingen\ am\ Rhein",
"495763", "Uchte",
"493578", "Kamenz",
"492245", "Much",
"4934207", "Zwochau",
"495606", "Zierenberg",
"497558", "Illmensee",
"499566", "Meeder",
"499356", "Burgsinn",
"499971", "Cham",
"499872", "Heilsbronn",
"496220", "Wilhelmsfeld",
"499920", "Bischofsmais",
"499394", "Esselbach",
"496175", "Friedrichsdorf\ Taunus",
"496271", "Eberbach\ Baden",
"498642", "Übersee",
"4935384", "Steinsdorf\ bei\ Jessen",
"4933231", "Pausin",
"495473", "Ostercappeln",
"497483", "Horb\-Mühringen",
"494773", "Lamstedt",
"496095", "Bessenbach",
"493501", "Pirna",
"4938376", "Zirchow",
"495695", "Twistetal",
"493433", "Borna\ Stadt",
"492554", "Laer\ Kreis\ Steinfurt",
"492364", "Haltern\ Westfalen",
"4933333", "Tantow",
"499438", "Fensterbach",
"495874", "Soltendieck",
"493834", "Greifswald",
"4935609", "Drachhausen",
"492596", "Nordkirchen",
"499343", "Lauda\-Königshofen",
"498345", "Stöttwang",
"4939401", "Neuwegersleben",
"49291", "Meschede",
"4936642", "Harra",
"495776", "Preussisch\ Ströhen",
"497629", "Tegernau\ Baden",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"497261", "Sinsheim",
"497165", "Göppingen\-Hohenstaufen",
"4939038", "Henningen",
"492505", "Altenberge\ Westfalen",
"494539", "Westerau",
"496783", "Baumholder",
"495226", "Bruchmühlen\ Westfalen",
"494864", "Oldenswort",
"4933924", "Rägelin",
"4935698", "Hornow",
"499573", "Staffelstein\ Oberfranken",
"498823", "Mittenwald",
"492452", "Heinsberg\ Rheinland",
"496628", "Oberaula",
"496122", "Hofheim\-Wallau",
"499825", "Herrieden",
"492742", "Wissen",
"4937368", "Deutschneudorf",
"4939361", "Lüderitz",
"495028", "Pennigsehl",
"4939342", "Gladau",
"494766", "Basdahl",
"495466", "Merzen",
"498067", "Tuntenhausen",
"494603", "Havetoft",
"496301", "Otterbach\ Pfalz",
"494281", "Zeven",
"494185", "Marxen\ Auetal",
"4939387", "Havelberg",
"4933458", "Falkenberg\ Mark",
"492248", "Hennef\-Uckerath",
"4938296", "Rerik\ Ostseebad",
"495535", "Polle",
"499727", "Schonungen\-Marktsteinach",
"494385", "Hohenfelde\ bei\ Kiel",
"496205", "Hockenheim",
"496101", "Bad\ Vilbel",
"497504", "Horgenzell",
"499905", "Bernried\ Niederbayern",
"4936846", "Suhl\-Dietzhausen",
"49209", "Gelsenkirchen",
"492973", "Eslohe\ Sauerland",
"496322", "Bad\ Dürkheim",
"4938481", "Witzin",
"498450", "Ingolstadt\-Zuchering",
"498145", "Mammendorf",
"498241", "Buchloe",
"497402", "Fluorn\-Winzeln",
"49951", "Bamberg",
"499143", "Pappenheim\ Mittelfranken",
"495192", "Munster",
"492164", "Jüchen\-Otzenrath",
"496254", "Lautertal\ Odenwald",
"497365", "Essingen\ Württemberg",
"4936743", "Teichel",
"497555", "Deggenhausertal",
"4938307", "Poseritz",
"499954", "Simbach\ Niederbayern",
"499277", "Warmensteinach",
"4938355", "Züssow",
"495072", "Neustadt\-Mandelsloh",
"497082", "Neuenbürg\ Württemberg",
"496296", "Ahorn\ Baden",
"496672", "Eiterfeld",
"495284", "Schwalenberg",
"497274", "Germersheim",
"497957", "Kressberg",
"496575", "Landscheid",
"4939200", "Gommern",
"4936202", "Neudietendorf",
"497652", "Hinterzarten",
"497158", "Neuhausen\ auf\ den\ Fildern",
"4938720", "Grebbin",
"499166", "Münchsteinach",
"498783", "Rohr\ in\ Niederbayern",
"494327", "Grossenaspe",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"4934321", "Leisnig",
"4935249", "Basslitz",
"492371", "Iserlohn",
"498548", "Vilshofen\-Sandbach",
"495861", "Dannenberg\ Elbe",
"495962", "Herzlake",
"492994", "Marsberg\-Westheim",
"498628", "Kienberg\ Oberbayern",
"498122", "Erding",
"493322", "Falkensee",
"4936082", "Ershausen",
"496159", "Messel",
"4935341", "Bad\ Liebenwerda",
"492429", "Hürtgenwald",
"496345", "Albersweiler",
"4939080", "Kalbe\ Milde",
"497826", "Schuttertal",
"4933702", "Wünsdorf",
"4935362", "Schönewalde\ bei\ Herzberg",
"495138", "Sehnde",
"495632", "Willingen\ Upland",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"499180", "Pyrbaum",
"492827", "Goch\-Hassum",
"496032", "Bad\ Nauheim",
"492308", "Unna\-Hemmerde",
"497724", "St\ Georgen\ im\ Schwarzwald",
"492621", "Lahnstein",
"498378", "Buchenberg\ bei\ Kempten",
"494871", "Hohenwestedt",
"492541", "Coesfeld",
"492269", "Kierspe\-Rönsahl",
"493672", "Rudolstadt",
"494972", "Langeoog",
"495937", "Geeste\-Gross\ Hesepe",
"4939831", "Feldberg",
"497906", "Braunsbach",
"4938323", "Prohn",
"496834", "Bous",
"492725", "Lennestadt\-Oedingen",
"499842", "Uffenheim",
"499941", "Kötzting",
"496145", "Flörsheim\ am\ Main",
"496241", "Worms",
"496569", "Bickendorf",
"496359", "Grünstadt",
"4933603", "Falkenhagen\ bei\ Seelow",
"494743", "Langen\ bei\ Bremerhaven",
"495443", "Lemförde",
"493378", "Ludwigsfelde",
"498178", "Icking",
"4933766", "Teupitz",
"494453", "Zetel",
"498296", "Villenbach",
"496736", "Bechenheim",
"495753", "Auetal\-Bernsen",
"499492", "Parsberg",
"492602", "Montabaur",
"498254", "Altomünster",
"4934652", "Allstedt",
"499556", "Geiselwind",
"4939927", "Nossentiner\ Hütte",
"499366", "Geroldshausen\ Unterfranken",
"497358", "Eberhardzell\-Füramoos",
"497568", "Bad\ Wurzach\-Hauerz",
"497733", "Engen\ Hegau",
"4938751", "Picher",
"493628", "Arnstadt",
"494928", "Ihlow\-Riepe",
"498322", "Oberstdorf",
"492275", "Kerpen\-Buir",
"492171", "Leverkusen\-Opladen",
"499203", "Neudrossenfeld",
"499681", "Windischeschenbach",
"493301", "Oranienburg",
"498205", "Dasing",
"4935935", "Kleinwelka",
"494127", "Westerhorn",
"4937752", "Eibenstock",
"492303", "Unna",
"492426", "Nörvenich",
"498373", "Altusried",
"497267", "Gemmingen",
"499375", "Freudenberg\ Baden",
"494934", "Marienhafe",
"493634", "Sömmerda",
"495252", "Bad\ Lippspringe",
"494242", "Syke",
"4939030", "Brunau",
"497427", "Schömberg\ bei\ Balingen",
"496074", "Rödermark",
"492266", "Lindlar",
"496435", "Wallmerod",
"497684", "Glottertal",
"495674", "Grebenstein",
"494803", "Pahlen",
"497232", "Königsbach\-Stein",
"499545", "Buttenheim",
"496307", "Schopp",
"498623", "Kirchweidach",
"49331", "Potsdam",
"494287", "Heeslingen\-Boitzen",
"49811", "Hallbergmoos",
"498543", "Aidenbach",
"497944", "Kupferzell",
"499625", "Kastl\ bei\ Amberg",
"498061", "Bad\ Aibling",
"4936744", "Remda",
"4933656", "Bahro",
"493964", "Bredenfelde\ bei\ Strasburg",
"494664", "Neukirchen\ bei\ Niebüll",
"497153", "Plochingen",
"4937360", "Olbernhau",
"495324", "Vienenburg",
"4934741", "Frose",
"4939607", "Kotelow",
"4933334", "Greiffenberg",
"49831", "Kempten\ Allgäu",
"494923", "Krummhörn\-Pewsum",
"493623", "Friedrichroda",
"496107", "Kelsterbach",
"4936481", "Neustadt\ an\ der\ Orla",
"499369", "Uettingen",
"4935267", "Diesbar\-Seusslitz",
"498282", "Krumbach\ Schwaben",
"499208", "Bindlach",
"497353", "Schwendi",
"497041", "Mühlacker",
"497563", "Kisslegg",
"496580", "Zemmer",
"497738", "Steisslingen",
"492945", "Lippstadt\-Benninghausen",
"499721", "Schweinfurt",
"496394", "Bundenthal",
"494458", "Wiefelstede\-Spohle",
"499175", "Spalt",
"499271", "Thurnau\-Alladorf",
"494748", "Stubben\ bei\ Bremerhaven",
"495448", "Barver",
"496872", "Losheim\ am\ See",
"499220", "Kasendorf\-Azendorf",
"496566", "Körperich",
"495333", "Dettum",
"496356", "Carlsberg\ Pfalz",
"492103", "Hilden",
"4937606", "Lengenfeld\ Vogtland",
"4933923", "Flecken\ Zechlin",
"492685", "Flammersfeld",
"498093", "Glonn\ Kreis\ Ebersberg",
"498247", "Bad\ Wörishofen",
"4935389", "Holzdorf\ Elster",
"4939881", "Ringenwalde\ bei\ Templin",
"498634", "Garching\ an\ der\ Alz",
"496543", "Büchenbeuren",
"4939208", "Loitsche",
"4938324", "Velgast",
"496061", "Michelstadt",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"494321", "Neumünster",
"4938728", "Domsühl",
"496623", "Rotenburg\ an\ der\ Fulda",
"494536", "Steinhorst\ Lauenburg",
"495661", "Melsungen",
"49611", "Wiesbaden",
"494608", "Handewitt",
"494102", "Ahrensburg",
"4933604", "Lebus",
"492377", "Wickede\ Ruhr",
"497852", "Willstätt",
"4938202", "Volkenshagen",
"497951", "Crailsheim",
"4939391", "Lückstedt",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"4939722", "Sarnow\ bei\ Anklam",
"492582", "Everswinkel",
"496788", "Sien",
"494769", "Bremervörde\-Iselersheim",
"497376", "Langenenslingen",
"492922", "Werl",
"492821", "Kleve\ Niederrhein",
"493394", "Wittstock\ Dosse",
"498194", "Vilgertshofen",
"496373", "Schönenberg\-Kübelberg",
"492484", "Mechernich\-Eiserfey",
"4939956", "Neukalen",
"4934345", "Bad\ Lausick",
"493971", "Anklam",
"494671", "Bredstedt",
"492547", "Rosendahl\-Osterwick",
"494877", "Hennstedt\ bei\ Itzehoe",
"495832", "Hankensbüttel",
"4939088", "Letzlingen",
"495931", "Meppen",
"492599", "Ascheberg\-Herbern",
"492627", "Braubach",
"499433", "Nabburg",
"498074", "Schnaitsee",
"498435", "Ehekirchen",
"497546", "Oberteuringen",
"497626", "Kandern",
"494479", "Molbergen\-Peheim",
"499348", "Werbach\-Gamburg",
"4936691", "Eisenberg\ Thüringen",
"492802", "Alpen",
"496173", "Kronberg\ im\ Taunus",
"498394", "Lautrach",
"499148", "Ettenstatt",
"499642", "Kemnath\ Stadt",
"496634", "Gemünden\ Felda",
"495475", "Bohmte\-Hunteburg",
"497485", "Empfingen",
"499522", "Eltmann",
"494775", "Grossenwörden",
"495034", "Neustadt\-Hagen",
"496247", "Worms\-Pfeddersheim",
"495693", "Volkmarsen",
"493435", "Oschatz",
"496093", "Laufach",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"4939247", "Güterglück",
"499424", "Strasskirchen",
"496282", "Walldürn",
"494302", "Kirchbarkau",
"49631", "Kaiserslautern",
"493307", "Zehdenick",
"494121", "Elmshorn",
"497054", "Wildberg\ Württemberg",
"495186", "Salzhemmendorf\-Wallensen",
"497176", "Spraitbach",
"492243", "Eitorf",
"4939002", "Oebisfelde",
"494465", "Friedeburg\ Ostfriesland",
"495765", "Raddestorf",
"499264", "Küps",
"4937432", "Pausa\ Vogtland",
"496234", "Mutterstadt",
"499242", "Gössweinstein",
"496841", "Homburg\ Saar",
"4933830", "Ziesar",
"4936021", "Schlotheim",
"496647", "Herbstein\-Stockhausen",
"495293", "Paderborn\-Dahl",
"498756", "Nandlstadt",
"498446", "Pörnbach",
"496527", "Oberweis",
"4935327", "Priessen",
"493585", "Löbau",
"492983", "Winterberg\-Siedlinghausen",
"4933654", "Fünfeichen",
"495504", "Friedland\ Kreis\ Göttingen",
"492643", "Altenahr",
"49671", "Bad\ Kreuznach",
"492523", "Wadersloh",
"4938293", "Kühlungsborn\ Ostseebad",
"497192", "Murrhardt",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"499664", "Hahnbach",
"494702", "Sandstedt",
"497072", "Gomaringen",
"499803", "Colmberg",
"495082", "Langlingen",
"496682", "Tann\ Rhön",
"4933432", "Müncheberg",
"496188", "Kahl\ am\ Main",
"498805", "Hohenpeissenberg",
"495555", "Moringen\-Fredelsloh",
"494625", "Jübek",
"493925", "Stassfurt",
"4936843", "Benshausen",
"4934382", "Nerchau",
"495365", "Wolfsburg\-Neindorf",
"499287", "Selb",
"4934347", "Oelzschau\ bei\ Borna",
"494545", "Seedorf\ Lauenburg",
"494169", "Sauensiek",
"492777", "Breitscheid\ Hessen",
"492432", "Wassenberg",
"4937604", "Mosel",
"4939245", "Loburg",
"497392", "Laupheim",
"494721", "Cuxhaven",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"498707", "Adlkofen",
"494770", "Wischhafen",
"4933201", "Gross\ Glienicke",
"4938379", "Benz\ Usedom",
"494559", "Wensin",
"494486", "Edewecht\-Friedrichsfehn",
"499923", "Teisnach",
"495165", "Rethem\ Aller",
"496223", "Neckargemünd",
"495261", "Lemgo",
"496029", "Mömbris",
"494208", "Grasberg",
"4933398", "Werneuchen",
"498585", "Grainet",
"4938844", "Gülze",
"496773", "Kamp\-Bornhofen",
"4939052", "Erxleben\ bei\ Haldensleben",
"498052", "Aschau\ im\ Chiemgau",
"4933336", "Passow\ Kreis\ Uckermark",
"497226", "Bühl\-Sand",
"4936701", "Lichte",
"4934291", "Borsdorf",
"495379", "Sassenburg\-Grussendorf",
"492534", "Münster\-Roxel",
"497389", "Heroldstatt",
"499748", "Motten",
"497466", "Beuron",
"494175", "Egestorf\ Nordheide",
"494271", "Sulingen",
"4935974", "Hinterhermsdorf",
"4937383", "Lunzenau",
"498139", "Röhrmoos",
"492227", "Bornheim\-Merten",
"496430", "Hahnstätten",
"49871", "Landshut",
"4939954", "Stavenhagen\ Reuterstadt",
"495906", "Lünne",
"499536", "Kirchlauter",
"499321", "Kitzingen",
"4935020", "Struppen",
"498682", "Laufen\ Salzach",
"496805", "Kleinblittersdorf",
"497443", "Dornstetten",
"497753", "Albbruck",
"499102", "Wilhermsdorf",
"499608", "Kohlberg\ Oberpfalz",
"4933606", "Müllrose",
"496446", "Hohenahr",
"494501", "Kastorf\ Holstein",
"4938851", "Zarrentin",
"494433", "Dötlingen",
"495733", "Vlotho",
"496756", "Winterbach\ Soonwald",
"498841", "Murnau\ am\ Staffelsee",
"494348", "Schönkirchen",
"4934638", "Zöschen",
"4938326", "Grimmen",
"493773", "Johanngeorgenstadt",
"498234", "Bobingen",
"495358", "Bahrdorf\-Mackendorf",
"499671", "Oberviechtach",
"496854", "Oberthal\ Saar",
"4933763", "Bestensee",
"492181", "Grevenbroich",
"496339", "Grosssteinhausen",
"499775", "Schönau\ an\ der\ Brend",
"495652", "Bad\ Sooden\-Allendorf",
"495158", "Hemeringen",
"494522", "Plön",
"498773", "Neufahrn\ in\ Niederbayern",
"496052", "Bad\ Orb",
"493841", "Wismar",
"494642", "Kappeln\ Schlei",
"494148", "Drochtersen\-Assel",
"493647", "Pössneck",
"494947", "Aurich\-Ogenbargen",
"4938872", "Rehna",
"492666", "Freilingen\ Westerwald",
"496585", "Ralingen",
"495274", "Nieheim",
"495957", "Lindern\ Oldenburg",
"496139", "Budenheim",
"4935265", "Glaubitz",
"492381", "Hamm\ Westfalen",
"493491", "Lutherstadt\ Wittenberg",
"4936465", "Oberndorf\ bei\ Apolda",
"497962", "Fichtenau",
"497667", "Breisach\ am\ Rhein",
"4939605", "Gross\ Nemerow",
"499465", "Neukirchen\-Balbini",
"4937421", "Oelsnitz\ Vogtland",
"4939428", "Pabstorf",
"498463", "Greding",
"496707", "Windesheim",
"49371", "Chemnitz\ Sachsen",
"4934922", "Mühlanger",
"4939749", "Grambow\ bei\ Pasewalk",
"495826", "Suderburg",
"494264", "Sottrum\ Kreis\ Rotenburg",
"499090", "Rain\ Lech",
"499302", "Rottendorf\ Unterfranken",
"495724", "Obernkirchen",
"492680", "Mündersbach",
"4938422", "Neukloster",
"497937", "Dörzbach",
"493682", "Zella\-Mehlis",
"498388", "Hergensweiler",
"494881", "Friedrichstadt",
"498223", "Ichenhausen",
"499170", "Schwanstetten",
"493987", "Templin",
"497632", "Badenweiler",
"497138", "Schwaigern",
"498029", "Kreuth\ bei\ Tegernsee",
"499225", "Stadtsteinach",
"498272", "Wertingen",
"4933926", "Herzberg\ Mark",
"4937603", "Wildenfels",
"496449", "Ehringshausen\-Katzenfurt",
"492325", "Wanne\-Eickel",
"492202", "Bergisch\ Gladbach",
"498654", "Freilassing",
"4933838", "Päwesin",
"4936252", "Tambach\-Dietharz",
"4935452", "Golssen",
"495563", "Kreiensen",
"497124", "Trochtelfingen\ Hohenz",
"495353", "Königslutter\ am\ Elm",
"496336", "Dellfeld",
"495041", "Springe\ Deister",
"494343", "Laboe",
"496641", "Lauterbach\ Hessen",
"497333", "Laichingen",
"494825", "Burg\ Dithmarschen",
"4938843", "Bennin",
"492675", "Ediger\-Eller",
"499185", "Mühlhausen\ Oberpfalz",
"499281", "Hof\ Saale",
"495909", "Wettrup",
"499603", "Floss",
"497448", "Seewald",
"499766", "Grosswenkheim",
"496340", "Wörth\-Schaidt",
"492843", "Rheinberg",
"4937384", "Wechselburg",
"4935973", "Stolpen",
"498722", "Gangkofen",
"493605", "Leinefelde",
"498383", "Grünenbach\ Allgäu",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"4939329", "Möringen",
"499385", "Kolitzheim",
"495829", "Wriedel",
"496404", "Lich\ Hessen",
"4936968", "Rossdorf\ Rhön",
"4936379", "Holzengel",
"497133", "Lauffen\ am\ Neckar",
"498468", "Altmannstein\-Pondorf",
"493722", "Limbach\-Oberfrohna",
"496084", "Schmitten\ Taunus",
"4933653", "Ziltendorf",
"492771", "Dillenburg",
"495684", "Frielendorf",
"497674", "Todtmoos",
"497252", "Bretten",
"495427", "Melle\-Buer",
"498026", "Hausham",
"494954", "Moormerland",
"4938294", "Neubukow",
"494277", "Schwaförden",
"495232", "Lage\ Lippe",
"4935937", "Prischwitz",
"495944", "Hoogstede",
"496455", "Frankenau\ Hessen",
"496745", "Gondershausen",
"4939221", "Möckern\ bei\ Magdeburg",
"494143", "Drochtersen",
"496136", "Nieder\-Olm",
"495153", "Salzhemmendorf",
"492461", "Jülich",
"49451", "Lübeck",
"497324", "Herbrechtingen",
"4935471", "Birkenhainchen",
"4939925", "Wredenhagen",
"496502", "Schweich",
"4936844", "Rohr\ Thüringen",
"496183", "Erlensee",
"4939451", "Wasserleben",
"492528", "Ennigerloh\-Enniger",
"496722", "Rüdesheim\ am\ Rhein",
"498340", "Baisweil",
"4935028", "Krippen",
"494166", "Ahlerstedt",
"497475", "Burladingen",
"495485", "Ladbergen",
"497034", "Ehningen",
"496654", "Gersfeld\ Rhön",
"494180", "Königsmoor",
"499677", "Oberviechtach\-Pullenried",
"495054", "Bergen\-Sülze",
"496696", "Gilserberg",
"499972", "Waldmünchen",
"499871", "Windsbach",
"493745", "Falkenstein\ Vogtland",
"496272", "Hirschhorn\ Neckar",
"499820", "Lehrberg",
"498641", "Grassau\ Kreis\ Traunstein",
"498336", "Erkheim",
"495176", "Edemissen",
"498847", "Obersöchering",
"497765", "Rickenbach\ Hotzenwald",
"499453", "Thalmassing",
"498745", "Bodenkirchen",
"492387", "Drensteinfurt\-Walstedde",
"497023", "Weilheim\ an\ der\ Teck",
"497229", "Iffezheim",
"4939953", "Schwinkendorf",
"497661", "Kirchzarten",
"492764", "Welschen\ Ennest",
"494492", "Saterland",
"4938828", "Schönberg",
"492866", "Dorsten\-Rhade",
"493847", "Sternberg",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"4934261", "Kühren\ bei\ Wurzen",
"497386", "Hayingen",
"498502", "Fürstenzell",
"498136", "Markt\ Indersdorf",
"495852", "Bleckede",
"4934242", "Hohenpriessnitz",
"495951", "Werlte",
"493521", "Meissen",
"494941", "Aurich",
"493641", "Jena",
"494842", "Nordstrand",
"492572", "Emsdetten",
"4939822", "Kratzeburg",
"497832", "Haslach\ im\ Kinzigtal",
"496228", "Schönau\ Odenwald",
"497931", "Bad\ Mergentheim",
"4934978", "Radegast\ Kreis\ Köthen",
"4934498", "Rositz",
"498404", "Oberdolling",
"499928", "Kirchdorf\ im\ Wald",
"4939992", "Görmin",
"499127", "Rosstal\ Mittelfranken",
"4938305", "Gingst",
"493981", "Neustrelitz",
"494681", "Wyk\ auf\ Föhr",
"494203", "Weyhe\ bei\ Bremen",
"4936422", "Reinstädt\ Thüringen",
"496383", "Glan\-Münchweiler",
"492474", "Nideggen\-Schmidt",
"495546", "Scheden",
"496701", "Sprendlingen\ Rheinhessen",
"496026", "Grossostheim",
"494366", "Grömitz\-Cismar",
"495626", "Bad\ Zwesten",
"494556", "Ahrensbök\-Gnissau",
"494489", "Apen",
"4933979", "Wusterhausen\ Dosse",
"4933368", "Hohensaaten",
"4933764", "Mittenwalde\ Mark",
"496468", "Dautphetal\-Mornshausen",
"498084", "Taufkirchen\ Vils",
"492525", "Beckum\-Neubeckum",
"495206", "Bielefeld\-Jöllenbeck",
"492645", "Vettelschoss",
"4939959", "Dargun",
"498664", "Chieming",
"4939296", "Welsleben",
"497478", "Hirrlingen",
"4933452", "Neulewin",
"498803", "Peissenberg",
"496102", "Neu\-Isenburg",
"499805", "Burgoberbach",
"4935793", "Elstra",
"4936607", "Niederpöllnitz",
"492873", "Isselburg\-Werth",
"494543", "Nusse",
"496536", "Kleinich",
"493923", "Zerbst",
"495553", "Kalefeld",
"494623", "Böklund",
"4939481", "Hedersleben\ bei\ Aschersleben",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"495363", "Wolfsburg\-Vorsfelde",
"4934363", "Cavertitz",
"496479", "Waldbrunn\ Westerwald",
"4937297", "Thum\ Sachsen",
"497533", "Allensbach",
"493583", "Zittau",
"499446", "Altmannstein",
"495295", "Lichtenau\ Westfalen",
"4938232", "Zingst\ Ostseebad",
"495191", "Soltau",
"499339", "Ippesheim",
"499854", "Wittelshofen",
"4935752", "Ruhland",
"492985", "Winterberg\-Niedersfeld",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"495071", "Schwarmstedt",
"496620", "Philippsthal\ Werra",
"497081", "Bad\ Wildbad",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"497422", "Schramberg",
"494247", "Affinghausen",
"4934901", "Rosslau\ Elbe",
"495257", "Hövelhof",
"498583", "Neureichenau",
"4936648", "Dittersdorf\ bei\ Schleiz",
"494634", "Husby",
"496775", "Strüth\ Taunus",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"4934205", "Markranstädt",
"494173", "Wulfsen",
"498458", "Gaimersheim",
"49281", "Wesel",
"4935771", "Bad\ Muskau",
"498031", "Rosenheim\ Oberbayern",
"497262", "Eppingen",
"4937362", "Seiffen\ Erzgebirge",
"494964", "Rhede\ Ems",
"4939348", "Klitsche",
"4937341", "Ehrenfriedersdorf",
"4939744", "Rothenklempenow",
"496465", "Breidenbach\ bei\ Biedenkopf",
"492236", "Wesseling\ Rheinland",
"495163", "Fallingbostel\-Dorfmark",
"492451", "Geilenkirchen",
"49431", "Kiel",
"497524", "Bad\ Waldsee",
"497644", "Kenzingen",
"492741", "Betzdorf",
"499925", "Bayerisch\ Eisenstein",
"496302", "Winnweiler",
"494282", "Sittensen",
"4935692", "Kerkwitz",
"497237", "Neulingen\ Enzkreis",
"499527", "Knetzgau",
"497150", "Korntal\-Münchingen",
"492409", "Stolberg\-Gressenich",
"494435", "Grossenkneten",
"499647", "Kirchenthumbach",
"4939323", "Schönhausen\ Elbe",
"497806", "Bad\ Peterstal\-Griesbach",
"499841", "Bad\ Windsheim",
"4936373", "Buttstädt",
"499942", "Viechtach",
"499234", "Neusorg",
"4934658", "Hayn\ Harz",
"496242", "Osthofen",
"498671", "Altötting",
"494194", "Sievershütten",
"495146", "Wietze",
"497704", "Geisingen\ Baden",
"499491", "Hemau",
"492601", "Nauort",
"494156", "Talkau",
"4937430", "Eichigt",
"495064", "Gross\ Düngen",
"4933747", "Marzahna",
"496664", "Sinntal\-Sterbfritz",
"49971", "Bad\ Kissingen",
"4939000", "Beetzendorf",
"4939934", "Gross\ Plasten",
"4936623", "Berga\ Elster",
"4939751", "Penkun",
"496287", "Limbach\ Baden",
"494307", "Raisdorf",
"498536", "Kösslarn",
"494828", "Lägerdorf",
"498321", "Sonthofen",
"492678", "Büchel\ bei\ Cochem",
"498370", "Wiggensbach",
"499188", "Postbauer\-Heng",
"499682", "Erbendorf",
"497755", "Weilheim\ Kreis\ Waldshut",
"495130", "Wedemark",
"496803", "Mandelbachtal\-Ommersheim",
"493302", "Hennigsdorf",
"497445", "Pfalzgrafenweiler",
"498102", "Höhenkirchen\-Siegertsbrunn",
"4937609", "Wolkenburg\ Mulde",
"492587", "Ennigerloh\-Westkirchen",
"498465", "Kipfenberg",
"4939772", "Rothemühl",
"499463", "Wald\ Oberpfalz",
"497651", "Titisee\-Neustadt",
"492754", "Bad\ Laasphe\-Feudingen",
"492444", "Schleiden\-Gemünd",
"498302", "Görisried",
"4936337", "Schiedungen",
"497586", "Herbertingen",
"497459", "Nagold\-Hochdorf",
"4938374", "Lassan\ bei\ Wolgast",
"492856", "Hamminkeln\-Brünen",
"499223", "Rugendorf",
"498170", "Strasslach\-Dingharting",
"4936208", "Ermstedt",
"4935386", "Prettin",
"492372", "Hemer",
"498121", "Markt\ Schwaben",
"498225", "Jettingen\-Scheppach",
"493321", "Nauen\ Brandenburg",
"495862", "Hitzacker\ Elbe",
"494107", "Siek\ Kreis\ Stormarn",
"495961", "Haselünne",
"499773", "Unsleben",
"495439", "Bersenbrück",
"496583", "Palzem",
"494356", "Gross\ Wittensee",
"493877", "Wittenberge",
"495631", "Korbach",
"492927", "Neuengeseke",
"495346", "Liebenburg",
"496031", "Friedberg\ Hessen",
"496458", "Rosenthal\ Hessen",
"492622", "Bendorf\ am\ Rhein",
"4933708", "Rangsdorf",
"494920", "Wirdum",
"494394", "Bokhorst",
"495837", "Sprakensehl",
"494872", "Hanerau\-Hademarschen",
"492542", "Gescher",
"493671", "Saalfeld\ Saale",
"494971", "Esens",
"492673", "Ellenz\-Poltersdorf",
"497335", "Wiesensteig",
"494823", "Wilster",
"498281", "Thannhausen\ Schwaben",
"493385", "Rathenow",
"496327", "Neustadt\-Lachen",
"499183", "Burgthann",
"499605", "Weiherhammer",
"498766", "Gammelsdorf",
"497042", "Vaihingen\ an\ der\ Enz",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"492845", "Neukirchen\-Vluyn",
"499722", "Werneck",
"495304", "Meine",
"499272", "Fichtelberg",
"492323", "Herne",
"492406", "Herzogenrath",
"496871", "Wadern",
"496677", "Neuenstein\ Hessen",
"4939743", "Zerrenthin",
"4933677", "Glienicke\ bei\ Beeskow",
"499654", "Pleystein",
"4935246", "Ziegenhain\ Sachsen",
"494159", "Basthorst",
"495197", "Soltau\-Frielingen",
"495149", "Wienhausen",
"495565", "Einbeck\-Wenzen",
"495355", "Frellstedt",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"496743", "Bacharach",
"4935201", "Langebrück",
"494736", "Butjadingen\-Tossens",
"49261", "Koblenz\ am\ Rhein",
"496453", "Gemünden\ Wohra",
"495436", "Nortrup",
"4936640", "Remptendorf",
"495155", "Emmerthal",
"499778", "Fladungen",
"495251", "Paderborn",
"494834", "Büsum",
"494241", "Bassum",
"496588", "Pluwig",
"4934775", "Wippra",
"4937325", "Niederbobritzsch",
"492747", "Molzhain",
"499383", "Wiesentheid",
"496127", "Niedernhausen\ Taunus",
"4934364", "Wermsdorf",
"493603", "Bad\ Langensalza",
"494903", "Wymeer",
"498385", "Hergatz",
"497231", "Pforzheim",
"497135", "Brackenheim",
"499228", "Thurnau",
"498062", "Bruckmühl\ Mangfall",
"497844", "Rheinau",
"494740", "Loxstedt\-Dedesdorf",
"4933633", "Spreenhagen",
"499468", "Zell\ Oberpfalz",
"492859", "Wesel\-Bislich",
"497746", "Wutöschingen",
"4933845", "Borkheide",
"492334", "Hagen\-Hohenlimburg",
"497456", "Haiterbach",
"4933769", "Töpchin",
"4933974", "Dessow",
"499701", "Sandberg\ Unterfranken",
"492801", "Xanten",
"492902", "Warstein",
"496476", "Mengerskirchen",
"498677", "Burghausen\ Salzach",
"492607", "Kobern\-Gondorf",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"499641", "Grafenwöhr",
"4938373", "Katzow",
"499521", "Hassfurt",
"499336", "Bütthard",
"497763", "Murg",
"499847", "Ergersheim",
"493588", "Niesky",
"4939008", "Kunrau",
"495209", "Gütersloh\-Friedrichsdorf",
"496766", "Kisselbach",
"496281", "Buchen\ Odenwald",
"496185", "Hammersbach\ Hessen",
"498808", "Pähl",
"4935606", "Briesen\ bei\ Cottbus",
"498327", "Rettenberg",
"494122", "Uetersen",
"493928", "Schönebeck\ Elbe",
"4937438", "Bad\ Brambach",
"495368", "Parsau",
"4939266", "Förderstedt",
"4939977", "Jördenstorf",
"499340", "Königheim\-Brehmen",
"497473", "Mössingen",
"495483", "Lienen",
"4936927", "Unterellen",
"496864", "Mettlach",
"496062", "Erbach\ Odenwald",
"4939324", "Kläden\ bei\ Stendal",
"4938208", "Kavelstorf",
"499404", "Nittendorf",
"495662", "Felsberg\ Hessen",
"492694", "Wershofen",
"495168", "Walsrode\-Stellichte",
"494322", "Bordesholm",
"4939728", "Medow\ bei\ Anklam",
"493327", "Werder\ Havel",
"494101", "Pinneberg",
"494205", "Ottersberg",
"496385", "Reichenbach\-Steegen",
"4936374", "Weissensee",
"492656", "Virneburg",
"4936200", "Elxleben\ bei\ Arnstadt",
"4938391", "Altenkirchen\ Rügen",
"497851", "Kehl",
"4939202", "Gross\ Ammensleben",
"497952", "Gerabronn",
"492581", "Warendorf",
"4938722", "Raduhn",
"497657", "Eisenbach\ Hochschwarzwald",
"499084", "Bissingen\ Schwaben",
"494296", "Schwanewede\-Aschwarden",
"498453", "Reichertshofen\ Oberbayern",
"492921", "Soest",
"492822", "Emmerich",
"499745", "Wildflecken",
"494672", "Langenhorn",
"494178", "Radbruch",
"493871", "Parchim",
"498743", "Geisenhausen",
"495831", "Wittingen",
"495932", "Haren\ Ems",
"494977", "Blomberg\ Ostfriesland",
"493677", "Ilmenau\ Thüringen",
"494254", "Eystrup",
"495244", "Rietberg",
"4936624", "Teichwolframsdorf",
"497025", "Neuffen",
"4939933", "Vollrathsruhe",
"49741", "Rottweil",
"499502", "Frensdorf",
"4933051", "Nassenheide",
"4939082", "Mieste",
"4936849", "Kleinschmalkalden",};
$areanames{de} = {"496321", "Neustadt\ an\ der\ Weinstraße",
"4934901", "Roßlau\ Elbe",
"4939934", "Groß\ Plasten",
"495064", "Groß\ Düngen",
"498536", "Kößlarn",
"498170", "Straßlach\-Dingharting",
"499242", "Gößweinstein",
"493647", "Pößneck",
"49911", "Nürnberg",
"497355", "Hochdorf\ Riß",
"49221", "Köln",
"494497", "Barßel\-Harkebrügge",
"498807", "Dießen\ am\ Ammersee",
"492339", "Sprockhövel\-Haßlinghausen",
"4989", "München",
"499656", "Moosbach\ bei\ Vohenstrauß",
"497162", "Süßen",
"497351", "Biberach\ an\ der\ Riß",
"496364", "Nußbach\ Pfalz",
"499141", "Weißenburg\ in\ Bayern",
"4936072", "Weißenborn\-Lüderode",
"499636", "Plößberg",
"492203", "Köln\-Porz",
"495384", "Seesen\-Groß\ Rhüden",
"4939976", "Groß\ Bützin",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"4935841", "Großschönau\ Sachsen",
"4934493", "Gößnitz\ Thüringen",
"4935240", "Tauscha\ bei\ Großenhain",
"4935248", "Schönfeld\ bei\ Großenhain",
"494684", "Langeneß\ Hallig",
"4934445", "Stößen",
"4935753", "Großräschen",
"496252", "Heppenheim\ Bergstraße",
"4938234", "Born\ Darß",
"494483", "Ovelgönne\-Großenmeer",
"4939883", "Groß\ Dölln",
"4935938", "Großpostwitz\ OL",
"4936949", "Obermaßfeld\-Grimmenthal",
"4936484", "Knau\ bei\ Pößneck",
"498367", "Roßhaupten\ Forggensee",
"498633", "Tüßling",
"499567", "Seßlach\-Gemünda",
"495053", "Faßberg\-Müden",
"494509", "Groß\ Grönau",
"4935726", "Groß\ Särchen",
"4935952", "Großröhrsdorf\ OL",
"496663", "Steinau\ an\ der\ Straße",
"495827", "Unterlüß",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;