
use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME           => 'Amazon::API',
    AUTHOR         => 'Rob Lauer <rlauer6@comcast.net>',
    VERSION_FROM   => 'lib/Amazon/API.pm',
    ABSTRACT       => 'AWS API base class',
    LICENSE        => 'perl',
    PL_FILES       => {},
    EXE_FILES      =>     []
,
    PREREQ_PM      => {
      'AWS::Signature4' => '1.02',
      'Amazon::Credentials' => '1.0.14',
      'Class::Accessor' => '0.34',
      'Class::Accessor::Fast' => '0.34',
      'HTTP::Request' => '6.36',
      'JSON::PP' => '4.06',
      'LWP::UserAgent' => '6.61',
      'Scalar::Util' => '1.60',
      'XML::LibXML::Simple' => '1.01'
    },
    TEST_REQUIRES  =>     {}
,
    META_MERGE =>     {
      "meta-spec"=>{
                       "version"=>2
                     },
      "provides"=>{
                      "Amazon::API"=>{
                                         "file"=>"lib/Amazon/API.pm",
                                         "version"=>"1.1.11"
                                       },
                      "Amazon::API::Error"=>{
                                                "file"=>"lib/Amazon/API/Error.pm",
                                                "version"=>"1.1.11"
                                              },
                      "Amazon::API::Signature4"=>{
                                                     "file"=>"lib/Amazon/API/Signature4.pm",
                                                     "version"=>"1.1.11"
                                                   }
                    }
    }

);
