BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Carp Data::Dumper File::Spec FindBin JSON::PP List::Util strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.014; 1}) {
    print "Perl 5.014 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.36.
use strict;
use warnings;
use 5.014;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Use Alien::Build with Dist::Zilla",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"         => "Dist-Zilla-Plugin-AlienBuild",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.014",
  "NAME"             => "Dist::Zilla::Plugin::AlienBuild",
  "PM"               => {
    "lib/Dist/Zilla/Plugin/AlienBase/Doc.pm"            => "\$(INST_LIB)/Dist/Zilla/Plugin/AlienBase/Doc.pm",
    "lib/Dist/Zilla/Plugin/AlienBase/Wrapper.pm"        => "\$(INST_LIB)/Dist/Zilla/Plugin/AlienBase/Wrapper.pm",
    "lib/Dist/Zilla/Plugin/AlienBase/Wrapper/Bundle.pm" => "\$(INST_LIB)/Dist/Zilla/Plugin/AlienBase/Wrapper/Bundle.pm",
    "lib/Dist/Zilla/Plugin/AlienBuild.pm"               => "\$(INST_LIB)/Dist/Zilla/Plugin/AlienBuild.pm"
  },
  "PREREQ_PM" => {
    "Alien::Base::Wrapper"      => "1.28",
    "Alien::Build"              => "1.28",
    "Capture::Tiny"             => 0,
    "Data::Section"             => "0.004",
    "Dist::Zilla"               => "6.000",
    "Moose"                     => 0,
    "Path::Tiny"                => 0,
    "Sub::Exporter::ForMethods" => 0
  },
  "TEST_REQUIRES" => {
    "Alien::Base::Wrapper" => "1.28",
    "JSON::MaybeXS"        => 0,
    "Test2::Mock"          => "0.000060",
    "Test2::V0"            => "0.000060",
    "YAML"                 => 0
  },
  "VERSION" => "0.29",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Alien::Base::Wrapper"      => "1.28",
  "Alien::Build"              => "1.28",
  "Capture::Tiny"             => 0,
  "Data::Section"             => "0.004",
  "Dist::Zilla"               => "6.000",
  "JSON::MaybeXS"             => 0,
  "Moose"                     => 0,
  "Path::Tiny"                => 0,
  "Sub::Exporter::ForMethods" => 0,
  "Test2::Mock"               => "0.000060",
  "Test2::V0"                 => "0.000060",
  "YAML"                      => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);