#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Metrics::Any '$metrics';
use Metrics::Any::Adapter 'Test';

# Force the adapter to exist
$metrics->adapter;

# unlabelled
{
   Metrics::Any::Adapter::Test->clear;

   $metrics->make_counter( abc => name => "the_ABC_counter" );
   $metrics->make_counter( def => name => "the_DEF_counter" );

   $metrics->inc_counter( 'abc' );

   $metrics->inc_counter( 'def' );
   $metrics->inc_counter( 'def' );
   $metrics->inc_counter( 'def' );

   is( Metrics::Any::Adapter::Test->metrics,
      "the_ABC_counter = 1\n" .
      "the_DEF_counter = 3\n",
      'Metrics::Any::Adapter::Test->metrics for basic metrics'
   );
}

# with labels
{
   Metrics::Any::Adapter::Test->clear;

   $metrics->make_counter( ghi =>
      name   => "the_GHI_counter",
      labels => [qw( label )],
   );
   $metrics->make_counter( jkl =>
      name   => "the_JKL_counter",
      labels => [qw( x y )],
   );

   $metrics->inc_counter( ghi => "value" );
   $metrics->inc_counter( jkl => 10, 20 );

   is( Metrics::Any::Adapter::Test->metrics,
      "the_GHI_counter label:value = 1\n" .
      "the_JKL_counter x:10 y:20 = 1\n",
      'Metrics::Any::Adapter::Test->metrics after increment with label'
   );
}

done_testing;
