package Firewall::Policy::Designer;

# ABSTRACT: turns baubles into trinkets

#------------------------------------------------------------------------------
# 加载系统模块，辅助构造函数功能和属性
#------------------------------------------------------------------------------
use Moose;
use namespace::autoclean;
no warnings 'uninitialized';
use Try::Tiny;
use Time::HiRes;

#------------------------------------------------------------------------------
# 加载项目模块
#------------------------------------------------------------------------------
use Firewall::Policy::Searcher::Report;

has dbi => (is => 'ro', does => 'Firewall::DBI::Role', required => 1,);

has searcherReport => (is => 'ro', isa => 'Firewall::Policy::Searcher::Report', required => 1,);

has designerReport => (is => 'ro', isa => 'ArrayRef[HashRef[Ref]]', default => sub { [] },);

sub getPolicyState {
  my ($self, $type, $exist) = @_;
  my %map = ('ignore' => 'allExist', 'modify' => 'partExist', 'new' => 'nonExist');
  confess "ERROR: $type correlative policyState dose not exsit.\n" unless (defined $map{$type});
  my $result = $map{$type};
  if ($type eq 'modify' and not defined $exist) {
    $result = 'nonExist';
  }
  return $result;
}

sub design {
  my $self = shift;
  my %index;
  for my $searcherReportFwInfo (@{$self->{"searcherReport"}{"FwInfos"}}) {
    my $fwId           = $searcherReportFwInfo->{"fwId"};
    my $fwType         = ucfirst lc $searcherReportFwInfo->{"fwType"};
    my $fwName         = $searcherReportFwInfo->{"fwName"};
    my $policyState    = $self->getPolicyState($searcherReportFwInfo->type, $searcherReportFwInfo->exist);
    my $newCommandInfo = $self->getNewCommandInfo($fwType, $searcherReportFwInfo);
    if ($policyState eq 'allExist' and $newCommandInfo->{"content"} ne '') {
      $policyState = 'partExist';
    }
    my $existCommandInfo = {};
    if (defined $searcherReportFwInfo->{"exist"}) {
      @{$existCommandInfo}{/ src dst srv /} = @{$searcherReportFwInfo->{"exist"}}{/ src dst srv /};
      $existCommandInfo->{"content"} = $searcherReportFwInfo->{"ruleObj"}{"content"} . "\n";
    }
    if (not defined $index{$fwId}) {
      push @{$self->{"designerReport"}},
        {
        "fwId"           => $fwId,
        "fwName"         => $fwName,
        "fwType"         => $fwType,
        "policyState"    => $policyState,
        "policyContents" => [{
          "src"   => $searcherReportFwInfo->{"srcMap"},
          "dst"   => $searcherReportFwInfo->{"dstMap"},
          "srv"   => $searcherReportFwInfo->{"srvMap"},
          "new"   => $newCommandInfo,
          "exist" => $existCommandInfo,
        }]
        };
      $index{$fwId} = @{$self->designerReport} - 1;
    }
    else {

      #将ASA分散的设计再组合起来
      if (
        (
          $self->designerReport->[$index{$fwId}]{"policyState"} eq 'allExist'
          and ($policyState eq 'nonExist' or $policyState eq 'partExist')
        )
        or (
          (
               $self->designerReport->[$index{$fwId}]{"policyState"} eq 'nonExist'
            or $self->designerReport->[$index{$fwId}]{"policyState"} eq 'partExist'
          )
          and $policyState eq 'allExist'
        )
        )
      {
        $self->designerReport->[$index{$fwId}]->{policyState} = 'partExist';
      }
      for (keys %{$searcherReportFwInfo->srcMap}) {
        $self->designerReport->[$index{$fwId}]->{policyContents}->[0]->{src}{$_} = $searcherReportFwInfo->srcMap->{$_};
      }
      for (keys %{$searcherReportFwInfo->dstMap}) {
        $self->designerReport->[$index{$fwId}]->{policyContents}->[0]->{dst}{$_} = $searcherReportFwInfo->dstMap->{$_};
      }
      for (keys %{$searcherReportFwInfo->srvMap}) {
        $self->designerReport->[$index{$fwId}]->{policyContents}->[0]->{srv}{$_} = $searcherReportFwInfo->srvMap->{$_};
      }
      $self->designerReport->[$index{$fwId}]->{policyContents}->[0]->{'new'}{content} .= $newCommandInfo->{content};
      my $newString = $self->designerReport->[$index{$fwId}]->{policyContents}->[0]->{exist}{content};
      $newString = '' unless (defined $newString);
      if (defined $existCommandInfo->{content} and $newString !~ /\Q$existCommandInfo->{content}\E/) {
        $self->designerReport->[$index{$fwId}]->{policyContents}->[0]->{exist}{content} .= $existCommandInfo->{content};
      }
    }
  }
  return $self->designerReport;
}

sub getNewCommandInfo {
  my ($self, $fwType, $searcherReportFwInfo) = @_;
  my $info;
  my $className = __PACKAGE__ . "::$fwType";
  my $metaDesigner;

  #eval "use $className";
  #eval "\$metaDesigner = $className->new(searcherReportFwInfo=>\$searcherReportFwInfo, dbi=>\$self->dbi)";
  use Firewall::Policy::Designer::Huawei;
  $metaDesigner = Firewall::Policy::Designer::Huawei->new(searcherReportFwInfo => $searcherReportFwInfo, dbi => $self->dbi);
  confess $@ if $@;
  $info->{"content"} = $metaDesigner->design;

  if ($searcherReportFwInfo->type ne 'ignore') {
    for my $act (keys %{$searcherReportFwInfo->action}) {
      for my $type (qw/ src dst srv /) {
        if (defined $searcherReportFwInfo->action->{$act}{$type}) {
          $info->{$type} = join(',', keys %{$searcherReportFwInfo->action->{$act}{$type}});
        }
        else {
          my $attr = $type . 'Map';
          $info->{$type} = join(',', keys %{$searcherReportFwInfo->$attr});
        }
      }
    }
  }
  return $info;
}

__PACKAGE__->meta->make_immutable;
1;
