package WordList::PersonName::Bible::EN;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-01'; # DATE
our $DIST = 'WordList-PersonName-Bible-EN'; # DIST
our $VERSION = '0.001'; # VERSION

use WordList;
our @ISA = qw(WordList);

our %STATS = ("num_words",1998,"num_words_contains_nonword_chars",59,"shortest_word_len",2,"num_words_contains_whitespace",3,"longest_word_len",23,"avg_word_len",6.47347347347347,"num_words_contains_unicode",0); # STATS

1;
# ABSTRACT: All men mentioned in the bible

=pod

=encoding UTF-8

=head1 NAME

WordList::PersonName::Bible::EN - All men mentioned in the bible

=head1 VERSION

This document describes version 0.001 of WordList::PersonName::Bible::EN (from Perl distribution WordList-PersonName-Bible-EN), released on 2020-05-01.

=head1 SYNOPSIS

 use WordList::PersonName::Bible::EN;

 my $wl = WordList::PersonName::Bible::EN->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 STATISTICS

 +----------------------------------+------------------+
 | key                              | value            |
 +----------------------------------+------------------+
 | avg_word_len                     | 6.47347347347347 |
 | longest_word_len                 | 23               |
 | num_words                        | 1998             |
 | num_words_contains_nonword_chars | 59               |
 | num_words_contains_unicode       | 0                |
 | num_words_contains_whitespace    | 3                |
 | shortest_word_len                | 2                |
 +----------------------------------+------------------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-PersonName-Bible-EN>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-PersonName-Bible-EN>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-PersonName-Bible-EN>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

Sources:

L<https://www.biblegateway.com/resources/all-men-bible/Alphabetical-Order-All-Men>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Aaron
Abagtha
Abda
Abdeel
Abdi
Abdiel
Abdon
Abednego
Abel
Abia
Abiah
Abialbon
Abiasaph
Abiathar
Abida
Abidah
Abidan
Abiel
Abiezer
Abigibeon
Abihail
Abihu
Abihud
Abijah
Abijam
Abimael
Abimelech
Abinadab
Abiner
Abinoam
Abiram
Abishai
Abishalom
Abishua
Abishur
Abitub
Abiud
Abner
Abraham
Abram
Absalom
Abshai
Achaicus
Achan
Achar
Achbor
Achim
Achish
Achor
Adaiah
Adalia
Adam
Adar
Adbeel
Addar
Addi
Ader
Adiel
Adin
Adina
Adino
Adlai
Admatha
Adna
Adnah
Adoni-Bezek
Adoni-Zedec
Adoni-Zedek
Adonijah
Adonikam
Adoniram
Adoram
Adrammelech
Adriel
Aeneas
Agabus
Agag
Agee
Agrippa
Agur
Ahab
Aharah
Aharhel
Ahasai
Ahasbai
Ahasuerus
Ahaz
Ahaziah
Ahban
Aher
Ahi
Ahiah
Ahiam
Ahian
Ahiezer
Ahihud
Ahijah
Ahikam
Ahilud
Ahimaaz
Ahiman
Ahimelech
Ahimoth
Ahinadab
Ahio
Ahira
Ahiram
Ahisamach
Ahishahar
Ahishar
Ahithophel
Ahitub
Ahoah
Aholiab
Ahumai
Ahuzam
Ahuzzath
Ahzai
Aiah
Ajah
Akan
Akkub
Alameth
Alemeth
Alexander
Aliah
Alian
Allon
Almodad
Alphaeus
Alvah
Alvan
Amal
Amalek
Amariah
Amasa
Amasai
Amashai
Amasiah
Amaziah
Ami
Amiel
Aminadab
Amittai
Ammihud
Ammihur
Amminadab
Amminadib
Ammishaddai
Ammizabad
Ammon
Amnon
Amok
Amon
Amos
Amoz
Amplias
Ampliatus
Amram
Amraphel
Amzi
Anah
Anaiah
Anak
Anan
Anani
Ananiah
Ananias
Anath
Anathoth
Andrew
Andronicus
Aner
Aniam
Annas
Antipas
Antothijah
Anub
Apelles
Aphiah
Aphses
Apollos
Appaim
Aquila
Ara
Arad
Arah
Aram
Aran
Araunah
Arba
Archelaus
Archippus
Ard
Ardon
Areli
Aretas
Argob
Aridai
Aridatha
Arieh
Ariel
Arioch
Arisai
Aristarchus
Aristobulus
Armoni
Arnan
Arni
Arod
Arpachshad
Arphaxad
Artaxerxes
Artemas
Arza
Asa
Asahel
Asahiah
Asaiah
Asaph
Asareel
Asarel
Asarelah
Asharelah
Ashbea
Ashbel
Ashchenaz
Asher
Ashkenaz
Ashpenaz
Ashriel
Ashur
Ashvath
Asiel
Asnah
Asnapper
Aspatha
Asriel
Asshur
Asshurim
Assir
Assur
Asyncritus
Ater
Athaiah
Athaliah
Athlai
Attai
Augustus
Azal
Azaliah
Azaniah
Azarael
Azareel
Azariah
Azaz
Azaziah
Azbuk
Azel
Azgad
Aziel
Aziza
Azmaveth
Azor
Azriel
Azrikam
Azur
Azzan
Azzur
Baal
Baal-Hanan
Baalis
Baana
Baanah
Baaseiah
Baasha
Bakbakkar
Bakbuk
Bakbukiah
Balaam
Balac
Baladan
Balak
Bani
Bar-Jesus
Bar-Jona
Barabbas
Barachel
Barak
Bariah
Barkos
Barnabas
Barsabas
Barsabbas
Bartholomew
Bartimaeus
Baruch
Barzillai
Bashan-Havoth-Jair
Bavai
Bavvai
Bazlith
Bazluth
Bealiah
Bebai
Becher
Bechorath
Bedad
Bedan
Bedeiah
Beeliada
Beera
Beerah
Beeri
Bela
Belah
Belshazzar
Belteshazzar
Ben-Ammi
Ben-Dekar
Ben-Geber
Ben-Hadad
Ben-Hail
Ben-Hanan
Ben-Hesed
Ben-Hur
Ben-Oni
Ben-Zoheth
Benaiah
Beninu
Benjamin
Beno
Beor
Bera
Berachah
Berachiah
Beraiah
Berechiah
Bered
Beri
Beriah
Berodach-Baladan
Besai
Besodeiah
Beth Rapha
Beth-Gader
Beth-Zur
Bethlehem
Bethuel
Bezai
Bezaleel
Bezer
Bichri
Bidkar
Bigtha
Bigthan
Bigthana
Bigvai
Bildad
Bilgah
Bilgai
Bilhan
Bilshan
Bimhal
Binea
Binnui
Birsha
Birzavith
Bishlam
Biztha
Blastus
Boanerges
Boaz
Bocheru
Bohan
Booz
Bukki
Bukkiah
Bunah
Bunni
Buz
Buzi
Caesar
Caiaphas
Cain
Cainan
Calcol
Caleb
Canaan
Carcas
Careah
Carmi
Carpus
Carshena
Cephas
Chalcol
Chanaan
Chedorlaomer
Chelal
Chelluh
Chelub
Chelubai
Chenaanah
Chenani
Chenaniah
Cheran
Chesed
Chileab
Chilion
Chimham
Chislon
Chushan-Rishathaim
Chuza
Cis
Claudius
Clement
Cleopas
Cleophas
Clopas
Colhozeh
Conaniah
Cononiah
Core
Cornelius
Cosam
Coz
Crescens
Crispus
Cush
Cushi
Cyrenius
Cyrus
Dalaiah
Dalphon
Dan
Daniel
Dara
Darda
Darius
Darkon
Dathan
David
Debir
Dedan
Dekar
Delaiah
Demas
Demetrius
Deuel
Diblaim
Dibri
Didymus
Diklah
Dionysius
Diotrephes
Dishan
Dishon
Dodai
Dodanim
Dodavah
Dodo
Doeg
Dumah
Ebal
Ebed
Ebed-Melech
Eber
Ebiasaph
Edar
Eden
Eder
Edom
Eglon
Ehi
Ehud
Eker
Ela
Eladah
Elah
Elam
Elasah
Eldaah
Eldad
Elead
Eleasah
Eleazar
Elhanan
Eli
Eliab
Eliada
Eliadah
Eliah
Eliahba
Eliakim
Eliam
Elias
Eliasaph
Eliashib
Eliathah
Elidad
Eliel
Elienai
Eliezer
Elihoenai
Elihoreph
Elihu
Elijah
Elika
Elimelech
Elioenai
Eliphal
Eliphalet
Eliphaz
Elipheleh
Eliphelet
Eliseus
Elisha
Elishah
Elishama
Elishaphat
Elishua
Eliud
Elizaphan
Elizur
Elkanah
Elmadan
Elmodam
Elnaam
Elnathan
Elon
Elpaal
Elpalet
Eluzai
Elymas
Elzabad
Elzaphan
Emmor
Enan
Eneas
Enoch
Enos
Enosh
Epaenetus
Epaphras
Epaphroditus
Ephah
Ephai
Epher
Ephlal
Ephod
Ephraim
Ephron
Er
Eran
Erastus
Eri
Esaias
Esar-Haddon
Esau
Eshbaal
Eshban
Eshcol
Eshek
Eshtemoa
Eshtemoh
Eshton
Esli
Esrom
Esron
Etam
Ethan
Ethbaal
Ethnan
Ethni
Eubulus
Eutychus
Evi
Evil-Merodach
Ezar
Ezbai
Ezbon
Ezekias
Ezekiel
Ezer
Ezra
Ezrah
Ezri
Felix
Festus
Fortunatus
Gaal
Gabbai
Gad
Gaddi
Gaddiel
Gadi
Gaham
Gahar
Gaius
Galal
Gallio
Gamaliel
Gamul
Gareb
Gashmu
Gatam
Gazez
Gazzam
Geber
Gedaliah
Gedeon
Gedor
Gehazi
Gemalli
Gemariah
Genubath
Gera
Gershom
Gesham
Geshan
Geshem
Gether
Geuel
Gibbar
Gibea
Giddalti
Giddel
Gideon
Gideoni
Gilalai
Gilead
Ginath
Ginnetho
Ginnethon
Gishpa
Gispa
Gog
Goliath
Gomer
Guni
Haahashtari
Habaiah
Habakkuk
Habaziniah
Habazziniah
Hachaliah
Hachmoni
Hadad
Hadadezer
Hadarezer
Hadlai
Hadoram
Hagab
Hagaba
Hagabah
Haggai
Haggeri
Haggi
Haggiah
Hakkatan
Hakkoz
Hakupha
Hallohesh
Halohesh
Ham
Haman
Hammath
Hammedatha
Hammelech
Hammuel
Hamor
Hamuel
Hamul
Hanameel
Hanamel
Hanan
Hananeel
Hanani
Hananiah
Haniel
Hanniel
Hanoch
Hanun
Happizzez
Haran
Harbona
Harbonah
Hareph
Harhaiah
Harhas
Harhur
Harim
Hariph
Harnepher
Haroeh
Harum
Harumaph
Haruz
Hasadiah
Hasenuah
Hashabiah
Hashabnah
Hashabniah
Hashbadana
Hashbaddna
Hashem
Hashub
Hashubah
Hashum
Hashupha
Hasrah
Hassenaah
Hasshub
Hasupha
Hatach
Hathach
Hathath
Hatipha
Hatita
Hattil
Hattush
Havilah
Hazael
Hazaiah
Hazarmaveth
Haziel
Hazo
Heber
Hebron
Hegai
Hege
Heldai
Heleb
Heled
Helek
Helem
Helez
Heli
Helkai
Helon
Hemam
Hemath
Hemdan
Hen
Henadad
Henoch
Hepher
Heresh
Hermas
Hermes
Hermogenes
Herod
Herodion
Hesed
Heth
Hezeki
Hezekiah
Hezion
Hezir
Hezrai
Hezro
Hezron
Hiddai
Hiel
Hilkiah
Hillel
Hinnom
Hirah
Hiram
Hizkiah
Hizkijah
Hobab
Hobiah
Hod
Hodaiah
Hodaviah
Hodevah
Hodiah
Hodijah
Hoham
Homam
Hophni
Horam
Hori
Hosah
Hosea
Hoshaiah
Hoshama
Hoshea
Hotham
Hothan
Hothir
Hozai
Hul
Hupham
Huppah
Hur
Hurai
Huram
Huri
Hushah
Hushai
Husham
Hushim
Huz
Hymenaeus
Ibhar
Ibneiah
Ibnijah
Ibri
Ibsam
Ibzan
Ichabod
Idbash
Iddo
Igal
Igdaliah
Igeal
Ikkesh
Ilai
Imla
Imlah
Immer
Imna
Imnah
Imrah
Imri
Iphedeiah
Ir
Ira
Irad
Iram
Iri
Irijah
Irnahash
Iru
Isaac
Isaiah
Iscariot
Ishbah
Ishbak
Ishbi-Benob
Ishbosheth
Ishi
Ishiah
Ishijah
Ishma
Ishmael
Ishmaiah
Ishmerai
Ishod
Ishpah
Ishpan
Ishuah
Ishuai
Ishui
Ishvi
Isliah
Ismachiah
Ismaiah
Ispah
Israel
Issachar
Isshiah
Isuah
Isui
Ithai
Ithamar
Ithiel
Ithmah
Ithra
Ithran
Ithream
Ittai
Izehar
Izhar
Izrahiah
Izri
Izziah
Jaakan
Jaakobah
Jaala
Jaalah
Jaalam
Jaanai
Jaare-Oregim
Jaareshiah
Jaasau
Jaasiel
Jaasu
Jaazaniah
Jaazeniah
Jaaziah
Jaaziel
Jabal
Jabesh
Jabez
Jabin
Jacan
Jachan
Jachin
Jacob
Jada
Jadau
Jaddua
Jadon
Jahath
Jahaziah
Jahaziel
Jahdai
Jahdiel
Jahdo
Jahleel
Jahmai
Jahzeel
Jahzeiah
Jahzerah
Jahziel
Jair
Jairus
Jakan
Jakeh
Jakim
Jalam
Jalon
Jambres
James
Jamin
Jamlech
Janai
Janna
Jannai
Jannes
Japheth
Japhia
Japhlet
Jarah
Jareb
Jared
Jaresiah
Jarha
Jarib
Jaroah
Jashen
Jashobeam
Jashub
Jashubi-Lehem
Jasiel
Jason
Jassai
Jathniel
Javan
Jaziz
Jeaterai
Jeberechiah
Jecamiah
Jechoniah
Jechonias
Jeconiah
Jedaiah
Jediael
Jedidiah
Jeduthun
Jeezer
Jehaleleel
Jehalelel
Jehdeiah
Jehezekel
Jehiah
Jehiel
Jehieli
Jehizkiah
Jehoadah
Jehoaddah
Jehoahaz
Jehoash
Jehohanan
Jehoiachin
Jehoiada
Jehoiakim
Jehoiarib
Jehonadab
Jehonathan
Jehoram
Jehoshaphat
Jehoshua
Jehoshuah
Jehozabad
Jehozadak
Jehu
Jehubbah
Jehucal
Jehudi
Jehush
Jeiel
Jekameam
Jekamiah
Jekuthiel
Jemuel
Jephthae
Jephthah
Jephunneh
Jerah
Jerahmeel
Jered
Jeremai
Jeremiah
Jeremias
Jeremoth
Jeremy
Jeriah
Jeribai
Jeriel
Jerijah
Jerimoth
Jeroboam
Jeroham
Jerubbaal
Jerubbesheth
Jesaiah
Jeshaiah
Jesharelah
Jeshebeab
Jesher
Jeshishai
Jeshohaiah
Jeshua
Jeshuah
Jesiah
Jesimiel
Jesse
Jesui
Jesus
Jether
Jetheth
Jethro
Jetur
Jeuel
Jeush
Jeuz
Jezaniah
Jezer
Jeziah
Jeziel
Jezliah
Jezoar
Jezrahiah
Jezreel
Jibsam
Jidlaph
Jimna
Jimnah
Joab
Joah
Joahaz
Joanan
Joanna
Joash
Joatham
Job
Jobab
Joda
Joed
Joel
Joelah
Joezer
Jogli
Joha
Johanan
John
Joiada
Joiakim
Joiarib
Jokim
Jokshan
Joktan
Jona
Jonadab
Jonah
Jonam
Jonan
Jonas
Jonathan
Jorah
Joram
Jorim
Jorkoam
Josabad
Josaphat
Jose
Josech
Josedech
Joseph
Joses
Joshah
Joshaphat
Joshaviah
Joshbekashah
Josheb-Bassebet
Josheb-Basshebeth
Joshua
Josiah
Josibiah
Josiphiah
Jotham
Jozabad
Jozacar
Jozachar
Jozadak
Jubal
Jucal
Juda
Judah
Judas
Jude
Julius
Junia
Junias
Jushab-Hesed
Justus
Kadmiel
Kallai
Kareah
Kedar
Kedemah
Keilah
Kelaiah
Kelita
Kemuel
Kenan
Kenaz
Kenez
Keros
Kirjath-Jearim
Kish
Kishi
Kittim
Kohath
Kolaiah
Korah
Kore
Koz
Kushaiah
Laadah
Laadan
Laban
Lael
Lahad
Lahmi
Laish
Lamech
Lapidoth
Lappidoth
Lazarus
Lebana
Lebanah
Lebbaeus
Lecah
Lehabim
Lemuel
Letushim
Leummim
Levi
Libni
Likhi
Linus
Lo-Ammi
Lot
Lotan
Lucas
Lucifer
Lucius
Lud
Ludim
Luke
Lysanias
Lysias
Maacah
Maachah
Maadai
Maadiah
Maai
Maasai
Maaseiah
Maasiai
Maath
Maaz
Maaziah
Machbanai
Machbannai
Machi
Machir
Machnadebai
Madai
Madian
Madmannah
Magbish
Magdiel
Magog
Magor-Missabib
Magpiash
Magus
Mahalah
Mahalaleel
Mahalalel
Mahali
Maharai
Mahath
Mahazioth
Maher-Shalal-Hashbaz
Mahlah
Mahli
Mahlon
Mahol
Mahseiah
Malachi
Malcam
Malcham
Malchi-Shua
Malchiah
Malchiel
Malchijah
Malchiram
Malchishua
Malchus
Maleleel
Malluch
Mamre
Manaen
Manahath
Manasseh
Manasses
Manoah
Maoch
Maon
Marcus
Mareshah
Mark
Marsena
Mash
Massa
Mathusala
Matri
Mattan
Mattaniah
Mattatah
Mattatha
Mattathah
Mattathias
Mattenai
Matthan
Matthew
Matthias
Mattithiah
Mebunnai
Medad
Medan
Mehetabeel
Mehetabel
Mehida
Mehir
Mehujael
Mehuman
Mehunim
Melatiah
Melchi
Melchi-Shua
Melchisedec
Melchishua
Melchizedek
Melea
Melech
Melicu
Melzar
Memucan
Menahem
Menan
Menna
Meonothai
Mephibosheth
Meraiah
Meraioth
Merari
Mered
Meremoth
Meres
Merib-Baal
Merodach-Baladan
Mesech
Mesha
Meshach
Meshech
Meshelemiah
Meshezabeel
Meshezabel
Meshillemith
Meshillemoth
Meshobab
Meshullam
Methusael
Methuselah
Methushael
Meunim
Mezahab
Miamin
Mibhar
Mibsam
Mibzar
Mica
Micah
Micaiah
Micha
Michael
Michah
Michaiah
Michri
Midian
Mijamin
Mikloth
Mikneiah
Milalai
Miniamin
Mirma
Mirmah
Mishael
Misham
Mishma
Mishmannah
Mispar
Mispereth
Mithredath
Mizpar
Mizraim
Mizzah
Mnason
Moab
Moadiah
Molid
Mordecai
Moses
Moza
Muppim
Mushi
Naam
Naaman
Naarai
Naashon
Naasson
Nabal
Naboth
Nachon
Nachor
Nadab
Naggai
Nagge
Naham
Nahamani
Naharai
Nahari
Nahash
Nahath
Nahbi
Nahor
Nahshon
Nahum
Naphish
Naphtali
Narcissus
Nathan
Nathan-Melech
Nathanael
Naum
Neariah
Nebai
Nebaioth
Nebajoth
Nebat
Nebo
Nebuchadnezzar
Nebuchadrezzar
Nebushasban
Nebushazban
Nebuzar-Adan
Necho
Neco
Nedabiah
Nehemiah
Nehum
Nekoda
Nemuel
Nepheg
Nephish
Nephthalim
Ner
Nereus
Nergal-Sharezer
Neri
Neriah
Nethaneel
Nethanel
Nethaniah
Neziah
Nicanor
Nicodemus
Nicolas
Nicolaus
Niger
Nimrod
Nimshi
Noadiah
Noah
Nobah
Nobai
Noe
Nogah
Nohan
Nun
Nymphas
Obadiah
Obal
Obed
Obed-Edom
Obil
Ocran
Oded
Og
Ohad
Ohel
Oholiab
Olympas
Omar
Omri
On
Onam
Onan
Onesimus
Onesiphorus
Ophir
Ophrah
Oreb
Oren
Ornan
Osee
Oshea
Othni
Othniel
Ozem
Ozias
Ozni
Paarai
Padon
Pagiel
Pahath-Moab
Palal
Pallu
Palti
Paltiel
Parmashta
Parmenas
Parnach
Parosh
Parshandatha
Paruah
Pasach
Paseah
Pashhur
Pashur
Pathrusim
Patrobas
Paul
Paulus
Pedahel
Pedahzur
Pedaiah
Pekah
Pekahiah
Pelaiah
Pelaliah
Pelatiah
Peleg
Pelet
Peleth
Peniel
Penuel
Peresh
Perez
Perida
Persis
Peter
Pethahiah
Pethuel
Peulethai
Peulthai
Phalec
Phallu
Phalti
Phaltiel
Phanuel
Pharaoh
Pharaoh-Hophra
Pharaoh-Necho or Nechoh
Phares
Pharez
Pharosh
Phaseah
Phichol
Philemon
Philetus
Philip
Philologus
Phinehas
Phlegon
Phurah
Phut
Phuvah
Phygellus
Phygelus
Pilate
Pildash
Pileha
Pilha
Piltai
Pinon
Piram
Pispah
Pithon
Pochereth
Poratha
Porcius
Poti-Phera
Poti-Pherah
Potiphar
Prochorus
Pua
Puah
Publius
Pudens
Pul
Put
Putiel
Pyrrhus
Quartus
Raama
Raamah
Raamiah
Rabmag
Rabsaris
Rabshakeh
Raddai
Ragau
Raguel
Raham
Rakem
Ram
Ramiah
Ramoth
Rapha
Raphah
Raphu
Reaia
Reaiah
Reba
Rechab
Reelaiah
Regem
Regem-Melech
Rehabiah
Rehob
Rehoboam
Rehoboth
Rehum
Rei
Rekem
Remaliah
Rephael
Rephah
Rephaiah
Resheph
Reu
Reuben
Reuel
Rezia
Rezin
Rezon
Rezzar
Rhesa
Ribai
Rimmon
Rinnah
Riphath
Roboam
Rohgah
Romamti-Ezer
Rosh
Rufus
Sabta
Sabtah
Sabtecha
Sabtechah
Sacar
Sadoc
Sala
Salah
Salathiel
Sallai
Salma
Salmah
Salmon
Salu
Samgar-Nebo
Samlah
Samson
Samuel
Sanballat
Saph
Saraph
Sargon
Sarsechim
Saruch
Saul
Sceva
Seba
Secundus
Segub
Seir
Seled
Sem
Semachiah
Semei
Senaah
Sennacherib
Senuah
Seorim
Seraiah
Sered
Sergius Paulus
Serug
Seth
Sethur
Shaaph
Shaashgaz
Shabbethai
Shachia
Shadrach
Shage
Shagee
Shaharaim
Shallum
Shallun
Shalmai
Shalman
Shalmaneser
Shama
Shamariah
Shamed
Shamer
Shamgar
Shamhuth
Shamir
Shamma
Shammah
Shammai
Shammoth
Shammua
Shammuah
Shamsherai
Shapham
Shaphan
Shaphat
Sharai
Sharar
Sharezer
Shashai
Shashak
Shaul
Shavsha
Sheal
Shealtiel
Shear-Jashub
Sheariah
Sheba
Shebaniah
Sheber
Shebna
Shebnah
Shebuel
Shechaniah
Shechem
Shedeur
Shehariah
Shelah
Shelemiah
Sheleph
Shelesh
Shelomi
Shelomith
Shelumiel
Shem
Shema
Shemaah
Shemaiah
Shemariah
Shemeber
Shemer
Shemida
Shemidah
Shemiramoth
Shemuel
Shenazar
Shephatiah
Shephi
Shepho
Shephupham
Shephuphan
Sherebiah
Sheresh
Sherezer
Sheshai
Sheshan
Sheshbazzar
Sheth
Shethar
Shethar-Boznai
Sheva
Shilhi
Shillem
Shiloni
Shilshah
Shimea
Shimeah
Shimeam
Shimei
Shimeon
Shimhi
Shimi
Shimma
Shimon
Shimrath
Shimri
Shimrom
Shimron
Shimshai
Shinab
Shiphi
Shiphtan
Shisha
Shishak
Shitrai
Shiza
Shobab
Shobach
Shobai
Shobal
Shobek
Shobi
Shocho
Shoco
Shoham
Shomer
Shophach
Shua
Shuah
Shual
Shubael
Shuham
Shuni
Shupham
Shuppim
Shuthelah
Sia
Siaha
Sibbecai
Sibbechai
Sichem
Sidon
Sihon
Silas
Silvanus
Simeon
Simon
Simri
Sippai
Sisamai
Sisera
Sismai
So
Socho
Sodi
Solomon
Sopater
Sophereth
Sosipater
Sosthenes
Sotai
Stachys
Stephanas
Stephen
Suah
Susi
Sychar
Sychem
Symeon
Tabbaoth
Tabeal
Tabeel
Tabrimmon
Tabrimon
Tahan
Tahath
Tahrea
Talmai
Talmon
Tamah
Tanhumeth
Tappuah
Tarah
Tarea
Tarshish
Tartan
Tatnai
Tebah
Tebaliah
Tehinnah
Tekoa
Tekoh
Telah
Telem
Tema
Temah
Teman
Temani
Temeni
Terah
Teresh
Tertius
Tertullus
Thaddaeus
Thahash
Thamah
Thara
Tharshish
Theophilus
Theudas
Thomas
Tiberius
Tibni
Tidal
Tiglath-Pileser
Tikvah
Tikvath
Tilgath-Pilneser
Tilon
Timaeus
Timna
Timnah
Timon
Timotheus
Timothy
Tiras
Tirhakah
Tirhanah
Tiria
Tirshatha
Titus
Toah
Tob-Adonijah
Tobiah
Tobijah
Togarmah
Tohu
Toi
Tola
Tou
Trophimus
Tubal
Tubal-Cain
Tychicus
Tyrannus
Ucal
Uel
Ulam
Ulla
Unni
Unno
Ur
Urbane
Urbanus
Uri
Uriah
Urias
Uriel
Urijah
Uthai
Uz
Uzai
Uzal
Uzza
Uzzah
Uzzi
Uzzia
Uzziah
Uzziel
Vaizatha
Vajezatha
Vaniah
Vashni
Vophsi
Zaavan
Zabad
Zabbai
Zabbud
Zabdi
Zabdiel
Zabud
Zabulon
Zaccai
Zacchaeus
Zacchur
Zaccur
Zachariah
Zacharias
Zacher
Zadok
Zaham
Zalaph
Zalmunna
Zanoah
Zaphnath-Paaneah
Zaphon
Zara
Zarah
Zatthu
Zattu
Zavan
Zaza
Zebadiah
Zebah
Zebedee
Zebina
Zebul
Zebulun
Zechariah
Zecher
Zedekiah
Zeeb
Zelek
Zelophehad
Zelotes
Zemira
Zemirah
Zenas
Zephaniah
Zephi
Zepho
Zephon
Zerah
Zerahiah
Zereth
Zeri
Zeror
Zerubbabel
Zetham
Zethan
Zethar
Zia
Ziba
Zibeon
Zibia
Zichri
Zidkijah
Zidon
Ziha
Zillethai
Zilthai
Zimmah
Zimran
Zimri
Zina
Ziph
Ziphah
Ziphion
Zippor
Zithri
Ziza
Zizah
Zohar
Zoheth
Zophah
Zophai
Zophar
Zorobabel
Zuar
Zuph
Zur
Zuriel
Zurishaddai
mallothi
zalmon
