package Sah::SchemaR::cryptocurrency;

our $DATE = '2020-03-04'; # DATE
our $VERSION = '0.014'; # VERSION

our $rschema = ["str",[{description=>"\nCryptocurrency code or name or safename that is listed in\n<pm:CryptoCurrency::Catalog>, e.g. BTC, \"Bitcoin Cash\", ethereum-classic.\n\nCode/name/safename must be listed.\n\nWill be normalized to code in uppercase.\n\n",examples=>[{valid=>0,value=>""},{valid=>1,validated_value=>"BTC",value=>"btc"},{valid=>1,validated_value=>"BTC",value=>"bitcoin"},{valid=>1,validated_value=>"BCH",value=>"bitCOIN caSh"},{valid=>0,value=>"notbtc"}],summary=>"Cryptocurrency code, name, or safename","x.completion"=>"cryptocurrency","x.perl.coerce_rules"=>["From_str::to_cryptocurrency_code"]}],["str"]];

1;
# ABSTRACT: Cryptocurrency code, name, or safename

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::cryptocurrency - Cryptocurrency code, name, or safename

=head1 VERSION

This document describes version 0.014 of Sah::SchemaR::cryptocurrency (from Perl distribution Sah-Schemas-CryptoCurrency), released on 2020-03-04.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-CryptoCurrency>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-CryptoCurrency>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-CryptoCurrency>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020, 2019, 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
