package Sah::SchemaR::perl::arraydata::modnames;

our $DATE = '2021-06-17'; # DATE
our $VERSION = '0.001'; # VERSION

our $rschema = ["array",[{description=>"\nArray of Perl ArrayData::* module names, where each element is of\n`perl::arraydata::modname` schema, e.g. `Word::ID::KBBI`,\n`Number::Prime::First1000`.\n\nContains coercion rule that expands wildcard, so you can specify:\n\n    Word::ID::*\n\nand it will be expanded to e.g.:\n\n    [\"Word::ID::KBBI\", \"Word::ID::PERLANCAR\"]\n\nThe wildcard syntax supports jokers (`?`, `*`, `**`), brackets (`[abc]`), and\nbraces (`{one,two}`). See <pm:Module::List::Wildcard> for more details.\n\n",of=>["perl::arraydata::modname",{req=>1},{}],summary=>"Array of Perl ArrayData::* module names without the prefix, e.g. [\"Word::ID::KBBI\", \"Number::Prime::First1000\"]","x.element_completion"=>["perl_modname",{ns_prefix=>"ArrayData"}],"x.perl.coerce_rules"=>[["From_str_or_array::expand_perl_modname_wildcard",{ns_prefix=>"ArrayData"}]]}],["array"]];

1;
# ABSTRACT: Array of Perl ArrayData::* module names without the prefix, e.g. ["Word::ID::KBBI", "Number::Prime::First1000"]

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::perl::arraydata::modnames - Array of Perl ArrayData::* module names without the prefix, e.g. ["Word::ID::KBBI", "Number::Prime::First1000"]

=head1 VERSION

This document describes version 0.001 of Sah::SchemaR::perl::arraydata::modnames (from Perl distribution Sah-Schemas-ArrayData), released on 2021-06-17.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-ArrayData>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-ArrayData>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-ArrayData>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
